import { EventEmitter } from "../../stencil-public-runtime";
import { IcActivationTypes, IcStatusVariants } from "../../utils/types";
/**
 * @slot action - IcButton or IcLink is placed below header and message. If used will default toast to manual `dismiss` type.
 * @slot neutral-icon - A custom neutral icon is placed on the left side of the component. If used will default toast to `neutral` variant.
 */
export declare class Toast {
    private dismissTimeout;
    private interactiveElements;
    private isManual;
    private neutralVariantLabel;
    private timerRefreshInterval;
    el: HTMLIcToastElement;
    timerProgress: number;
    visible: boolean;
    /**
     * If toast dismissMode is set to `automatic`, use this prop to define the time before the toast dismisses (in MILLISECONDS)
     * (NOTE: Has a minimum value of `5000ms`)
     */
    autoDismissTimeout?: number;
    /**
     * If toast can be manually dismissed, this prop sets a custom aria-label for the ic-button component
     */
    dismissButtonAriaLabel?: string;
    /**
     * How the toast will be dismissed. If manual will display a dismiss button.
     */
    dismissMode?: IcActivationTypes;
    dismissModeChangeHandler(newValue: IcActivationTypes): void;
    /**
     * The title to display at the start of the toast. (NOTE: Should be no more than `70` characters)
     */
    heading: string;
    /**
     * The main body message of the toast. (NOTE: Should be no more than `140` characters)
     */
    message?: string;
    /**
     * Provides a custom alt-text to be announced to screen readers, if slotting a custom neutral icon
     */
    neutralIconAriaLabel?: string;
    /**
     * The variant of the toast being rendered
     */
    variant?: IcStatusVariants;
    /**
     * Is emitted when the user dismisses the toast
     */
    icDismiss: EventEmitter<void>;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    handleDismiss(): void;
    handleKeyboard(ev: KeyboardEvent): void;
    handleTimer(ev: MouseEvent): void;
    /**
     * @internal Used to display the individual toast.
     * @returns The element that previously had focus before the toast appeared
     */
    setVisible(): Promise<HTMLElement>;
    private dismissAction;
    private handleProgressChange;
    private handleLongText;
    private findNextInteractiveElement;
    private isActive;
    render(): any;
}
