import { EventEmitter } from "../../stencil-public-runtime";
import { IcSizes, IcThemeForeground, IcSelectTypes, IcSelectMethodTypes } from "../../utils/types";
import { IcChangeEventDetail } from "./ic-toggle-button-group.types";
interface lastKey {
    key: string | null;
    shift: boolean;
}
export declare class ToggleButtonGroup {
    el: HTMLIcToggleButtonGroupElement;
    lastKeyPressed: lastKey;
    /**
     * The accessible label of the toggle button group component to provide context for screen reader users.
     */
    accessibleLabel?: string;
    /**
     * The appearance of the toggle button group, e.g dark, or light.
     */
    appearance: IcThemeForeground;
    /**
     * If `true`, the toggle button group will be set to the disabled state.
     */
    disabled: boolean;
    /**
     * If `true`, the toggle button group will fill the width of the container.
     */
    fullWidth?: boolean;
    /**
     * The placement of the icons in relation to the toggle button labels.
     */
    iconPlacement?: "left" | "right" | "top";
    /**
     * If `true`, the toggle button group will be in loading state.
     */
    loading?: boolean;
    /**
     * If `auto`, controls are toggled automatically when navigated to. If `manual`, the controls must be actioned to change their toggled state. The value of this prop is ignored if `selectType` is set to`multi`.
     */
    selectMethod?: IcSelectMethodTypes;
    /**
     * Sets whether single or multiple options can be toggled. If `multi`, then the `selectMethod` is always `manual`.
     */
    selectType?: IcSelectTypes;
    /**
     * The size of the toggle buttons to be displayed. This does not affect the font size of the accessible label.
     */
    size?: IcSizes;
    /**
     * The variant of the toggle button.
     */
    variant: "default" | "icon";
    /**
     * Emitted when a toggle button is selected.
     */
    icChange: EventEmitter<IcChangeEventDetail>;
    selectHandler(ev: CustomEvent, tabTarget?: HTMLIcToggleButtonElement): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    disconnectedCallback(): void;
    private keyListener;
    private setSlottedAria;
    private handleHostFocus;
    private proxySelectHandler;
    private handleKeyDown;
    private getNextItemToSelect;
    private getAllToggleButtons;
    render(): any;
}
export {};
