import { EventEmitter } from "../../stencil-public-runtime";
import { IcSizes, IcThemeForeground } from "../../utils/types";
/**
 * @slot icon - Content will be displayed alongside the toggle button label.
 * @slot badge - Badge component overlaying the top right of the toggle button.
 */
export declare class ToggleButton {
    private iconPosition;
    el: HTMLIcToggleButtonElement;
    /**
     * The accessible label that will be applied to the toggle button. This is required for the icon variant of toggle buttons.
     */
    accessibleLabel?: string;
    /**
     * The appearance of the toggle button.
     */
    appearance?: IcThemeForeground;
    /**
     * If `true`, the toggle button will be in disabled state.
     */
    disabled?: boolean;
    /**
     * If `true`, the toggle button will fill the width of the container.
     */
    fullWidth?: boolean;
    /**
     * The placement of the icon in relation to the toggle button label.
     */
    iconPlacement?: "left" | "right" | "top";
    /**
     * The label to display in the toggle button. This is required for the default variant of toggle buttons.
     */
    label?: string;
    /**
     * If `true`, the toggle button will be in loading state.
     */
    loading?: boolean;
    /**
     * The size of the toggle button to be displayed.
     */
    size?: IcSizes;
    /**
     * If `true`, the toggle button will be in a checked state.
     */
    toggleChecked: boolean;
    /**
     * The variant of the toggle button.
     */
    variant: "default" | "icon";
    /**
     * Emitted when the user clicks a toggle button.
     */
    icToggleChecked: EventEmitter<{
        checked: boolean;
    }>;
    componentWillLoad(): void;
    componentDidLoad(): void;
    handleHostClick(e: Event): void;
    private handleFocus;
    private handleClick;
    render(): any;
}
