import { Options } from "@popperjs/core";
import { IcTooltipPlacements } from "./ic-tooltip.types";
export declare class Tooltip {
    private arrow;
    private delayedHideEvents;
    private dialogOverflow;
    private icDialogEl;
    private instantHideEvents;
    private mouseOverTool;
    private persistTooltip;
    private popperInstance;
    private onDialog;
    private showEvents;
    private toolTip;
    el: HTMLIcTooltipElement;
    /**
     * @internal If `true`, the tooltip will not be displayed on click, it will require hover or using the display method.
     */
    disableClick?: boolean;
    /**
     * If `true`, the tooltip will not be displayed on hover, it will require a click.
     */
    disableHover?: boolean;
    /**
     * The number of lines to display before truncating the text.
     */
    maxLines?: number;
    /**
     * The position of the tooltip in relation to the parent element.
     */
    placement?: IcTooltipPlacements;
    /**
     * @internal Sets the tooltip to aria-hidden, when used as part of components that are already announced.
     */
    silent?: boolean;
    /**
     * The ID of the element the tooltip is describing - for when aria-labelledby or aria-describedby is used.
     */
    target?: string;
    /**
     * The text to display on the tooltip.
     */
    label: string;
    popperProps: Partial<Options>;
    /**
     * @internal This method allows props to be added to the PopperJS createPopper instance outside of tooltip
     * @param props object - createPopper props set externally
     */
    setExternalPopperProps<T extends Partial<Options>>(props: T): Promise<void>;
    disconnectedCallback(): void;
    componentDidLoad(): void;
    componentDidRender(): void;
    /**
     * Method to programmatically show/hide the tooltip without needing to interact with an anchor element
     * @param show Whether to show or hide the tooltip
     * @param persistTooltip Whether the tooltip should stay on the screen when actions are performed that would previously dismiss the tooltip, such as on hover
     */
    displayTooltip(show: boolean, persistTooltip?: boolean): Promise<void>;
    /**
     * @internal Method to return if tooltip is currently visible.
     */
    isTooltipVisible(): Promise<boolean>;
    private getTooltipTranslate;
    private show;
    private hide;
    private checkCloseTooltip;
    private mouseEnterTooltip;
    private mouseLeaveTooltip;
    private handleKeyDown;
    private manageEventListeners;
    render(): any;
}
