import { EventEmitter } from "../../stencil-public-runtime";
import { IcAlignment, IcThemeForeground, IcTheme, IcDeviceSizes, IcValueEventDetail } from "../../utils/types";
import { IcSearchBarBlurEventDetail } from "../ic-search-bar/ic-search-bar.types";
/**
 * @slot app-icon - Content will be rendered to left of app title. Anything that is slotted here will be hidden from screen readers.
 * @slot app-title - Handle routing by nesting a route in the app title.
 * @slot short-app-title - Handle routing by nesting a route in the short app title (to be displayed in place of app title on small screen sizes).
 * @slot search - Content will be rendered in search area to left of buttons.
 * @slot toggle-icon - Icon to be displayed on the button to toggle search slot content on smaller devices
 * @slot navigation - Content will be rendered in navigation panel.
 * @slot buttons - Content will be rendered to right of search bar.
 */
export declare class TopNavigation {
    private hasAppIcon;
    private hasIconButtons;
    private hasNavigation;
    private hasSearchSlotContent;
    private mobileSearchButtonEl;
    private resizeObserver;
    private searchBar;
    el: HTMLIcTopNavigationElement;
    deviceSize: number;
    foregroundColor: IcThemeForeground;
    hasFullWidthSearchBar: boolean;
    mobileSearchBarVisible: boolean;
    mobileSearchHiddenOnBlur: boolean;
    navMenuVisible: boolean;
    searchButtonClick: boolean;
    searchValue: string;
    /**
     * The alignment of the top navigation content.
     */
    contentAligned: IcAlignment;
    /**
     * Can set a custom breakpoint for the top navigation to switch to mobile mode.
     * Must be one of our specified breakpoints in px: `0`, `576`, `768`, `992`, `1200`.
     */
    customMobileBreakpoint: IcDeviceSizes;
    /**
     *  The URL to navigate to when the app title is clicked.
     */
    href: string;
    /**
     * If `true`, the flyout navigation menu on small devices will be contained by the parent element.
     */
    inline: boolean;
    /**
     * The short title of the app to be displayed at small screen sizes in place of the app title.
     */
    shortAppTitle: string;
    /**
     * The status info to be displayed.
     */
    status: string;
    /**
     * The version info to be displayed.
     */
    version: string;
    /**
     * The app title to be displayed. This is required, unless a slotted app title link is used.
     */
    appTitle: string;
    watchPropHandler(newValue: string, oldValue: string): void;
    /**
     * @internal - Emitted when the menu is closed.
     */
    icNavigationMenuClosed: EventEmitter<void>;
    /**
     * @internal - Emitted when the menu is opened.
     */
    icNavigationMenuOpened: EventEmitter<void>;
    /**
     * Emitted when the top navigation is resized.
     */
    topNavResized: EventEmitter<{
        size: number;
    }>;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    componentWillRender(): void;
    navBarMenuCloseHandler(): void;
    searchInputBlurHandler({ detail, }: CustomEvent<IcSearchBarBlurEventDetail>): void;
    searchValueChangeHandler({ detail }: CustomEvent<IcValueEventDetail>): void;
    themeChangeHandler({ detail }: CustomEvent<IcTheme>): void;
    private checkSlots;
    private initialiseSearchBar;
    private toggleSearchBar;
    private menuButtonClick;
    private showNavMenu;
    private searchButtonMouseDownHandler;
    private searchButtonClickHandler;
    private resizeObserverCallback;
    private runResizeObserver;
    render(): any;
}
