import { EventEmitter } from "../../stencil-public-runtime";
import { IcTypographyVariants } from "../../utils/types";
export declare class Typography {
    private focusBtnFromKeyboard;
    private inAGGrid;
    private lastMarkerTop;
    private lastWidth;
    private marker;
    private resizeInterval;
    private resizeObserver;
    private truncatedHeight;
    private truncWrapperEl;
    el: HTMLIcTypographyElement;
    truncated: boolean;
    truncButtonFocussed: boolean;
    /**
     * If `true`, appropriate top and bottom margins will be applied to the typography.
     */
    applyVerticalMargins?: boolean;
    /**
     * If `true`, the typography will have a bold font weight.
     * Note: This will have no impact on variants that already use an equivalent or higher font weight (h1, h2, and subtitle-large).
     */
    bold?: boolean;
    /**
     * If `true`, the typography will have an italic font style.
     */
    italic?: boolean;
    /**
     * The number of lines to display before truncating the text, only used for the 'body' variant.
     */
    maxLines?: number;
    /**
     * If `true`, the typography will have a line through it.
     */
    strikethrough?: boolean;
    /**
     * If `true`, the typography will have a line under it.
     */
    underline?: boolean;
    /**
     * The ICDS typography style to use.
     */
    variant?: IcTypographyVariants;
    /**
     * @internal Emits and event when the typography truncation button has been clicked.
     */
    typographyTruncationExpandToggle: EventEmitter<{
        expanded: boolean;
        typographyEl: HTMLIcTypographyElement;
    }>;
    expanded: boolean;
    watchExpandedHandler(): void;
    disconnectedCallback(): void;
    /**
     * @internal This is used by data table to remove all truncation in certain events
     */
    resetTruncation(): Promise<void>;
    componentDidLoad(): void;
    componentWillRender(): void;
    private toggleExpanded;
    /**
     * @internal This checks if the number of lines of text exceeds the maxLines prop. If so, set the line clamp CSS to the max lines
     * @param height - text container height
     */
    checkMaxLines(height: number): Promise<void>;
    /**
     * @internal This method makes it possible to set the expanded status of truncated text outside of ic-typography component
     */
    setShowHideExpanded(expanded: boolean): Promise<void>;
    private checkMarkerPosition;
    private getElementTop;
    private runResizeObserver;
    private resizeObserverCallback;
    private truncButtonFocus;
    private truncButtonBlur;
    private truncButtonFocusFromMouse;
    render(): any;
}
