import { EventEmitter } from "../stencil-public-runtime";
import { IcCallbackFunctionNoReturn, IcInformationStatusOrEmpty, IcNavParentDetails, IcPropObject, IcSearchMatchPositions, IcColorRGBA, IcDeviceSizes, IcColor } from "./types";
import { IcMenuOption, IcThemeForeground } from "../utils/types";
/**
 * converts an enum of strings into an array of strings
 */
export declare const stringEnumToArray: (theEnum: Record<string, string | number>) => string[];
/**
 * Used to inherit global attributes set on the host. Called in componentWillLoad and assigned
 * to a variable that is later used in the render function.
 *
 * This does not need to be reactive as changing attributes on the host element
 * does not trigger a re-render.
 */
export declare const inheritAttributes: (element: HTMLElement, attributes?: string[]) => {
    [key: string]: string;
};
export declare const debounceEvent: (event: EventEmitter, wait: number) => EventEmitter;
export declare const debounce: (func: (...args: unknown[]) => void, wait?: number) => unknown;
/**
 * This method is used to add a hidden input to a host element that contains
 * a Shadow DOM. It does not add the input inside of the Shadow root which
 * allows it to be picked up inside of forms. It should contain the same
 * values as the host element.
 *
 * @param always Add a hidden input even if the container does not use Shadow
 * @param container The element where the input will be added
 * @param name The name of the input
 * @param value The value of the input
 * @param disabled If true, the input is disabled
 */
export declare const renderHiddenInput: (always: boolean, container: HTMLElement, name: string, value: string | Date | undefined | null, disabled: boolean) => void;
/**
 * This method is used to add a hidden file input to a host element that contains
 * a Shadow DOM. It does not add the input inside of the Shadow root which
 * allows it to be picked up inside of forms. It should contain the same
 * values as the host element.
 *
 * @param event: The event that is emitted once a file is selected.
 * @param container The element where the input will be added
 * @param multiple If true, multiple files can be selected
 * @param name The name of the input
 * @param value The value of the input
 * @param disabled If true, the input is disabled
 * @param accept A string of the accepted files
 */
export declare const renderFileHiddenInput: (event: EventEmitter, container: HTMLElement, multiple: boolean, name: string, value: FileList | undefined | null, disabled: boolean, accept: string) => void;
export declare const removeHiddenInput: (container: HTMLElement) => void;
export declare const hasShadowDom: (el: HTMLElement) => boolean;
export declare const getInputHelperTextID: (id: string) => string;
export declare const getInputValidationTextID: (id: string) => string;
export declare const getInputDescribedByText: (inputId: string, helperText: boolean, validationText: boolean) => string;
/**
 * This method helps to understand the context in which a component exists,
 * to assist with choosing appropriate foreground colours to use. For example,
 * this method will help you use the 'white' version of a button if it's within
 * a block colour element using white foreground text.
 *
 * This only works for components/elements passed via <slot> and not if they
 * are part of an IC component.
 *
 * ""
 * @returns IcThemeForeground depending on the context
 */
export declare const getThemeFromContext: (el: Element, themeFromEvent?: IcThemeForeground) => IcThemeForeground;
/**
 * Checks if the current device is a mobile or tablet device.
 * @returns {boolean} Returns true if the device is a mobile or tablet device, otherwise returns false.
 */
export declare const isMobileOrTablet: () => boolean;
/**
 * Will create a button within the lightDOM which interacts with the parent form.
 * This is required as buttons within the shadowDOM will not invoke a submit or reset
 *
 * @param form - parent form element which contains shadowDom button
 * @param button - shadowDOM button
 */
export declare const handleHiddenFormButtonClick: (form: HTMLFormElement, button: HTMLIcButtonElement | HTMLButtonElement) => void;
export declare const isEmptyString: (value: string) => boolean;
export declare const isPropDefined: (prop: string) => string | null;
/**
 * Extracts the label using the value from an object. Requires the object to have a label and value property.
 * @param value - value from object
 * @param options - list of menu items
 * @returns - label corresponding to value
 */
export declare const getLabelFromValue: (value: string, options: IcMenuOption[], valueField?: string, labelField?: string) => string | undefined;
/**
 * Filters the options based on the search string.
 * @param options - array of options
 * @param includeDescriptions - determines whether option descriptions are included when filtering options
 * @param searchString - string used to filter the options
 * @param position - whether the search string matches the start of or anywhere in the options
 * @returns filtered array of options
 */
export declare const getFilteredMenuOptions: (options: IcMenuOption[], includeDescriptions: boolean, searchString: string, position: IcSearchMatchPositions, labelField?: string) => IcMenuOption[];
export declare const deviceSizeMatches: (size: number) => boolean;
export declare const getCurrentDeviceSize: () => number;
export declare const getCssProperty: (cssVar: string) => string;
/**
 * Returns the brightness of the theme colour, calculated by using the theme RGB CSS values by:
 * - Multiplying each RGB value by a set number: https://www.w3.org/TR/AERT/#color-contrast
 * - Adding them together and dividing by 1000
 * This is a similar calculation to its CSS counterpart: "--ic-theme-text"
 * @returns number representing the brightness of the theme colour
 */
export declare const getThemeColorBrightness: () => number;
/**
 * Returns if dark or light foreground colors should be used for color contrast reasons
 * @returns "dark" or "light"
 * @param brightness - Optional custom brightness value. Defaults to `getThemeColorBrightness`
 */
export declare const getThemeForegroundColor: (brightness?: number) => IcThemeForeground;
export declare const getSlot: (element: HTMLElement, name: string) => Element | null;
export declare const slotHasContent: (element: HTMLElement, name: string) => boolean;
export declare const getSlotContent: (element: HTMLElement, name: string) => Element[] | NodeListOf<ChildNode> | null;
export declare const getSlotElements: (slot: Element) => NodeListOf<ChildNode> | Element[];
export declare const getNavItemParentDetails: ({ parentElement, }: HTMLElement) => IcNavParentDetails;
export declare const DEVICE_SIZES: {
    XS: IcDeviceSizes;
    S: IcDeviceSizes;
    M: IcDeviceSizes;
    L: IcDeviceSizes;
    XL: IcDeviceSizes;
    UNDEFINED: number;
};
export declare const hasValidationStatus: (status: IcInformationStatusOrEmpty, disabled: boolean) => boolean;
export declare const isSlotUsed: ({ children }: HTMLElement, slotName: string) => boolean;
export declare const onComponentPropUndefinedChange: (oldValue: string | undefined, newValue: string | undefined, callback: IcCallbackFunctionNoReturn) => void;
export declare const onComponentRequiredPropUndefined: (props: IcPropObject[], component: string) => void;
export declare const kebabToCamelCase: (kebabCase: string) => string;
export declare const checkResizeObserver: (callbackFn: IcCallbackFunctionNoReturn) => void;
export declare const hexToRgba: (hex: string) => IcColorRGBA;
export declare const rgbaStrToObj: (rgbaStr: string) => IcColorRGBA;
export declare const elementOverflowsX: ({ scrollWidth, clientWidth, }: HTMLElement) => boolean;
export declare const hasClassificationBanner: () => boolean;
export declare const addFormResetListener: (el: HTMLElement, callbackFn: IcCallbackFunctionNoReturn) => void;
export declare const removeFormResetListener: (el: HTMLElement, callbackFn: IcCallbackFunctionNoReturn) => void;
export declare const pxToRem: (px: string, base?: number) => string;
export declare const removeDisabledFalse: (disabled: boolean, element: HTMLElement) => void;
export declare const isMacDevice: () => boolean;
export declare const isNumeric: (value: string) => boolean;
export declare function waitForHydration(): Promise<boolean>;
export declare const convertToRGBA: (color: IcColor) => IcColorRGBA | null;
export declare const capitalize: (text: string) => string;
export declare const checkSlotInChildMutations: (addedNodes: NodeList, removedNodes: NodeList, slotName: string | string[]) => boolean;
export declare const isElInAGGrid: (el: HTMLElement) => boolean;
