'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/*!
 Stencil Mock Doc v4.10.0 | MIT Licensed | https://stenciljs.com
 */
const CONTENT_REF_ID = 'r';
const ORG_LOCATION_ID = 'o';
const SLOT_NODE_ID = 's';
const TEXT_NODE_ID = 't';
const XLINK_NS = 'http://www.w3.org/1999/xlink';

const attrHandler = {
    get(obj, prop) {
        if (prop in obj) {
            return obj[prop];
        }
        if (typeof prop !== 'symbol' && !isNaN(prop)) {
            return obj.__items[prop];
        }
        return undefined;
    },
};
const createAttributeProxy = (caseInsensitive) => new Proxy(new MockAttributeMap(caseInsensitive), attrHandler);
class MockAttributeMap {
    constructor(caseInsensitive = false) {
        this.caseInsensitive = caseInsensitive;
        this.__items = [];
    }
    get length() {
        return this.__items.length;
    }
    item(index) {
        return this.__items[index] || null;
    }
    setNamedItem(attr) {
        attr.namespaceURI = null;
        this.setNamedItemNS(attr);
    }
    setNamedItemNS(attr) {
        if (attr != null && attr.value != null) {
            attr.value = String(attr.value);
        }
        const existingAttr = this.__items.find((a) => a.name === attr.name && a.namespaceURI === attr.namespaceURI);
        if (existingAttr != null) {
            existingAttr.value = attr.value;
        }
        else {
            this.__items.push(attr);
        }
    }
    getNamedItem(attrName) {
        if (this.caseInsensitive) {
            attrName = attrName.toLowerCase();
        }
        return this.getNamedItemNS(null, attrName);
    }
    getNamedItemNS(namespaceURI, attrName) {
        namespaceURI = getNamespaceURI(namespaceURI);
        return (this.__items.find((attr) => attr.name === attrName && getNamespaceURI(attr.namespaceURI) === namespaceURI) || null);
    }
    removeNamedItem(attr) {
        this.removeNamedItemNS(attr);
    }
    removeNamedItemNS(attr) {
        for (let i = 0, ii = this.__items.length; i < ii; i++) {
            if (this.__items[i].name === attr.name && this.__items[i].namespaceURI === attr.namespaceURI) {
                this.__items.splice(i, 1);
                break;
            }
        }
    }
    [Symbol.iterator]() {
        let i = 0;
        return {
            next: () => ({
                done: i === this.length,
                value: this.item(i++),
            }),
        };
    }
    get [Symbol.toStringTag]() {
        return 'MockAttributeMap';
    }
}
function getNamespaceURI(namespaceURI) {
    return namespaceURI === XLINK_NS ? null : namespaceURI;
}
function cloneAttributes(srcAttrs, sortByName = false) {
    const dstAttrs = new MockAttributeMap(srcAttrs.caseInsensitive);
    if (srcAttrs != null) {
        const attrLen = srcAttrs.length;
        if (sortByName && attrLen > 1) {
            const sortedAttrs = [];
            for (let i = 0; i < attrLen; i++) {
                const srcAttr = srcAttrs.item(i);
                const dstAttr = new MockAttr(srcAttr.name, srcAttr.value, srcAttr.namespaceURI);
                sortedAttrs.push(dstAttr);
            }
            sortedAttrs.sort(sortAttributes).forEach((attr) => {
                dstAttrs.setNamedItemNS(attr);
            });
        }
        else {
            for (let i = 0; i < attrLen; i++) {
                const srcAttr = srcAttrs.item(i);
                const dstAttr = new MockAttr(srcAttr.name, srcAttr.value, srcAttr.namespaceURI);
                dstAttrs.setNamedItemNS(dstAttr);
            }
        }
    }
    return dstAttrs;
}
function sortAttributes(a, b) {
    if (a.name < b.name)
        return -1;
    if (a.name > b.name)
        return 1;
    return 0;
}
class MockAttr {
    constructor(attrName, attrValue, namespaceURI = null) {
        this._name = attrName;
        this._value = String(attrValue);
        this._namespaceURI = namespaceURI;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get value() {
        return this._value;
    }
    set value(value) {
        this._value = String(value);
    }
    get nodeName() {
        return this._name;
    }
    set nodeName(value) {
        this._name = value;
    }
    get nodeValue() {
        return this._value;
    }
    set nodeValue(value) {
        this._value = String(value);
    }
    get namespaceURI() {
        return this._namespaceURI;
    }
    set namespaceURI(namespaceURI) {
        this._namespaceURI = namespaceURI;
    }
}

class MockClassList {
    constructor(elm) {
        this.elm = elm;
    }
    add(...classNames) {
        const clsNames = getItems(this.elm);
        let updated = false;
        classNames.forEach((className) => {
            className = String(className);
            validateClass(className);
            if (clsNames.includes(className) === false) {
                clsNames.push(className);
                updated = true;
            }
        });
        if (updated) {
            this.elm.setAttributeNS(null, 'class', clsNames.join(' '));
        }
    }
    remove(...classNames) {
        const clsNames = getItems(this.elm);
        let updated = false;
        classNames.forEach((className) => {
            className = String(className);
            validateClass(className);
            const index = clsNames.indexOf(className);
            if (index > -1) {
                clsNames.splice(index, 1);
                updated = true;
            }
        });
        if (updated) {
            this.elm.setAttributeNS(null, 'class', clsNames.filter((c) => c.length > 0).join(' '));
        }
    }
    contains(className) {
        className = String(className);
        return getItems(this.elm).includes(className);
    }
    toggle(className) {
        className = String(className);
        if (this.contains(className) === true) {
            this.remove(className);
        }
        else {
            this.add(className);
        }
    }
    get length() {
        return getItems(this.elm).length;
    }
    item(index) {
        return getItems(this.elm)[index];
    }
    toString() {
        return getItems(this.elm).join(' ');
    }
}
function validateClass(className) {
    if (className === '') {
        throw new Error('The token provided must not be empty.');
    }
    if (/\s/.test(className)) {
        throw new Error(`The token provided ('${className}') contains HTML space characters, which are not valid in tokens.`);
    }
}
function getItems(elm) {
    const className = elm.getAttribute('class');
    if (typeof className === 'string' && className.length > 0) {
        return className
            .trim()
            .split(' ')
            .filter((c) => c.length > 0);
    }
    return [];
}

class MockCSSStyleDeclaration {
    constructor() {
        this._styles = new Map();
    }
    setProperty(prop, value) {
        prop = jsCaseToCssCase(prop);
        if (value == null || value === '') {
            this._styles.delete(prop);
        }
        else {
            this._styles.set(prop, String(value));
        }
    }
    getPropertyValue(prop) {
        prop = jsCaseToCssCase(prop);
        return String(this._styles.get(prop) || '');
    }
    removeProperty(prop) {
        prop = jsCaseToCssCase(prop);
        this._styles.delete(prop);
    }
    get length() {
        return this._styles.size;
    }
    get cssText() {
        const cssText = [];
        this._styles.forEach((value, prop) => {
            cssText.push(`${prop}: ${value};`);
        });
        return cssText.join(' ').trim();
    }
    set cssText(cssText) {
        if (cssText == null || cssText === '') {
            this._styles.clear();
            return;
        }
        cssText.split(';').forEach((rule) => {
            rule = rule.trim();
            if (rule.length > 0) {
                const splt = rule.split(':');
                if (splt.length > 1) {
                    const prop = splt[0].trim();
                    const value = splt.slice(1).join(':').trim();
                    if (prop !== '' && value !== '') {
                        this._styles.set(jsCaseToCssCase(prop), value);
                    }
                }
            }
        });
    }
}
function createCSSStyleDeclaration() {
    return new Proxy(new MockCSSStyleDeclaration(), cssProxyHandler);
}
const cssProxyHandler = {
    get(cssStyle, prop) {
        if (prop in cssStyle) {
            return cssStyle[prop];
        }
        prop = cssCaseToJsCase(prop);
        return cssStyle.getPropertyValue(prop);
    },
    set(cssStyle, prop, value) {
        if (prop in cssStyle) {
            cssStyle[prop] = value;
        }
        else {
            cssStyle.setProperty(prop, value);
        }
        return true;
    },
};
function cssCaseToJsCase(str) {
    // font-size to fontSize
    if (str.length > 1 && str.includes('-') === true) {
        str = str
            .toLowerCase()
            .split('-')
            .map((segment) => segment.charAt(0).toUpperCase() + segment.slice(1))
            .join('');
        str = str.slice(0, 1).toLowerCase() + str.slice(1);
    }
    return str;
}
function jsCaseToCssCase(str) {
    // fontSize to font-size
    if (str.length > 1 && str.includes('-') === false && /[A-Z]/.test(str) === true) {
        str = str
            .replace(/([A-Z])/g, (g) => ' ' + g[0])
            .trim()
            .replace(/ /g, '-')
            .toLowerCase();
    }
    return str;
}

class MockCustomElementRegistry {
    constructor(win) {
        this.win = win;
    }
    define(tagName, cstr, options) {
        if (tagName.toLowerCase() !== tagName) {
            throw new Error(`Failed to execute 'define' on 'CustomElementRegistry': "${tagName}" is not a valid custom element name`);
        }
        if (this.__registry == null) {
            this.__registry = new Map();
        }
        this.__registry.set(tagName, { cstr, options });
        if (this.__whenDefined != null) {
            const whenDefinedResolveFns = this.__whenDefined.get(tagName);
            if (whenDefinedResolveFns != null) {
                whenDefinedResolveFns.forEach((whenDefinedResolveFn) => {
                    whenDefinedResolveFn();
                });
                whenDefinedResolveFns.length = 0;
                this.__whenDefined.delete(tagName);
            }
        }
        const doc = this.win.document;
        if (doc != null) {
            const hosts = doc.querySelectorAll(tagName);
            hosts.forEach((host) => {
                if (upgradedElements.has(host) === false) {
                    tempDisableCallbacks.add(doc);
                    const upgradedCmp = createCustomElement(this, doc, tagName);
                    for (let i = 0; i < host.childNodes.length; i++) {
                        const childNode = host.childNodes[i];
                        childNode.remove();
                        upgradedCmp.appendChild(childNode);
                    }
                    tempDisableCallbacks.delete(doc);
                    if (proxyElements.has(host)) {
                        proxyElements.set(host, upgradedCmp);
                    }
                }
                fireConnectedCallback(host);
            });
        }
    }
    get(tagName) {
        if (this.__registry != null) {
            const def = this.__registry.get(tagName.toLowerCase());
            if (def != null) {
                return def.cstr;
            }
        }
        return undefined;
    }
    upgrade(_rootNode) {
        //
    }
    clear() {
        if (this.__registry != null) {
            this.__registry.clear();
        }
        if (this.__whenDefined != null) {
            this.__whenDefined.clear();
        }
    }
    whenDefined(tagName) {
        tagName = tagName.toLowerCase();
        if (this.__registry != null && this.__registry.has(tagName) === true) {
            return Promise.resolve(this.__registry.get(tagName).cstr);
        }
        return new Promise((resolve) => {
            if (this.__whenDefined == null) {
                this.__whenDefined = new Map();
            }
            let whenDefinedResolveFns = this.__whenDefined.get(tagName);
            if (whenDefinedResolveFns == null) {
                whenDefinedResolveFns = [];
                this.__whenDefined.set(tagName, whenDefinedResolveFns);
            }
            whenDefinedResolveFns.push(resolve);
        });
    }
}
function createCustomElement(customElements, ownerDocument, tagName) {
    const Cstr = customElements.get(tagName);
    if (Cstr != null) {
        const cmp = new Cstr(ownerDocument);
        cmp.nodeName = tagName.toUpperCase();
        upgradedElements.add(cmp);
        return cmp;
    }
    const host = new Proxy({}, {
        get(obj, prop) {
            const elm = proxyElements.get(host);
            if (elm != null) {
                return elm[prop];
            }
            return obj[prop];
        },
        set(obj, prop, val) {
            const elm = proxyElements.get(host);
            if (elm != null) {
                elm[prop] = val;
            }
            else {
                obj[prop] = val;
            }
            return true;
        },
        has(obj, prop) {
            const elm = proxyElements.get(host);
            if (prop in elm) {
                return true;
            }
            if (prop in obj) {
                return true;
            }
            return false;
        },
    });
    const elm = new MockHTMLElement(ownerDocument, tagName);
    proxyElements.set(host, elm);
    return host;
}
const proxyElements = new WeakMap();
const upgradedElements = new WeakSet();
function connectNode(ownerDocument, node) {
    node.ownerDocument = ownerDocument;
    if (node.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */) {
        if (ownerDocument != null && node.nodeName.includes('-')) {
            const win = ownerDocument.defaultView;
            if (win != null && typeof node.connectedCallback === 'function' && node.isConnected) {
                fireConnectedCallback(node);
            }
            const shadowRoot = node.shadowRoot;
            if (shadowRoot != null) {
                shadowRoot.childNodes.forEach((childNode) => {
                    connectNode(ownerDocument, childNode);
                });
            }
        }
        node.childNodes.forEach((childNode) => {
            connectNode(ownerDocument, childNode);
        });
    }
    else {
        node.childNodes.forEach((childNode) => {
            childNode.ownerDocument = ownerDocument;
        });
    }
}
function fireConnectedCallback(node) {
    if (typeof node.connectedCallback === 'function') {
        if (tempDisableCallbacks.has(node.ownerDocument) === false) {
            try {
                node.connectedCallback();
            }
            catch (e) {
                console.error(e);
            }
        }
    }
}
function disconnectNode(node) {
    if (node.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */) {
        if (node.nodeName.includes('-') === true && typeof node.disconnectedCallback === 'function') {
            if (tempDisableCallbacks.has(node.ownerDocument) === false) {
                try {
                    node.disconnectedCallback();
                }
                catch (e) {
                    console.error(e);
                }
            }
        }
        node.childNodes.forEach(disconnectNode);
    }
}
function attributeChanged(node, attrName, oldValue, newValue) {
    attrName = attrName.toLowerCase();
    const observedAttributes = node.constructor.observedAttributes;
    if (Array.isArray(observedAttributes) === true &&
        observedAttributes.some((obs) => obs.toLowerCase() === attrName) === true) {
        try {
            node.attributeChangedCallback(attrName, oldValue, newValue);
        }
        catch (e) {
            console.error(e);
        }
    }
}
function checkAttributeChanged(node) {
    return node.nodeName.includes('-') === true && typeof node.attributeChangedCallback === 'function';
}
const tempDisableCallbacks = new Set();

function dataset(elm) {
    const ds = {};
    const attributes = elm.attributes;
    const attrLen = attributes.length;
    for (let i = 0; i < attrLen; i++) {
        const attr = attributes.item(i);
        const nodeName = attr.nodeName;
        if (nodeName.startsWith('data-')) {
            ds[dashToPascalCase(nodeName)] = attr.nodeValue;
        }
    }
    return new Proxy(ds, {
        get(_obj, camelCaseProp) {
            return ds[camelCaseProp];
        },
        set(_obj, camelCaseProp, value) {
            const dataAttr = toDataAttribute(camelCaseProp);
            elm.setAttribute(dataAttr, value);
            return true;
        },
    });
}
function toDataAttribute(str) {
    return ('data-' +
        String(str)
            .replace(/([A-Z0-9])/g, (g) => ' ' + g[0])
            .trim()
            .replace(/ /g, '-')
            .toLowerCase());
}
function dashToPascalCase(str) {
    str = String(str).slice(5);
    return str
        .split('-')
        .map((segment, index) => {
        if (index === 0) {
            return segment.charAt(0).toLowerCase() + segment.slice(1);
        }
        return segment.charAt(0).toUpperCase() + segment.slice(1);
    })
        .join('');
}

class MockEvent {
    constructor(type, eventInitDict) {
        this.bubbles = false;
        this.cancelBubble = false;
        this.cancelable = false;
        this.composed = false;
        this.currentTarget = null;
        this.defaultPrevented = false;
        this.srcElement = null;
        this.target = null;
        if (typeof type !== 'string') {
            throw new Error(`Event type required`);
        }
        this.type = type;
        this.timeStamp = Date.now();
        if (eventInitDict != null) {
            Object.assign(this, eventInitDict);
        }
    }
    preventDefault() {
        this.defaultPrevented = true;
    }
    stopPropagation() {
        this.cancelBubble = true;
    }
    stopImmediatePropagation() {
        this.cancelBubble = true;
    }
    composedPath() {
        const composedPath = [];
        let currentElement = this.target;
        while (currentElement) {
            composedPath.push(currentElement);
            if (!currentElement.parentElement && currentElement.nodeName === "#document" /* NODE_NAMES.DOCUMENT_NODE */) {
                // the current element doesn't have a parent, but we've detected it's our root document node. push the window
                // object associated with the document onto the path
                composedPath.push(currentElement.defaultView);
                break;
            }
            currentElement = currentElement.parentElement;
        }
        return composedPath;
    }
}
class MockCustomEvent extends MockEvent {
    constructor(type, customEventInitDic) {
        super(type);
        this.detail = null;
        if (customEventInitDic != null) {
            Object.assign(this, customEventInitDic);
        }
    }
}
class MockKeyboardEvent extends MockEvent {
    constructor(type, keyboardEventInitDic) {
        super(type);
        this.code = '';
        this.key = '';
        this.altKey = false;
        this.ctrlKey = false;
        this.metaKey = false;
        this.shiftKey = false;
        this.location = 0;
        this.repeat = false;
        if (keyboardEventInitDic != null) {
            Object.assign(this, keyboardEventInitDic);
        }
    }
}
class MockMouseEvent extends MockEvent {
    constructor(type, mouseEventInitDic) {
        super(type);
        this.screenX = 0;
        this.screenY = 0;
        this.clientX = 0;
        this.clientY = 0;
        this.ctrlKey = false;
        this.shiftKey = false;
        this.altKey = false;
        this.metaKey = false;
        this.button = 0;
        this.buttons = 0;
        this.relatedTarget = null;
        if (mouseEventInitDic != null) {
            Object.assign(this, mouseEventInitDic);
        }
    }
}
class MockUIEvent extends MockEvent {
    constructor(type, uiEventInitDic) {
        super(type);
        this.detail = null;
        this.view = null;
        if (uiEventInitDic != null) {
            Object.assign(this, uiEventInitDic);
        }
    }
}
class MockFocusEvent extends MockUIEvent {
    constructor(type, focusEventInitDic) {
        super(type);
        this.relatedTarget = null;
        if (focusEventInitDic != null) {
            Object.assign(this, focusEventInitDic);
        }
    }
}
class MockEventListener {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
}
function addEventListener(elm, type, handler) {
    const target = elm;
    if (target.__listeners == null) {
        target.__listeners = [];
    }
    target.__listeners.push(new MockEventListener(type, handler));
}
function removeEventListener(elm, type, handler) {
    const target = elm;
    if (target != null && Array.isArray(target.__listeners) === true) {
        const elmListener = target.__listeners.find((e) => e.type === type && e.handler === handler);
        if (elmListener != null) {
            const index = target.__listeners.indexOf(elmListener);
            target.__listeners.splice(index, 1);
        }
    }
}
function resetEventListeners(target) {
    if (target != null && target.__listeners != null) {
        target.__listeners = null;
    }
}
function triggerEventListener(elm, ev) {
    if (elm == null || ev.cancelBubble === true) {
        return;
    }
    const target = elm;
    ev.currentTarget = elm;
    if (Array.isArray(target.__listeners) === true) {
        const listeners = target.__listeners.filter((e) => e.type === ev.type);
        listeners.forEach((listener) => {
            try {
                listener.handler.call(target, ev);
            }
            catch (err) {
                console.error(err);
            }
        });
    }
    if (ev.bubbles === false) {
        return;
    }
    if (elm.nodeName === "#document" /* NODE_NAMES.DOCUMENT_NODE */) {
        triggerEventListener(elm.defaultView, ev);
    }
    else {
        triggerEventListener(elm.parentElement, ev);
    }
}
function dispatchEvent(currentTarget, ev) {
    ev.target = currentTarget;
    triggerEventListener(currentTarget, ev);
    return true;
}

// Parse5 7.1.2
const e=function(e){const t=new Set([65534,65535,131070,131071,196606,196607,262142,262143,327678,327679,393214,393215,458750,458751,524286,524287,589822,589823,655358,655359,720894,720895,786430,786431,851966,851967,917502,917503,983038,983039,1048574,1048575,1114110,1114111]),s="�";var a;!function(e){e[e.EOF=-1]="EOF",e[e.NULL=0]="NULL",e[e.TABULATION=9]="TABULATION",e[e.CARRIAGE_RETURN=13]="CARRIAGE_RETURN",e[e.LINE_FEED=10]="LINE_FEED",e[e.FORM_FEED=12]="FORM_FEED",e[e.SPACE=32]="SPACE",e[e.EXCLAMATION_MARK=33]="EXCLAMATION_MARK",e[e.QUOTATION_MARK=34]="QUOTATION_MARK",e[e.NUMBER_SIGN=35]="NUMBER_SIGN",e[e.AMPERSAND=38]="AMPERSAND",e[e.APOSTROPHE=39]="APOSTROPHE",e[e.HYPHEN_MINUS=45]="HYPHEN_MINUS",e[e.SOLIDUS=47]="SOLIDUS",e[e.DIGIT_0=48]="DIGIT_0",e[e.DIGIT_9=57]="DIGIT_9",e[e.SEMICOLON=59]="SEMICOLON",e[e.LESS_THAN_SIGN=60]="LESS_THAN_SIGN",e[e.EQUALS_SIGN=61]="EQUALS_SIGN",e[e.GREATER_THAN_SIGN=62]="GREATER_THAN_SIGN",e[e.QUESTION_MARK=63]="QUESTION_MARK",e[e.LATIN_CAPITAL_A=65]="LATIN_CAPITAL_A",e[e.LATIN_CAPITAL_F=70]="LATIN_CAPITAL_F",e[e.LATIN_CAPITAL_X=88]="LATIN_CAPITAL_X",e[e.LATIN_CAPITAL_Z=90]="LATIN_CAPITAL_Z",e[e.RIGHT_SQUARE_BRACKET=93]="RIGHT_SQUARE_BRACKET",e[e.GRAVE_ACCENT=96]="GRAVE_ACCENT",e[e.LATIN_SMALL_A=97]="LATIN_SMALL_A",e[e.LATIN_SMALL_F=102]="LATIN_SMALL_F",e[e.LATIN_SMALL_X=120]="LATIN_SMALL_X",e[e.LATIN_SMALL_Z=122]="LATIN_SMALL_Z",e[e.REPLACEMENT_CHARACTER=65533]="REPLACEMENT_CHARACTER";}(a=a||(a={}));const r="[CDATA[",n="doctype",i="script";function o(e){return e>=55296&&e<=57343}function c(e){return 32!==e&&10!==e&&13!==e&&9!==e&&12!==e&&e>=1&&e<=31||e>=127&&e<=159}function E(e){return e>=64976&&e<=65007||t.has(e)}var T,h;!function(e){e.controlCharacterInInputStream="control-character-in-input-stream",e.noncharacterInInputStream="noncharacter-in-input-stream",e.surrogateInInputStream="surrogate-in-input-stream",e.nonVoidHtmlElementStartTagWithTrailingSolidus="non-void-html-element-start-tag-with-trailing-solidus",e.endTagWithAttributes="end-tag-with-attributes",e.endTagWithTrailingSolidus="end-tag-with-trailing-solidus",e.unexpectedSolidusInTag="unexpected-solidus-in-tag",e.unexpectedNullCharacter="unexpected-null-character",e.unexpectedQuestionMarkInsteadOfTagName="unexpected-question-mark-instead-of-tag-name",e.invalidFirstCharacterOfTagName="invalid-first-character-of-tag-name",e.unexpectedEqualsSignBeforeAttributeName="unexpected-equals-sign-before-attribute-name",e.missingEndTagName="missing-end-tag-name",e.unexpectedCharacterInAttributeName="unexpected-character-in-attribute-name",e.unknownNamedCharacterReference="unknown-named-character-reference",e.missingSemicolonAfterCharacterReference="missing-semicolon-after-character-reference",e.unexpectedCharacterAfterDoctypeSystemIdentifier="unexpected-character-after-doctype-system-identifier",e.unexpectedCharacterInUnquotedAttributeValue="unexpected-character-in-unquoted-attribute-value",e.eofBeforeTagName="eof-before-tag-name",e.eofInTag="eof-in-tag",e.missingAttributeValue="missing-attribute-value",e.missingWhitespaceBetweenAttributes="missing-whitespace-between-attributes",e.missingWhitespaceAfterDoctypePublicKeyword="missing-whitespace-after-doctype-public-keyword",e.missingWhitespaceBetweenDoctypePublicAndSystemIdentifiers="missing-whitespace-between-doctype-public-and-system-identifiers",e.missingWhitespaceAfterDoctypeSystemKeyword="missing-whitespace-after-doctype-system-keyword",e.missingQuoteBeforeDoctypePublicIdentifier="missing-quote-before-doctype-public-identifier",e.missingQuoteBeforeDoctypeSystemIdentifier="missing-quote-before-doctype-system-identifier",e.missingDoctypePublicIdentifier="missing-doctype-public-identifier",e.missingDoctypeSystemIdentifier="missing-doctype-system-identifier",e.abruptDoctypePublicIdentifier="abrupt-doctype-public-identifier",e.abruptDoctypeSystemIdentifier="abrupt-doctype-system-identifier",e.cdataInHtmlContent="cdata-in-html-content",e.incorrectlyOpenedComment="incorrectly-opened-comment",e.eofInScriptHtmlCommentLikeText="eof-in-script-html-comment-like-text",e.eofInDoctype="eof-in-doctype",e.nestedComment="nested-comment",e.abruptClosingOfEmptyComment="abrupt-closing-of-empty-comment",e.eofInComment="eof-in-comment",e.incorrectlyClosedComment="incorrectly-closed-comment",e.eofInCdata="eof-in-cdata",e.absenceOfDigitsInNumericCharacterReference="absence-of-digits-in-numeric-character-reference",e.nullCharacterReference="null-character-reference",e.surrogateCharacterReference="surrogate-character-reference",e.characterReferenceOutsideUnicodeRange="character-reference-outside-unicode-range",e.controlCharacterReference="control-character-reference",e.noncharacterCharacterReference="noncharacter-character-reference",e.missingWhitespaceBeforeDoctypeName="missing-whitespace-before-doctype-name",e.missingDoctypeName="missing-doctype-name",e.invalidCharacterSequenceAfterDoctypeName="invalid-character-sequence-after-doctype-name",e.duplicateAttribute="duplicate-attribute",e.nonConformingDoctype="non-conforming-doctype",e.missingDoctype="missing-doctype",e.misplacedDoctype="misplaced-doctype",e.endTagWithoutMatchingOpenElement="end-tag-without-matching-open-element",e.closingOfElementWithOpenChildElements="closing-of-element-with-open-child-elements",e.disallowedContentInNoscriptInHead="disallowed-content-in-noscript-in-head",e.openElementsLeftAfterEof="open-elements-left-after-eof",e.abandonedHeadElementChild="abandoned-head-element-child",e.misplacedStartTagForHeadElement="misplaced-start-tag-for-head-element",e.nestedNoscriptInHead="nested-noscript-in-head",e.eofInElementThatCanContainOnlyText="eof-in-element-that-can-contain-only-text";}(T=T||(T={}));class _{constructor(e){this.handler=e,this.html="",this.pos=-1,this.lastGapPos=-2,this.gapStack=[],this.skipNextNewLine=!1,this.lastChunkWritten=!1,this.endOfChunkHit=!1,this.bufferWaterline=65536,this.isEol=!1,this.lineStartPos=0,this.droppedBufferSize=0,this.line=1,this.lastErrOffset=-1;}get col(){return this.pos-this.lineStartPos+Number(this.lastGapPos!==this.pos)}get offset(){return this.droppedBufferSize+this.pos}getError(e){const{line:t,col:s,offset:a}=this;return {code:e,startLine:t,endLine:t,startCol:s,endCol:s,startOffset:a,endOffset:a}}_err(e){this.handler.onParseError&&this.lastErrOffset!==this.offset&&(this.lastErrOffset=this.offset,this.handler.onParseError(this.getError(e)));}_addGap(){this.gapStack.push(this.lastGapPos),this.lastGapPos=this.pos;}_processSurrogate(e){if(this.pos!==this.html.length-1){const t=this.html.charCodeAt(this.pos+1);if(function(e){return e>=56320&&e<=57343}(t))return this.pos++,this._addGap(),1024*(e-55296)+9216+t}else if(!this.lastChunkWritten)return this.endOfChunkHit=!0,a.EOF;return this._err(T.surrogateInInputStream),e}willDropParsedChunk(){return this.pos>this.bufferWaterline}dropParsedChunk(){this.willDropParsedChunk()&&(this.html=this.html.substring(this.pos),this.lineStartPos-=this.pos,this.droppedBufferSize+=this.pos,this.pos=0,this.lastGapPos=-2,this.gapStack.length=0);}write(e,t){this.html.length>0?this.html+=e:this.html=e,this.endOfChunkHit=!1,this.lastChunkWritten=t;}insertHtmlAtCurrentPos(e){this.html=this.html.substring(0,this.pos+1)+e+this.html.substring(this.pos+1),this.endOfChunkHit=!1;}startsWith(e,t){if(this.pos+e.length>this.html.length)return this.endOfChunkHit=!this.lastChunkWritten,!1;if(t)return this.html.startsWith(e,this.pos);for(let t=0;t<e.length;t++)if((32|this.html.charCodeAt(this.pos+t))!==e.charCodeAt(t))return !1;return !0}peek(e){const t=this.pos+e;if(t>=this.html.length)return this.endOfChunkHit=!this.lastChunkWritten,a.EOF;const s=this.html.charCodeAt(t);return s===a.CARRIAGE_RETURN?a.LINE_FEED:s}advance(){if(this.pos++,this.isEol&&(this.isEol=!1,this.line++,this.lineStartPos=this.pos),this.pos>=this.html.length)return this.endOfChunkHit=!this.lastChunkWritten,a.EOF;let e=this.html.charCodeAt(this.pos);return e===a.CARRIAGE_RETURN?(this.isEol=!0,this.skipNextNewLine=!0,a.LINE_FEED):e===a.LINE_FEED&&(this.isEol=!0,this.skipNextNewLine)?(this.line--,this.skipNextNewLine=!1,this._addGap(),this.advance()):(this.skipNextNewLine=!1,o(e)&&(e=this._processSurrogate(e)),null===this.handler.onParseError||e>31&&e<127||e===a.LINE_FEED||e===a.CARRIAGE_RETURN||e>159&&e<64976||this._checkForProblematicCharacters(e),e)}_checkForProblematicCharacters(e){c(e)?this._err(T.controlCharacterInInputStream):E(e)&&this._err(T.noncharacterInInputStream);}retreat(e){for(this.pos-=e;this.pos<this.lastGapPos;)this.lastGapPos=this.gapStack.pop(),this.pos--;this.isEol=!1;}}function A(e,t){for(let s=e.attrs.length-1;s>=0;s--)if(e.attrs[s].name===t)return e.attrs[s].value;return null}!function(e){e[e.CHARACTER=0]="CHARACTER",e[e.NULL_CHARACTER=1]="NULL_CHARACTER",e[e.WHITESPACE_CHARACTER=2]="WHITESPACE_CHARACTER",e[e.START_TAG=3]="START_TAG",e[e.END_TAG=4]="END_TAG",e[e.COMMENT=5]="COMMENT",e[e.DOCTYPE=6]="DOCTYPE",e[e.EOF=7]="EOF",e[e.HIBERNATION=8]="HIBERNATION";}(h=h||(h={}));var l="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function m(e,t,s){return e(s={path:t,exports:{},require:function(e,t){return function(){throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs")}(null==t&&s.path)}},s.exports),s.exports}var d,p,u,N,I,C=m((function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.default=new Uint16Array('ᵁ<Õıʊҝջאٵ۞ޢߖࠏ੊ઑඡ๭༉༦჊ረዡᐕᒝᓃᓟᔥ\0\0\0\0\0\0ᕫᛍᦍᰒᷝ὾⁠↰⊍⏀⏻⑂⠤⤒ⴈ⹈⿎〖㊺㘹㞬㣾㨨㩱㫠㬮ࠀEMabcfglmnoprstu\\bfms¦³¹ÈÏlig耻Æ䃆P耻&䀦cute耻Á䃁reve;䄂Āiyx}rc耻Â䃂;䐐r;쀀𝔄rave耻À䃀pha;䎑acr;䄀d;橓Āgp¡on;䄄f;쀀𝔸plyFunction;恡ing耻Å䃅Ācs¾Ãr;쀀𝒜ign;扔ilde耻Ã䃃ml耻Ä䃄ЀaceforsuåûþėĜĢħĪĀcrêòkslash;或Ŷöø;櫧ed;挆y;䐑ƀcrtąċĔause;戵noullis;愬a;䎒r;쀀𝔅pf;쀀𝔹eve;䋘còēmpeq;扎܀HOacdefhilorsuōőŖƀƞƢƵƷƺǜȕɳɸɾcy;䐧PY耻©䂩ƀcpyŝŢźute;䄆Ā;iŧŨ拒talDifferentialD;慅leys;愭ȀaeioƉƎƔƘron;䄌dil耻Ç䃇rc;䄈nint;戰ot;䄊ĀdnƧƭilla;䂸terDot;䂷òſi;䎧rcleȀDMPTǇǋǑǖot;抙inus;抖lus;投imes;抗oĀcsǢǸkwiseContourIntegral;戲eCurlyĀDQȃȏoubleQuote;思uote;怙ȀlnpuȞȨɇɕonĀ;eȥȦ户;橴ƀgitȯȶȺruent;扡nt;戯ourIntegral;戮ĀfrɌɎ;愂oduct;成nterClockwiseContourIntegral;戳oss;樯cr;쀀𝒞pĀ;Cʄʅ拓ap;才րDJSZacefiosʠʬʰʴʸˋ˗ˡ˦̳ҍĀ;oŹʥtrahd;椑cy;䐂cy;䐅cy;䐏ƀgrsʿ˄ˇger;怡r;憡hv;櫤Āayː˕ron;䄎;䐔lĀ;t˝˞戇a;䎔r;쀀𝔇Āaf˫̧Ācm˰̢riticalȀADGT̖̜̀̆cute;䂴oŴ̋̍;䋙bleAcute;䋝rave;䁠ilde;䋜ond;拄ferentialD;慆Ѱ̽\0\0\0͔͂\0Ѕf;쀀𝔻ƀ;DE͈͉͍䂨ot;惜qual;扐blèCDLRUVͣͲ΂ϏϢϸontourIntegraìȹoɴ͹\0\0ͻ»͉nArrow;懓Āeo·ΤftƀARTΐΖΡrrow;懐ightArrow;懔eåˊngĀLRΫτeftĀARγιrrow;柸ightArrow;柺ightArrow;柹ightĀATϘϞrrow;懒ee;抨pɁϩ\0\0ϯrrow;懑ownArrow;懕erticalBar;戥ǹABLRTaВЪаўѿͼrrowƀ;BUНОТ憓ar;椓pArrow;懵reve;䌑eft˒к\0ц\0ѐightVector;楐eeVector;楞ectorĀ;Bљњ憽ar;楖ightǔѧ\0ѱeeVector;楟ectorĀ;BѺѻ懁ar;楗eeĀ;A҆҇护rrow;憧ĀctҒҗr;쀀𝒟rok;䄐ࠀNTacdfglmopqstuxҽӀӄӋӞӢӧӮӵԡԯԶՒ՝ՠեG;䅊H耻Ð䃐cute耻É䃉ƀaiyӒӗӜron;䄚rc耻Ê䃊;䐭ot;䄖r;쀀𝔈rave耻È䃈ement;戈ĀapӺӾcr;䄒tyɓԆ\0\0ԒmallSquare;旻erySmallSquare;斫ĀgpԦԪon;䄘f;쀀𝔼silon;䎕uĀaiԼՉlĀ;TՂՃ橵ilde;扂librium;懌Āci՗՚r;愰m;橳a;䎗ml耻Ë䃋Āipժկsts;戃onentialE;慇ʀcfiosօֈ֍ֲ׌y;䐤r;쀀𝔉lledɓ֗\0\0֣mallSquare;旼erySmallSquare;斪Ͱֺ\0ֿ\0\0ׄf;쀀𝔽All;戀riertrf;愱cò׋؀JTabcdfgorstר׬ׯ׺؀ؒؖ؛؝أ٬ٲcy;䐃耻>䀾mmaĀ;d׷׸䎓;䏜reve;䄞ƀeiy؇،ؐdil;䄢rc;䄜;䐓ot;䄠r;쀀𝔊;拙pf;쀀𝔾eater̀EFGLSTصلَٖٛ٦qualĀ;Lؾؿ扥ess;招ullEqual;执reater;檢ess;扷lantEqual;橾ilde;扳cr;쀀𝒢;扫ЀAacfiosuڅڋږڛڞڪھۊRDcy;䐪Āctڐڔek;䋇;䁞irc;䄤r;愌lbertSpace;愋ǰگ\0ڲf;愍izontalLine;攀Āctۃۅòکrok;䄦mpńېۘownHumðįqual;扏܀EJOacdfgmnostuۺ۾܃܇܎ܚܞܡܨ݄ݸދޏޕcy;䐕lig;䄲cy;䐁cute耻Í䃍Āiyܓܘrc耻Î䃎;䐘ot;䄰r;愑rave耻Ì䃌ƀ;apܠܯܿĀcgܴܷr;䄪inaryI;慈lieóϝǴ݉\0ݢĀ;eݍݎ戬Āgrݓݘral;戫section;拂isibleĀCTݬݲomma;恣imes;恢ƀgptݿރވon;䄮f;쀀𝕀a;䎙cr;愐ilde;䄨ǫޚ\0ޞcy;䐆l耻Ï䃏ʀcfosuެ޷޼߂ߐĀiyޱ޵rc;䄴;䐙r;쀀𝔍pf;쀀𝕁ǣ߇\0ߌr;쀀𝒥rcy;䐈kcy;䐄΀HJacfosߤߨ߽߬߱ࠂࠈcy;䐥cy;䐌ppa;䎚Āey߶߻dil;䄶;䐚r;쀀𝔎pf;쀀𝕂cr;쀀𝒦րJTaceflmostࠥࠩࠬࡐࡣ঳সে্਷ੇcy;䐉耻<䀼ʀcmnpr࠷࠼ࡁࡄࡍute;䄹bda;䎛g;柪lacetrf;愒r;憞ƀaeyࡗ࡜ࡡron;䄽dil;䄻;䐛Āfsࡨ॰tԀACDFRTUVarࡾࢩࢱࣦ࣠ࣼयज़ΐ४Ānrࢃ࢏gleBracket;柨rowƀ;BR࢙࢚࢞憐ar;懤ightArrow;懆eiling;挈oǵࢷ\0ࣃbleBracket;柦nǔࣈ\0࣒eeVector;楡ectorĀ;Bࣛࣜ懃ar;楙loor;挊ightĀAV࣯ࣵrrow;憔ector;楎Āerँगeƀ;AVउऊऐ抣rrow;憤ector;楚iangleƀ;BEतथऩ抲ar;槏qual;抴pƀDTVषूौownVector;楑eeVector;楠ectorĀ;Bॖॗ憿ar;楘ectorĀ;B॥०憼ar;楒ightáΜs̀EFGLSTॾঋকঝঢভqualGreater;拚ullEqual;扦reater;扶ess;檡lantEqual;橽ilde;扲r;쀀𝔏Ā;eঽা拘ftarrow;懚idot;䄿ƀnpw৔ਖਛgȀLRlr৞৷ਂਐeftĀAR০৬rrow;柵ightArrow;柷ightArrow;柶eftĀarγਊightáοightáϊf;쀀𝕃erĀLRਢਬeftArrow;憙ightArrow;憘ƀchtਾੀੂòࡌ;憰rok;䅁;扪Ѐacefiosuਗ਼੝੠੷੼અઋ઎p;椅y;䐜Ādl੥੯iumSpace;恟lintrf;愳r;쀀𝔐nusPlus;戓pf;쀀𝕄cò੶;䎜ҀJacefostuણધભીଔଙඑ඗ඞcy;䐊cute;䅃ƀaey઴હાron;䅇dil;䅅;䐝ƀgswે૰଎ativeƀMTV૓૟૨ediumSpace;怋hiĀcn૦૘ë૙eryThiî૙tedĀGL૸ଆreaterGreateòٳessLesóੈLine;䀊r;쀀𝔑ȀBnptଢନଷ଺reak;恠BreakingSpace;䂠f;愕ڀ;CDEGHLNPRSTV୕ୖ୪୼஡௫ఄ౞಄ದ೘ൡඅ櫬Āou୛୤ngruent;扢pCap;扭oubleVerticalBar;戦ƀlqxஃஊ஛ement;戉ualĀ;Tஒஓ扠ilde;쀀≂̸ists;戄reater΀;EFGLSTஶஷ஽௉௓௘௥扯qual;扱ullEqual;쀀≧̸reater;쀀≫̸ess;批lantEqual;쀀⩾̸ilde;扵umpń௲௽ownHump;쀀≎̸qual;쀀≏̸eĀfsఊధtTriangleƀ;BEచఛడ拪ar;쀀⧏̸qual;括s̀;EGLSTవశ఼ౄోౘ扮qual;扰reater;扸ess;쀀≪̸lantEqual;쀀⩽̸ilde;扴estedĀGL౨౹reaterGreater;쀀⪢̸essLess;쀀⪡̸recedesƀ;ESಒಓಛ技qual;쀀⪯̸lantEqual;拠ĀeiಫಹverseElement;戌ghtTriangleƀ;BEೋೌ೒拫ar;쀀⧐̸qual;拭ĀquೝഌuareSuĀbp೨೹setĀ;E೰ೳ쀀⊏̸qual;拢ersetĀ;Eഃആ쀀⊐̸qual;拣ƀbcpഓതൎsetĀ;Eഛഞ쀀⊂⃒qual;抈ceedsȀ;ESTലള഻െ抁qual;쀀⪰̸lantEqual;拡ilde;쀀≿̸ersetĀ;E൘൛쀀⊃⃒qual;抉ildeȀ;EFT൮൯൵ൿ扁qual;扄ullEqual;扇ilde;扉erticalBar;戤cr;쀀𝒩ilde耻Ñ䃑;䎝܀Eacdfgmoprstuvලෂ෉෕ෛ෠෧෼ขภยา฿ไlig;䅒cute耻Ó䃓Āiy෎ීrc耻Ô䃔;䐞blac;䅐r;쀀𝔒rave耻Ò䃒ƀaei෮ෲ෶cr;䅌ga;䎩cron;䎟pf;쀀𝕆enCurlyĀDQฎบoubleQuote;怜uote;怘;橔Āclวฬr;쀀𝒪ash耻Ø䃘iŬื฼de耻Õ䃕es;樷ml耻Ö䃖erĀBP๋๠Āar๐๓r;怾acĀek๚๜;揞et;掴arenthesis;揜Ҁacfhilors๿ງຊຏຒດຝະ໼rtialD;戂y;䐟r;쀀𝔓i;䎦;䎠usMinus;䂱Āipຢອncareplanåڝf;愙Ȁ;eio຺ູ໠໤檻cedesȀ;EST່້໏໚扺qual;檯lantEqual;扼ilde;找me;怳Ādp໩໮uct;戏ortionĀ;aȥ໹l;戝Āci༁༆r;쀀𝒫;䎨ȀUfos༑༖༛༟OT耻"䀢r;쀀𝔔pf;愚cr;쀀𝒬؀BEacefhiorsu༾གྷཇའཱིྦྷྪྭ႖ႩႴႾarr;椐G耻®䂮ƀcnrཎནབute;䅔g;柫rĀ;tཛྷཝ憠l;椖ƀaeyཧཬཱron;䅘dil;䅖;䐠Ā;vླྀཹ愜erseĀEUྂྙĀlq྇ྎement;戋uilibrium;懋pEquilibrium;楯r»ཹo;䎡ghtЀACDFTUVa࿁࿫࿳ဢဨၛႇϘĀnr࿆࿒gleBracket;柩rowƀ;BL࿜࿝࿡憒ar;懥eftArrow;懄eiling;按oǵ࿹\0စbleBracket;柧nǔည\0နeeVector;楝ectorĀ;Bဝသ懂ar;楕loor;挋Āerိ၃eƀ;AVဵံြ抢rrow;憦ector;楛iangleƀ;BEၐၑၕ抳ar;槐qual;抵pƀDTVၣၮၸownVector;楏eeVector;楜ectorĀ;Bႂႃ憾ar;楔ectorĀ;B႑႒懀ar;楓Āpuႛ႞f;愝ndImplies;楰ightarrow;懛ĀchႹႼr;愛;憱leDelayed;槴ڀHOacfhimoqstuფჱჷჽᄙᄞᅑᅖᅡᅧᆵᆻᆿĀCcჩხHcy;䐩y;䐨FTcy;䐬cute;䅚ʀ;aeiyᄈᄉᄎᄓᄗ檼ron;䅠dil;䅞rc;䅜;䐡r;쀀𝔖ortȀDLRUᄪᄴᄾᅉownArrow»ОeftArrow»࢚ightArrow»࿝pArrow;憑gma;䎣allCircle;战pf;쀀𝕊ɲᅭ\0\0ᅰt;戚areȀ;ISUᅻᅼᆉᆯ斡ntersection;抓uĀbpᆏᆞsetĀ;Eᆗᆘ抏qual;抑ersetĀ;Eᆨᆩ抐qual;抒nion;抔cr;쀀𝒮ar;拆ȀbcmpᇈᇛሉላĀ;sᇍᇎ拐etĀ;Eᇍᇕqual;抆ĀchᇠህeedsȀ;ESTᇭᇮᇴᇿ扻qual;檰lantEqual;扽ilde;承Tháྌ;我ƀ;esሒሓሣ拑rsetĀ;Eሜም抃qual;抇et»ሓրHRSacfhiorsሾቄ቉ቕ቞ቱቶኟዂወዑORN耻Þ䃞ADE;愢ĀHc቎ቒcy;䐋y;䐦Ābuቚቜ;䀉;䎤ƀaeyብቪቯron;䅤dil;䅢;䐢r;쀀𝔗Āeiቻ኉ǲኀ\0ኇefore;戴a;䎘Ācn኎ኘkSpace;쀀  Space;怉ldeȀ;EFTካኬኲኼ戼qual;扃ullEqual;扅ilde;扈pf;쀀𝕋ipleDot;惛Āctዖዛr;쀀𝒯rok;䅦ૡዷጎጚጦ\0ጬጱ\0\0\0\0\0ጸጽ፷ᎅ\0᏿ᐄᐊᐐĀcrዻጁute耻Ú䃚rĀ;oጇገ憟cir;楉rǣጓ\0጖y;䐎ve;䅬Āiyጞጣrc耻Û䃛;䐣blac;䅰r;쀀𝔘rave耻Ù䃙acr;䅪Ādiፁ፩erĀBPፈ፝Āarፍፐr;䁟acĀekፗፙ;揟et;掵arenthesis;揝onĀ;P፰፱拃lus;抎Āgp፻፿on;䅲f;쀀𝕌ЀADETadps᎕ᎮᎸᏄϨᏒᏗᏳrrowƀ;BDᅐᎠᎤar;椒ownArrow;懅ownArrow;憕quilibrium;楮eeĀ;AᏋᏌ报rrow;憥ownáϳerĀLRᏞᏨeftArrow;憖ightArrow;憗iĀ;lᏹᏺ䏒on;䎥ing;䅮cr;쀀𝒰ilde;䅨ml耻Ü䃜ҀDbcdefosvᐧᐬᐰᐳᐾᒅᒊᒐᒖash;披ar;櫫y;䐒ashĀ;lᐻᐼ抩;櫦Āerᑃᑅ;拁ƀbtyᑌᑐᑺar;怖Ā;iᑏᑕcalȀBLSTᑡᑥᑪᑴar;戣ine;䁼eparator;杘ilde;所ThinSpace;怊r;쀀𝔙pf;쀀𝕍cr;쀀𝒱dash;抪ʀcefosᒧᒬᒱᒶᒼirc;䅴dge;拀r;쀀𝔚pf;쀀𝕎cr;쀀𝒲Ȁfiosᓋᓐᓒᓘr;쀀𝔛;䎞pf;쀀𝕏cr;쀀𝒳ҀAIUacfosuᓱᓵᓹᓽᔄᔏᔔᔚᔠcy;䐯cy;䐇cy;䐮cute耻Ý䃝Āiyᔉᔍrc;䅶;䐫r;쀀𝔜pf;쀀𝕐cr;쀀𝒴ml;䅸ЀHacdefosᔵᔹᔿᕋᕏᕝᕠᕤcy;䐖cute;䅹Āayᕄᕉron;䅽;䐗ot;䅻ǲᕔ\0ᕛoWidtè૙a;䎖r;愨pf;愤cr;쀀𝒵௡ᖃᖊᖐ\0ᖰᖶᖿ\0\0\0\0ᗆᗛᗫᙟ᙭\0ᚕ᚛ᚲᚹ\0ᚾcute耻á䃡reve;䄃̀;Ediuyᖜᖝᖡᖣᖨᖭ戾;쀀∾̳;房rc耻â䃢te肻´̆;䐰lig耻æ䃦Ā;r²ᖺ;쀀𝔞rave耻à䃠ĀepᗊᗖĀfpᗏᗔsym;愵èᗓha;䎱ĀapᗟcĀclᗤᗧr;䄁g;樿ɤᗰ\0\0ᘊʀ;adsvᗺᗻᗿᘁᘇ戧nd;橕;橜lope;橘;橚΀;elmrszᘘᘙᘛᘞᘿᙏᙙ戠;榤e»ᘙsdĀ;aᘥᘦ戡ѡᘰᘲᘴᘶᘸᘺᘼᘾ;榨;榩;榪;榫;榬;榭;榮;榯tĀ;vᙅᙆ戟bĀ;dᙌᙍ抾;榝Āptᙔᙗh;戢»¹arr;捼Āgpᙣᙧon;䄅f;쀀𝕒΀;Eaeiop዁ᙻᙽᚂᚄᚇᚊ;橰cir;橯;扊d;手s;䀧roxĀ;e዁ᚒñᚃing耻å䃥ƀctyᚡᚦᚨr;쀀𝒶;䀪mpĀ;e዁ᚯñʈilde耻ã䃣ml耻ä䃤Āciᛂᛈoninôɲnt;樑ࠀNabcdefiklnoprsu᛭ᛱᜰ᜼ᝃᝈ᝸᝽០៦ᠹᡐᜍ᤽᥈ᥰot;櫭Ācrᛶ᜞kȀcepsᜀᜅᜍᜓong;扌psilon;䏶rime;怵imĀ;e᜚᜛戽q;拍Ŷᜢᜦee;抽edĀ;gᜬᜭ挅e»ᜭrkĀ;t፜᜷brk;掶Āoyᜁᝁ;䐱quo;怞ʀcmprtᝓ᝛ᝡᝤᝨausĀ;eĊĉptyv;榰séᜌnoõēƀahwᝯ᝱ᝳ;䎲;愶een;扬r;쀀𝔟g΀costuvwឍឝឳេ៕៛៞ƀaiuបពរðݠrc;旯p»፱ƀdptឤឨឭot;樀lus;樁imes;樂ɱឹ\0\0ើcup;樆ar;昅riangleĀdu៍្own;施p;斳plus;樄eåᑄåᒭarow;植ƀako៭ᠦᠵĀcn៲ᠣkƀlst៺֫᠂ozenge;槫riangleȀ;dlr᠒᠓᠘᠝斴own;斾eft;旂ight;斸k;搣Ʊᠫ\0ᠳƲᠯ\0ᠱ;斒;斑4;斓ck;斈ĀeoᠾᡍĀ;qᡃᡆ쀀=⃥uiv;쀀≡⃥t;挐Ȁptwxᡙᡞᡧᡬf;쀀𝕓Ā;tᏋᡣom»Ꮜtie;拈؀DHUVbdhmptuvᢅᢖᢪᢻᣗᣛᣬ᣿ᤅᤊᤐᤡȀLRlrᢎᢐᢒᢔ;敗;敔;敖;敓ʀ;DUduᢡᢢᢤᢦᢨ敐;敦;敩;敤;敧ȀLRlrᢳᢵᢷᢹ;敝;敚;敜;教΀;HLRhlrᣊᣋᣍᣏᣑᣓᣕ救;敬;散;敠;敫;敢;敟ox;槉ȀLRlrᣤᣦᣨᣪ;敕;敒;攐;攌ʀ;DUduڽ᣷᣹᣻᣽;敥;敨;攬;攴inus;抟lus;択imes;抠ȀLRlrᤙᤛᤝ᤟;敛;敘;攘;攔΀;HLRhlrᤰᤱᤳᤵᤷ᤻᤹攂;敪;敡;敞;攼;攤;攜Āevģ᥂bar耻¦䂦Ȁceioᥑᥖᥚᥠr;쀀𝒷mi;恏mĀ;e᜚᜜lƀ;bhᥨᥩᥫ䁜;槅sub;柈Ŭᥴ᥾lĀ;e᥹᥺怢t»᥺pƀ;Eeįᦅᦇ;檮Ā;qۜۛೡᦧ\0᧨ᨑᨕᨲ\0ᨷᩐ\0\0᪴\0\0᫁\0\0ᬡᬮ᭍᭒\0᯽\0ᰌƀcpr᦭ᦲ᧝ute;䄇̀;abcdsᦿᧀᧄ᧊᧕᧙戩nd;橄rcup;橉Āau᧏᧒p;橋p;橇ot;橀;쀀∩︀Āeo᧢᧥t;恁îړȀaeiu᧰᧻ᨁᨅǰ᧵\0᧸s;橍on;䄍dil耻ç䃧rc;䄉psĀ;sᨌᨍ橌m;橐ot;䄋ƀdmnᨛᨠᨦil肻¸ƭptyv;榲t脀¢;eᨭᨮ䂢räƲr;쀀𝔠ƀceiᨽᩀᩍy;䑇ckĀ;mᩇᩈ朓ark»ᩈ;䏇r΀;Ecefms᩟᩠ᩢᩫ᪤᪪᪮旋;槃ƀ;elᩩᩪᩭ䋆q;扗eɡᩴ\0\0᪈rrowĀlr᩼᪁eft;憺ight;憻ʀRSacd᪒᪔᪖᪚᪟»ཇ;擈st;抛irc;抚ash;抝nint;樐id;櫯cir;槂ubsĀ;u᪻᪼晣it»᪼ˬ᫇᫔᫺\0ᬊonĀ;eᫍᫎ䀺Ā;qÇÆɭ᫙\0\0᫢aĀ;t᫞᫟䀬;䁀ƀ;fl᫨᫩᫫戁îᅠeĀmx᫱᫶ent»᫩eóɍǧ᫾\0ᬇĀ;dኻᬂot;橭nôɆƀfryᬐᬔᬗ;쀀𝕔oäɔ脀©;sŕᬝr;愗Āaoᬥᬩrr;憵ss;朗Ācuᬲᬷr;쀀𝒸Ābpᬼ᭄Ā;eᭁᭂ櫏;櫑Ā;eᭉᭊ櫐;櫒dot;拯΀delprvw᭠᭬᭷ᮂᮬᯔ᯹arrĀlr᭨᭪;椸;椵ɰ᭲\0\0᭵r;拞c;拟arrĀ;p᭿ᮀ憶;椽̀;bcdosᮏᮐᮖᮡᮥᮨ截rcap;橈Āauᮛᮞp;橆p;橊ot;抍r;橅;쀀∪︀Ȁalrv᮵ᮿᯞᯣrrĀ;mᮼᮽ憷;椼yƀevwᯇᯔᯘqɰᯎ\0\0ᯒreã᭳uã᭵ee;拎edge;拏en耻¤䂤earrowĀlrᯮ᯳eft»ᮀight»ᮽeäᯝĀciᰁᰇoninôǷnt;戱lcty;挭ঀAHabcdefhijlorstuwz᰸᰻᰿ᱝᱩᱵᲊᲞᲬᲷ᳻᳿ᴍᵻᶑᶫᶻ᷆᷍rò΁ar;楥Ȁglrs᱈ᱍ᱒᱔ger;怠eth;愸òᄳhĀ;vᱚᱛ怐»ऊūᱡᱧarow;椏aã̕Āayᱮᱳron;䄏;䐴ƀ;ao̲ᱼᲄĀgrʿᲁr;懊tseq;橷ƀglmᲑᲔᲘ耻°䂰ta;䎴ptyv;榱ĀirᲣᲨsht;楿;쀀𝔡arĀlrᲳᲵ»ࣜ»သʀaegsv᳂͸᳖᳜᳠mƀ;oș᳊᳔ndĀ;ș᳑uit;晦amma;䏝in;拲ƀ;io᳧᳨᳸䃷de脀÷;o᳧ᳰntimes;拇nø᳷cy;䑒cɯᴆ\0\0ᴊrn;挞op;挍ʀlptuwᴘᴝᴢᵉᵕlar;䀤f;쀀𝕕ʀ;emps̋ᴭᴷᴽᵂqĀ;d͒ᴳot;扑inus;戸lus;戔quare;抡blebarwedgåúnƀadhᄮᵝᵧownarrowóᲃarpoonĀlrᵲᵶefôᲴighôᲶŢᵿᶅkaro÷གɯᶊ\0\0ᶎrn;挟op;挌ƀcotᶘᶣᶦĀryᶝᶡ;쀀𝒹;䑕l;槶rok;䄑Ādrᶰᶴot;拱iĀ;fᶺ᠖斿Āah᷀᷃ròЩaòྦangle;榦Āci᷒ᷕy;䑟grarr;柿ऀDacdefglmnopqrstuxḁḉḙḸոḼṉṡṾấắẽỡἪἷὄ὎὚ĀDoḆᴴoôᲉĀcsḎḔute耻é䃩ter;橮ȀaioyḢḧḱḶron;䄛rĀ;cḭḮ扖耻ê䃪lon;払;䑍ot;䄗ĀDrṁṅot;扒;쀀𝔢ƀ;rsṐṑṗ檚ave耻è䃨Ā;dṜṝ檖ot;檘Ȁ;ilsṪṫṲṴ檙nters;揧;愓Ā;dṹṺ檕ot;檗ƀapsẅẉẗcr;䄓tyƀ;svẒẓẕ戅et»ẓpĀ1;ẝẤĳạả;怄;怅怃ĀgsẪẬ;䅋p;怂ĀgpẴẸon;䄙f;쀀𝕖ƀalsỄỎỒrĀ;sỊị拕l;槣us;橱iƀ;lvỚớở䎵on»ớ;䏵ȀcsuvỪỳἋἣĀioữḱrc»Ḯɩỹ\0\0ỻíՈantĀglἂἆtr»ṝess»Ṻƀaeiἒ἖Ἒls;䀽st;扟vĀ;DȵἠD;橸parsl;槥ĀDaἯἳot;打rr;楱ƀcdiἾὁỸr;愯oô͒ĀahὉὋ;䎷耻ð䃰Āmrὓὗl耻ë䃫o;悬ƀcipὡὤὧl;䀡sôծĀeoὬὴctatioîՙnentialåչৡᾒ\0ᾞ\0ᾡᾧ\0\0ῆῌ\0ΐ\0ῦῪ \0 ⁚llingdotseñṄy;䑄male;晀ƀilrᾭᾳ῁lig;耀ﬃɩᾹ\0\0᾽g;耀ﬀig;耀ﬄ;쀀𝔣lig;耀ﬁlig;쀀fjƀaltῙ῜ῡt;晭ig;耀ﬂns;斱of;䆒ǰ΅\0ῳf;쀀𝕗ĀakֿῷĀ;vῼ´拔;櫙artint;樍Āao‌⁕Ācs‑⁒α‚‰‸⁅⁈\0⁐β•‥‧‪‬\0‮耻½䂽;慓耻¼䂼;慕;慙;慛Ƴ‴\0‶;慔;慖ʴ‾⁁\0\0⁃耻¾䂾;慗;慜5;慘ƶ⁌\0⁎;慚;慝8;慞l;恄wn;挢cr;쀀𝒻ࢀEabcdefgijlnorstv₂₉₟₥₰₴⃰⃵⃺⃿℃ℒℸ̗ℾ⅒↞Ā;lٍ₇;檌ƀcmpₐₕ₝ute;䇵maĀ;dₜ᳚䎳;檆reve;䄟Āiy₪₮rc;䄝;䐳ot;䄡Ȁ;lqsؾق₽⃉ƀ;qsؾٌ⃄lanô٥Ȁ;cdl٥⃒⃥⃕c;檩otĀ;o⃜⃝檀Ā;l⃢⃣檂;檄Ā;e⃪⃭쀀⋛︀s;檔r;쀀𝔤Ā;gٳ؛mel;愷cy;䑓Ȁ;Eajٚℌℎℐ;檒;檥;檤ȀEaesℛℝ℩ℴ;扩pĀ;p℣ℤ檊rox»ℤĀ;q℮ℯ檈Ā;q℮ℛim;拧pf;쀀𝕘Āci⅃ⅆr;愊mƀ;el٫ⅎ⅐;檎;檐茀>;cdlqr׮ⅠⅪⅮⅳⅹĀciⅥⅧ;檧r;橺ot;拗Par;榕uest;橼ʀadelsↄⅪ←ٖ↛ǰ↉\0↎proø₞r;楸qĀlqؿ↖lesó₈ií٫Āen↣↭rtneqq;쀀≩︀Å↪ԀAabcefkosy⇄⇇⇱⇵⇺∘∝∯≨≽ròΠȀilmr⇐⇔⇗⇛rsðᒄf»․ilôکĀdr⇠⇤cy;䑊ƀ;cwࣴ⇫⇯ir;楈;憭ar;意irc;䄥ƀalr∁∎∓rtsĀ;u∉∊晥it»∊lip;怦con;抹r;쀀𝔥sĀew∣∩arow;椥arow;椦ʀamopr∺∾≃≞≣rr;懿tht;戻kĀlr≉≓eftarrow;憩ightarrow;憪f;쀀𝕙bar;怕ƀclt≯≴≸r;쀀𝒽asè⇴rok;䄧Ābp⊂⊇ull;恃hen»ᱛૡ⊣\0⊪\0⊸⋅⋎\0⋕⋳\0\0⋸⌢⍧⍢⍿\0⎆⎪⎴cute耻í䃭ƀ;iyݱ⊰⊵rc耻î䃮;䐸Ācx⊼⊿y;䐵cl耻¡䂡ĀfrΟ⋉;쀀𝔦rave耻ì䃬Ȁ;inoܾ⋝⋩⋮Āin⋢⋦nt;樌t;戭fin;槜ta;愩lig;䄳ƀaop⋾⌚⌝ƀcgt⌅⌈⌗r;䄫ƀelpܟ⌏⌓inåގarôܠh;䄱f;抷ed;䆵ʀ;cfotӴ⌬⌱⌽⍁are;愅inĀ;t⌸⌹戞ie;槝doô⌙ʀ;celpݗ⍌⍐⍛⍡al;抺Āgr⍕⍙eróᕣã⍍arhk;樗rod;樼Ȁcgpt⍯⍲⍶⍻y;䑑on;䄯f;쀀𝕚a;䎹uest耻¿䂿Āci⎊⎏r;쀀𝒾nʀ;EdsvӴ⎛⎝⎡ӳ;拹ot;拵Ā;v⎦⎧拴;拳Ā;iݷ⎮lde;䄩ǫ⎸\0⎼cy;䑖l耻ï䃯̀cfmosu⏌⏗⏜⏡⏧⏵Āiy⏑⏕rc;䄵;䐹r;쀀𝔧ath;䈷pf;쀀𝕛ǣ⏬\0⏱r;쀀𝒿rcy;䑘kcy;䑔Ѐacfghjos␋␖␢␧␭␱␵␻ppaĀ;v␓␔䎺;䏰Āey␛␠dil;䄷;䐺r;쀀𝔨reen;䄸cy;䑅cy;䑜pf;쀀𝕜cr;쀀𝓀஀ABEHabcdefghjlmnoprstuv⑰⒁⒆⒍⒑┎┽╚▀♎♞♥♹♽⚚⚲⛘❝❨➋⟀⠁⠒ƀart⑷⑺⑼rò৆òΕail;椛arr;椎Ā;gঔ⒋;檋ar;楢ॣ⒥\0⒪\0⒱\0\0\0\0\0⒵Ⓔ\0ⓆⓈⓍ\0⓹ute;䄺mptyv;榴raîࡌbda;䎻gƀ;dlࢎⓁⓃ;榑åࢎ;檅uo耻«䂫rЀ;bfhlpst࢙ⓞⓦⓩ⓫⓮⓱⓵Ā;f࢝ⓣs;椟s;椝ë≒p;憫l;椹im;楳l;憢ƀ;ae⓿─┄檫il;椙Ā;s┉┊檭;쀀⪭︀ƀabr┕┙┝rr;椌rk;杲Āak┢┬cĀek┨┪;䁻;䁛Āes┱┳;榋lĀdu┹┻;榏;榍Ȁaeuy╆╋╖╘ron;䄾Ādi═╔il;䄼ìࢰâ┩;䐻Ȁcqrs╣╦╭╽a;椶uoĀ;rนᝆĀdu╲╷har;楧shar;楋h;憲ʀ;fgqs▋▌উ◳◿扤tʀahlrt▘▤▷◂◨rrowĀ;t࢙□aé⓶arpoonĀdu▯▴own»њp»०eftarrows;懇ightƀahs◍◖◞rrowĀ;sࣴࢧarpoonó྘quigarro÷⇰hreetimes;拋ƀ;qs▋ও◺lanôবʀ;cdgsব☊☍☝☨c;檨otĀ;o☔☕橿Ā;r☚☛檁;檃Ā;e☢☥쀀⋚︀s;檓ʀadegs☳☹☽♉♋pproøⓆot;拖qĀgq♃♅ôউgtò⒌ôছiíলƀilr♕࣡♚sht;楼;쀀𝔩Ā;Eজ♣;檑š♩♶rĀdu▲♮Ā;l॥♳;楪lk;斄cy;䑙ʀ;achtੈ⚈⚋⚑⚖rò◁orneòᴈard;楫ri;旺Āio⚟⚤dot;䅀ustĀ;a⚬⚭掰che»⚭ȀEaes⚻⚽⛉⛔;扨pĀ;p⛃⛄檉rox»⛄Ā;q⛎⛏檇Ā;q⛎⚻im;拦Ѐabnoptwz⛩⛴⛷✚✯❁❇❐Ānr⛮⛱g;柬r;懽rëࣁgƀlmr⛿✍✔eftĀar০✇ightá৲apsto;柼ightá৽parrowĀlr✥✩efô⓭ight;憬ƀafl✶✹✽r;榅;쀀𝕝us;樭imes;樴š❋❏st;戗áፎƀ;ef❗❘᠀旊nge»❘arĀ;l❤❥䀨t;榓ʀachmt❳❶❼➅➇ròࢨorneòᶌarĀ;d྘➃;業;怎ri;抿̀achiqt➘➝ੀ➢➮➻quo;怹r;쀀𝓁mƀ;egল➪➬;檍;檏Ābu┪➳oĀ;rฟ➹;怚rok;䅂萀<;cdhilqrࠫ⟒☹⟜⟠⟥⟪⟰Āci⟗⟙;檦r;橹reå◲mes;拉arr;楶uest;橻ĀPi⟵⟹ar;榖ƀ;ef⠀भ᠛旃rĀdu⠇⠍shar;楊har;楦Āen⠗⠡rtneqq;쀀≨︀Å⠞܀Dacdefhilnopsu⡀⡅⢂⢎⢓⢠⢥⢨⣚⣢⣤ઃ⣳⤂Dot;戺Ȁclpr⡎⡒⡣⡽r耻¯䂯Āet⡗⡙;時Ā;e⡞⡟朠se»⡟Ā;sျ⡨toȀ;dluျ⡳⡷⡻owîҌefôएðᏑker;斮Āoy⢇⢌mma;権;䐼ash;怔asuredangle»ᘦr;쀀𝔪o;愧ƀcdn⢯⢴⣉ro耻µ䂵Ȁ;acdᑤ⢽⣀⣄sôᚧir;櫰ot肻·Ƶusƀ;bd⣒ᤃ⣓戒Ā;uᴼ⣘;横ţ⣞⣡p;櫛ò−ðઁĀdp⣩⣮els;抧f;쀀𝕞Āct⣸⣽r;쀀𝓂pos»ᖝƀ;lm⤉⤊⤍䎼timap;抸ఀGLRVabcdefghijlmoprstuvw⥂⥓⥾⦉⦘⧚⧩⨕⨚⩘⩝⪃⪕⪤⪨⬄⬇⭄⭿⮮ⰴⱧⱼ⳩Āgt⥇⥋;쀀⋙̸Ā;v⥐௏쀀≫⃒ƀelt⥚⥲⥶ftĀar⥡⥧rrow;懍ightarrow;懎;쀀⋘̸Ā;v⥻ే쀀≪⃒ightarrow;懏ĀDd⦎⦓ash;抯ash;抮ʀbcnpt⦣⦧⦬⦱⧌la»˞ute;䅄g;쀀∠⃒ʀ;Eiop඄⦼⧀⧅⧈;쀀⩰̸d;쀀≋̸s;䅉roø඄urĀ;a⧓⧔普lĀ;s⧓ସǳ⧟\0⧣p肻 ଷmpĀ;e௹ఀʀaeouy⧴⧾⨃⨐⨓ǰ⧹\0⧻;橃on;䅈dil;䅆ngĀ;dൾ⨊ot;쀀⩭̸p;橂;䐽ash;怓΀;Aadqsxஒ⨩⨭⨻⩁⩅⩐rr;懗rĀhr⨳⨶k;椤Ā;oᏲᏰot;쀀≐̸uiöୣĀei⩊⩎ar;椨í஘istĀ;s஠டr;쀀𝔫ȀEest௅⩦⩹⩼ƀ;qs஼⩭௡ƀ;qs஼௅⩴lanô௢ií௪Ā;rஶ⪁»ஷƀAap⪊⪍⪑rò⥱rr;憮ar;櫲ƀ;svྍ⪜ྌĀ;d⪡⪢拼;拺cy;䑚΀AEadest⪷⪺⪾⫂⫅⫶⫹rò⥦;쀀≦̸rr;憚r;急Ȁ;fqs఻⫎⫣⫯tĀar⫔⫙rro÷⫁ightarro÷⪐ƀ;qs఻⪺⫪lanôౕĀ;sౕ⫴»శiíౝĀ;rవ⫾iĀ;eచథiäඐĀpt⬌⬑f;쀀𝕟膀¬;in⬙⬚⬶䂬nȀ;Edvஉ⬤⬨⬮;쀀⋹̸ot;쀀⋵̸ǡஉ⬳⬵;拷;拶iĀ;vಸ⬼ǡಸ⭁⭃;拾;拽ƀaor⭋⭣⭩rȀ;ast୻⭕⭚⭟lleì୻l;쀀⫽⃥;쀀∂̸lint;樔ƀ;ceಒ⭰⭳uåಥĀ;cಘ⭸Ā;eಒ⭽ñಘȀAait⮈⮋⮝⮧rò⦈rrƀ;cw⮔⮕⮙憛;쀀⤳̸;쀀↝̸ghtarrow»⮕riĀ;eೋೖ΀chimpqu⮽⯍⯙⬄୸⯤⯯Ȁ;cerല⯆ഷ⯉uå൅;쀀𝓃ortɭ⬅\0\0⯖ará⭖mĀ;e൮⯟Ā;q൴൳suĀbp⯫⯭å೸åഋƀbcp⯶ⰑⰙȀ;Ees⯿ⰀഢⰄ抄;쀀⫅̸etĀ;eഛⰋqĀ;qണⰀcĀ;eലⰗñസȀ;EesⰢⰣൟⰧ抅;쀀⫆̸etĀ;e൘ⰮqĀ;qൠⰣȀgilrⰽⰿⱅⱇìௗlde耻ñ䃱çృiangleĀlrⱒⱜeftĀ;eచⱚñదightĀ;eೋⱥñ೗Ā;mⱬⱭ䎽ƀ;esⱴⱵⱹ䀣ro;愖p;怇ҀDHadgilrsⲏⲔⲙⲞⲣⲰⲶⳓⳣash;抭arr;椄p;쀀≍⃒ash;抬ĀetⲨⲬ;쀀≥⃒;쀀>⃒nfin;槞ƀAetⲽⳁⳅrr;椂;쀀≤⃒Ā;rⳊⳍ쀀<⃒ie;쀀⊴⃒ĀAtⳘⳜrr;椃rie;쀀⊵⃒im;쀀∼⃒ƀAan⳰⳴ⴂrr;懖rĀhr⳺⳽k;椣Ā;oᏧᏥear;椧ቓ᪕\0\0\0\0\0\0\0\0\0\0\0\0\0ⴭ\0ⴸⵈⵠⵥ⵲ⶄᬇ\0\0ⶍⶫ\0ⷈⷎ\0ⷜ⸙⸫⸾⹃Ācsⴱ᪗ute耻ó䃳ĀiyⴼⵅrĀ;c᪞ⵂ耻ô䃴;䐾ʀabios᪠ⵒⵗǈⵚlac;䅑v;樸old;榼lig;䅓Ācr⵩⵭ir;榿;쀀𝔬ͯ⵹\0\0⵼\0ⶂn;䋛ave耻ò䃲;槁Ābmⶈ෴ar;榵Ȁacitⶕ⶘ⶥⶨrò᪀Āir⶝ⶠr;榾oss;榻nå๒;槀ƀaeiⶱⶵⶹcr;䅍ga;䏉ƀcdnⷀⷅǍron;䎿;榶pf;쀀𝕠ƀaelⷔ⷗ǒr;榷rp;榹΀;adiosvⷪⷫⷮ⸈⸍⸐⸖戨rò᪆Ȁ;efmⷷⷸ⸂⸅橝rĀ;oⷾⷿ愴f»ⷿ耻ª䂪耻º䂺gof;抶r;橖lope;橗;橛ƀclo⸟⸡⸧ò⸁ash耻ø䃸l;折iŬⸯ⸴de耻õ䃵esĀ;aǛ⸺s;樶ml耻ö䃶bar;挽ૡ⹞\0⹽\0⺀⺝\0⺢⺹\0\0⻋ຜ\0⼓\0\0⼫⾼\0⿈rȀ;astЃ⹧⹲຅脀¶;l⹭⹮䂶leìЃɩ⹸\0\0⹻m;櫳;櫽y;䐿rʀcimpt⺋⺏⺓ᡥ⺗nt;䀥od;䀮il;怰enk;怱r;쀀𝔭ƀimo⺨⺰⺴Ā;v⺭⺮䏆;䏕maô੶ne;明ƀ;tv⺿⻀⻈䏀chfork»´;䏖Āau⻏⻟nĀck⻕⻝kĀ;h⇴⻛;愎ö⇴sҀ;abcdemst⻳⻴ᤈ⻹⻽⼄⼆⼊⼎䀫cir;樣ir;樢Āouᵀ⼂;樥;橲n肻±ຝim;樦wo;樧ƀipu⼙⼠⼥ntint;樕f;쀀𝕡nd耻£䂣Ԁ;Eaceinosu່⼿⽁⽄⽇⾁⾉⾒⽾⾶;檳p;檷uå໙Ā;c໎⽌̀;acens່⽙⽟⽦⽨⽾pproø⽃urlyeñ໙ñ໎ƀaes⽯⽶⽺pprox;檹qq;檵im;拨iíໟmeĀ;s⾈ຮ怲ƀEas⽸⾐⽺ð⽵ƀdfp໬⾙⾯ƀals⾠⾥⾪lar;挮ine;挒urf;挓Ā;t໻⾴ï໻rel;抰Āci⿀⿅r;쀀𝓅;䏈ncsp;怈̀fiopsu⿚⋢⿟⿥⿫⿱r;쀀𝔮pf;쀀𝕢rime;恗cr;쀀𝓆ƀaeo⿸〉〓tĀei⿾々rnionóڰnt;樖stĀ;e【】䀿ñἙô༔઀ABHabcdefhilmnoprstux぀けさすムㄎㄫㅇㅢㅲㆎ㈆㈕㈤㈩㉘㉮㉲㊐㊰㊷ƀartぇおがròႳòϝail;検aròᱥar;楤΀cdenqrtとふへみわゔヌĀeuねぱ;쀀∽̱te;䅕iãᅮmptyv;榳gȀ;del࿑らるろ;榒;榥å࿑uo耻»䂻rր;abcfhlpstw࿜ガクシスゼゾダッデナp;極Ā;f࿠ゴs;椠;椳s;椞ë≝ð✮l;楅im;楴l;憣;憝Āaiパフil;椚oĀ;nホボ戶aló༞ƀabrョリヮrò៥rk;杳ĀakンヽcĀekヹ・;䁽;䁝Āes㄂㄄;榌lĀduㄊㄌ;榎;榐Ȁaeuyㄗㄜㄧㄩron;䅙Ādiㄡㄥil;䅗ì࿲âヺ;䑀Ȁclqsㄴㄷㄽㅄa;椷dhar;楩uoĀ;rȎȍh;憳ƀacgㅎㅟངlȀ;ipsླྀㅘㅛႜnåႻarôྩt;断ƀilrㅩဣㅮsht;楽;쀀𝔯ĀaoㅷㆆrĀduㅽㅿ»ѻĀ;l႑ㆄ;楬Ā;vㆋㆌ䏁;䏱ƀgns㆕ㇹㇼht̀ahlrstㆤㆰ㇂㇘㇤㇮rrowĀ;t࿜ㆭaéトarpoonĀduㆻㆿowîㅾp»႒eftĀah㇊㇐rrowó࿪arpoonóՑightarrows;應quigarro÷ニhreetimes;拌g;䋚ingdotseñἲƀahm㈍㈐㈓rò࿪aòՑ;怏oustĀ;a㈞㈟掱che»㈟mid;櫮Ȁabpt㈲㈽㉀㉒Ānr㈷㈺g;柭r;懾rëဃƀafl㉇㉊㉎r;榆;쀀𝕣us;樮imes;樵Āap㉝㉧rĀ;g㉣㉤䀩t;榔olint;樒arò㇣Ȁachq㉻㊀Ⴜ㊅quo;怺r;쀀𝓇Ābu・㊊oĀ;rȔȓƀhir㊗㊛㊠reåㇸmes;拊iȀ;efl㊪ၙᠡ㊫方tri;槎luhar;楨;愞ൡ㋕㋛㋟㌬㌸㍱\0㍺㎤\0\0㏬㏰\0㐨㑈㑚㒭㒱㓊㓱\0㘖\0\0㘳cute;䅛quï➺Ԁ;Eaceinpsyᇭ㋳㋵㋿㌂㌋㌏㌟㌦㌩;檴ǰ㋺\0㋼;檸on;䅡uåᇾĀ;dᇳ㌇il;䅟rc;䅝ƀEas㌖㌘㌛;檶p;檺im;择olint;樓iíሄ;䑁otƀ;be㌴ᵇ㌵担;橦΀Aacmstx㍆㍊㍗㍛㍞㍣㍭rr;懘rĀhr㍐㍒ë∨Ā;oਸ਼਴t耻§䂧i;䀻war;椩mĀin㍩ðnuóñt;朶rĀ;o㍶⁕쀀𝔰Ȁacoy㎂㎆㎑㎠rp;景Āhy㎋㎏cy;䑉;䑈rtɭ㎙\0\0㎜iäᑤaraì⹯耻­䂭Āgm㎨㎴maƀ;fv㎱㎲㎲䏃;䏂Ѐ;deglnprካ㏅㏉㏎㏖㏞㏡㏦ot;橪Ā;q኱ኰĀ;E㏓㏔檞;檠Ā;E㏛㏜檝;檟e;扆lus;樤arr;楲aròᄽȀaeit㏸㐈㐏㐗Āls㏽㐄lsetmé㍪hp;樳parsl;槤Ādlᑣ㐔e;挣Ā;e㐜㐝檪Ā;s㐢㐣檬;쀀⪬︀ƀflp㐮㐳㑂tcy;䑌Ā;b㐸㐹䀯Ā;a㐾㐿槄r;挿f;쀀𝕤aĀdr㑍ЂesĀ;u㑔㑕晠it»㑕ƀcsu㑠㑹㒟Āau㑥㑯pĀ;sᆈ㑫;쀀⊓︀pĀ;sᆴ㑵;쀀⊔︀uĀbp㑿㒏ƀ;esᆗᆜ㒆etĀ;eᆗ㒍ñᆝƀ;esᆨᆭ㒖etĀ;eᆨ㒝ñᆮƀ;afᅻ㒦ְrť㒫ֱ»ᅼaròᅈȀcemt㒹㒾㓂㓅r;쀀𝓈tmîñiì㐕aræᆾĀar㓎㓕rĀ;f㓔ឿ昆Āan㓚㓭ightĀep㓣㓪psiloîỠhé⺯s»⡒ʀbcmnp㓻㕞ሉ㖋㖎Ҁ;Edemnprs㔎㔏㔑㔕㔞㔣㔬㔱㔶抂;櫅ot;檽Ā;dᇚ㔚ot;櫃ult;櫁ĀEe㔨㔪;櫋;把lus;檿arr;楹ƀeiu㔽㕒㕕tƀ;en㔎㕅㕋qĀ;qᇚ㔏eqĀ;q㔫㔨m;櫇Ābp㕚㕜;櫕;櫓c̀;acensᇭ㕬㕲㕹㕻㌦pproø㋺urlyeñᇾñᇳƀaes㖂㖈㌛pproø㌚qñ㌗g;晪ڀ123;Edehlmnps㖩㖬㖯ሜ㖲㖴㗀㗉㗕㗚㗟㗨㗭耻¹䂹耻²䂲耻³䂳;櫆Āos㖹㖼t;檾ub;櫘Ā;dሢ㗅ot;櫄sĀou㗏㗒l;柉b;櫗arr;楻ult;櫂ĀEe㗤㗦;櫌;抋lus;櫀ƀeiu㗴㘉㘌tƀ;enሜ㗼㘂qĀ;qሢ㖲eqĀ;q㗧㗤m;櫈Ābp㘑㘓;櫔;櫖ƀAan㘜㘠㘭rr;懙rĀhr㘦㘨ë∮Ā;oਫ਩war;椪lig耻ß䃟௡㙑㙝㙠ዎ㙳㙹\0㙾㛂\0\0\0\0\0㛛㜃\0㜉㝬\0\0\0㞇ɲ㙖\0\0㙛get;挖;䏄rë๟ƀaey㙦㙫㙰ron;䅥dil;䅣;䑂lrec;挕r;쀀𝔱Ȁeiko㚆㚝㚵㚼ǲ㚋\0㚑eĀ4fኄኁaƀ;sv㚘㚙㚛䎸ym;䏑Ācn㚢㚲kĀas㚨㚮pproø዁im»ኬsðኞĀas㚺㚮ð዁rn耻þ䃾Ǭ̟㛆⋧es膀×;bd㛏㛐㛘䃗Ā;aᤏ㛕r;樱;樰ƀeps㛡㛣㜀á⩍Ȁ;bcf҆㛬㛰㛴ot;挶ir;櫱Ā;o㛹㛼쀀𝕥rk;櫚á㍢rime;怴ƀaip㜏㜒㝤dåቈ΀adempst㜡㝍㝀㝑㝗㝜㝟ngleʀ;dlqr㜰㜱㜶㝀㝂斵own»ᶻeftĀ;e⠀㜾ñम;扜ightĀ;e㊪㝋ñၚot;旬inus;樺lus;樹b;槍ime;樻ezium;揢ƀcht㝲㝽㞁Āry㝷㝻;쀀𝓉;䑆cy;䑛rok;䅧Āio㞋㞎xô᝷headĀlr㞗㞠eftarro÷ࡏightarrow»ཝऀAHabcdfghlmoprstuw㟐㟓㟗㟤㟰㟼㠎㠜㠣㠴㡑㡝㡫㢩㣌㣒㣪㣶ròϭar;楣Ācr㟜㟢ute耻ú䃺òᅐrǣ㟪\0㟭y;䑞ve;䅭Āiy㟵㟺rc耻û䃻;䑃ƀabh㠃㠆㠋ròᎭlac;䅱aòᏃĀir㠓㠘sht;楾;쀀𝔲rave耻ù䃹š㠧㠱rĀlr㠬㠮»ॗ»ႃlk;斀Āct㠹㡍ɯ㠿\0\0㡊rnĀ;e㡅㡆挜r»㡆op;挏ri;旸Āal㡖㡚cr;䅫肻¨͉Āgp㡢㡦on;䅳f;쀀𝕦̀adhlsuᅋ㡸㡽፲㢑㢠ownáᎳarpoonĀlr㢈㢌efô㠭ighô㠯iƀ;hl㢙㢚㢜䏅»ᏺon»㢚parrows;懈ƀcit㢰㣄㣈ɯ㢶\0\0㣁rnĀ;e㢼㢽挝r»㢽op;挎ng;䅯ri;旹cr;쀀𝓊ƀdir㣙㣝㣢ot;拰lde;䅩iĀ;f㜰㣨»᠓Āam㣯㣲rò㢨l耻ü䃼angle;榧ހABDacdeflnoprsz㤜㤟㤩㤭㦵㦸㦽㧟㧤㧨㧳㧹㧽㨁㨠ròϷarĀ;v㤦㤧櫨;櫩asèϡĀnr㤲㤷grt;榜΀eknprst㓣㥆㥋㥒㥝㥤㦖appá␕othinçẖƀhir㓫⻈㥙opô⾵Ā;hᎷ㥢ïㆍĀiu㥩㥭gmá㎳Ābp㥲㦄setneqĀ;q㥽㦀쀀⊊︀;쀀⫋︀setneqĀ;q㦏㦒쀀⊋︀;쀀⫌︀Āhr㦛㦟etá㚜iangleĀlr㦪㦯eft»थight»ၑy;䐲ash»ံƀelr㧄㧒㧗ƀ;beⷪ㧋㧏ar;抻q;扚lip;拮Ābt㧜ᑨaòᑩr;쀀𝔳tré㦮suĀbp㧯㧱»ജ»൙pf;쀀𝕧roð໻tré㦴Ācu㨆㨋r;쀀𝓋Ābp㨐㨘nĀEe㦀㨖»㥾nĀEe㦒㨞»㦐igzag;榚΀cefoprs㨶㨻㩖㩛㩔㩡㩪irc;䅵Ādi㩀㩑Ābg㩅㩉ar;機eĀ;qᗺ㩏;扙erp;愘r;쀀𝔴pf;쀀𝕨Ā;eᑹ㩦atèᑹcr;쀀𝓌ૣណ㪇\0㪋\0㪐㪛\0\0㪝㪨㪫㪯\0\0㫃㫎\0㫘ៜ៟tré៑r;쀀𝔵ĀAa㪔㪗ròσrò৶;䎾ĀAa㪡㪤ròθrò৫að✓is;拻ƀdptឤ㪵㪾Āfl㪺ឩ;쀀𝕩imåឲĀAa㫇㫊ròώròਁĀcq㫒ីr;쀀𝓍Āpt៖㫜ré។Ѐacefiosu㫰㫽㬈㬌㬑㬕㬛㬡cĀuy㫶㫻te耻ý䃽;䑏Āiy㬂㬆rc;䅷;䑋n耻¥䂥r;쀀𝔶cy;䑗pf;쀀𝕪cr;쀀𝓎Ācm㬦㬩y;䑎l耻ÿ䃿Ԁacdefhiosw㭂㭈㭔㭘㭤㭩㭭㭴㭺㮀cute;䅺Āay㭍㭒ron;䅾;䐷ot;䅼Āet㭝㭡træᕟa;䎶r;쀀𝔷cy;䐶grarr;懝pf;쀀𝕫cr;쀀𝓏Ājn㮅㮇;怍j;怌'.split("").map((function(e){return e.charCodeAt(0)})));})),S=m((function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.default=new Uint16Array("Ȁaglq\tɭ\0\0p;䀦os;䀧t;䀾t;䀼uot;䀢".split("").map((function(e){return e.charCodeAt(0)})));})),D=m((function(e,t){var s;Object.defineProperty(t,"__esModule",{value:!0}),t.replaceCodePoint=t.fromCodePoint=void 0;var a=new Map([[0,65533],[128,8364],[130,8218],[131,402],[132,8222],[133,8230],[134,8224],[135,8225],[136,710],[137,8240],[138,352],[139,8249],[140,338],[142,381],[145,8216],[146,8217],[147,8220],[148,8221],[149,8226],[150,8211],[151,8212],[152,732],[153,8482],[154,353],[155,8250],[156,339],[158,382],[159,376]]);function r(e){var t;return e>=55296&&e<=57343||e>1114111?65533:null!==(t=a.get(e))&&void 0!==t?t:e}t.fromCodePoint=null!==(s=String.fromCodePoint)&&void 0!==s?s:function(e){var t="";return e>65535&&(e-=65536,t+=String.fromCharCode(e>>>10&1023|55296),e=56320|1023&e),t+String.fromCharCode(e)},t.replaceCodePoint=r,t.default=function(e){return (0, t.fromCodePoint)(r(e))};})),R=m((function(e,t){var s=l&&l.__createBinding||(Object.create?function(e,t,s,a){void 0===a&&(a=s);var r=Object.getOwnPropertyDescriptor(t,s);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,a,r);}:function(e,t,s,a){void 0===a&&(a=s),e[a]=t[s];}),a=l&&l.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t});}:function(e,t){e.default=t;}),r=l&&l.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&s(t,e,r);return a(t,e),t},n=l&&l.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.decodeXML=t.decodeHTMLStrict=t.decodeHTMLAttribute=t.decodeHTML=t.determineBranch=t.EntityDecoder=t.DecodingMode=t.BinTrieFlags=t.fromCodePoint=t.replaceCodePoint=t.decodeCodePoint=t.xmlDecodeTree=t.htmlDecodeTree=void 0;var i=n(C);t.htmlDecodeTree=i.default;var o=n(S);t.xmlDecodeTree=o.default;var c=r(D);t.decodeCodePoint=c.default;var E,T,h,_,A=D;function m(e){return e>=E.ZERO&&e<=E.NINE}Object.defineProperty(t,"replaceCodePoint",{enumerable:!0,get:function(){return A.replaceCodePoint}}),Object.defineProperty(t,"fromCodePoint",{enumerable:!0,get:function(){return A.fromCodePoint}}),function(e){e[e.NUM=35]="NUM",e[e.SEMI=59]="SEMI",e[e.EQUALS=61]="EQUALS",e[e.ZERO=48]="ZERO",e[e.NINE=57]="NINE",e[e.LOWER_A=97]="LOWER_A",e[e.LOWER_F=102]="LOWER_F",e[e.LOWER_X=120]="LOWER_X",e[e.LOWER_Z=122]="LOWER_Z",e[e.UPPER_A=65]="UPPER_A",e[e.UPPER_F=70]="UPPER_F",e[e.UPPER_Z=90]="UPPER_Z";}(E||(E={})),function(e){e[e.VALUE_LENGTH=49152]="VALUE_LENGTH",e[e.BRANCH_LENGTH=16256]="BRANCH_LENGTH",e[e.JUMP_TABLE=127]="JUMP_TABLE";}(T=t.BinTrieFlags||(t.BinTrieFlags={})),function(e){e[e.EntityStart=0]="EntityStart",e[e.NumericStart=1]="NumericStart",e[e.NumericDecimal=2]="NumericDecimal",e[e.NumericHex=3]="NumericHex",e[e.NamedEntity=4]="NamedEntity";}(h||(h={})),function(e){e[e.Legacy=0]="Legacy",e[e.Strict=1]="Strict",e[e.Attribute=2]="Attribute";}(_=t.DecodingMode||(t.DecodingMode={}));var d=function(){function e(e,t,s){this.decodeTree=e,this.emitCodePoint=t,this.errors=s,this.state=h.EntityStart,this.consumed=1,this.result=0,this.treeIndex=0,this.excess=1,this.decodeMode=_.Strict;}return e.prototype.startEntity=function(e){this.decodeMode=e,this.state=h.EntityStart,this.result=0,this.treeIndex=0,this.excess=1,this.consumed=1;},e.prototype.write=function(e,t){switch(this.state){case h.EntityStart:return e.charCodeAt(t)===E.NUM?(this.state=h.NumericStart,this.consumed+=1,this.stateNumericStart(e,t+1)):(this.state=h.NamedEntity,this.stateNamedEntity(e,t));case h.NumericStart:return this.stateNumericStart(e,t);case h.NumericDecimal:return this.stateNumericDecimal(e,t);case h.NumericHex:return this.stateNumericHex(e,t);case h.NamedEntity:return this.stateNamedEntity(e,t)}},e.prototype.stateNumericStart=function(e,t){return t>=e.length?-1:(32|e.charCodeAt(t))===E.LOWER_X?(this.state=h.NumericHex,this.consumed+=1,this.stateNumericHex(e,t+1)):(this.state=h.NumericDecimal,this.stateNumericDecimal(e,t))},e.prototype.addToNumericResult=function(e,t,s,a){if(t!==s){var r=s-t;this.result=this.result*Math.pow(a,r)+parseInt(e.substr(t,r),a),this.consumed+=r;}},e.prototype.stateNumericHex=function(e,t){for(var s,a=t;t<e.length;){var r=e.charCodeAt(t);if(!(m(r)||(s=r,s>=E.UPPER_A&&s<=E.UPPER_F||s>=E.LOWER_A&&s<=E.LOWER_F)))return this.addToNumericResult(e,a,t,16),this.emitNumericEntity(r,3);t+=1;}return this.addToNumericResult(e,a,t,16),-1},e.prototype.stateNumericDecimal=function(e,t){for(var s=t;t<e.length;){var a=e.charCodeAt(t);if(!m(a))return this.addToNumericResult(e,s,t,10),this.emitNumericEntity(a,2);t+=1;}return this.addToNumericResult(e,s,t,10),-1},e.prototype.emitNumericEntity=function(e,t){var s;if(this.consumed<=t)return null===(s=this.errors)||void 0===s||s.absenceOfDigitsInNumericCharacterReference(this.consumed),0;if(e===E.SEMI)this.consumed+=1;else if(this.decodeMode===_.Strict)return 0;return this.emitCodePoint((0, c.replaceCodePoint)(this.result),this.consumed),this.errors&&(e!==E.SEMI&&this.errors.missingSemicolonAfterCharacterReference(),this.errors.validateNumericCharacterReference(this.result)),this.consumed},e.prototype.stateNamedEntity=function(e,t){for(var s=this.decodeTree,a=s[this.treeIndex],r=(a&T.VALUE_LENGTH)>>14;t<e.length;t++,this.excess++){var n=e.charCodeAt(t);if(this.treeIndex=u(s,a,this.treeIndex+Math.max(1,r),n),this.treeIndex<0)return 0===this.result||this.decodeMode===_.Attribute&&(0===r||((i=n)===E.EQUALS||function(e){return e>=E.UPPER_A&&e<=E.UPPER_Z||e>=E.LOWER_A&&e<=E.LOWER_Z||m(e)}(i)))?0:this.emitNotTerminatedNamedEntity();if(0!=(r=((a=s[this.treeIndex])&T.VALUE_LENGTH)>>14)){if(n===E.SEMI)return this.emitNamedEntityData(this.treeIndex,r,this.consumed+this.excess);this.decodeMode!==_.Strict&&(this.result=this.treeIndex,this.consumed+=this.excess,this.excess=0);}}var i;return -1},e.prototype.emitNotTerminatedNamedEntity=function(){var e,t=this.result,s=(this.decodeTree[t]&T.VALUE_LENGTH)>>14;return this.emitNamedEntityData(t,s,this.consumed),null===(e=this.errors)||void 0===e||e.missingSemicolonAfterCharacterReference(),this.consumed},e.prototype.emitNamedEntityData=function(e,t,s){var a=this.decodeTree;return this.emitCodePoint(1===t?a[e]&~T.VALUE_LENGTH:a[e+1],s),3===t&&this.emitCodePoint(a[e+2],s),s},e.prototype.end=function(){var e;switch(this.state){case h.NamedEntity:return 0===this.result||this.decodeMode===_.Attribute&&this.result!==this.treeIndex?0:this.emitNotTerminatedNamedEntity();case h.NumericDecimal:return this.emitNumericEntity(0,2);case h.NumericHex:return this.emitNumericEntity(0,3);case h.NumericStart:return null===(e=this.errors)||void 0===e||e.absenceOfDigitsInNumericCharacterReference(this.consumed),0;case h.EntityStart:return 0}},e}();function p(e){var t="",s=new d(e,(function(e){return t+=(0, c.fromCodePoint)(e)}));return function(e,a){for(var r=0,n=0;(n=e.indexOf("&",n))>=0;){t+=e.slice(r,n),s.startEntity(a);var i=s.write(e,n+1);if(i<0){r=n+s.end();break}r=n+i,n=0===i?r+1:r;}var o=t+e.slice(r);return t="",o}}function u(e,t,s,a){var r=(t&T.BRANCH_LENGTH)>>7,n=t&T.JUMP_TABLE;if(0===r)return 0!==n&&a===n?s:-1;if(n){var i=a-n;return i<0||i>=r?-1:e[s+i]-1}for(var o=s,c=o+r-1;o<=c;){var E=o+c>>>1,h=e[E];if(h<a)o=E+1;else {if(!(h>a))return e[E+r];c=E-1;}}return -1}t.EntityDecoder=d,t.determineBranch=u;var N=p(i.default),I=p(o.default);t.decodeHTML=function(e,t){return void 0===t&&(t=_.Legacy),N(e,t)},t.decodeHTMLAttribute=function(e){return N(e,_.Attribute)},t.decodeHTMLStrict=function(e){return N(e,_.Strict)},t.decodeXML=function(e){return I(e,_.Strict)};}));!function(e){e.HTML="http://www.w3.org/1999/xhtml",e.MATHML="http://www.w3.org/1998/Math/MathML",e.SVG="http://www.w3.org/2000/svg",e.XLINK="http://www.w3.org/1999/xlink",e.XML="http://www.w3.org/XML/1998/namespace",e.XMLNS="http://www.w3.org/2000/xmlns/";}(d=d||(d={})),function(e){e.TYPE="type",e.ACTION="action",e.ENCODING="encoding",e.PROMPT="prompt",e.NAME="name",e.COLOR="color",e.FACE="face",e.SIZE="size";}(p=p||(p={})),function(e){e.NO_QUIRKS="no-quirks",e.QUIRKS="quirks",e.LIMITED_QUIRKS="limited-quirks";}(u=u||(u={})),function(e){e.A="a",e.ADDRESS="address",e.ANNOTATION_XML="annotation-xml",e.APPLET="applet",e.AREA="area",e.ARTICLE="article",e.ASIDE="aside",e.B="b",e.BASE="base",e.BASEFONT="basefont",e.BGSOUND="bgsound",e.BIG="big",e.BLOCKQUOTE="blockquote",e.BODY="body",e.BR="br",e.BUTTON="button",e.CAPTION="caption",e.CENTER="center",e.CODE="code",e.COL="col",e.COLGROUP="colgroup",e.DD="dd",e.DESC="desc",e.DETAILS="details",e.DIALOG="dialog",e.DIR="dir",e.DIV="div",e.DL="dl",e.DT="dt",e.EM="em",e.EMBED="embed",e.FIELDSET="fieldset",e.FIGCAPTION="figcaption",e.FIGURE="figure",e.FONT="font",e.FOOTER="footer",e.FOREIGN_OBJECT="foreignObject",e.FORM="form",e.FRAME="frame",e.FRAMESET="frameset",e.H1="h1",e.H2="h2",e.H3="h3",e.H4="h4",e.H5="h5",e.H6="h6",e.HEAD="head",e.HEADER="header",e.HGROUP="hgroup",e.HR="hr",e.HTML="html",e.I="i",e.IMG="img",e.IMAGE="image",e.INPUT="input",e.IFRAME="iframe",e.KEYGEN="keygen",e.LABEL="label",e.LI="li",e.LINK="link",e.LISTING="listing",e.MAIN="main",e.MALIGNMARK="malignmark",e.MARQUEE="marquee",e.MATH="math",e.MENU="menu",e.META="meta",e.MGLYPH="mglyph",e.MI="mi",e.MO="mo",e.MN="mn",e.MS="ms",e.MTEXT="mtext",e.NAV="nav",e.NOBR="nobr",e.NOFRAMES="noframes",e.NOEMBED="noembed",e.NOSCRIPT="noscript",e.OBJECT="object",e.OL="ol",e.OPTGROUP="optgroup",e.OPTION="option",e.P="p",e.PARAM="param",e.PLAINTEXT="plaintext",e.PRE="pre",e.RB="rb",e.RP="rp",e.RT="rt",e.RTC="rtc",e.RUBY="ruby",e.S="s",e.SCRIPT="script",e.SECTION="section",e.SELECT="select",e.SOURCE="source",e.SMALL="small",e.SPAN="span",e.STRIKE="strike",e.STRONG="strong",e.STYLE="style",e.SUB="sub",e.SUMMARY="summary",e.SUP="sup",e.TABLE="table",e.TBODY="tbody",e.TEMPLATE="template",e.TEXTAREA="textarea",e.TFOOT="tfoot",e.TD="td",e.TH="th",e.THEAD="thead",e.TITLE="title",e.TR="tr",e.TRACK="track",e.TT="tt",e.U="u",e.UL="ul",e.SVG="svg",e.VAR="var",e.WBR="wbr",e.XMP="xmp";}(N=N||(N={})),function(e){e[e.UNKNOWN=0]="UNKNOWN",e[e.A=1]="A",e[e.ADDRESS=2]="ADDRESS",e[e.ANNOTATION_XML=3]="ANNOTATION_XML",e[e.APPLET=4]="APPLET",e[e.AREA=5]="AREA",e[e.ARTICLE=6]="ARTICLE",e[e.ASIDE=7]="ASIDE",e[e.B=8]="B",e[e.BASE=9]="BASE",e[e.BASEFONT=10]="BASEFONT",e[e.BGSOUND=11]="BGSOUND",e[e.BIG=12]="BIG",e[e.BLOCKQUOTE=13]="BLOCKQUOTE",e[e.BODY=14]="BODY",e[e.BR=15]="BR",e[e.BUTTON=16]="BUTTON",e[e.CAPTION=17]="CAPTION",e[e.CENTER=18]="CENTER",e[e.CODE=19]="CODE",e[e.COL=20]="COL",e[e.COLGROUP=21]="COLGROUP",e[e.DD=22]="DD",e[e.DESC=23]="DESC",e[e.DETAILS=24]="DETAILS",e[e.DIALOG=25]="DIALOG",e[e.DIR=26]="DIR",e[e.DIV=27]="DIV",e[e.DL=28]="DL",e[e.DT=29]="DT",e[e.EM=30]="EM",e[e.EMBED=31]="EMBED",e[e.FIELDSET=32]="FIELDSET",e[e.FIGCAPTION=33]="FIGCAPTION",e[e.FIGURE=34]="FIGURE",e[e.FONT=35]="FONT",e[e.FOOTER=36]="FOOTER",e[e.FOREIGN_OBJECT=37]="FOREIGN_OBJECT",e[e.FORM=38]="FORM",e[e.FRAME=39]="FRAME",e[e.FRAMESET=40]="FRAMESET",e[e.H1=41]="H1",e[e.H2=42]="H2",e[e.H3=43]="H3",e[e.H4=44]="H4",e[e.H5=45]="H5",e[e.H6=46]="H6",e[e.HEAD=47]="HEAD",e[e.HEADER=48]="HEADER",e[e.HGROUP=49]="HGROUP",e[e.HR=50]="HR",e[e.HTML=51]="HTML",e[e.I=52]="I",e[e.IMG=53]="IMG",e[e.IMAGE=54]="IMAGE",e[e.INPUT=55]="INPUT",e[e.IFRAME=56]="IFRAME",e[e.KEYGEN=57]="KEYGEN",e[e.LABEL=58]="LABEL",e[e.LI=59]="LI",e[e.LINK=60]="LINK",e[e.LISTING=61]="LISTING",e[e.MAIN=62]="MAIN",e[e.MALIGNMARK=63]="MALIGNMARK",e[e.MARQUEE=64]="MARQUEE",e[e.MATH=65]="MATH",e[e.MENU=66]="MENU",e[e.META=67]="META",e[e.MGLYPH=68]="MGLYPH",e[e.MI=69]="MI",e[e.MO=70]="MO",e[e.MN=71]="MN",e[e.MS=72]="MS",e[e.MTEXT=73]="MTEXT",e[e.NAV=74]="NAV",e[e.NOBR=75]="NOBR",e[e.NOFRAMES=76]="NOFRAMES",e[e.NOEMBED=77]="NOEMBED",e[e.NOSCRIPT=78]="NOSCRIPT",e[e.OBJECT=79]="OBJECT",e[e.OL=80]="OL",e[e.OPTGROUP=81]="OPTGROUP",e[e.OPTION=82]="OPTION",e[e.P=83]="P",e[e.PARAM=84]="PARAM",e[e.PLAINTEXT=85]="PLAINTEXT",e[e.PRE=86]="PRE",e[e.RB=87]="RB",e[e.RP=88]="RP",e[e.RT=89]="RT",e[e.RTC=90]="RTC",e[e.RUBY=91]="RUBY",e[e.S=92]="S",e[e.SCRIPT=93]="SCRIPT",e[e.SECTION=94]="SECTION",e[e.SELECT=95]="SELECT",e[e.SOURCE=96]="SOURCE",e[e.SMALL=97]="SMALL",e[e.SPAN=98]="SPAN",e[e.STRIKE=99]="STRIKE",e[e.STRONG=100]="STRONG",e[e.STYLE=101]="STYLE",e[e.SUB=102]="SUB",e[e.SUMMARY=103]="SUMMARY",e[e.SUP=104]="SUP",e[e.TABLE=105]="TABLE",e[e.TBODY=106]="TBODY",e[e.TEMPLATE=107]="TEMPLATE",e[e.TEXTAREA=108]="TEXTAREA",e[e.TFOOT=109]="TFOOT",e[e.TD=110]="TD",e[e.TH=111]="TH",e[e.THEAD=112]="THEAD",e[e.TITLE=113]="TITLE",e[e.TR=114]="TR",e[e.TRACK=115]="TRACK",e[e.TT=116]="TT",e[e.U=117]="U",e[e.UL=118]="UL",e[e.SVG=119]="SVG",e[e.VAR=120]="VAR",e[e.WBR=121]="WBR",e[e.XMP=122]="XMP";}(I=I||(I={}));const O=new Map([[N.A,I.A],[N.ADDRESS,I.ADDRESS],[N.ANNOTATION_XML,I.ANNOTATION_XML],[N.APPLET,I.APPLET],[N.AREA,I.AREA],[N.ARTICLE,I.ARTICLE],[N.ASIDE,I.ASIDE],[N.B,I.B],[N.BASE,I.BASE],[N.BASEFONT,I.BASEFONT],[N.BGSOUND,I.BGSOUND],[N.BIG,I.BIG],[N.BLOCKQUOTE,I.BLOCKQUOTE],[N.BODY,I.BODY],[N.BR,I.BR],[N.BUTTON,I.BUTTON],[N.CAPTION,I.CAPTION],[N.CENTER,I.CENTER],[N.CODE,I.CODE],[N.COL,I.COL],[N.COLGROUP,I.COLGROUP],[N.DD,I.DD],[N.DESC,I.DESC],[N.DETAILS,I.DETAILS],[N.DIALOG,I.DIALOG],[N.DIR,I.DIR],[N.DIV,I.DIV],[N.DL,I.DL],[N.DT,I.DT],[N.EM,I.EM],[N.EMBED,I.EMBED],[N.FIELDSET,I.FIELDSET],[N.FIGCAPTION,I.FIGCAPTION],[N.FIGURE,I.FIGURE],[N.FONT,I.FONT],[N.FOOTER,I.FOOTER],[N.FOREIGN_OBJECT,I.FOREIGN_OBJECT],[N.FORM,I.FORM],[N.FRAME,I.FRAME],[N.FRAMESET,I.FRAMESET],[N.H1,I.H1],[N.H2,I.H2],[N.H3,I.H3],[N.H4,I.H4],[N.H5,I.H5],[N.H6,I.H6],[N.HEAD,I.HEAD],[N.HEADER,I.HEADER],[N.HGROUP,I.HGROUP],[N.HR,I.HR],[N.HTML,I.HTML],[N.I,I.I],[N.IMG,I.IMG],[N.IMAGE,I.IMAGE],[N.INPUT,I.INPUT],[N.IFRAME,I.IFRAME],[N.KEYGEN,I.KEYGEN],[N.LABEL,I.LABEL],[N.LI,I.LI],[N.LINK,I.LINK],[N.LISTING,I.LISTING],[N.MAIN,I.MAIN],[N.MALIGNMARK,I.MALIGNMARK],[N.MARQUEE,I.MARQUEE],[N.MATH,I.MATH],[N.MENU,I.MENU],[N.META,I.META],[N.MGLYPH,I.MGLYPH],[N.MI,I.MI],[N.MO,I.MO],[N.MN,I.MN],[N.MS,I.MS],[N.MTEXT,I.MTEXT],[N.NAV,I.NAV],[N.NOBR,I.NOBR],[N.NOFRAMES,I.NOFRAMES],[N.NOEMBED,I.NOEMBED],[N.NOSCRIPT,I.NOSCRIPT],[N.OBJECT,I.OBJECT],[N.OL,I.OL],[N.OPTGROUP,I.OPTGROUP],[N.OPTION,I.OPTION],[N.P,I.P],[N.PARAM,I.PARAM],[N.PLAINTEXT,I.PLAINTEXT],[N.PRE,I.PRE],[N.RB,I.RB],[N.RP,I.RP],[N.RT,I.RT],[N.RTC,I.RTC],[N.RUBY,I.RUBY],[N.S,I.S],[N.SCRIPT,I.SCRIPT],[N.SECTION,I.SECTION],[N.SELECT,I.SELECT],[N.SOURCE,I.SOURCE],[N.SMALL,I.SMALL],[N.SPAN,I.SPAN],[N.STRIKE,I.STRIKE],[N.STRONG,I.STRONG],[N.STYLE,I.STYLE],[N.SUB,I.SUB],[N.SUMMARY,I.SUMMARY],[N.SUP,I.SUP],[N.TABLE,I.TABLE],[N.TBODY,I.TBODY],[N.TEMPLATE,I.TEMPLATE],[N.TEXTAREA,I.TEXTAREA],[N.TFOOT,I.TFOOT],[N.TD,I.TD],[N.TH,I.TH],[N.THEAD,I.THEAD],[N.TITLE,I.TITLE],[N.TR,I.TR],[N.TRACK,I.TRACK],[N.TT,I.TT],[N.U,I.U],[N.UL,I.UL],[N.SVG,I.SVG],[N.VAR,I.VAR],[N.WBR,I.WBR],[N.XMP,I.XMP]]);function f(e){var t;return null!==(t=O.get(e))&&void 0!==t?t:I.UNKNOWN}const L=I,M={[d.HTML]:new Set([L.ADDRESS,L.APPLET,L.AREA,L.ARTICLE,L.ASIDE,L.BASE,L.BASEFONT,L.BGSOUND,L.BLOCKQUOTE,L.BODY,L.BR,L.BUTTON,L.CAPTION,L.CENTER,L.COL,L.COLGROUP,L.DD,L.DETAILS,L.DIR,L.DIV,L.DL,L.DT,L.EMBED,L.FIELDSET,L.FIGCAPTION,L.FIGURE,L.FOOTER,L.FORM,L.FRAME,L.FRAMESET,L.H1,L.H2,L.H3,L.H4,L.H5,L.H6,L.HEAD,L.HEADER,L.HGROUP,L.HR,L.HTML,L.IFRAME,L.IMG,L.INPUT,L.LI,L.LINK,L.LISTING,L.MAIN,L.MARQUEE,L.MENU,L.META,L.NAV,L.NOEMBED,L.NOFRAMES,L.NOSCRIPT,L.OBJECT,L.OL,L.P,L.PARAM,L.PLAINTEXT,L.PRE,L.SCRIPT,L.SECTION,L.SELECT,L.SOURCE,L.STYLE,L.SUMMARY,L.TABLE,L.TBODY,L.TD,L.TEMPLATE,L.TEXTAREA,L.TFOOT,L.TH,L.THEAD,L.TITLE,L.TR,L.TRACK,L.UL,L.WBR,L.XMP]),[d.MATHML]:new Set([L.MI,L.MO,L.MN,L.MS,L.MTEXT,L.ANNOTATION_XML]),[d.SVG]:new Set([L.TITLE,L.FOREIGN_OBJECT,L.DESC]),[d.XLINK]:new Set,[d.XML]:new Set,[d.XMLNS]:new Set};function g(e){return e===L.H1||e===L.H2||e===L.H3||e===L.H4||e===L.H5||e===L.H6}new Set([N.STYLE,N.SCRIPT,N.XMP,N.IFRAME,N.NOEMBED,N.NOFRAMES,N.PLAINTEXT]);const P=new Map([[128,8364],[130,8218],[131,402],[132,8222],[133,8230],[134,8224],[135,8225],[136,710],[137,8240],[138,352],[139,8249],[140,338],[142,381],[145,8216],[146,8217],[147,8220],[148,8221],[149,8226],[150,8211],[151,8212],[152,732],[153,8482],[154,353],[155,8250],[156,339],[158,382],[159,376]]);var k;!function(e){e[e.DATA=0]="DATA",e[e.RCDATA=1]="RCDATA",e[e.RAWTEXT=2]="RAWTEXT",e[e.SCRIPT_DATA=3]="SCRIPT_DATA",e[e.PLAINTEXT=4]="PLAINTEXT",e[e.TAG_OPEN=5]="TAG_OPEN",e[e.END_TAG_OPEN=6]="END_TAG_OPEN",e[e.TAG_NAME=7]="TAG_NAME",e[e.RCDATA_LESS_THAN_SIGN=8]="RCDATA_LESS_THAN_SIGN",e[e.RCDATA_END_TAG_OPEN=9]="RCDATA_END_TAG_OPEN",e[e.RCDATA_END_TAG_NAME=10]="RCDATA_END_TAG_NAME",e[e.RAWTEXT_LESS_THAN_SIGN=11]="RAWTEXT_LESS_THAN_SIGN",e[e.RAWTEXT_END_TAG_OPEN=12]="RAWTEXT_END_TAG_OPEN",e[e.RAWTEXT_END_TAG_NAME=13]="RAWTEXT_END_TAG_NAME",e[e.SCRIPT_DATA_LESS_THAN_SIGN=14]="SCRIPT_DATA_LESS_THAN_SIGN",e[e.SCRIPT_DATA_END_TAG_OPEN=15]="SCRIPT_DATA_END_TAG_OPEN",e[e.SCRIPT_DATA_END_TAG_NAME=16]="SCRIPT_DATA_END_TAG_NAME",e[e.SCRIPT_DATA_ESCAPE_START=17]="SCRIPT_DATA_ESCAPE_START",e[e.SCRIPT_DATA_ESCAPE_START_DASH=18]="SCRIPT_DATA_ESCAPE_START_DASH",e[e.SCRIPT_DATA_ESCAPED=19]="SCRIPT_DATA_ESCAPED",e[e.SCRIPT_DATA_ESCAPED_DASH=20]="SCRIPT_DATA_ESCAPED_DASH",e[e.SCRIPT_DATA_ESCAPED_DASH_DASH=21]="SCRIPT_DATA_ESCAPED_DASH_DASH",e[e.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN=22]="SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN",e[e.SCRIPT_DATA_ESCAPED_END_TAG_OPEN=23]="SCRIPT_DATA_ESCAPED_END_TAG_OPEN",e[e.SCRIPT_DATA_ESCAPED_END_TAG_NAME=24]="SCRIPT_DATA_ESCAPED_END_TAG_NAME",e[e.SCRIPT_DATA_DOUBLE_ESCAPE_START=25]="SCRIPT_DATA_DOUBLE_ESCAPE_START",e[e.SCRIPT_DATA_DOUBLE_ESCAPED=26]="SCRIPT_DATA_DOUBLE_ESCAPED",e[e.SCRIPT_DATA_DOUBLE_ESCAPED_DASH=27]="SCRIPT_DATA_DOUBLE_ESCAPED_DASH",e[e.SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH=28]="SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH",e[e.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN=29]="SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN",e[e.SCRIPT_DATA_DOUBLE_ESCAPE_END=30]="SCRIPT_DATA_DOUBLE_ESCAPE_END",e[e.BEFORE_ATTRIBUTE_NAME=31]="BEFORE_ATTRIBUTE_NAME",e[e.ATTRIBUTE_NAME=32]="ATTRIBUTE_NAME",e[e.AFTER_ATTRIBUTE_NAME=33]="AFTER_ATTRIBUTE_NAME",e[e.BEFORE_ATTRIBUTE_VALUE=34]="BEFORE_ATTRIBUTE_VALUE",e[e.ATTRIBUTE_VALUE_DOUBLE_QUOTED=35]="ATTRIBUTE_VALUE_DOUBLE_QUOTED",e[e.ATTRIBUTE_VALUE_SINGLE_QUOTED=36]="ATTRIBUTE_VALUE_SINGLE_QUOTED",e[e.ATTRIBUTE_VALUE_UNQUOTED=37]="ATTRIBUTE_VALUE_UNQUOTED",e[e.AFTER_ATTRIBUTE_VALUE_QUOTED=38]="AFTER_ATTRIBUTE_VALUE_QUOTED",e[e.SELF_CLOSING_START_TAG=39]="SELF_CLOSING_START_TAG",e[e.BOGUS_COMMENT=40]="BOGUS_COMMENT",e[e.MARKUP_DECLARATION_OPEN=41]="MARKUP_DECLARATION_OPEN",e[e.COMMENT_START=42]="COMMENT_START",e[e.COMMENT_START_DASH=43]="COMMENT_START_DASH",e[e.COMMENT=44]="COMMENT",e[e.COMMENT_LESS_THAN_SIGN=45]="COMMENT_LESS_THAN_SIGN",e[e.COMMENT_LESS_THAN_SIGN_BANG=46]="COMMENT_LESS_THAN_SIGN_BANG",e[e.COMMENT_LESS_THAN_SIGN_BANG_DASH=47]="COMMENT_LESS_THAN_SIGN_BANG_DASH",e[e.COMMENT_LESS_THAN_SIGN_BANG_DASH_DASH=48]="COMMENT_LESS_THAN_SIGN_BANG_DASH_DASH",e[e.COMMENT_END_DASH=49]="COMMENT_END_DASH",e[e.COMMENT_END=50]="COMMENT_END",e[e.COMMENT_END_BANG=51]="COMMENT_END_BANG",e[e.DOCTYPE=52]="DOCTYPE",e[e.BEFORE_DOCTYPE_NAME=53]="BEFORE_DOCTYPE_NAME",e[e.DOCTYPE_NAME=54]="DOCTYPE_NAME",e[e.AFTER_DOCTYPE_NAME=55]="AFTER_DOCTYPE_NAME",e[e.AFTER_DOCTYPE_PUBLIC_KEYWORD=56]="AFTER_DOCTYPE_PUBLIC_KEYWORD",e[e.BEFORE_DOCTYPE_PUBLIC_IDENTIFIER=57]="BEFORE_DOCTYPE_PUBLIC_IDENTIFIER",e[e.DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED=58]="DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED",e[e.DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED=59]="DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED",e[e.AFTER_DOCTYPE_PUBLIC_IDENTIFIER=60]="AFTER_DOCTYPE_PUBLIC_IDENTIFIER",e[e.BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS=61]="BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS",e[e.AFTER_DOCTYPE_SYSTEM_KEYWORD=62]="AFTER_DOCTYPE_SYSTEM_KEYWORD",e[e.BEFORE_DOCTYPE_SYSTEM_IDENTIFIER=63]="BEFORE_DOCTYPE_SYSTEM_IDENTIFIER",e[e.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED=64]="DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED",e[e.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED=65]="DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED",e[e.AFTER_DOCTYPE_SYSTEM_IDENTIFIER=66]="AFTER_DOCTYPE_SYSTEM_IDENTIFIER",e[e.BOGUS_DOCTYPE=67]="BOGUS_DOCTYPE",e[e.CDATA_SECTION=68]="CDATA_SECTION",e[e.CDATA_SECTION_BRACKET=69]="CDATA_SECTION_BRACKET",e[e.CDATA_SECTION_END=70]="CDATA_SECTION_END",e[e.CHARACTER_REFERENCE=71]="CHARACTER_REFERENCE",e[e.NAMED_CHARACTER_REFERENCE=72]="NAMED_CHARACTER_REFERENCE",e[e.AMBIGUOUS_AMPERSAND=73]="AMBIGUOUS_AMPERSAND",e[e.NUMERIC_CHARACTER_REFERENCE=74]="NUMERIC_CHARACTER_REFERENCE",e[e.HEXADEMICAL_CHARACTER_REFERENCE_START=75]="HEXADEMICAL_CHARACTER_REFERENCE_START",e[e.HEXADEMICAL_CHARACTER_REFERENCE=76]="HEXADEMICAL_CHARACTER_REFERENCE",e[e.DECIMAL_CHARACTER_REFERENCE=77]="DECIMAL_CHARACTER_REFERENCE",e[e.NUMERIC_CHARACTER_REFERENCE_END=78]="NUMERIC_CHARACTER_REFERENCE_END";}(k||(k={}));const b={DATA:k.DATA,RCDATA:k.RCDATA,RAWTEXT:k.RAWTEXT,SCRIPT_DATA:k.SCRIPT_DATA,PLAINTEXT:k.PLAINTEXT,CDATA_SECTION:k.CDATA_SECTION};function B(e){return e>=a.DIGIT_0&&e<=a.DIGIT_9}function H(e){return e>=a.LATIN_CAPITAL_A&&e<=a.LATIN_CAPITAL_Z}function F(e){return function(e){return e>=a.LATIN_SMALL_A&&e<=a.LATIN_SMALL_Z}(e)||H(e)}function U(e){return F(e)||B(e)}function y(e){return e>=a.LATIN_CAPITAL_A&&e<=a.LATIN_CAPITAL_F}function G(e){return e>=a.LATIN_SMALL_A&&e<=a.LATIN_SMALL_F}function w(e){return e+32}function x(e){return e===a.SPACE||e===a.LINE_FEED||e===a.TABULATION||e===a.FORM_FEED}function Y(e){return x(e)||e===a.SOLIDUS||e===a.GREATER_THAN_SIGN}class v{constructor(e,t){this.options=e,this.handler=t,this.paused=!1,this.inLoop=!1,this.inForeignNode=!1,this.lastStartTagName="",this.active=!1,this.state=k.DATA,this.returnState=k.DATA,this.charRefCode=-1,this.consumedAfterSnapshot=-1,this.currentCharacterToken=null,this.currentToken=null,this.currentAttr={name:"",value:""},this.preprocessor=new _(t),this.currentLocation=this.getCurrentLocation(-1);}_err(e){var t,s;null===(s=(t=this.handler).onParseError)||void 0===s||s.call(t,this.preprocessor.getError(e));}getCurrentLocation(e){return this.options.sourceCodeLocationInfo?{startLine:this.preprocessor.line,startCol:this.preprocessor.col-e,startOffset:this.preprocessor.offset-e,endLine:-1,endCol:-1,endOffset:-1}:null}_runParsingLoop(){if(!this.inLoop){for(this.inLoop=!0;this.active&&!this.paused;){this.consumedAfterSnapshot=0;const e=this._consume();this._ensureHibernation()||this._callState(e);}this.inLoop=!1;}}pause(){this.paused=!0;}resume(e){if(!this.paused)throw new Error("Parser was already resumed");this.paused=!1,this.inLoop||(this._runParsingLoop(),this.paused||null==e||e());}write(e,t,s){this.active=!0,this.preprocessor.write(e,t),this._runParsingLoop(),this.paused||null==s||s();}insertHtmlAtCurrentPos(e){this.active=!0,this.preprocessor.insertHtmlAtCurrentPos(e),this._runParsingLoop();}_ensureHibernation(){return !!this.preprocessor.endOfChunkHit&&(this._unconsume(this.consumedAfterSnapshot),this.active=!1,!0)}_consume(){return this.consumedAfterSnapshot++,this.preprocessor.advance()}_unconsume(e){this.consumedAfterSnapshot-=e,this.preprocessor.retreat(e);}_reconsumeInState(e,t){this.state=e,this._callState(t);}_advanceBy(e){this.consumedAfterSnapshot+=e;for(let t=0;t<e;t++)this.preprocessor.advance();}_consumeSequenceIfMatch(e,t){return !!this.preprocessor.startsWith(e,t)&&(this._advanceBy(e.length-1),!0)}_createStartTagToken(){this.currentToken={type:h.START_TAG,tagName:"",tagID:I.UNKNOWN,selfClosing:!1,ackSelfClosing:!1,attrs:[],location:this.getCurrentLocation(1)};}_createEndTagToken(){this.currentToken={type:h.END_TAG,tagName:"",tagID:I.UNKNOWN,selfClosing:!1,ackSelfClosing:!1,attrs:[],location:this.getCurrentLocation(2)};}_createCommentToken(e){this.currentToken={type:h.COMMENT,data:"",location:this.getCurrentLocation(e)};}_createDoctypeToken(e){this.currentToken={type:h.DOCTYPE,name:e,forceQuirks:!1,publicId:null,systemId:null,location:this.currentLocation};}_createCharacterToken(e,t){this.currentCharacterToken={type:e,chars:t,location:this.currentLocation};}_createAttr(e){this.currentAttr={name:e,value:""},this.currentLocation=this.getCurrentLocation(0);}_leaveAttrName(){var e,t;const s=this.currentToken;null===A(s,this.currentAttr.name)?(s.attrs.push(this.currentAttr),s.location&&this.currentLocation&&((null!==(e=(t=s.location).attrs)&&void 0!==e?e:t.attrs=Object.create(null))[this.currentAttr.name]=this.currentLocation,this._leaveAttrValue())):this._err(T.duplicateAttribute);}_leaveAttrValue(){this.currentLocation&&(this.currentLocation.endLine=this.preprocessor.line,this.currentLocation.endCol=this.preprocessor.col,this.currentLocation.endOffset=this.preprocessor.offset);}prepareToken(e){this._emitCurrentCharacterToken(e.location),this.currentToken=null,e.location&&(e.location.endLine=this.preprocessor.line,e.location.endCol=this.preprocessor.col+1,e.location.endOffset=this.preprocessor.offset+1),this.currentLocation=this.getCurrentLocation(-1);}emitCurrentTagToken(){const e=this.currentToken;this.prepareToken(e),e.tagID=f(e.tagName),e.type===h.START_TAG?(this.lastStartTagName=e.tagName,this.handler.onStartTag(e)):(e.attrs.length>0&&this._err(T.endTagWithAttributes),e.selfClosing&&this._err(T.endTagWithTrailingSolidus),this.handler.onEndTag(e)),this.preprocessor.dropParsedChunk();}emitCurrentComment(e){this.prepareToken(e),this.handler.onComment(e),this.preprocessor.dropParsedChunk();}emitCurrentDoctype(e){this.prepareToken(e),this.handler.onDoctype(e),this.preprocessor.dropParsedChunk();}_emitCurrentCharacterToken(e){if(this.currentCharacterToken){switch(e&&this.currentCharacterToken.location&&(this.currentCharacterToken.location.endLine=e.startLine,this.currentCharacterToken.location.endCol=e.startCol,this.currentCharacterToken.location.endOffset=e.startOffset),this.currentCharacterToken.type){case h.CHARACTER:this.handler.onCharacter(this.currentCharacterToken);break;case h.NULL_CHARACTER:this.handler.onNullCharacter(this.currentCharacterToken);break;case h.WHITESPACE_CHARACTER:this.handler.onWhitespaceCharacter(this.currentCharacterToken);}this.currentCharacterToken=null;}}_emitEOFToken(){const e=this.getCurrentLocation(0);e&&(e.endLine=e.startLine,e.endCol=e.startCol,e.endOffset=e.startOffset),this._emitCurrentCharacterToken(e),this.handler.onEof({type:h.EOF,location:e}),this.active=!1;}_appendCharToCurrentCharacterToken(e,t){if(this.currentCharacterToken){if(this.currentCharacterToken.type===e)return void(this.currentCharacterToken.chars+=t);this.currentLocation=this.getCurrentLocation(0),this._emitCurrentCharacterToken(this.currentLocation),this.preprocessor.dropParsedChunk();}this._createCharacterToken(e,t);}_emitCodePoint(e){const t=x(e)?h.WHITESPACE_CHARACTER:e===a.NULL?h.NULL_CHARACTER:h.CHARACTER;this._appendCharToCurrentCharacterToken(t,String.fromCodePoint(e));}_emitChars(e){this._appendCharToCurrentCharacterToken(h.CHARACTER,e);}_matchNamedCharacterReference(e){let t=null,s=0,r=!1;for(let i=0,o=R.htmlDecodeTree[0];i>=0&&(i=R.determineBranch(R.htmlDecodeTree,o,i+1,e),!(i<0));e=this._consume()){s+=1,o=R.htmlDecodeTree[i];const c=o&R.BinTrieFlags.VALUE_LENGTH;if(c){const o=(c>>14)-1;if(e!==a.SEMICOLON&&this._isCharacterReferenceInAttribute()&&((n=this.preprocessor.peek(1))===a.EQUALS_SIGN||U(n))?(t=[a.AMPERSAND],i+=o):(t=0===o?[R.htmlDecodeTree[i]&~R.BinTrieFlags.VALUE_LENGTH]:1===o?[R.htmlDecodeTree[++i]]:[R.htmlDecodeTree[++i],R.htmlDecodeTree[++i]],s=0,r=e!==a.SEMICOLON),0===o){this._consume();break}}}var n;return this._unconsume(s),r&&!this.preprocessor.endOfChunkHit&&this._err(T.missingSemicolonAfterCharacterReference),this._unconsume(1),t}_isCharacterReferenceInAttribute(){return this.returnState===k.ATTRIBUTE_VALUE_DOUBLE_QUOTED||this.returnState===k.ATTRIBUTE_VALUE_SINGLE_QUOTED||this.returnState===k.ATTRIBUTE_VALUE_UNQUOTED}_flushCodePointConsumedAsCharacterReference(e){this._isCharacterReferenceInAttribute()?this.currentAttr.value+=String.fromCodePoint(e):this._emitCodePoint(e);}_callState(e){switch(this.state){case k.DATA:this._stateData(e);break;case k.RCDATA:this._stateRcdata(e);break;case k.RAWTEXT:this._stateRawtext(e);break;case k.SCRIPT_DATA:this._stateScriptData(e);break;case k.PLAINTEXT:this._statePlaintext(e);break;case k.TAG_OPEN:this._stateTagOpen(e);break;case k.END_TAG_OPEN:this._stateEndTagOpen(e);break;case k.TAG_NAME:this._stateTagName(e);break;case k.RCDATA_LESS_THAN_SIGN:this._stateRcdataLessThanSign(e);break;case k.RCDATA_END_TAG_OPEN:this._stateRcdataEndTagOpen(e);break;case k.RCDATA_END_TAG_NAME:this._stateRcdataEndTagName(e);break;case k.RAWTEXT_LESS_THAN_SIGN:this._stateRawtextLessThanSign(e);break;case k.RAWTEXT_END_TAG_OPEN:this._stateRawtextEndTagOpen(e);break;case k.RAWTEXT_END_TAG_NAME:this._stateRawtextEndTagName(e);break;case k.SCRIPT_DATA_LESS_THAN_SIGN:this._stateScriptDataLessThanSign(e);break;case k.SCRIPT_DATA_END_TAG_OPEN:this._stateScriptDataEndTagOpen(e);break;case k.SCRIPT_DATA_END_TAG_NAME:this._stateScriptDataEndTagName(e);break;case k.SCRIPT_DATA_ESCAPE_START:this._stateScriptDataEscapeStart(e);break;case k.SCRIPT_DATA_ESCAPE_START_DASH:this._stateScriptDataEscapeStartDash(e);break;case k.SCRIPT_DATA_ESCAPED:this._stateScriptDataEscaped(e);break;case k.SCRIPT_DATA_ESCAPED_DASH:this._stateScriptDataEscapedDash(e);break;case k.SCRIPT_DATA_ESCAPED_DASH_DASH:this._stateScriptDataEscapedDashDash(e);break;case k.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN:this._stateScriptDataEscapedLessThanSign(e);break;case k.SCRIPT_DATA_ESCAPED_END_TAG_OPEN:this._stateScriptDataEscapedEndTagOpen(e);break;case k.SCRIPT_DATA_ESCAPED_END_TAG_NAME:this._stateScriptDataEscapedEndTagName(e);break;case k.SCRIPT_DATA_DOUBLE_ESCAPE_START:this._stateScriptDataDoubleEscapeStart(e);break;case k.SCRIPT_DATA_DOUBLE_ESCAPED:this._stateScriptDataDoubleEscaped(e);break;case k.SCRIPT_DATA_DOUBLE_ESCAPED_DASH:this._stateScriptDataDoubleEscapedDash(e);break;case k.SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH:this._stateScriptDataDoubleEscapedDashDash(e);break;case k.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN:this._stateScriptDataDoubleEscapedLessThanSign(e);break;case k.SCRIPT_DATA_DOUBLE_ESCAPE_END:this._stateScriptDataDoubleEscapeEnd(e);break;case k.BEFORE_ATTRIBUTE_NAME:this._stateBeforeAttributeName(e);break;case k.ATTRIBUTE_NAME:this._stateAttributeName(e);break;case k.AFTER_ATTRIBUTE_NAME:this._stateAfterAttributeName(e);break;case k.BEFORE_ATTRIBUTE_VALUE:this._stateBeforeAttributeValue(e);break;case k.ATTRIBUTE_VALUE_DOUBLE_QUOTED:this._stateAttributeValueDoubleQuoted(e);break;case k.ATTRIBUTE_VALUE_SINGLE_QUOTED:this._stateAttributeValueSingleQuoted(e);break;case k.ATTRIBUTE_VALUE_UNQUOTED:this._stateAttributeValueUnquoted(e);break;case k.AFTER_ATTRIBUTE_VALUE_QUOTED:this._stateAfterAttributeValueQuoted(e);break;case k.SELF_CLOSING_START_TAG:this._stateSelfClosingStartTag(e);break;case k.BOGUS_COMMENT:this._stateBogusComment(e);break;case k.MARKUP_DECLARATION_OPEN:this._stateMarkupDeclarationOpen(e);break;case k.COMMENT_START:this._stateCommentStart(e);break;case k.COMMENT_START_DASH:this._stateCommentStartDash(e);break;case k.COMMENT:this._stateComment(e);break;case k.COMMENT_LESS_THAN_SIGN:this._stateCommentLessThanSign(e);break;case k.COMMENT_LESS_THAN_SIGN_BANG:this._stateCommentLessThanSignBang(e);break;case k.COMMENT_LESS_THAN_SIGN_BANG_DASH:this._stateCommentLessThanSignBangDash(e);break;case k.COMMENT_LESS_THAN_SIGN_BANG_DASH_DASH:this._stateCommentLessThanSignBangDashDash(e);break;case k.COMMENT_END_DASH:this._stateCommentEndDash(e);break;case k.COMMENT_END:this._stateCommentEnd(e);break;case k.COMMENT_END_BANG:this._stateCommentEndBang(e);break;case k.DOCTYPE:this._stateDoctype(e);break;case k.BEFORE_DOCTYPE_NAME:this._stateBeforeDoctypeName(e);break;case k.DOCTYPE_NAME:this._stateDoctypeName(e);break;case k.AFTER_DOCTYPE_NAME:this._stateAfterDoctypeName(e);break;case k.AFTER_DOCTYPE_PUBLIC_KEYWORD:this._stateAfterDoctypePublicKeyword(e);break;case k.BEFORE_DOCTYPE_PUBLIC_IDENTIFIER:this._stateBeforeDoctypePublicIdentifier(e);break;case k.DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED:this._stateDoctypePublicIdentifierDoubleQuoted(e);break;case k.DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED:this._stateDoctypePublicIdentifierSingleQuoted(e);break;case k.AFTER_DOCTYPE_PUBLIC_IDENTIFIER:this._stateAfterDoctypePublicIdentifier(e);break;case k.BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS:this._stateBetweenDoctypePublicAndSystemIdentifiers(e);break;case k.AFTER_DOCTYPE_SYSTEM_KEYWORD:this._stateAfterDoctypeSystemKeyword(e);break;case k.BEFORE_DOCTYPE_SYSTEM_IDENTIFIER:this._stateBeforeDoctypeSystemIdentifier(e);break;case k.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED:this._stateDoctypeSystemIdentifierDoubleQuoted(e);break;case k.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED:this._stateDoctypeSystemIdentifierSingleQuoted(e);break;case k.AFTER_DOCTYPE_SYSTEM_IDENTIFIER:this._stateAfterDoctypeSystemIdentifier(e);break;case k.BOGUS_DOCTYPE:this._stateBogusDoctype(e);break;case k.CDATA_SECTION:this._stateCdataSection(e);break;case k.CDATA_SECTION_BRACKET:this._stateCdataSectionBracket(e);break;case k.CDATA_SECTION_END:this._stateCdataSectionEnd(e);break;case k.CHARACTER_REFERENCE:this._stateCharacterReference(e);break;case k.NAMED_CHARACTER_REFERENCE:this._stateNamedCharacterReference(e);break;case k.AMBIGUOUS_AMPERSAND:this._stateAmbiguousAmpersand(e);break;case k.NUMERIC_CHARACTER_REFERENCE:this._stateNumericCharacterReference(e);break;case k.HEXADEMICAL_CHARACTER_REFERENCE_START:this._stateHexademicalCharacterReferenceStart(e);break;case k.HEXADEMICAL_CHARACTER_REFERENCE:this._stateHexademicalCharacterReference(e);break;case k.DECIMAL_CHARACTER_REFERENCE:this._stateDecimalCharacterReference(e);break;case k.NUMERIC_CHARACTER_REFERENCE_END:this._stateNumericCharacterReferenceEnd(e);break;default:throw new Error("Unknown state")}}_stateData(e){switch(e){case a.LESS_THAN_SIGN:this.state=k.TAG_OPEN;break;case a.AMPERSAND:this.returnState=k.DATA,this.state=k.CHARACTER_REFERENCE;break;case a.NULL:this._err(T.unexpectedNullCharacter),this._emitCodePoint(e);break;case a.EOF:this._emitEOFToken();break;default:this._emitCodePoint(e);}}_stateRcdata(e){switch(e){case a.AMPERSAND:this.returnState=k.RCDATA,this.state=k.CHARACTER_REFERENCE;break;case a.LESS_THAN_SIGN:this.state=k.RCDATA_LESS_THAN_SIGN;break;case a.NULL:this._err(T.unexpectedNullCharacter),this._emitChars(s);break;case a.EOF:this._emitEOFToken();break;default:this._emitCodePoint(e);}}_stateRawtext(e){switch(e){case a.LESS_THAN_SIGN:this.state=k.RAWTEXT_LESS_THAN_SIGN;break;case a.NULL:this._err(T.unexpectedNullCharacter),this._emitChars(s);break;case a.EOF:this._emitEOFToken();break;default:this._emitCodePoint(e);}}_stateScriptData(e){switch(e){case a.LESS_THAN_SIGN:this.state=k.SCRIPT_DATA_LESS_THAN_SIGN;break;case a.NULL:this._err(T.unexpectedNullCharacter),this._emitChars(s);break;case a.EOF:this._emitEOFToken();break;default:this._emitCodePoint(e);}}_statePlaintext(e){switch(e){case a.NULL:this._err(T.unexpectedNullCharacter),this._emitChars(s);break;case a.EOF:this._emitEOFToken();break;default:this._emitCodePoint(e);}}_stateTagOpen(e){if(F(e))this._createStartTagToken(),this.state=k.TAG_NAME,this._stateTagName(e);else switch(e){case a.EXCLAMATION_MARK:this.state=k.MARKUP_DECLARATION_OPEN;break;case a.SOLIDUS:this.state=k.END_TAG_OPEN;break;case a.QUESTION_MARK:this._err(T.unexpectedQuestionMarkInsteadOfTagName),this._createCommentToken(1),this.state=k.BOGUS_COMMENT,this._stateBogusComment(e);break;case a.EOF:this._err(T.eofBeforeTagName),this._emitChars("<"),this._emitEOFToken();break;default:this._err(T.invalidFirstCharacterOfTagName),this._emitChars("<"),this.state=k.DATA,this._stateData(e);}}_stateEndTagOpen(e){if(F(e))this._createEndTagToken(),this.state=k.TAG_NAME,this._stateTagName(e);else switch(e){case a.GREATER_THAN_SIGN:this._err(T.missingEndTagName),this.state=k.DATA;break;case a.EOF:this._err(T.eofBeforeTagName),this._emitChars("</"),this._emitEOFToken();break;default:this._err(T.invalidFirstCharacterOfTagName),this._createCommentToken(2),this.state=k.BOGUS_COMMENT,this._stateBogusComment(e);}}_stateTagName(e){const t=this.currentToken;switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:this.state=k.BEFORE_ATTRIBUTE_NAME;break;case a.SOLIDUS:this.state=k.SELF_CLOSING_START_TAG;break;case a.GREATER_THAN_SIGN:this.state=k.DATA,this.emitCurrentTagToken();break;case a.NULL:this._err(T.unexpectedNullCharacter),t.tagName+=s;break;case a.EOF:this._err(T.eofInTag),this._emitEOFToken();break;default:t.tagName+=String.fromCodePoint(H(e)?w(e):e);}}_stateRcdataLessThanSign(e){e===a.SOLIDUS?this.state=k.RCDATA_END_TAG_OPEN:(this._emitChars("<"),this.state=k.RCDATA,this._stateRcdata(e));}_stateRcdataEndTagOpen(e){F(e)?(this.state=k.RCDATA_END_TAG_NAME,this._stateRcdataEndTagName(e)):(this._emitChars("</"),this.state=k.RCDATA,this._stateRcdata(e));}handleSpecialEndTag(e){if(!this.preprocessor.startsWith(this.lastStartTagName,!1))return !this._ensureHibernation();switch(this._createEndTagToken(),this.currentToken.tagName=this.lastStartTagName,this.preprocessor.peek(this.lastStartTagName.length)){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:return this._advanceBy(this.lastStartTagName.length),this.state=k.BEFORE_ATTRIBUTE_NAME,!1;case a.SOLIDUS:return this._advanceBy(this.lastStartTagName.length),this.state=k.SELF_CLOSING_START_TAG,!1;case a.GREATER_THAN_SIGN:return this._advanceBy(this.lastStartTagName.length),this.emitCurrentTagToken(),this.state=k.DATA,!1;default:return !this._ensureHibernation()}}_stateRcdataEndTagName(e){this.handleSpecialEndTag(e)&&(this._emitChars("</"),this.state=k.RCDATA,this._stateRcdata(e));}_stateRawtextLessThanSign(e){e===a.SOLIDUS?this.state=k.RAWTEXT_END_TAG_OPEN:(this._emitChars("<"),this.state=k.RAWTEXT,this._stateRawtext(e));}_stateRawtextEndTagOpen(e){F(e)?(this.state=k.RAWTEXT_END_TAG_NAME,this._stateRawtextEndTagName(e)):(this._emitChars("</"),this.state=k.RAWTEXT,this._stateRawtext(e));}_stateRawtextEndTagName(e){this.handleSpecialEndTag(e)&&(this._emitChars("</"),this.state=k.RAWTEXT,this._stateRawtext(e));}_stateScriptDataLessThanSign(e){switch(e){case a.SOLIDUS:this.state=k.SCRIPT_DATA_END_TAG_OPEN;break;case a.EXCLAMATION_MARK:this.state=k.SCRIPT_DATA_ESCAPE_START,this._emitChars("<!");break;default:this._emitChars("<"),this.state=k.SCRIPT_DATA,this._stateScriptData(e);}}_stateScriptDataEndTagOpen(e){F(e)?(this.state=k.SCRIPT_DATA_END_TAG_NAME,this._stateScriptDataEndTagName(e)):(this._emitChars("</"),this.state=k.SCRIPT_DATA,this._stateScriptData(e));}_stateScriptDataEndTagName(e){this.handleSpecialEndTag(e)&&(this._emitChars("</"),this.state=k.SCRIPT_DATA,this._stateScriptData(e));}_stateScriptDataEscapeStart(e){e===a.HYPHEN_MINUS?(this.state=k.SCRIPT_DATA_ESCAPE_START_DASH,this._emitChars("-")):(this.state=k.SCRIPT_DATA,this._stateScriptData(e));}_stateScriptDataEscapeStartDash(e){e===a.HYPHEN_MINUS?(this.state=k.SCRIPT_DATA_ESCAPED_DASH_DASH,this._emitChars("-")):(this.state=k.SCRIPT_DATA,this._stateScriptData(e));}_stateScriptDataEscaped(e){switch(e){case a.HYPHEN_MINUS:this.state=k.SCRIPT_DATA_ESCAPED_DASH,this._emitChars("-");break;case a.LESS_THAN_SIGN:this.state=k.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN;break;case a.NULL:this._err(T.unexpectedNullCharacter),this._emitChars(s);break;case a.EOF:this._err(T.eofInScriptHtmlCommentLikeText),this._emitEOFToken();break;default:this._emitCodePoint(e);}}_stateScriptDataEscapedDash(e){switch(e){case a.HYPHEN_MINUS:this.state=k.SCRIPT_DATA_ESCAPED_DASH_DASH,this._emitChars("-");break;case a.LESS_THAN_SIGN:this.state=k.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN;break;case a.NULL:this._err(T.unexpectedNullCharacter),this.state=k.SCRIPT_DATA_ESCAPED,this._emitChars(s);break;case a.EOF:this._err(T.eofInScriptHtmlCommentLikeText),this._emitEOFToken();break;default:this.state=k.SCRIPT_DATA_ESCAPED,this._emitCodePoint(e);}}_stateScriptDataEscapedDashDash(e){switch(e){case a.HYPHEN_MINUS:this._emitChars("-");break;case a.LESS_THAN_SIGN:this.state=k.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN;break;case a.GREATER_THAN_SIGN:this.state=k.SCRIPT_DATA,this._emitChars(">");break;case a.NULL:this._err(T.unexpectedNullCharacter),this.state=k.SCRIPT_DATA_ESCAPED,this._emitChars(s);break;case a.EOF:this._err(T.eofInScriptHtmlCommentLikeText),this._emitEOFToken();break;default:this.state=k.SCRIPT_DATA_ESCAPED,this._emitCodePoint(e);}}_stateScriptDataEscapedLessThanSign(e){e===a.SOLIDUS?this.state=k.SCRIPT_DATA_ESCAPED_END_TAG_OPEN:F(e)?(this._emitChars("<"),this.state=k.SCRIPT_DATA_DOUBLE_ESCAPE_START,this._stateScriptDataDoubleEscapeStart(e)):(this._emitChars("<"),this.state=k.SCRIPT_DATA_ESCAPED,this._stateScriptDataEscaped(e));}_stateScriptDataEscapedEndTagOpen(e){F(e)?(this.state=k.SCRIPT_DATA_ESCAPED_END_TAG_NAME,this._stateScriptDataEscapedEndTagName(e)):(this._emitChars("</"),this.state=k.SCRIPT_DATA_ESCAPED,this._stateScriptDataEscaped(e));}_stateScriptDataEscapedEndTagName(e){this.handleSpecialEndTag(e)&&(this._emitChars("</"),this.state=k.SCRIPT_DATA_ESCAPED,this._stateScriptDataEscaped(e));}_stateScriptDataDoubleEscapeStart(e){if(this.preprocessor.startsWith(i,!1)&&Y(this.preprocessor.peek(6))){this._emitCodePoint(e);for(let e=0;e<6;e++)this._emitCodePoint(this._consume());this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED;}else this._ensureHibernation()||(this.state=k.SCRIPT_DATA_ESCAPED,this._stateScriptDataEscaped(e));}_stateScriptDataDoubleEscaped(e){switch(e){case a.HYPHEN_MINUS:this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED_DASH,this._emitChars("-");break;case a.LESS_THAN_SIGN:this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN,this._emitChars("<");break;case a.NULL:this._err(T.unexpectedNullCharacter),this._emitChars(s);break;case a.EOF:this._err(T.eofInScriptHtmlCommentLikeText),this._emitEOFToken();break;default:this._emitCodePoint(e);}}_stateScriptDataDoubleEscapedDash(e){switch(e){case a.HYPHEN_MINUS:this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH,this._emitChars("-");break;case a.LESS_THAN_SIGN:this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN,this._emitChars("<");break;case a.NULL:this._err(T.unexpectedNullCharacter),this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED,this._emitChars(s);break;case a.EOF:this._err(T.eofInScriptHtmlCommentLikeText),this._emitEOFToken();break;default:this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED,this._emitCodePoint(e);}}_stateScriptDataDoubleEscapedDashDash(e){switch(e){case a.HYPHEN_MINUS:this._emitChars("-");break;case a.LESS_THAN_SIGN:this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN,this._emitChars("<");break;case a.GREATER_THAN_SIGN:this.state=k.SCRIPT_DATA,this._emitChars(">");break;case a.NULL:this._err(T.unexpectedNullCharacter),this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED,this._emitChars(s);break;case a.EOF:this._err(T.eofInScriptHtmlCommentLikeText),this._emitEOFToken();break;default:this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED,this._emitCodePoint(e);}}_stateScriptDataDoubleEscapedLessThanSign(e){e===a.SOLIDUS?(this.state=k.SCRIPT_DATA_DOUBLE_ESCAPE_END,this._emitChars("/")):(this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED,this._stateScriptDataDoubleEscaped(e));}_stateScriptDataDoubleEscapeEnd(e){if(this.preprocessor.startsWith(i,!1)&&Y(this.preprocessor.peek(6))){this._emitCodePoint(e);for(let e=0;e<6;e++)this._emitCodePoint(this._consume());this.state=k.SCRIPT_DATA_ESCAPED;}else this._ensureHibernation()||(this.state=k.SCRIPT_DATA_DOUBLE_ESCAPED,this._stateScriptDataDoubleEscaped(e));}_stateBeforeAttributeName(e){switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:break;case a.SOLIDUS:case a.GREATER_THAN_SIGN:case a.EOF:this.state=k.AFTER_ATTRIBUTE_NAME,this._stateAfterAttributeName(e);break;case a.EQUALS_SIGN:this._err(T.unexpectedEqualsSignBeforeAttributeName),this._createAttr("="),this.state=k.ATTRIBUTE_NAME;break;default:this._createAttr(""),this.state=k.ATTRIBUTE_NAME,this._stateAttributeName(e);}}_stateAttributeName(e){switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:case a.SOLIDUS:case a.GREATER_THAN_SIGN:case a.EOF:this._leaveAttrName(),this.state=k.AFTER_ATTRIBUTE_NAME,this._stateAfterAttributeName(e);break;case a.EQUALS_SIGN:this._leaveAttrName(),this.state=k.BEFORE_ATTRIBUTE_VALUE;break;case a.QUOTATION_MARK:case a.APOSTROPHE:case a.LESS_THAN_SIGN:this._err(T.unexpectedCharacterInAttributeName),this.currentAttr.name+=String.fromCodePoint(e);break;case a.NULL:this._err(T.unexpectedNullCharacter),this.currentAttr.name+=s;break;default:this.currentAttr.name+=String.fromCodePoint(H(e)?w(e):e);}}_stateAfterAttributeName(e){switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:break;case a.SOLIDUS:this.state=k.SELF_CLOSING_START_TAG;break;case a.EQUALS_SIGN:this.state=k.BEFORE_ATTRIBUTE_VALUE;break;case a.GREATER_THAN_SIGN:this.state=k.DATA,this.emitCurrentTagToken();break;case a.EOF:this._err(T.eofInTag),this._emitEOFToken();break;default:this._createAttr(""),this.state=k.ATTRIBUTE_NAME,this._stateAttributeName(e);}}_stateBeforeAttributeValue(e){switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:break;case a.QUOTATION_MARK:this.state=k.ATTRIBUTE_VALUE_DOUBLE_QUOTED;break;case a.APOSTROPHE:this.state=k.ATTRIBUTE_VALUE_SINGLE_QUOTED;break;case a.GREATER_THAN_SIGN:this._err(T.missingAttributeValue),this.state=k.DATA,this.emitCurrentTagToken();break;default:this.state=k.ATTRIBUTE_VALUE_UNQUOTED,this._stateAttributeValueUnquoted(e);}}_stateAttributeValueDoubleQuoted(e){switch(e){case a.QUOTATION_MARK:this.state=k.AFTER_ATTRIBUTE_VALUE_QUOTED;break;case a.AMPERSAND:this.returnState=k.ATTRIBUTE_VALUE_DOUBLE_QUOTED,this.state=k.CHARACTER_REFERENCE;break;case a.NULL:this._err(T.unexpectedNullCharacter),this.currentAttr.value+=s;break;case a.EOF:this._err(T.eofInTag),this._emitEOFToken();break;default:this.currentAttr.value+=String.fromCodePoint(e);}}_stateAttributeValueSingleQuoted(e){switch(e){case a.APOSTROPHE:this.state=k.AFTER_ATTRIBUTE_VALUE_QUOTED;break;case a.AMPERSAND:this.returnState=k.ATTRIBUTE_VALUE_SINGLE_QUOTED,this.state=k.CHARACTER_REFERENCE;break;case a.NULL:this._err(T.unexpectedNullCharacter),this.currentAttr.value+=s;break;case a.EOF:this._err(T.eofInTag),this._emitEOFToken();break;default:this.currentAttr.value+=String.fromCodePoint(e);}}_stateAttributeValueUnquoted(e){switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:this._leaveAttrValue(),this.state=k.BEFORE_ATTRIBUTE_NAME;break;case a.AMPERSAND:this.returnState=k.ATTRIBUTE_VALUE_UNQUOTED,this.state=k.CHARACTER_REFERENCE;break;case a.GREATER_THAN_SIGN:this._leaveAttrValue(),this.state=k.DATA,this.emitCurrentTagToken();break;case a.NULL:this._err(T.unexpectedNullCharacter),this.currentAttr.value+=s;break;case a.QUOTATION_MARK:case a.APOSTROPHE:case a.LESS_THAN_SIGN:case a.EQUALS_SIGN:case a.GRAVE_ACCENT:this._err(T.unexpectedCharacterInUnquotedAttributeValue),this.currentAttr.value+=String.fromCodePoint(e);break;case a.EOF:this._err(T.eofInTag),this._emitEOFToken();break;default:this.currentAttr.value+=String.fromCodePoint(e);}}_stateAfterAttributeValueQuoted(e){switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:this._leaveAttrValue(),this.state=k.BEFORE_ATTRIBUTE_NAME;break;case a.SOLIDUS:this._leaveAttrValue(),this.state=k.SELF_CLOSING_START_TAG;break;case a.GREATER_THAN_SIGN:this._leaveAttrValue(),this.state=k.DATA,this.emitCurrentTagToken();break;case a.EOF:this._err(T.eofInTag),this._emitEOFToken();break;default:this._err(T.missingWhitespaceBetweenAttributes),this.state=k.BEFORE_ATTRIBUTE_NAME,this._stateBeforeAttributeName(e);}}_stateSelfClosingStartTag(e){switch(e){case a.GREATER_THAN_SIGN:this.currentToken.selfClosing=!0,this.state=k.DATA,this.emitCurrentTagToken();break;case a.EOF:this._err(T.eofInTag),this._emitEOFToken();break;default:this._err(T.unexpectedSolidusInTag),this.state=k.BEFORE_ATTRIBUTE_NAME,this._stateBeforeAttributeName(e);}}_stateBogusComment(e){const t=this.currentToken;switch(e){case a.GREATER_THAN_SIGN:this.state=k.DATA,this.emitCurrentComment(t);break;case a.EOF:this.emitCurrentComment(t),this._emitEOFToken();break;case a.NULL:this._err(T.unexpectedNullCharacter),t.data+=s;break;default:t.data+=String.fromCodePoint(e);}}_stateMarkupDeclarationOpen(e){this._consumeSequenceIfMatch("--",!0)?(this._createCommentToken(3),this.state=k.COMMENT_START):this._consumeSequenceIfMatch(n,!1)?(this.currentLocation=this.getCurrentLocation(8),this.state=k.DOCTYPE):this._consumeSequenceIfMatch(r,!0)?this.inForeignNode?this.state=k.CDATA_SECTION:(this._err(T.cdataInHtmlContent),this._createCommentToken(8),this.currentToken.data="[CDATA[",this.state=k.BOGUS_COMMENT):this._ensureHibernation()||(this._err(T.incorrectlyOpenedComment),this._createCommentToken(2),this.state=k.BOGUS_COMMENT,this._stateBogusComment(e));}_stateCommentStart(e){switch(e){case a.HYPHEN_MINUS:this.state=k.COMMENT_START_DASH;break;case a.GREATER_THAN_SIGN:{this._err(T.abruptClosingOfEmptyComment),this.state=k.DATA;const e=this.currentToken;this.emitCurrentComment(e);break}default:this.state=k.COMMENT,this._stateComment(e);}}_stateCommentStartDash(e){const t=this.currentToken;switch(e){case a.HYPHEN_MINUS:this.state=k.COMMENT_END;break;case a.GREATER_THAN_SIGN:this._err(T.abruptClosingOfEmptyComment),this.state=k.DATA,this.emitCurrentComment(t);break;case a.EOF:this._err(T.eofInComment),this.emitCurrentComment(t),this._emitEOFToken();break;default:t.data+="-",this.state=k.COMMENT,this._stateComment(e);}}_stateComment(e){const t=this.currentToken;switch(e){case a.HYPHEN_MINUS:this.state=k.COMMENT_END_DASH;break;case a.LESS_THAN_SIGN:t.data+="<",this.state=k.COMMENT_LESS_THAN_SIGN;break;case a.NULL:this._err(T.unexpectedNullCharacter),t.data+=s;break;case a.EOF:this._err(T.eofInComment),this.emitCurrentComment(t),this._emitEOFToken();break;default:t.data+=String.fromCodePoint(e);}}_stateCommentLessThanSign(e){const t=this.currentToken;switch(e){case a.EXCLAMATION_MARK:t.data+="!",this.state=k.COMMENT_LESS_THAN_SIGN_BANG;break;case a.LESS_THAN_SIGN:t.data+="<";break;default:this.state=k.COMMENT,this._stateComment(e);}}_stateCommentLessThanSignBang(e){e===a.HYPHEN_MINUS?this.state=k.COMMENT_LESS_THAN_SIGN_BANG_DASH:(this.state=k.COMMENT,this._stateComment(e));}_stateCommentLessThanSignBangDash(e){e===a.HYPHEN_MINUS?this.state=k.COMMENT_LESS_THAN_SIGN_BANG_DASH_DASH:(this.state=k.COMMENT_END_DASH,this._stateCommentEndDash(e));}_stateCommentLessThanSignBangDashDash(e){e!==a.GREATER_THAN_SIGN&&e!==a.EOF&&this._err(T.nestedComment),this.state=k.COMMENT_END,this._stateCommentEnd(e);}_stateCommentEndDash(e){const t=this.currentToken;switch(e){case a.HYPHEN_MINUS:this.state=k.COMMENT_END;break;case a.EOF:this._err(T.eofInComment),this.emitCurrentComment(t),this._emitEOFToken();break;default:t.data+="-",this.state=k.COMMENT,this._stateComment(e);}}_stateCommentEnd(e){const t=this.currentToken;switch(e){case a.GREATER_THAN_SIGN:this.state=k.DATA,this.emitCurrentComment(t);break;case a.EXCLAMATION_MARK:this.state=k.COMMENT_END_BANG;break;case a.HYPHEN_MINUS:t.data+="-";break;case a.EOF:this._err(T.eofInComment),this.emitCurrentComment(t),this._emitEOFToken();break;default:t.data+="--",this.state=k.COMMENT,this._stateComment(e);}}_stateCommentEndBang(e){const t=this.currentToken;switch(e){case a.HYPHEN_MINUS:t.data+="--!",this.state=k.COMMENT_END_DASH;break;case a.GREATER_THAN_SIGN:this._err(T.incorrectlyClosedComment),this.state=k.DATA,this.emitCurrentComment(t);break;case a.EOF:this._err(T.eofInComment),this.emitCurrentComment(t),this._emitEOFToken();break;default:t.data+="--!",this.state=k.COMMENT,this._stateComment(e);}}_stateDoctype(e){switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:this.state=k.BEFORE_DOCTYPE_NAME;break;case a.GREATER_THAN_SIGN:this.state=k.BEFORE_DOCTYPE_NAME,this._stateBeforeDoctypeName(e);break;case a.EOF:{this._err(T.eofInDoctype),this._createDoctypeToken(null);const e=this.currentToken;e.forceQuirks=!0,this.emitCurrentDoctype(e),this._emitEOFToken();break}default:this._err(T.missingWhitespaceBeforeDoctypeName),this.state=k.BEFORE_DOCTYPE_NAME,this._stateBeforeDoctypeName(e);}}_stateBeforeDoctypeName(e){if(H(e))this._createDoctypeToken(String.fromCharCode(w(e))),this.state=k.DOCTYPE_NAME;else switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:break;case a.NULL:this._err(T.unexpectedNullCharacter),this._createDoctypeToken(s),this.state=k.DOCTYPE_NAME;break;case a.GREATER_THAN_SIGN:{this._err(T.missingDoctypeName),this._createDoctypeToken(null);const e=this.currentToken;e.forceQuirks=!0,this.emitCurrentDoctype(e),this.state=k.DATA;break}case a.EOF:{this._err(T.eofInDoctype),this._createDoctypeToken(null);const e=this.currentToken;e.forceQuirks=!0,this.emitCurrentDoctype(e),this._emitEOFToken();break}default:this._createDoctypeToken(String.fromCodePoint(e)),this.state=k.DOCTYPE_NAME;}}_stateDoctypeName(e){const t=this.currentToken;switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:this.state=k.AFTER_DOCTYPE_NAME;break;case a.GREATER_THAN_SIGN:this.state=k.DATA,this.emitCurrentDoctype(t);break;case a.NULL:this._err(T.unexpectedNullCharacter),t.name+=s;break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:t.name+=String.fromCodePoint(H(e)?w(e):e);}}_stateAfterDoctypeName(e){const t=this.currentToken;switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:break;case a.GREATER_THAN_SIGN:this.state=k.DATA,this.emitCurrentDoctype(t);break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:this._consumeSequenceIfMatch("public",!1)?this.state=k.AFTER_DOCTYPE_PUBLIC_KEYWORD:this._consumeSequenceIfMatch("system",!1)?this.state=k.AFTER_DOCTYPE_SYSTEM_KEYWORD:this._ensureHibernation()||(this._err(T.invalidCharacterSequenceAfterDoctypeName),t.forceQuirks=!0,this.state=k.BOGUS_DOCTYPE,this._stateBogusDoctype(e));}}_stateAfterDoctypePublicKeyword(e){const t=this.currentToken;switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:this.state=k.BEFORE_DOCTYPE_PUBLIC_IDENTIFIER;break;case a.QUOTATION_MARK:this._err(T.missingWhitespaceAfterDoctypePublicKeyword),t.publicId="",this.state=k.DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED;break;case a.APOSTROPHE:this._err(T.missingWhitespaceAfterDoctypePublicKeyword),t.publicId="",this.state=k.DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED;break;case a.GREATER_THAN_SIGN:this._err(T.missingDoctypePublicIdentifier),t.forceQuirks=!0,this.state=k.DATA,this.emitCurrentDoctype(t);break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:this._err(T.missingQuoteBeforeDoctypePublicIdentifier),t.forceQuirks=!0,this.state=k.BOGUS_DOCTYPE,this._stateBogusDoctype(e);}}_stateBeforeDoctypePublicIdentifier(e){const t=this.currentToken;switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:break;case a.QUOTATION_MARK:t.publicId="",this.state=k.DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED;break;case a.APOSTROPHE:t.publicId="",this.state=k.DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED;break;case a.GREATER_THAN_SIGN:this._err(T.missingDoctypePublicIdentifier),t.forceQuirks=!0,this.state=k.DATA,this.emitCurrentDoctype(t);break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:this._err(T.missingQuoteBeforeDoctypePublicIdentifier),t.forceQuirks=!0,this.state=k.BOGUS_DOCTYPE,this._stateBogusDoctype(e);}}_stateDoctypePublicIdentifierDoubleQuoted(e){const t=this.currentToken;switch(e){case a.QUOTATION_MARK:this.state=k.AFTER_DOCTYPE_PUBLIC_IDENTIFIER;break;case a.NULL:this._err(T.unexpectedNullCharacter),t.publicId+=s;break;case a.GREATER_THAN_SIGN:this._err(T.abruptDoctypePublicIdentifier),t.forceQuirks=!0,this.emitCurrentDoctype(t),this.state=k.DATA;break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:t.publicId+=String.fromCodePoint(e);}}_stateDoctypePublicIdentifierSingleQuoted(e){const t=this.currentToken;switch(e){case a.APOSTROPHE:this.state=k.AFTER_DOCTYPE_PUBLIC_IDENTIFIER;break;case a.NULL:this._err(T.unexpectedNullCharacter),t.publicId+=s;break;case a.GREATER_THAN_SIGN:this._err(T.abruptDoctypePublicIdentifier),t.forceQuirks=!0,this.emitCurrentDoctype(t),this.state=k.DATA;break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:t.publicId+=String.fromCodePoint(e);}}_stateAfterDoctypePublicIdentifier(e){const t=this.currentToken;switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:this.state=k.BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS;break;case a.GREATER_THAN_SIGN:this.state=k.DATA,this.emitCurrentDoctype(t);break;case a.QUOTATION_MARK:this._err(T.missingWhitespaceBetweenDoctypePublicAndSystemIdentifiers),t.systemId="",this.state=k.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;break;case a.APOSTROPHE:this._err(T.missingWhitespaceBetweenDoctypePublicAndSystemIdentifiers),t.systemId="",this.state=k.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:this._err(T.missingQuoteBeforeDoctypeSystemIdentifier),t.forceQuirks=!0,this.state=k.BOGUS_DOCTYPE,this._stateBogusDoctype(e);}}_stateBetweenDoctypePublicAndSystemIdentifiers(e){const t=this.currentToken;switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:break;case a.GREATER_THAN_SIGN:this.emitCurrentDoctype(t),this.state=k.DATA;break;case a.QUOTATION_MARK:t.systemId="",this.state=k.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;break;case a.APOSTROPHE:t.systemId="",this.state=k.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:this._err(T.missingQuoteBeforeDoctypeSystemIdentifier),t.forceQuirks=!0,this.state=k.BOGUS_DOCTYPE,this._stateBogusDoctype(e);}}_stateAfterDoctypeSystemKeyword(e){const t=this.currentToken;switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:this.state=k.BEFORE_DOCTYPE_SYSTEM_IDENTIFIER;break;case a.QUOTATION_MARK:this._err(T.missingWhitespaceAfterDoctypeSystemKeyword),t.systemId="",this.state=k.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;break;case a.APOSTROPHE:this._err(T.missingWhitespaceAfterDoctypeSystemKeyword),t.systemId="",this.state=k.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;break;case a.GREATER_THAN_SIGN:this._err(T.missingDoctypeSystemIdentifier),t.forceQuirks=!0,this.state=k.DATA,this.emitCurrentDoctype(t);break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:this._err(T.missingQuoteBeforeDoctypeSystemIdentifier),t.forceQuirks=!0,this.state=k.BOGUS_DOCTYPE,this._stateBogusDoctype(e);}}_stateBeforeDoctypeSystemIdentifier(e){const t=this.currentToken;switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:break;case a.QUOTATION_MARK:t.systemId="",this.state=k.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;break;case a.APOSTROPHE:t.systemId="",this.state=k.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;break;case a.GREATER_THAN_SIGN:this._err(T.missingDoctypeSystemIdentifier),t.forceQuirks=!0,this.state=k.DATA,this.emitCurrentDoctype(t);break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:this._err(T.missingQuoteBeforeDoctypeSystemIdentifier),t.forceQuirks=!0,this.state=k.BOGUS_DOCTYPE,this._stateBogusDoctype(e);}}_stateDoctypeSystemIdentifierDoubleQuoted(e){const t=this.currentToken;switch(e){case a.QUOTATION_MARK:this.state=k.AFTER_DOCTYPE_SYSTEM_IDENTIFIER;break;case a.NULL:this._err(T.unexpectedNullCharacter),t.systemId+=s;break;case a.GREATER_THAN_SIGN:this._err(T.abruptDoctypeSystemIdentifier),t.forceQuirks=!0,this.emitCurrentDoctype(t),this.state=k.DATA;break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:t.systemId+=String.fromCodePoint(e);}}_stateDoctypeSystemIdentifierSingleQuoted(e){const t=this.currentToken;switch(e){case a.APOSTROPHE:this.state=k.AFTER_DOCTYPE_SYSTEM_IDENTIFIER;break;case a.NULL:this._err(T.unexpectedNullCharacter),t.systemId+=s;break;case a.GREATER_THAN_SIGN:this._err(T.abruptDoctypeSystemIdentifier),t.forceQuirks=!0,this.emitCurrentDoctype(t),this.state=k.DATA;break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:t.systemId+=String.fromCodePoint(e);}}_stateAfterDoctypeSystemIdentifier(e){const t=this.currentToken;switch(e){case a.SPACE:case a.LINE_FEED:case a.TABULATION:case a.FORM_FEED:break;case a.GREATER_THAN_SIGN:this.emitCurrentDoctype(t),this.state=k.DATA;break;case a.EOF:this._err(T.eofInDoctype),t.forceQuirks=!0,this.emitCurrentDoctype(t),this._emitEOFToken();break;default:this._err(T.unexpectedCharacterAfterDoctypeSystemIdentifier),this.state=k.BOGUS_DOCTYPE,this._stateBogusDoctype(e);}}_stateBogusDoctype(e){const t=this.currentToken;switch(e){case a.GREATER_THAN_SIGN:this.emitCurrentDoctype(t),this.state=k.DATA;break;case a.NULL:this._err(T.unexpectedNullCharacter);break;case a.EOF:this.emitCurrentDoctype(t),this._emitEOFToken();}}_stateCdataSection(e){switch(e){case a.RIGHT_SQUARE_BRACKET:this.state=k.CDATA_SECTION_BRACKET;break;case a.EOF:this._err(T.eofInCdata),this._emitEOFToken();break;default:this._emitCodePoint(e);}}_stateCdataSectionBracket(e){e===a.RIGHT_SQUARE_BRACKET?this.state=k.CDATA_SECTION_END:(this._emitChars("]"),this.state=k.CDATA_SECTION,this._stateCdataSection(e));}_stateCdataSectionEnd(e){switch(e){case a.GREATER_THAN_SIGN:this.state=k.DATA;break;case a.RIGHT_SQUARE_BRACKET:this._emitChars("]");break;default:this._emitChars("]]"),this.state=k.CDATA_SECTION,this._stateCdataSection(e);}}_stateCharacterReference(e){e===a.NUMBER_SIGN?this.state=k.NUMERIC_CHARACTER_REFERENCE:U(e)?(this.state=k.NAMED_CHARACTER_REFERENCE,this._stateNamedCharacterReference(e)):(this._flushCodePointConsumedAsCharacterReference(a.AMPERSAND),this._reconsumeInState(this.returnState,e));}_stateNamedCharacterReference(e){const t=this._matchNamedCharacterReference(e);if(this._ensureHibernation());else if(t){for(let e=0;e<t.length;e++)this._flushCodePointConsumedAsCharacterReference(t[e]);this.state=this.returnState;}else this._flushCodePointConsumedAsCharacterReference(a.AMPERSAND),this.state=k.AMBIGUOUS_AMPERSAND;}_stateAmbiguousAmpersand(e){U(e)?this._flushCodePointConsumedAsCharacterReference(e):(e===a.SEMICOLON&&this._err(T.unknownNamedCharacterReference),this._reconsumeInState(this.returnState,e));}_stateNumericCharacterReference(e){this.charRefCode=0,e===a.LATIN_SMALL_X||e===a.LATIN_CAPITAL_X?this.state=k.HEXADEMICAL_CHARACTER_REFERENCE_START:B(e)?(this.state=k.DECIMAL_CHARACTER_REFERENCE,this._stateDecimalCharacterReference(e)):(this._err(T.absenceOfDigitsInNumericCharacterReference),this._flushCodePointConsumedAsCharacterReference(a.AMPERSAND),this._flushCodePointConsumedAsCharacterReference(a.NUMBER_SIGN),this._reconsumeInState(this.returnState,e));}_stateHexademicalCharacterReferenceStart(e){!function(e){return B(e)||y(e)||G(e)}(e)?(this._err(T.absenceOfDigitsInNumericCharacterReference),this._flushCodePointConsumedAsCharacterReference(a.AMPERSAND),this._flushCodePointConsumedAsCharacterReference(a.NUMBER_SIGN),this._unconsume(2),this.state=this.returnState):(this.state=k.HEXADEMICAL_CHARACTER_REFERENCE,this._stateHexademicalCharacterReference(e));}_stateHexademicalCharacterReference(e){y(e)?this.charRefCode=16*this.charRefCode+e-55:G(e)?this.charRefCode=16*this.charRefCode+e-87:B(e)?this.charRefCode=16*this.charRefCode+e-48:e===a.SEMICOLON?this.state=k.NUMERIC_CHARACTER_REFERENCE_END:(this._err(T.missingSemicolonAfterCharacterReference),this.state=k.NUMERIC_CHARACTER_REFERENCE_END,this._stateNumericCharacterReferenceEnd(e));}_stateDecimalCharacterReference(e){B(e)?this.charRefCode=10*this.charRefCode+e-48:e===a.SEMICOLON?this.state=k.NUMERIC_CHARACTER_REFERENCE_END:(this._err(T.missingSemicolonAfterCharacterReference),this.state=k.NUMERIC_CHARACTER_REFERENCE_END,this._stateNumericCharacterReferenceEnd(e));}_stateNumericCharacterReferenceEnd(e){if(this.charRefCode===a.NULL)this._err(T.nullCharacterReference),this.charRefCode=a.REPLACEMENT_CHARACTER;else if(this.charRefCode>1114111)this._err(T.characterReferenceOutsideUnicodeRange),this.charRefCode=a.REPLACEMENT_CHARACTER;else if(o(this.charRefCode))this._err(T.surrogateCharacterReference),this.charRefCode=a.REPLACEMENT_CHARACTER;else if(E(this.charRefCode))this._err(T.noncharacterCharacterReference);else if(c(this.charRefCode)||this.charRefCode===a.CARRIAGE_RETURN){this._err(T.controlCharacterReference);const e=P.get(this.charRefCode);void 0!==e&&(this.charRefCode=e);}this._flushCodePointConsumedAsCharacterReference(this.charRefCode),this._reconsumeInState(this.returnState,e);}}const Q=new Set([I.DD,I.DT,I.LI,I.OPTGROUP,I.OPTION,I.P,I.RB,I.RP,I.RT,I.RTC]),q=new Set([...Q,I.CAPTION,I.COLGROUP,I.TBODY,I.TD,I.TFOOT,I.TH,I.THEAD,I.TR]),W=new Map([[I.APPLET,d.HTML],[I.CAPTION,d.HTML],[I.HTML,d.HTML],[I.MARQUEE,d.HTML],[I.OBJECT,d.HTML],[I.TABLE,d.HTML],[I.TD,d.HTML],[I.TEMPLATE,d.HTML],[I.TH,d.HTML],[I.ANNOTATION_XML,d.MATHML],[I.MI,d.MATHML],[I.MN,d.MATHML],[I.MO,d.MATHML],[I.MS,d.MATHML],[I.MTEXT,d.MATHML],[I.DESC,d.SVG],[I.FOREIGN_OBJECT,d.SVG],[I.TITLE,d.SVG]]),X=[I.H1,I.H2,I.H3,I.H4,I.H5,I.H6],K=[I.TR,I.TEMPLATE,I.HTML],V=[I.TBODY,I.TFOOT,I.THEAD,I.TEMPLATE,I.HTML],j=[I.TABLE,I.TEMPLATE,I.HTML],z=[I.TD,I.TH];class J{get currentTmplContentOrNode(){return this._isInTemplate()?this.treeAdapter.getTemplateContent(this.current):this.current}constructor(e,t,s){this.treeAdapter=t,this.handler=s,this.items=[],this.tagIDs=[],this.stackTop=-1,this.tmplCount=0,this.currentTagId=I.UNKNOWN,this.current=e;}_indexOf(e){return this.items.lastIndexOf(e,this.stackTop)}_isInTemplate(){return this.currentTagId===I.TEMPLATE&&this.treeAdapter.getNamespaceURI(this.current)===d.HTML}_updateCurrentElement(){this.current=this.items[this.stackTop],this.currentTagId=this.tagIDs[this.stackTop];}push(e,t){this.stackTop++,this.items[this.stackTop]=e,this.current=e,this.tagIDs[this.stackTop]=t,this.currentTagId=t,this._isInTemplate()&&this.tmplCount++,this.handler.onItemPush(e,t,!0);}pop(){const e=this.current;this.tmplCount>0&&this._isInTemplate()&&this.tmplCount--,this.stackTop--,this._updateCurrentElement(),this.handler.onItemPop(e,!0);}replace(e,t){const s=this._indexOf(e);this.items[s]=t,s===this.stackTop&&(this.current=t);}insertAfter(e,t,s){const a=this._indexOf(e)+1;this.items.splice(a,0,t),this.tagIDs.splice(a,0,s),this.stackTop++,a===this.stackTop&&this._updateCurrentElement(),this.handler.onItemPush(this.current,this.currentTagId,a===this.stackTop);}popUntilTagNamePopped(e){let t=this.stackTop+1;do{t=this.tagIDs.lastIndexOf(e,t-1);}while(t>0&&this.treeAdapter.getNamespaceURI(this.items[t])!==d.HTML);this.shortenToLength(t<0?0:t);}shortenToLength(e){for(;this.stackTop>=e;){const t=this.current;this.tmplCount>0&&this._isInTemplate()&&(this.tmplCount-=1),this.stackTop--,this._updateCurrentElement(),this.handler.onItemPop(t,this.stackTop<e);}}popUntilElementPopped(e){const t=this._indexOf(e);this.shortenToLength(t<0?0:t);}popUntilPopped(e,t){const s=this._indexOfTagNames(e,t);this.shortenToLength(s<0?0:s);}popUntilNumberedHeaderPopped(){this.popUntilPopped(X,d.HTML);}popUntilTableCellPopped(){this.popUntilPopped(z,d.HTML);}popAllUpToHtmlElement(){this.tmplCount=0,this.shortenToLength(1);}_indexOfTagNames(e,t){for(let s=this.stackTop;s>=0;s--)if(e.includes(this.tagIDs[s])&&this.treeAdapter.getNamespaceURI(this.items[s])===t)return s;return -1}clearBackTo(e,t){const s=this._indexOfTagNames(e,t);this.shortenToLength(s+1);}clearBackToTableContext(){this.clearBackTo(j,d.HTML);}clearBackToTableBodyContext(){this.clearBackTo(V,d.HTML);}clearBackToTableRowContext(){this.clearBackTo(K,d.HTML);}remove(e){const t=this._indexOf(e);t>=0&&(t===this.stackTop?this.pop():(this.items.splice(t,1),this.tagIDs.splice(t,1),this.stackTop--,this._updateCurrentElement(),this.handler.onItemPop(e,!1)));}tryPeekProperlyNestedBodyElement(){return this.stackTop>=1&&this.tagIDs[1]===I.BODY?this.items[1]:null}contains(e){return this._indexOf(e)>-1}getCommonAncestor(e){const t=this._indexOf(e)-1;return t>=0?this.items[t]:null}isRootHtmlElementCurrent(){return 0===this.stackTop&&this.tagIDs[0]===I.HTML}hasInScope(e){for(let t=this.stackTop;t>=0;t--){const s=this.tagIDs[t],a=this.treeAdapter.getNamespaceURI(this.items[t]);if(s===e&&a===d.HTML)return !0;if(W.get(s)===a)return !1}return !0}hasNumberedHeaderInScope(){for(let e=this.stackTop;e>=0;e--){const t=this.tagIDs[e],s=this.treeAdapter.getNamespaceURI(this.items[e]);if(g(t)&&s===d.HTML)return !0;if(W.get(t)===s)return !1}return !0}hasInListItemScope(e){for(let t=this.stackTop;t>=0;t--){const s=this.tagIDs[t],a=this.treeAdapter.getNamespaceURI(this.items[t]);if(s===e&&a===d.HTML)return !0;if((s===I.UL||s===I.OL)&&a===d.HTML||W.get(s)===a)return !1}return !0}hasInButtonScope(e){for(let t=this.stackTop;t>=0;t--){const s=this.tagIDs[t],a=this.treeAdapter.getNamespaceURI(this.items[t]);if(s===e&&a===d.HTML)return !0;if(s===I.BUTTON&&a===d.HTML||W.get(s)===a)return !1}return !0}hasInTableScope(e){for(let t=this.stackTop;t>=0;t--){const s=this.tagIDs[t];if(this.treeAdapter.getNamespaceURI(this.items[t])===d.HTML){if(s===e)return !0;if(s===I.TABLE||s===I.TEMPLATE||s===I.HTML)return !1}}return !0}hasTableBodyContextInTableScope(){for(let e=this.stackTop;e>=0;e--){const t=this.tagIDs[e];if(this.treeAdapter.getNamespaceURI(this.items[e])===d.HTML){if(t===I.TBODY||t===I.THEAD||t===I.TFOOT)return !0;if(t===I.TABLE||t===I.HTML)return !1}}return !0}hasInSelectScope(e){for(let t=this.stackTop;t>=0;t--){const s=this.tagIDs[t];if(this.treeAdapter.getNamespaceURI(this.items[t])===d.HTML){if(s===e)return !0;if(s!==I.OPTION&&s!==I.OPTGROUP)return !1}}return !0}generateImpliedEndTags(){for(;Q.has(this.currentTagId);)this.pop();}generateImpliedEndTagsThoroughly(){for(;q.has(this.currentTagId);)this.pop();}generateImpliedEndTagsWithExclusion(e){for(;this.currentTagId!==e&&q.has(this.currentTagId);)this.pop();}}var Z;!function(e){e[e.Marker=0]="Marker",e[e.Element=1]="Element";}(Z=Z||(Z={}));const $={type:Z.Marker};class ee{constructor(e){this.treeAdapter=e,this.entries=[],this.bookmark=null;}_getNoahArkConditionCandidates(e,t){const s=[],a=t.length,r=this.treeAdapter.getTagName(e),n=this.treeAdapter.getNamespaceURI(e);for(let e=0;e<this.entries.length;e++){const t=this.entries[e];if(t.type===Z.Marker)break;const{element:i}=t;if(this.treeAdapter.getTagName(i)===r&&this.treeAdapter.getNamespaceURI(i)===n){const t=this.treeAdapter.getAttrList(i);t.length===a&&s.push({idx:e,attrs:t});}}return s}_ensureNoahArkCondition(e){if(this.entries.length<3)return;const t=this.treeAdapter.getAttrList(e),s=this._getNoahArkConditionCandidates(e,t);if(s.length<3)return;const a=new Map(t.map((e=>[e.name,e.value])));let r=0;for(let e=0;e<s.length;e++){const t=s[e];t.attrs.every((e=>a.get(e.name)===e.value))&&(r+=1,r>=3&&this.entries.splice(t.idx,1));}}insertMarker(){this.entries.unshift($);}pushElement(e,t){this._ensureNoahArkCondition(e),this.entries.unshift({type:Z.Element,element:e,token:t});}insertElementAfterBookmark(e,t){const s=this.entries.indexOf(this.bookmark);this.entries.splice(s,0,{type:Z.Element,element:e,token:t});}removeEntry(e){const t=this.entries.indexOf(e);t>=0&&this.entries.splice(t,1);}clearToLastMarker(){const e=this.entries.indexOf($);e>=0?this.entries.splice(0,e+1):this.entries.length=0;}getElementEntryInScopeWithTagName(e){const t=this.entries.find((t=>t.type===Z.Marker||this.treeAdapter.getTagName(t.element)===e));return t&&t.type===Z.Element?t:null}getElementEntry(e){return this.entries.find((t=>t.type===Z.Element&&t.element===e))}}function te(e){return {nodeName:"#text",value:e,parentNode:null}}const se={createDocument:()=>({nodeName:"#document",mode:u.NO_QUIRKS,childNodes:[]}),createDocumentFragment:()=>({nodeName:"#document-fragment",childNodes:[]}),createElement:(e,t,s)=>({nodeName:e,tagName:e,attrs:s,namespaceURI:t,childNodes:[],parentNode:null}),createCommentNode:e=>({nodeName:"#comment",data:e,parentNode:null}),appendChild(e,t){e.childNodes.push(t),t.parentNode=e;},insertBefore(e,t,s){const a=e.childNodes.indexOf(s);e.childNodes.splice(a,0,t),t.parentNode=e;},setTemplateContent(e,t){e.content=t;},getTemplateContent:e=>e.content,setDocumentType(e,t,s,a){const r=e.childNodes.find((e=>"#documentType"===e.nodeName));if(r)r.name=t,r.publicId=s,r.systemId=a;else {const r={nodeName:"#documentType",name:t,publicId:s,systemId:a,parentNode:null};se.appendChild(e,r);}},setDocumentMode(e,t){e.mode=t;},getDocumentMode:e=>e.mode,detachNode(e){if(e.parentNode){const t=e.parentNode.childNodes.indexOf(e);e.parentNode.childNodes.splice(t,1),e.parentNode=null;}},insertText(e,t){if(e.childNodes.length>0){const s=e.childNodes[e.childNodes.length-1];if(se.isTextNode(s))return void(s.value+=t)}se.appendChild(e,te(t));},insertTextBefore(e,t,s){const a=e.childNodes[e.childNodes.indexOf(s)-1];a&&se.isTextNode(a)?a.value+=t:se.insertBefore(e,te(t),s);},adoptAttributes(e,t){const s=new Set(e.attrs.map((e=>e.name)));for(let a=0;a<t.length;a++)s.has(t[a].name)||e.attrs.push(t[a]);},getFirstChild:e=>e.childNodes[0],getChildNodes:e=>e.childNodes,getParentNode:e=>e.parentNode,getAttrList:e=>e.attrs,getTagName:e=>e.tagName,getNamespaceURI:e=>e.namespaceURI,getTextNodeContent:e=>e.value,getCommentNodeContent:e=>e.data,getDocumentTypeNodeName:e=>e.name,getDocumentTypeNodePublicId:e=>e.publicId,getDocumentTypeNodeSystemId:e=>e.systemId,isTextNode:e=>"#text"===e.nodeName,isCommentNode:e=>"#comment"===e.nodeName,isDocumentTypeNode:e=>"#documentType"===e.nodeName,isElementNode:e=>Object.prototype.hasOwnProperty.call(e,"tagName"),setNodeSourceCodeLocation(e,t){e.sourceCodeLocation=t;},getNodeSourceCodeLocation:e=>e.sourceCodeLocation,updateNodeSourceCodeLocation(e,t){e.sourceCodeLocation={...e.sourceCodeLocation,...t};}},ae="html",re=["+//silmaril//dtd html pro v0r11 19970101//","-//as//dtd html 3.0 aswedit + extensions//","-//advasoft ltd//dtd html 3.0 aswedit + extensions//","-//ietf//dtd html 2.0 level 1//","-//ietf//dtd html 2.0 level 2//","-//ietf//dtd html 2.0 strict level 1//","-//ietf//dtd html 2.0 strict level 2//","-//ietf//dtd html 2.0 strict//","-//ietf//dtd html 2.0//","-//ietf//dtd html 2.1e//","-//ietf//dtd html 3.0//","-//ietf//dtd html 3.2 final//","-//ietf//dtd html 3.2//","-//ietf//dtd html 3//","-//ietf//dtd html level 0//","-//ietf//dtd html level 1//","-//ietf//dtd html level 2//","-//ietf//dtd html level 3//","-//ietf//dtd html strict level 0//","-//ietf//dtd html strict level 1//","-//ietf//dtd html strict level 2//","-//ietf//dtd html strict level 3//","-//ietf//dtd html strict//","-//ietf//dtd html//","-//metrius//dtd metrius presentational//","-//microsoft//dtd internet explorer 2.0 html strict//","-//microsoft//dtd internet explorer 2.0 html//","-//microsoft//dtd internet explorer 2.0 tables//","-//microsoft//dtd internet explorer 3.0 html strict//","-//microsoft//dtd internet explorer 3.0 html//","-//microsoft//dtd internet explorer 3.0 tables//","-//netscape comm. corp.//dtd html//","-//netscape comm. corp.//dtd strict html//","-//o'reilly and associates//dtd html 2.0//","-//o'reilly and associates//dtd html extended 1.0//","-//o'reilly and associates//dtd html extended relaxed 1.0//","-//sq//dtd html 2.0 hotmetal + extensions//","-//softquad software//dtd hotmetal pro 6.0::19990601::extensions to html 4.0//","-//softquad//dtd hotmetal pro 4.0::19971010::extensions to html 4.0//","-//spyglass//dtd html 2.0 extended//","-//sun microsystems corp.//dtd hotjava html//","-//sun microsystems corp.//dtd hotjava strict html//","-//w3c//dtd html 3 1995-03-24//","-//w3c//dtd html 3.2 draft//","-//w3c//dtd html 3.2 final//","-//w3c//dtd html 3.2//","-//w3c//dtd html 3.2s draft//","-//w3c//dtd html 4.0 frameset//","-//w3c//dtd html 4.0 transitional//","-//w3c//dtd html experimental 19960712//","-//w3c//dtd html experimental 970421//","-//w3c//dtd w3 html//","-//w3o//dtd w3 html 3.0//","-//webtechs//dtd mozilla html 2.0//","-//webtechs//dtd mozilla html//"],ne=[...re,"-//w3c//dtd html 4.01 frameset//","-//w3c//dtd html 4.01 transitional//"],ie=new Set(["-//w3o//dtd w3 html strict 3.0//en//","-/w3c/dtd html 4.0 transitional/en","html"]),oe=["-//w3c//dtd xhtml 1.0 frameset//","-//w3c//dtd xhtml 1.0 transitional//"],ce=[...oe,"-//w3c//dtd html 4.01 frameset//","-//w3c//dtd html 4.01 transitional//"];function Ee(e,t){return t.some((t=>e.startsWith(t)))}const Te="text/html",he="application/xhtml+xml",_e="definitionurl",Ae="definitionURL",le=new Map(["attributeName","attributeType","baseFrequency","baseProfile","calcMode","clipPathUnits","diffuseConstant","edgeMode","filterUnits","glyphRef","gradientTransform","gradientUnits","kernelMatrix","kernelUnitLength","keyPoints","keySplines","keyTimes","lengthAdjust","limitingConeAngle","markerHeight","markerUnits","markerWidth","maskContentUnits","maskUnits","numOctaves","pathLength","patternContentUnits","patternTransform","patternUnits","pointsAtX","pointsAtY","pointsAtZ","preserveAlpha","preserveAspectRatio","primitiveUnits","refX","refY","repeatCount","repeatDur","requiredExtensions","requiredFeatures","specularConstant","specularExponent","spreadMethod","startOffset","stdDeviation","stitchTiles","surfaceScale","systemLanguage","tableValues","targetX","targetY","textLength","viewBox","viewTarget","xChannelSelector","yChannelSelector","zoomAndPan"].map((e=>[e.toLowerCase(),e]))),me=new Map([["xlink:actuate",{prefix:"xlink",name:"actuate",namespace:d.XLINK}],["xlink:arcrole",{prefix:"xlink",name:"arcrole",namespace:d.XLINK}],["xlink:href",{prefix:"xlink",name:"href",namespace:d.XLINK}],["xlink:role",{prefix:"xlink",name:"role",namespace:d.XLINK}],["xlink:show",{prefix:"xlink",name:"show",namespace:d.XLINK}],["xlink:title",{prefix:"xlink",name:"title",namespace:d.XLINK}],["xlink:type",{prefix:"xlink",name:"type",namespace:d.XLINK}],["xml:base",{prefix:"xml",name:"base",namespace:d.XML}],["xml:lang",{prefix:"xml",name:"lang",namespace:d.XML}],["xml:space",{prefix:"xml",name:"space",namespace:d.XML}],["xmlns",{prefix:"",name:"xmlns",namespace:d.XMLNS}],["xmlns:xlink",{prefix:"xmlns",name:"xlink",namespace:d.XMLNS}]]),de=new Map(["altGlyph","altGlyphDef","altGlyphItem","animateColor","animateMotion","animateTransform","clipPath","feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence","foreignObject","glyphRef","linearGradient","radialGradient","textPath"].map((e=>[e.toLowerCase(),e]))),pe=new Set([I.B,I.BIG,I.BLOCKQUOTE,I.BODY,I.BR,I.CENTER,I.CODE,I.DD,I.DIV,I.DL,I.DT,I.EM,I.EMBED,I.H1,I.H2,I.H3,I.H4,I.H5,I.H6,I.HEAD,I.HR,I.I,I.IMG,I.LI,I.LISTING,I.MENU,I.META,I.NOBR,I.OL,I.P,I.PRE,I.RUBY,I.S,I.SMALL,I.SPAN,I.STRONG,I.STRIKE,I.SUB,I.SUP,I.TABLE,I.TT,I.U,I.UL,I.VAR]);function ue(e){for(let t=0;t<e.attrs.length;t++)if(e.attrs[t].name===_e){e.attrs[t].name=Ae;break}}function Ne(e){for(let t=0;t<e.attrs.length;t++){const s=le.get(e.attrs[t].name);null!=s&&(e.attrs[t].name=s);}}function Ie(e){for(let t=0;t<e.attrs.length;t++){const s=me.get(e.attrs[t].name);s&&(e.attrs[t].prefix=s.prefix,e.attrs[t].name=s.name,e.attrs[t].namespace=s.namespace);}}const Ce="hidden",Se=8,De=3;var Re;!function(e){e[e.INITIAL=0]="INITIAL",e[e.BEFORE_HTML=1]="BEFORE_HTML",e[e.BEFORE_HEAD=2]="BEFORE_HEAD",e[e.IN_HEAD=3]="IN_HEAD",e[e.IN_HEAD_NO_SCRIPT=4]="IN_HEAD_NO_SCRIPT",e[e.AFTER_HEAD=5]="AFTER_HEAD",e[e.IN_BODY=6]="IN_BODY",e[e.TEXT=7]="TEXT",e[e.IN_TABLE=8]="IN_TABLE",e[e.IN_TABLE_TEXT=9]="IN_TABLE_TEXT",e[e.IN_CAPTION=10]="IN_CAPTION",e[e.IN_COLUMN_GROUP=11]="IN_COLUMN_GROUP",e[e.IN_TABLE_BODY=12]="IN_TABLE_BODY",e[e.IN_ROW=13]="IN_ROW",e[e.IN_CELL=14]="IN_CELL",e[e.IN_SELECT=15]="IN_SELECT",e[e.IN_SELECT_IN_TABLE=16]="IN_SELECT_IN_TABLE",e[e.IN_TEMPLATE=17]="IN_TEMPLATE",e[e.AFTER_BODY=18]="AFTER_BODY",e[e.IN_FRAMESET=19]="IN_FRAMESET",e[e.AFTER_FRAMESET=20]="AFTER_FRAMESET",e[e.AFTER_AFTER_BODY=21]="AFTER_AFTER_BODY",e[e.AFTER_AFTER_FRAMESET=22]="AFTER_AFTER_FRAMESET";}(Re||(Re={}));const Oe={startLine:-1,startCol:-1,startOffset:-1,endLine:-1,endCol:-1,endOffset:-1},fe=new Set([I.TABLE,I.TBODY,I.TFOOT,I.THEAD,I.TR]),Le={scriptingEnabled:!0,sourceCodeLocationInfo:!1,treeAdapter:se,onParseError:null};class Me{constructor(e,t,s=null,a=null){this.fragmentContext=s,this.scriptHandler=a,this.currentToken=null,this.stopped=!1,this.insertionMode=Re.INITIAL,this.originalInsertionMode=Re.INITIAL,this.headElement=null,this.formElement=null,this.currentNotInHTML=!1,this.tmplInsertionModeStack=[],this.pendingCharacterTokens=[],this.hasNonWhitespacePendingCharacterToken=!1,this.framesetOk=!0,this.skipNextNewLine=!1,this.fosterParentingEnabled=!1,this.options={...Le,...e},this.treeAdapter=this.options.treeAdapter,this.onParseError=this.options.onParseError,this.onParseError&&(this.options.sourceCodeLocationInfo=!0),this.document=null!=t?t:this.treeAdapter.createDocument(),this.tokenizer=new v(this.options,this),this.activeFormattingElements=new ee(this.treeAdapter),this.fragmentContextID=s?f(this.treeAdapter.getTagName(s)):I.UNKNOWN,this._setContextModes(null!=s?s:this.document,this.fragmentContextID),this.openElements=new J(this.document,this.treeAdapter,this);}static parse(e,t){const s=new this(t);return s.tokenizer.write(e,!0),s.document}static getFragmentParser(e,t){const s={...Le,...t};null!=e||(e=s.treeAdapter.createElement(N.TEMPLATE,d.HTML,[]));const a=s.treeAdapter.createElement("documentmock",d.HTML,[]),r=new this(s,a,e);return r.fragmentContextID===I.TEMPLATE&&r.tmplInsertionModeStack.unshift(Re.IN_TEMPLATE),r._initTokenizerForFragmentParsing(),r._insertFakeRootElement(),r._resetInsertionMode(),r._findFormInFragmentContext(),r}getFragment(){const e=this.treeAdapter.getFirstChild(this.document),t=this.treeAdapter.createDocumentFragment();return this._adoptNodes(e,t),t}_err(e,t,s){var a;if(!this.onParseError)return;const r=null!==(a=e.location)&&void 0!==a?a:Oe,n={code:t,startLine:r.startLine,startCol:r.startCol,startOffset:r.startOffset,endLine:s?r.startLine:r.endLine,endCol:s?r.startCol:r.endCol,endOffset:s?r.startOffset:r.endOffset};this.onParseError(n);}onItemPush(e,t,s){var a,r;null===(r=(a=this.treeAdapter).onItemPush)||void 0===r||r.call(a,e),s&&this.openElements.stackTop>0&&this._setContextModes(e,t);}onItemPop(e,t){var s,a;if(this.options.sourceCodeLocationInfo&&this._setEndLocation(e,this.currentToken),null===(a=(s=this.treeAdapter).onItemPop)||void 0===a||a.call(s,e,this.openElements.current),t){let e,t;0===this.openElements.stackTop&&this.fragmentContext?(e=this.fragmentContext,t=this.fragmentContextID):({current:e,currentTagId:t}=this.openElements),this._setContextModes(e,t);}}_setContextModes(e,t){const s=e===this.document||this.treeAdapter.getNamespaceURI(e)===d.HTML;this.currentNotInHTML=!s,this.tokenizer.inForeignNode=!s&&!this._isIntegrationPoint(t,e);}_switchToTextParsing(e,t){this._insertElement(e,d.HTML),this.tokenizer.state=t,this.originalInsertionMode=this.insertionMode,this.insertionMode=Re.TEXT;}switchToPlaintextParsing(){this.insertionMode=Re.TEXT,this.originalInsertionMode=Re.IN_BODY,this.tokenizer.state=b.PLAINTEXT;}_getAdjustedCurrentElement(){return 0===this.openElements.stackTop&&this.fragmentContext?this.fragmentContext:this.openElements.current}_findFormInFragmentContext(){let e=this.fragmentContext;for(;e;){if(this.treeAdapter.getTagName(e)===N.FORM){this.formElement=e;break}e=this.treeAdapter.getParentNode(e);}}_initTokenizerForFragmentParsing(){if(this.fragmentContext&&this.treeAdapter.getNamespaceURI(this.fragmentContext)===d.HTML)switch(this.fragmentContextID){case I.TITLE:case I.TEXTAREA:this.tokenizer.state=b.RCDATA;break;case I.STYLE:case I.XMP:case I.IFRAME:case I.NOEMBED:case I.NOFRAMES:case I.NOSCRIPT:this.tokenizer.state=b.RAWTEXT;break;case I.SCRIPT:this.tokenizer.state=b.SCRIPT_DATA;break;case I.PLAINTEXT:this.tokenizer.state=b.PLAINTEXT;}}_setDocumentType(e){const t=e.name||"",s=e.publicId||"",a=e.systemId||"";if(this.treeAdapter.setDocumentType(this.document,t,s,a),e.location){const t=this.treeAdapter.getChildNodes(this.document).find((e=>this.treeAdapter.isDocumentTypeNode(e)));t&&this.treeAdapter.setNodeSourceCodeLocation(t,e.location);}}_attachElementToTree(e,t){if(this.options.sourceCodeLocationInfo){const s=t&&{...t,startTag:t};this.treeAdapter.setNodeSourceCodeLocation(e,s);}if(this._shouldFosterParentOnInsertion())this._fosterParentElement(e);else {const t=this.openElements.currentTmplContentOrNode;this.treeAdapter.appendChild(t,e);}}_appendElement(e,t){const s=this.treeAdapter.createElement(e.tagName,t,e.attrs);this._attachElementToTree(s,e.location);}_insertElement(e,t){const s=this.treeAdapter.createElement(e.tagName,t,e.attrs);this._attachElementToTree(s,e.location),this.openElements.push(s,e.tagID);}_insertFakeElement(e,t){const s=this.treeAdapter.createElement(e,d.HTML,[]);this._attachElementToTree(s,null),this.openElements.push(s,t);}_insertTemplate(e){const t=this.treeAdapter.createElement(e.tagName,d.HTML,e.attrs),s=this.treeAdapter.createDocumentFragment();this.treeAdapter.setTemplateContent(t,s),this._attachElementToTree(t,e.location),this.openElements.push(t,e.tagID),this.options.sourceCodeLocationInfo&&this.treeAdapter.setNodeSourceCodeLocation(s,null);}_insertFakeRootElement(){const e=this.treeAdapter.createElement(N.HTML,d.HTML,[]);this.options.sourceCodeLocationInfo&&this.treeAdapter.setNodeSourceCodeLocation(e,null),this.treeAdapter.appendChild(this.openElements.current,e),this.openElements.push(e,I.HTML);}_appendCommentNode(e,t){const s=this.treeAdapter.createCommentNode(e.data);this.treeAdapter.appendChild(t,s),this.options.sourceCodeLocationInfo&&this.treeAdapter.setNodeSourceCodeLocation(s,e.location);}_insertCharacters(e){let t,s;if(this._shouldFosterParentOnInsertion()?(({parent:t,beforeElement:s}=this._findFosterParentingLocation()),s?this.treeAdapter.insertTextBefore(t,e.chars,s):this.treeAdapter.insertText(t,e.chars)):(t=this.openElements.currentTmplContentOrNode,this.treeAdapter.insertText(t,e.chars)),!e.location)return;const a=this.treeAdapter.getChildNodes(t),r=s?a.lastIndexOf(s):a.length,n=a[r-1];if(this.treeAdapter.getNodeSourceCodeLocation(n)){const{endLine:t,endCol:s,endOffset:a}=e.location;this.treeAdapter.updateNodeSourceCodeLocation(n,{endLine:t,endCol:s,endOffset:a});}else this.options.sourceCodeLocationInfo&&this.treeAdapter.setNodeSourceCodeLocation(n,e.location);}_adoptNodes(e,t){for(let s=this.treeAdapter.getFirstChild(e);s;s=this.treeAdapter.getFirstChild(e))this.treeAdapter.detachNode(s),this.treeAdapter.appendChild(t,s);}_setEndLocation(e,t){if(this.treeAdapter.getNodeSourceCodeLocation(e)&&t.location){const s=t.location,a=this.treeAdapter.getTagName(e),r=t.type===h.END_TAG&&a===t.tagName?{endTag:{...s},endLine:s.endLine,endCol:s.endCol,endOffset:s.endOffset}:{endLine:s.startLine,endCol:s.startCol,endOffset:s.startOffset};this.treeAdapter.updateNodeSourceCodeLocation(e,r);}}shouldProcessStartTagTokenInForeignContent(e){if(!this.currentNotInHTML)return !1;let t,s;return 0===this.openElements.stackTop&&this.fragmentContext?(t=this.fragmentContext,s=this.fragmentContextID):({current:t,currentTagId:s}=this.openElements),(e.tagID!==I.SVG||this.treeAdapter.getTagName(t)!==N.ANNOTATION_XML||this.treeAdapter.getNamespaceURI(t)!==d.MATHML)&&(this.tokenizer.inForeignNode||(e.tagID===I.MGLYPH||e.tagID===I.MALIGNMARK)&&!this._isIntegrationPoint(s,t,d.HTML))}_processToken(e){switch(e.type){case h.CHARACTER:this.onCharacter(e);break;case h.NULL_CHARACTER:this.onNullCharacter(e);break;case h.COMMENT:this.onComment(e);break;case h.DOCTYPE:this.onDoctype(e);break;case h.START_TAG:this._processStartTag(e);break;case h.END_TAG:this.onEndTag(e);break;case h.EOF:this.onEof(e);break;case h.WHITESPACE_CHARACTER:this.onWhitespaceCharacter(e);}}_isIntegrationPoint(e,t,s){return function(e,t,s,a){return (!a||a===d.HTML)&&function(e,t,s){if(t===d.MATHML&&e===I.ANNOTATION_XML)for(let e=0;e<s.length;e++)if(s[e].name===p.ENCODING){const t=s[e].value.toLowerCase();return t===Te||t===he}return t===d.SVG&&(e===I.FOREIGN_OBJECT||e===I.DESC||e===I.TITLE)}(e,t,s)||(!a||a===d.MATHML)&&function(e,t){return t===d.MATHML&&(e===I.MI||e===I.MO||e===I.MN||e===I.MS||e===I.MTEXT)}(e,t)}(e,this.treeAdapter.getNamespaceURI(t),this.treeAdapter.getAttrList(t),s)}_reconstructActiveFormattingElements(){const e=this.activeFormattingElements.entries.length;if(e){const t=this.activeFormattingElements.entries.findIndex((e=>e.type===Z.Marker||this.openElements.contains(e.element)));for(let s=t<0?e-1:t-1;s>=0;s--){const e=this.activeFormattingElements.entries[s];this._insertElement(e.token,this.treeAdapter.getNamespaceURI(e.element)),e.element=this.openElements.current;}}}_closeTableCell(){this.openElements.generateImpliedEndTags(),this.openElements.popUntilTableCellPopped(),this.activeFormattingElements.clearToLastMarker(),this.insertionMode=Re.IN_ROW;}_closePElement(){this.openElements.generateImpliedEndTagsWithExclusion(I.P),this.openElements.popUntilTagNamePopped(I.P);}_resetInsertionMode(){for(let e=this.openElements.stackTop;e>=0;e--)switch(0===e&&this.fragmentContext?this.fragmentContextID:this.openElements.tagIDs[e]){case I.TR:return void(this.insertionMode=Re.IN_ROW);case I.TBODY:case I.THEAD:case I.TFOOT:return void(this.insertionMode=Re.IN_TABLE_BODY);case I.CAPTION:return void(this.insertionMode=Re.IN_CAPTION);case I.COLGROUP:return void(this.insertionMode=Re.IN_COLUMN_GROUP);case I.TABLE:return void(this.insertionMode=Re.IN_TABLE);case I.BODY:return void(this.insertionMode=Re.IN_BODY);case I.FRAMESET:return void(this.insertionMode=Re.IN_FRAMESET);case I.SELECT:return void this._resetInsertionModeForSelect(e);case I.TEMPLATE:return void(this.insertionMode=this.tmplInsertionModeStack[0]);case I.HTML:return void(this.insertionMode=this.headElement?Re.AFTER_HEAD:Re.BEFORE_HEAD);case I.TD:case I.TH:if(e>0)return void(this.insertionMode=Re.IN_CELL);break;case I.HEAD:if(e>0)return void(this.insertionMode=Re.IN_HEAD)}this.insertionMode=Re.IN_BODY;}_resetInsertionModeForSelect(e){if(e>0)for(let t=e-1;t>0;t--){const e=this.openElements.tagIDs[t];if(e===I.TEMPLATE)break;if(e===I.TABLE)return void(this.insertionMode=Re.IN_SELECT_IN_TABLE)}this.insertionMode=Re.IN_SELECT;}_isElementCausesFosterParenting(e){return fe.has(e)}_shouldFosterParentOnInsertion(){return this.fosterParentingEnabled&&this._isElementCausesFosterParenting(this.openElements.currentTagId)}_findFosterParentingLocation(){for(let e=this.openElements.stackTop;e>=0;e--){const t=this.openElements.items[e];switch(this.openElements.tagIDs[e]){case I.TEMPLATE:if(this.treeAdapter.getNamespaceURI(t)===d.HTML)return {parent:this.treeAdapter.getTemplateContent(t),beforeElement:null};break;case I.TABLE:{const s=this.treeAdapter.getParentNode(t);return s?{parent:s,beforeElement:t}:{parent:this.openElements.items[e-1],beforeElement:null}}}}return {parent:this.openElements.items[0],beforeElement:null}}_fosterParentElement(e){const t=this._findFosterParentingLocation();t.beforeElement?this.treeAdapter.insertBefore(t.parent,e,t.beforeElement):this.treeAdapter.appendChild(t.parent,e);}_isSpecialElement(e,t){const s=this.treeAdapter.getNamespaceURI(e);return M[s].has(t)}onCharacter(e){if(this.skipNextNewLine=!1,this.tokenizer.inForeignNode)!function(e,t){e._insertCharacters(t),e.framesetOk=!1;}(this,e);else switch(this.insertionMode){case Re.INITIAL:Ge(this,e);break;case Re.BEFORE_HTML:we(this,e);break;case Re.BEFORE_HEAD:xe(this,e);break;case Re.IN_HEAD:Qe(this,e);break;case Re.IN_HEAD_NO_SCRIPT:qe(this,e);break;case Re.AFTER_HEAD:We(this,e);break;case Re.IN_BODY:case Re.IN_CAPTION:case Re.IN_CELL:case Re.IN_TEMPLATE:Ve(this,e);break;case Re.TEXT:case Re.IN_SELECT:case Re.IN_SELECT_IN_TABLE:this._insertCharacters(e);break;case Re.IN_TABLE:case Re.IN_TABLE_BODY:case Re.IN_ROW:at(this,e);break;case Re.IN_TABLE_TEXT:ct(this,e);break;case Re.IN_COLUMN_GROUP:_t(this,e);break;case Re.AFTER_BODY:Ct(this,e);break;case Re.AFTER_AFTER_BODY:St(this,e);}}onNullCharacter(e){if(this.skipNextNewLine=!1,this.tokenizer.inForeignNode)!function(e,t){t.chars=s,e._insertCharacters(t);}(this,e);else switch(this.insertionMode){case Re.INITIAL:Ge(this,e);break;case Re.BEFORE_HTML:we(this,e);break;case Re.BEFORE_HEAD:xe(this,e);break;case Re.IN_HEAD:Qe(this,e);break;case Re.IN_HEAD_NO_SCRIPT:qe(this,e);break;case Re.AFTER_HEAD:We(this,e);break;case Re.TEXT:this._insertCharacters(e);break;case Re.IN_TABLE:case Re.IN_TABLE_BODY:case Re.IN_ROW:at(this,e);break;case Re.IN_COLUMN_GROUP:_t(this,e);break;case Re.AFTER_BODY:Ct(this,e);break;case Re.AFTER_AFTER_BODY:St(this,e);}}onComment(e){if(this.skipNextNewLine=!1,this.currentNotInHTML)Ue(this,e);else switch(this.insertionMode){case Re.INITIAL:case Re.BEFORE_HTML:case Re.BEFORE_HEAD:case Re.IN_HEAD:case Re.IN_HEAD_NO_SCRIPT:case Re.AFTER_HEAD:case Re.IN_BODY:case Re.IN_TABLE:case Re.IN_CAPTION:case Re.IN_COLUMN_GROUP:case Re.IN_TABLE_BODY:case Re.IN_ROW:case Re.IN_CELL:case Re.IN_SELECT:case Re.IN_SELECT_IN_TABLE:case Re.IN_TEMPLATE:case Re.IN_FRAMESET:case Re.AFTER_FRAMESET:Ue(this,e);break;case Re.IN_TABLE_TEXT:Et(this,e);break;case Re.AFTER_BODY:!function(e,t){e._appendCommentNode(t,e.openElements.items[0]);}(this,e);break;case Re.AFTER_AFTER_BODY:case Re.AFTER_AFTER_FRAMESET:!function(e,t){e._appendCommentNode(t,e.document);}(this,e);}}onDoctype(e){switch(this.skipNextNewLine=!1,this.insertionMode){case Re.INITIAL:!function(e,t){e._setDocumentType(t);const s=t.forceQuirks?u.QUIRKS:function(e){if(e.name!==ae)return u.QUIRKS;const{systemId:t}=e;if(t&&"http://www.ibm.com/data/dtd/v11/ibmxhtml1-transitional.dtd"===t.toLowerCase())return u.QUIRKS;let{publicId:s}=e;if(null!==s){if(s=s.toLowerCase(),ie.has(s))return u.QUIRKS;let e=null===t?ne:re;if(Ee(s,e))return u.QUIRKS;if(e=null===t?oe:ce,Ee(s,e))return u.LIMITED_QUIRKS}return u.NO_QUIRKS}(t);(function(e){return e.name===ae&&null===e.publicId&&(null===e.systemId||"about:legacy-compat"===e.systemId)})(t)||e._err(t,T.nonConformingDoctype),e.treeAdapter.setDocumentMode(e.document,s),e.insertionMode=Re.BEFORE_HTML;}(this,e);break;case Re.BEFORE_HEAD:case Re.IN_HEAD:case Re.IN_HEAD_NO_SCRIPT:case Re.AFTER_HEAD:this._err(e,T.misplacedDoctype);break;case Re.IN_TABLE_TEXT:Et(this,e);}}onStartTag(e){this.skipNextNewLine=!1,this.currentToken=e,this._processStartTag(e),e.selfClosing&&!e.ackSelfClosing&&this._err(e,T.nonVoidHtmlElementStartTagWithTrailingSolidus);}_processStartTag(e){this.shouldProcessStartTagTokenInForeignContent(e)?function(e,t){if(function(e){const t=e.tagID;return t===I.FONT&&e.attrs.some((({name:e})=>e===p.COLOR||e===p.SIZE||e===p.FACE))||pe.has(t)}(t))Dt(e),e._startTagOutsideForeignContent(t);else {const s=e._getAdjustedCurrentElement(),a=e.treeAdapter.getNamespaceURI(s);a===d.MATHML?ue(t):a===d.SVG&&(function(e){const t=de.get(e.tagName);null!=t&&(e.tagName=t,e.tagID=f(e.tagName));}(t),Ne(t)),Ie(t),t.selfClosing?e._appendElement(t,a):e._insertElement(t,a),t.ackSelfClosing=!0;}}(this,e):this._startTagOutsideForeignContent(e);}_startTagOutsideForeignContent(e){switch(this.insertionMode){case Re.INITIAL:Ge(this,e);break;case Re.BEFORE_HTML:!function(e,t){t.tagID===I.HTML?(e._insertElement(t,d.HTML),e.insertionMode=Re.BEFORE_HEAD):we(e,t);}(this,e);break;case Re.BEFORE_HEAD:!function(e,t){switch(t.tagID){case I.HTML:$e(e,t);break;case I.HEAD:e._insertElement(t,d.HTML),e.headElement=e.openElements.current,e.insertionMode=Re.IN_HEAD;break;default:xe(e,t);}}(this,e);break;case Re.IN_HEAD:Ye(this,e);break;case Re.IN_HEAD_NO_SCRIPT:!function(e,t){switch(t.tagID){case I.HTML:$e(e,t);break;case I.BASEFONT:case I.BGSOUND:case I.HEAD:case I.LINK:case I.META:case I.NOFRAMES:case I.STYLE:Ye(e,t);break;case I.NOSCRIPT:e._err(t,T.nestedNoscriptInHead);break;default:qe(e,t);}}(this,e);break;case Re.AFTER_HEAD:!function(e,t){switch(t.tagID){case I.HTML:$e(e,t);break;case I.BODY:e._insertElement(t,d.HTML),e.framesetOk=!1,e.insertionMode=Re.IN_BODY;break;case I.FRAMESET:e._insertElement(t,d.HTML),e.insertionMode=Re.IN_FRAMESET;break;case I.BASE:case I.BASEFONT:case I.BGSOUND:case I.LINK:case I.META:case I.NOFRAMES:case I.SCRIPT:case I.STYLE:case I.TEMPLATE:case I.TITLE:e._err(t,T.abandonedHeadElementChild),e.openElements.push(e.headElement,I.HEAD),Ye(e,t),e.openElements.remove(e.headElement);break;case I.HEAD:e._err(t,T.misplacedStartTagForHeadElement);break;default:We(e,t);}}(this,e);break;case Re.IN_BODY:$e(this,e);break;case Re.IN_TABLE:rt(this,e);break;case Re.IN_TABLE_TEXT:Et(this,e);break;case Re.IN_CAPTION:!function(e,t){const s=t.tagID;Tt.has(s)?e.openElements.hasInTableScope(I.CAPTION)&&(e.openElements.generateImpliedEndTags(),e.openElements.popUntilTagNamePopped(I.CAPTION),e.activeFormattingElements.clearToLastMarker(),e.insertionMode=Re.IN_TABLE,rt(e,t)):$e(e,t);}(this,e);break;case Re.IN_COLUMN_GROUP:ht(this,e);break;case Re.IN_TABLE_BODY:At(this,e);break;case Re.IN_ROW:mt(this,e);break;case Re.IN_CELL:!function(e,t){const s=t.tagID;Tt.has(s)?(e.openElements.hasInTableScope(I.TD)||e.openElements.hasInTableScope(I.TH))&&(e._closeTableCell(),mt(e,t)):$e(e,t);}(this,e);break;case Re.IN_SELECT:pt(this,e);break;case Re.IN_SELECT_IN_TABLE:!function(e,t){const s=t.tagID;s===I.CAPTION||s===I.TABLE||s===I.TBODY||s===I.TFOOT||s===I.THEAD||s===I.TR||s===I.TD||s===I.TH?(e.openElements.popUntilTagNamePopped(I.SELECT),e._resetInsertionMode(),e._processStartTag(t)):pt(e,t);}(this,e);break;case Re.IN_TEMPLATE:!function(e,t){switch(t.tagID){case I.BASE:case I.BASEFONT:case I.BGSOUND:case I.LINK:case I.META:case I.NOFRAMES:case I.SCRIPT:case I.STYLE:case I.TEMPLATE:case I.TITLE:Ye(e,t);break;case I.CAPTION:case I.COLGROUP:case I.TBODY:case I.TFOOT:case I.THEAD:e.tmplInsertionModeStack[0]=Re.IN_TABLE,e.insertionMode=Re.IN_TABLE,rt(e,t);break;case I.COL:e.tmplInsertionModeStack[0]=Re.IN_COLUMN_GROUP,e.insertionMode=Re.IN_COLUMN_GROUP,ht(e,t);break;case I.TR:e.tmplInsertionModeStack[0]=Re.IN_TABLE_BODY,e.insertionMode=Re.IN_TABLE_BODY,At(e,t);break;case I.TD:case I.TH:e.tmplInsertionModeStack[0]=Re.IN_ROW,e.insertionMode=Re.IN_ROW,mt(e,t);break;default:e.tmplInsertionModeStack[0]=Re.IN_BODY,e.insertionMode=Re.IN_BODY,$e(e,t);}}(this,e);break;case Re.AFTER_BODY:!function(e,t){t.tagID===I.HTML?$e(e,t):Ct(e,t);}(this,e);break;case Re.IN_FRAMESET:!function(e,t){switch(t.tagID){case I.HTML:$e(e,t);break;case I.FRAMESET:e._insertElement(t,d.HTML);break;case I.FRAME:e._appendElement(t,d.HTML),t.ackSelfClosing=!0;break;case I.NOFRAMES:Ye(e,t);}}(this,e);break;case Re.AFTER_FRAMESET:!function(e,t){switch(t.tagID){case I.HTML:$e(e,t);break;case I.NOFRAMES:Ye(e,t);}}(this,e);break;case Re.AFTER_AFTER_BODY:!function(e,t){t.tagID===I.HTML?$e(e,t):St(e,t);}(this,e);break;case Re.AFTER_AFTER_FRAMESET:!function(e,t){switch(t.tagID){case I.HTML:$e(e,t);break;case I.NOFRAMES:Ye(e,t);}}(this,e);}}onEndTag(e){this.skipNextNewLine=!1,this.currentToken=e,this.currentNotInHTML?function(e,t){if(t.tagID===I.P||t.tagID===I.BR)return Dt(e),void e._endTagOutsideForeignContent(t);for(let s=e.openElements.stackTop;s>0;s--){const a=e.openElements.items[s];if(e.treeAdapter.getNamespaceURI(a)===d.HTML){e._endTagOutsideForeignContent(t);break}const r=e.treeAdapter.getTagName(a);if(r.toLowerCase()===t.tagName){t.tagName=r,e.openElements.shortenToLength(s);break}}}(this,e):this._endTagOutsideForeignContent(e);}_endTagOutsideForeignContent(e){switch(this.insertionMode){case Re.INITIAL:Ge(this,e);break;case Re.BEFORE_HTML:!function(e,t){const s=t.tagID;s!==I.HTML&&s!==I.HEAD&&s!==I.BODY&&s!==I.BR||we(e,t);}(this,e);break;case Re.BEFORE_HEAD:!function(e,t){const s=t.tagID;s===I.HEAD||s===I.BODY||s===I.HTML||s===I.BR?xe(e,t):e._err(t,T.endTagWithoutMatchingOpenElement);}(this,e);break;case Re.IN_HEAD:!function(e,t){switch(t.tagID){case I.HEAD:e.openElements.pop(),e.insertionMode=Re.AFTER_HEAD;break;case I.BODY:case I.BR:case I.HTML:Qe(e,t);break;case I.TEMPLATE:ve(e,t);break;default:e._err(t,T.endTagWithoutMatchingOpenElement);}}(this,e);break;case Re.IN_HEAD_NO_SCRIPT:!function(e,t){switch(t.tagID){case I.NOSCRIPT:e.openElements.pop(),e.insertionMode=Re.IN_HEAD;break;case I.BR:qe(e,t);break;default:e._err(t,T.endTagWithoutMatchingOpenElement);}}(this,e);break;case Re.AFTER_HEAD:!function(e,t){switch(t.tagID){case I.BODY:case I.HTML:case I.BR:We(e,t);break;case I.TEMPLATE:ve(e,t);break;default:e._err(t,T.endTagWithoutMatchingOpenElement);}}(this,e);break;case Re.IN_BODY:tt(this,e);break;case Re.TEXT:!function(e,t){var s;t.tagID===I.SCRIPT&&(null===(s=e.scriptHandler)||void 0===s||s.call(e,e.openElements.current)),e.openElements.pop(),e.insertionMode=e.originalInsertionMode;}(this,e);break;case Re.IN_TABLE:nt(this,e);break;case Re.IN_TABLE_TEXT:Et(this,e);break;case Re.IN_CAPTION:!function(e,t){const s=t.tagID;switch(s){case I.CAPTION:case I.TABLE:e.openElements.hasInTableScope(I.CAPTION)&&(e.openElements.generateImpliedEndTags(),e.openElements.popUntilTagNamePopped(I.CAPTION),e.activeFormattingElements.clearToLastMarker(),e.insertionMode=Re.IN_TABLE,s===I.TABLE&&nt(e,t));break;case I.BODY:case I.COL:case I.COLGROUP:case I.HTML:case I.TBODY:case I.TD:case I.TFOOT:case I.TH:case I.THEAD:case I.TR:break;default:tt(e,t);}}(this,e);break;case Re.IN_COLUMN_GROUP:!function(e,t){switch(t.tagID){case I.COLGROUP:e.openElements.currentTagId===I.COLGROUP&&(e.openElements.pop(),e.insertionMode=Re.IN_TABLE);break;case I.TEMPLATE:ve(e,t);break;case I.COL:break;default:_t(e,t);}}(this,e);break;case Re.IN_TABLE_BODY:lt(this,e);break;case Re.IN_ROW:dt(this,e);break;case Re.IN_CELL:!function(e,t){const s=t.tagID;switch(s){case I.TD:case I.TH:e.openElements.hasInTableScope(s)&&(e.openElements.generateImpliedEndTags(),e.openElements.popUntilTagNamePopped(s),e.activeFormattingElements.clearToLastMarker(),e.insertionMode=Re.IN_ROW);break;case I.TABLE:case I.TBODY:case I.TFOOT:case I.THEAD:case I.TR:e.openElements.hasInTableScope(s)&&(e._closeTableCell(),dt(e,t));break;case I.BODY:case I.CAPTION:case I.COL:case I.COLGROUP:case I.HTML:break;default:tt(e,t);}}(this,e);break;case Re.IN_SELECT:ut(this,e);break;case Re.IN_SELECT_IN_TABLE:!function(e,t){const s=t.tagID;s===I.CAPTION||s===I.TABLE||s===I.TBODY||s===I.TFOOT||s===I.THEAD||s===I.TR||s===I.TD||s===I.TH?e.openElements.hasInTableScope(s)&&(e.openElements.popUntilTagNamePopped(I.SELECT),e._resetInsertionMode(),e.onEndTag(t)):ut(e,t);}(this,e);break;case Re.IN_TEMPLATE:!function(e,t){t.tagID===I.TEMPLATE&&ve(e,t);}(this,e);break;case Re.AFTER_BODY:It(this,e);break;case Re.IN_FRAMESET:!function(e,t){t.tagID!==I.FRAMESET||e.openElements.isRootHtmlElementCurrent()||(e.openElements.pop(),e.fragmentContext||e.openElements.currentTagId===I.FRAMESET||(e.insertionMode=Re.AFTER_FRAMESET));}(this,e);break;case Re.AFTER_FRAMESET:!function(e,t){t.tagID===I.HTML&&(e.insertionMode=Re.AFTER_AFTER_FRAMESET);}(this,e);break;case Re.AFTER_AFTER_BODY:St(this,e);}}onEof(e){switch(this.insertionMode){case Re.INITIAL:Ge(this,e);break;case Re.BEFORE_HTML:we(this,e);break;case Re.BEFORE_HEAD:xe(this,e);break;case Re.IN_HEAD:Qe(this,e);break;case Re.IN_HEAD_NO_SCRIPT:qe(this,e);break;case Re.AFTER_HEAD:We(this,e);break;case Re.IN_BODY:case Re.IN_TABLE:case Re.IN_CAPTION:case Re.IN_COLUMN_GROUP:case Re.IN_TABLE_BODY:case Re.IN_ROW:case Re.IN_CELL:case Re.IN_SELECT:case Re.IN_SELECT_IN_TABLE:st(this,e);break;case Re.TEXT:!function(e,t){e._err(t,T.eofInElementThatCanContainOnlyText),e.openElements.pop(),e.insertionMode=e.originalInsertionMode,e.onEof(t);}(this,e);break;case Re.IN_TABLE_TEXT:Et(this,e);break;case Re.IN_TEMPLATE:Nt(this,e);break;case Re.AFTER_BODY:case Re.IN_FRAMESET:case Re.AFTER_FRAMESET:case Re.AFTER_AFTER_BODY:case Re.AFTER_AFTER_FRAMESET:ye(this,e);}}onWhitespaceCharacter(e){if(this.skipNextNewLine&&(this.skipNextNewLine=!1,e.chars.charCodeAt(0)===a.LINE_FEED)){if(1===e.chars.length)return;e.chars=e.chars.substr(1);}if(this.tokenizer.inForeignNode)this._insertCharacters(e);else switch(this.insertionMode){case Re.IN_HEAD:case Re.IN_HEAD_NO_SCRIPT:case Re.AFTER_HEAD:case Re.TEXT:case Re.IN_COLUMN_GROUP:case Re.IN_SELECT:case Re.IN_SELECT_IN_TABLE:case Re.IN_FRAMESET:case Re.AFTER_FRAMESET:this._insertCharacters(e);break;case Re.IN_BODY:case Re.IN_CAPTION:case Re.IN_CELL:case Re.IN_TEMPLATE:case Re.AFTER_BODY:case Re.AFTER_AFTER_BODY:case Re.AFTER_AFTER_FRAMESET:Ke(this,e);break;case Re.IN_TABLE:case Re.IN_TABLE_BODY:case Re.IN_ROW:at(this,e);break;case Re.IN_TABLE_TEXT:ot(this,e);}}}function ge(e,t){let s=e.activeFormattingElements.getElementEntryInScopeWithTagName(t.tagName);return s?e.openElements.contains(s.element)?e.openElements.hasInScope(t.tagID)||(s=null):(e.activeFormattingElements.removeEntry(s),s=null):et(e,t),s}function Pe(e,t){let s=null,a=e.openElements.stackTop;for(;a>=0;a--){const r=e.openElements.items[a];if(r===t.element)break;e._isSpecialElement(r,e.openElements.tagIDs[a])&&(s=r);}return s||(e.openElements.shortenToLength(a<0?0:a),e.activeFormattingElements.removeEntry(t)),s}function ke(e,t,s){let a=t,r=e.openElements.getCommonAncestor(t);for(let n=0,i=r;i!==s;n++,i=r){r=e.openElements.getCommonAncestor(i);const s=e.activeFormattingElements.getElementEntry(i),o=s&&n>=De;!s||o?(o&&e.activeFormattingElements.removeEntry(s),e.openElements.remove(i)):(i=be(e,s),a===t&&(e.activeFormattingElements.bookmark=s),e.treeAdapter.detachNode(a),e.treeAdapter.appendChild(i,a),a=i);}return a}function be(e,t){const s=e.treeAdapter.getNamespaceURI(t.element),a=e.treeAdapter.createElement(t.token.tagName,s,t.token.attrs);return e.openElements.replace(t.element,a),t.element=a,a}function Be(e,t,s){const a=f(e.treeAdapter.getTagName(t));if(e._isElementCausesFosterParenting(a))e._fosterParentElement(s);else {const r=e.treeAdapter.getNamespaceURI(t);a===I.TEMPLATE&&r===d.HTML&&(t=e.treeAdapter.getTemplateContent(t)),e.treeAdapter.appendChild(t,s);}}function He(e,t,s){const a=e.treeAdapter.getNamespaceURI(s.element),{token:r}=s,n=e.treeAdapter.createElement(r.tagName,a,r.attrs);e._adoptNodes(t,n),e.treeAdapter.appendChild(t,n),e.activeFormattingElements.insertElementAfterBookmark(n,r),e.activeFormattingElements.removeEntry(s),e.openElements.remove(s.element),e.openElements.insertAfter(t,n,r.tagID);}function Fe(e,t){for(let s=0;s<Se;s++){const s=ge(e,t);if(!s)break;const a=Pe(e,s);if(!a)break;e.activeFormattingElements.bookmark=s;const r=ke(e,a,s.element),n=e.openElements.getCommonAncestor(s.element);e.treeAdapter.detachNode(r),n&&Be(e,n,r),He(e,a,s);}}function Ue(e,t){e._appendCommentNode(t,e.openElements.currentTmplContentOrNode);}function ye(e,t){if(e.stopped=!0,t.location){const s=e.fragmentContext?0:2;for(let a=e.openElements.stackTop;a>=s;a--)e._setEndLocation(e.openElements.items[a],t);if(!e.fragmentContext&&e.openElements.stackTop>=0){const s=e.openElements.items[0],a=e.treeAdapter.getNodeSourceCodeLocation(s);if(a&&!a.endTag&&(e._setEndLocation(s,t),e.openElements.stackTop>=1)){const s=e.openElements.items[1],a=e.treeAdapter.getNodeSourceCodeLocation(s);a&&!a.endTag&&e._setEndLocation(s,t);}}}}function Ge(e,t){e._err(t,T.missingDoctype,!0),e.treeAdapter.setDocumentMode(e.document,u.QUIRKS),e.insertionMode=Re.BEFORE_HTML,e._processToken(t);}function we(e,t){e._insertFakeRootElement(),e.insertionMode=Re.BEFORE_HEAD,e._processToken(t);}function xe(e,t){e._insertFakeElement(N.HEAD,I.HEAD),e.headElement=e.openElements.current,e.insertionMode=Re.IN_HEAD,e._processToken(t);}function Ye(e,t){switch(t.tagID){case I.HTML:$e(e,t);break;case I.BASE:case I.BASEFONT:case I.BGSOUND:case I.LINK:case I.META:e._appendElement(t,d.HTML),t.ackSelfClosing=!0;break;case I.TITLE:e._switchToTextParsing(t,b.RCDATA);break;case I.NOSCRIPT:e.options.scriptingEnabled?e._switchToTextParsing(t,b.RAWTEXT):(e._insertElement(t,d.HTML),e.insertionMode=Re.IN_HEAD_NO_SCRIPT);break;case I.NOFRAMES:case I.STYLE:e._switchToTextParsing(t,b.RAWTEXT);break;case I.SCRIPT:e._switchToTextParsing(t,b.SCRIPT_DATA);break;case I.TEMPLATE:e._insertTemplate(t),e.activeFormattingElements.insertMarker(),e.framesetOk=!1,e.insertionMode=Re.IN_TEMPLATE,e.tmplInsertionModeStack.unshift(Re.IN_TEMPLATE);break;case I.HEAD:e._err(t,T.misplacedStartTagForHeadElement);break;default:Qe(e,t);}}function ve(e,t){e.openElements.tmplCount>0?(e.openElements.generateImpliedEndTagsThoroughly(),e.openElements.currentTagId!==I.TEMPLATE&&e._err(t,T.closingOfElementWithOpenChildElements),e.openElements.popUntilTagNamePopped(I.TEMPLATE),e.activeFormattingElements.clearToLastMarker(),e.tmplInsertionModeStack.shift(),e._resetInsertionMode()):e._err(t,T.endTagWithoutMatchingOpenElement);}function Qe(e,t){e.openElements.pop(),e.insertionMode=Re.AFTER_HEAD,e._processToken(t);}function qe(e,t){const s=t.type===h.EOF?T.openElementsLeftAfterEof:T.disallowedContentInNoscriptInHead;e._err(t,s),e.openElements.pop(),e.insertionMode=Re.IN_HEAD,e._processToken(t);}function We(e,t){e._insertFakeElement(N.BODY,I.BODY),e.insertionMode=Re.IN_BODY,Xe(e,t);}function Xe(e,t){switch(t.type){case h.CHARACTER:Ve(e,t);break;case h.WHITESPACE_CHARACTER:Ke(e,t);break;case h.COMMENT:Ue(e,t);break;case h.START_TAG:$e(e,t);break;case h.END_TAG:tt(e,t);break;case h.EOF:st(e,t);}}function Ke(e,t){e._reconstructActiveFormattingElements(),e._insertCharacters(t);}function Ve(e,t){e._reconstructActiveFormattingElements(),e._insertCharacters(t),e.framesetOk=!1;}function je(e,t){e._reconstructActiveFormattingElements(),e._appendElement(t,d.HTML),e.framesetOk=!1,t.ackSelfClosing=!0;}function ze(e){const t=A(e,p.TYPE);return null!=t&&t.toLowerCase()===Ce}function Je(e,t){e._switchToTextParsing(t,b.RAWTEXT);}function Ze(e,t){e._reconstructActiveFormattingElements(),e._insertElement(t,d.HTML);}function $e(e,t){switch(t.tagID){case I.I:case I.S:case I.B:case I.U:case I.EM:case I.TT:case I.BIG:case I.CODE:case I.FONT:case I.SMALL:case I.STRIKE:case I.STRONG:!function(e,t){e._reconstructActiveFormattingElements(),e._insertElement(t,d.HTML),e.activeFormattingElements.pushElement(e.openElements.current,t);}(e,t);break;case I.A:!function(e,t){const s=e.activeFormattingElements.getElementEntryInScopeWithTagName(N.A);s&&(Fe(e,t),e.openElements.remove(s.element),e.activeFormattingElements.removeEntry(s)),e._reconstructActiveFormattingElements(),e._insertElement(t,d.HTML),e.activeFormattingElements.pushElement(e.openElements.current,t);}(e,t);break;case I.H1:case I.H2:case I.H3:case I.H4:case I.H5:case I.H6:!function(e,t){e.openElements.hasInButtonScope(I.P)&&e._closePElement(),g(e.openElements.currentTagId)&&e.openElements.pop(),e._insertElement(t,d.HTML);}(e,t);break;case I.P:case I.DL:case I.OL:case I.UL:case I.DIV:case I.DIR:case I.NAV:case I.MAIN:case I.MENU:case I.ASIDE:case I.CENTER:case I.FIGURE:case I.FOOTER:case I.HEADER:case I.HGROUP:case I.DIALOG:case I.DETAILS:case I.ADDRESS:case I.ARTICLE:case I.SECTION:case I.SUMMARY:case I.FIELDSET:case I.BLOCKQUOTE:case I.FIGCAPTION:!function(e,t){e.openElements.hasInButtonScope(I.P)&&e._closePElement(),e._insertElement(t,d.HTML);}(e,t);break;case I.LI:case I.DD:case I.DT:!function(e,t){e.framesetOk=!1;const s=t.tagID;for(let t=e.openElements.stackTop;t>=0;t--){const a=e.openElements.tagIDs[t];if(s===I.LI&&a===I.LI||(s===I.DD||s===I.DT)&&(a===I.DD||a===I.DT)){e.openElements.generateImpliedEndTagsWithExclusion(a),e.openElements.popUntilTagNamePopped(a);break}if(a!==I.ADDRESS&&a!==I.DIV&&a!==I.P&&e._isSpecialElement(e.openElements.items[t],a))break}e.openElements.hasInButtonScope(I.P)&&e._closePElement(),e._insertElement(t,d.HTML);}(e,t);break;case I.BR:case I.IMG:case I.WBR:case I.AREA:case I.EMBED:case I.KEYGEN:je(e,t);break;case I.HR:!function(e,t){e.openElements.hasInButtonScope(I.P)&&e._closePElement(),e._appendElement(t,d.HTML),e.framesetOk=!1,t.ackSelfClosing=!0;}(e,t);break;case I.RB:case I.RTC:!function(e,t){e.openElements.hasInScope(I.RUBY)&&e.openElements.generateImpliedEndTags(),e._insertElement(t,d.HTML);}(e,t);break;case I.RT:case I.RP:!function(e,t){e.openElements.hasInScope(I.RUBY)&&e.openElements.generateImpliedEndTagsWithExclusion(I.RTC),e._insertElement(t,d.HTML);}(e,t);break;case I.PRE:case I.LISTING:!function(e,t){e.openElements.hasInButtonScope(I.P)&&e._closePElement(),e._insertElement(t,d.HTML),e.skipNextNewLine=!0,e.framesetOk=!1;}(e,t);break;case I.XMP:!function(e,t){e.openElements.hasInButtonScope(I.P)&&e._closePElement(),e._reconstructActiveFormattingElements(),e.framesetOk=!1,e._switchToTextParsing(t,b.RAWTEXT);}(e,t);break;case I.SVG:!function(e,t){e._reconstructActiveFormattingElements(),Ne(t),Ie(t),t.selfClosing?e._appendElement(t,d.SVG):e._insertElement(t,d.SVG),t.ackSelfClosing=!0;}(e,t);break;case I.HTML:!function(e,t){0===e.openElements.tmplCount&&e.treeAdapter.adoptAttributes(e.openElements.items[0],t.attrs);}(e,t);break;case I.BASE:case I.LINK:case I.META:case I.STYLE:case I.TITLE:case I.SCRIPT:case I.BGSOUND:case I.BASEFONT:case I.TEMPLATE:Ye(e,t);break;case I.BODY:!function(e,t){const s=e.openElements.tryPeekProperlyNestedBodyElement();s&&0===e.openElements.tmplCount&&(e.framesetOk=!1,e.treeAdapter.adoptAttributes(s,t.attrs));}(e,t);break;case I.FORM:!function(e,t){const s=e.openElements.tmplCount>0;e.formElement&&!s||(e.openElements.hasInButtonScope(I.P)&&e._closePElement(),e._insertElement(t,d.HTML),s||(e.formElement=e.openElements.current));}(e,t);break;case I.NOBR:!function(e,t){e._reconstructActiveFormattingElements(),e.openElements.hasInScope(I.NOBR)&&(Fe(e,t),e._reconstructActiveFormattingElements()),e._insertElement(t,d.HTML),e.activeFormattingElements.pushElement(e.openElements.current,t);}(e,t);break;case I.MATH:!function(e,t){e._reconstructActiveFormattingElements(),ue(t),Ie(t),t.selfClosing?e._appendElement(t,d.MATHML):e._insertElement(t,d.MATHML),t.ackSelfClosing=!0;}(e,t);break;case I.TABLE:!function(e,t){e.treeAdapter.getDocumentMode(e.document)!==u.QUIRKS&&e.openElements.hasInButtonScope(I.P)&&e._closePElement(),e._insertElement(t,d.HTML),e.framesetOk=!1,e.insertionMode=Re.IN_TABLE;}(e,t);break;case I.INPUT:!function(e,t){e._reconstructActiveFormattingElements(),e._appendElement(t,d.HTML),ze(t)||(e.framesetOk=!1),t.ackSelfClosing=!0;}(e,t);break;case I.PARAM:case I.TRACK:case I.SOURCE:!function(e,t){e._appendElement(t,d.HTML),t.ackSelfClosing=!0;}(e,t);break;case I.IMAGE:!function(e,t){t.tagName=N.IMG,t.tagID=I.IMG,je(e,t);}(e,t);break;case I.BUTTON:!function(e,t){e.openElements.hasInScope(I.BUTTON)&&(e.openElements.generateImpliedEndTags(),e.openElements.popUntilTagNamePopped(I.BUTTON)),e._reconstructActiveFormattingElements(),e._insertElement(t,d.HTML),e.framesetOk=!1;}(e,t);break;case I.APPLET:case I.OBJECT:case I.MARQUEE:!function(e,t){e._reconstructActiveFormattingElements(),e._insertElement(t,d.HTML),e.activeFormattingElements.insertMarker(),e.framesetOk=!1;}(e,t);break;case I.IFRAME:!function(e,t){e.framesetOk=!1,e._switchToTextParsing(t,b.RAWTEXT);}(e,t);break;case I.SELECT:!function(e,t){e._reconstructActiveFormattingElements(),e._insertElement(t,d.HTML),e.framesetOk=!1,e.insertionMode=e.insertionMode===Re.IN_TABLE||e.insertionMode===Re.IN_CAPTION||e.insertionMode===Re.IN_TABLE_BODY||e.insertionMode===Re.IN_ROW||e.insertionMode===Re.IN_CELL?Re.IN_SELECT_IN_TABLE:Re.IN_SELECT;}(e,t);break;case I.OPTION:case I.OPTGROUP:!function(e,t){e.openElements.currentTagId===I.OPTION&&e.openElements.pop(),e._reconstructActiveFormattingElements(),e._insertElement(t,d.HTML);}(e,t);break;case I.NOEMBED:Je(e,t);break;case I.FRAMESET:!function(e,t){const s=e.openElements.tryPeekProperlyNestedBodyElement();e.framesetOk&&s&&(e.treeAdapter.detachNode(s),e.openElements.popAllUpToHtmlElement(),e._insertElement(t,d.HTML),e.insertionMode=Re.IN_FRAMESET);}(e,t);break;case I.TEXTAREA:!function(e,t){e._insertElement(t,d.HTML),e.skipNextNewLine=!0,e.tokenizer.state=b.RCDATA,e.originalInsertionMode=e.insertionMode,e.framesetOk=!1,e.insertionMode=Re.TEXT;}(e,t);break;case I.NOSCRIPT:e.options.scriptingEnabled?Je(e,t):Ze(e,t);break;case I.PLAINTEXT:!function(e,t){e.openElements.hasInButtonScope(I.P)&&e._closePElement(),e._insertElement(t,d.HTML),e.tokenizer.state=b.PLAINTEXT;}(e,t);break;case I.COL:case I.TH:case I.TD:case I.TR:case I.HEAD:case I.FRAME:case I.TBODY:case I.TFOOT:case I.THEAD:case I.CAPTION:case I.COLGROUP:break;default:Ze(e,t);}}function et(e,t){const s=t.tagName,a=t.tagID;for(let t=e.openElements.stackTop;t>0;t--){const r=e.openElements.items[t],n=e.openElements.tagIDs[t];if(a===n&&(a!==I.UNKNOWN||e.treeAdapter.getTagName(r)===s)){e.openElements.generateImpliedEndTagsWithExclusion(a),e.openElements.stackTop>=t&&e.openElements.shortenToLength(t);break}if(e._isSpecialElement(r,n))break}}function tt(e,t){switch(t.tagID){case I.A:case I.B:case I.I:case I.S:case I.U:case I.EM:case I.TT:case I.BIG:case I.CODE:case I.FONT:case I.NOBR:case I.SMALL:case I.STRIKE:case I.STRONG:Fe(e,t);break;case I.P:!function(e){e.openElements.hasInButtonScope(I.P)||e._insertFakeElement(N.P,I.P),e._closePElement();}(e);break;case I.DL:case I.UL:case I.OL:case I.DIR:case I.DIV:case I.NAV:case I.PRE:case I.MAIN:case I.MENU:case I.ASIDE:case I.BUTTON:case I.CENTER:case I.FIGURE:case I.FOOTER:case I.HEADER:case I.HGROUP:case I.DIALOG:case I.ADDRESS:case I.ARTICLE:case I.DETAILS:case I.SECTION:case I.SUMMARY:case I.LISTING:case I.FIELDSET:case I.BLOCKQUOTE:case I.FIGCAPTION:!function(e,t){const s=t.tagID;e.openElements.hasInScope(s)&&(e.openElements.generateImpliedEndTags(),e.openElements.popUntilTagNamePopped(s));}(e,t);break;case I.LI:!function(e){e.openElements.hasInListItemScope(I.LI)&&(e.openElements.generateImpliedEndTagsWithExclusion(I.LI),e.openElements.popUntilTagNamePopped(I.LI));}(e);break;case I.DD:case I.DT:!function(e,t){const s=t.tagID;e.openElements.hasInScope(s)&&(e.openElements.generateImpliedEndTagsWithExclusion(s),e.openElements.popUntilTagNamePopped(s));}(e,t);break;case I.H1:case I.H2:case I.H3:case I.H4:case I.H5:case I.H6:!function(e){e.openElements.hasNumberedHeaderInScope()&&(e.openElements.generateImpliedEndTags(),e.openElements.popUntilNumberedHeaderPopped());}(e);break;case I.BR:!function(e){e._reconstructActiveFormattingElements(),e._insertFakeElement(N.BR,I.BR),e.openElements.pop(),e.framesetOk=!1;}(e);break;case I.BODY:!function(e,t){if(e.openElements.hasInScope(I.BODY)&&(e.insertionMode=Re.AFTER_BODY,e.options.sourceCodeLocationInfo)){const s=e.openElements.tryPeekProperlyNestedBodyElement();s&&e._setEndLocation(s,t);}}(e,t);break;case I.HTML:!function(e,t){e.openElements.hasInScope(I.BODY)&&(e.insertionMode=Re.AFTER_BODY,It(e,t));}(e,t);break;case I.FORM:!function(e){const t=e.openElements.tmplCount>0,{formElement:s}=e;t||(e.formElement=null),(s||t)&&e.openElements.hasInScope(I.FORM)&&(e.openElements.generateImpliedEndTags(),t?e.openElements.popUntilTagNamePopped(I.FORM):s&&e.openElements.remove(s));}(e);break;case I.APPLET:case I.OBJECT:case I.MARQUEE:!function(e,t){const s=t.tagID;e.openElements.hasInScope(s)&&(e.openElements.generateImpliedEndTags(),e.openElements.popUntilTagNamePopped(s),e.activeFormattingElements.clearToLastMarker());}(e,t);break;case I.TEMPLATE:ve(e,t);break;default:et(e,t);}}function st(e,t){e.tmplInsertionModeStack.length>0?Nt(e,t):ye(e,t);}function at(e,t){if(fe.has(e.openElements.currentTagId))switch(e.pendingCharacterTokens.length=0,e.hasNonWhitespacePendingCharacterToken=!1,e.originalInsertionMode=e.insertionMode,e.insertionMode=Re.IN_TABLE_TEXT,t.type){case h.CHARACTER:ct(e,t);break;case h.WHITESPACE_CHARACTER:ot(e,t);}else it(e,t);}function rt(e,t){switch(t.tagID){case I.TD:case I.TH:case I.TR:!function(e,t){e.openElements.clearBackToTableContext(),e._insertFakeElement(N.TBODY,I.TBODY),e.insertionMode=Re.IN_TABLE_BODY,At(e,t);}(e,t);break;case I.STYLE:case I.SCRIPT:case I.TEMPLATE:Ye(e,t);break;case I.COL:!function(e,t){e.openElements.clearBackToTableContext(),e._insertFakeElement(N.COLGROUP,I.COLGROUP),e.insertionMode=Re.IN_COLUMN_GROUP,ht(e,t);}(e,t);break;case I.FORM:!function(e,t){e.formElement||0!==e.openElements.tmplCount||(e._insertElement(t,d.HTML),e.formElement=e.openElements.current,e.openElements.pop());}(e,t);break;case I.TABLE:!function(e,t){e.openElements.hasInTableScope(I.TABLE)&&(e.openElements.popUntilTagNamePopped(I.TABLE),e._resetInsertionMode(),e._processStartTag(t));}(e,t);break;case I.TBODY:case I.TFOOT:case I.THEAD:!function(e,t){e.openElements.clearBackToTableContext(),e._insertElement(t,d.HTML),e.insertionMode=Re.IN_TABLE_BODY;}(e,t);break;case I.INPUT:!function(e,t){ze(t)?e._appendElement(t,d.HTML):it(e,t),t.ackSelfClosing=!0;}(e,t);break;case I.CAPTION:!function(e,t){e.openElements.clearBackToTableContext(),e.activeFormattingElements.insertMarker(),e._insertElement(t,d.HTML),e.insertionMode=Re.IN_CAPTION;}(e,t);break;case I.COLGROUP:!function(e,t){e.openElements.clearBackToTableContext(),e._insertElement(t,d.HTML),e.insertionMode=Re.IN_COLUMN_GROUP;}(e,t);break;default:it(e,t);}}function nt(e,t){switch(t.tagID){case I.TABLE:e.openElements.hasInTableScope(I.TABLE)&&(e.openElements.popUntilTagNamePopped(I.TABLE),e._resetInsertionMode());break;case I.TEMPLATE:ve(e,t);break;case I.BODY:case I.CAPTION:case I.COL:case I.COLGROUP:case I.HTML:case I.TBODY:case I.TD:case I.TFOOT:case I.TH:case I.THEAD:case I.TR:break;default:it(e,t);}}function it(e,t){const s=e.fosterParentingEnabled;e.fosterParentingEnabled=!0,Xe(e,t),e.fosterParentingEnabled=s;}function ot(e,t){e.pendingCharacterTokens.push(t);}function ct(e,t){e.pendingCharacterTokens.push(t),e.hasNonWhitespacePendingCharacterToken=!0;}function Et(e,t){let s=0;if(e.hasNonWhitespacePendingCharacterToken)for(;s<e.pendingCharacterTokens.length;s++)it(e,e.pendingCharacterTokens[s]);else for(;s<e.pendingCharacterTokens.length;s++)e._insertCharacters(e.pendingCharacterTokens[s]);e.insertionMode=e.originalInsertionMode,e._processToken(t);}const Tt=new Set([I.CAPTION,I.COL,I.COLGROUP,I.TBODY,I.TD,I.TFOOT,I.TH,I.THEAD,I.TR]);function ht(e,t){switch(t.tagID){case I.HTML:$e(e,t);break;case I.COL:e._appendElement(t,d.HTML),t.ackSelfClosing=!0;break;case I.TEMPLATE:Ye(e,t);break;default:_t(e,t);}}function _t(e,t){e.openElements.currentTagId===I.COLGROUP&&(e.openElements.pop(),e.insertionMode=Re.IN_TABLE,e._processToken(t));}function At(e,t){switch(t.tagID){case I.TR:e.openElements.clearBackToTableBodyContext(),e._insertElement(t,d.HTML),e.insertionMode=Re.IN_ROW;break;case I.TH:case I.TD:e.openElements.clearBackToTableBodyContext(),e._insertFakeElement(N.TR,I.TR),e.insertionMode=Re.IN_ROW,mt(e,t);break;case I.CAPTION:case I.COL:case I.COLGROUP:case I.TBODY:case I.TFOOT:case I.THEAD:e.openElements.hasTableBodyContextInTableScope()&&(e.openElements.clearBackToTableBodyContext(),e.openElements.pop(),e.insertionMode=Re.IN_TABLE,rt(e,t));break;default:rt(e,t);}}function lt(e,t){const s=t.tagID;switch(t.tagID){case I.TBODY:case I.TFOOT:case I.THEAD:e.openElements.hasInTableScope(s)&&(e.openElements.clearBackToTableBodyContext(),e.openElements.pop(),e.insertionMode=Re.IN_TABLE);break;case I.TABLE:e.openElements.hasTableBodyContextInTableScope()&&(e.openElements.clearBackToTableBodyContext(),e.openElements.pop(),e.insertionMode=Re.IN_TABLE,nt(e,t));break;case I.BODY:case I.CAPTION:case I.COL:case I.COLGROUP:case I.HTML:case I.TD:case I.TH:case I.TR:break;default:nt(e,t);}}function mt(e,t){switch(t.tagID){case I.TH:case I.TD:e.openElements.clearBackToTableRowContext(),e._insertElement(t,d.HTML),e.insertionMode=Re.IN_CELL,e.activeFormattingElements.insertMarker();break;case I.CAPTION:case I.COL:case I.COLGROUP:case I.TBODY:case I.TFOOT:case I.THEAD:case I.TR:e.openElements.hasInTableScope(I.TR)&&(e.openElements.clearBackToTableRowContext(),e.openElements.pop(),e.insertionMode=Re.IN_TABLE_BODY,At(e,t));break;default:rt(e,t);}}function dt(e,t){switch(t.tagID){case I.TR:e.openElements.hasInTableScope(I.TR)&&(e.openElements.clearBackToTableRowContext(),e.openElements.pop(),e.insertionMode=Re.IN_TABLE_BODY);break;case I.TABLE:e.openElements.hasInTableScope(I.TR)&&(e.openElements.clearBackToTableRowContext(),e.openElements.pop(),e.insertionMode=Re.IN_TABLE_BODY,lt(e,t));break;case I.TBODY:case I.TFOOT:case I.THEAD:(e.openElements.hasInTableScope(t.tagID)||e.openElements.hasInTableScope(I.TR))&&(e.openElements.clearBackToTableRowContext(),e.openElements.pop(),e.insertionMode=Re.IN_TABLE_BODY,lt(e,t));break;case I.BODY:case I.CAPTION:case I.COL:case I.COLGROUP:case I.HTML:case I.TD:case I.TH:break;default:nt(e,t);}}function pt(e,t){switch(t.tagID){case I.HTML:$e(e,t);break;case I.OPTION:e.openElements.currentTagId===I.OPTION&&e.openElements.pop(),e._insertElement(t,d.HTML);break;case I.OPTGROUP:e.openElements.currentTagId===I.OPTION&&e.openElements.pop(),e.openElements.currentTagId===I.OPTGROUP&&e.openElements.pop(),e._insertElement(t,d.HTML);break;case I.INPUT:case I.KEYGEN:case I.TEXTAREA:case I.SELECT:e.openElements.hasInSelectScope(I.SELECT)&&(e.openElements.popUntilTagNamePopped(I.SELECT),e._resetInsertionMode(),t.tagID!==I.SELECT&&e._processStartTag(t));break;case I.SCRIPT:case I.TEMPLATE:Ye(e,t);}}function ut(e,t){switch(t.tagID){case I.OPTGROUP:e.openElements.stackTop>0&&e.openElements.currentTagId===I.OPTION&&e.openElements.tagIDs[e.openElements.stackTop-1]===I.OPTGROUP&&e.openElements.pop(),e.openElements.currentTagId===I.OPTGROUP&&e.openElements.pop();break;case I.OPTION:e.openElements.currentTagId===I.OPTION&&e.openElements.pop();break;case I.SELECT:e.openElements.hasInSelectScope(I.SELECT)&&(e.openElements.popUntilTagNamePopped(I.SELECT),e._resetInsertionMode());break;case I.TEMPLATE:ve(e,t);}}function Nt(e,t){e.openElements.tmplCount>0?(e.openElements.popUntilTagNamePopped(I.TEMPLATE),e.activeFormattingElements.clearToLastMarker(),e.tmplInsertionModeStack.shift(),e._resetInsertionMode(),e.onEof(t)):ye(e,t);}function It(e,t){var s;if(t.tagID===I.HTML){if(e.fragmentContext||(e.insertionMode=Re.AFTER_AFTER_BODY),e.options.sourceCodeLocationInfo&&e.openElements.tagIDs[0]===I.HTML){e._setEndLocation(e.openElements.items[0],t);const a=e.openElements.items[1];a&&!(null===(s=e.treeAdapter.getNodeSourceCodeLocation(a))||void 0===s?void 0:s.endTag)&&e._setEndLocation(a,t);}}else Ct(e,t);}function Ct(e,t){e.insertionMode=Re.IN_BODY,Xe(e,t);}function St(e,t){e.insertionMode=Re.IN_BODY,Xe(e,t);}function Dt(e){for(;e.treeAdapter.getNamespaceURI(e.openElements.current)!==d.HTML&&!e._isIntegrationPoint(e.openElements.currentTagId,e.openElements.current);)e.openElements.pop();}return new Set([N.AREA,N.BASE,N.BASEFONT,N.BGSOUND,N.BR,N.COL,N.EMBED,N.FRAME,N.HR,N.IMG,N.INPUT,N.KEYGEN,N.LINK,N.META,N.PARAM,N.SOURCE,N.TRACK,N.WBR]),e.parse=function(e,t){return Me.parse(e,t)},e.parseFragment=function(e,t,s){"string"==typeof e&&(s=t,t=e,e=null);const a=Me.getFragmentParser(e,s);return a.tokenizer.write(t,!0),a.getFragment()},Object.defineProperty(e,"__esModule",{value:!0}),e}({});const parse=e.parse;const parseFragment=e.parseFragment;

const docParser = new WeakMap();
function parseDocumentUtil(ownerDocument, html) {
    const doc = parse(html.trim(), getParser(ownerDocument));
    doc.documentElement = doc.firstElementChild;
    doc.head = doc.documentElement.firstElementChild;
    doc.body = doc.head.nextElementSibling;
    return doc;
}
function parseFragmentUtil(ownerDocument, html) {
    if (typeof html === 'string') {
        html = html.trim();
    }
    else {
        html = '';
    }
    const frag = parseFragment(html, getParser(ownerDocument));
    return frag;
}
function getParser(ownerDocument) {
    let parseOptions = docParser.get(ownerDocument);
    if (parseOptions != null) {
        return parseOptions;
    }
    const treeAdapter = {
        createDocument() {
            const doc = ownerDocument.createElement("#document" /* NODE_NAMES.DOCUMENT_NODE */);
            doc['x-mode'] = 'no-quirks';
            return doc;
        },
        setNodeSourceCodeLocation(node, location) {
            node.sourceCodeLocation = location;
        },
        getNodeSourceCodeLocation(node) {
            return node.sourceCodeLocation;
        },
        createDocumentFragment() {
            return ownerDocument.createDocumentFragment();
        },
        createElement(tagName, namespaceURI, attrs) {
            const elm = ownerDocument.createElementNS(namespaceURI, tagName);
            for (let i = 0; i < attrs.length; i++) {
                const attr = attrs[i];
                if (attr.namespace == null || attr.namespace === 'http://www.w3.org/1999/xhtml') {
                    elm.setAttribute(attr.name, attr.value);
                }
                else {
                    elm.setAttributeNS(attr.namespace, attr.name, attr.value);
                }
            }
            return elm;
        },
        createCommentNode(data) {
            return ownerDocument.createComment(data);
        },
        appendChild(parentNode, newNode) {
            parentNode.appendChild(newNode);
        },
        insertBefore(parentNode, newNode, referenceNode) {
            parentNode.insertBefore(newNode, referenceNode);
        },
        setTemplateContent(templateElement, contentElement) {
            templateElement.content = contentElement;
        },
        getTemplateContent(templateElement) {
            return templateElement.content;
        },
        setDocumentType(doc, name, publicId, systemId) {
            let doctypeNode = doc.childNodes.find((n) => n.nodeType === 10 /* NODE_TYPES.DOCUMENT_TYPE_NODE */);
            if (doctypeNode == null) {
                doctypeNode = ownerDocument.createDocumentTypeNode();
                doc.insertBefore(doctypeNode, doc.firstChild);
            }
            doctypeNode.nodeValue = '!DOCTYPE';
            doctypeNode['x-name'] = name;
            doctypeNode['x-publicId'] = publicId;
            doctypeNode['x-systemId'] = systemId;
        },
        setDocumentMode(doc, mode) {
            doc['x-mode'] = mode;
        },
        getDocumentMode(doc) {
            return doc['x-mode'];
        },
        detachNode(node) {
            node.remove();
        },
        insertText(parentNode, text) {
            const lastChild = parentNode.lastChild;
            if (lastChild != null && lastChild.nodeType === 3 /* NODE_TYPES.TEXT_NODE */) {
                lastChild.nodeValue += text;
            }
            else {
                parentNode.appendChild(ownerDocument.createTextNode(text));
            }
        },
        insertTextBefore(parentNode, text, referenceNode) {
            const prevNode = parentNode.childNodes[parentNode.childNodes.indexOf(referenceNode) - 1];
            if (prevNode != null && prevNode.nodeType === 3 /* NODE_TYPES.TEXT_NODE */) {
                prevNode.nodeValue += text;
            }
            else {
                parentNode.insertBefore(ownerDocument.createTextNode(text), referenceNode);
            }
        },
        adoptAttributes(recipient, attrs) {
            for (let i = 0; i < attrs.length; i++) {
                const attr = attrs[i];
                if (recipient.hasAttributeNS(attr.namespace, attr.name) === false) {
                    recipient.setAttributeNS(attr.namespace, attr.name, attr.value);
                }
            }
        },
        getFirstChild(node) {
            return node.childNodes[0];
        },
        getChildNodes(node) {
            return node.childNodes;
        },
        getParentNode(node) {
            return node.parentNode;
        },
        getAttrList(element) {
            const attrs = element.attributes.__items.map((attr) => {
                return {
                    name: attr.name,
                    value: attr.value,
                    namespace: attr.namespaceURI,
                    prefix: null,
                };
            });
            return attrs;
        },
        getTagName(element) {
            if (element.namespaceURI === 'http://www.w3.org/1999/xhtml') {
                return element.nodeName.toLowerCase();
            }
            else {
                return element.nodeName;
            }
        },
        getNamespaceURI(element) {
            // mock-doc widens the type of an element's namespace uri to 'string | null'
            // we use a type assertion here to adhere to parse5's type definitions
            return element.namespaceURI;
        },
        getTextNodeContent(textNode) {
            return textNode.nodeValue;
        },
        getCommentNodeContent(commentNode) {
            return commentNode.nodeValue;
        },
        getDocumentTypeNodeName(doctypeNode) {
            return doctypeNode['x-name'];
        },
        getDocumentTypeNodePublicId(doctypeNode) {
            return doctypeNode['x-publicId'];
        },
        getDocumentTypeNodeSystemId(doctypeNode) {
            return doctypeNode['x-systemId'];
        },
        // @ts-ignore - a `MockNode` will never be assignable to a `TreeAdapterTypeMap['text']`. As a result, we cannot
        // complete this function signature
        isTextNode(node) {
            return node.nodeType === 3 /* NODE_TYPES.TEXT_NODE */;
        },
        // @ts-ignore - a `MockNode` will never be assignable to a `TreeAdapterTypeMap['comment']`. As a result, we cannot
        // complete this function signature (which requires its return type to be a type predicate)
        isCommentNode(node) {
            return node.nodeType === 8 /* NODE_TYPES.COMMENT_NODE */;
        },
        // @ts-ignore - a `MockNode` will never be assignable to a `TreeAdapterTypeMap['document']`. As a result, we cannot
        // complete this function signature (which requires its return type to be a type predicate)
        isDocumentTypeNode(node) {
            return node.nodeType === 10 /* NODE_TYPES.DOCUMENT_TYPE_NODE */;
        },
        // @ts-ignore - a `MockNode` will never be assignable to a `TreeAdapterTypeMap['element']`. As a result, we cannot
        // complete this function signature (which requires its return type to be a type predicate)
        isElementNode(node) {
            return node.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */;
        },
    };
    parseOptions = {
        treeAdapter: treeAdapter,
    };
    docParser.set(ownerDocument, parseOptions);
    return parseOptions;
}

/* eslint-disable */
// @ts-nocheck
/**
 * ATTENTION: DO NOT MODIFY THIS FILE
 *
 * This file is generated by "scripts/updateSelectorEngine.ts" and can be overwritten
 * at any time. Don't make changes in here as they will get lost!
 */
const jQuery = /*!
 * jQuery JavaScript Library v4.0.0-pre+9352011a7.dirty +selector
 * https://jquery.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2023-12-11T17:55Z
 */ (function (global, factory) {
    {
        // For CommonJS and CommonJS-like environments where a proper `window`
        // is present, execute the factory and get jQuery.
        return factory(global, true);
    }
    // Pass this if window is not defined yet
})({
    document: {
        createElement() {
            return {};
        },
        nodeType: 9,
        documentElement: {
            nodeType: 1,
            nodeName: 'HTML'
        }
    }
}, function (window, noGlobal) {
    if (!window.document) {
        throw new Error("jQuery requires a window with a document");
    }
    var arr = [];
    var getProto = Object.getPrototypeOf;
    var slice = arr.slice;
    // Support: IE 11+
    // IE doesn't have Array#flat; provide a fallback.
    var flat = arr.flat ? function (array) {
        return arr.flat.call(array);
    } : function (array) {
        return arr.concat.apply([], array);
    };
    var push = arr.push;
    var indexOf = arr.indexOf;
    // [[Class]] -> type pairs
    var class2type = {};
    var toString = class2type.toString;
    var hasOwn = class2type.hasOwnProperty;
    var fnToString = hasOwn.toString;
    var ObjectFunctionString = fnToString.call(Object);
    // All support tests are defined in their respective modules.
    var support = {};
    function toType(obj) {
        if (obj == null) {
            return obj + "";
        }
        return typeof obj === "object" ?
            class2type[toString.call(obj)] || "object" :
            typeof obj;
    }
    function isWindow(obj) {
        return obj != null && obj === obj.window;
    }
    function isArrayLike(obj) {
        var length = !!obj && obj.length, type = toType(obj);
        if (typeof obj === "function" || isWindow(obj)) {
            return false;
        }
        return type === "array" || length === 0 ||
            typeof length === "number" && length > 0 && (length - 1) in obj;
    }
    var document = window.document;
    var preservedScriptAttributes = {
        type: true,
        src: true,
        nonce: true,
        noModule: true
    };
    function DOMEval(code, node, doc) {
        doc = doc || document;
        var i, script = doc.createElement("script");
        script.text = code;
        if (node) {
            for (i in preservedScriptAttributes) {
                if (node[i]) {
                    script[i] = node[i];
                }
            }
        }
        doc.head.appendChild(script).parentNode.removeChild(script);
    }
    const jQuery = {};
    var version = "4.0.0-pre+9352011a7.dirty +selector", rhtmlSuffix = /HTML$/i; 
    jQuery.fn = jQuery.prototype = {
        // The current version of jQuery being used
        jquery: version,
        constructor: jQuery,
        // The default length of a jQuery object is 0
        length: 0,
        toArray: function () {
            return slice.call(this);
        },
        // Get the Nth element in the matched element set OR
        // Get the whole matched element set as a clean array
        get: function (num) {
            // Return all the elements in a clean array
            if (num == null) {
                return slice.call(this);
            }
            // Return just the one element from the set
            return num < 0 ? this[num + this.length] : this[num];
        },
        // Take an array of elements and push it onto the stack
        // (returning the new matched element set)
        pushStack: function (elems) {
            // Build a new jQuery matched element set
            var ret = jQuery.merge(this.constructor(), elems);
            // Add the old object onto the stack (as a reference)
            ret.prevObject = this;
            // Return the newly-formed element set
            return ret;
        },
        // Execute a callback for every element in the matched set.
        each: function (callback) {
            return jQuery.each(this, callback);
        },
        map: function (callback) {
            return this.pushStack(jQuery.map(this, function (elem, i) {
                return callback.call(elem, i, elem);
            }));
        },
        slice: function () {
            return this.pushStack(slice.apply(this, arguments));
        },
        first: function () {
            return this.eq(0);
        },
        last: function () {
            return this.eq(-1);
        },
        even: function () {
            return this.pushStack(jQuery.grep(this, function (_elem, i) {
                return (i + 1) % 2;
            }));
        },
        odd: function () {
            return this.pushStack(jQuery.grep(this, function (_elem, i) {
                return i % 2;
            }));
        },
        eq: function (i) {
            var len = this.length, j = +i + (i < 0 ? len : 0);
            return this.pushStack(j >= 0 && j < len ? [this[j]] : []);
        },
        end: function () {
            return this.prevObject || this.constructor();
        }
    };
    jQuery.extend = jQuery.fn.extend = function () {
        var options, name, src, copy, copyIsArray, clone, target = arguments[0] || {}, i = 1, length = arguments.length, deep = false;
        // Handle a deep copy situation
        if (typeof target === "boolean") {
            deep = target;
            // Skip the boolean and the target
            target = arguments[i] || {};
            i++;
        }
        // Handle case when target is a string or something (possible in deep copy)
        if (typeof target !== "object" && typeof target !== "function") {
            target = {};
        }
        // Extend jQuery itself if only one argument is passed
        if (i === length) {
            target = this;
            i--;
        }
        for (; i < length; i++) {
            // Only deal with non-null/undefined values
            if ((options = arguments[i]) != null) {
                // Extend the base object
                for (name in options) {
                    copy = options[name];
                    // Prevent Object.prototype pollution
                    // Prevent never-ending loop
                    if (name === "__proto__" || target === copy) {
                        continue;
                    }
                    // Recurse if we're merging plain objects or arrays
                    if (deep && copy && (jQuery.isPlainObject(copy) ||
                        (copyIsArray = Array.isArray(copy)))) {
                        src = target[name];
                        // Ensure proper type for the source value
                        if (copyIsArray && !Array.isArray(src)) {
                            clone = [];
                        }
                        else if (!copyIsArray && !jQuery.isPlainObject(src)) {
                            clone = {};
                        }
                        else {
                            clone = src;
                        }
                        copyIsArray = false;
                        // Never move original objects, clone them
                        target[name] = jQuery.extend(deep, clone, copy);
                        // Don't bring in undefined values
                    }
                    else if (copy !== undefined) {
                        target[name] = copy;
                    }
                }
            }
        }
        // Return the modified object
        return target;
    };
    jQuery.extend({
        // Unique for each copy of jQuery on the page
        expando: "jQuery" + (version + Math.random()).replace(/\D/g, ""),
        // Assume jQuery is ready without the ready module
        isReady: true,
        error: function (msg) {
            throw new Error(msg);
        },
        noop: function () { },
        isPlainObject: function (obj) {
            var proto, Ctor;
            // Detect obvious negatives
            // Use toString instead of jQuery.type to catch host objects
            if (!obj || toString.call(obj) !== "[object Object]") {
                return false;
            }
            proto = getProto(obj);
            // Objects with no prototype (e.g., `Object.create( null )`) are plain
            if (!proto) {
                return true;
            }
            // Objects with prototype are plain iff they were constructed by a global Object function
            Ctor = hasOwn.call(proto, "constructor") && proto.constructor;
            return typeof Ctor === "function" && fnToString.call(Ctor) === ObjectFunctionString;
        },
        isEmptyObject: function (obj) {
            var name;
            for (name in obj) {
                return false;
            }
            return true;
        },
        // Evaluates a script in a provided context; falls back to the global one
        // if not specified.
        globalEval: function (code, options, doc) {
            DOMEval(code, { nonce: options && options.nonce }, doc);
        },
        each: function (obj, callback) {
            var length, i = 0;
            if (isArrayLike(obj)) {
                length = obj.length;
                for (; i < length; i++) {
                    if (callback.call(obj[i], i, obj[i]) === false) {
                        break;
                    }
                }
            }
            else {
                for (i in obj) {
                    if (callback.call(obj[i], i, obj[i]) === false) {
                        break;
                    }
                }
            }
            return obj;
        },
        // Retrieve the text value of an array of DOM nodes
        text: function (elem) {
            var node, ret = "", i = 0, nodeType = elem.nodeType;
            if (!nodeType) {
                // If no nodeType, this is expected to be an array
                while ((node = elem[i++])) {
                    // Do not traverse comment nodes
                    ret += jQuery.text(node);
                }
            }
            if (nodeType === 1 || nodeType === 11) {
                return elem.textContent;
            }
            if (nodeType === 9) {
                return elem.documentElement.textContent;
            }
            if (nodeType === 3 || nodeType === 4) {
                return elem.nodeValue;
            }
            // Do not include comment or processing instruction nodes
            return ret;
        },
        // results is for internal usage only
        makeArray: function (arr, results) {
            var ret = results || [];
            if (arr != null) {
                if (isArrayLike(Object(arr))) {
                    jQuery.merge(ret, typeof arr === "string" ?
                        [arr] : arr);
                }
                else {
                    push.call(ret, arr);
                }
            }
            return ret;
        },
        inArray: function (elem, arr, i) {
            return arr == null ? -1 : indexOf.call(arr, elem, i);
        },
        isXMLDoc: function (elem) {
            var namespace = elem && elem.namespaceURI, docElem = elem && (elem.ownerDocument || elem).documentElement;
            // Assume HTML when documentElement doesn't yet exist, such as inside
            // document fragments.
            return !rhtmlSuffix.test(namespace || docElem && docElem.nodeName || "HTML");
        },
        // Note: an element does not contain itself
        contains: function (a, b) {
            var bup = b && b.parentNode;
            return a === bup || !!(bup && bup.nodeType === 1 && (
            // Support: IE 9 - 11+
            // IE doesn't have `contains` on SVG.
            a.contains ?
                a.contains(bup) :
                a.compareDocumentPosition && a.compareDocumentPosition(bup) & 16));
        },
        merge: function (first, second) {
            var len = +second.length, j = 0, i = first.length;
            for (; j < len; j++) {
                first[i++] = second[j];
            }
            first.length = i;
            return first;
        },
        grep: function (elems, callback, invert) {
            var callbackInverse, matches = [], i = 0, length = elems.length, callbackExpect = !invert;
            // Go through the array, only saving the items
            // that pass the validator function
            for (; i < length; i++) {
                callbackInverse = !callback(elems[i], i);
                if (callbackInverse !== callbackExpect) {
                    matches.push(elems[i]);
                }
            }
            return matches;
        },
        // arg is for internal usage only
        map: function (elems, callback, arg) {
            var length, value, i = 0, ret = [];
            // Go through the array, translating each of the items to their new values
            if (isArrayLike(elems)) {
                length = elems.length;
                for (; i < length; i++) {
                    value = callback(elems[i], i, arg);
                    if (value != null) {
                        ret.push(value);
                    }
                }
                // Go through every key on the object,
            }
            else {
                for (i in elems) {
                    value = callback(elems[i], i, arg);
                    if (value != null) {
                        ret.push(value);
                    }
                }
            }
            // Flatten any nested arrays
            return flat(ret);
        },
        // A global GUID counter for objects
        guid: 1,
        // jQuery.support is not used in Core but other projects attach their
        // properties to it so it needs to exist.
        support: support
    });
    if (typeof Symbol === "function") {
        jQuery.fn[Symbol.iterator] = arr[Symbol.iterator];
    }
    // Populate the class2type map
    jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "), function (_i, name) {
        class2type["[object " + name + "]"] = name.toLowerCase();
    });
    function nodeName(elem, name) {
        return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
    }
    var pop = arr.pop;
    // https://www.w3.org/TR/css3-selectors/#whitespace
    var whitespace = "[\\x20\\t\\r\\n\\f]";
    var isIE = document.documentMode;
    // Support: Chrome 105 - 111 only, Safari 15.4 - 16.3 only
    // Make sure the `:has()` argument is parsed unforgivingly.
    // We include `*` in the test to detect buggy implementations that are
    // _selectively_ forgiving (specifically when the list includes at least
    // one valid selector).
    // Note that we treat complete lack of support for `:has()` as if it were
    // spec-compliant support, which is fine because use of `:has()` in such
    // environments will fail in the qSA path and fall back to jQuery traversal
    // anyway.
    try {
        document.querySelector(":has(*,:jqfake)");
        support.cssHas = false;
    }
    catch (e) {
        support.cssHas = true;
    }
    // Build QSA regex.
    // Regex strategy adopted from Diego Perini.
    var rbuggyQSA = [];
    if (isIE) {
        rbuggyQSA.push(
        // Support: IE 9 - 11+
        // IE's :disabled selector does not pick up the children of disabled fieldsets
        ":enabled", ":disabled", 
        // Support: IE 11+
        // IE 11 doesn't find elements on a `[name='']` query in some cases.
        // Adding a temporary attribute to the document before the selection works
        // around the issue.
        "\\[" + whitespace + "*name" + whitespace + "*=" +
            whitespace + "*(?:''|\"\")");
    }
    if (!support.cssHas) {
        // Support: Chrome 105 - 110+, Safari 15.4 - 16.3+
        // Our regular `try-catch` mechanism fails to detect natively-unsupported
        // pseudo-classes inside `:has()` (such as `:has(:contains("Foo"))`)
        // in browsers that parse the `:has()` argument as a forgiving selector list.
        // https://drafts.csswg.org/selectors/#relational now requires the argument
        // to be parsed unforgivingly, but browsers have not yet fully adjusted.
        rbuggyQSA.push(":has");
    }
    rbuggyQSA = rbuggyQSA.length && new RegExp(rbuggyQSA.join("|"));
    var rtrimCSS = new RegExp("^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g");
    // https://www.w3.org/TR/css-syntax-3/#ident-token-diagram
    var identifier = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace +
        "?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+";
    var booleans = "checked|selected|async|autofocus|autoplay|controls|" +
        "defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped";
    var rleadingCombinator = new RegExp("^" + whitespace + "*([>+~]|" +
        whitespace + ")" + whitespace + "*");
    var rsibling = /[+~]/;
    var documentElement = document.documentElement;
    // Support: IE 9 - 11+
    // IE requires a prefix.
    var matches = documentElement.matches || documentElement.msMatchesSelector;
    /**
     * Create key-value caches of limited size
     * @returns {function(string, object)} Returns the Object data after storing it on itself with
     *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
     *	deleting the oldest entry
     */
    function createCache() {
        var keys = [];
        function cache(key, value) {
            // Use (key + " ") to avoid collision with native prototype properties
            // (see https://github.com/jquery/sizzle/issues/157)
            if (keys.push(key + " ") > jQuery.expr.cacheLength) {
                // Only keep the most recent entries
                delete cache[keys.shift()];
            }
            return (cache[key + " "] = value);
        }
        return cache;
    }
    /**
     * Checks a node for validity as a jQuery selector context
     * @param {Element|Object=} context
     * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
     */
    function testContext(context) {
        return context && typeof context.getElementsByTagName !== "undefined" && context;
    }
    // Attribute selectors: https://www.w3.org/TR/selectors/#attribute-selectors
    var attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +
        // Operator (capture 2)
        "*([*^$|!~]?=)" + whitespace +
        // "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
        "*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" +
        whitespace + "*\\]";
    var pseudos = ":(" + identifier + ")(?:\\((" +
        // To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
        // 1. quoted (capture 3; capture 4 or capture 5)
        "('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +
        // 2. simple (capture 6)
        "((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +
        // 3. anything else (capture 2)
        ".*" +
        ")\\)|)";
    var filterMatchExpr = {
        ID: new RegExp("^#(" + identifier + ")"),
        CLASS: new RegExp("^\\.(" + identifier + ")"),
        TAG: new RegExp("^(" + identifier + "|[*])"),
        ATTR: new RegExp("^" + attributes),
        PSEUDO: new RegExp("^" + pseudos),
        CHILD: new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +
            whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" +
            whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i")
    };
    var rpseudo = new RegExp(pseudos);
    // CSS escapes
    var runescape = new RegExp("\\\\[\\da-fA-F]{1,6}" + whitespace +
        "?|\\\\([^\\r\\n\\f])", "g"), funescape = function (escape, nonHex) {
        var high = "0x" + escape.slice(1) - 0x10000;
        if (nonHex) {
            // Strip the backslash prefix from a non-hex escape sequence
            return nonHex;
        }
        // Replace a hexadecimal escape sequence with the encoded Unicode code point
        // Support: IE <=11+
        // For values outside the Basic Multilingual Plane (BMP), manually construct a
        // surrogate pair
        return high < 0 ?
            String.fromCharCode(high + 0x10000) :
            String.fromCharCode(high >> 10 | 0xD800, high & 0x3FF | 0xDC00);
    };
    function unescapeSelector(sel) {
        return sel.replace(runescape, funescape);
    }
    function selectorError(msg) {
        jQuery.error("Syntax error, unrecognized expression: " + msg);
    }
    var rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*");
    var tokenCache = createCache();
    function tokenize(selector, parseOnly) {
        var matched, match, tokens, type, soFar, groups, preFilters, cached = tokenCache[selector + " "];
        if (cached) {
            return parseOnly ? 0 : cached.slice(0);
        }
        soFar = selector;
        groups = [];
        preFilters = jQuery.expr.preFilter;
        while (soFar) {
            // Comma and first run
            if (!matched || (match = rcomma.exec(soFar))) {
                if (match) {
                    // Don't consume trailing commas as valid
                    soFar = soFar.slice(match[0].length) || soFar;
                }
                groups.push((tokens = []));
            }
            matched = false;
            // Combinators
            if ((match = rleadingCombinator.exec(soFar))) {
                matched = match.shift();
                tokens.push({
                    value: matched,
                    // Cast descendant combinators to space
                    type: match[0].replace(rtrimCSS, " ")
                });
                soFar = soFar.slice(matched.length);
            }
            // Filters
            for (type in filterMatchExpr) {
                if ((match = jQuery.expr.match[type].exec(soFar)) && (!preFilters[type] ||
                    (match = preFilters[type](match)))) {
                    matched = match.shift();
                    tokens.push({
                        value: matched,
                        type: type,
                        matches: match
                    });
                    soFar = soFar.slice(matched.length);
                }
            }
            if (!matched) {
                break;
            }
        }
        // Return the length of the invalid excess
        // if we're just parsing
        // Otherwise, throw an error or return tokens
        if (parseOnly) {
            return soFar.length;
        }
        return soFar ?
            selectorError(selector) :
            // Cache the tokens
            tokenCache(selector, groups).slice(0);
    }
    var preFilter = {
        ATTR: function (match) {
            match[1] = unescapeSelector(match[1]);
            // Move the given value to match[3] whether quoted or unquoted
            match[3] = unescapeSelector(match[3] || match[4] || match[5] || "");
            if (match[2] === "~=") {
                match[3] = " " + match[3] + " ";
            }
            return match.slice(0, 4);
        },
        CHILD: function (match) {
            /* matches from filterMatchExpr["CHILD"]
                1 type (only|nth|...)
                2 what (child|of-type)
                3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
                4 xn-component of xn+y argument ([+-]?\d*n|)
                5 sign of xn-component
                6 x of xn-component
                7 sign of y-component
                8 y of y-component
            */
            match[1] = match[1].toLowerCase();
            if (match[1].slice(0, 3) === "nth") {
                // nth-* requires argument
                if (!match[3]) {
                    selectorError(match[0]);
                }
                // numeric x and y parameters for jQuery.expr.filter.CHILD
                // remember that false/true cast respectively to 0/1
                match[4] = +(match[4] ?
                    match[5] + (match[6] || 1) :
                    2 * (match[3] === "even" || match[3] === "odd"));
                match[5] = +((match[7] + match[8]) || match[3] === "odd");
                // other types prohibit arguments
            }
            else if (match[3]) {
                selectorError(match[0]);
            }
            return match;
        },
        PSEUDO: function (match) {
            var excess, unquoted = !match[6] && match[2];
            if (filterMatchExpr.CHILD.test(match[0])) {
                return null;
            }
            // Accept quoted arguments as-is
            if (match[3]) {
                match[2] = match[4] || match[5] || "";
                // Strip excess characters from unquoted arguments
            }
            else if (unquoted && rpseudo.test(unquoted) &&
                // Get excess from tokenize (recursively)
                (excess = tokenize(unquoted, true)) &&
                // advance to the next closing parenthesis
                (excess = unquoted.indexOf(")", unquoted.length - excess) -
                    unquoted.length)) {
                // excess is a negative index
                match[0] = match[0].slice(0, excess);
                match[2] = unquoted.slice(0, excess);
            }
            // Return only captures needed by the pseudo filter method (type and argument)
            return match.slice(0, 3);
        }
    };
    function toSelector(tokens) {
        var i = 0, len = tokens.length, selector = "";
        for (; i < len; i++) {
            selector += tokens[i].value;
        }
        return selector;
    }
    // CSS string/identifier serialization
    // https://drafts.csswg.org/cssom/#common-serializing-idioms
    var rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\x80-\uFFFF\w-]/g;
    function fcssescape(ch, asCodePoint) {
        if (asCodePoint) {
            // U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
            if (ch === "\0") {
                return "\uFFFD";
            }
            // Control characters and (dependent upon position) numbers get escaped as code points
            return ch.slice(0, -1) + "\\" + ch.charCodeAt(ch.length - 1).toString(16) + " ";
        }
        // Other potentially-special ASCII characters get backslash-escaped
        return "\\" + ch;
    }
    jQuery.escapeSelector = function (sel) {
        return (sel + "").replace(rcssescape, fcssescape);
    };
    var sort = arr.sort;
    var splice = arr.splice;
    var hasDuplicate;
    // Document order sorting
    function sortOrder(a, b) {
        // Flag for duplicate removal
        if (a === b) {
            hasDuplicate = true;
            return 0;
        }
        // Sort on method existence if only one input has compareDocumentPosition
        var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
        if (compare) {
            return compare;
        }
        // Calculate position if both inputs belong to the same document
        // Support: IE 11+
        // IE sometimes throws a "Permission denied" error when strict-comparing
        // two documents; shallow comparisons work.
        // eslint-disable-next-line eqeqeq
        compare = (a.ownerDocument || a) == (b.ownerDocument || b) ?
            a.compareDocumentPosition(b) :
            // Otherwise we know they are disconnected
            1;
        // Disconnected nodes
        if (compare & 1) {
            // Choose the first element that is related to the document
            // Support: IE 11+
            // IE sometimes throws a "Permission denied" error when strict-comparing
            // two documents; shallow comparisons work.
            // eslint-disable-next-line eqeqeq
            if (a == document || a.ownerDocument == document &&
                jQuery.contains(document, a)) {
                return -1;
            }
            // Support: IE 11+
            // IE sometimes throws a "Permission denied" error when strict-comparing
            // two documents; shallow comparisons work.
            // eslint-disable-next-line eqeqeq
            if (b == document || b.ownerDocument == document &&
                jQuery.contains(document, b)) {
                return 1;
            }
            // Maintain original order
            return 0;
        }
        return compare & 4 ? -1 : 1;
    }
    /**
     * Document sorting and removing duplicates
     * @param {ArrayLike} results
     */
    jQuery.uniqueSort = function (results) {
        var elem, duplicates = [], j = 0, i = 0;
        hasDuplicate = false;
        sort.call(results, sortOrder);
        if (hasDuplicate) {
            while ((elem = results[i++])) {
                if (elem === results[i]) {
                    j = duplicates.push(i);
                }
            }
            while (j--) {
                splice.call(results, duplicates[j], 1);
            }
        }
        return results;
    };
    jQuery.fn.uniqueSort = function () {
        return this.pushStack(jQuery.uniqueSort(slice.apply(this)));
    };
    var i, outermostContext, 
    // Local document vars
    document$1, documentElement$1, documentIsHTML, 
    // Instance-specific data
    dirruns = 0, done = 0, classCache = createCache(), compilerCache = createCache(), nonnativeSelectorCache = createCache(), 
    // Regular expressions
    // Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
    rwhitespace = new RegExp(whitespace + "+", "g"), ridentifier = new RegExp("^" + identifier + "$"), matchExpr = jQuery.extend({
        bool: new RegExp("^(?:" + booleans + ")$", "i"),
        // For use in libraries implementing .is()
        // We use this for POS matching in `select`
        needsContext: new RegExp("^" + whitespace +
            "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
            "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i")
    }, filterMatchExpr), rinputs = /^(?:input|select|textarea|button)$/i, rheader = /^h\d$/i, 
    // Used for iframes; see `setDocument`.
    // Support: IE 9 - 11+
    // Removing the function wrapper causes a "Permission Denied"
    // error in IE.
    unloadHandler = function () {
        setDocument();
    }, inDisabledFieldset = addCombinator(function (elem) {
        return elem.disabled === true && nodeName(elem, "fieldset");
    }, { dir: "parentNode", next: "legend" });
    function find(selector, context, results, seed) {
        context && context.ownerDocument; 
        var // nodeType defaults to 9, since context defaults to document
        nodeType = context ? context.nodeType : 9;
        results = results || [];
        // Return early from calls with invalid selector or context
        if (typeof selector !== "string" || !selector ||
            nodeType !== 1 && nodeType !== 9 && nodeType !== 11) {
            return results;
        }
        // All others
        return select(selector.replace(rtrimCSS, "$1"), context, results, seed);
    }
    /**
     * Mark a function for special use by jQuery selector module
     * @param {Function} fn The function to mark
     */
    function markFunction(fn) {
        fn[jQuery.expando] = true;
        return fn;
    }
    /**
     * Returns a function to use in pseudos for input types
     * @param {String} type
     */
    function createInputPseudo(type) {
        return function (elem) {
            return nodeName(elem, "input") && elem.type === type;
        };
    }
    /**
     * Returns a function to use in pseudos for buttons
     * @param {String} type
     */
    function createButtonPseudo(type) {
        return function (elem) {
            return (nodeName(elem, "input") || nodeName(elem, "button")) &&
                elem.type === type;
        };
    }
    /**
     * Returns a function to use in pseudos for :enabled/:disabled
     * @param {Boolean} disabled true for :disabled; false for :enabled
     */
    function createDisabledPseudo(disabled) {
        // Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
        return function (elem) {
            // Only certain elements can match :enabled or :disabled
            // https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
            // https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
            if ("form" in elem) {
                // Check for inherited disabledness on relevant non-disabled elements:
                // * listed form-associated elements in a disabled fieldset
                //   https://html.spec.whatwg.org/multipage/forms.html#category-listed
                //   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
                // * option elements in a disabled optgroup
                //   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
                // All such elements have a "form" property.
                if (elem.parentNode && elem.disabled === false) {
                    // Option elements defer to a parent optgroup if present
                    if ("label" in elem) {
                        if ("label" in elem.parentNode) {
                            return elem.parentNode.disabled === disabled;
                        }
                        else {
                            return elem.disabled === disabled;
                        }
                    }
                    // Support: IE 6 - 11+
                    // Use the isDisabled shortcut property to check for disabled fieldset ancestors
                    return elem.isDisabled === disabled ||
                        // Where there is no isDisabled, check manually
                        elem.isDisabled !== !disabled &&
                            inDisabledFieldset(elem) === disabled;
                }
                return elem.disabled === disabled;
                // Try to winnow out elements that can't be disabled before trusting the disabled property.
                // Some victims get caught in our net (label, legend, menu, track), but it shouldn't
                // even exist on them, let alone have a boolean value.
            }
            else if ("label" in elem) {
                return elem.disabled === disabled;
            }
            // Remaining elements are neither :enabled nor :disabled
            return false;
        };
    }
    /**
     * Returns a function to use in pseudos for positionals
     * @param {Function} fn
     */
    function createPositionalPseudo(fn) {
        return markFunction(function (argument) {
            argument = +argument;
            return markFunction(function (seed, matches) {
                var j, matchIndexes = fn([], seed.length, argument), i = matchIndexes.length;
                // Match elements found at the specified indexes
                while (i--) {
                    if (seed[(j = matchIndexes[i])]) {
                        seed[j] = !(matches[j] = seed[j]);
                    }
                }
            });
        });
    }
    /**
     * Sets document-related variables once based on the current document
     * @param {Element|Object} [node] An element or document object to use to set the document
     */
    function setDocument(node) {
        var subWindow, doc = node ? node.ownerDocument || node : document;
        // Return early if doc is invalid or already selected
        // Support: IE 11+
        // IE sometimes throws a "Permission denied" error when strict-comparing
        // two documents; shallow comparisons work.
        // eslint-disable-next-line eqeqeq
        if (doc == document$1 || doc.nodeType !== 9) {
            return;
        }
        // Update global variables
        document$1 = doc;
        documentElement$1 = document$1.documentElement;
        documentIsHTML = !jQuery.isXMLDoc(document$1);
        // Support: IE 9 - 11+
        // Accessing iframe documents after unload throws "permission denied" errors (see trac-13936)
        // Support: IE 11+
        // IE sometimes throws a "Permission denied" error when strict-comparing
        // two documents; shallow comparisons work.
        // eslint-disable-next-line eqeqeq
        if (isIE && document != document$1 &&
            (subWindow = document$1.defaultView) && subWindow.top !== subWindow) {
            subWindow.addEventListener("unload", unloadHandler);
        }
    }
    find.matches = function (expr, elements) {
        return find(expr, null, null, elements);
    };
    find.matchesSelector = function (elem, expr) {
        setDocument(elem);
        if (documentIsHTML &&
            !nonnativeSelectorCache[expr + " "] &&
            (!rbuggyQSA || !rbuggyQSA.test(expr))) {
            try {
                return matches.call(elem, expr);
            }
            catch (e) {
                nonnativeSelectorCache(expr, true);
            }
        }
        return find(expr, document$1, null, [elem]).length > 0;
    };
    jQuery.expr = {
        // Can be adjusted by the user
        cacheLength: 50,
        createPseudo: markFunction,
        match: matchExpr,
        find: {
            ID: function (id, context) {
                if (typeof context.getElementById !== "undefined" && documentIsHTML) {
                    var elem = context.getElementById(id);
                    return elem ? [elem] : [];
                }
            },
            TAG: function (tag, context) {
                if (typeof context.getElementsByTagName !== "undefined") {
                    return context.getElementsByTagName(tag);
                    // DocumentFragment nodes don't have gEBTN
                }
                else {
                    return context.querySelectorAll(tag);
                }
            },
            CLASS: function (className, context) {
                if (typeof context.getElementsByClassName !== "undefined" && documentIsHTML) {
                    return context.getElementsByClassName(className);
                }
            }
        },
        relative: {
            ">": { dir: "parentNode", first: true },
            " ": { dir: "parentNode" },
            "+": { dir: "previousSibling", first: true },
            "~": { dir: "previousSibling" }
        },
        preFilter: preFilter,
        filter: {
            ID: function (id) {
                var attrId = unescapeSelector(id);
                return function (elem) {
                    return elem.getAttribute("id") === attrId;
                };
            },
            TAG: function (nodeNameSelector) {
                var expectedNodeName = unescapeSelector(nodeNameSelector).toLowerCase();
                return nodeNameSelector === "*" ?
                    function () {
                        return true;
                    } :
                    function (elem) {
                        return nodeName(elem, expectedNodeName);
                    };
            },
            CLASS: function (className) {
                var pattern = classCache[className + " "];
                return pattern ||
                    (pattern = new RegExp("(^|" + whitespace + ")" + className +
                        "(" + whitespace + "|$)")) &&
                        classCache(className, function (elem) {
                            return pattern.test(typeof elem.className === "string" && elem.className ||
                                typeof elem.getAttribute !== "undefined" &&
                                    elem.getAttribute("class") ||
                                "");
                        });
            },
            ATTR: function (name, operator, check) {
                return function (elem) {
                    var result = elem.getAttribute(name);
                    if (result == null) {
                        return operator === "!=";
                    }
                    if (!operator) {
                        return true;
                    }
                    result += "";
                    if (operator === "=") {
                        return result === check;
                    }
                    if (operator === "!=") {
                        return result !== check;
                    }
                    if (operator === "^=") {
                        return check && result.indexOf(check) === 0;
                    }
                    if (operator === "*=") {
                        return check && result.indexOf(check) > -1;
                    }
                    if (operator === "$=") {
                        return check && result.slice(-check.length) === check;
                    }
                    if (operator === "~=") {
                        return (" " + result.replace(rwhitespace, " ") + " ")
                            .indexOf(check) > -1;
                    }
                    if (operator === "|=") {
                        return result === check || result.slice(0, check.length + 1) === check + "-";
                    }
                    return false;
                };
            },
            CHILD: function (type, what, _argument, first, last) {
                var simple = type.slice(0, 3) !== "nth", forward = type.slice(-4) !== "last", ofType = what === "of-type";
                return first === 1 && last === 0 ?
                    // Shortcut for :nth-*(n)
                    function (elem) {
                        return !!elem.parentNode;
                    } :
                    function (elem, _context, xml) {
                        var cache, outerCache, node, nodeIndex, start, dir = simple !== forward ? "nextSibling" : "previousSibling", parent = elem.parentNode, name = ofType && elem.nodeName.toLowerCase(), useCache = !xml && !ofType, diff = false;
                        if (parent) {
                            // :(first|last|only)-(child|of-type)
                            if (simple) {
                                while (dir) {
                                    node = elem;
                                    while ((node = node[dir])) {
                                        if (ofType ?
                                            nodeName(node, name) :
                                            node.nodeType === 1) {
                                            return false;
                                        }
                                    }
                                    // Reverse direction for :only-* (if we haven't yet done so)
                                    start = dir = type === "only" && !start && "nextSibling";
                                }
                                return true;
                            }
                            start = [forward ? parent.firstChild : parent.lastChild];
                            // non-xml :nth-child(...) stores cache data on `parent`
                            if (forward && useCache) {
                                // Seek `elem` from a previously-cached index
                                outerCache = parent[jQuery.expando] ||
                                    (parent[jQuery.expando] = {});
                                cache = outerCache[type] || [];
                                nodeIndex = cache[0] === dirruns && cache[1];
                                diff = nodeIndex && cache[2];
                                node = nodeIndex && parent.childNodes[nodeIndex];
                                while ((node = ++nodeIndex && node && node[dir] ||
                                    // Fallback to seeking `elem` from the start
                                    (diff = nodeIndex = 0) || start.pop())) {
                                    // When found, cache indexes on `parent` and break
                                    if (node.nodeType === 1 && ++diff && node === elem) {
                                        outerCache[type] = [dirruns, nodeIndex, diff];
                                        break;
                                    }
                                }
                            }
                            else {
                                // Use previously-cached element index if available
                                if (useCache) {
                                    outerCache = elem[jQuery.expando] ||
                                        (elem[jQuery.expando] = {});
                                    cache = outerCache[type] || [];
                                    nodeIndex = cache[0] === dirruns && cache[1];
                                    diff = nodeIndex;
                                }
                                // xml :nth-child(...)
                                // or :nth-last-child(...) or :nth(-last)?-of-type(...)
                                if (diff === false) {
                                    // Use the same loop as above to seek `elem` from the start
                                    while ((node = ++nodeIndex && node && node[dir] ||
                                        (diff = nodeIndex = 0) || start.pop())) {
                                        if ((ofType ?
                                            nodeName(node, name) :
                                            node.nodeType === 1) &&
                                            ++diff) {
                                            // Cache the index of each encountered element
                                            if (useCache) {
                                                outerCache = node[jQuery.expando] ||
                                                    (node[jQuery.expando] = {});
                                                outerCache[type] = [dirruns, diff];
                                            }
                                            if (node === elem) {
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            // Incorporate the offset, then check against cycle size
                            diff -= last;
                            return diff === first || (diff % first === 0 && diff / first >= 0);
                        }
                    };
            },
            PSEUDO: function (pseudo, argument) {
                // pseudo-class names are case-insensitive
                // https://www.w3.org/TR/selectors/#pseudo-classes
                // Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
                // Remember that setFilters inherits from pseudos
                var fn = jQuery.expr.pseudos[pseudo] ||
                    jQuery.expr.setFilters[pseudo.toLowerCase()] ||
                    selectorError("unsupported pseudo: " + pseudo);
                // The user may use createPseudo to indicate that
                // arguments are needed to create the filter function
                // just as jQuery does
                if (fn[jQuery.expando]) {
                    return fn(argument);
                }
                return fn;
            }
        },
        pseudos: {
            // Potentially complex pseudos
            not: markFunction(function (selector) {
                // Trim the selector passed to compile
                // to avoid treating leading and trailing
                // spaces as combinators
                var input = [], results = [], matcher = compile(selector.replace(rtrimCSS, "$1"));
                return matcher[jQuery.expando] ?
                    markFunction(function (seed, matches, _context, xml) {
                        var elem, unmatched = matcher(seed, null, xml, []), i = seed.length;
                        // Match elements unmatched by `matcher`
                        while (i--) {
                            if ((elem = unmatched[i])) {
                                seed[i] = !(matches[i] = elem);
                            }
                        }
                    }) :
                    function (elem, _context, xml) {
                        input[0] = elem;
                        matcher(input, null, xml, results);
                        // Don't keep the element
                        // (see https://github.com/jquery/sizzle/issues/299)
                        input[0] = null;
                        return !results.pop();
                    };
            }),
            has: markFunction(function (selector) {
                return function (elem) {
                    return find(selector, elem).length > 0;
                };
            }),
            contains: markFunction(function (text) {
                text = unescapeSelector(text);
                return function (elem) {
                    return (elem.textContent || jQuery.text(elem)).indexOf(text) > -1;
                };
            }),
            // "Whether an element is represented by a :lang() selector
            // is based solely on the element's language value
            // being equal to the identifier C,
            // or beginning with the identifier C immediately followed by "-".
            // The matching of C against the element's language value is performed case-insensitively.
            // The identifier C does not have to be a valid language name."
            // https://www.w3.org/TR/selectors/#lang-pseudo
            lang: markFunction(function (lang) {
                // lang value must be a valid identifier
                if (!ridentifier.test(lang || "")) {
                    selectorError("unsupported lang: " + lang);
                }
                lang = unescapeSelector(lang).toLowerCase();
                return function (elem) {
                    var elemLang;
                    do {
                        if ((elemLang = documentIsHTML ?
                            elem.lang :
                            elem.getAttribute("xml:lang") || elem.getAttribute("lang"))) {
                            elemLang = elemLang.toLowerCase();
                            return elemLang === lang || elemLang.indexOf(lang + "-") === 0;
                        }
                    } while ((elem = elem.parentNode) && elem.nodeType === 1);
                    return false;
                };
            }),
            // Miscellaneous
            target: function (elem) {
                var hash = window.location && window.location.hash;
                return hash && hash.slice(1) === elem.id;
            },
            root: function (elem) {
                return elem === documentElement$1;
            },
            focus: function (elem) {
                return elem === document$1.activeElement &&
                    document$1.hasFocus() &&
                    !!(elem.type || elem.href || ~elem.tabIndex);
            },
            // Boolean properties
            enabled: createDisabledPseudo(false),
            disabled: createDisabledPseudo(true),
            checked: function (elem) {
                // In CSS3, :checked should return both checked and selected elements
                // https://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
                return (nodeName(elem, "input") && !!elem.checked) ||
                    (nodeName(elem, "option") && !!elem.selected);
            },
            selected: function (elem) {
                // Support: IE <=11+
                // Accessing the selectedIndex property
                // forces the browser to treat the default option as
                // selected when in an optgroup.
                if (isIE && elem.parentNode) {
                    // eslint-disable-next-line no-unused-expressions
                    elem.parentNode.selectedIndex;
                }
                return elem.selected === true;
            },
            // Contents
            empty: function (elem) {
                // https://www.w3.org/TR/selectors/#empty-pseudo
                // :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
                //   but not by others (comment: 8; processing instruction: 7; etc.)
                // nodeType < 6 works because attributes (2) do not appear as children
                for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
                    if (elem.nodeType < 6) {
                        return false;
                    }
                }
                return true;
            },
            parent: function (elem) {
                return !jQuery.expr.pseudos.empty(elem);
            },
            // Element/input types
            header: function (elem) {
                return rheader.test(elem.nodeName);
            },
            input: function (elem) {
                return rinputs.test(elem.nodeName);
            },
            button: function (elem) {
                return nodeName(elem, "input") && elem.type === "button" ||
                    nodeName(elem, "button");
            },
            text: function (elem) {
                return nodeName(elem, "input") && elem.type === "text";
            },
            // Position-in-collection
            first: createPositionalPseudo(function () {
                return [0];
            }),
            last: createPositionalPseudo(function (_matchIndexes, length) {
                return [length - 1];
            }),
            eq: createPositionalPseudo(function (_matchIndexes, length, argument) {
                return [argument < 0 ? argument + length : argument];
            }),
            even: createPositionalPseudo(function (matchIndexes, length) {
                var i = 0;
                for (; i < length; i += 2) {
                    matchIndexes.push(i);
                }
                return matchIndexes;
            }),
            odd: createPositionalPseudo(function (matchIndexes, length) {
                var i = 1;
                for (; i < length; i += 2) {
                    matchIndexes.push(i);
                }
                return matchIndexes;
            }),
            lt: createPositionalPseudo(function (matchIndexes, length, argument) {
                var i;
                if (argument < 0) {
                    i = argument + length;
                }
                else if (argument > length) {
                    i = length;
                }
                else {
                    i = argument;
                }
                for (; --i >= 0;) {
                    matchIndexes.push(i);
                }
                return matchIndexes;
            }),
            gt: createPositionalPseudo(function (matchIndexes, length, argument) {
                var i = argument < 0 ? argument + length : argument;
                for (; ++i < length;) {
                    matchIndexes.push(i);
                }
                return matchIndexes;
            })
        }
    };
    jQuery.expr.pseudos.nth = jQuery.expr.pseudos.eq;
    // Add button/input type pseudos
    for (i in { radio: true, checkbox: true, file: true, password: true, image: true }) {
        jQuery.expr.pseudos[i] = createInputPseudo(i);
    }
    for (i in { submit: true, reset: true }) {
        jQuery.expr.pseudos[i] = createButtonPseudo(i);
    }
    // Easy API for creating new setFilters
    function setFilters() { }
    setFilters.prototype = jQuery.expr.filters = jQuery.expr.pseudos;
    jQuery.expr.setFilters = new setFilters();
    function addCombinator(matcher, combinator, base) {
        var dir = combinator.dir, skip = combinator.next, key = skip || dir, checkNonElements = base && key === "parentNode", doneName = done++;
        return combinator.first ?
            // Check against closest ancestor/preceding element
            function (elem, context, xml) {
                while ((elem = elem[dir])) {
                    if (elem.nodeType === 1 || checkNonElements) {
                        return matcher(elem, context, xml);
                    }
                }
                return false;
            } :
            // Check against all ancestor/preceding elements
            function (elem, context, xml) {
                var oldCache, outerCache, newCache = [dirruns, doneName];
                // We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
                if (xml) {
                    while ((elem = elem[dir])) {
                        if (elem.nodeType === 1 || checkNonElements) {
                            if (matcher(elem, context, xml)) {
                                return true;
                            }
                        }
                    }
                }
                else {
                    while ((elem = elem[dir])) {
                        if (elem.nodeType === 1 || checkNonElements) {
                            outerCache = elem[jQuery.expando] || (elem[jQuery.expando] = {});
                            if (skip && nodeName(elem, skip)) {
                                elem = elem[dir] || elem;
                            }
                            else if ((oldCache = outerCache[key]) &&
                                oldCache[0] === dirruns && oldCache[1] === doneName) {
                                // Assign to newCache so results back-propagate to previous elements
                                return (newCache[2] = oldCache[2]);
                            }
                            else {
                                // Reuse newcache so results back-propagate to previous elements
                                outerCache[key] = newCache;
                                // A match means we're done; a fail means we have to keep checking
                                if ((newCache[2] = matcher(elem, context, xml))) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                return false;
            };
    }
    function elementMatcher(matchers) {
        return matchers.length > 1 ?
            function (elem, context, xml) {
                var i = matchers.length;
                while (i--) {
                    if (!matchers[i](elem, context, xml)) {
                        return false;
                    }
                }
                return true;
            } :
            matchers[0];
    }
    function multipleContexts(selector, contexts, results) {
        var i = 0, len = contexts.length;
        for (; i < len; i++) {
            find(selector, contexts[i], results);
        }
        return results;
    }
    function condense(unmatched, map, filter, context, xml) {
        var elem, newUnmatched = [], i = 0, len = unmatched.length, mapped = map != null;
        for (; i < len; i++) {
            if ((elem = unmatched[i])) {
                if (!filter || filter(elem, context, xml)) {
                    newUnmatched.push(elem);
                    if (mapped) {
                        map.push(i);
                    }
                }
            }
        }
        return newUnmatched;
    }
    function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {
        if (postFilter && !postFilter[jQuery.expando]) {
            postFilter = setMatcher(postFilter);
        }
        if (postFinder && !postFinder[jQuery.expando]) {
            postFinder = setMatcher(postFinder, postSelector);
        }
        return markFunction(function (seed, results, context, xml) {
            var temp, i, elem, matcherOut, preMap = [], postMap = [], preexisting = results.length, 
            // Get initial elements from seed or context
            elems = seed ||
                multipleContexts(selector || "*", context.nodeType ? [context] : context, []), 
            // Prefilter to get matcher input, preserving a map for seed-results synchronization
            matcherIn = preFilter && (seed || !selector) ?
                condense(elems, preMap, preFilter, context, xml) :
                elems;
            if (matcher) {
                // If we have a postFinder, or filtered seed, or non-seed postFilter
                // or preexisting results,
                matcherOut = postFinder || (seed ? preFilter : preexisting || postFilter) ?
                    // ...intermediate processing is necessary
                    [] :
                    // ...otherwise use results directly
                    results;
                // Find primary matches
                matcher(matcherIn, matcherOut, context, xml);
            }
            else {
                matcherOut = matcherIn;
            }
            // Apply postFilter
            if (postFilter) {
                temp = condense(matcherOut, postMap);
                postFilter(temp, [], context, xml);
                // Un-match failing elements by moving them back to matcherIn
                i = temp.length;
                while (i--) {
                    if ((elem = temp[i])) {
                        matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem);
                    }
                }
            }
            if (seed) {
                if (postFinder || preFilter) {
                    if (postFinder) {
                        // Get the final matcherOut by condensing this intermediate into postFinder contexts
                        temp = [];
                        i = matcherOut.length;
                        while (i--) {
                            if ((elem = matcherOut[i])) {
                                // Restore matcherIn since elem is not yet a final match
                                temp.push((matcherIn[i] = elem));
                            }
                        }
                        postFinder(null, (matcherOut = []), temp, xml);
                    }
                    // Move matched elements from seed to results to keep them synchronized
                    i = matcherOut.length;
                    while (i--) {
                        if ((elem = matcherOut[i]) &&
                            (temp = postFinder ? indexOf.call(seed, elem) : preMap[i]) > -1) {
                            seed[temp] = !(results[temp] = elem);
                        }
                    }
                }
                // Add elements to results, through postFinder if defined
            }
            else {
                matcherOut = condense(matcherOut === results ?
                    matcherOut.splice(preexisting, matcherOut.length) :
                    matcherOut);
                if (postFinder) {
                    postFinder(null, results, matcherOut, xml);
                }
                else {
                    push.apply(results, matcherOut);
                }
            }
        });
    }
    function matcherFromTokens(tokens) {
        var checkContext, matcher, j, len = tokens.length, leadingRelative = jQuery.expr.relative[tokens[0].type], implicitRelative = leadingRelative || jQuery.expr.relative[" "], i = leadingRelative ? 1 : 0, 
        // The foundational matcher ensures that elements are reachable from top-level context(s)
        matchContext = addCombinator(function (elem) {
            return elem === checkContext;
        }, implicitRelative, true), matchAnyContext = addCombinator(function (elem) {
            return indexOf.call(checkContext, elem) > -1;
        }, implicitRelative, true), matchers = [function (elem, context, xml) {
                // Support: IE 11+
                // IE sometimes throws a "Permission denied" error when strict-comparing
                // two documents; shallow comparisons work.
                // eslint-disable-next-line eqeqeq
                var ret = (!leadingRelative && (xml || context != outermostContext)) || ((checkContext = context).nodeType ?
                    matchContext(elem, context, xml) :
                    matchAnyContext(elem, context, xml));
                // Avoid hanging onto element
                // (see https://github.com/jquery/sizzle/issues/299)
                checkContext = null;
                return ret;
            }];
        for (; i < len; i++) {
            if ((matcher = jQuery.expr.relative[tokens[i].type])) {
                matchers = [addCombinator(elementMatcher(matchers), matcher)];
            }
            else {
                matcher = jQuery.expr.filter[tokens[i].type].apply(null, tokens[i].matches);
                // Return special upon seeing a positional matcher
                if (matcher[jQuery.expando]) {
                    // Find the next relative operator (if any) for proper handling
                    j = ++i;
                    for (; j < len; j++) {
                        if (jQuery.expr.relative[tokens[j].type]) {
                            break;
                        }
                    }
                    return setMatcher(i > 1 && elementMatcher(matchers), i > 1 && toSelector(
                    // If the preceding token was a descendant combinator, insert an implicit any-element `*`
                    tokens.slice(0, i - 1)
                        .concat({ value: tokens[i - 2].type === " " ? "*" : "" })).replace(rtrimCSS, "$1"), matcher, i < j && matcherFromTokens(tokens.slice(i, j)), j < len && matcherFromTokens((tokens = tokens.slice(j))), j < len && toSelector(tokens));
                }
                matchers.push(matcher);
            }
        }
        return elementMatcher(matchers);
    }
    function matcherFromGroupMatchers(elementMatchers, setMatchers) {
        var bySet = setMatchers.length > 0, byElement = elementMatchers.length > 0, superMatcher = function (seed, context, xml, results, outermost) {
            var elem, j, matcher, matchedCount = 0, i = "0", unmatched = seed && [], setMatched = [], contextBackup = outermostContext, 
            // We must always have either seed elements or outermost context
            elems = seed || byElement && jQuery.expr.find.TAG("*", outermost), 
            // Use integer dirruns iff this is the outermost matcher
            dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1);
            if (outermost) {
                // Support: IE 11+
                // IE sometimes throws a "Permission denied" error when strict-comparing
                // two documents; shallow comparisons work.
                // eslint-disable-next-line eqeqeq
                outermostContext = context == document$1 || context || outermost;
            }
            // Add elements passing elementMatchers directly to results
            for (; (elem = elems[i]) != null; i++) {
                if (byElement && elem) {
                    j = 0;
                    // Support: IE 11+
                    // IE sometimes throws a "Permission denied" error when strict-comparing
                    // two documents; shallow comparisons work.
                    // eslint-disable-next-line eqeqeq
                    if (!context && elem.ownerDocument != document$1) {
                        setDocument(elem);
                        xml = !documentIsHTML;
                    }
                    while ((matcher = elementMatchers[j++])) {
                        if (matcher(elem, context || document$1, xml)) {
                            push.call(results, elem);
                            break;
                        }
                    }
                    if (outermost) {
                        dirruns = dirrunsUnique;
                    }
                }
                // Track unmatched elements for set filters
                if (bySet) {
                    // They will have gone through all possible matchers
                    if ((elem = !matcher && elem)) {
                        matchedCount--;
                    }
                    // Lengthen the array for every element, matched or not
                    if (seed) {
                        unmatched.push(elem);
                    }
                }
            }
            // `i` is now the count of elements visited above, and adding it to `matchedCount`
            // makes the latter nonnegative.
            matchedCount += i;
            // Apply set filters to unmatched elements
            // NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
            // equals `i`), unless we didn't visit _any_ elements in the above loop because we have
            // no element matchers and no seed.
            // Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
            // case, which will result in a "00" `matchedCount` that differs from `i` but is also
            // numerically zero.
            if (bySet && i !== matchedCount) {
                j = 0;
                while ((matcher = setMatchers[j++])) {
                    matcher(unmatched, setMatched, context, xml);
                }
                if (seed) {
                    // Reintegrate element matches to eliminate the need for sorting
                    if (matchedCount > 0) {
                        while (i--) {
                            if (!(unmatched[i] || setMatched[i])) {
                                setMatched[i] = pop.call(results);
                            }
                        }
                    }
                    // Discard index placeholder values to get only actual matches
                    setMatched = condense(setMatched);
                }
                // Add matches to results
                push.apply(results, setMatched);
                // Seedless set matches succeeding multiple successful matchers stipulate sorting
                if (outermost && !seed && setMatched.length > 0 &&
                    (matchedCount + setMatchers.length) > 1) {
                    jQuery.uniqueSort(results);
                }
            }
            // Override manipulation of globals by nested matchers
            if (outermost) {
                dirruns = dirrunsUnique;
                outermostContext = contextBackup;
            }
            return unmatched;
        };
        return bySet ?
            markFunction(superMatcher) :
            superMatcher;
    }
    function compile(selector, match /* Internal Use Only */) {
        var i, setMatchers = [], elementMatchers = [], cached = compilerCache[selector + " "];
        if (!cached) {
            // Generate a function of recursive functions that can be used to check each element
            if (!match) {
                match = tokenize(selector);
            }
            i = match.length;
            while (i--) {
                cached = matcherFromTokens(match[i]);
                if (cached[jQuery.expando]) {
                    setMatchers.push(cached);
                }
                else {
                    elementMatchers.push(cached);
                }
            }
            // Cache the compiled function
            cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers));
            // Save selector and tokenization
            cached.selector = selector;
        }
        return cached;
    }
    /**
     * A low-level selection function that works with jQuery's compiled
     *  selector functions
     * @param {String|Function} selector A selector or a pre-compiled
     *  selector function built with jQuery selector compile
     * @param {Element} context
     * @param {Array} [results]
     * @param {Array} [seed] A set of elements to match against
     */
    function select(selector, context, results, seed) {
        var i, tokens, token, type, find, compiled = typeof selector === "function" && selector, match = !seed && tokenize((selector = compiled.selector || selector));
        results = results || [];
        // Try to minimize operations if there is only one selector in the list and no seed
        // (the latter of which guarantees us context)
        if (match.length === 1) {
            // Reduce context if the leading compound selector is an ID
            tokens = match[0] = match[0].slice(0);
            if (tokens.length > 2 && (token = tokens[0]).type === "ID" &&
                context.nodeType === 9 && documentIsHTML &&
                jQuery.expr.relative[tokens[1].type]) {
                context = (jQuery.expr.find.ID(unescapeSelector(token.matches[0]), context) || [])[0];
                if (!context) {
                    return results;
                    // Precompiled matchers will still verify ancestry, so step up a level
                }
                else if (compiled) {
                    context = context.parentNode;
                }
                selector = selector.slice(tokens.shift().value.length);
            }
            // Fetch a seed set for right-to-left matching
            i = matchExpr.needsContext.test(selector) ? 0 : tokens.length;
            while (i--) {
                token = tokens[i];
                // Abort if we hit a combinator
                if (jQuery.expr.relative[(type = token.type)]) {
                    break;
                }
                if ((find = jQuery.expr.find[type])) {
                    // Search, expanding context for leading sibling combinators
                    if ((seed = find(unescapeSelector(token.matches[0]), rsibling.test(tokens[0].type) &&
                        testContext(context.parentNode) || context))) {
                        // If seed is empty or no tokens remain, we can return early
                        tokens.splice(i, 1);
                        selector = seed.length && toSelector(tokens);
                        if (!selector) {
                            push.apply(results, seed);
                            return results;
                        }
                        break;
                    }
                }
            }
        }
        // Compile and execute a filtering function if one is not provided
        // Provide `match` to avoid retokenization if we modified the selector above
        (compiled || compile(selector, match))(seed, context, !documentIsHTML, results, !context || rsibling.test(selector) && testContext(context.parentNode) || context);
        return results;
    }
    // Initialize against the default document
    setDocument();
    jQuery.find = find;
    // These have always been private, but they used to be documented as part of
    // Sizzle so let's maintain them for now for backwards compatibility purposes.
    find.compile = compile;
    find.select = select;
    find.setDocument = setDocument;
    find.tokenize = tokenize;
    return jQuery;
});

function matches(selector, elm) {
    const r = jQuery.find(selector, undefined, undefined, [elm]);
    return r.length > 0;
}
function selectOne(selector, elm) {
    const r = jQuery.find(selector, elm, undefined, undefined);
    return r[0] || null;
}
function selectAll(selector, elm) {
    return jQuery.find(selector, elm, undefined, undefined);
}

function serializeNodeToHtml(elm, opts = {}) {
    const output = {
        currentLineWidth: 0,
        indent: 0,
        isWithinBody: false,
        text: [],
    };
    if (opts.prettyHtml) {
        if (typeof opts.indentSpaces !== 'number') {
            opts.indentSpaces = 2;
        }
        if (typeof opts.newLines !== 'boolean') {
            opts.newLines = true;
        }
        opts.approximateLineWidth = -1;
    }
    else {
        opts.prettyHtml = false;
        if (typeof opts.newLines !== 'boolean') {
            opts.newLines = false;
        }
        if (typeof opts.indentSpaces !== 'number') {
            opts.indentSpaces = 0;
        }
    }
    if (typeof opts.approximateLineWidth !== 'number') {
        opts.approximateLineWidth = -1;
    }
    if (typeof opts.removeEmptyAttributes !== 'boolean') {
        opts.removeEmptyAttributes = true;
    }
    if (typeof opts.removeAttributeQuotes !== 'boolean') {
        opts.removeAttributeQuotes = false;
    }
    if (typeof opts.removeBooleanAttributeQuotes !== 'boolean') {
        opts.removeBooleanAttributeQuotes = false;
    }
    if (typeof opts.removeHtmlComments !== 'boolean') {
        opts.removeHtmlComments = false;
    }
    if (typeof opts.serializeShadowRoot !== 'boolean') {
        opts.serializeShadowRoot = false;
    }
    if (opts.outerHtml) {
        serializeToHtml(elm, opts, output, false);
    }
    else {
        for (let i = 0, ii = elm.childNodes.length; i < ii; i++) {
            serializeToHtml(elm.childNodes[i], opts, output, false);
        }
    }
    if (output.text[0] === '\n') {
        output.text.shift();
    }
    if (output.text[output.text.length - 1] === '\n') {
        output.text.pop();
    }
    return output.text.join('');
}
function serializeToHtml(node, opts, output, isShadowRoot) {
    if (node.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */ || isShadowRoot) {
        const tagName = isShadowRoot ? 'mock:shadow-root' : getTagName(node);
        if (tagName === 'body') {
            output.isWithinBody = true;
        }
        const ignoreTag = opts.excludeTags != null && opts.excludeTags.includes(tagName);
        if (ignoreTag === false) {
            const isWithinWhitespaceSensitiveNode = opts.newLines || opts.indentSpaces > 0 ? isWithinWhitespaceSensitive(node) : false;
            if (opts.newLines && !isWithinWhitespaceSensitiveNode) {
                output.text.push('\n');
                output.currentLineWidth = 0;
            }
            if (opts.indentSpaces > 0 && !isWithinWhitespaceSensitiveNode) {
                for (let i = 0; i < output.indent; i++) {
                    output.text.push(' ');
                }
                output.currentLineWidth += output.indent;
            }
            output.text.push('<' + tagName);
            output.currentLineWidth += tagName.length + 1;
            const attrsLength = node.attributes.length;
            const attributes = opts.prettyHtml && attrsLength > 1
                ? cloneAttributes(node.attributes, true)
                : node.attributes;
            for (let i = 0; i < attrsLength; i++) {
                const attr = attributes.item(i);
                const attrName = attr.name;
                if (attrName === 'style') {
                    continue;
                }
                let attrValue = attr.value;
                if (opts.removeEmptyAttributes && attrValue === '' && REMOVE_EMPTY_ATTR.has(attrName)) {
                    continue;
                }
                const attrNamespaceURI = attr.namespaceURI;
                if (attrNamespaceURI == null) {
                    output.currentLineWidth += attrName.length + 1;
                    if (opts.approximateLineWidth > 0 && output.currentLineWidth > opts.approximateLineWidth) {
                        output.text.push('\n' + attrName);
                        output.currentLineWidth = 0;
                    }
                    else {
                        output.text.push(' ' + attrName);
                    }
                }
                else if (attrNamespaceURI === 'http://www.w3.org/XML/1998/namespace') {
                    output.text.push(' xml:' + attrName);
                    output.currentLineWidth += attrName.length + 5;
                }
                else if (attrNamespaceURI === 'http://www.w3.org/2000/xmlns/') {
                    if (attrName !== 'xmlns') {
                        output.text.push(' xmlns:' + attrName);
                        output.currentLineWidth += attrName.length + 7;
                    }
                    else {
                        output.text.push(' ' + attrName);
                        output.currentLineWidth += attrName.length + 1;
                    }
                }
                else if (attrNamespaceURI === XLINK_NS) {
                    output.text.push(' xlink:' + attrName);
                    output.currentLineWidth += attrName.length + 7;
                }
                else {
                    output.text.push(' ' + attrNamespaceURI + ':' + attrName);
                    output.currentLineWidth += attrNamespaceURI.length + attrName.length + 2;
                }
                if (opts.prettyHtml && attrName === 'class') {
                    attrValue = attr.value = attrValue
                        .split(' ')
                        .filter((t) => t !== '')
                        .sort()
                        .join(' ')
                        .trim();
                }
                if (attrValue === '') {
                    if (opts.removeBooleanAttributeQuotes && BOOLEAN_ATTR.has(attrName)) {
                        continue;
                    }
                    if (opts.removeEmptyAttributes && attrName.startsWith('data-')) {
                        continue;
                    }
                }
                if (opts.removeAttributeQuotes && CAN_REMOVE_ATTR_QUOTES.test(attrValue)) {
                    output.text.push('=' + escapeString(attrValue, true));
                    output.currentLineWidth += attrValue.length + 1;
                }
                else {
                    output.text.push('="' + escapeString(attrValue, true) + '"');
                    output.currentLineWidth += attrValue.length + 3;
                }
            }
            if (node.hasAttribute('style')) {
                const cssText = node.style.cssText;
                if (opts.approximateLineWidth > 0 &&
                    output.currentLineWidth + cssText.length + 10 > opts.approximateLineWidth) {
                    output.text.push(`\nstyle="${cssText}">`);
                    output.currentLineWidth = 0;
                }
                else {
                    output.text.push(` style="${cssText}">`);
                    output.currentLineWidth += cssText.length + 10;
                }
            }
            else {
                output.text.push('>');
                output.currentLineWidth += 1;
            }
        }
        if (EMPTY_ELEMENTS.has(tagName) === false) {
            if (opts.serializeShadowRoot && node.shadowRoot != null) {
                output.indent = output.indent + opts.indentSpaces;
                serializeToHtml(node.shadowRoot, opts, output, true);
                output.indent = output.indent - opts.indentSpaces;
                if (opts.newLines &&
                    (node.childNodes.length === 0 ||
                        (node.childNodes.length === 1 &&
                            node.childNodes[0].nodeType === 3 /* NODE_TYPES.TEXT_NODE */ &&
                            node.childNodes[0].nodeValue.trim() === ''))) {
                    output.text.push('\n');
                    output.currentLineWidth = 0;
                    for (let i = 0; i < output.indent; i++) {
                        output.text.push(' ');
                    }
                    output.currentLineWidth += output.indent;
                }
            }
            if (opts.excludeTagContent == null || opts.excludeTagContent.includes(tagName) === false) {
                const childNodes = tagName === 'template' ? node.content.childNodes : node.childNodes;
                const childNodeLength = childNodes.length;
                if (childNodeLength > 0) {
                    if (childNodeLength === 1 &&
                        childNodes[0].nodeType === 3 /* NODE_TYPES.TEXT_NODE */ &&
                        (typeof childNodes[0].nodeValue !== 'string' || childNodes[0].nodeValue.trim() === '')) ;
                    else {
                        const isWithinWhitespaceSensitiveNode = opts.newLines || opts.indentSpaces > 0 ? isWithinWhitespaceSensitive(node) : false;
                        if (!isWithinWhitespaceSensitiveNode && opts.indentSpaces > 0 && ignoreTag === false) {
                            output.indent = output.indent + opts.indentSpaces;
                        }
                        for (let i = 0; i < childNodeLength; i++) {
                            serializeToHtml(childNodes[i], opts, output, false);
                        }
                        if (ignoreTag === false) {
                            if (opts.newLines && !isWithinWhitespaceSensitiveNode) {
                                output.text.push('\n');
                                output.currentLineWidth = 0;
                            }
                            if (opts.indentSpaces > 0 && !isWithinWhitespaceSensitiveNode) {
                                output.indent = output.indent - opts.indentSpaces;
                                for (let i = 0; i < output.indent; i++) {
                                    output.text.push(' ');
                                }
                                output.currentLineWidth += output.indent;
                            }
                        }
                    }
                }
                if (ignoreTag === false) {
                    output.text.push('</' + tagName + '>');
                    output.currentLineWidth += tagName.length + 3;
                }
            }
        }
        if (opts.approximateLineWidth > 0 && STRUCTURE_ELEMENTS.has(tagName)) {
            output.text.push('\n');
            output.currentLineWidth = 0;
        }
        if (tagName === 'body') {
            output.isWithinBody = false;
        }
    }
    else if (node.nodeType === 3 /* NODE_TYPES.TEXT_NODE */) {
        let textContent = node.nodeValue;
        if (typeof textContent === 'string') {
            const trimmedTextContent = textContent.trim();
            if (trimmedTextContent === '') {
                // this text node is whitespace only
                if (isWithinWhitespaceSensitive(node)) {
                    // whitespace matters within this element
                    // just add the exact text we were given
                    output.text.push(textContent);
                    output.currentLineWidth += textContent.length;
                }
                else if (opts.approximateLineWidth > 0 && !output.isWithinBody) ;
                else if (!opts.prettyHtml) {
                    // this text node is only whitespace, and it's not
                    // within a whitespace sensitive element like <pre> or <code>
                    // so replace the entire white space with a single new line
                    output.currentLineWidth += 1;
                    if (opts.approximateLineWidth > 0 && output.currentLineWidth > opts.approximateLineWidth) {
                        // good enough for a new line
                        // for perf these are all just estimates
                        // we don't care to ensure exact line lengths
                        output.text.push('\n');
                        output.currentLineWidth = 0;
                    }
                    else {
                        // let's keep it all on the same line yet
                        output.text.push(' ');
                    }
                }
            }
            else {
                // this text node has text content
                const isWithinWhitespaceSensitiveNode = opts.newLines || opts.indentSpaces > 0 || opts.prettyHtml ? isWithinWhitespaceSensitive(node) : false;
                if (opts.newLines && !isWithinWhitespaceSensitiveNode) {
                    output.text.push('\n');
                    output.currentLineWidth = 0;
                }
                if (opts.indentSpaces > 0 && !isWithinWhitespaceSensitiveNode) {
                    for (let i = 0; i < output.indent; i++) {
                        output.text.push(' ');
                    }
                    output.currentLineWidth += output.indent;
                }
                let textContentLength = textContent.length;
                if (textContentLength > 0) {
                    // this text node has text content
                    const parentTagName = node.parentNode != null && node.parentNode.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */
                        ? node.parentNode.nodeName
                        : null;
                    if (NON_ESCAPABLE_CONTENT.has(parentTagName)) {
                        // this text node cannot have its content escaped since it's going
                        // into an element like <style> or <script>
                        if (isWithinWhitespaceSensitive(node)) {
                            output.text.push(textContent);
                        }
                        else {
                            output.text.push(trimmedTextContent);
                            textContentLength = trimmedTextContent.length;
                        }
                        output.currentLineWidth += textContentLength;
                    }
                    else {
                        // this text node is going into a normal element and html can be escaped
                        if (opts.prettyHtml && !isWithinWhitespaceSensitiveNode) {
                            // pretty print the text node
                            output.text.push(escapeString(textContent.replace(/\s\s+/g, ' ').trim(), false));
                            output.currentLineWidth += textContentLength;
                        }
                        else {
                            // not pretty printing the text node
                            if (isWithinWhitespaceSensitive(node)) {
                                output.currentLineWidth += textContentLength;
                            }
                            else {
                                // this element is not a whitespace sensitive one, like <pre> or <code> so
                                // any whitespace at the start and end can be cleaned up to just be one space
                                if (/\s/.test(textContent.charAt(0))) {
                                    textContent = ' ' + textContent.trimLeft();
                                }
                                textContentLength = textContent.length;
                                if (textContentLength > 1) {
                                    if (/\s/.test(textContent.charAt(textContentLength - 1))) {
                                        if (opts.approximateLineWidth > 0 &&
                                            output.currentLineWidth + textContentLength > opts.approximateLineWidth) {
                                            textContent = textContent.trimRight() + '\n';
                                            output.currentLineWidth = 0;
                                        }
                                        else {
                                            textContent = textContent.trimRight() + ' ';
                                        }
                                    }
                                }
                                output.currentLineWidth += textContentLength;
                            }
                            output.text.push(escapeString(textContent, false));
                        }
                    }
                }
            }
        }
    }
    else if (node.nodeType === 8 /* NODE_TYPES.COMMENT_NODE */) {
        const nodeValue = node.nodeValue;
        if (opts.removeHtmlComments) {
            const isHydrateAnnotation = nodeValue.startsWith(CONTENT_REF_ID + '.') ||
                nodeValue.startsWith(ORG_LOCATION_ID + '.') ||
                nodeValue.startsWith(SLOT_NODE_ID + '.') ||
                nodeValue.startsWith(TEXT_NODE_ID + '.');
            if (!isHydrateAnnotation) {
                return;
            }
        }
        const isWithinWhitespaceSensitiveNode = opts.newLines || opts.indentSpaces > 0 ? isWithinWhitespaceSensitive(node) : false;
        if (opts.newLines && !isWithinWhitespaceSensitiveNode) {
            output.text.push('\n');
            output.currentLineWidth = 0;
        }
        if (opts.indentSpaces > 0 && !isWithinWhitespaceSensitiveNode) {
            for (let i = 0; i < output.indent; i++) {
                output.text.push(' ');
            }
            output.currentLineWidth += output.indent;
        }
        output.text.push('<!--' + nodeValue + '-->');
        output.currentLineWidth += nodeValue.length + 7;
    }
    else if (node.nodeType === 10 /* NODE_TYPES.DOCUMENT_TYPE_NODE */) {
        output.text.push('<!doctype html>');
    }
}
const AMP_REGEX = /&/g;
const NBSP_REGEX = /\u00a0/g;
const DOUBLE_QUOTE_REGEX = /"/g;
const LT_REGEX = /</g;
const GT_REGEX = />/g;
const CAN_REMOVE_ATTR_QUOTES = /^[^ \t\n\f\r"'`=<>\/\\-]+$/;
function getTagName(element) {
    if (element.namespaceURI === 'http://www.w3.org/1999/xhtml') {
        return element.nodeName.toLowerCase();
    }
    else {
        return element.nodeName;
    }
}
function escapeString(str, attrMode) {
    str = str.replace(AMP_REGEX, '&amp;').replace(NBSP_REGEX, '&nbsp;');
    if (attrMode) {
        return str.replace(DOUBLE_QUOTE_REGEX, '&quot;');
    }
    return str.replace(LT_REGEX, '&lt;').replace(GT_REGEX, '&gt;');
}
function isWithinWhitespaceSensitive(node) {
    while (node != null) {
        if (WHITESPACE_SENSITIVE.has(node.nodeName)) {
            return true;
        }
        node = node.parentNode;
    }
    return false;
}
/*@__PURE__*/ const NON_ESCAPABLE_CONTENT = new Set([
    'STYLE',
    'SCRIPT',
    'IFRAME',
    'NOSCRIPT',
    'XMP',
    'NOEMBED',
    'NOFRAMES',
    'PLAINTEXT',
]);
/*@__PURE__*/ const WHITESPACE_SENSITIVE = new Set([
    'CODE',
    'OUTPUT',
    'PLAINTEXT',
    'PRE',
    'SCRIPT',
    'TEMPLATE',
    'TEXTAREA',
]);
/*@__PURE__*/ const EMPTY_ELEMENTS = new Set([
    'area',
    'base',
    'basefont',
    'bgsound',
    'br',
    'col',
    'embed',
    'frame',
    'hr',
    'img',
    'input',
    'keygen',
    'link',
    'meta',
    'param',
    'source',
    'trace',
    'wbr',
]);
/*@__PURE__*/ const REMOVE_EMPTY_ATTR = new Set(['class', 'dir', 'id', 'lang', 'name', 'title']);
/*@__PURE__*/ const BOOLEAN_ATTR = new Set([
    'allowfullscreen',
    'async',
    'autofocus',
    'autoplay',
    'checked',
    'compact',
    'controls',
    'declare',
    'default',
    'defaultchecked',
    'defaultmuted',
    'defaultselected',
    'defer',
    'disabled',
    'enabled',
    'formnovalidate',
    'hidden',
    'indeterminate',
    'inert',
    'ismap',
    'itemscope',
    'loop',
    'multiple',
    'muted',
    'nohref',
    'nomodule',
    'noresize',
    'noshade',
    'novalidate',
    'nowrap',
    'open',
    'pauseonexit',
    'readonly',
    'required',
    'reversed',
    'scoped',
    'seamless',
    'selected',
    'sortable',
    'truespeed',
    'typemustmatch',
    'visible',
]);
/*@__PURE__*/ const STRUCTURE_ELEMENTS = new Set([
    'html',
    'body',
    'head',
    'iframe',
    'meta',
    'link',
    'base',
    'title',
    'script',
    'style',
]);

class MockNode {
    constructor(ownerDocument, nodeType, nodeName, nodeValue) {
        this.ownerDocument = ownerDocument;
        this.nodeType = nodeType;
        this.nodeName = nodeName;
        this._nodeValue = nodeValue;
        this.parentNode = null;
        this.childNodes = [];
    }
    appendChild(newNode) {
        if (newNode.nodeType === 11 /* NODE_TYPES.DOCUMENT_FRAGMENT_NODE */) {
            const nodes = newNode.childNodes.slice();
            for (const child of nodes) {
                this.appendChild(child);
            }
        }
        else {
            newNode.remove();
            newNode.parentNode = this;
            this.childNodes.push(newNode);
            connectNode(this.ownerDocument, newNode);
        }
        return newNode;
    }
    append(...items) {
        items.forEach((item) => {
            const isNode = typeof item === 'object' && item !== null && 'nodeType' in item;
            this.appendChild(isNode ? item : this.ownerDocument.createTextNode(String(item)));
        });
    }
    prepend(...items) {
        const firstChild = this.firstChild;
        items.forEach((item) => {
            const isNode = typeof item === 'object' && item !== null && 'nodeType' in item;
            if (firstChild) {
                this.insertBefore(isNode ? item : this.ownerDocument.createTextNode(String(item)), firstChild);
            }
        });
    }
    cloneNode(deep) {
        throw new Error(`invalid node type to clone: ${this.nodeType}, deep: ${deep}`);
    }
    compareDocumentPosition(_other) {
        // unimplemented
        // https://developer.mozilla.org/en-US/docs/Web/API/Node/compareDocumentPosition
        return -1;
    }
    get firstChild() {
        return this.childNodes[0] || null;
    }
    insertBefore(newNode, referenceNode) {
        if (newNode.nodeType === 11 /* NODE_TYPES.DOCUMENT_FRAGMENT_NODE */) {
            for (let i = 0, ii = newNode.childNodes.length; i < ii; i++) {
                insertBefore(this, newNode.childNodes[i], referenceNode);
            }
        }
        else {
            insertBefore(this, newNode, referenceNode);
        }
        return newNode;
    }
    get isConnected() {
        let node = this;
        while (node != null) {
            if (node.nodeType === 9 /* NODE_TYPES.DOCUMENT_NODE */) {
                return true;
            }
            node = node.parentNode;
            if (node != null && node.nodeType === 11 /* NODE_TYPES.DOCUMENT_FRAGMENT_NODE */) {
                node = node.host;
            }
        }
        return false;
    }
    isSameNode(node) {
        return this === node;
    }
    get lastChild() {
        return this.childNodes[this.childNodes.length - 1] || null;
    }
    get nextSibling() {
        if (this.parentNode != null) {
            const index = this.parentNode.childNodes.indexOf(this) + 1;
            return this.parentNode.childNodes[index] || null;
        }
        return null;
    }
    get nodeValue() {
        var _a;
        return (_a = this._nodeValue) !== null && _a !== void 0 ? _a : '';
    }
    set nodeValue(value) {
        this._nodeValue = value;
    }
    get parentElement() {
        return this.parentNode || null;
    }
    set parentElement(value) {
        this.parentNode = value;
    }
    get previousSibling() {
        if (this.parentNode != null) {
            const index = this.parentNode.childNodes.indexOf(this) - 1;
            return this.parentNode.childNodes[index] || null;
        }
        return null;
    }
    contains(otherNode) {
        if (otherNode === this) {
            return true;
        }
        const childNodes = Array.from(this.childNodes);
        if (childNodes.includes(otherNode)) {
            return true;
        }
        return childNodes.some((node) => this.contains.bind(node)(otherNode));
    }
    removeChild(childNode) {
        const index = this.childNodes.indexOf(childNode);
        if (index > -1) {
            this.childNodes.splice(index, 1);
            if (this.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */) {
                const wasConnected = this.isConnected;
                childNode.parentNode = null;
                if (wasConnected === true) {
                    disconnectNode(childNode);
                }
            }
            else {
                childNode.parentNode = null;
            }
        }
        else {
            throw new Error(`node not found within childNodes during removeChild`);
        }
        return childNode;
    }
    remove() {
        if (this.parentNode != null) {
            this.parentNode.removeChild(this);
        }
    }
    replaceChild(newChild, oldChild) {
        if (oldChild.parentNode === this) {
            this.insertBefore(newChild, oldChild);
            oldChild.remove();
            return newChild;
        }
        return null;
    }
    get textContent() {
        var _a;
        return (_a = this._nodeValue) !== null && _a !== void 0 ? _a : '';
    }
    set textContent(value) {
        this._nodeValue = String(value);
    }
}
MockNode.ELEMENT_NODE = 1;
MockNode.TEXT_NODE = 3;
MockNode.PROCESSING_INSTRUCTION_NODE = 7;
MockNode.COMMENT_NODE = 8;
MockNode.DOCUMENT_NODE = 9;
MockNode.DOCUMENT_TYPE_NODE = 10;
MockNode.DOCUMENT_FRAGMENT_NODE = 11;
class MockNodeList {
    constructor(ownerDocument, childNodes, length) {
        this.ownerDocument = ownerDocument;
        this.childNodes = childNodes;
        this.length = length;
    }
}
class MockElement extends MockNode {
    attachInternals() {
        return new Proxy({}, {
            get: function (_target, prop, _receiver) {
                console.error(`NOTE: Property ${String(prop)} was accessed on ElementInternals, but this property is not implemented.
Testing components with ElementInternals is fully supported in e2e tests.`);
            },
        });
    }
    constructor(ownerDocument, nodeName, namespaceURI = null) {
        super(ownerDocument, 1 /* NODE_TYPES.ELEMENT_NODE */, typeof nodeName === 'string' ? nodeName : null, null);
        this.__namespaceURI = namespaceURI;
        this.__shadowRoot = null;
        this.__attributeMap = null;
    }
    addEventListener(type, handler) {
        addEventListener(this, type, handler);
    }
    attachShadow(_opts) {
        const shadowRoot = this.ownerDocument.createDocumentFragment();
        this.shadowRoot = shadowRoot;
        return shadowRoot;
    }
    blur() {
        dispatchEvent(this, new MockFocusEvent('blur', { relatedTarget: null, bubbles: true, cancelable: true, composed: true }));
    }
    get namespaceURI() {
        return this.__namespaceURI;
    }
    get shadowRoot() {
        return this.__shadowRoot || null;
    }
    set shadowRoot(shadowRoot) {
        if (shadowRoot != null) {
            shadowRoot.host = this;
            this.__shadowRoot = shadowRoot;
        }
        else {
            delete this.__shadowRoot;
        }
    }
    get attributes() {
        if (this.__attributeMap == null) {
            const attrMap = createAttributeProxy(false);
            this.__attributeMap = attrMap;
            return attrMap;
        }
        return this.__attributeMap;
    }
    set attributes(attrs) {
        this.__attributeMap = attrs;
    }
    get children() {
        return this.childNodes.filter((n) => n.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */);
    }
    get childElementCount() {
        return this.childNodes.filter((n) => n.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */).length;
    }
    get className() {
        return this.getAttributeNS(null, 'class') || '';
    }
    set className(value) {
        this.setAttributeNS(null, 'class', value);
    }
    get classList() {
        return new MockClassList(this);
    }
    click() {
        dispatchEvent(this, new MockEvent('click', { bubbles: true, cancelable: true, composed: true }));
    }
    cloneNode(_deep) {
        // implemented on MockElement.prototype from within element.ts
        // @ts-ignore - implemented on MockElement.prototype from within element.ts
        return null;
    }
    closest(selector) {
        let elm = this;
        while (elm != null) {
            if (elm.matches(selector)) {
                return elm;
            }
            elm = elm.parentNode;
        }
        return null;
    }
    get dataset() {
        return dataset(this);
    }
    get dir() {
        return this.getAttributeNS(null, 'dir') || '';
    }
    set dir(value) {
        this.setAttributeNS(null, 'dir', value);
    }
    dispatchEvent(ev) {
        return dispatchEvent(this, ev);
    }
    get firstElementChild() {
        return this.children[0] || null;
    }
    focus(_options) {
        dispatchEvent(this, new MockFocusEvent('focus', { relatedTarget: null, bubbles: true, cancelable: true, composed: true }));
    }
    getAttribute(attrName) {
        if (attrName === 'style') {
            if (this.__style != null && this.__style.length > 0) {
                return this.style.cssText;
            }
            return null;
        }
        const attr = this.attributes.getNamedItem(attrName);
        if (attr != null) {
            return attr.value;
        }
        return null;
    }
    getAttributeNS(namespaceURI, attrName) {
        const attr = this.attributes.getNamedItemNS(namespaceURI, attrName);
        if (attr != null) {
            return attr.value;
        }
        return null;
    }
    getAttributeNode(attrName) {
        if (!this.hasAttribute(attrName)) {
            return null;
        }
        return new MockAttr(attrName, this.getAttribute(attrName));
    }
    getBoundingClientRect() {
        return { bottom: 0, height: 0, left: 0, right: 0, top: 0, width: 0, x: 0, y: 0 };
    }
    getRootNode(opts) {
        const isComposed = opts != null && opts.composed === true;
        let node = this;
        while (node.parentNode != null) {
            node = node.parentNode;
            if (isComposed === true && node.parentNode == null && node.host != null) {
                node = node.host;
            }
        }
        return node;
    }
    get draggable() {
        return this.getAttributeNS(null, 'draggable') === 'true';
    }
    set draggable(value) {
        this.setAttributeNS(null, 'draggable', value);
    }
    hasChildNodes() {
        return this.childNodes.length > 0;
    }
    get id() {
        return this.getAttributeNS(null, 'id') || '';
    }
    set id(value) {
        this.setAttributeNS(null, 'id', value);
    }
    get innerHTML() {
        if (this.childNodes.length === 0) {
            return '';
        }
        return serializeNodeToHtml(this, {
            newLines: false,
            indentSpaces: 0,
        });
    }
    set innerHTML(html) {
        var _a;
        if (NON_ESCAPABLE_CONTENT.has((_a = this.nodeName) !== null && _a !== void 0 ? _a : '') === true) {
            setTextContent(this, html);
        }
        else {
            for (let i = this.childNodes.length - 1; i >= 0; i--) {
                this.removeChild(this.childNodes[i]);
            }
            if (typeof html === 'string') {
                const frag = parseFragmentUtil(this.ownerDocument, html);
                while (frag.childNodes.length > 0) {
                    this.appendChild(frag.childNodes[0]);
                }
            }
        }
    }
    get innerText() {
        const text = [];
        getTextContent(this.childNodes, text);
        return text.join('');
    }
    set innerText(value) {
        setTextContent(this, value);
    }
    insertAdjacentElement(position, elm) {
        if (position === 'beforebegin') {
            insertBefore(this.parentNode, elm, this);
        }
        else if (position === 'afterbegin') {
            this.prepend(elm);
        }
        else if (position === 'beforeend') {
            this.appendChild(elm);
        }
        else if (position === 'afterend') {
            insertBefore(this.parentNode, elm, this.nextSibling);
        }
        return elm;
    }
    insertAdjacentHTML(position, html) {
        const frag = parseFragmentUtil(this.ownerDocument, html);
        if (position === 'beforebegin') {
            while (frag.childNodes.length > 0) {
                insertBefore(this.parentNode, frag.childNodes[0], this);
            }
        }
        else if (position === 'afterbegin') {
            while (frag.childNodes.length > 0) {
                this.prepend(frag.childNodes[frag.childNodes.length - 1]);
            }
        }
        else if (position === 'beforeend') {
            while (frag.childNodes.length > 0) {
                this.appendChild(frag.childNodes[0]);
            }
        }
        else if (position === 'afterend') {
            while (frag.childNodes.length > 0) {
                insertBefore(this.parentNode, frag.childNodes[frag.childNodes.length - 1], this.nextSibling);
            }
        }
    }
    insertAdjacentText(position, text) {
        const elm = this.ownerDocument.createTextNode(text);
        if (position === 'beforebegin') {
            insertBefore(this.parentNode, elm, this);
        }
        else if (position === 'afterbegin') {
            this.prepend(elm);
        }
        else if (position === 'beforeend') {
            this.appendChild(elm);
        }
        else if (position === 'afterend') {
            insertBefore(this.parentNode, elm, this.nextSibling);
        }
    }
    hasAttribute(attrName) {
        if (attrName === 'style') {
            return this.__style != null && this.__style.length > 0;
        }
        return this.getAttribute(attrName) !== null;
    }
    hasAttributeNS(namespaceURI, name) {
        return this.getAttributeNS(namespaceURI, name) !== null;
    }
    get hidden() {
        return this.hasAttributeNS(null, 'hidden');
    }
    set hidden(isHidden) {
        if (isHidden === true) {
            this.setAttributeNS(null, 'hidden', '');
        }
        else {
            this.removeAttributeNS(null, 'hidden');
        }
    }
    get lang() {
        return this.getAttributeNS(null, 'lang') || '';
    }
    set lang(value) {
        this.setAttributeNS(null, 'lang', value);
    }
    get lastElementChild() {
        const children = this.children;
        return children[children.length - 1] || null;
    }
    matches(selector) {
        return matches(selector, this);
    }
    get nextElementSibling() {
        const parentElement = this.parentElement;
        if (parentElement != null &&
            (parentElement.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */ ||
                parentElement.nodeType === 11 /* NODE_TYPES.DOCUMENT_FRAGMENT_NODE */ ||
                parentElement.nodeType === 9 /* NODE_TYPES.DOCUMENT_NODE */)) {
            const children = parentElement.children;
            const index = children.indexOf(this) + 1;
            return parentElement.children[index] || null;
        }
        return null;
    }
    get outerHTML() {
        return serializeNodeToHtml(this, {
            newLines: false,
            outerHtml: true,
            indentSpaces: 0,
        });
    }
    get previousElementSibling() {
        const parentElement = this.parentElement;
        if (parentElement != null &&
            (parentElement.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */ ||
                parentElement.nodeType === 11 /* NODE_TYPES.DOCUMENT_FRAGMENT_NODE */ ||
                parentElement.nodeType === 9 /* NODE_TYPES.DOCUMENT_NODE */)) {
            const children = parentElement.children;
            const index = children.indexOf(this) - 1;
            return parentElement.children[index] || null;
        }
        return null;
    }
    getElementsByClassName(classNames) {
        const classes = classNames
            .trim()
            .split(' ')
            .filter((c) => c.length > 0);
        const results = [];
        getElementsByClassName(this, classes, results);
        return results;
    }
    getElementsByTagName(tagName) {
        const results = [];
        getElementsByTagName(this, tagName.toLowerCase(), results);
        return results;
    }
    querySelector(selector) {
        return selectOne(selector, this);
    }
    querySelectorAll(selector) {
        return selectAll(selector, this);
    }
    removeAttribute(attrName) {
        if (attrName === 'style') {
            delete this.__style;
        }
        else {
            const attr = this.attributes.getNamedItem(attrName);
            if (attr != null) {
                this.attributes.removeNamedItemNS(attr);
                if (checkAttributeChanged(this) === true) {
                    attributeChanged(this, attrName, attr.value, null);
                }
            }
        }
    }
    removeAttributeNS(namespaceURI, attrName) {
        const attr = this.attributes.getNamedItemNS(namespaceURI, attrName);
        if (attr != null) {
            this.attributes.removeNamedItemNS(attr);
            if (checkAttributeChanged(this) === true) {
                attributeChanged(this, attrName, attr.value, null);
            }
        }
    }
    removeEventListener(type, handler) {
        removeEventListener(this, type, handler);
    }
    setAttribute(attrName, value) {
        if (attrName === 'style') {
            this.style = value;
        }
        else {
            const attributes = this.attributes;
            let attr = attributes.getNamedItem(attrName);
            const checkAttrChanged = checkAttributeChanged(this);
            if (attr != null) {
                if (checkAttrChanged === true) {
                    const oldValue = attr.value;
                    attr.value = value;
                    if (oldValue !== attr.value) {
                        attributeChanged(this, attr.name, oldValue, attr.value);
                    }
                }
                else {
                    attr.value = value;
                }
            }
            else {
                if (attributes.caseInsensitive) {
                    attrName = attrName.toLowerCase();
                }
                attr = new MockAttr(attrName, value);
                attributes.__items.push(attr);
                if (checkAttrChanged === true) {
                    attributeChanged(this, attrName, null, attr.value);
                }
            }
        }
    }
    setAttributeNS(namespaceURI, attrName, value) {
        const attributes = this.attributes;
        let attr = attributes.getNamedItemNS(namespaceURI, attrName);
        const checkAttrChanged = checkAttributeChanged(this);
        if (attr != null) {
            if (checkAttrChanged === true) {
                const oldValue = attr.value;
                attr.value = value;
                if (oldValue !== attr.value) {
                    attributeChanged(this, attr.name, oldValue, attr.value);
                }
            }
            else {
                attr.value = value;
            }
        }
        else {
            attr = new MockAttr(attrName, value, namespaceURI);
            attributes.__items.push(attr);
            if (checkAttrChanged === true) {
                attributeChanged(this, attrName, null, attr.value);
            }
        }
    }
    get style() {
        if (this.__style == null) {
            this.__style = createCSSStyleDeclaration();
        }
        return this.__style;
    }
    set style(val) {
        if (typeof val === 'string') {
            if (this.__style == null) {
                this.__style = createCSSStyleDeclaration();
            }
            this.__style.cssText = val;
        }
        else {
            this.__style = val;
        }
    }
    get tabIndex() {
        return parseInt(this.getAttributeNS(null, 'tabindex') || '-1', 10);
    }
    set tabIndex(value) {
        this.setAttributeNS(null, 'tabindex', value);
    }
    get tagName() {
        var _a;
        return (_a = this.nodeName) !== null && _a !== void 0 ? _a : '';
    }
    set tagName(value) {
        this.nodeName = value;
    }
    get textContent() {
        const text = [];
        getTextContent(this.childNodes, text);
        return text.join('');
    }
    set textContent(value) {
        setTextContent(this, value);
    }
    get title() {
        return this.getAttributeNS(null, 'title') || '';
    }
    set title(value) {
        this.setAttributeNS(null, 'title', value);
    }
    animate() {
        /**/
    }
    onanimationstart() {
        /**/
    }
    onanimationend() {
        /**/
    }
    onanimationiteration() {
        /**/
    }
    onabort() {
        /**/
    }
    onauxclick() {
        /**/
    }
    onbeforecopy() {
        /**/
    }
    onbeforecut() {
        /**/
    }
    onbeforepaste() {
        /**/
    }
    onblur() {
        /**/
    }
    oncancel() {
        /**/
    }
    oncanplay() {
        /**/
    }
    oncanplaythrough() {
        /**/
    }
    onchange() {
        /**/
    }
    onclick() {
        /**/
    }
    onclose() {
        /**/
    }
    oncontextmenu() {
        /**/
    }
    oncopy() {
        /**/
    }
    oncuechange() {
        /**/
    }
    oncut() {
        /**/
    }
    ondblclick() {
        /**/
    }
    ondrag() {
        /**/
    }
    ondragend() {
        /**/
    }
    ondragenter() {
        /**/
    }
    ondragleave() {
        /**/
    }
    ondragover() {
        /**/
    }
    ondragstart() {
        /**/
    }
    ondrop() {
        /**/
    }
    ondurationchange() {
        /**/
    }
    onemptied() {
        /**/
    }
    onended() {
        /**/
    }
    onerror() {
        /**/
    }
    onfocus() {
        /**/
    }
    onfocusin() {
        /**/
    }
    onfocusout() {
        /**/
    }
    onformdata() {
        /**/
    }
    onfullscreenchange() {
        /**/
    }
    onfullscreenerror() {
        /**/
    }
    ongotpointercapture() {
        /**/
    }
    oninput() {
        /**/
    }
    oninvalid() {
        /**/
    }
    onkeydown() {
        /**/
    }
    onkeypress() {
        /**/
    }
    onkeyup() {
        /**/
    }
    onload() {
        /**/
    }
    onloadeddata() {
        /**/
    }
    onloadedmetadata() {
        /**/
    }
    onloadstart() {
        /**/
    }
    onlostpointercapture() {
        /**/
    }
    onmousedown() {
        /**/
    }
    onmouseenter() {
        /**/
    }
    onmouseleave() {
        /**/
    }
    onmousemove() {
        /**/
    }
    onmouseout() {
        /**/
    }
    onmouseover() {
        /**/
    }
    onmouseup() {
        /**/
    }
    onmousewheel() {
        /**/
    }
    onpaste() {
        /**/
    }
    onpause() {
        /**/
    }
    onplay() {
        /**/
    }
    onplaying() {
        /**/
    }
    onpointercancel() {
        /**/
    }
    onpointerdown() {
        /**/
    }
    onpointerenter() {
        /**/
    }
    onpointerleave() {
        /**/
    }
    onpointermove() {
        /**/
    }
    onpointerout() {
        /**/
    }
    onpointerover() {
        /**/
    }
    onpointerup() {
        /**/
    }
    onprogress() {
        /**/
    }
    onratechange() {
        /**/
    }
    onreset() {
        /**/
    }
    onresize() {
        /**/
    }
    onscroll() {
        /**/
    }
    onsearch() {
        /**/
    }
    onseeked() {
        /**/
    }
    onseeking() {
        /**/
    }
    onselect() {
        /**/
    }
    onselectstart() {
        /**/
    }
    onstalled() {
        /**/
    }
    onsubmit() {
        /**/
    }
    onsuspend() {
        /**/
    }
    ontimeupdate() {
        /**/
    }
    ontoggle() {
        /**/
    }
    onvolumechange() {
        /**/
    }
    onwaiting() {
        /**/
    }
    onwebkitfullscreenchange() {
        /**/
    }
    onwebkitfullscreenerror() {
        /**/
    }
    onwheel() {
        /**/
    }
    requestFullscreen() {
        /**/
    }
    scrollBy() {
        /**/
    }
    scrollTo() {
        /**/
    }
    scrollIntoView() {
        /**/
    }
    toString(opts) {
        return serializeNodeToHtml(this, opts);
    }
}
function getElementsByClassName(elm, classNames, foundElms) {
    const children = elm.children;
    for (let i = 0, ii = children.length; i < ii; i++) {
        const childElm = children[i];
        for (let j = 0, jj = classNames.length; j < jj; j++) {
            if (childElm.classList.contains(classNames[j])) {
                foundElms.push(childElm);
            }
        }
        getElementsByClassName(childElm, classNames, foundElms);
    }
}
function getElementsByTagName(elm, tagName, foundElms) {
    var _a;
    const children = elm.children;
    for (let i = 0, ii = children.length; i < ii; i++) {
        const childElm = children[i];
        if (tagName === '*' || ((_a = childElm.nodeName) !== null && _a !== void 0 ? _a : '').toLowerCase() === tagName) {
            foundElms.push(childElm);
        }
        getElementsByTagName(childElm, tagName, foundElms);
    }
}
function resetElement(elm) {
    resetEventListeners(elm);
    delete elm.__attributeMap;
    delete elm.__shadowRoot;
    delete elm.__style;
}
function insertBefore(parentNode, newNode, referenceNode) {
    if (newNode !== referenceNode) {
        newNode.remove();
        newNode.parentNode = parentNode;
        newNode.ownerDocument = parentNode.ownerDocument;
        if (referenceNode != null) {
            const index = parentNode.childNodes.indexOf(referenceNode);
            if (index > -1) {
                parentNode.childNodes.splice(index, 0, newNode);
            }
            else {
                throw new Error(`referenceNode not found in parentNode.childNodes`);
            }
        }
        else {
            parentNode.childNodes.push(newNode);
        }
        connectNode(parentNode.ownerDocument, newNode);
    }
    return newNode;
}
class MockHTMLElement extends MockElement {
    constructor(ownerDocument, nodeName) {
        super(ownerDocument, typeof nodeName === 'string' ? nodeName.toUpperCase() : null);
        this.__namespaceURI = 'http://www.w3.org/1999/xhtml';
    }
    get tagName() {
        var _a;
        return (_a = this.nodeName) !== null && _a !== void 0 ? _a : '';
    }
    set tagName(value) {
        this.nodeName = value;
    }
    get attributes() {
        if (this.__attributeMap == null) {
            const attrMap = createAttributeProxy(true);
            this.__attributeMap = attrMap;
            return attrMap;
        }
        return this.__attributeMap;
    }
    set attributes(attrs) {
        this.__attributeMap = attrs;
    }
}
class MockTextNode extends MockNode {
    constructor(ownerDocument, text) {
        super(ownerDocument, 3 /* NODE_TYPES.TEXT_NODE */, "#text" /* NODE_NAMES.TEXT_NODE */, text);
    }
    cloneNode(_deep) {
        return new MockTextNode(null, this.nodeValue);
    }
    get textContent() {
        return this.nodeValue;
    }
    set textContent(text) {
        this.nodeValue = text;
    }
    get data() {
        return this.nodeValue;
    }
    set data(text) {
        this.nodeValue = text;
    }
    get wholeText() {
        if (this.parentNode != null) {
            const text = [];
            for (let i = 0, ii = this.parentNode.childNodes.length; i < ii; i++) {
                const childNode = this.parentNode.childNodes[i];
                if (childNode.nodeType === 3 /* NODE_TYPES.TEXT_NODE */) {
                    text.push(childNode.nodeValue);
                }
            }
            return text.join('');
        }
        return this.nodeValue;
    }
}
function getTextContent(childNodes, text) {
    for (let i = 0, ii = childNodes.length; i < ii; i++) {
        const childNode = childNodes[i];
        if (childNode.nodeType === 3 /* NODE_TYPES.TEXT_NODE */) {
            text.push(childNode.nodeValue);
        }
        else if (childNode.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */) {
            getTextContent(childNode.childNodes, text);
        }
    }
}
function setTextContent(elm, text) {
    for (let i = elm.childNodes.length - 1; i >= 0; i--) {
        elm.removeChild(elm.childNodes[i]);
    }
    const textNode = new MockTextNode(elm.ownerDocument, text);
    elm.appendChild(textNode);
}

class MockComment extends MockNode {
    constructor(ownerDocument, data) {
        super(ownerDocument, 8 /* NODE_TYPES.COMMENT_NODE */, "#comment" /* NODE_NAMES.COMMENT_NODE */, data);
    }
    cloneNode(_deep) {
        return new MockComment(null, this.nodeValue);
    }
    get textContent() {
        return this.nodeValue;
    }
    set textContent(text) {
        this.nodeValue = text;
    }
}

class MockDocumentFragment extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, null);
        this.nodeName = "#document-fragment" /* NODE_NAMES.DOCUMENT_FRAGMENT_NODE */;
        this.nodeType = 11 /* NODE_TYPES.DOCUMENT_FRAGMENT_NODE */;
    }
    getElementById(id) {
        return getElementById(this, id);
    }
    cloneNode(deep) {
        const cloned = new MockDocumentFragment(null);
        if (deep) {
            for (let i = 0, ii = this.childNodes.length; i < ii; i++) {
                const childNode = this.childNodes[i];
                if (childNode.nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */ ||
                    childNode.nodeType === 3 /* NODE_TYPES.TEXT_NODE */ ||
                    childNode.nodeType === 8 /* NODE_TYPES.COMMENT_NODE */) {
                    const clonedChildNode = this.childNodes[i].cloneNode(true);
                    cloned.appendChild(clonedChildNode);
                }
            }
        }
        return cloned;
    }
}

class MockDocumentTypeNode extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, '!DOCTYPE');
        this.nodeType = 10 /* NODE_TYPES.DOCUMENT_TYPE_NODE */;
        this.setAttribute('html', '');
    }
}

class MockCSSRule {
    constructor(parentStyleSheet) {
        this.parentStyleSheet = parentStyleSheet;
        this.cssText = '';
        this.type = 0;
    }
}
class MockCSSStyleSheet {
    constructor(ownerNode) {
        this.type = 'text/css';
        this.parentStyleSheet = null;
        this.cssRules = [];
        this.ownerNode = ownerNode;
    }
    get rules() {
        return this.cssRules;
    }
    set rules(rules) {
        this.cssRules = rules;
    }
    deleteRule(index) {
        if (index >= 0 && index < this.cssRules.length) {
            this.cssRules.splice(index, 1);
            updateStyleTextNode(this.ownerNode);
        }
    }
    insertRule(rule, index = 0) {
        if (typeof index !== 'number') {
            index = 0;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > this.cssRules.length) {
            index = this.cssRules.length;
        }
        const cssRule = new MockCSSRule(this);
        cssRule.cssText = rule;
        this.cssRules.splice(index, 0, cssRule);
        updateStyleTextNode(this.ownerNode);
        return index;
    }
}
function getStyleElementText(styleElm) {
    const output = [];
    for (let i = 0; i < styleElm.childNodes.length; i++) {
        output.push(styleElm.childNodes[i].nodeValue);
    }
    return output.join('');
}
function setStyleElementText(styleElm, text) {
    // keeping the innerHTML and the sheet.cssRules connected
    // is not technically correct, but since we're doing
    // SSR we'll need to turn any assigned cssRules into
    // real text, not just properties that aren't rendered
    const sheet = styleElm.sheet;
    sheet.cssRules.length = 0;
    sheet.insertRule(text);
    updateStyleTextNode(styleElm);
}
function updateStyleTextNode(styleElm) {
    const childNodeLen = styleElm.childNodes.length;
    if (childNodeLen > 1) {
        for (let i = childNodeLen - 1; i >= 1; i--) {
            styleElm.removeChild(styleElm.childNodes[i]);
        }
    }
    else if (childNodeLen < 1) {
        styleElm.appendChild(styleElm.ownerDocument.createTextNode(''));
    }
    const textNode = styleElm.childNodes[0];
    textNode.nodeValue = styleElm.sheet.cssRules.map((r) => r.cssText).join('\n');
}

function createElement(ownerDocument, tagName) {
    if (typeof tagName !== 'string' || tagName === '' || !/^[a-z0-9-_:]+$/i.test(tagName)) {
        throw new Error(`The tag name provided (${tagName}) is not a valid name.`);
    }
    tagName = tagName.toLowerCase();
    switch (tagName) {
        case 'a':
            return new MockAnchorElement(ownerDocument);
        case 'base':
            return new MockBaseElement(ownerDocument);
        case 'button':
            return new MockButtonElement(ownerDocument);
        case 'canvas':
            return new MockCanvasElement(ownerDocument);
        case 'form':
            return new MockFormElement(ownerDocument);
        case 'img':
            return new MockImageElement(ownerDocument);
        case 'input':
            return new MockInputElement(ownerDocument);
        case 'link':
            return new MockLinkElement(ownerDocument);
        case 'meta':
            return new MockMetaElement(ownerDocument);
        case 'script':
            return new MockScriptElement(ownerDocument);
        case 'style':
            return new MockStyleElement(ownerDocument);
        case 'template':
            return new MockTemplateElement(ownerDocument);
        case 'title':
            return new MockTitleElement(ownerDocument);
        case 'ul':
            return new MockUListElement(ownerDocument);
    }
    if (ownerDocument != null && tagName.includes('-')) {
        const win = ownerDocument.defaultView;
        if (win != null && win.customElements != null) {
            return createCustomElement(win.customElements, ownerDocument, tagName);
        }
    }
    return new MockHTMLElement(ownerDocument, tagName);
}
function createElementNS(ownerDocument, namespaceURI, tagName) {
    if (namespaceURI === 'http://www.w3.org/1999/xhtml') {
        return createElement(ownerDocument, tagName);
    }
    else if (namespaceURI === 'http://www.w3.org/2000/svg') {
        switch (tagName.toLowerCase()) {
            case 'text':
            case 'tspan':
            case 'tref':
            case 'altglyph':
            case 'textpath':
                return new MockSVGTextContentElement(ownerDocument, tagName);
            case 'circle':
            case 'ellipse':
            case 'image':
            case 'line':
            case 'path':
            case 'polygon':
            case 'polyline':
            case 'rect':
            case 'use':
                return new MockSVGGraphicsElement(ownerDocument, tagName);
            case 'svg':
                return new MockSVGSVGElement(ownerDocument, tagName);
            default:
                return new MockSVGElement(ownerDocument, tagName);
        }
    }
    else {
        return new MockElement(ownerDocument, tagName, namespaceURI);
    }
}
class MockAnchorElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'a');
    }
    get href() {
        return fullUrl(this, 'href');
    }
    set href(value) {
        this.setAttribute('href', value);
    }
    get pathname() {
        return new URL(this.href).pathname;
    }
}
class MockButtonElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'button');
    }
}
patchPropAttributes(MockButtonElement.prototype, {
    type: String,
}, {
    type: 'submit',
});
class MockImageElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'img');
    }
    get draggable() {
        return this.getAttributeNS(null, 'draggable') !== 'false';
    }
    set draggable(value) {
        this.setAttributeNS(null, 'draggable', value);
    }
    get src() {
        return fullUrl(this, 'src');
    }
    set src(value) {
        this.setAttribute('src', value);
    }
}
patchPropAttributes(MockImageElement.prototype, {
    height: Number,
    width: Number,
});
class MockInputElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'input');
    }
    get list() {
        const listId = this.getAttribute('list');
        if (listId) {
            return this.ownerDocument.getElementById(listId);
        }
        return null;
    }
}
patchPropAttributes(MockInputElement.prototype, {
    accept: String,
    autocomplete: String,
    autofocus: Boolean,
    capture: String,
    checked: Boolean,
    disabled: Boolean,
    form: String,
    formaction: String,
    formenctype: String,
    formmethod: String,
    formnovalidate: String,
    formtarget: String,
    height: Number,
    inputmode: String,
    max: String,
    maxLength: Number,
    min: String,
    minLength: Number,
    multiple: Boolean,
    name: String,
    pattern: String,
    placeholder: String,
    required: Boolean,
    readOnly: Boolean,
    size: Number,
    spellCheck: Boolean,
    src: String,
    step: String,
    type: String,
    value: String,
    width: Number,
}, {
    type: 'text',
});
class MockFormElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'form');
    }
}
patchPropAttributes(MockFormElement.prototype, {
    name: String,
});
class MockLinkElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'link');
    }
    get href() {
        return fullUrl(this, 'href');
    }
    set href(value) {
        this.setAttribute('href', value);
    }
}
patchPropAttributes(MockLinkElement.prototype, {
    crossorigin: String,
    media: String,
    rel: String,
    type: String,
});
class MockMetaElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'meta');
    }
}
patchPropAttributes(MockMetaElement.prototype, {
    charset: String,
    content: String,
    name: String,
});
class MockScriptElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'script');
    }
    get src() {
        return fullUrl(this, 'src');
    }
    set src(value) {
        this.setAttribute('src', value);
    }
}
patchPropAttributes(MockScriptElement.prototype, {
    type: String,
});
class MockDOMMatrix {
    constructor() {
        this.a = 1;
        this.b = 0;
        this.c = 0;
        this.d = 1;
        this.e = 0;
        this.f = 0;
        this.m11 = 1;
        this.m12 = 0;
        this.m13 = 0;
        this.m14 = 0;
        this.m21 = 0;
        this.m22 = 1;
        this.m23 = 0;
        this.m24 = 0;
        this.m31 = 0;
        this.m32 = 0;
        this.m33 = 1;
        this.m34 = 0;
        this.m41 = 0;
        this.m42 = 0;
        this.m43 = 0;
        this.m44 = 1;
        this.is2D = true;
        this.isIdentity = true;
    }
    static fromMatrix() {
        return new MockDOMMatrix();
    }
    inverse() {
        return new MockDOMMatrix();
    }
    flipX() {
        return new MockDOMMatrix();
    }
    flipY() {
        return new MockDOMMatrix();
    }
    multiply() {
        return new MockDOMMatrix();
    }
    rotate() {
        return new MockDOMMatrix();
    }
    rotateAxisAngle() {
        return new MockDOMMatrix();
    }
    rotateFromVector() {
        return new MockDOMMatrix();
    }
    scale() {
        return new MockDOMMatrix();
    }
    scaleNonUniform() {
        return new MockDOMMatrix();
    }
    skewX() {
        return new MockDOMMatrix();
    }
    skewY() {
        return new MockDOMMatrix();
    }
    toJSON() { }
    toString() { }
    transformPoint() {
        return new MockDOMPoint();
    }
    translate() {
        return new MockDOMMatrix();
    }
}
class MockDOMPoint {
    constructor() {
        this.w = 1;
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }
    toJSON() { }
    matrixTransform() {
        return new MockDOMMatrix();
    }
}
class MockSVGRect {
    constructor() {
        this.height = 10;
        this.width = 10;
        this.x = 0;
        this.y = 0;
    }
}
class MockStyleElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'style');
        this.sheet = new MockCSSStyleSheet(this);
    }
    get innerHTML() {
        return getStyleElementText(this);
    }
    set innerHTML(value) {
        setStyleElementText(this, value);
    }
    get innerText() {
        return getStyleElementText(this);
    }
    set innerText(value) {
        setStyleElementText(this, value);
    }
    get textContent() {
        return getStyleElementText(this);
    }
    set textContent(value) {
        setStyleElementText(this, value);
    }
}
class MockSVGElement extends MockElement {
    constructor() {
        super(...arguments);
        this.__namespaceURI = 'http://www.w3.org/2000/svg';
    }
    // SVGElement properties and methods
    get ownerSVGElement() {
        return null;
    }
    get viewportElement() {
        return null;
    }
    onunload() {
        /**/
    }
    // SVGGeometryElement properties and methods
    get pathLength() {
        return 0;
    }
    isPointInFill(_pt) {
        return false;
    }
    isPointInStroke(_pt) {
        return false;
    }
    getTotalLength() {
        return 0;
    }
}
class MockSVGGraphicsElement extends MockSVGElement {
    getBBox(_options) {
        return new MockSVGRect();
    }
    getCTM() {
        return new MockDOMMatrix();
    }
    getScreenCTM() {
        return new MockDOMMatrix();
    }
}
class MockSVGSVGElement extends MockSVGGraphicsElement {
    createSVGPoint() {
        return new MockDOMPoint();
    }
}
class MockSVGTextContentElement extends MockSVGGraphicsElement {
    getComputedTextLength() {
        return 0;
    }
}
class MockBaseElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'base');
    }
    get href() {
        return fullUrl(this, 'href');
    }
    set href(value) {
        this.setAttribute('href', value);
    }
}
class MockTemplateElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'template');
        this.content = new MockDocumentFragment(ownerDocument);
    }
    get innerHTML() {
        return this.content.innerHTML;
    }
    set innerHTML(html) {
        this.content.innerHTML = html;
    }
    cloneNode(deep) {
        const cloned = new MockTemplateElement(null);
        cloned.attributes = cloneAttributes(this.attributes);
        const styleCssText = this.getAttribute('style');
        if (styleCssText != null && styleCssText.length > 0) {
            cloned.setAttribute('style', styleCssText);
        }
        cloned.content = this.content.cloneNode(deep);
        if (deep) {
            for (let i = 0, ii = this.childNodes.length; i < ii; i++) {
                const clonedChildNode = this.childNodes[i].cloneNode(true);
                cloned.appendChild(clonedChildNode);
            }
        }
        return cloned;
    }
}
class MockTitleElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'title');
    }
    get text() {
        return this.textContent;
    }
    set text(value) {
        this.textContent = value;
    }
}
class MockUListElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'ul');
    }
}
class MockCanvasElement extends MockHTMLElement {
    constructor(ownerDocument) {
        super(ownerDocument, 'canvas');
    }
    getContext() {
        return {
            fillRect() {
                return;
            },
            clearRect() { },
            getImageData: function (_, __, w, h) {
                return {
                    data: new Array(w * h * 4),
                };
            },
            putImageData() { },
            createImageData: function () {
                return [];
            },
            setTransform() { },
            drawImage() { },
            save() { },
            fillText() { },
            restore() { },
            beginPath() { },
            moveTo() { },
            lineTo() { },
            closePath() { },
            stroke() { },
            translate() { },
            scale() { },
            rotate() { },
            arc() { },
            fill() { },
            measureText() {
                return { width: 0 };
            },
            transform() { },
            rect() { },
            clip() { },
        };
    }
}
function fullUrl(elm, attrName) {
    const val = elm.getAttribute(attrName) || '';
    if (elm.ownerDocument != null) {
        const win = elm.ownerDocument.defaultView;
        if (win != null) {
            const loc = win.location;
            if (loc != null) {
                try {
                    const url = new URL(val, loc.href);
                    return url.href;
                }
                catch (e) { }
            }
        }
    }
    return val.replace(/\'|\"/g, '').trim();
}
function patchPropAttributes(prototype, attrs, defaults = {}) {
    Object.keys(attrs).forEach((propName) => {
        const attr = attrs[propName];
        const defaultValue = defaults[propName];
        if (attr === Boolean) {
            Object.defineProperty(prototype, propName, {
                get() {
                    return this.hasAttribute(propName);
                },
                set(value) {
                    if (value) {
                        this.setAttribute(propName, '');
                    }
                    else {
                        this.removeAttribute(propName);
                    }
                },
            });
        }
        else if (attr === Number) {
            Object.defineProperty(prototype, propName, {
                get() {
                    const value = this.getAttribute(propName);
                    return value ? parseInt(value, 10) : defaultValue === undefined ? 0 : defaultValue;
                },
                set(value) {
                    this.setAttribute(propName, value);
                },
            });
        }
        else {
            Object.defineProperty(prototype, propName, {
                get() {
                    return this.hasAttribute(propName) ? this.getAttribute(propName) : defaultValue || '';
                },
                set(value) {
                    this.setAttribute(propName, value);
                },
            });
        }
    });
}
MockElement.prototype.cloneNode = function (deep) {
    // because we're creating elements, which extending specific HTML base classes there
    // is a MockElement circular reference that bundling has trouble dealing with so
    // the fix is to add cloneNode() to MockElement's prototype after the HTML classes
    const cloned = createElement(this.ownerDocument, this.nodeName);
    cloned.attributes = cloneAttributes(this.attributes);
    const styleCssText = this.getAttribute('style');
    if (styleCssText != null && styleCssText.length > 0) {
        cloned.setAttribute('style', styleCssText);
    }
    if (deep) {
        for (let i = 0, ii = this.childNodes.length; i < ii; i++) {
            const clonedChildNode = this.childNodes[i].cloneNode(true);
            cloned.appendChild(clonedChildNode);
        }
    }
    return cloned;
};

let sharedDocument;
function parseHtmlToDocument(html, ownerDocument = null) {
    if (ownerDocument == null) {
        if (sharedDocument == null) {
            sharedDocument = new MockDocument();
        }
        ownerDocument = sharedDocument;
    }
    return parseDocumentUtil(ownerDocument, html);
}
function parseHtmlToFragment(html, ownerDocument = null) {
    if (ownerDocument == null) {
        if (sharedDocument == null) {
            sharedDocument = new MockDocument();
        }
        ownerDocument = sharedDocument;
    }
    return parseFragmentUtil(ownerDocument, html);
}

const consoleNoop = () => {
    /**/
};
function createConsole() {
    return {
        debug: consoleNoop,
        error: consoleNoop,
        info: consoleNoop,
        log: consoleNoop,
        warn: consoleNoop,
        dir: consoleNoop,
        dirxml: consoleNoop,
        table: consoleNoop,
        trace: consoleNoop,
        group: consoleNoop,
        groupCollapsed: consoleNoop,
        groupEnd: consoleNoop,
        clear: consoleNoop,
        count: consoleNoop,
        countReset: consoleNoop,
        assert: consoleNoop,
        profile: consoleNoop,
        profileEnd: consoleNoop,
        time: consoleNoop,
        timeLog: consoleNoop,
        timeEnd: consoleNoop,
        timeStamp: consoleNoop,
        context: consoleNoop,
        memory: consoleNoop,
    };
}

class MockHeaders {
    constructor(init) {
        this._values = [];
        if (typeof init === 'object') {
            if (typeof init[Symbol.iterator] === 'function') {
                const kvs = [];
                for (const kv of init) {
                    if (typeof kv[Symbol.iterator] === 'function') {
                        kvs.push([...kv]);
                    }
                }
                for (const kv of kvs) {
                    this.append(kv[0], kv[1]);
                }
            }
            else {
                for (const key in init) {
                    this.append(key, init[key]);
                }
            }
        }
    }
    append(key, value) {
        this._values.push([key, value + '']);
    }
    delete(key) {
        key = key.toLowerCase();
        for (let i = this._values.length - 1; i >= 0; i--) {
            if (this._values[i][0].toLowerCase() === key) {
                this._values.splice(i, 1);
            }
        }
    }
    entries() {
        const entries = [];
        for (const kv of this.keys()) {
            entries.push([kv, this.get(kv)]);
        }
        let index = -1;
        return {
            next() {
                index++;
                return {
                    value: entries[index],
                    done: !entries[index],
                };
            },
            [Symbol.iterator]() {
                return this;
            },
        };
    }
    forEach(cb) {
        for (const kv of this.entries()) {
            cb(kv[1], kv[0]);
        }
    }
    get(key) {
        const rtn = [];
        key = key.toLowerCase();
        for (const kv of this._values) {
            if (kv[0].toLowerCase() === key) {
                rtn.push(kv[1]);
            }
        }
        return rtn.length > 0 ? rtn.join(', ') : null;
    }
    has(key) {
        key = key.toLowerCase();
        for (const kv of this._values) {
            if (kv[0].toLowerCase() === key) {
                return true;
            }
        }
        return false;
    }
    keys() {
        const keys = [];
        for (const kv of this._values) {
            const key = kv[0].toLowerCase();
            if (!keys.includes(key)) {
                keys.push(key);
            }
        }
        let index = -1;
        return {
            next() {
                index++;
                return {
                    value: keys[index],
                    done: !keys[index],
                };
            },
            [Symbol.iterator]() {
                return this;
            },
        };
    }
    set(key, value) {
        for (const kv of this._values) {
            if (kv[0].toLowerCase() === key.toLowerCase()) {
                kv[1] = value + '';
                return;
            }
        }
        this.append(key, value);
    }
    values() {
        const values = this._values;
        let index = -1;
        return {
            next() {
                index++;
                const done = !values[index];
                return {
                    value: done ? undefined : values[index][1],
                    done,
                };
            },
            [Symbol.iterator]() {
                return this;
            },
        };
    }
    [Symbol.iterator]() {
        return this.entries();
    }
}

class MockDOMParser {
    parseFromString(htmlToParse, mimeType) {
        if (mimeType !== 'text/html') {
            console.error('XML parsing not implemented yet, continuing as html');
        }
        return parseHtmlToDocument(htmlToParse);
    }
}

class MockRequest {
    constructor(input, init = {}) {
        this._method = 'GET';
        this._url = '/';
        this.bodyUsed = false;
        this.cache = 'default';
        this.credentials = 'same-origin';
        this.integrity = '';
        this.keepalive = false;
        this.mode = 'cors';
        this.redirect = 'follow';
        this.referrer = 'about:client';
        this.referrerPolicy = '';
        if (typeof input === 'string') {
            this.url = input;
        }
        else if (input) {
            Object.assign(this, input);
            this.headers = new MockHeaders(input.headers);
        }
        Object.assign(this, init);
        if (init.headers) {
            this.headers = new MockHeaders(init.headers);
        }
        if (!this.headers) {
            this.headers = new MockHeaders();
        }
    }
    get url() {
        if (typeof this._url === 'string') {
            return new URL(this._url, location.href).href;
        }
        return new URL('/', location.href).href;
    }
    set url(value) {
        this._url = value;
    }
    get method() {
        if (typeof this._method === 'string') {
            return this._method.toUpperCase();
        }
        return 'GET';
    }
    set method(value) {
        this._method = value;
    }
    clone() {
        const clone = { ...this };
        clone.headers = new MockHeaders(this.headers);
        return new MockRequest(clone);
    }
}
class MockResponse {
    constructor(body, init = {}) {
        this.ok = true;
        this.status = 200;
        this.statusText = '';
        this.type = 'default';
        this.url = '';
        this._body = body;
        if (init) {
            Object.assign(this, init);
        }
        this.headers = new MockHeaders(init.headers);
    }
    async json() {
        return JSON.parse(this._body);
    }
    async text() {
        return this._body;
    }
    clone() {
        const initClone = { ...this };
        initClone.headers = new MockHeaders(this.headers);
        return new MockResponse(this._body, initClone);
    }
}

function setupGlobal(gbl) {
    if (gbl.window == null) {
        const win = (gbl.window = new MockWindow());
        WINDOW_FUNCTIONS.forEach((fnName) => {
            if (!(fnName in gbl)) {
                gbl[fnName] = win[fnName].bind(win);
            }
        });
        WINDOW_PROPS.forEach((propName) => {
            if (!(propName in gbl)) {
                Object.defineProperty(gbl, propName, {
                    get() {
                        return win[propName];
                    },
                    set(val) {
                        win[propName] = val;
                    },
                    configurable: true,
                    enumerable: true,
                });
            }
        });
        GLOBAL_CONSTRUCTORS.forEach(([cstrName]) => {
            gbl[cstrName] = win[cstrName];
        });
    }
    return gbl.window;
}
function teardownGlobal(gbl) {
    const win = gbl.window;
    if (win && typeof win.close === 'function') {
        win.close();
    }
}
function patchWindow(winToBePatched) {
    const mockWin = new MockWindow(false);
    WINDOW_FUNCTIONS.forEach((fnName) => {
        if (typeof winToBePatched[fnName] !== 'function') {
            winToBePatched[fnName] = mockWin[fnName].bind(mockWin);
        }
    });
    WINDOW_PROPS.forEach((propName) => {
        if (winToBePatched === undefined) {
            Object.defineProperty(winToBePatched, propName, {
                get() {
                    return mockWin[propName];
                },
                set(val) {
                    mockWin[propName] = val;
                },
                configurable: true,
                enumerable: true,
            });
        }
    });
}
function addGlobalsToWindowPrototype(mockWinPrototype) {
    GLOBAL_CONSTRUCTORS.forEach(([cstrName, Cstr]) => {
        Object.defineProperty(mockWinPrototype, cstrName, {
            get() {
                return this['__' + cstrName] || Cstr;
            },
            set(cstr) {
                this['__' + cstrName] = cstr;
            },
            configurable: true,
            enumerable: true,
        });
    });
}
const WINDOW_FUNCTIONS = [
    'addEventListener',
    'alert',
    'blur',
    'cancelAnimationFrame',
    'cancelIdleCallback',
    'clearInterval',
    'clearTimeout',
    'close',
    'confirm',
    'dispatchEvent',
    'focus',
    'getComputedStyle',
    'matchMedia',
    'open',
    'prompt',
    'removeEventListener',
    'requestAnimationFrame',
    'requestIdleCallback',
    'URL',
];
const WINDOW_PROPS = [
    'customElements',
    'devicePixelRatio',
    'document',
    'history',
    'innerHeight',
    'innerWidth',
    'localStorage',
    'location',
    'navigator',
    'pageXOffset',
    'pageYOffset',
    'performance',
    'screenLeft',
    'screenTop',
    'screenX',
    'screenY',
    'scrollX',
    'scrollY',
    'sessionStorage',
    'CSS',
    'CustomEvent',
    'Event',
    'Element',
    'HTMLElement',
    'Node',
    'NodeList',
    'FocusEvent',
    'KeyboardEvent',
    'MouseEvent',
];
const GLOBAL_CONSTRUCTORS = [
    ['CustomEvent', MockCustomEvent],
    ['Event', MockEvent],
    ['Headers', MockHeaders],
    ['FocusEvent', MockFocusEvent],
    ['KeyboardEvent', MockKeyboardEvent],
    ['MouseEvent', MockMouseEvent],
    ['Request', MockRequest],
    ['Response', MockResponse],
    ['DOMParser', MockDOMParser],
    ['HTMLAnchorElement', MockAnchorElement],
    ['HTMLBaseElement', MockBaseElement],
    ['HTMLButtonElement', MockButtonElement],
    ['HTMLCanvasElement', MockCanvasElement],
    ['HTMLFormElement', MockFormElement],
    ['HTMLImageElement', MockImageElement],
    ['HTMLInputElement', MockInputElement],
    ['HTMLLinkElement', MockLinkElement],
    ['HTMLMetaElement', MockMetaElement],
    ['HTMLScriptElement', MockScriptElement],
    ['HTMLStyleElement', MockStyleElement],
    ['HTMLTemplateElement', MockTemplateElement],
    ['HTMLTitleElement', MockTitleElement],
    ['HTMLUListElement', MockUListElement],
];

class MockHistory {
    constructor() {
        this.items = [];
    }
    get length() {
        return this.items.length;
    }
    back() {
        this.go(-1);
    }
    forward() {
        this.go(1);
    }
    go(_value) {
        //
    }
    pushState(_state, _title, _url) {
        //
    }
    replaceState(_state, _title, _url) {
        //
    }
}

class MockIntersectionObserver {
    constructor() {
        /**/
    }
    disconnect() {
        /**/
    }
    observe() {
        /**/
    }
    takeRecords() {
        return [];
    }
    unobserve() {
        /**/
    }
}

class MockLocation {
    constructor() {
        this.ancestorOrigins = null;
        this.protocol = '';
        this.host = '';
        this.hostname = '';
        this.port = '';
        this.pathname = '';
        this.search = '';
        this.hash = '';
        this.username = '';
        this.password = '';
        this.origin = '';
        this._href = '';
    }
    get href() {
        return this._href;
    }
    set href(value) {
        const url = new URL(value, 'http://mockdoc.stenciljs.com');
        this._href = url.href;
        this.protocol = url.protocol;
        this.host = url.host;
        this.hostname = url.hostname;
        this.port = url.port;
        this.pathname = url.pathname;
        this.search = url.search;
        this.hash = url.hash;
        this.username = url.username;
        this.password = url.password;
        this.origin = url.origin;
    }
    assign(_url) {
        //
    }
    reload(_forcedReload) {
        //
    }
    replace(_url) {
        //
    }
    toString() {
        return this.href;
    }
}

class MockNavigator {
    constructor() {
        this.appCodeName = 'MockNavigator';
        this.appName = 'MockNavigator';
        this.appVersion = 'MockNavigator';
        this.platform = 'MockNavigator';
        this.userAgent = 'MockNavigator';
    }
}

/**
 * https://developer.mozilla.org/en-US/docs/Web/API/Performance
 */
class MockPerformance {
    constructor() {
        this.timeOrigin = Date.now();
        this.eventCounts = new Map();
    }
    addEventListener() {
        //
    }
    clearMarks() {
        //
    }
    clearMeasures() {
        //
    }
    clearResourceTimings() {
        //
    }
    dispatchEvent() {
        return true;
    }
    getEntries() {
        return [];
    }
    getEntriesByName() {
        return [];
    }
    getEntriesByType() {
        return [];
    }
    // Stencil's implementation of `mark` is non-compliant with the `Performance` interface. Because Stencil will
    // instantiate an instance of this class and may attempt to assign it to a variable of type `Performance`, the return
    // type must match the `Performance` interface (rather than typing this function as returning `void` and ignoring the
    // associated errors returned by the type checker)
    // @ts-ignore
    mark() {
        //
    }
    // Stencil's implementation of `measure` is non-compliant with the `Performance` interface. Because Stencil will
    // instantiate an instance of this class and may attempt to assign it to a variable of type `Performance`, the return
    // type must match the `Performance` interface (rather than typing this function as returning `void` and ignoring the
    // associated errors returned by the type checker)
    // @ts-ignore
    measure() {
        //
    }
    get navigation() {
        return {};
    }
    now() {
        return Date.now() - this.timeOrigin;
    }
    get onresourcetimingbufferfull() {
        return null;
    }
    removeEventListener() {
        //
    }
    setResourceTimingBufferSize() {
        //
    }
    get timing() {
        return {};
    }
    toJSON() {
        //
    }
}
function resetPerformance(perf) {
    if (perf != null) {
        try {
            perf.timeOrigin = Date.now();
        }
        catch (e) { }
    }
}

class MockStorage {
    constructor() {
        this.items = new Map();
    }
    key(_value) {
        //
    }
    getItem(key) {
        key = String(key);
        if (this.items.has(key)) {
            return this.items.get(key);
        }
        return null;
    }
    setItem(key, value) {
        if (value == null) {
            value = 'null';
        }
        this.items.set(String(key), String(value));
    }
    removeItem(key) {
        this.items.delete(String(key));
    }
    clear() {
        this.items.clear();
    }
}

const nativeClearInterval = clearInterval;
const nativeClearTimeout = clearTimeout;
const nativeSetInterval = setInterval;
const nativeSetTimeout = setTimeout;
const nativeURL = URL;
class MockWindow {
    constructor(html = null) {
        if (html !== false) {
            this.document = new MockDocument(html, this);
        }
        else {
            this.document = null;
        }
        this.performance = new MockPerformance();
        this.customElements = new MockCustomElementRegistry(this);
        this.console = createConsole();
        resetWindowDefaults(this);
        resetWindowDimensions(this);
    }
    addEventListener(type, handler) {
        addEventListener(this, type, handler);
    }
    alert(msg) {
        if (this.console) {
            this.console.debug(msg);
        }
        else {
            console.debug(msg);
        }
    }
    blur() {
        /**/
    }
    cancelAnimationFrame(id) {
        this.__clearTimeout(id);
    }
    cancelIdleCallback(id) {
        this.__clearTimeout(id);
    }
    get CharacterData() {
        if (this.__charDataCstr == null) {
            const ownerDocument = this.document;
            this.__charDataCstr = class extends MockNode {
                constructor() {
                    super(ownerDocument, 0, 'test', '');
                    throw new Error('Illegal constructor: cannot construct CharacterData');
                }
            };
        }
        return this.__charDataCstr;
    }
    set CharacterData(charDataCstr) {
        this.__charDataCstr = charDataCstr;
    }
    clearInterval(id) {
        this.__clearInterval(id);
    }
    clearTimeout(id) {
        this.__clearTimeout(id);
    }
    close() {
        resetWindow(this);
    }
    confirm() {
        return false;
    }
    get CSS() {
        return {
            supports: () => true,
        };
    }
    get Document() {
        if (this.__docCstr == null) {
            const win = this;
            this.__docCstr = class extends MockDocument {
                constructor() {
                    super(false, win);
                    throw new Error('Illegal constructor: cannot construct Document');
                }
            };
        }
        return this.__docCstr;
    }
    set Document(docCstr) {
        this.__docCstr = docCstr;
    }
    get DocumentFragment() {
        if (this.__docFragCstr == null) {
            const ownerDocument = this.document;
            this.__docFragCstr = class extends MockDocumentFragment {
                constructor() {
                    super(ownerDocument);
                    throw new Error('Illegal constructor: cannot construct DocumentFragment');
                }
            };
        }
        return this.__docFragCstr;
    }
    set DocumentFragment(docFragCstr) {
        this.__docFragCstr = docFragCstr;
    }
    get DocumentType() {
        if (this.__docTypeCstr == null) {
            const ownerDocument = this.document;
            this.__docTypeCstr = class extends MockNode {
                constructor() {
                    super(ownerDocument, 0, 'test', '');
                    throw new Error('Illegal constructor: cannot construct DocumentType');
                }
            };
        }
        return this.__docTypeCstr;
    }
    set DocumentType(docTypeCstr) {
        this.__docTypeCstr = docTypeCstr;
    }
    get DOMTokenList() {
        if (this.__domTokenListCstr == null) {
            this.__domTokenListCstr = class MockDOMTokenList {
            };
        }
        return this.__domTokenListCstr;
    }
    set DOMTokenList(domTokenListCstr) {
        this.__domTokenListCstr = domTokenListCstr;
    }
    dispatchEvent(ev) {
        return dispatchEvent(this, ev);
    }
    get Element() {
        if (this.__elementCstr == null) {
            const ownerDocument = this.document;
            this.__elementCstr = class extends MockElement {
                constructor() {
                    super(ownerDocument, '');
                    throw new Error('Illegal constructor: cannot construct Element');
                }
            };
        }
        return this.__elementCstr;
    }
    fetch(input, init) {
        if (typeof fetch === 'function') {
            return fetch(input, init);
        }
        throw new Error(`fetch() not implemented`);
    }
    focus() {
        /**/
    }
    getComputedStyle(_) {
        return {
            cssText: '',
            length: 0,
            parentRule: null,
            getPropertyPriority() {
                return null;
            },
            getPropertyValue() {
                return '';
            },
            item() {
                return null;
            },
            removeProperty() {
                return null;
            },
            setProperty() {
                return null;
            },
        };
    }
    get globalThis() {
        return this;
    }
    get history() {
        if (this.__history == null) {
            this.__history = new MockHistory();
        }
        return this.__history;
    }
    set history(hsty) {
        this.__history = hsty;
    }
    get JSON() {
        return JSON;
    }
    get HTMLElement() {
        if (this.__htmlElementCstr == null) {
            const ownerDocument = this.document;
            this.__htmlElementCstr = class extends MockHTMLElement {
                constructor() {
                    super(ownerDocument, '');
                    const observedAttributes = this.constructor.observedAttributes;
                    if (Array.isArray(observedAttributes) && typeof this.attributeChangedCallback === 'function') {
                        observedAttributes.forEach((attrName) => {
                            const attrValue = this.getAttribute(attrName);
                            if (attrValue != null) {
                                this.attributeChangedCallback(attrName, null, attrValue);
                            }
                        });
                    }
                }
            };
        }
        return this.__htmlElementCstr;
    }
    set HTMLElement(htmlElementCstr) {
        this.__htmlElementCstr = htmlElementCstr;
    }
    get IntersectionObserver() {
        return MockIntersectionObserver;
    }
    get localStorage() {
        if (this.__localStorage == null) {
            this.__localStorage = new MockStorage();
        }
        return this.__localStorage;
    }
    set localStorage(locStorage) {
        this.__localStorage = locStorage;
    }
    get location() {
        if (this.__location == null) {
            this.__location = new MockLocation();
        }
        return this.__location;
    }
    set location(val) {
        if (typeof val === 'string') {
            if (this.__location == null) {
                this.__location = new MockLocation();
            }
            this.__location.href = val;
        }
        else {
            this.__location = val;
        }
    }
    matchMedia(media) {
        return {
            media,
            matches: false,
            addListener: (_handler) => { },
            removeListener: (_handler) => { },
            addEventListener: (_type, _handler) => { },
            removeEventListener: (_type, _handler) => { },
            dispatchEvent: (_ev) => { },
            onchange: null,
        };
    }
    get Node() {
        if (this.__nodeCstr == null) {
            const ownerDocument = this.document;
            this.__nodeCstr = class extends MockNode {
                constructor() {
                    super(ownerDocument, 0, 'test', '');
                    throw new Error('Illegal constructor: cannot construct Node');
                }
            };
        }
        return this.__nodeCstr;
    }
    get NodeList() {
        if (this.__nodeListCstr == null) {
            const ownerDocument = this.document;
            this.__nodeListCstr = class extends MockNodeList {
                constructor() {
                    super(ownerDocument, [], 0);
                    throw new Error('Illegal constructor: cannot construct NodeList');
                }
            };
        }
        return this.__nodeListCstr;
    }
    get navigator() {
        if (this.__navigator == null) {
            this.__navigator = new MockNavigator();
        }
        return this.__navigator;
    }
    set navigator(nav) {
        this.__navigator = nav;
    }
    get parent() {
        return null;
    }
    prompt() {
        return '';
    }
    open() {
        return null;
    }
    get origin() {
        return this.location.origin;
    }
    removeEventListener(type, handler) {
        removeEventListener(this, type, handler);
    }
    requestAnimationFrame(callback) {
        return this.setTimeout(() => {
            callback(Date.now());
        }, 0);
    }
    requestIdleCallback(callback) {
        return this.setTimeout(() => {
            callback({
                didTimeout: false,
                timeRemaining: () => 0,
            });
        }, 0);
    }
    scroll(_x, _y) {
        /**/
    }
    scrollBy(_x, _y) {
        /**/
    }
    scrollTo(_x, _y) {
        /**/
    }
    get self() {
        return this;
    }
    get sessionStorage() {
        if (this.__sessionStorage == null) {
            this.__sessionStorage = new MockStorage();
        }
        return this.__sessionStorage;
    }
    set sessionStorage(locStorage) {
        this.__sessionStorage = locStorage;
    }
    setInterval(callback, ms, ...args) {
        if (this.__timeouts == null) {
            this.__timeouts = new Set();
        }
        ms = Math.min(ms, this.__maxTimeout);
        if (this.__allowInterval) {
            const intervalId = this.__setInterval(() => {
                if (this.__timeouts) {
                    this.__timeouts.delete(intervalId);
                    try {
                        callback(...args);
                    }
                    catch (e) {
                        if (this.console) {
                            this.console.error(e);
                        }
                        else {
                            console.error(e);
                        }
                    }
                }
            }, ms);
            if (this.__timeouts) {
                this.__timeouts.add(intervalId);
            }
            return intervalId;
        }
        const timeoutId = this.__setTimeout(() => {
            if (this.__timeouts) {
                this.__timeouts.delete(timeoutId);
                try {
                    callback(...args);
                }
                catch (e) {
                    if (this.console) {
                        this.console.error(e);
                    }
                    else {
                        console.error(e);
                    }
                }
            }
        }, ms);
        if (this.__timeouts) {
            this.__timeouts.add(timeoutId);
        }
        return timeoutId;
    }
    setTimeout(callback, ms, ...args) {
        if (this.__timeouts == null) {
            this.__timeouts = new Set();
        }
        ms = Math.min(ms, this.__maxTimeout);
        const timeoutId = this.__setTimeout(() => {
            if (this.__timeouts) {
                this.__timeouts.delete(timeoutId);
                try {
                    callback(...args);
                }
                catch (e) {
                    if (this.console) {
                        this.console.error(e);
                    }
                    else {
                        console.error(e);
                    }
                }
            }
        }, ms);
        if (this.__timeouts) {
            this.__timeouts.add(timeoutId);
        }
        return timeoutId;
    }
    get top() {
        return this;
    }
    get window() {
        return this;
    }
    onanimationstart() {
        /**/
    }
    onanimationend() {
        /**/
    }
    onanimationiteration() {
        /**/
    }
    onabort() {
        /**/
    }
    onauxclick() {
        /**/
    }
    onbeforecopy() {
        /**/
    }
    onbeforecut() {
        /**/
    }
    onbeforepaste() {
        /**/
    }
    onblur() {
        /**/
    }
    oncancel() {
        /**/
    }
    oncanplay() {
        /**/
    }
    oncanplaythrough() {
        /**/
    }
    onchange() {
        /**/
    }
    onclick() {
        /**/
    }
    onclose() {
        /**/
    }
    oncontextmenu() {
        /**/
    }
    oncopy() {
        /**/
    }
    oncuechange() {
        /**/
    }
    oncut() {
        /**/
    }
    ondblclick() {
        /**/
    }
    ondrag() {
        /**/
    }
    ondragend() {
        /**/
    }
    ondragenter() {
        /**/
    }
    ondragleave() {
        /**/
    }
    ondragover() {
        /**/
    }
    ondragstart() {
        /**/
    }
    ondrop() {
        /**/
    }
    ondurationchange() {
        /**/
    }
    onemptied() {
        /**/
    }
    onended() {
        /**/
    }
    onerror() {
        /**/
    }
    onfocus() {
        /**/
    }
    onfocusin() {
        /**/
    }
    onfocusout() {
        /**/
    }
    onformdata() {
        /**/
    }
    onfullscreenchange() {
        /**/
    }
    onfullscreenerror() {
        /**/
    }
    ongotpointercapture() {
        /**/
    }
    oninput() {
        /**/
    }
    oninvalid() {
        /**/
    }
    onkeydown() {
        /**/
    }
    onkeypress() {
        /**/
    }
    onkeyup() {
        /**/
    }
    onload() {
        /**/
    }
    onloadeddata() {
        /**/
    }
    onloadedmetadata() {
        /**/
    }
    onloadstart() {
        /**/
    }
    onlostpointercapture() {
        /**/
    }
    onmousedown() {
        /**/
    }
    onmouseenter() {
        /**/
    }
    onmouseleave() {
        /**/
    }
    onmousemove() {
        /**/
    }
    onmouseout() {
        /**/
    }
    onmouseover() {
        /**/
    }
    onmouseup() {
        /**/
    }
    onmousewheel() {
        /**/
    }
    onpaste() {
        /**/
    }
    onpause() {
        /**/
    }
    onplay() {
        /**/
    }
    onplaying() {
        /**/
    }
    onpointercancel() {
        /**/
    }
    onpointerdown() {
        /**/
    }
    onpointerenter() {
        /**/
    }
    onpointerleave() {
        /**/
    }
    onpointermove() {
        /**/
    }
    onpointerout() {
        /**/
    }
    onpointerover() {
        /**/
    }
    onpointerup() {
        /**/
    }
    onprogress() {
        /**/
    }
    onratechange() {
        /**/
    }
    onreset() {
        /**/
    }
    onresize() {
        /**/
    }
    onscroll() {
        /**/
    }
    onsearch() {
        /**/
    }
    onseeked() {
        /**/
    }
    onseeking() {
        /**/
    }
    onselect() {
        /**/
    }
    onselectstart() {
        /**/
    }
    onstalled() {
        /**/
    }
    onsubmit() {
        /**/
    }
    onsuspend() {
        /**/
    }
    ontimeupdate() {
        /**/
    }
    ontoggle() {
        /**/
    }
    onvolumechange() {
        /**/
    }
    onwaiting() {
        /**/
    }
    onwebkitfullscreenchange() {
        /**/
    }
    onwebkitfullscreenerror() {
        /**/
    }
    onwheel() {
        /**/
    }
}
addGlobalsToWindowPrototype(MockWindow.prototype);
function resetWindowDefaults(win) {
    win.__clearInterval = nativeClearInterval;
    win.__clearTimeout = nativeClearTimeout;
    win.__setInterval = nativeSetInterval;
    win.__setTimeout = nativeSetTimeout;
    win.__maxTimeout = 30000;
    win.__allowInterval = true;
    win.URL = nativeURL;
}
function cloneWindow(srcWin, opts = {}) {
    if (srcWin == null) {
        return null;
    }
    const clonedWin = new MockWindow(false);
    if (!opts.customElementProxy) {
        // TODO(STENCIL-345) - Evaluate reconciling MockWindow, Window differences
        // @ts-ignore
        srcWin.customElements = null;
    }
    if (srcWin.document != null) {
        const clonedDoc = new MockDocument(false, clonedWin);
        clonedWin.document = clonedDoc;
        clonedDoc.documentElement = srcWin.document.documentElement.cloneNode(true);
    }
    else {
        clonedWin.document = new MockDocument(null, clonedWin);
    }
    return clonedWin;
}
function cloneDocument(srcDoc) {
    if (srcDoc == null) {
        return null;
    }
    const dstWin = cloneWindow(srcDoc.defaultView);
    return dstWin.document;
}
// TODO(STENCIL-345) - Evaluate reconciling MockWindow, Window differences
/**
 * Constrain setTimeout() to 1ms, but still async. Also
 * only allow setInterval() to fire once, also constrained to 1ms.
 * @param win the mock window instance to update
 */
function constrainTimeouts(win) {
    win.__allowInterval = false;
    win.__maxTimeout = 0;
}
function resetWindow(win) {
    if (win != null) {
        if (win.__timeouts) {
            win.__timeouts.forEach((timeoutId) => {
                nativeClearInterval(timeoutId);
                nativeClearTimeout(timeoutId);
            });
            win.__timeouts.clear();
        }
        if (win.customElements && win.customElements.clear) {
            win.customElements.clear();
        }
        resetDocument(win.document);
        resetPerformance(win.performance);
        for (const key in win) {
            if (win.hasOwnProperty(key) && key !== 'document' && key !== 'performance' && key !== 'customElements') {
                delete win[key];
            }
        }
        resetWindowDefaults(win);
        resetWindowDimensions(win);
        resetEventListeners(win);
        if (win.document != null) {
            try {
                win.document.defaultView = win;
            }
            catch (e) { }
        }
        // ensure we don't hold onto nodeFetch values
        win.fetch = null;
        win.Headers = null;
        win.Request = null;
        win.Response = null;
        win.FetchError = null;
    }
}
function resetWindowDimensions(win) {
    try {
        win.devicePixelRatio = 1;
        win.innerHeight = 768;
        win.innerWidth = 1366;
        win.pageXOffset = 0;
        win.pageYOffset = 0;
        win.screenLeft = 0;
        win.screenTop = 0;
        win.screenX = 0;
        win.screenY = 0;
        win.scrollX = 0;
        win.scrollY = 0;
        win.screen = {
            availHeight: win.innerHeight,
            availLeft: 0,
            availTop: 0,
            availWidth: win.innerWidth,
            colorDepth: 24,
            height: win.innerHeight,
            keepAwake: false,
            orientation: {
                angle: 0,
                type: 'portrait-primary',
            },
            pixelDepth: 24,
            width: win.innerWidth,
        };
    }
    catch (e) { }
}

class MockDocument extends MockHTMLElement {
    constructor(html = null, win = null) {
        super(null, null);
        this.nodeName = "#document" /* NODE_NAMES.DOCUMENT_NODE */;
        this.nodeType = 9 /* NODE_TYPES.DOCUMENT_NODE */;
        this.defaultView = win;
        this.cookie = '';
        this.referrer = '';
        this.appendChild(this.createDocumentTypeNode());
        if (typeof html === 'string') {
            const parsedDoc = parseDocumentUtil(this, html);
            const documentElement = parsedDoc.children.find((elm) => elm.nodeName === 'HTML');
            if (documentElement != null) {
                this.appendChild(documentElement);
                setOwnerDocument(documentElement, this);
            }
        }
        else if (html !== false) {
            const documentElement = new MockHTMLElement(this, 'html');
            this.appendChild(documentElement);
            documentElement.appendChild(new MockHTMLElement(this, 'head'));
            documentElement.appendChild(new MockHTMLElement(this, 'body'));
        }
    }
    get dir() {
        return this.documentElement.dir;
    }
    set dir(value) {
        this.documentElement.dir = value;
    }
    get location() {
        if (this.defaultView != null) {
            return this.defaultView.location;
        }
        return null;
    }
    set location(val) {
        if (this.defaultView != null) {
            this.defaultView.location = val;
        }
    }
    get baseURI() {
        const baseNode = this.head.childNodes.find((node) => node.nodeName === 'BASE');
        if (baseNode) {
            return baseNode.href;
        }
        return this.URL;
    }
    get URL() {
        return this.location.href;
    }
    get styleSheets() {
        return this.querySelectorAll('style');
    }
    get scripts() {
        return this.querySelectorAll('script');
    }
    get forms() {
        return this.querySelectorAll('form');
    }
    get images() {
        return this.querySelectorAll('img');
    }
    get scrollingElement() {
        return this.documentElement;
    }
    get documentElement() {
        for (let i = this.childNodes.length - 1; i >= 0; i--) {
            if (this.childNodes[i].nodeName === 'HTML') {
                return this.childNodes[i];
            }
        }
        const documentElement = new MockHTMLElement(this, 'html');
        this.appendChild(documentElement);
        return documentElement;
    }
    set documentElement(documentElement) {
        for (let i = this.childNodes.length - 1; i >= 0; i--) {
            if (this.childNodes[i].nodeType !== 10 /* NODE_TYPES.DOCUMENT_TYPE_NODE */) {
                this.childNodes[i].remove();
            }
        }
        if (documentElement != null) {
            this.appendChild(documentElement);
            setOwnerDocument(documentElement, this);
        }
    }
    get head() {
        const documentElement = this.documentElement;
        for (let i = 0; i < documentElement.childNodes.length; i++) {
            if (documentElement.childNodes[i].nodeName === 'HEAD') {
                return documentElement.childNodes[i];
            }
        }
        const head = new MockHTMLElement(this, 'head');
        documentElement.insertBefore(head, documentElement.firstChild);
        return head;
    }
    set head(head) {
        const documentElement = this.documentElement;
        for (let i = documentElement.childNodes.length - 1; i >= 0; i--) {
            if (documentElement.childNodes[i].nodeName === 'HEAD') {
                documentElement.childNodes[i].remove();
            }
        }
        if (head != null) {
            documentElement.insertBefore(head, documentElement.firstChild);
            setOwnerDocument(head, this);
        }
    }
    get body() {
        const documentElement = this.documentElement;
        for (let i = documentElement.childNodes.length - 1; i >= 0; i--) {
            if (documentElement.childNodes[i].nodeName === 'BODY') {
                return documentElement.childNodes[i];
            }
        }
        const body = new MockHTMLElement(this, 'body');
        documentElement.appendChild(body);
        return body;
    }
    set body(body) {
        const documentElement = this.documentElement;
        for (let i = documentElement.childNodes.length - 1; i >= 0; i--) {
            if (documentElement.childNodes[i].nodeName === 'BODY') {
                documentElement.childNodes[i].remove();
            }
        }
        if (body != null) {
            documentElement.appendChild(body);
            setOwnerDocument(body, this);
        }
    }
    appendChild(newNode) {
        newNode.remove();
        newNode.parentNode = this;
        this.childNodes.push(newNode);
        return newNode;
    }
    createComment(data) {
        return new MockComment(this, data);
    }
    createAttribute(attrName) {
        return new MockAttr(attrName.toLowerCase(), '');
    }
    createAttributeNS(namespaceURI, attrName) {
        return new MockAttr(attrName, '', namespaceURI);
    }
    createElement(tagName) {
        if (tagName === "#document" /* NODE_NAMES.DOCUMENT_NODE */) {
            const doc = new MockDocument(false);
            doc.nodeName = tagName;
            doc.parentNode = null;
            return doc;
        }
        return createElement(this, tagName);
    }
    createElementNS(namespaceURI, tagName) {
        const elmNs = createElementNS(this, namespaceURI, tagName);
        return elmNs;
    }
    createTextNode(text) {
        return new MockTextNode(this, text);
    }
    createDocumentFragment() {
        return new MockDocumentFragment(this);
    }
    createDocumentTypeNode() {
        return new MockDocumentTypeNode(this);
    }
    getElementById(id) {
        return getElementById(this, id);
    }
    getElementsByName(elmName) {
        return getElementsByName(this, elmName.toLowerCase());
    }
    get title() {
        const title = this.head.childNodes.find((elm) => elm.nodeName === 'TITLE');
        if (title != null && typeof title.textContent === 'string') {
            return title.textContent.trim();
        }
        return '';
    }
    set title(value) {
        const head = this.head;
        let title = head.childNodes.find((elm) => elm.nodeName === 'TITLE');
        if (title == null) {
            title = this.createElement('title');
            head.appendChild(title);
        }
        title.textContent = value;
    }
}
function createDocument(html = null) {
    return new MockWindow(html).document;
}
function createFragment(html) {
    return parseHtmlToFragment(html, null);
}
function resetDocument(doc) {
    if (doc != null) {
        resetEventListeners(doc);
        const documentElement = doc.documentElement;
        if (documentElement != null) {
            resetElement(documentElement);
            for (let i = 0, ii = documentElement.childNodes.length; i < ii; i++) {
                const childNode = documentElement.childNodes[i];
                resetElement(childNode);
                childNode.childNodes.length = 0;
            }
        }
        for (const key in doc) {
            if (doc.hasOwnProperty(key) && !DOC_KEY_KEEPERS.has(key)) {
                delete doc[key];
            }
        }
        try {
            doc.nodeName = "#document" /* NODE_NAMES.DOCUMENT_NODE */;
        }
        catch (e) { }
        try {
            doc.nodeType = 9 /* NODE_TYPES.DOCUMENT_NODE */;
        }
        catch (e) { }
        try {
            doc.cookie = '';
        }
        catch (e) { }
        try {
            doc.referrer = '';
        }
        catch (e) { }
    }
}
const DOC_KEY_KEEPERS = new Set([
    'nodeName',
    'nodeType',
    'nodeValue',
    'ownerDocument',
    'parentNode',
    'childNodes',
    '_shadowRoot',
]);
function getElementById(elm, id) {
    const children = elm.children;
    for (let i = 0, ii = children.length; i < ii; i++) {
        const childElm = children[i];
        if (childElm.id === id) {
            return childElm;
        }
        const childElmFound = getElementById(childElm, id);
        if (childElmFound != null) {
            return childElmFound;
        }
    }
    return null;
}
function getElementsByName(elm, elmName, foundElms = []) {
    const children = elm.children;
    for (let i = 0, ii = children.length; i < ii; i++) {
        const childElm = children[i];
        if (childElm.name && childElm.name.toLowerCase() === elmName) {
            foundElms.push(childElm);
        }
        getElementsByName(childElm, elmName, foundElms);
    }
    return foundElms;
}
function setOwnerDocument(elm, ownerDocument) {
    for (let i = 0, ii = elm.childNodes.length; i < ii; i++) {
        elm.childNodes[i].ownerDocument = ownerDocument;
        if (elm.childNodes[i].nodeType === 1 /* NODE_TYPES.ELEMENT_NODE */) {
            setOwnerDocument(elm.childNodes[i], ownerDocument);
        }
    }
}

function hydrateFactory($stencilWindow, $stencilHydrateOpts, $stencilHydrateResults, $stencilAfterHydrate, $stencilHydrateResolve) {
  var globalThis = $stencilWindow;
  var self = $stencilWindow;
  var top = $stencilWindow;
  var parent = $stencilWindow;

  var addEventListener = $stencilWindow.addEventListener.bind($stencilWindow);
  var alert = $stencilWindow.alert.bind($stencilWindow);
  var blur = $stencilWindow.blur.bind($stencilWindow);
  var cancelAnimationFrame = $stencilWindow.cancelAnimationFrame.bind($stencilWindow);
  var cancelIdleCallback = $stencilWindow.cancelIdleCallback.bind($stencilWindow);
  var clearInterval = $stencilWindow.clearInterval.bind($stencilWindow);
  var clearTimeout = $stencilWindow.clearTimeout.bind($stencilWindow);
  var close = () => {};
  var confirm = $stencilWindow.confirm.bind($stencilWindow);
  var dispatchEvent = $stencilWindow.dispatchEvent.bind($stencilWindow);
  var focus = $stencilWindow.focus.bind($stencilWindow);
  var getComputedStyle = $stencilWindow.getComputedStyle.bind($stencilWindow);
  var matchMedia = $stencilWindow.matchMedia.bind($stencilWindow);
  var open = $stencilWindow.open.bind($stencilWindow);
  var prompt = $stencilWindow.prompt.bind($stencilWindow);
  var removeEventListener = $stencilWindow.removeEventListener.bind($stencilWindow);
  var requestAnimationFrame = $stencilWindow.requestAnimationFrame.bind($stencilWindow);
  var requestIdleCallback = $stencilWindow.requestIdleCallback.bind($stencilWindow);
  var setInterval = $stencilWindow.setInterval.bind($stencilWindow);
  var setTimeout = $stencilWindow.setTimeout.bind($stencilWindow);

  var CharacterData = $stencilWindow.CharacterData;
  var CSS = $stencilWindow.CSS;
  var CustomEvent = $stencilWindow.CustomEvent;
  var Document = $stencilWindow.Document;
  var DocumentFragment = $stencilWindow.DocumentFragment;
  var DocumentType = $stencilWindow.DocumentType;
  var DOMTokenList = $stencilWindow.DOMTokenList;
  var Element = $stencilWindow.Element;
  var Event = $stencilWindow.Event;
  var HTMLAnchorElement = $stencilWindow.HTMLAnchorElement;
  var HTMLBaseElement = $stencilWindow.HTMLBaseElement;
  var HTMLButtonElement = $stencilWindow.HTMLButtonElement;
  var HTMLCanvasElement = $stencilWindow.HTMLCanvasElement;
  var HTMLElement = $stencilWindow.HTMLElement;
  var HTMLFormElement = $stencilWindow.HTMLFormElement;
  var HTMLImageElement = $stencilWindow.HTMLImageElement;
  var HTMLInputElement = $stencilWindow.HTMLInputElement;
  var HTMLLinkElement = $stencilWindow.HTMLLinkElement;
  var HTMLMetaElement = $stencilWindow.HTMLMetaElement;
  var HTMLScriptElement = $stencilWindow.HTMLScriptElement;
  var HTMLStyleElement = $stencilWindow.HTMLStyleElement;
  var HTMLTemplateElement = $stencilWindow.HTMLTemplateElement;
  var HTMLTitleElement = $stencilWindow.HTMLTitleElement;
  var IntersectionObserver = $stencilWindow.IntersectionObserver;
  var KeyboardEvent = $stencilWindow.KeyboardEvent;
  var MouseEvent = $stencilWindow.MouseEvent;
  var Node = $stencilWindow.Node;
  var NodeList = $stencilWindow.NodeList;
  var URL = $stencilWindow.URL;

  var console = $stencilWindow.console;
  var customElements = $stencilWindow.customElements;
  var history = $stencilWindow.history;
  var localStorage = $stencilWindow.localStorage;
  var location = $stencilWindow.location;
  var navigator = $stencilWindow.navigator;
  var performance = $stencilWindow.performance;
  var sessionStorage = $stencilWindow.sessionStorage;

  var devicePixelRatio = $stencilWindow.devicePixelRatio;
  var innerHeight = $stencilWindow.innerHeight;
  var innerWidth = $stencilWindow.innerWidth;
  var origin = $stencilWindow.origin;
  var pageXOffset = $stencilWindow.pageXOffset;
  var pageYOffset = $stencilWindow.pageYOffset;
  var screen = $stencilWindow.screen;
  var screenLeft = $stencilWindow.screenLeft;
  var screenTop = $stencilWindow.screenTop;
  var screenX = $stencilWindow.screenX;
  var screenY = $stencilWindow.screenY;
  var scrollX = $stencilWindow.scrollX;
  var scrollY = $stencilWindow.scrollY;
  var exports = {};

  var fetch, FetchError, Headers, Request, Response;

  if (typeof $stencilWindow.fetch === 'function') {
    fetch = $stencilWindow.fetch;
  } else {
    fetch = $stencilWindow.fetch = function() { throw new Error('fetch() is not implemented'); };
  }

  if (typeof $stencilWindow.FetchError === 'function') {
    FetchError = $stencilWindow.FetchError;
  } else {
    FetchError = $stencilWindow.FetchError = class FetchError { constructor() { throw new Error('FetchError is not implemented'); } };
  }

  if (typeof $stencilWindow.Headers === 'function') {
    Headers = $stencilWindow.Headers;
  } else {
    Headers = $stencilWindow.Headers = class Headers { constructor() { throw new Error('Headers is not implemented'); } };
  }

  if (typeof $stencilWindow.Request === 'function') {
    Request = $stencilWindow.Request;
  } else {
    Request = $stencilWindow.Request = class Request { constructor() { throw new Error('Request is not implemented'); } };
  }

  if (typeof $stencilWindow.Response === 'function') {
    Response = $stencilWindow.Response;
  } else {
    Response = $stencilWindow.Response = class Response { constructor() { throw new Error('Response is not implemented'); } };
  }

  function hydrateAppClosure($stencilWindow) {
    const window = $stencilWindow;
    const document = $stencilWindow.document;
    /*hydrateAppClosure start*/


const NAMESPACE = 'core';
const BUILD = /* core */ { allRenderFn: true, appendChildSlotFix: false, asyncLoading: true, attachStyles: true, cloneNodeFix: false, cmpDidLoad: true, cmpDidRender: true, cmpDidUnload: false, cmpDidUpdate: true, cmpShouldUpdate: false, cmpWillLoad: true, cmpWillRender: true, cmpWillUpdate: true, connectedCallback: true, constructableCSS: false, cssAnnotations: true, devTools: false, disconnectedCallback: true, element: false, event: true, experimentalScopedSlotChanges: false, experimentalSlotFixes: false, formAssociated: false, hasRenderFn: true, hostListener: true, hostListenerTarget: true, hostListenerTargetBody: false, hostListenerTargetDocument: true, hostListenerTargetParent: false, hostListenerTargetWindow: false, hotModuleReplacement: false, hydrateClientSide: true, hydrateServerSide: true, hydratedAttribute: false, hydratedClass: true, isDebug: false, isDev: false, isTesting: false, lazyLoad: true, lifecycle: true, lifecycleDOMEvents: false, member: true, method: true, mode: false, observeAttribute: true, profile: false, prop: true, propBoolean: true, propMutable: true, propNumber: true, propString: true, reflect: true, scoped: true, scriptDataOpts: false, shadowDelegatesFocus: true, shadowDom: true, shadowDomShim: true, slot: true, slotChildNodesFix: false, slotRelocation: true, state: true, style: true, svg: true, taskQueue: true, updatable: true, vdomAttribute: true, vdomClass: true, vdomFunctional: true, vdomKey: true, vdomListener: true, vdomPropOrAttr: true, vdomRef: true, vdomRender: true, vdomStyle: true, vdomText: true, vdomXlink: true, watchCallback: true };

function queryNonceMetaTagContent(e) {
 var t, o, n;
 return null !== (n = null === (o = null === (t = e.head) || void 0 === t ? void 0 : t.querySelector('meta[name="csp-nonce"]')) || void 0 === o ? void 0 : o.getAttribute("content")) && void 0 !== n ? n : void 0;
}

function componentOnReady() {
 return getHostRef(this).$onReadyPromise$;
}

function forceUpdate() {}

function hydrateApp(e, t, o, n, s) {
 function l() {
  if (global.clearTimeout(p), i.clear(), r.clear(), !h) {
   h = !0;
   try {
    t.clientHydrateAnnotations && insertVdomAnnotations(e.document, t.staticComponents), 
    e.dispatchEvent(new e.Event("DOMContentLoaded")), e.document.createElement = c, 
    e.document.createElementNS = $;
   } catch (e) {
    renderCatchError(t, o, e);
   }
  }
  n(e, t, o, s);
 }
 function a(e) {
  renderCatchError(t, o, e), l();
 }
 const r = new Set, i = new Set, d = new Set, c = e.document.createElement, $ = e.document.createElementNS, m = Promise.resolve();
 let p, h = !1;
 try {
  function f() {
   return L(this);
  }
  function u(e) {
   if (isValidComponent(e, t) && !getHostRef(e)) {
    const t = loadModule({
     $tagName$: e.nodeName.toLowerCase(),
     $flags$: null
    });
    null != t && null != t.cmpMeta && (i.add(e), e.connectedCallback = f, registerHost(e, t.cmpMeta), 
    function o(e, t) {
     if ("function" != typeof e.componentOnReady && (e.componentOnReady = componentOnReady), 
     "function" != typeof e.forceUpdate && (e.forceUpdate = forceUpdate), 1 & t.$flags$ && (e.shadowRoot = e), 
     null != t.$members$) {
      const o = getHostRef(e);
      Object.entries(t.$members$).forEach((([n, s]) => {
       const l = s[0];
       if (31 & l) {
        const a = s[1] || n, r = e.getAttribute(a);
        if (null != r) {
         const e = parsePropertyValue(r, l);
         o.$instanceValues$.set(n, e);
        }
        const i = e[n];
        void 0 !== i && (o.$instanceValues$.set(n, i), delete e[n]), Object.defineProperty(e, n, {
         get() {
          return getValue(this, n);
         },
         set(e) {
          setValue(this, n, e, t);
         },
         configurable: !0,
         enumerable: !0
        });
       } else 64 & l && Object.defineProperty(e, n, {
        value(...e) {
         const t = getHostRef(this);
         return t.$onInstancePromise$.then((() => t.$lazyInstance$[n](...e))).catch(consoleError);
        }
       });
      }));
     }
    }(e, t.cmpMeta));
   }
  }
  function g(e) {
   if (null != e && 1 === e.nodeType) {
    u(e);
    const t = e.children;
    for (let e = 0, o = t.length; e < o; e++) g(t[e]);
   }
  }
  function L(n) {
   return i.delete(n), isValidComponent(n, t) && o.hydratedCount < t.maxHydrateCount && !r.has(n) && shouldHydrate(n) ? (r.add(n), 
   async function s(e, t, o, n, l) {
    o = o.toLowerCase();
    const a = loadModule({
     $tagName$: o,
     $flags$: null
    });
    if (null != a && null != a.cmpMeta) {
     l.add(n);
     try {
      connectedCallback(n), await n.componentOnReady(), t.hydratedCount++;
      const e = getHostRef(n), s = e.$modeName$ ? e.$modeName$ : "$";
      t.components.some((e => e.tag === o && e.mode === s)) || t.components.push({
       tag: o,
       mode: s,
       count: 0,
       depth: -1
      });
     } catch (t) {
      e.console.error(t);
     }
     l.delete(n);
    }
   }(e, o, n.nodeName, n, d)) : m;
  }
  function y() {
   const e = Array.from(i).filter((e => e.parentElement));
   return e.length > 0 ? Promise.all(e.map(L)).then(y) : m;
  }
  e.document.createElement = function t(o) {
   const n = c.call(e.document, o);
   return u(n), n;
  }, e.document.createElementNS = function t(o, n) {
   const s = $.call(e.document, o, n);
   return u(s), s;
  }, p = global.setTimeout((function I() {
   a(`Hydrate exceeded timeout${function e(t) {
    return Array.from(t).map(waitingOnElementMsg);
   }(d)}`);
  }), t.timeout), plt.$resourcesUrl$ = new URL(t.resourcesUrl || "./", doc.baseURI).href, 
  g(e.document.body), y().then(l).catch(a);
 } catch (D) {
  a(D);
 }
}

function isValidComponent(e, t) {
 if (null != e && 1 === e.nodeType) {
  const o = e.nodeName;
  if ("string" == typeof o && o.includes("-")) return !t.excludeComponents.includes(o.toLowerCase());
 }
 return !1;
}

function shouldHydrate(e) {
 if (9 === e.nodeType) return !0;
 if (NO_HYDRATE_TAGS.has(e.nodeName)) return !1;
 if (e.hasAttribute("no-prerender")) return !1;
 const t = e.parentNode;
 return null == t || shouldHydrate(t);
}

function renderCatchError(e, t, o) {
 const n = {
  level: "error",
  type: "build",
  header: "Hydrate Error",
  messageText: "",
  relFilePath: void 0,
  absFilePath: void 0,
  lines: []
 };
 if (e.url) try {
  const t = new URL(e.url);
  "/" !== t.pathname && (n.header += ": " + t.pathname);
 } catch (e) {}
 null != o && (null != o.stack ? n.messageText = o.stack.toString() : null != o.message ? n.messageText = o.message.toString() : n.messageText = o.toString()), 
 t.diagnostics.push(n);
}

function printTag(e) {
 let t = `<${e.nodeName.toLowerCase()}`;
 if (Array.isArray(e.attributes)) for (let o = 0; o < e.attributes.length; o++) {
  const n = e.attributes[o];
  t += ` ${n.name}`, "" !== n.value && (t += `="${n.value}"`);
 }
 return t += ">", t;
}

function waitingOnElementMsg(e) {
 let t = "";
 if (e) {
  const o = [];
  t = " - waiting on:";
  let n = e;
  for (;n && 9 !== n.nodeType && "BODY" !== n.nodeName; ) o.unshift(printTag(n)), 
  n = n.parentElement;
  let s = "";
  for (const e of o) s += "  ", t += `\n${s}${e}`;
 }
 return t;
}

const createTime = (e, t = "") => {
 return () => {};
}, SLOT_FB_CSS = "slot-fb{display:contents}slot-fb[hidden]{display:none}", XLINK_NS = "http://www.w3.org/1999/xlink", EMPTY_OBJ = {}, isComplexType = e => "object" == (e = typeof e) || "function" === e, isPromise = e => !!e && ("object" == typeof e || "function" == typeof e) && "function" == typeof e.then, h = (e, t, ...o) => {
 let n = null, s = null, l = null, a = !1, r = !1;
 const i = [], d = t => {
  for (let o = 0; o < t.length; o++) n = t[o], Array.isArray(n) ? d(n) : null != n && "boolean" != typeof n && ((a = "function" != typeof e && !isComplexType(n)) ? n = String(n) : BUILD.isDev  , 
  a && r ? i[i.length - 1].$text$ += n : i.push(a ? newVNode(null, n) : n), r = a);
 };
 if (d(o), t && (t.key && (s = t.key), 
 t.name && (l = t.name), BUILD.vdomClass)) {
  const e = t.className || t.class;
  e && (t.class = "object" != typeof e ? e : Object.keys(e).filter((t => e[t])).join(" "));
 }
 if ("function" == typeof e) return e(null === t ? {} : t, i, vdomFnUtils);
 const c = newVNode(e, null);
 return c.$attrs$ = t, i.length > 0 && (c.$children$ = i), (c.$key$ = s), 
 (c.$name$ = l), c;
}, newVNode = (e, t) => {
 const o = {
  $flags$: 0,
  $tag$: e,
  $text$: t,
  $elm$: null,
  $children$: null
 };
 return (o.$attrs$ = null), (o.$key$ = null), 
 (o.$name$ = null), o;
}, Host = {}, isHost = e => e && e.$tag$ === Host, vdomFnUtils = {
 forEach: (e, t) => e.map(convertToPublic).forEach(t),
 map: (e, t) => e.map(convertToPublic).map(t).map(convertToPrivate)
}, convertToPublic = e => ({
 vattrs: e.$attrs$,
 vchildren: e.$children$,
 vkey: e.$key$,
 vname: e.$name$,
 vtag: e.$tag$,
 vtext: e.$text$
}), convertToPrivate = e => {
 if ("function" == typeof e.vtag) {
  const t = {
   ...e.vattrs
  };
  return e.vkey && (t.key = e.vkey), e.vname && (t.name = e.vname), h(e.vtag, t, ...e.vchildren || []);
 }
 const t = newVNode(e.vtag, e.vtext);
 return t.$attrs$ = e.vattrs, t.$children$ = e.vchildren, t.$key$ = e.vkey, t.$name$ = e.vname, 
 t;
}, clientHydrate = (e, t, o, n, s, l, a) => {
 let r, i, d, c;
 if (1 === l.nodeType) {
  for (r = l.getAttribute("c-id"), r && (i = r.split("."), i[0] !== a && "0" !== i[0] || (d = {
   $flags$: 0,
   $hostId$: i[0],
   $nodeId$: i[1],
   $depth$: i[2],
   $index$: i[3],
   $tag$: l.tagName.toLowerCase(),
   $elm$: l,
   $attrs$: null,
   $children$: null,
   $key$: null,
   $name$: null,
   $text$: null
  }, t.push(d), l.removeAttribute("c-id"), e.$children$ || (e.$children$ = []), e.$children$[d.$index$] = d, 
  e = d, n && "0" === d.$depth$ && (n[d.$index$] = d.$elm$))), c = l.childNodes.length - 1; c >= 0; c--) clientHydrate(e, t, o, n, s, l.childNodes[c], a);
  if (l.shadowRoot) for (c = l.shadowRoot.childNodes.length - 1; c >= 0; c--) clientHydrate(e, t, o, n, s, l.shadowRoot.childNodes[c], a);
 } else if (8 === l.nodeType) i = l.nodeValue.split("."), i[1] !== a && "0" !== i[1] || (r = i[0], 
 d = {
  $flags$: 0,
  $hostId$: i[1],
  $nodeId$: i[2],
  $depth$: i[3],
  $index$: i[4],
  $elm$: l,
  $attrs$: null,
  $children$: null,
  $key$: null,
  $name$: null,
  $tag$: null,
  $text$: null
 }, "t" === r ? (d.$elm$ = l.nextSibling, d.$elm$ && 3 === d.$elm$.nodeType && (d.$text$ = d.$elm$.textContent, 
 t.push(d), l.remove(), e.$children$ || (e.$children$ = []), e.$children$[d.$index$] = d, 
 n && "0" === d.$depth$ && (n[d.$index$] = d.$elm$))) : d.$hostId$ === a && ("s" === r ? (d.$tag$ = "slot", 
 i[5] ? l["s-sn"] = d.$name$ = i[5] : l["s-sn"] = "", l["s-sr"] = !0, n && (d.$elm$ = doc.createElement(d.$tag$), 
 d.$name$ && d.$elm$.setAttribute("name", d.$name$), l.parentNode.insertBefore(d.$elm$, l), 
 l.remove(), "0" === d.$depth$ && (n[d.$index$] = d.$elm$)), o.push(d), e.$children$ || (e.$children$ = []), 
 e.$children$[d.$index$] = d) : "r" === r && (n ? l.remove() : (s["s-cr"] = l, 
 l["s-cn"] = !0)))); else if (e && "style" === e.$tag$) {
  const t = newVNode(null, l.textContent);
  t.$elm$ = l, t.$index$ = "0", e.$children$ = [ t ];
 }
}, initializeDocumentHydrate = (e, t) => {
 if (1 === e.nodeType) {
  let o = 0;
  for (;o < e.childNodes.length; o++) initializeDocumentHydrate(e.childNodes[o], t);
  if (e.shadowRoot) for (o = 0; o < e.shadowRoot.childNodes.length; o++) initializeDocumentHydrate(e.shadowRoot.childNodes[o], t);
 } else if (8 === e.nodeType) {
  const o = e.nodeValue.split(".");
  "o" === o[0] && (t.set(o[1] + "." + o[2], e), e.nodeValue = "", e["s-en"] = o[3]);
 }
}, parsePropertyValue = (e, t) => null == e || isComplexType(e) ? e : 4 & t ? "false" !== e && ("" === e || !!e) : 2 & t ? parseFloat(e) : 1 & t ? String(e) : e, getElement = e => getHostRef(e).$hostElement$ , createEvent = (e, t, o) => {
 const n = getElement(e);
 return {
  emit: e => (emitEvent(n, t, {
   bubbles: !!(4 & o),
   composed: !!(2 & o),
   cancelable: !!(1 & o),
   detail: e
  }))
 };
}, emitEvent = (e, t, o) => {
 const n = plt.ce(t, o);
 return e.dispatchEvent(n), n;
}, rootAppliedStyles = new WeakMap, registerStyle = (e, t, o) => {
 let n = styles.get(e);
 n = t, styles.set(e, n);
}, addStyle = (e, t, o) => {
 var n;
 const s = getScopeId(t), l = styles.get(s);
 if (e = 11 === e.nodeType ? e : doc, l) if ("string" == typeof l) {
  e = e.head || e;
  let o, a = rootAppliedStyles.get(e);
  if (a || rootAppliedStyles.set(e, a = new Set), !a.has(s)) {
   if (e.host && (o = e.querySelector(`[sty-id="${s}"]`))) o.innerHTML = l; else {
    o = doc.createElement("style"), o.innerHTML = l;
    const t = null !== (n = plt.$nonce$) && void 0 !== n ? n : queryNonceMetaTagContent(doc);
    null != t && o.setAttribute("nonce", t), o.setAttribute("sty-id", s), 
    e.insertBefore(o, e.querySelector("link"));
   }
   4 & t.$flags$ && (o.innerHTML += SLOT_FB_CSS), a && a.add(s);
  }
 }
 return s;
}, attachStyles = e => {
 const t = e.$cmpMeta$, o = e.$hostElement$, n = t.$flags$, s = createTime("attachStyles", t.$tagName$), l = addStyle(o.getRootNode(), t);
 10 & n && (o["s-sc"] = l, 
 o.classList.add(l + "-h"), 2 & n && o.classList.add(l + "-s")), 
 s();
}, getScopeId = (e, t) => "sc-" + (e.$tagName$), setAccessor = (e, t, o, n, s, l) => {
 if (o !== n) {
  let a = isMemberInElement(e, t), r = t.toLowerCase();
  if ("class" === t) {
   const t = e.classList, s = parseClassList(o), l = parseClassList(n);
   t.remove(...s.filter((e => e && !l.includes(e)))), t.add(...l.filter((e => e && !s.includes(e))));
  } else if ("style" === t) {
   for (const t in o) n && null != n[t] || (e.style[t] = "");
   for (const t in n) o && n[t] === o[t] || (e.style[t] = n[t]);
  } else if ("key" === t) ; else if ("ref" === t) n && n(e); else if ((a ) || "o" !== t[0] || "n" !== t[1]) {
   {
    const i = isComplexType(n);
    if ((a || i && null !== n) && !s) try {
     if (e.tagName.includes("-")) e[t] = n; else {
      const s = null == n ? "" : n;
      "list" === t ? a = !1 : null != o && e[t] == s || (e[t] = s);
     }
    } catch (e) {}
    let d = !1;
    r !== (r = r.replace(/^xlink\:?/, "")) && (t = r, d = !0), null == n || !1 === n ? !1 === n && "" !== e.getAttribute(t) || (d ? e.removeAttributeNS(XLINK_NS, t) : e.removeAttribute(t)) : (!a || 4 & l || s) && !i && (n = !0 === n ? "" : n, 
    d ? e.setAttributeNS(XLINK_NS, t, n) : e.setAttribute(t, n));
   }
  } else if (t = "-" === t[2] ? t.slice(3) : isMemberInElement(win, r) ? r.slice(2) : r[2] + t.slice(3), 
  o || n) {
   const s = t.endsWith(CAPTURE_EVENT_SUFFIX);
   t = t.replace(CAPTURE_EVENT_REGEX, ""), o && plt.rel(e, t, o, s), n && plt.ael(e, t, n, s);
  }
 }
}, parseClassListRegex = /\s/, parseClassList = e => e ? e.split(parseClassListRegex) : [], CAPTURE_EVENT_SUFFIX = "Capture", CAPTURE_EVENT_REGEX = new RegExp(CAPTURE_EVENT_SUFFIX + "$"), updateElement = (e, t, o, n) => {
 const s = 11 === t.$elm$.nodeType && t.$elm$.host ? t.$elm$.host : t.$elm$, l = e && e.$attrs$ || EMPTY_OBJ, a = t.$attrs$ || EMPTY_OBJ;
 for (n in l) n in a || setAccessor(s, n, l[n], void 0, o, t.$flags$);
 for (n in a) setAccessor(s, n, l[n], a[n], o, t.$flags$);
};

let scopeId, contentRef, hostTagName, useNativeShadowDom = !1, checkSlotFallbackVisibility = !1, checkSlotRelocate = !1, isSvgMode = !1;

const createElm = (e, t, o, n) => {
 const s = t.$children$[o];
 let l, a, r, i = 0;
 if (!useNativeShadowDom && (checkSlotRelocate = !0, "slot" === s.$tag$ && (scopeId && n.classList.add(scopeId + "-s"), 
 s.$flags$ |= s.$children$ ? 2 : 1)), null !== s.$text$) l = s.$elm$ = doc.createTextNode(s.$text$); else if (1 & s.$flags$) l = s.$elm$ = slotReferenceDebugNode(s) ; else {
  if (!isSvgMode && (isSvgMode = "svg" === s.$tag$), l = s.$elm$ = doc.createElementNS(isSvgMode ? "http://www.w3.org/2000/svg" : "http://www.w3.org/1999/xhtml", 2 & s.$flags$ ? "slot-fb" : s.$tag$) , 
  isSvgMode && "foreignObject" === s.$tag$ && (isSvgMode = !1), updateElement(null, s, isSvgMode), 
  null != scopeId && l["s-si"] !== scopeId && l.classList.add(l["s-si"] = scopeId), 
  s.$children$) for (i = 0; i < s.$children$.length; ++i) a = createElm(e, s, i, l), 
  a && l.appendChild(a);
  ("svg" === s.$tag$ ? isSvgMode = !1 : "foreignObject" === l.tagName && (isSvgMode = !0));
 }
 return l["s-hn"] = hostTagName, 3 & s.$flags$ && (l["s-sr"] = !0, 
 l["s-cr"] = contentRef, l["s-sn"] = s.$name$ || "", r = e && e.$children$ && e.$children$[o], 
 r && r.$tag$ === s.$tag$ && e.$elm$ && (putBackInOriginalLocation(e.$elm$, !1))), 
 l;
}, putBackInOriginalLocation = (e, t) => {
 plt.$flags$ |= 1;
 const o = e.childNodes;
 for (let e = o.length - 1; e >= 0; e--) {
  const n = o[e];
  n["s-hn"] !== hostTagName && n["s-ol"] && (parentReferenceNode(n).insertBefore(n, referenceNode(n)), 
  n["s-ol"].remove(), n["s-ol"] = void 0, n["s-sh"] = void 0, checkSlotRelocate = !0), 
  t && putBackInOriginalLocation(n, t);
 }
 plt.$flags$ &= -2;
}, addVnodes = (e, t, o, n, s, l) => {
 let a, r = e["s-cr"] && e["s-cr"].parentNode || e;
 for (r.shadowRoot && r.tagName === hostTagName && (r = r.shadowRoot); s <= l; ++s) n[s] && (a = createElm(null, o, s, e), 
 a && (n[s].$elm$ = a, r.insertBefore(a, referenceNode(t) )));
}, removeVnodes = (e, t, o) => {
 for (let n = t; n <= o; ++n) {
  const t = e[n];
  if (t) {
   const e = t.$elm$;
   nullifyVNodeRefs(t), e && ((checkSlotFallbackVisibility = !0, 
   e["s-ol"] ? e["s-ol"].remove() : putBackInOriginalLocation(e, !0)), e.remove());
  }
 }
}, isSameVnode = (e, t, o = !1) => e.$tag$ === t.$tag$ && ("slot" === e.$tag$ ? e.$name$ === t.$name$ : !(!o) || e.$key$ === t.$key$), referenceNode = e => e && e["s-ol"] || e, parentReferenceNode = e => (e["s-ol"] ? e["s-ol"] : e).parentNode, patch = (e, t, o = !1) => {
 const n = t.$elm$ = e.$elm$, s = e.$children$, l = t.$children$, a = t.$tag$, r = t.$text$;
 let i;
 null !== r ? (i = n["s-cr"]) ? i.parentNode.textContent = r : e.$text$ !== r && (n.data = r) : ((isSvgMode = "svg" === a || "foreignObject" !== a && isSvgMode), 
 ("slot" === a || updateElement(e, t, isSvgMode)), 
 null !== s && null !== l ? ((e, t, o, n, s = !1) => {
  let l, a, r = 0, i = 0, d = 0, c = 0, $ = t.length - 1, m = t[0], p = t[$], h = n.length - 1, f = n[0], u = n[h];
  for (;r <= $ && i <= h; ) if (null == m) m = t[++r]; else if (null == p) p = t[--$]; else if (null == f) f = n[++i]; else if (null == u) u = n[--h]; else if (isSameVnode(m, f, s)) patch(m, f, s), 
  m = t[++r], f = n[++i]; else if (isSameVnode(p, u, s)) patch(p, u, s), p = t[--$], 
  u = n[--h]; else if (isSameVnode(m, u, s)) "slot" !== m.$tag$ && "slot" !== u.$tag$ || putBackInOriginalLocation(m.$elm$.parentNode, !1), 
  patch(m, u, s), e.insertBefore(m.$elm$, p.$elm$.nextSibling), m = t[++r], u = n[--h]; else if (isSameVnode(p, f, s)) "slot" !== m.$tag$ && "slot" !== u.$tag$ || putBackInOriginalLocation(p.$elm$.parentNode, !1), 
  patch(p, f, s), e.insertBefore(p.$elm$, m.$elm$), p = t[--$], f = n[++i]; else {
   if (d = -1, BUILD.vdomKey) for (c = r; c <= $; ++c) if (t[c] && null !== t[c].$key$ && t[c].$key$ === f.$key$) {
    d = c;
    break;
   }
   d >= 0 ? (a = t[d], a.$tag$ !== f.$tag$ ? l = createElm(t && t[i], o, d, e) : (patch(a, f, s), 
   t[d] = void 0, l = a.$elm$), f = n[++i]) : (l = createElm(t && t[i], o, i, e), f = n[++i]), 
   l && (parentReferenceNode(m.$elm$).insertBefore(l, referenceNode(m.$elm$)) );
  }
  r > $ ? addVnodes(e, null == n[h + 1] ? null : n[h + 1].$elm$, o, n, i, h) : i > h && removeVnodes(t, r, $);
 })(n, s, t, l, o) : null !== l ? (null !== e.$text$ && (n.textContent = ""), 
 addVnodes(n, null, t, l, 0, l.length - 1)) : null !== s && removeVnodes(s, 0, s.length - 1), 
 isSvgMode && "svg" === a && (isSvgMode = !1));
}, updateFallbackSlotVisibility = e => {
 const t = e.childNodes;
 for (const e of t) if (1 === e.nodeType) {
  if (e["s-sr"]) {
   const o = e["s-sn"];
   e.hidden = !1;
   for (const n of t) if (n !== e) if (n["s-hn"] !== e["s-hn"] || "" !== o) {
    if (1 === n.nodeType && (o === n.getAttribute("slot") || o === n["s-sn"])) {
     e.hidden = !0;
     break;
    }
   } else if (1 === n.nodeType || 3 === n.nodeType && "" !== n.textContent.trim()) {
    e.hidden = !0;
    break;
   }
  }
  updateFallbackSlotVisibility(e);
 }
}, relocateNodes = [], markSlotContentForRelocation = e => {
 let t, o, n;
 for (const s of e.childNodes) {
  if (s["s-sr"] && (t = s["s-cr"]) && t.parentNode) {
   o = t.parentNode.childNodes;
   const e = s["s-sn"];
   for (n = o.length - 1; n >= 0; n--) if (t = o[n], !(t["s-cn"] || t["s-nr"] || t["s-hn"] === s["s-hn"] || BUILD.experimentalSlotFixes  )) if (isNodeLocatedInSlot(t, e)) {
    let o = relocateNodes.find((e => e.$nodeToRelocate$ === t));
    checkSlotFallbackVisibility = !0, t["s-sn"] = t["s-sn"] || e, o ? (o.$nodeToRelocate$["s-sh"] = s["s-hn"], 
    o.$slotRefNode$ = s) : (t["s-sh"] = s["s-hn"], relocateNodes.push({
     $slotRefNode$: s,
     $nodeToRelocate$: t
    })), t["s-sr"] && relocateNodes.map((e => {
     isNodeLocatedInSlot(e.$nodeToRelocate$, t["s-sn"]) && (o = relocateNodes.find((e => e.$nodeToRelocate$ === t)), 
     o && !e.$slotRefNode$ && (e.$slotRefNode$ = o.$slotRefNode$));
    }));
   } else relocateNodes.some((e => e.$nodeToRelocate$ === t)) || relocateNodes.push({
    $nodeToRelocate$: t
   });
  }
  1 === s.nodeType && markSlotContentForRelocation(s);
 }
}, isNodeLocatedInSlot = (e, t) => 1 === e.nodeType ? null === e.getAttribute("slot") && "" === t || e.getAttribute("slot") === t : e["s-sn"] === t || "" === t, nullifyVNodeRefs = e => {
 (e.$attrs$ && e.$attrs$.ref && e.$attrs$.ref(null), e.$children$ && e.$children$.map(nullifyVNodeRefs));
}, renderVdom = (e, t, o = !1) => {
 var n, s, l, a;
 const i = e.$hostElement$, d = e.$cmpMeta$, c = e.$vnode$ || newVNode(null, null), $ = isHost(t) ? t : h(null, null, t);
 if (hostTagName = i.tagName, BUILD.isDev  ) ;
 if (d.$attrsToReflect$ && ($.$attrs$ = $.$attrs$ || {}, d.$attrsToReflect$.map((([e, t]) => $.$attrs$[t] = i[e]))), 
 o && $.$attrs$) for (const e of Object.keys($.$attrs$)) i.hasAttribute(e) && ![ "key", "ref", "style", "class" ].includes(e) && ($.$attrs$[e] = i[e]);
 if ($.$tag$ = null, $.$flags$ |= 4, e.$vnode$ = $, $.$elm$ = c.$elm$ = i.shadowRoot || i, 
 (scopeId = i["s-sc"]), (contentRef = i["s-cr"], 
 useNativeShadowDom = supportsShadow, checkSlotFallbackVisibility = !1), patch(c, $, o), 
 BUILD.slotRelocation) {
  if (plt.$flags$ |= 1, checkSlotRelocate) {
   markSlotContentForRelocation($.$elm$);
   for (const e of relocateNodes) {
    const t = e.$nodeToRelocate$;
    if (!t["s-ol"]) {
     const e = originalLocationDebugNode(t) ;
     e["s-nr"] = t, t.parentNode.insertBefore(t["s-ol"] = e, t);
    }
   }
   for (const e of relocateNodes) {
    const t = e.$nodeToRelocate$, r = e.$slotRefNode$;
    if (r) {
     const e = r.parentNode;
     let o = r.nextSibling;
     {
      let l = null === (n = t["s-ol"]) || void 0 === n ? void 0 : n.previousSibling;
      for (;l; ) {
       let n = null !== (s = l["s-nr"]) && void 0 !== s ? s : null;
       if (n && n["s-sn"] === t["s-sn"] && e === n.parentNode && (n = n.nextSibling, !n || !n["s-nr"])) {
        o = n;
        break;
       }
       l = l.previousSibling;
      }
     }
     (!o && e !== t.parentNode || t.nextSibling !== o) && t !== o && (t["s-hn"] || !t["s-ol"] || (t["s-hn"] = t["s-ol"].parentNode.nodeName), 
     e.insertBefore(t, o), 1 === t.nodeType && (t.hidden = null !== (l = t["s-ih"]) && void 0 !== l && l));
    } else 1 === t.nodeType && (o && (t["s-ih"] = null !== (a = t.hidden) && void 0 !== a && a), 
    t.hidden = !0);
   }
  }
  checkSlotFallbackVisibility && updateFallbackSlotVisibility($.$elm$), plt.$flags$ &= -2, 
  relocateNodes.length = 0;
 }
}, slotReferenceDebugNode = e => doc.createComment(`<slot${e.$name$ ? ' name="' + e.$name$ + '"' : ""}> (host=${hostTagName.toLowerCase()})`), originalLocationDebugNode = e => doc.createComment("org-location for " + (e.localName ? `<${e.localName}> (host=${e["s-hn"]})` : `[${e.textContent}]`)), attachToAncestor = (e, t) => {
 t && !e.$onRenderResolve$ && t["s-p"] && t["s-p"].push(new Promise((t => e.$onRenderResolve$ = t)));
}, scheduleUpdate = (e, t) => {
 if ((e.$flags$ |= 16), 4 & e.$flags$) return void (e.$flags$ |= 512);
 attachToAncestor(e, e.$ancestorComponent$);
 const o = () => dispatchHooks(e, t);
 return writeTask(o) ;
}, dispatchHooks = (e, t) => {
 const n = createTime("scheduleUpdate", e.$cmpMeta$.$tagName$), s = e.$lazyInstance$ ;
 let l;
 return t ? ((e.$flags$ |= 256, e.$queuedListeners$ && (e.$queuedListeners$.map((([e, t]) => safeCall(s, e, t))), 
 e.$queuedListeners$ = void 0)), (l = safeCall(s, "componentWillLoad"))) : ((l = safeCall(s, "componentWillUpdate"))), (l = enqueue(l, (() => safeCall(s, "componentWillRender")))), 
 n(), enqueue(l, (() => updateComponent(e, s, t)));
}, enqueue = (e, t) => isPromisey(e) ? e.then(t) : t(), isPromisey = e => e instanceof Promise || e && e.then && "function" == typeof e.then, updateComponent = async (e, t, o) => {
 var n;
 const s = e.$hostElement$, l = createTime("update", e.$cmpMeta$.$tagName$), a = s["s-rc"];
 o && attachStyles(e);
 const r = createTime("render", e.$cmpMeta$.$tagName$);
 if (await callRender(e, t, s, o) , 
 BUILD.hydrateServerSide) try {
  serverSideConnected(s), o && (1 & e.$cmpMeta$.$flags$ ? s["s-en"] = "" : 2 & e.$cmpMeta$.$flags$ && (s["s-en"] = "c"));
 } catch (e) {
  consoleError(e, s);
 }
 if (a && (a.map((e => e())), s["s-rc"] = void 0), r(), l(), 
 BUILD.asyncLoading) {
  const t = null !== (n = s["s-p"]) && void 0 !== n ? n : [], o = () => postUpdateComponent(e);
  0 === t.length ? o() : (Promise.all(t).then(o), e.$flags$ |= 4, t.length = 0);
 }
};

const callRender = (e, t, o, n) => {
 try {
  if (t = t.render(), (e.$flags$ &= -17), 
  (e.$flags$ |= 2), BUILD.hasRenderFn ) {
   return Promise.resolve(t).then((t => renderVdom(e, t, n)));
  }
 } catch (t) {
  consoleError(t, e.$hostElement$);
 }
 return null;
}, postUpdateComponent = e => {
 const t = e.$cmpMeta$.$tagName$, o = e.$hostElement$, n = createTime("postUpdate", t), s = e.$lazyInstance$ , l = e.$ancestorComponent$;
 (safeCall(s, "componentDidRender"), 
 BUILD.isDev ), 64 & e.$flags$ ? ((safeCall(s, "componentDidUpdate"), 
 BUILD.isDev ), n()) : (e.$flags$ |= 64, addHydratedFlag(o), 
 (safeCall(s, "componentDidLoad"), 
 BUILD.isDev ), n(), (e.$onReadyResolve$(o), l || appDidLoad())), e.$onInstanceResolve$(o), 
 (e.$onRenderResolve$ && (e.$onRenderResolve$(), e.$onRenderResolve$ = void 0), 
 512 & e.$flags$ && nextTick((() => scheduleUpdate(e, !1))), e.$flags$ &= -517);
}, appDidLoad = e => {
 addHydratedFlag(doc.documentElement), nextTick((() => emitEvent(win, "appload", {
  detail: {
   namespace: NAMESPACE
  }
 }))), BUILD.profile  ;
}, safeCall = (e, t, o) => {
 if (e && e[t]) try {
  return e[t](o);
 } catch (e) {
  consoleError(e);
 }
}, addHydratedFlag = e => e.classList.add("hydrated") , serverSideConnected = e => {
 const t = e.children;
 if (null != t) for (let e = 0, o = t.length; e < o; e++) {
  const o = t[e];
  "function" == typeof o.connectedCallback && o.connectedCallback(), serverSideConnected(o);
 }
}, getValue = (e, t) => getHostRef(e).$instanceValues$.get(t), setValue = (e, t, o, n) => {
 const s = getHostRef(e), l = s.$hostElement$ , a = s.$instanceValues$.get(t), r = s.$flags$, i = s.$lazyInstance$ ;
 o = parsePropertyValue(o, n.$members$[t][0]);
 const d = Number.isNaN(a) && Number.isNaN(o), c = o !== a && !d;
 if ((!(8 & r) || void 0 === a) && c && (s.$instanceValues$.set(t, o), 
 i)) {
  if (n.$watchers$ && 128 & r) {
   const e = n.$watchers$[t];
   e && e.map((e => {
    try {
     i[e](o, a, t);
    } catch (e) {
     consoleError(e, l);
    }
   }));
  }
  if (2 == (18 & r)) {
   scheduleUpdate(s, !1);
  }
 }
}, proxyComponent = (e, t, o) => {
 var n;
 const s = e.prototype;
 if (t.$members$) {
  e.watchers && (t.$watchers$ = e.watchers);
  const l = Object.entries(t.$members$);
  if (l.map((([e, [n]]) => {
   (31 & n || (2 & o) && 32 & n) ? Object.defineProperty(s, e, {
    get() {
     return getValue(this, e);
    },
    set(s) {
     setValue(this, e, s, t);
    },
    configurable: !0,
    enumerable: !0
   }) : 1 & o && 64 & n && Object.defineProperty(s, e, {
    value(...t) {
     var o;
     const n = getHostRef(this);
     return null === (o = null == n ? void 0 : n.$onInstancePromise$) || void 0 === o ? void 0 : o.then((() => {
      var o;
      return null === (o = n.$lazyInstance$) || void 0 === o ? void 0 : o[e](...t);
     }));
    }
   });
  })), (1 & o)) {
   const o = new Map;
   s.attributeChangedCallback = function(e, n, l) {
    plt.jmp((() => {
     var a;
     const r = o.get(e);
     if (this.hasOwnProperty(r)) l = this[r], delete this[r]; else {
      if (s.hasOwnProperty(r) && "number" == typeof this[r] && this[r] == l) return;
      if (null == r) {
       const o = getHostRef(this), s = null == o ? void 0 : o.$flags$;
       if (s && !(8 & s) && 128 & s && l !== n) {
        const r = o.$lazyInstance$ , i = null === (a = t.$watchers$) || void 0 === a ? void 0 : a[e];
        null == i || i.forEach((t => {
         null != r[t] && r[t].call(r, l, n, e);
        }));
       }
       return;
      }
     }
     this[r] = (null !== l || "boolean" != typeof this[r]) && l;
    }));
   }, e.observedAttributes = Array.from(new Set([ ...Object.keys(null !== (n = t.$watchers$) && void 0 !== n ? n : {}), ...l.filter((([e, t]) => 15 & t[0])).map((([e, n]) => {
    var s;
    const l = n[1] || e;
    return o.set(l, e), 512 & n[0] && (null === (s = t.$attrsToReflect$) || void 0 === s || s.push([ e, l ])), 
    l;
   })) ]));
  }
 }
 return e;
}, initializeComponent = async (e, t, o, n) => {
 let s;
 if (0 == (32 & t.$flags$)) {
  if (t.$flags$ |= 32, BUILD.lazyLoad ) {
   if (s = loadModule(o), s.then) {
    const e = (() => {});
    s = await s, e();
   }
   !s.isProxied && ((o.$watchers$ = s.watchers), 
   proxyComponent(s, o, 2), s.isProxied = !0);
   const e = createTime("createInstance", o.$tagName$);
   (t.$flags$ |= 8);
   try {
    new s(t);
   } catch (e) {
    consoleError(e);
   }
   (t.$flags$ &= -9), (t.$flags$ |= 128), e(), 
   fireConnectedCallback(t.$lazyInstance$);
  }
  if (s.style) {
   let n = s.style;
   const l = getScopeId(o);
   if (!styles.has(l)) {
    const e = createTime("registerStyles", o.$tagName$);
    registerStyle(l, n), e();
   }
  }
 }
 const r = t.$ancestorComponent$, i = () => scheduleUpdate(t, !0);
 r && r["s-rc"] ? r["s-rc"].push(i) : i();
}, fireConnectedCallback = e => {
 safeCall(e, "connectedCallback");
}, connectedCallback = e => {
 if (0 == (1 & plt.$flags$)) {
  const t = getHostRef(e), o = t.$cmpMeta$, n = createTime("connectedCallback", o.$tagName$);
  if (1 & t.$flags$) addHostEventListeners(e, t, o.$listeners$), (null == t ? void 0 : t.$lazyInstance$) ? fireConnectedCallback(t.$lazyInstance$) : (null == t ? void 0 : t.$onReadyPromise$) && t.$onReadyPromise$.then((() => fireConnectedCallback(t.$lazyInstance$))); else {
   let n;
   if (t.$flags$ |= 1, (n = e.getAttribute("s-id"), n)) {
    ((e, t, o, n) => {
     const s = createTime("hydrateClient", t), l = e.shadowRoot, a = [], r = l ? [] : null, i = n.$vnode$ = newVNode(t, null);
     plt.$orgLocNodes$ || initializeDocumentHydrate(doc.body, plt.$orgLocNodes$ = new Map), 
     e["s-id"] = o, e.removeAttribute("s-id"), clientHydrate(i, a, [], r, e, e, o), a.map((e => {
      const o = e.$hostId$ + "." + e.$nodeId$, n = plt.$orgLocNodes$.get(o), s = e.$elm$;
      n && supportsShadow && "" === n["s-en"] && n.parentNode.insertBefore(s, n.nextSibling), 
      l || (s["s-hn"] = t, n && (s["s-ol"] = n, s["s-ol"]["s-nr"] = s)), plt.$orgLocNodes$.delete(o);
     })), l && r.map((e => {
      e && l.appendChild(e);
     })), s();
    })(e, o.$tagName$, n, t);
   }
   if (!n && (BUILD.hydrateServerSide ) && setContentReference(e), 
   BUILD.asyncLoading) {
    let o = e;
    for (;o = o.parentNode || o.host; ) if (1 === o.nodeType && o.hasAttribute("s-id") && o["s-p"] || o["s-p"]) {
     attachToAncestor(t, t.$ancestorComponent$ = o);
     break;
    }
   }
   initializeComponent(e, t, o);
  }
  n();
 }
}, setContentReference = e => {
 const t = e["s-cr"] = doc.createComment("");
 t["s-cn"] = !0, e.insertBefore(t, e.firstChild);
}, Fragment = (e, t) => t, addHostEventListeners = (e, t, o, n) => {
 o && (o.map((([o, n, s]) => {
  const l = getHostListenerTarget(e, o) , a = hostListenerProxy(t, s), r = hostListenerOpts(o);
  plt.ael(l, n, a, r), (t.$rmListeners$ = t.$rmListeners$ || []).push((() => plt.rel(l, n, a, r)));
 })));
}, hostListenerProxy = (e, t) => o => {
 try {
  256 & e.$flags$ ? e.$lazyInstance$[t](o) : (e.$queuedListeners$ = e.$queuedListeners$ || []).push([ t, o ]) ;
 } catch (e) {
  consoleError(e);
 }
}, getHostListenerTarget = (e, t) => 4 & t ? doc : e, hostListenerOpts = e => 0 != (2 & e), insertVdomAnnotations = (e, t) => {
 if (null != e) {
  const o = {
   hostIds: 0,
   rootLevelIds: 0,
   staticComponents: new Set(t)
  }, n = [];
  parseVNodeAnnotations(e, e.body, o, n), n.forEach((t => {
   var n, s;
   if (null != t && t["s-nr"]) {
    const l = t["s-nr"];
    let a = l["s-host-id"], r = l["s-node-id"], i = `${a}.${r}`;
    if (null == a) if (a = 0, o.rootLevelIds++, r = o.rootLevelIds, i = `${a}.${r}`, 
    1 === l.nodeType) l.setAttribute("c-id", i); else if (3 === l.nodeType) {
     if (0 === a && "" === (null === (n = l.nodeValue) || void 0 === n ? void 0 : n.trim())) return void t.remove();
     const o = e.createComment(i);
     o.nodeValue = `t.${i}`, null === (s = l.parentNode) || void 0 === s || s.insertBefore(o, l);
    }
    let d = `o.${i}`;
    const c = t.parentElement;
    c && ("" === c["s-en"] ? d += "." : "c" === c["s-en"] && (d += ".c")), t.nodeValue = d;
   }
  }));
 }
}, parseVNodeAnnotations = (e, t, o, n) => {
 null != t && (null != t["s-nr"] && n.push(t), 1 === t.nodeType && t.childNodes.forEach((t => {
  const s = getHostRef(t);
  if (null != s && !o.staticComponents.has(t.nodeName.toLowerCase())) {
   const n = {
    nodeIds: 0
   };
   insertVNodeAnnotations(e, t, s.$vnode$, o, n);
  }
  parseVNodeAnnotations(e, t, o, n);
 })));
}, insertVNodeAnnotations = (e, t, o, n, s) => {
 if (null != o) {
  const l = ++n.hostIds;
  if (t.setAttribute("s-id", l), null != t["s-cr"] && (t["s-cr"].nodeValue = `r.${l}`), 
  null != o.$children$) {
   const t = 0;
   o.$children$.forEach(((o, n) => {
    insertChildVNodeAnnotations(e, o, s, l, t, n);
   }));
  }
  if (t && o && o.$elm$ && !t.hasAttribute("c-id")) {
   const e = t.parentElement;
   if (e && e.childNodes) {
    const n = Array.from(e.childNodes), s = n.find((e => 8 === e.nodeType && e["s-sr"]));
    if (s) {
     const e = n.indexOf(t) - 1;
     o.$elm$.setAttribute("c-id", `${s["s-host-id"]}.${s["s-node-id"]}.0.${e}`);
    }
   }
  }
 }
}, insertChildVNodeAnnotations = (e, t, o, n, s, l) => {
 const a = t.$elm$;
 if (null == a) return;
 const r = o.nodeIds++, i = `${n}.${r}.${s}.${l}`;
 if (a["s-host-id"] = n, a["s-node-id"] = r, 1 === a.nodeType) a.setAttribute("c-id", i); else if (3 === a.nodeType) {
  const t = a.parentNode, o = null == t ? void 0 : t.nodeName;
  if ("STYLE" !== o && "SCRIPT" !== o) {
   const o = `t.${i}`, n = e.createComment(o);
   null == t || t.insertBefore(n, a);
  }
 } else if (8 === a.nodeType && a["s-sr"]) {
  const e = `s.${i}.${a["s-sn"] || ""}`;
  a.nodeValue = e;
 }
 if (null != t.$children$) {
  const l = s + 1;
  t.$children$.forEach(((t, s) => {
   insertChildVNodeAnnotations(e, t, o, n, l, s);
  }));
 }
}, hAsync = (e, t, ...o) => {
 if (Array.isArray(o) && o.length > 0) {
  const n = o.flat(1 / 0);
  return n.some(isPromise) ? Promise.all(n).then((o => h(e, t, ...o))).catch((o => h(e, t))) : h(e, t, ...o);
 }
 return h(e, t);
}, NO_HYDRATE_TAGS = new Set([ "CODE", "HEAD", "IFRAME", "INPUT", "OBJECT", "OUTPUT", "NOSCRIPT", "PRE", "SCRIPT", "SELECT", "STYLE", "TEMPLATE", "TEXTAREA" ]);

const cmpModules = new Map, getModule = e => {
 if ("string" == typeof e) {
  e = e.toLowerCase();
  const t = cmpModules.get(e);
  if (null != t) return t[e];
 }
 return null;
}, loadModule = (e, t, o) => getModule(e.$tagName$), isMemberInElement = (e, t) => {
 if (null != e) {
  if (t in e) return !0;
  const o = getModule(e.nodeName);
  if (null != o) {
   const e = o;
   if (null != e && null != e.cmpMeta && null != e.cmpMeta.$members$) return t in e.cmpMeta.$members$;
  }
 }
 return !1;
}, registerComponents = e => {
 for (const t of e) {
  const e = t.cmpMeta.$tagName$;
  cmpModules.set(e, {
   [e]: t
  });
 }
}, win = window, doc = win.document, writeTask = e => {
 process.nextTick((() => {
  try {
   e();
  } catch (e) {
   consoleError(e);
  }
 }));
}, resolved = Promise.resolve(), nextTick = e => resolved.then(e), defaultConsoleError = e => {
 null != e && console.error(e.stack || e.message || e);
}, consoleError = (e, t) => (defaultConsoleError)(e, t), plt = {
 $flags$: 0,
 $resourcesUrl$: "",
 jmp: e => e(),
 raf: e => requestAnimationFrame(e),
 ael: (e, t, o, n) => e.addEventListener(t, o, n),
 rel: (e, t, o, n) => e.removeEventListener(t, o, n),
 ce: (e, t) => new win.CustomEvent(e, t)
}, supportsShadow = !1, hostRefs = new WeakMap, getHostRef = e => hostRefs.get(e), registerInstance = (e, t) => hostRefs.set(t.$lazyInstance$ = e, t), registerHost = (e, t) => {
 const o = {
  $flags$: 0,
  $cmpMeta$: t,
  $hostElement$: e,
  $instanceValues$: new Map,
  $renderCount$: 0
 };
 return o.$onInstancePromise$ = new Promise((e => o.$onInstanceResolve$ = e)), o.$onReadyPromise$ = new Promise((e => o.$onReadyResolve$ = e)), 
 e["s-p"] = [], e["s-rc"] = [], addHostEventListeners(e, o, t.$listeners$), hostRefs.set(e, o);
}, styles = new Map;

var IcInformationStatus;
(function (IcInformationStatus) {
    IcInformationStatus["Warning"] = "warning";
    IcInformationStatus["Error"] = "error";
    IcInformationStatus["Success"] = "success";
})(IcInformationStatus || (IcInformationStatus = {}));
var IcThemeForegroundEnum;
(function (IcThemeForegroundEnum) {
    IcThemeForegroundEnum["Default"] = "default";
    IcThemeForegroundEnum["Dark"] = "dark";
    IcThemeForegroundEnum["Light"] = "light";
})(IcThemeForegroundEnum || (IcThemeForegroundEnum = {}));

var errorIcon = `<svg aria-labelledby="error-title" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#000000">
    <title id="error-title">Error</title>
    <g id="close-octagon">
        <path id="Vector" d="M8.77 3L3.5 8.27V15.73L8.77 21H16.23L21.5 15.73V8.27L16.23 3M8.91 7L12.5 10.59L16.09 7L17.5 8.41L13.91 12L17.5 15.59L16.09 17L12.5 13.41L8.91 17L7.5 15.59L11.09 12L7.5 8.41" />
    </g>
</svg>
`;

var infoIcon = `<svg aria-labelledby="info-title" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#000000">
    <title id="info-title">For your information</title>
    <g id="info">
        <path id="Vector" d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM12 17C11.45 17 11 16.55 11 16V12C11 11.45 11.45 11 12 11C12.55 11 13 11.45 13 12V16C13 16.55 12.55 17 12 17ZM13 9H11V7H13V9Z" />
    </g>
</svg>
`;

var neutralIcon = `<svg aria-labelledby="neutral-title" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#000000">
<title id="neutral-title">Neutral</title>
    <g id="Icon">
        <path id="Vector" d="M19.5 3H5.5C4.4 3 3.5 3.9 3.5 5V19C3.5 20.1 4.4 21 5.5 21H19.5C20.6 21 21.5 20.1 21.5 19V5C21.5 3.9 20.6 3 19.5 3ZM12.51 18C11.81 18 11.25 17.44 11.25 16.74C11.25 16.03 11.81 15.49 12.51 15.49C13.22 15.49 13.76 16.03 13.76 16.74C13.75 17.43 13.22 18 12.51 18ZM15.52 10.6C14.76 11.71 14.04 12.06 13.65 12.77C13.55 12.95 13.49 13.09 13.46 13.4C13.41 13.85 13.01 14.18 12.56 14.18H12.5C11.98 14.18 11.57 13.74 11.62 13.22C11.65 12.88 11.73 12.53 11.92 12.19C12.41 11.32 13.34 10.8 13.88 10.03C14.45 9.22 14.13 7.7 12.51 7.7C11.8 7.7 11.33 8.06 11.04 8.49C10.79 8.85 10.35 9.02 9.94 8.85C9.41 8.64 9.22 8 9.54 7.54C10.15 6.65 11.17 6 12.49 6C13.97 6 14.98 6.67 15.5 7.52C15.94 8.24 16.2 9.59 15.52 10.6Z" />
    </g>
</svg>
`;

var successIcon = `<svg aria-labelledby="success-title" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#000000">
    <title id="success-title">Success</title>
    <g id="check_circle">
        <path id="Vector" d="M12.5 2C6.98 2 2.5 6.48 2.5 12C2.5 17.52 6.98 22 12.5 22C18.02 22 22.5 17.52 22.5 12C22.5 6.48 18.02 2 12.5 2ZM9.79 16.29L6.2 12.7C5.81 12.31 5.81 11.68 6.2 11.29C6.59 10.9 7.22 10.9 7.61 11.29L10.5 14.17L17.38 7.29C17.77 6.9 18.4 6.9 18.79 7.29C19.18 7.68 19.18 8.31 18.79 8.7L11.2 16.29C10.82 16.68 10.18 16.68 9.79 16.29Z" />
    </g>
</svg>
`;

var warningIcon$1 = `<svg aria-labelledby="warning-title" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#000000">
    <title id="warning-title">Warning</title>
    <g id="warning">
        <path id="Vector" d="M4.47 20.5037H19.53C21.07 20.5037 22.03 18.8337 21.26 17.5037L13.73 4.49375C12.96 3.16375 11.04 3.16375 10.27 4.49375L2.74 17.5037C1.97 18.8337 2.93 20.5037 4.47 20.5037ZM12 13.5037C11.45 13.5037 11 13.0537 11 12.5037V10.5037C11 9.95375 11.45 9.50375 12 9.50375C12.55 9.50375 13 9.95375 13 10.5037V12.5037C13 13.0537 12.55 13.5037 12 13.5037ZM13 17.5037H11V15.5037H13V17.5037Z" />
    </g>
</svg>
`;

// Global status icons
const VARIANT_ICONS = {
    neutral: {
        icon: neutralIcon,
        ariaLabel: "Neutral",
    },
    info: {
        icon: infoIcon,
        ariaLabel: "For your information",
    },
    warning: {
        icon: warningIcon$1,
        ariaLabel: "Warning",
    },
    error: {
        icon: errorIcon,
        ariaLabel: "Error",
    },
    success: {
        icon: successIcon,
        ariaLabel: "Success",
    },
};
// Global ARIA attributes
const IC_INHERITED_ARIA = [
    "aria-atomic",
    "aria-autocomplete",
    "aria-busy",
    "aria-controls",
    "aria-current",
    "aria-describedby",
    "aria-description",
    "aria-details",
    "aria-disabled",
    "aria-dropeffect",
    "aria-errormessage",
    "aria-expanded",
    "aria-flowto",
    "aria-grabbed",
    "aria-haspopup",
    "aria-hidden",
    "aria-invalid",
    "aria-keyshortcuts",
    "aria-label",
    "aria-labelledby",
    "aria-live",
    "aria-owns",
    "aria-relevant",
    "aria-roledescription",
];
const IC_DEVICE_SIZES = {
    XS: 576,
    S: 768,
    M: 992,
    L: 1200,
    XL: 99999,
};
const IC_BLOCK_COLOR_COMPONENTS = [
    "ic-hero",
    "ic-top-navigation",
    "ic-footer",
    "ic-side-navigation",
    "ic-alert",
];
const IC_FIXED_COLOR_COMPONENTS = ["ic-alert"];
const IC_BLOCK_COLOR_EXCEPTIONS = {
    "ic-alert": ["ic-link"],
};
/* Range within which the chosen theme colour would not have a sufficient brightness difference with either of the black or white foreground colours
 * The brightness difference must be greater than 125 to provide good colour visibility
 * Calculated by:
 * - Using the brightness formula for both colours: https://www.w3.org/TR/AERT/#color-contrast
 * - Adding 125 to the brightness of the black foreground colour - RGB(11, 12, 12)
 * - Subtracting 125 from the brightness of the white foreground colour - RGB(255, 255, 255)
 */
const BLACK_MIN_COLOR_BRIGHTNESS = 136.701;
const WHITE_MAX_COLOR_BRIGHTNESS = 130;

const DARK_MODE_THRESHOLD = 133.3505;
const icInput = "ic-input";
const linkIcInput = "input.ic-input";
/**
 * Used to inherit global attributes set on the host. Called in componentWillLoad and assigned
 * to a variable that is later used in the render function.
 *
 * This does not need to be reactive as changing attributes on the host element
 * does not trigger a re-render.
 */
const inheritAttributes = (element, attributes = []) => {
    const attributeObject = {};
    attributes.forEach((attr) => {
        if (element.hasAttribute(attr)) {
            const value = element.getAttribute(attr);
            if (value !== null) {
                attributeObject[attr] = value;
            }
            element.removeAttribute(attr);
        }
    });
    return attributeObject;
};
const debounceEvent = (event, wait) => {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const original = event._original || event;
    return {
        _original: event,
        emit: debounce$1(original.emit.bind(original), wait),
    };
};
const debounce$1 = (func, wait = 0) => {
    let timer;
    return (...args) => {
        clearTimeout(timer);
        timer = setTimeout(func, wait, ...args);
    };
};
/**
 * This method is used to add a hidden input to a host element that contains
 * a Shadow DOM. It does not add the input inside of the Shadow root which
 * allows it to be picked up inside of forms. It should contain the same
 * values as the host element.
 *
 * @param always Add a hidden input even if the container does not use Shadow
 * @param container The element where the input will be added
 * @param name The name of the input
 * @param value The value of the input
 * @param disabled If true, the input is disabled
 */
const renderHiddenInput = (always, container, name, value, disabled) => {
    if (name !== undefined && (always || hasShadowDom(container))) {
        const inputs = container.querySelectorAll(linkIcInput);
        const inputEls = Array.from(inputs);
        const filtered = inputEls.filter((el) => container === el.parentElement);
        let input = filtered[0];
        if (input === null || input === undefined) {
            input = container.ownerDocument.createElement("input");
            input.type = "hidden";
            input.classList.add(icInput);
            container.appendChild(input);
        }
        input.disabled = disabled;
        input.name = name;
        if (value instanceof Date) {
            input.value = value ? value.toISOString() : null;
        }
        else {
            input.value = value || "";
        }
    }
};
/**
 * This method is used to add a hidden file input to a host element that contains
 * a Shadow DOM. It does not add the input inside of the Shadow root which
 * allows it to be picked up inside of forms. It should contain the same
 * values as the host element.
 *
 * @param event: The event that is emitted once a file is selected.
 * @param container The element where the input will be added
 * @param multiple If true, multiple files can be selected
 * @param name The name of the input
 * @param value The value of the input
 * @param disabled If true, the input is disabled
 * @param accept A string of the accepted files
 */
const renderFileHiddenInput = (event, container, multiple, name, value, disabled, accept) => {
    if (name !== undefined && hasShadowDom(container)) {
        const inputs = container.querySelectorAll(linkIcInput);
        const inputEls = Array.from(inputs);
        const filtered = inputEls.filter((el) => container === el.parentElement);
        let input = filtered[0];
        if (input === null || input === undefined) {
            input = container.ownerDocument.createElement("input");
            input.classList.add(icInput);
            container.appendChild(input);
        }
        input.type = "file";
        input.hidden = true;
        input.multiple = multiple;
        input.name = name;
        input.files = value;
        input.disabled = disabled;
        input.accept = accept;
        input.onchange = () => {
            event.emit(input.files);
        };
        input.click();
    }
};
const removeHiddenInput = (container) => {
    const inputs = container.querySelectorAll("input.ic-input");
    const inputEls = Array.from(inputs);
    const filtered = inputEls.filter((el) => container === el.parentElement);
    const input = filtered[0];
    input === null || input === void 0 ? void 0 : input.remove();
};
const hasShadowDom = (el) => !!el.shadowRoot && !!el.attachShadow;
const getInputHelperTextID = (id) => id + "-helper-text";
const getInputValidationTextID = (id) => id + "-validation-text";
const getInputDescribedByText = (inputId, helperText, validationText) => `${helperText ? getInputHelperTextID(inputId) : ""} ${validationText ? getInputValidationTextID(inputId) : ""}`.trim();
/**
 * This method helps to understand the context in which a component exists,
 * to assist with choosing appropriate foreground colours to use. For example,
 * this method will help you use the 'white' version of a button if it's within
 * a block colour element using white foreground text.
 *
 * This only works for components/elements passed via <slot> and not if they
 * are part of an IC component.
 *
 * ""
 * @returns IcThemeForeground depending on the context
 */
const getThemeFromContext = (el, themeFromEvent = null) => {
    var _a;
    const parentElement = el.parentElement || el.getRootNode().host.parentElement;
    const blockColorParent = parentElement.closest(IC_BLOCK_COLOR_COMPONENTS.join(","));
    // If within a block color component
    if (blockColorParent !== null) {
        const parentTag = blockColorParent.tagName.toLowerCase();
        const currentTag = el.tagName.toLowerCase();
        if ((_a = IC_BLOCK_COLOR_EXCEPTIONS[parentTag]) === null || _a === void 0 ? void 0 : _a.includes(currentTag)) {
            return IcThemeForegroundEnum.Default;
        }
        else if (themeFromEvent !== null &&
            !IC_FIXED_COLOR_COMPONENTS.includes(parentTag)) {
            return themeFromEvent;
        }
        else if (blockColorParent.classList.contains(IcThemeForegroundEnum.Dark)) {
            return IcThemeForegroundEnum.Dark;
        }
        return IcThemeForegroundEnum.Light;
    }
    return IcThemeForegroundEnum.Default;
};
/**
 * Checks if the current device is a mobile or tablet device.
 * @returns {boolean} Returns true if the device is a mobile or tablet device, otherwise returns false.
 */
const isMobileOrTablet = () => "maxTouchPoints" in navigator && "userAgent" in navigator
    ? navigator.maxTouchPoints > 0 &&
        /iPad|iPhone|iPod|Android|webOS|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)
    : false;
/**
 * Will create a button within the lightDOM which interacts with the parent form.
 * This is required as buttons within the shadowDOM will not invoke a submit or reset
 *
 * @param form - parent form element which contains shadowDom button
 * @param button - shadowDOM button
 */
const handleHiddenFormButtonClick = (form, button) => {
    const hiddenFormButton = document.createElement("button");
    hiddenFormButton.setAttribute("type", button.type);
    hiddenFormButton.style.display = "none";
    form.appendChild(hiddenFormButton);
    hiddenFormButton.click();
    hiddenFormButton.remove();
};
const isEmptyString = (value) => value ? value.trim().length === 0 : true;
// A helper function that checks if a prop has been defined
const isPropDefined = (prop) => prop !== undefined ? prop : null;
/**
 * Extracts the label using the value from an object. Requires the object to have a label and value property.
 * @param value - value from object
 * @param options - list of menu items
 * @returns - label corresponding to value
 */
const getLabelFromValue = (value, options, valueField = "value", labelField = "label") => {
    const ungroupedOptions = [];
    if (options.length > 0 && options.map) {
        options.map((option) => {
            if (option.children) {
                option.children.map((option) => ungroupedOptions.push(option));
            }
            else {
                ungroupedOptions.push(option);
            }
        });
        const matchingValue = ungroupedOptions.find((option) => option[valueField] === value);
        if (matchingValue !== undefined)
            return matchingValue[labelField];
    }
    return undefined;
};
/**
 * Filters the options based on the search string.
 * @param options - array of options
 * @param includeDescriptions - determines whether option descriptions are included when filtering options
 * @param searchString - string used to filter the options
 * @param position - whether the search string matches the start of or anywhere in the options
 * @returns filtered array of options
 */
const getFilteredMenuOptions = (options, includeDescriptions, searchString, position, labelField = "label") => options.filter((option) => {
    var _a;
    const label = option[labelField].toLowerCase();
    const description = (_a = option.description) === null || _a === void 0 ? void 0 : _a.toLowerCase();
    const lowerSearchString = searchString.toLowerCase();
    return position === "anywhere"
        ? includeDescriptions
            ? label.includes(lowerSearchString) ||
                (description === null || description === void 0 ? void 0 : description.includes(lowerSearchString))
            : label.includes(lowerSearchString)
        : includeDescriptions
            ? label.startsWith(lowerSearchString) ||
                (description === null || description === void 0 ? void 0 : description.startsWith(lowerSearchString))
            : label.startsWith(lowerSearchString);
});
const deviceSizeMatches = (size) => window.matchMedia(`(max-width: ${size}px)`).matches;
const getCurrentDeviceSize = () => {
    if (deviceSizeMatches(DEVICE_SIZES.S)) {
        return DEVICE_SIZES.S;
    }
    if (deviceSizeMatches(DEVICE_SIZES.M)) {
        return DEVICE_SIZES.M;
    }
    if (deviceSizeMatches(DEVICE_SIZES.L)) {
        return DEVICE_SIZES.L;
    }
    if (deviceSizeMatches(DEVICE_SIZES.XL)) {
        return DEVICE_SIZES.XL;
    }
    //fallback needed as all of above get initialised to 0 in jest tests
    return DEVICE_SIZES.UNDEFINED;
};
const getCssProperty = (cssVar) => getComputedStyle(document.documentElement).getPropertyValue(cssVar);
/**
 * Returns the brightness of the theme colour, calculated by using the theme RGB CSS values by:
 * - Multiplying each RGB value by a set number: https://www.w3.org/TR/AERT/#color-contrast
 * - Adding them together and dividing by 1000
 * This is a similar calculation to its CSS counterpart: "--ic-theme-text"
 * @returns number representing the brightness of the theme colour
 */
const getThemeColorBrightness = () => {
    const themeRed = getCssProperty("--ic-theme-primary-r");
    const themeGreen = getCssProperty("--ic-theme-primary-g");
    const themeBlue = getCssProperty("--ic-theme-primary-b");
    return ((parseInt(themeRed) * 299 +
        parseInt(themeGreen) * 587 +
        parseInt(themeBlue) * 114) /
        1000);
};
/**
 * Returns if dark or light foreground colors should be used for color contrast reasons
 * @returns "dark" or "light"
 * @param brightness - Optional custom brightness value. Defaults to `getThemeColorBrightness`
 */
const getThemeForegroundColor = (brightness = getThemeColorBrightness()) => brightness > DARK_MODE_THRESHOLD
    ? IcThemeForegroundEnum.Dark
    : IcThemeForegroundEnum.Light;
const getSlot = (element, name) => {
    if (element && element.querySelector) {
        return element.querySelector(`[slot="${name}"]`);
    }
    return null;
};
const slotHasContent = (element, name) => getSlot(element, name) !== null;
const getSlotContent = (element, name) => {
    const slot = getSlot(element, name);
    if (slot) {
        return getSlotElements(slot);
    }
    return null;
};
const getSlotElements = (slot) => {
    const slotContent = slot.firstElementChild;
    if (slotContent !== null) {
        const elements = slotContent.assignedElements
            ? slotContent.assignedElements()
            : slotContent.childNodes;
        return elements.length ? elements : slot.tagName ? [slot] : null;
    }
    else {
        //check for single element
        return slot === null ? null : [slot];
    }
};
const getNavItemParentDetails = ({ parentElement, }) => {
    let navType = { navType: "", parent: null };
    switch (parentElement.tagName) {
        case "IC-NAVIGATION-GROUP":
            navType = getNavItemParentDetails(parentElement);
            break;
        case "IC-TOP-NAVIGATION":
            navType = { navType: "top", parent: parentElement };
            break;
        case "IC-SIDE-NAVIGATION":
            navType = { navType: "side", parent: parentElement };
            break;
        case "IC-PAGE-HEADER":
            navType = { navType: "page-header", parent: null };
            break;
    }
    return navType;
};
const DEVICE_SIZES = {
    XS: Number(getCssProperty("--ic-breakpoint-xs").replace("px", "")), // 0
    S: Number(getCssProperty("--ic-breakpoint-sm").replace("px", "")), // 576
    M: Number(getCssProperty("--ic-breakpoint-md").replace("px", "")), // 768
    L: Number(getCssProperty("--ic-breakpoint-lg").replace("px", "")), // 992
    XL: Number(getCssProperty("--ic-breakpoint-xl").replace("px", "")), // 1200
    UNDEFINED: 1200,
};
const hasValidationStatus = (status, disabled) => !!status && !disabled;
const isSlotUsed = ({ children }, slotName) => Array.from(children).some((child) => child.getAttribute("slot") === slotName);
// added as a common method to allow detection of gatsby hydration issue, where (camelCase) props are initially undefined & then update
// with a value. Allows a callback function to be executed when this is the case
const onComponentPropUndefinedChange = (oldValue, newValue, callback) => {
    if (oldValue === undefined && newValue !== oldValue) {
        callback();
    }
};
const onComponentRequiredPropUndefined = (props, component) => {
    props.forEach(({ prop, propName }) => {
        if (prop === null || prop === undefined) {
            console.error(`No ${propName} specified for ${component} component - prop '${propName}' (web components) / '${kebabToCamelCase(propName)}' (react) required`);
        }
    });
};
const kebabToCamelCase = (kebabCase) => kebabCase
    .toLowerCase()
    .split("-")
    .map((word, index) => index === 0
    ? word
    : `${word.substring(0, 1).toUpperCase()}${word.substring(1)}`)
    .join("");
const checkResizeObserver = (callbackFn) => {
    if (typeof window !== "undefined" &&
        typeof window.ResizeObserver !== "undefined") {
        callbackFn();
    }
};
const hex2dec = (v) => parseInt(v, 16);
const hexToRgba = (hex) => {
    const hexChars = hex
        .replace("#", "")
        .split("")
        .map((char) => char.repeat(2));
    return {
        r: hex2dec(hex.length === 4 ? hexChars[0] : hex.slice(1, 3)),
        g: hex2dec(hex.length === 4 ? hexChars[1] : hex.slice(3, 5)),
        b: hex2dec(hex.length === 4 ? hexChars[2] : hex.slice(5)),
        a: 1,
    };
};
const rgbaStrToObj = (rgbaStr) => {
    const isRGBA = rgbaStr.slice(3, 4).toLowerCase() === "a";
    const rgbValues = rgbaStr
        .substring(isRGBA ? 5 : 4, rgbaStr.length - 1)
        .replace(/ /g, "")
        .split(",")
        .map(Number);
    return {
        r: rgbValues[0],
        g: rgbValues[1],
        b: rgbValues[2],
        a: isRGBA ? rgbValues[3] : 1,
    };
};
const elementOverflowsX = ({ scrollWidth, clientWidth, }) => scrollWidth > clientWidth;
const hasClassificationBanner = () => !!document.querySelector("ic-classification-banner:not([inline='true'])");
const addFormResetListener = (el, callbackFn) => {
    var _a;
    (_a = el.closest("FORM")) === null || _a === void 0 ? void 0 : _a.addEventListener("reset", callbackFn);
};
const removeFormResetListener = (el, callbackFn) => {
    var _a;
    (_a = el.closest("FORM")) === null || _a === void 0 ? void 0 : _a.removeEventListener("reset", callbackFn);
};
const pxToRem = (px, base = 16) => `${(1 / base) * parseInt(px)}rem`;
const removeDisabledFalse = (disabled, element) => {
    if (!disabled) {
        element.removeAttribute("disabled");
    }
};
const convertToRGBA = (color) => {
    const firstChar = color === null || color === void 0 ? void 0 : color.slice(0, 1).toLowerCase();
    return firstChar === "#"
        ? hexToRgba(color)
        : firstChar === "r"
            ? rgbaStrToObj(color)
            : null;
};
const capitalize = (text) => text.charAt(0).toUpperCase() + text.slice(1);
const checkSlotInChildMutations = (addedNodes, removedNodes, slotName) => {
    const hasSlot = (nodeList) => Array.from(nodeList).some((node) => Array.isArray(slotName)
        ? slotName.some((name) => node.slot === name)
        : node.slot === slotName);
    return hasSlot(addedNodes) || hasSlot(removedNodes);
};
const isElInAGGrid = (el) => !!el.closest(".ag-cell") && !!el.closest(".ag-root");

var chevronIcon = `<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.70687 6L8.29688 7.41L12.8769 12L8.29688 16.59L9.70687 18L15.7069 12L9.70687 6Z" fill="currentColor"/>
</svg>
`;

const icAccordionCss = "/*!@html*/html.sc-ic-accordion{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-accordion{margin:0}/*!@main*/main.sc-ic-accordion{display:block}/*!@h1*/h1.sc-ic-accordion{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-accordion{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-accordion{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-accordion{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-accordion{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-accordion,strong.sc-ic-accordion{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-accordion,kbd.sc-ic-accordion,samp.sc-ic-accordion{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-accordion{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-accordion,sup.sc-ic-accordion{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-accordion{bottom:-0.25em}/*!@sup*/sup.sc-ic-accordion{top:-0.5em}/*!@img*/img.sc-ic-accordion{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-accordion,input.sc-ic-accordion,optgroup.sc-ic-accordion,select.sc-ic-accordion,textarea.sc-ic-accordion{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-accordion,input.sc-ic-accordion{overflow:visible}/*!@button,\nselect*/button.sc-ic-accordion,select.sc-ic-accordion{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-accordion,[type=\"button\"].sc-ic-accordion,[type=\"reset\"].sc-ic-accordion,[type=\"submit\"].sc-ic-accordion{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-accordion::-moz-focus-inner,[type=\"button\"].sc-ic-accordion::-moz-focus-inner,[type=\"reset\"].sc-ic-accordion::-moz-focus-inner,[type=\"submit\"].sc-ic-accordion::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-accordion:-moz-focusring,[type=\"button\"].sc-ic-accordion:-moz-focusring,[type=\"reset\"].sc-ic-accordion:-moz-focusring,[type=\"submit\"].sc-ic-accordion:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-accordion{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-accordion{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-accordion{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-accordion{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-accordion,[type=\"radio\"].sc-ic-accordion{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-accordion::-webkit-inner-spin-button,[type=\"number\"].sc-ic-accordion::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-accordion{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-accordion::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-accordion::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-accordion{display:block}/*!@summary*/summary.sc-ic-accordion{display:list-item}/*!@template*/template.sc-ic-accordion{display:none}/*!@[hidden]*/[hidden].sc-ic-accordion{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-accordion,body.sc-ic-accordion,div.sc-ic-accordion,span.sc-ic-accordion,applet.sc-ic-accordion,object.sc-ic-accordion,iframe.sc-ic-accordion,h1.sc-ic-accordion,h2.sc-ic-accordion,h3.sc-ic-accordion,h4.sc-ic-accordion,h5.sc-ic-accordion,h6.sc-ic-accordion,p.sc-ic-accordion,blockquote.sc-ic-accordion,pre.sc-ic-accordion,a.sc-ic-accordion,abbr.sc-ic-accordion,acronym.sc-ic-accordion,address.sc-ic-accordion,big.sc-ic-accordion,cite.sc-ic-accordion,code.sc-ic-accordion,del.sc-ic-accordion,dfn.sc-ic-accordion,em.sc-ic-accordion,img.sc-ic-accordion,ins.sc-ic-accordion,kbd.sc-ic-accordion,q.sc-ic-accordion,s.sc-ic-accordion,samp.sc-ic-accordion,small.sc-ic-accordion,strike.sc-ic-accordion,strong.sc-ic-accordion,sub.sc-ic-accordion,sup.sc-ic-accordion,tt.sc-ic-accordion,var.sc-ic-accordion,b.sc-ic-accordion,u.sc-ic-accordion,i.sc-ic-accordion,center.sc-ic-accordion,dl.sc-ic-accordion,dt.sc-ic-accordion,dd.sc-ic-accordion,ol.sc-ic-accordion,ul.sc-ic-accordion,li.sc-ic-accordion,fieldset.sc-ic-accordion,form.sc-ic-accordion,label.sc-ic-accordion,legend.sc-ic-accordion,table.sc-ic-accordion,caption.sc-ic-accordion,tbody.sc-ic-accordion,tfoot.sc-ic-accordion,thead.sc-ic-accordion,tr.sc-ic-accordion,th.sc-ic-accordion,td.sc-ic-accordion,article.sc-ic-accordion,aside.sc-ic-accordion,canvas.sc-ic-accordion,details.sc-ic-accordion,embed.sc-ic-accordion,figure.sc-ic-accordion,figcaption.sc-ic-accordion,footer.sc-ic-accordion,header.sc-ic-accordion,hgroup.sc-ic-accordion,menu.sc-ic-accordion,nav.sc-ic-accordion,output.sc-ic-accordion,ruby.sc-ic-accordion,section.sc-ic-accordion,summary.sc-ic-accordion,time.sc-ic-accordion,mark.sc-ic-accordion,audio.sc-ic-accordion,video.sc-ic-accordion{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-accordion-h{display:block;border-bottom:var(--ic-border-default)}/*!@:host ic-typography,\n:host .expand-chevron*/.sc-ic-accordion-h ic-typography.sc-ic-accordion,.sc-ic-accordion-h .expand-chevron.sc-ic-accordion{color:var(--ic-color-primary-text)}/*!@:host(.light) ic-typography,\n:host(.light) .expanded-content,\n:host(.light) .icon-container,\n:host(.light) .expand-chevron*/.light.sc-ic-accordion-h ic-typography.sc-ic-accordion,.light.sc-ic-accordion-h .expanded-content.sc-ic-accordion,.light.sc-ic-accordion-h .icon-container.sc-ic-accordion,.light.sc-ic-accordion-h .expand-chevron.sc-ic-accordion{color:var(--ic-color-white-text)}/*!@:host(.disabled) ic-typography,\n:host(.disabled) .icon-container,\n:host(.disabled) .expand-chevron*/.disabled.sc-ic-accordion-h ic-typography.sc-ic-accordion,.disabled.sc-ic-accordion-h .icon-container.sc-ic-accordion,.disabled.sc-ic-accordion-h .expand-chevron.sc-ic-accordion{color:var(--ic-architectural-500)}/*!@.section-button.small*/.section-button.small.sc-ic-accordion{padding:var(--ic-space-xxs) var(--ic-space-xs)}/*!@.section-button.large*/.section-button.large.sc-ic-accordion{padding:var(--ic-space-sm) var(--ic-space-xs)}/*!@:host(:first-of-type)*/.sc-ic-accordion-h:first-of-type{border-top:var(--ic-border-default)}/*!@:focus*/.sc-ic-accordion:focus{outline:none}/*!@.section-button*/.section-button.sc-ic-accordion{background-color:transparent;display:flex;align-items:center;width:100%;padding:var(--ic-space-xs);font-weight:var(--ic-font-weight-bold);border:none}/*!@.section-header*/.section-header.sc-ic-accordion{text-align:left;flex:1 0}/*!@button:hover:enabled*/button.sc-ic-accordion:hover:enabled{background-color:var(--ic-action-dark-bg-hover);cursor:pointer}/*!@button:active*/button.sc-ic-accordion:active{background-color:var(--ic-action-dark-bg-active)}/*!@button:focus*/button.sc-ic-accordion:focus{box-shadow:var(--ic-border-focus);border-radius:var(--ic-border-radius);transition:var(--ic-transition-duration-fast)}/*!@button:disabled*/button.sc-ic-accordion:disabled{pointer-events:none}/*!@.icon-container*/.icon-container.sc-ic-accordion{margin:0 var(--ic-space-xs) 0 0;display:flex;align-items:center;width:var(--ic-space-lg);height:var(--ic-space-lg)}/*!@::slotted(svg)*/.sc-ic-accordion-s>svg{width:var(--ic-space-md);height:var(--ic-space-md)}/*!@.expand-chevron*/.expand-chevron.sc-ic-accordion{width:var(--ic-space-lg);height:var(--ic-space-lg);margin-left:calc(var(--ic-space-xl) + var(--ic-space-xs));transform:rotate(90deg);justify-self:end}/*!@.content-expanded-chevron*/.content-expanded-chevron.sc-ic-accordion{transform:rotate(-90deg)}/*!@.expanded-content*/.expanded-content.sc-ic-accordion{height:0;overflow:hidden;display:flex;flex-direction:column;visibility:var(--ic-expanded-content-visibility, hidden)}/*!@.expanded-content-inner*/.expanded-content-inner.sc-ic-accordion{padding:var(--ic-space-xs)}/*!@.expanded-content-opened*/.expanded-content-opened.sc-ic-accordion{overflow:visible}@media (forced-colors: active){/*!@button:focus*/button.sc-ic-accordion:focus{border:var(--ic-hc-border) !important}}";

let accordionIds = 0;
/**
 * @slot heading - Content is placed as the accordion heading.
 * @slot icon - Content is placed to the left of the heading.
 */
class Accordion {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.accordionClicked = createEvent(this, "accordionClicked", 7);
        this.accordionId = `ic-accordion-${accordionIds++}`;
        this.CONTENT_VISIBILITY_PROPERTY = "--ic-expanded-content-visibility";
        this.toggleExpanded = () => {
            this.expanded = !this.expanded;
            this.accordionClicked.emit({ id: this.accordionId });
        };
        // Set accordion animation
        this.setAccordionAnimation = (el, duration, property, delay) => {
            el.style.transitionDuration = `${duration}ms`;
            el.style.transitionProperty = property;
            el.style.transitionDelay = delay;
        };
        this.setExpandedContentStyle = (ev, expandedContent) => {
            if (ev.propertyName === "height" && expandedContent.clientHeight > 0) {
                expandedContent.classList.add("expanded-content-opened");
                expandedContent.style.height = "auto";
            }
        };
        this.hideExpandedContent = (ev, expandedContent) => {
            if (ev.propertyName === "height" && expandedContent.clientHeight === 0) {
                expandedContent.style.setProperty(this.CONTENT_VISIBILITY_PROPERTY, "hidden");
            }
        };
        this.animateExpandedContent = () => {
            const elementHeight = this.expandedContentEl.scrollHeight;
            if (elementHeight > 0 && this.expanded) {
                this.expandedContentEl.style.setProperty(this.CONTENT_VISIBILITY_PROPERTY, "visible");
                this.expandedContentEl.style.height = `${elementHeight}px`;
                this.setAccordionAnimation(this.expandedContentEl, "300", "height", "ease-out");
                this.expandedContentEl.addEventListener("transitionend", (e) => {
                    this.setExpandedContentStyle(e, this.expandedContentEl);
                });
            }
            else if (!this.expanded) {
                this.expandedContentEl.style.height = `${this.expandedContentEl.scrollHeight}px`;
                if (this.expandedContentEl.scrollHeight > 0 && !this.expanded) {
                    this.expandedContentEl.style.height = "0";
                    this.setAccordionAnimation(this.expandedContentEl, "300", "height", "ease-in");
                    this.expandedContentEl.classList.remove("expanded-content-opened");
                }
                this.expandedContentEl.addEventListener("transitionend", (e) => {
                    this.hideExpandedContent(e, this.expandedContentEl);
                });
            }
        };
        this.appearance = "default";
        this.disabled = false;
        this.expanded = false;
        this.heading = "";
        this.message = "";
        this.size = "default";
    }
    // Every time expanded is set via toggleExpanded or accordionGroup, animate to open or close
    handleExpandedWatch() {
        this.animateExpandedContent();
    }
    /**
     * Sets focus on accordion heading.
     */
    async setFocus() {
        if (this.accordionBtnHeading) {
            this.accordionBtnHeading.focus();
        }
    }
    disconnectedCallback() {
        if (this.expandedContentEl) {
            this.expandedContentEl.removeEventListener("transitionend", (e) => this.setExpandedContentStyle(e, this.expandedContentEl), true);
            this.expandedContentEl.removeEventListener("transitionend", (e) => this.hideExpandedContent(e, this.expandedContentEl), true);
        }
    }
    componentDidLoad() {
        // So accordion opens by default if expanded set to true
        if (this.expanded) {
            this.expandedContentEl.style.height = "auto";
            this.expandedContentEl.style.setProperty(this.CONTENT_VISIBILITY_PROPERTY, "visible");
        }
    }
    render() {
        const { appearance, size, disabled, expanded } = this;
        return (hAsync(Host, { id: this.accordionId, class: {
                [`${appearance}`]: true,
                ["disabled"]: disabled,
            }, "aria-disabled": disabled ? "true" : "false" }, hAsync("button", { ref: (el) => (this.accordionBtnHeading = el), id: `${this.accordionId}-button`, disabled: disabled, tabindex: disabled ? -1 : 0, class: {
                [`${size}`]: true,
                ["section-button"]: true,
                ["section-button-open"]: expanded && !disabled,
            }, "aria-expanded": `${expanded}`, "aria-controls": "expanded-content-area", onClick: this.toggleExpanded }, isSlotUsed(this.el, "icon") && (hAsync("div", { class: "icon-container" }, hAsync("slot", { name: "icon" }))), hAsync("ic-typography", { variant: "subtitle-large", class: "section-header" }, isSlotUsed(this.el, "heading") ? (hAsync("slot", { name: "heading" })) : (this.heading)), hAsync("span", { class: {
                ["expand-chevron"]: true,
                ["content-expanded-chevron"]: expanded && !disabled,
            }, "aria-hidden": "true", innerHTML: chevronIcon })), hAsync("div", { class: {
                ["expanded-content"]: true,
            }, "aria-labelledby": `${this.accordionId}-button`, role: "region", "aria-hidden": `${!expanded}`, id: "expanded-content-area", ref: (el) => (this.expandedContentEl = el) }, hAsync("div", { class: "expanded-content-inner" }, this.message ? (hAsync("ic-typography", { variant: "body" }, this.message)) : (hAsync("slot", null))))));
    }
    get el() { return getElement(this); }
    static get watchers() { return {
        "expanded": ["handleExpandedWatch"]
    }; }
    static get style() { return icAccordionCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-accordion",
        "$members$": {
            "appearance": [1],
            "disabled": [4],
            "expanded": [1028],
            "heading": [1],
            "message": [1],
            "size": [1],
            "setFocus": [64]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icAccordionGroupCss = "/*!@html*/html.sc-ic-accordion-group{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-accordion-group{margin:0}/*!@main*/main.sc-ic-accordion-group{display:block}/*!@h1*/h1.sc-ic-accordion-group{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-accordion-group{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-accordion-group{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-accordion-group{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-accordion-group{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-accordion-group,strong.sc-ic-accordion-group{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-accordion-group,kbd.sc-ic-accordion-group,samp.sc-ic-accordion-group{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-accordion-group{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-accordion-group,sup.sc-ic-accordion-group{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-accordion-group{bottom:-0.25em}/*!@sup*/sup.sc-ic-accordion-group{top:-0.5em}/*!@img*/img.sc-ic-accordion-group{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-accordion-group,input.sc-ic-accordion-group,optgroup.sc-ic-accordion-group,select.sc-ic-accordion-group,textarea.sc-ic-accordion-group{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-accordion-group,input.sc-ic-accordion-group{overflow:visible}/*!@button,\nselect*/button.sc-ic-accordion-group,select.sc-ic-accordion-group{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-accordion-group,[type=\"button\"].sc-ic-accordion-group,[type=\"reset\"].sc-ic-accordion-group,[type=\"submit\"].sc-ic-accordion-group{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-accordion-group::-moz-focus-inner,[type=\"button\"].sc-ic-accordion-group::-moz-focus-inner,[type=\"reset\"].sc-ic-accordion-group::-moz-focus-inner,[type=\"submit\"].sc-ic-accordion-group::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-accordion-group:-moz-focusring,[type=\"button\"].sc-ic-accordion-group:-moz-focusring,[type=\"reset\"].sc-ic-accordion-group:-moz-focusring,[type=\"submit\"].sc-ic-accordion-group:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-accordion-group{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-accordion-group{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-accordion-group{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-accordion-group{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-accordion-group,[type=\"radio\"].sc-ic-accordion-group{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-accordion-group::-webkit-inner-spin-button,[type=\"number\"].sc-ic-accordion-group::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-accordion-group{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-accordion-group::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-accordion-group::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-accordion-group{display:block}/*!@summary*/summary.sc-ic-accordion-group{display:list-item}/*!@template*/template.sc-ic-accordion-group{display:none}/*!@[hidden]*/[hidden].sc-ic-accordion-group{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-accordion-group,body.sc-ic-accordion-group,div.sc-ic-accordion-group,span.sc-ic-accordion-group,applet.sc-ic-accordion-group,object.sc-ic-accordion-group,iframe.sc-ic-accordion-group,h1.sc-ic-accordion-group,h2.sc-ic-accordion-group,h3.sc-ic-accordion-group,h4.sc-ic-accordion-group,h5.sc-ic-accordion-group,h6.sc-ic-accordion-group,p.sc-ic-accordion-group,blockquote.sc-ic-accordion-group,pre.sc-ic-accordion-group,a.sc-ic-accordion-group,abbr.sc-ic-accordion-group,acronym.sc-ic-accordion-group,address.sc-ic-accordion-group,big.sc-ic-accordion-group,cite.sc-ic-accordion-group,code.sc-ic-accordion-group,del.sc-ic-accordion-group,dfn.sc-ic-accordion-group,em.sc-ic-accordion-group,img.sc-ic-accordion-group,ins.sc-ic-accordion-group,kbd.sc-ic-accordion-group,q.sc-ic-accordion-group,s.sc-ic-accordion-group,samp.sc-ic-accordion-group,small.sc-ic-accordion-group,strike.sc-ic-accordion-group,strong.sc-ic-accordion-group,sub.sc-ic-accordion-group,sup.sc-ic-accordion-group,tt.sc-ic-accordion-group,var.sc-ic-accordion-group,b.sc-ic-accordion-group,u.sc-ic-accordion-group,i.sc-ic-accordion-group,center.sc-ic-accordion-group,dl.sc-ic-accordion-group,dt.sc-ic-accordion-group,dd.sc-ic-accordion-group,ol.sc-ic-accordion-group,ul.sc-ic-accordion-group,li.sc-ic-accordion-group,fieldset.sc-ic-accordion-group,form.sc-ic-accordion-group,label.sc-ic-accordion-group,legend.sc-ic-accordion-group,table.sc-ic-accordion-group,caption.sc-ic-accordion-group,tbody.sc-ic-accordion-group,tfoot.sc-ic-accordion-group,thead.sc-ic-accordion-group,tr.sc-ic-accordion-group,th.sc-ic-accordion-group,td.sc-ic-accordion-group,article.sc-ic-accordion-group,aside.sc-ic-accordion-group,canvas.sc-ic-accordion-group,details.sc-ic-accordion-group,embed.sc-ic-accordion-group,figure.sc-ic-accordion-group,figcaption.sc-ic-accordion-group,footer.sc-ic-accordion-group,header.sc-ic-accordion-group,hgroup.sc-ic-accordion-group,menu.sc-ic-accordion-group,nav.sc-ic-accordion-group,output.sc-ic-accordion-group,ruby.sc-ic-accordion-group,section.sc-ic-accordion-group,summary.sc-ic-accordion-group,time.sc-ic-accordion-group,mark.sc-ic-accordion-group,audio.sc-ic-accordion-group,video.sc-ic-accordion-group{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@.group-title-container*/.group-title-container.sc-ic-accordion-group{padding:var(--ic-space-xs);display:flex;justify-content:space-between;align-items:center}/*!@:host(.small) .group-title-container*/.small.sc-ic-accordion-group-h .group-title-container.sc-ic-accordion-group{padding:var(--ic-space-xxs) var(--ic-space-xs)}/*!@:host(.large) .group-title-container*/.large.sc-ic-accordion-group-h .group-title-container.sc-ic-accordion-group{padding:var(--ic-space-sm) var(--ic-space-xs)}/*!@:host(.light)*/.light.sc-ic-accordion-group-h{color:var(--ic-color-white-text)}/*!@:host(.accordion-group.dark) ::slotted(ic-accordion)*/.sc-ic-accordion-group-h.accordion-group.dark .sc-ic-accordion-group-s>ic-accordion{color:var(--ic-color-white-text)}";

let accordionGroupIds = 0;
/**
 * @slot group-title - Content is placed as the accordion group title.
 */
class AccordionGroup {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.accordionGroupId = `ic-accordion-group-${accordionGroupIds++}`;
        this.handleExpanded = () => {
            if (this.areAllAccordionsOpen) {
                this.expanded = false;
                this.accordions.forEach((acc) => {
                    acc.expanded = this.expanded;
                });
            }
            else {
                this.expanded = true;
                this.accordions.forEach((acc) => {
                    acc.expanded = this.expanded;
                });
            }
            this.setExpandedToAreAllAccordionsOpen();
        };
        this.linkAccordions = () => {
            this.accordions.forEach((accordion) => {
                accordion.setAttribute("context-id", this.accordionGroupId);
            });
        };
        this.setExpandedToAreAllAccordionsOpen = () => {
            this.areAllAccordionsOpen = this.accordions.every((accordion) => !!accordion.expanded);
        };
        this.accordionOpenBtnText = () => {
            return !this.areAllAccordionsOpen ? "See all" : "Hide all";
        };
        this.accordions = undefined;
        this.areAllAccordionsOpen = undefined;
        this.accessibleButtonLabel = "accordions";
        this.appearance = "default";
        this.expanded = false;
        this.groupTitle = "";
        this.singleExpansion = false;
        this.size = "default";
    }
    watchAppearanceHandler() {
        this.accordions.forEach((acc) => {
            acc.appearance = this.appearance;
        });
    }
    watchExpandedHandler() {
        this.handleExpanded();
    }
    componentDidLoad() {
        const accordionDirectChildren = this.el.children;
        this.accordions = Array.from(accordionDirectChildren).filter((child) => child.tagName === "IC-ACCORDION");
        this.linkAccordions();
        this.accordions.forEach((acc) => {
            acc.appearance = this.appearance;
        });
        this.accordions.forEach((acc) => {
            acc.size = this.size;
        });
        if (this.expanded) {
            this.accordions.forEach((acc) => {
                acc.expanded = true;
            });
            this.setExpandedToAreAllAccordionsOpen();
        }
        else {
            this.setExpandedToAreAllAccordionsOpen();
            this.expanded = this.areAllAccordionsOpen;
        }
    }
    handleAccordionClicked(event) {
        if (!this.singleExpansion) {
            // 'See all' should be visible until all accordions are open, then 'Hide all' should be visible
            this.setExpandedToAreAllAccordionsOpen();
        }
        else {
            this.accordions.forEach((acc) => {
                if (acc.expanded && event.detail.id !== acc.id) {
                    acc.expanded = false;
                }
            });
        }
    }
    /**
     * Sets the focus on first focusable element in the accordion group. If the "See/Hide all" button is present, it will be focused.
     * Otherwise, the first accordion will be focused.
     */
    async setFocus() {
        const focusEl = this.singleExpansion
            ? this.accordions[0]
            : this.allButtonEl;
        focusEl.setFocus();
    }
    render() {
        const { appearance, size, groupTitle, singleExpansion, accessibleButtonLabel, } = this;
        return (hAsync(Host, { "context-id": this.accordionGroupId, class: {
                [`${appearance}`]: true,
                [`${size}`]: true,
                ["accordion-group"]: true,
            } }, hAsync("div", { class: "group-title-container" }, hAsync("ic-typography", { variant: "h4" }, hAsync("h3", null, isSlotUsed(this.el, "group-title") ? (hAsync("slot", { name: "group-title" })) : (groupTitle))), !singleExpansion && (hAsync("ic-button", { ref: (el) => (this.allButtonEl = el), appearance: appearance === "light" ? "light" : "default", onClick: this.handleExpanded, variant: "tertiary", "aria-label": `${this.accordionOpenBtnText()} ${accessibleButtonLabel}` }, this.accordionOpenBtnText()))), hAsync("slot", null)));
    }
    get el() { return getElement(this); }
    static get watchers() { return {
        "appearance": ["watchAppearanceHandler"],
        "expanded": ["watchExpandedHandler"]
    }; }
    static get style() { return icAccordionGroupCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-accordion-group",
        "$members$": {
            "accessibleButtonLabel": [1, "accessible-button-label"],
            "appearance": [1],
            "expanded": [1028],
            "groupTitle": [1, "group-title"],
            "singleExpansion": [4, "single-expansion"],
            "size": [1],
            "accordions": [32],
            "areAllAccordionsOpen": [32],
            "setFocus": [64]
        },
        "$listeners$": [[0, "accordionClicked", "handleAccordionClicked"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

var closeIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
    <path d="M0 0h24v24H0z" fill="none"/>
    <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
    <title>close icon</title>
</svg>
`;

const icAlertCss = "/*!@html*/html.sc-ic-alert{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-alert{margin:0}/*!@main*/main.sc-ic-alert{display:block}/*!@h1*/h1.sc-ic-alert{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-alert{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-alert{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-alert{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-alert{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-alert,strong.sc-ic-alert{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-alert,kbd.sc-ic-alert,samp.sc-ic-alert{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-alert{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-alert,sup.sc-ic-alert{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-alert{bottom:-0.25em}/*!@sup*/sup.sc-ic-alert{top:-0.5em}/*!@img*/img.sc-ic-alert{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-alert,input.sc-ic-alert,optgroup.sc-ic-alert,select.sc-ic-alert,textarea.sc-ic-alert{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-alert,input.sc-ic-alert{overflow:visible}/*!@button,\nselect*/button.sc-ic-alert,select.sc-ic-alert{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-alert,[type=\"button\"].sc-ic-alert,[type=\"reset\"].sc-ic-alert,[type=\"submit\"].sc-ic-alert{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-alert::-moz-focus-inner,[type=\"button\"].sc-ic-alert::-moz-focus-inner,[type=\"reset\"].sc-ic-alert::-moz-focus-inner,[type=\"submit\"].sc-ic-alert::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-alert:-moz-focusring,[type=\"button\"].sc-ic-alert:-moz-focusring,[type=\"reset\"].sc-ic-alert:-moz-focusring,[type=\"submit\"].sc-ic-alert:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-alert{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-alert{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-alert{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-alert{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-alert,[type=\"radio\"].sc-ic-alert{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-alert::-webkit-inner-spin-button,[type=\"number\"].sc-ic-alert::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-alert{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-alert::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-alert::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-alert{display:block}/*!@summary*/summary.sc-ic-alert{display:list-item}/*!@template*/template.sc-ic-alert{display:none}/*!@[hidden]*/[hidden].sc-ic-alert{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-alert,body.sc-ic-alert,div.sc-ic-alert,span.sc-ic-alert,applet.sc-ic-alert,object.sc-ic-alert,iframe.sc-ic-alert,h1.sc-ic-alert,h2.sc-ic-alert,h3.sc-ic-alert,h4.sc-ic-alert,h5.sc-ic-alert,h6.sc-ic-alert,p.sc-ic-alert,blockquote.sc-ic-alert,pre.sc-ic-alert,a.sc-ic-alert,abbr.sc-ic-alert,acronym.sc-ic-alert,address.sc-ic-alert,big.sc-ic-alert,cite.sc-ic-alert,code.sc-ic-alert,del.sc-ic-alert,dfn.sc-ic-alert,em.sc-ic-alert,img.sc-ic-alert,ins.sc-ic-alert,kbd.sc-ic-alert,q.sc-ic-alert,s.sc-ic-alert,samp.sc-ic-alert,small.sc-ic-alert,strike.sc-ic-alert,strong.sc-ic-alert,sub.sc-ic-alert,sup.sc-ic-alert,tt.sc-ic-alert,var.sc-ic-alert,b.sc-ic-alert,u.sc-ic-alert,i.sc-ic-alert,center.sc-ic-alert,dl.sc-ic-alert,dt.sc-ic-alert,dd.sc-ic-alert,ol.sc-ic-alert,ul.sc-ic-alert,li.sc-ic-alert,fieldset.sc-ic-alert,form.sc-ic-alert,label.sc-ic-alert,legend.sc-ic-alert,table.sc-ic-alert,caption.sc-ic-alert,tbody.sc-ic-alert,tfoot.sc-ic-alert,thead.sc-ic-alert,tr.sc-ic-alert,th.sc-ic-alert,td.sc-ic-alert,article.sc-ic-alert,aside.sc-ic-alert,canvas.sc-ic-alert,details.sc-ic-alert,embed.sc-ic-alert,figure.sc-ic-alert,figcaption.sc-ic-alert,footer.sc-ic-alert,header.sc-ic-alert,hgroup.sc-ic-alert,menu.sc-ic-alert,nav.sc-ic-alert,output.sc-ic-alert,ruby.sc-ic-alert,section.sc-ic-alert,summary.sc-ic-alert,time.sc-ic-alert,mark.sc-ic-alert,audio.sc-ic-alert,video.sc-ic-alert{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-alert-h{display:block}/*!@.container*/.container.sc-ic-alert{min-height:3.5rem;border-radius:var(--ic-border-radius);position:relative;display:flex;align-items:center}/*!@.container-neutral*/.container-neutral.sc-ic-alert{background-color:var(--ic-status-unknown-light)}/*!@.container-info*/.container-info.sc-ic-alert{background-color:var(--ic-status-info-light)}/*!@.container-warning*/.container-warning.sc-ic-alert{background-color:var(--ic-status-warning-light)}/*!@.container-error*/.container-error.sc-ic-alert{background-color:var(--ic-status-error-light)}/*!@.container-success*/.container-success.sc-ic-alert{background-color:var(--ic-status-success-light)}/*!@.alert-icon-container*/.alert-icon-container.sc-ic-alert{height:100%;display:flex;align-items:center}/*!@.divider*/.divider.sc-ic-alert{height:100%;width:var(--ic-space-xs);border-radius:var(--ic-space-xxxs) 0 0 var(--ic-space-xxxs);position:absolute}/*!@.divider-neutral*/.divider-neutral.sc-ic-alert{background-color:var(--ic-status-unknown)}/*!@.divider-info*/.divider-info.sc-ic-alert{background-color:var(--ic-status-info)}/*!@.divider-warning*/.divider-warning.sc-ic-alert{background-color:var(--ic-status-warning)}/*!@.divider-error*/.divider-error.sc-ic-alert{background-color:var(--ic-status-error)}/*!@.divider-success*/.divider-success.sc-ic-alert{background-color:var(--ic-status-success)}/*!@.alert-icon*/.alert-icon.sc-ic-alert{height:var(--ic-space-lg);width:1.375rem;margin-left:1.125rem}/*!@.icon-placeholder*/.icon-placeholder.sc-ic-alert{margin-left:var(--ic-space-xs)}/*!@.alert-icon > svg*/.alert-icon.sc-ic-alert>svg.sc-ic-alert{height:var(--ic-space-lg);width:var(--ic-space-lg);display:inline-block}/*!@:host([showdefaulticon=\"false\"]) .icon-neutral*/[showdefaulticon=\"false\"].sc-ic-alert-h .icon-neutral.sc-ic-alert{display:none}/*!@.icon-neutral > svg,\n::slotted(svg)*/.icon-neutral.sc-ic-alert>svg.sc-ic-alert,.sc-ic-alert-s>svg{height:var(--ic-space-lg);width:var(--ic-space-lg);display:inline-block;fill:var(--ic-status-unknown)}/*!@:host([variant=\"info\"]) .alert-icon svg*/[variant=\"info\"].sc-ic-alert-h .alert-icon.sc-ic-alert svg.sc-ic-alert{fill:var(--ic-status-info)}/*!@:host([variant=\"warning\"]) .alert-icon svg*/[variant=\"warning\"].sc-ic-alert-h .alert-icon.sc-ic-alert svg.sc-ic-alert{fill:var(--ic-status-warning)}/*!@:host([variant=\"error\"]) .alert-icon svg*/[variant=\"error\"].sc-ic-alert-h .alert-icon.sc-ic-alert svg.sc-ic-alert{fill:var(--ic-status-error)}/*!@:host([variant=\"success\"]) .alert-icon svg*/[variant=\"success\"].sc-ic-alert-h .alert-icon.sc-ic-alert svg.sc-ic-alert{fill:var(--ic-status-success)}/*!@.alert-content*/.alert-content.sc-ic-alert{display:flex;align-items:center;margin-left:0.625rem;width:100%}/*!@.alert-message*/.alert-message.sc-ic-alert{display:flex;align-items:center;padding:var(--ic-space-xs) var(--ic-space-xs) var(--ic-space-xs) 0;flex:1}/*!@.alert-message-title-above*/.alert-message-title-above.sc-ic-alert{display:inline}/*!@.alert-title*/.alert-title.sc-ic-alert{margin-right:var(--ic-space-xs)}/*!@.alert-title-above*/.alert-title-above.sc-ic-alert{white-space:normal}/*!@.alert-action-container*/.alert-action-container.sc-ic-alert{margin-right:var(--ic-space-xs);display:flex;align-items:center}/*!@.dismiss-icon*/.dismiss-icon.sc-ic-alert{margin-right:var(--ic-space-xxxs);margin-left:-0.375rem;padding:0.375rem;border:none;border-radius:50%;background-color:inherit;display:flex;align-items:center;justify-content:center}/*!@.dismiss-icon:hover*/.dismiss-icon.sc-ic-alert:hover{cursor:pointer}@media (max-width: 628px){/*!@.alert-content*/.alert-content.sc-ic-alert{display:flex;flex-direction:column;align-items:flex-start}/*!@.alert-message*/.alert-message.sc-ic-alert{display:flex;flex-direction:column;align-items:flex-start}/*!@.alert-title*/.alert-title.sc-ic-alert{white-space:normal}/*!@.alert-action-container*/.alert-action-container.sc-ic-alert{margin-bottom:var(--ic-space-xs)}}@media (forced-colors: active){/*!@.container*/.container.sc-ic-alert{border:var(--ic-hc-border)}}";

/**
 * @slot message - Content is placed to the right of the title.
 * @slot action - Content is placed to the right of the message.
 * @slot neutral-icon - A custom neutral icon is placed to the left of the title. This will override the default icon if used.
 */
class Alert {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.dismiss = createEvent(this, "dismiss", 7);
        this.icDismiss = createEvent(this, "icDismiss", 7);
        this.hostMutationObserver = null;
        this.dismissAction = () => {
            this.dismiss.emit();
            this.icDismiss.emit();
        };
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, "action")
                : false)) ;
        };
        this.alertTitleWrap = false;
        this.visible = true;
        this.announced = true;
        this.dismissible = false;
        this.heading = "";
        this.message = undefined;
        this.titleAbove = false;
        this.variant = "neutral";
        this.showDefaultIcon = true;
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentDidLoad() {
        this.alertTitleShouldWrap();
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            childList: true,
        });
    }
    handleClick() {
        this.visible = !this.visible;
    }
    alertTitleShouldWrap() {
        var _a;
        const titleHeight = (_a = this.el.shadowRoot.querySelector(".alert-title")) === null || _a === void 0 ? void 0 : _a.clientHeight;
        if (titleHeight > 24)
            this.alertTitleWrap = true;
    }
    render() {
        const { variant, heading, message, titleAbove, dismissible, announced, visible, showDefaultIcon, } = this;
        return (visible && (hAsync(Host, { role: announced ? "alert" : null, class: {
                [IcThemeForegroundEnum.Dark]: true,
            } }, hAsync("div", { class: {
                ["container"]: true,
                [`container-${variant}`]: true,
            } }, hAsync("div", { class: "alert-icon-container" }, hAsync("div", { class: {
                ["divider"]: true,
                [`divider-${variant}`]: true,
            } }), variant === "neutral" ? (isSlotUsed(this.el, "neutral-icon") ? (hAsync("div", { class: "alert-icon svg-container icon-neutral" }, hAsync("slot", { name: "neutral-icon" }))) : showDefaultIcon ? (hAsync("span", { class: {
                ["alert-icon"]: true,
                ["svg-container"]: true,
                [`icon-${variant}`]: true,
            }, innerHTML: VARIANT_ICONS[variant].icon })) : (hAsync("div", { class: "icon-placeholder" }))) : (hAsync("span", { class: {
                ["alert-icon"]: true,
                ["svg-container"]: true,
                [`icon-${variant}`]: true,
            }, innerHTML: VARIANT_ICONS[variant].icon }))), hAsync("div", { class: "alert-content" }, hAsync("div", { class: {
                ["alert-message"]: true,
                ["alert-message-title-above"]: titleAbove || this.alertTitleWrap,
            } }, heading && (hAsync("ic-typography", { class: {
                ["alert-title"]: true,
                ["alert-title-above"]: titleAbove || this.alertTitleWrap,
            }, variant: "subtitle-large" }, hAsync("p", null, heading))), hAsync("slot", { name: "message" }, hAsync("ic-typography", { variant: "body" }, message))), isSlotUsed(this.el, "action") && (hAsync("div", { class: "alert-action-container" }, hAsync("slot", { name: "action" })))), hAsync("div", { class: "dismiss-icon-container" }, dismissible && (hAsync("ic-button", { class: {
                ["svg-container"]: true,
                ["dismiss-icon"]: true,
            }, innerHTML: closeIcon, onClick: this.dismissAction, variant: "icon", appearance: IcThemeForegroundEnum.Dark, title: "dismiss" })))))));
    }
    get el() { return getElement(this); }
    static get style() { return icAlertCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-alert",
        "$members$": {
            "announced": [4],
            "dismissible": [4],
            "heading": [1],
            "message": [1],
            "titleAbove": [4, "title-above"],
            "variant": [1],
            "showDefaultIcon": [4, "show-default-icon"],
            "alertTitleWrap": [32],
            "visible": [32]
        },
        "$listeners$": [[2, "icDismiss", "handleClick"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

var ArrowUpward = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" aria-hidden="true">
    <path d="M0 8L1.41 9.41L7 3.83V16H9V3.83L14.58 9.42L16 8L8 0L0 8Z"/>
</svg>
`;

const icBackToTopCss = "/*!@html*/html.sc-ic-back-to-top{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-back-to-top{margin:0}/*!@main*/main.sc-ic-back-to-top{display:block}/*!@h1*/h1.sc-ic-back-to-top{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-back-to-top{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-back-to-top{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-back-to-top{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-back-to-top{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-back-to-top,strong.sc-ic-back-to-top{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-back-to-top,kbd.sc-ic-back-to-top,samp.sc-ic-back-to-top{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-back-to-top{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-back-to-top,sup.sc-ic-back-to-top{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-back-to-top{bottom:-0.25em}/*!@sup*/sup.sc-ic-back-to-top{top:-0.5em}/*!@img*/img.sc-ic-back-to-top{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-back-to-top,input.sc-ic-back-to-top,optgroup.sc-ic-back-to-top,select.sc-ic-back-to-top,textarea.sc-ic-back-to-top{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-back-to-top,input.sc-ic-back-to-top{overflow:visible}/*!@button,\nselect*/button.sc-ic-back-to-top,select.sc-ic-back-to-top{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-back-to-top,[type=\"button\"].sc-ic-back-to-top,[type=\"reset\"].sc-ic-back-to-top,[type=\"submit\"].sc-ic-back-to-top{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-back-to-top::-moz-focus-inner,[type=\"button\"].sc-ic-back-to-top::-moz-focus-inner,[type=\"reset\"].sc-ic-back-to-top::-moz-focus-inner,[type=\"submit\"].sc-ic-back-to-top::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-back-to-top:-moz-focusring,[type=\"button\"].sc-ic-back-to-top:-moz-focusring,[type=\"reset\"].sc-ic-back-to-top:-moz-focusring,[type=\"submit\"].sc-ic-back-to-top:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-back-to-top{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-back-to-top{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-back-to-top{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-back-to-top{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-back-to-top,[type=\"radio\"].sc-ic-back-to-top{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-back-to-top::-webkit-inner-spin-button,[type=\"number\"].sc-ic-back-to-top::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-back-to-top{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-back-to-top::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-back-to-top::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-back-to-top{display:block}/*!@summary*/summary.sc-ic-back-to-top{display:list-item}/*!@template*/template.sc-ic-back-to-top{display:none}/*!@[hidden]*/[hidden].sc-ic-back-to-top{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-back-to-top,body.sc-ic-back-to-top,div.sc-ic-back-to-top,span.sc-ic-back-to-top,applet.sc-ic-back-to-top,object.sc-ic-back-to-top,iframe.sc-ic-back-to-top,h1.sc-ic-back-to-top,h2.sc-ic-back-to-top,h3.sc-ic-back-to-top,h4.sc-ic-back-to-top,h5.sc-ic-back-to-top,h6.sc-ic-back-to-top,p.sc-ic-back-to-top,blockquote.sc-ic-back-to-top,pre.sc-ic-back-to-top,a.sc-ic-back-to-top,abbr.sc-ic-back-to-top,acronym.sc-ic-back-to-top,address.sc-ic-back-to-top,big.sc-ic-back-to-top,cite.sc-ic-back-to-top,code.sc-ic-back-to-top,del.sc-ic-back-to-top,dfn.sc-ic-back-to-top,em.sc-ic-back-to-top,img.sc-ic-back-to-top,ins.sc-ic-back-to-top,kbd.sc-ic-back-to-top,q.sc-ic-back-to-top,s.sc-ic-back-to-top,samp.sc-ic-back-to-top,small.sc-ic-back-to-top,strike.sc-ic-back-to-top,strong.sc-ic-back-to-top,sub.sc-ic-back-to-top,sup.sc-ic-back-to-top,tt.sc-ic-back-to-top,var.sc-ic-back-to-top,b.sc-ic-back-to-top,u.sc-ic-back-to-top,i.sc-ic-back-to-top,center.sc-ic-back-to-top,dl.sc-ic-back-to-top,dt.sc-ic-back-to-top,dd.sc-ic-back-to-top,ol.sc-ic-back-to-top,ul.sc-ic-back-to-top,li.sc-ic-back-to-top,fieldset.sc-ic-back-to-top,form.sc-ic-back-to-top,label.sc-ic-back-to-top,legend.sc-ic-back-to-top,table.sc-ic-back-to-top,caption.sc-ic-back-to-top,tbody.sc-ic-back-to-top,tfoot.sc-ic-back-to-top,thead.sc-ic-back-to-top,tr.sc-ic-back-to-top,th.sc-ic-back-to-top,td.sc-ic-back-to-top,article.sc-ic-back-to-top,aside.sc-ic-back-to-top,canvas.sc-ic-back-to-top,details.sc-ic-back-to-top,embed.sc-ic-back-to-top,figure.sc-ic-back-to-top,figcaption.sc-ic-back-to-top,footer.sc-ic-back-to-top,header.sc-ic-back-to-top,hgroup.sc-ic-back-to-top,menu.sc-ic-back-to-top,nav.sc-ic-back-to-top,output.sc-ic-back-to-top,ruby.sc-ic-back-to-top,section.sc-ic-back-to-top,summary.sc-ic-back-to-top,time.sc-ic-back-to-top,mark.sc-ic-back-to-top,audio.sc-ic-back-to-top,video.sc-ic-back-to-top{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-back-to-top-h{display:block;position:absolute;right:0}/*!@.positioning*/.positioning.sc-ic-back-to-top{position:fixed;right:var(--ic-space-md);bottom:var(--ic-space-md);transition:visibility 0s linear var(--ic-transition-duration-slow),\n    opacity var(--ic-transition-duration-slow);z-index:var(--ic-z-index-back-to-top)}/*!@.icon-only*/.icon-only.sc-ic-back-to-top{width:2.5rem;padding:var(--ic-space-xs) var(--ic-space-xs) var(--ic-space-xs)\n    var(--ic-space-xs)}/*!@.icon-only .ic-back-to-top-icon*/.icon-only.sc-ic-back-to-top .ic-back-to-top-icon.sc-ic-back-to-top{padding-left:calc(var(--ic-space-xxxs) + var(--ic-space-1px))}/*!@button*/button.sc-ic-back-to-top{height:2.5rem;align-items:center;padding:var(--ic-space-xs) var(--ic-space-md) var(--ic-space-xs)\n    var(--ic-space-sm);margin:0;gap:var(--ic-space-xs);display:flex;background-color:var(--ic-architectural-white);border:var(--ic-border-width) solid var(--ic-action-default);outline-width:inherit;box-sizing:border-box;box-shadow:var(--ic-elevation-overlay);border-radius:5rem;text-decoration:none;visibility:hidden;opacity:0;cursor:pointer}/*!@button:hover*/button.sc-ic-back-to-top:hover{text-decoration:none;background-color:var(--ic-action-default-bg-hover-no-alpha);border:var(--ic-border-width) solid var(--ic-action-default-hover)}/*!@button:active*/button.sc-ic-back-to-top:active{text-decoration:none;background-color:var(--ic-action-default-bg-active-no-alpha);border:var(--ic-border-width) solid var(--ic-action-default-active)}/*!@button:focus*/button.sc-ic-back-to-top:focus{box-shadow:var(--ic-border-focus)}/*!@.ic-back-to-top-link.show*/.ic-back-to-top-link.show.sc-ic-back-to-top{visibility:visible;opacity:1;transition:visibility 0s linear 0s,\n    opacity var(--ic-transition-duration-slow),\n    box-shadow var(--ic-easing-transition-fast)}/*!@.ic-back-to-top-link.by-footer*/.ic-back-to-top-link.by-footer.sc-ic-back-to-top{position:relative;right:var(--ic-space-md);bottom:3.5rem}/*!@.ic-back-to-top-link.offset-banner*/.ic-back-to-top-link.offset-banner.sc-ic-back-to-top{margin-bottom:var(--ic-space-lg)}/*!@.ic-back-to-top-icon*/.ic-back-to-top-icon.sc-ic-back-to-top{fill:var(--ic-action-default);padding-left:var(--ic-space-xxs);padding-top:var(--ic-space-xxxs)}/*!@.ic-back-to-top-icon > svg*/.ic-back-to-top-icon.sc-ic-back-to-top>svg.sc-ic-back-to-top{height:var(--ic-space-md);width:var(--ic-space-md);display:inline-block}/*!@.ic-back-to-top-link span*/.ic-back-to-top-link.sc-ic-back-to-top span.sc-ic-back-to-top{color:var(--ic-action-default)}/*!@.ic-back-to-top-link:hover .ic-back-to-top-icon*/.ic-back-to-top-link.sc-ic-back-to-top:hover .ic-back-to-top-icon.sc-ic-back-to-top{fill:var(--ic-action-default-hover)}/*!@.ic-back-to-top-link:hover span*/.ic-back-to-top-link.sc-ic-back-to-top:hover span.sc-ic-back-to-top{color:var(--ic-action-default-hover)}@media (forced-colors: active){/*!@.ic-back-to-top-icon*/.ic-back-to-top-icon.sc-ic-back-to-top{fill:currentcolor}}";

const backToTopLabel = "Back to top";
class BackToTop {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.topObserver = null;
        this.getObservedEl = () => {
            return document.querySelector("#ic-back-to-top-target");
        };
        this.setTargetElVisible = (visible) => {
            this.targetElVisible = visible;
        };
        this.setFooterVisible = (visible) => {
            this.checkForClassificationBanner();
            this.footerVisible =
                typeof window !== "undefined" && window.scrollY === 0 ? false : visible;
        };
        this.targetElObserverCallback = (entries) => {
            this.setTargetElVisible(entries[0].isIntersecting);
        };
        this.footerObserverCallback = (entries) => {
            this.setFooterVisible(entries[0].isIntersecting);
        };
        this.findTargetEl = (target) => {
            let targetElement = null;
            if (target === null || target === undefined) {
                console.log("Error: No target ID specified for back to top component - defaulting to top of page");
            }
            else {
                targetElement = document.querySelector(`${target.startsWith("#") ? "" : "#"}${target}`);
                if (targetElement === null) {
                    console.log(`Error: Back to top target element '${target}' not found - defaulting to top of page`);
                }
            }
            return targetElement;
        };
        this.createTopObserver = (target) => {
            this.targetEl = this.findTargetEl(target);
            let objParent;
            //remove old element & observer
            if (this.topObserver !== null) {
                const observedEl = this.getObservedEl();
                if (observedEl !== null) {
                    this.topObserver.unobserve(observedEl);
                    observedEl.remove();
                }
            }
            if (this.targetEl === null) {
                objParent = document.body;
                this.targetEl = objParent.firstElementChild;
                this.isTargetElNull = true;
            }
            else {
                objParent = this.targetEl.parentNode;
                this.isTargetElNull = false;
            }
            //insert a new 0px height element before specified target that can be used to determine when page is scrolled
            const objBackToTopTargetEl = document.createElement("div");
            objBackToTopTargetEl.setAttribute("id", "ic-back-to-top-target");
            objBackToTopTargetEl.setAttribute("tabindex", "-1"); // Needed for virtual cursor behaviour to work
            objParent.insertBefore(objBackToTopTargetEl, this.targetEl);
            // resize observer needs to factor in any top margin on the target el
            const marginTop = getComputedStyle(this.targetEl).marginTop;
            this.topObserver = new IntersectionObserver(this.targetElObserverCallback, {
                threshold: [0],
                rootMargin: `${marginTop} 0px 0px 0px`,
            });
            this.topObserver.observe(objBackToTopTargetEl);
        };
        this.handleClick = () => {
            if (this.isTargetElNull) {
                window.scrollTo(0, 0);
            }
            else {
                this.targetEl.scrollIntoView();
            }
            // Get virtual cursor to move
            this.getObservedEl().focus();
        };
        this.checkForClassificationBanner = () => {
            //adjust position for classification banner at bottom
            const banners = document.querySelectorAll("ic-classification-banner:not([inline='true'])");
            this.bannerOffset = banners.length > 0;
        };
        this.buildButton = () => {
            const { bannerOffset, targetElVisible, footerVisible, variant } = this;
            return (hAsync("button", { class: {
                    ["ic-back-to-top-link"]: true,
                    ["offset-banner"]: bannerOffset,
                    ["show"]: !targetElVisible,
                    ["by-footer"]: footerVisible,
                    ["positioning"]: variant !== "icon",
                    ["icon-only"]: variant === "icon",
                }, "aria-label": backToTopLabel, onClick: this.handleClick }, hAsync("span", { class: "ic-back-to-top-icon", innerHTML: ArrowUpward }), this.variant !== "icon" && (hAsync("ic-typography", { variant: "subtitle-small" }, hAsync("span", null, backToTopLabel)))));
        };
        this.bannerOffset = false;
        this.footerVisible = false;
        this.targetElVisible = true;
        this.target = undefined;
        this.variant = "default";
    }
    watchPropHandler(newValue, oldValue) {
        //added for gatsby rehydration issue where prop is initially undefined but then changes to actual value
        onComponentPropUndefinedChange(oldValue, newValue, () => {
            this.createTopObserver(newValue);
        });
    }
    componentWillLoad() {
        this.createTopObserver(this.target);
        this.checkForClassificationBanner();
        //observer for when footer scrolls into view
        let footers = document.querySelectorAll("ic-footer");
        if (footers.length === 0) {
            footers = document.querySelectorAll("footer");
        }
        if (footers.length) {
            const footerEl = footers[footers.length - 1];
            const threshold = this.bannerOffset ? 0.15 : 0;
            const footerObserver = new IntersectionObserver(this.footerObserverCallback, { threshold: [threshold] });
            footerObserver.observe(footerEl);
        }
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.target, propName: "target" }], "Back to Top");
    }
    render() {
        const { variant, buildButton } = this;
        return variant === "icon" ? (hAsync("ic-tooltip", { label: backToTopLabel, placement: "top", class: "positioning" }, buildButton())) : (buildButton());
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get watchers() { return {
        "target": ["watchPropHandler"]
    }; }
    static get style() { return icBackToTopCss; }
    static get cmpMeta() { return {
        "$flags$": 25,
        "$tagName$": "ic-back-to-top",
        "$members$": {
            "target": [1],
            "variant": [1],
            "bannerOffset": [32],
            "footerVisible": [32],
            "targetElVisible": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icBadgeCss = "@media (prefers-reduced-motion: no-preference){/*!@:host(.show)*/.show.sc-ic-badge-h{animation:expand var(--ic-transition-duration-slow)}/*!@:host(.hide)*/.hide.sc-ic-badge-h{animation:shrink var(--ic-transition-duration-slow)}}/*!@:host*/.sc-ic-badge-h{display:flex;height:var(--ic-space-md);min-width:var(--ic-space-md);width:-moz-fit-content;width:fit-content;border-radius:calc(2 * var(--ic-space-xxl));position:absolute}/*!@:host(.neutral)*/.neutral.sc-ic-badge-h{background-color:var(--ic-architectural-500)}/*!@:host(.light)*/.light.sc-ic-badge-h{background-color:var(--ic-architectural-40)}/*!@:host(.info)*/.info.sc-ic-badge-h{background-color:var(--ic-status-info)}/*!@:host(.warning)*/.warning.sc-ic-badge-h{background-color:var(--ic-status-warning-mid)}/*!@:host(.error)*/.error.sc-ic-badge-h{background-color:var(--ic-status-error)}/*!@:host(.success)*/.success.sc-ic-badge-h{background-color:var(--ic-status-success)}/*!@:host(.small)*/.small.sc-ic-badge-h{height:var(--ic-space-sm);min-width:var(--ic-space-sm)}/*!@:host(.large)*/.large.sc-ic-badge-h{height:calc(var(--ic-space-md) + var(--ic-space-xxs));min-width:calc(var(--ic-space-md) + var(--ic-space-xxs))}/*!@:host(.dot.default)*/.dot.default.sc-ic-badge-h{height:var(--ic-space-xs);width:var(--ic-space-xs);min-width:var(--ic-space-xs)}/*!@:host(.dot.small)*/.dot.small.sc-ic-badge-h{height:calc(var(--ic-space-xxs) + var(--ic-space-xxxs));width:calc(var(--ic-space-xxs) + var(--ic-space-xxxs));min-width:calc(var(--ic-space-xxs) + var(--ic-space-xxxs))}/*!@:host(.dot.large)*/.dot.large.sc-ic-badge-h{height:var(--ic-space-sm);width:var(--ic-space-sm);min-width:var(--ic-space-sm)}/*!@:host(.foreground-dark) ::slotted(*)*/.sc-ic-badge-h.foreground-dark .sc-ic-badge-s>*{fill:var(--ic-color-primary-text)}/*!@:host(.foreground-light) ::slotted(*)*/.sc-ic-badge-h.foreground-light .sc-ic-badge-s>*{fill:white}/*!@:host(.foreground-dark) ic-typography*/.foreground-dark.sc-ic-badge-h ic-typography.sc-ic-badge{color:var(--ic-color-primary-text)}/*!@:host(.foreground-light) ic-typography*/.foreground-light.sc-ic-badge-h ic-typography.sc-ic-badge{color:white}/*!@:host(.text) ic-typography*/.text.sc-ic-badge-h ic-typography.sc-ic-badge{align-self:center;padding:0 calc((var(--ic-space-xs) + var(--ic-space-1px)) / 2)\n    var(--ic-space-1px)}/*!@:host(.text.small) ic-typography*/.text.small.sc-ic-badge-h ic-typography.sc-ic-badge{padding:0 0.2132rem}/*!@:host(.text.large) ic-typography*/.text.large.sc-ic-badge-h ic-typography.sc-ic-badge{padding:0 calc((var(--ic-space-sm) + var(--ic-space-1px)) / 2)\n    var(--ic-space-1px)}/*!@:host(.icon) ::slotted(svg)*/.sc-ic-badge-h.icon .sc-ic-badge-s>svg{width:var(--ic-space-sm);height:var(--ic-space-sm);padding:var(--ic-space-xxxs)}/*!@:host(.icon.small) ::slotted(svg)*/.sc-ic-badge-h.icon.small .sc-ic-badge-s>svg{width:var(--ic-space-xs);height:var(--ic-space-xs)}/*!@:host(.icon.large) ::slotted(svg)*/.sc-ic-badge-h.icon.large .sc-ic-badge-s>svg{width:calc(var(--ic-space-sm) + var(--ic-space-xxxs));height:calc(var(--ic-space-sm) + var(--ic-space-xxxs));padding:calc(var(--ic-space-xxxs) + var(--ic-space-1px))}/*!@:host(.far)*/.far.sc-ic-badge-h{top:calc(-1 * var(--ic-space-xs));right:calc(-1 * var(--ic-space-xs))}/*!@:host(.far.small),\n:host(.dot.far.large)*/.far.small.sc-ic-badge-h,.dot.far.large.sc-ic-badge-h{top:calc(-1 * var(--ic-space-xxs));right:calc(-1 * var(--ic-space-xxs))}/*!@:host(.dot.far),\n:host(.dot.far.small)*/.dot.far.sc-ic-badge-h,.dot.far.small.sc-ic-badge-h{top:calc(-1 * var(--ic-space-xxxs));right:calc(-1 * var(--ic-space-xxxs))}/*!@:host(.near)*/.near.sc-ic-badge-h{top:calc(-1 * calc(var(--ic-space-xxs) + var(--ic-space-1px)));right:calc(-1 * calc(var(--ic-space-xxs) + var(--ic-space-1px)))}/*!@:host(.dot.near)*/.dot.near.sc-ic-badge-h{top:calc(-1 * var(--ic-space-1px));right:calc(-1 * var(--ic-space-1px))}/*!@:host(.inline)*/.inline.sc-ic-badge-h{position:static}/*!@:host(.hide)*/.hide.sc-ic-badge-h{visibility:hidden !important;transition:visibility var(--ic-transition-duration-slow)}/*!@.sr-only*/.sr-only.sc-ic-badge{position:absolute;left:-9999px}@keyframes expand{from{opacity:0;transform:scale(0)}to{opacity:1;transform:scale(1)}}@keyframes shrink{from{opacity:1;transform:scale(1)}to{opacity:0;transform:scale(0)}}";

/**
 * @slot badge-icon - Icon will be rendered inside the badge if type is set to icon.
 */
class Badge {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.ariaLabel = null;
        this.setBadgeColour = () => {
            const colorRGBA = convertToRGBA(this.customColor);
            if (colorRGBA) {
                this.customColorRGBA = colorRGBA;
                const { r, g, b, a } = colorRGBA;
                this.el.style.backgroundColor = `rgba(${r}, ${g}, ${b}, ${a})`;
            }
        };
        this.getBadgeRGB = () => {
            switch (this.variant) {
                case "custom":
                    return this.customColorRGBA;
                case "error":
                case "success":
                case "warning":
                case "info": {
                    return rgbaStrToObj(getCssProperty(`--ic-status-${this.variant}`));
                }
                case "neutral":
                case "light":
                    return hexToRgba(getCssProperty(`--ic-architectural-${this.variant === "neutral" ? 500 : 40}`));
            }
        };
        this.getBadgeForeground = () => {
            const { r, g, b } = this.getBadgeRGB();
            this.foregroundColour = getThemeForegroundColor((r * 299 + g * 587 + b * 114) / 1000);
        };
        this.getTextLabel = () => this.maxNumber && Number(this.textLabel) > this.maxNumber
            ? `${this.maxNumber}+`
            : this.textLabel;
        // Set aria-label on badge and / or parent element
        // Aria-describedby seems to not work, probably due to shadow DOM
        this.setAccessibleLabel = () => {
            const parentEl = this.el.parentElement;
            const defaultAriaLabel = this.isAccessibleLabelDefined()
                ? this.accessibleLabel
                : this.textLabel || "with badge being displayed";
            if (parentEl) {
                const { tagName } = parentEl;
                if (tagName !== "IC-CARD" &&
                    (tagName !== "IC-TAB" || (tagName === "IC-TAB" && this.parentAriaLabel))) {
                    const ariaLabelPrefix = this.parentAriaLabel
                        ? `${this.parentAriaLabel} ,`
                        : "";
                    parentEl.ariaLabel = this.visible
                        ? `${ariaLabelPrefix} ${defaultAriaLabel}`
                        : undefined;
                }
                else {
                    this.ariaLabel = `, ${defaultAriaLabel}`;
                }
            }
        };
        this.isAccessibleLabelDefined = () => isPropDefined(this.accessibleLabel) && this.accessibleLabel !== null;
        this.accessibleLabel = undefined;
        this.customColor = null;
        this.maxNumber = undefined;
        this.position = "far";
        this.size = "default";
        this.textLabel = undefined;
        this.type = "text";
        this.variant = "neutral";
        this.visible = true;
    }
    accessibleLabelHandler() {
        this.setAccessibleLabel();
    }
    customColorHandler() {
        this.variant === "custom" && this.setBadgeColour();
    }
    variantHandler() {
        this.getBadgeForeground();
    }
    visibleHandler() {
        this.setAccessibleLabel();
    }
    componentWillLoad() {
        var _a;
        this.variant === "custom" && this.setBadgeColour();
        this.getBadgeForeground();
        const ariaLabel = (_a = this.el.parentElement) === null || _a === void 0 ? void 0 : _a.ariaLabel;
        if (ariaLabel)
            this.parentAriaLabel = ariaLabel;
        this.setAccessibleLabel();
    }
    componentDidLoad() {
        this.type === "text" &&
            onComponentRequiredPropUndefined([{ prop: this.textLabel, propName: "text-label" }], "Badge");
    }
    /**
     * @deprecated This method should not be used anymore. Use visible prop to set badge visibility.
     */
    async showBadge() {
        this.visible = true;
    }
    /**
     * @deprecated This method should not be used anymore. Use visible prop to set badge visibility.
     */
    async hideBadge() {
        this.visible = false;
    }
    render() {
        const { ariaLabel, el, foregroundColour, getTextLabel, position, size, textLabel, type, variant, visible, } = this;
        return (hAsync(Host, { class: {
                [`${position}`]: true,
                [`${size}`]: true,
                [`${variant}`]: true,
                [`${type}`]: true,
                [`foreground-${foregroundColour}`]: foregroundColour !== null,
                [`${visible ? "show" : "hide"}`]: true,
            }, id: el.id || null, "aria-label": ariaLabel, role: "status" }, type === "icon" && hAsync("slot", { name: "badge-icon" }), type === "text" && textLabel && (hAsync("ic-typography", { variant: size === "small" ? "badge-small" : "badge" }, getTextLabel())), type === "dot" && hAsync("span", { class: "sr-only" }, "badge")));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get watchers() { return {
        "accessibleLabel": ["accessibleLabelHandler"],
        "customColor": ["customColorHandler"],
        "variant": ["variantHandler"],
        "visible": ["visibleHandler"]
    }; }
    static get style() { return icBadgeCss; }
    static get cmpMeta() { return {
        "$flags$": 25,
        "$tagName$": "ic-badge",
        "$members$": {
            "accessibleLabel": [1, "accessible-label"],
            "customColor": [1, "custom-color"],
            "maxNumber": [2, "max-number"],
            "position": [1],
            "size": [1],
            "textLabel": [1, "text-label"],
            "type": [1],
            "variant": [1],
            "visible": [1028],
            "showBadge": [64],
            "hideBadge": [64]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

var backIcon = `<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20 11H7.83L13.42 5.41L12 4L4 12L12 20L13.41 18.59L7.83 13H20V11Z" fill="currentColor"/>
</svg>
`;

const icBreadcrumbCss = "/*!@:host*/.sc-ic-breadcrumb-h{display:block;margin:var(--ic-space-xs) var(--ic-space-xs) var(--ic-space-xs) 0}/*!@:host .breadcrumb*/.sc-ic-breadcrumb-h .breadcrumb.sc-ic-breadcrumb{display:flex;align-items:center;white-space:nowrap;gap:var(--ic-space-xs);min-height:var(--ic-space-lg)}/*!@:host .chevron*/.sc-ic-breadcrumb-h .chevron.sc-ic-breadcrumb{width:var(--ic-space-lg);height:var(--ic-space-lg)}/*!@:host .chevron svg*/.sc-ic-breadcrumb-h .chevron.sc-ic-breadcrumb svg.sc-ic-breadcrumb{color:var(--ic-architectural-400)}/*!@:host(:first-child) .chevron*/.sc-ic-breadcrumb-h:first-child .chevron.sc-ic-breadcrumb{display:none}/*!@.back-icon svg*/.back-icon.sc-ic-breadcrumb svg.sc-ic-breadcrumb{color:currentcolor}/*!@:host(.back)*/.back.sc-ic-breadcrumb-h{display:flex;align-items:center}/*!@:host(.back) .chevron*/.back.sc-ic-breadcrumb-h .chevron.sc-ic-breadcrumb{display:none}/*!@ic-link*/ic-link.sc-ic-breadcrumb{--breadcrumb-link-display:inline-flex;--breadcrumb-link-align-items:center;--breadcrumb-link-gap:var(--ic-space-xs)}/*!@:host([aria-current=\"page\"]) .current-page-container*/[aria-current=\"page\"].sc-ic-breadcrumb-h .current-page-container.sc-ic-breadcrumb{display:flex;align-items:center;gap:var(--ic-space-xs)}/*!@:host([aria-current=\"page\"]) .current-page-container.dark*/[aria-current=\"page\"].sc-ic-breadcrumb-h .current-page-container.dark.sc-ic-breadcrumb{color:var(--ic-color-primary-text)}/*!@:host([aria-current=\"page\"]) .current-page-container.light*/[aria-current=\"page\"].sc-ic-breadcrumb-h .current-page-container.light.sc-ic-breadcrumb{color:var(--ic-color-white-text)}/*!@:host(.collapsed-breadcrumb-wrapper)*/.collapsed-breadcrumb-wrapper.sc-ic-breadcrumb-h{margin-right:var(--ic-space-xs) !important;display:flex;align-items:center;gap:var(--ic-space-xs)}/*!@:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb)*/.sc-ic-breadcrumb-h.collapsed-breadcrumb-wrapper .sc-ic-breadcrumb-s>.collapsed-breadcrumb{border:none;background-color:transparent;color:var(--ic-hyperlink);text-decoration:underline;font-weight:var(--ic-font-weight-bold);cursor:pointer}/*!@:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:hover),\n:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:focus)*/.sc-ic-breadcrumb-h.collapsed-breadcrumb-wrapper .sc-ic-breadcrumb-s>.collapsed-breadcrumb:hover,.sc-ic-breadcrumb-h.collapsed-breadcrumb-wrapper.sc-ic-breadcrumb-s>.collapsed-breadcrumb:focus,.sc-ic-breadcrumb-h.collapsed-breadcrumb-wrapper .sc-ic-breadcrumb-s>.collapsed-breadcrumb:focus{outline:var(--ic-hc-focus-outline);border-bottom:0.25rem solid !important;margin-bottom:-0.25rem !important;text-decoration:none}/*!@.hide,\n:host(.collapsed-breadcrumb-wrapper) ::slotted(.hide)*/.hide.sc-ic-breadcrumb,.sc-ic-breadcrumb-h.collapsed-breadcrumb-wrapper.sc-ic-breadcrumb-s>.hide,.sc-ic-breadcrumb-h.collapsed-breadcrumb-wrapper .sc-ic-breadcrumb-s>.hide{display:none}@media (forced-colors: active){/*!@.back-icon svg*/.back-icon.sc-ic-breadcrumb svg.sc-ic-breadcrumb{color:currentcolor}}@supports (text-underline-offset: 25%){/*!@ic-link*/ic-link.sc-ic-breadcrumb{--breadcrumb-link-display:flex}/*!@:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:hover),\n  :host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:focus)*/.sc-ic-breadcrumb-h.collapsed-breadcrumb-wrapper .sc-ic-breadcrumb-s>.collapsed-breadcrumb:hover,.sc-ic-breadcrumb-h.collapsed-breadcrumb-wrapper.sc-ic-breadcrumb-s>.collapsed-breadcrumb:focus,.sc-ic-breadcrumb-h.collapsed-breadcrumb-wrapper .sc-ic-breadcrumb-s>.collapsed-breadcrumb:focus{text-decoration-line:underline;text-decoration-thickness:25%;text-underline-offset:25%;border-bottom:0 !important;margin-bottom:0 !important}}";

/**
 * @slot icon - Content will be rendered to the left of the breadcrumb page title.
 */
class Breadcrumb {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.renderDefaultBreadcrumb = (current, pageTitle, describedById, href) => {
            const hasPageTitle = pageTitle !== null && isPropDefined(pageTitle) && pageTitle !== "";
            if (current && hasPageTitle) {
                return (hAsync("span", { class: {
                        "current-page-container": current,
                        [this.appearance]: true,
                    } }, isSlotUsed(this.el, "icon") && hAsync("slot", { name: "icon" }), pageTitle));
            }
            return (hAsync("ic-link", { appearance: this.appearance, href: href, class: "breadcrumb-link", "aria-describedby": this.showBackIcon && describedById && describedById }, this.showBackIcon && (hAsync("div", { class: "back-icon", innerHTML: backIcon })), isSlotUsed(this.el, "icon") && hAsync("slot", { name: "icon" }), pageTitle));
        };
        this.setSlottedCurrentPageClass = () => {
            const icLink = this.el.querySelector("ic-link");
            const currentPage = "current-page";
            if (icLink) {
                icLink.classList.remove(currentPage);
                if (this.current) {
                    const hasCurrentPageClass = icLink.classList.contains(currentPage);
                    if (!hasCurrentPageClass) {
                        icLink.classList.add("breadcrumb-link", currentPage);
                    }
                }
            }
        };
        this.appearance = "default";
        this.current = false;
        this.href = undefined;
        this.pageTitle = undefined;
        this.showBackIcon = false;
    }
    componentWillRender() {
        this.setSlottedCurrentPageClass();
    }
    /**
     * Sets focus on the breadcrumb.
     */
    async setFocus() {
        if (this.el.shadowRoot.querySelector("ic-link")) {
            this.el.shadowRoot.querySelector("ic-link").focus();
        }
    }
    render() {
        const { current, href, pageTitle } = this;
        const describedById = `${pageTitle && pageTitle.toLowerCase().replace(" ", "-")}-describedby`;
        const hasPageTitle = pageTitle !== null && isPropDefined(pageTitle) && pageTitle !== "";
        const hasHref = href !== null && isPropDefined(href) && href !== "";
        return (hAsync(Host, { class: {
                back: this.showBackIcon,
            }, "aria-current": current && "page", role: "listitem" }, hAsync("div", { class: "breadcrumb" }, hAsync("span", { innerHTML: chevronIcon, class: "chevron", "aria-hidden": "true" }), this.showBackIcon && describedById && (hAsync("span", { id: describedById, class: "hide" }, `Back to ${pageTitle}`)), hasPageTitle && hasHref ? (this.renderDefaultBreadcrumb(current, pageTitle, describedById, href)) : (hAsync("slot", null)))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get style() { return icBreadcrumbCss; }
    static get cmpMeta() { return {
        "$flags$": 25,
        "$tagName$": "ic-breadcrumb",
        "$members$": {
            "appearance": [1],
            "current": [4],
            "href": [1],
            "pageTitle": [1, "page-title"],
            "showBackIcon": [516, "show-back-icon"],
            "setFocus": [64]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": [["showBackIcon", "show-back-icon"]]
    }; }
}

const icBreadcrumbGroupCss = "/*!@:host*/.sc-ic-breadcrumb-group-h{display:block}/*!@:host ol*/.sc-ic-breadcrumb-group-h ol.sc-ic-breadcrumb-group{display:flex;list-style-type:none;align-items:center;flex-wrap:wrap;padding:0;margin:0}/*!@:host(.back) ol ::slotted(ic-breadcrumb)*/.sc-ic-breadcrumb-group-h.back ol .sc-ic-breadcrumb-group-s>ic-breadcrumb{display:none}/*!@:host(.back) ol ::slotted(ic-breadcrumb.show)*/.sc-ic-breadcrumb-group-h.back ol .sc-ic-breadcrumb-group-s>ic-breadcrumb.show{display:flex}/*!@:host(.collapsed) ol ::slotted(ic-breadcrumb.hide)*/.sc-ic-breadcrumb-group-h.collapsed ol .sc-ic-breadcrumb-group-s>ic-breadcrumb.hide{display:none;opacity:0;visibility:hidden}/*!@:host(.collapsed) ol ::slotted(ic-breadcrumb.visuallyhidden)*/.sc-ic-breadcrumb-group-h.collapsed ol .sc-ic-breadcrumb-group-s>ic-breadcrumb.visuallyhidden{display:block;opacity:0;transition:all var(--ic-easing-transition-slow)}/*!@:host(.collapsed) ol ::slotted(ic-breadcrumb.fade)*/.sc-ic-breadcrumb-group-h.collapsed ol .sc-ic-breadcrumb-group-s>ic-breadcrumb.fade{opacity:1}";

// Added ResizeObserver to find out width of breadcrumbs and parents. Use side navigation long title for ref.
class BreadcrumbGroup {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.ADD_CLASS_DELAY = 50;
        this.IC_BREADCRUMB = "ic-breadcrumb";
        this.resizeObserver = null;
        this.SHOW_BACK_ICON = "show-back-icon";
        this.setAppearance = () => {
            const allBreadcrumbs = Array.from(this.el.querySelectorAll(this.IC_BREADCRUMB));
            allBreadcrumbs.forEach((breadcrumb) => {
                breadcrumb.setAttribute("appearance", this.appearance);
            });
        };
        this.setBackBreadcrumb = () => {
            if (this.backBreadcrumbOnly) {
                this.setBackBreadcrumbAttr();
            }
        };
        this.setBackBreadcrumbAttr = () => {
            if (this.lastParentBreadcrumb) {
                this.lastParentBreadcrumb.classList.add("show");
                this.lastParentBreadcrumb.setAttribute(this.SHOW_BACK_ICON, "true");
            }
        };
        this.getLastParentBreadcrumb = () => {
            const allBreadcrumbs = Array.from(this.el.querySelectorAll(this.IC_BREADCRUMB));
            if (allBreadcrumbs.length === 1) {
                return null;
            }
            this.breadcrumbs = allBreadcrumbs.filter((breadcrumb) => !breadcrumb.getAttribute("current"));
            this.breadcrumb = this.breadcrumbs[this.breadcrumbs.length - 1];
            return this.breadcrumb;
        };
        this.lastParentBreadcrumb = this.getLastParentBreadcrumb();
        this.setDefaultBreadcrumbs = () => {
            const allBreadcrumbs = Array.from(this.el.querySelectorAll(this.IC_BREADCRUMB));
            allBreadcrumbs.forEach((breadcrumb) => {
                breadcrumb.setAttribute(this.SHOW_BACK_ICON, "false");
            });
        };
        this.setCollapsed = () => {
            if (this.collapsed) {
                const allBreadcrumbs = Array.from(this.el.querySelectorAll(this.IC_BREADCRUMB));
                this.collapsedBreadcrumbs = allBreadcrumbs
                    .splice(1, allBreadcrumbs.length - 2)
                    .filter((breadcrumb) => !breadcrumb.classList.contains("collapsed-breadcrumb-wrapper"));
                this.collapsedBreadcrumbs.forEach((breadcrumb) => breadcrumb.classList.add("hide"));
                const firstBreadcrumb = allBreadcrumbs[0];
                if (firstBreadcrumb) {
                    firstBreadcrumb.insertAdjacentElement("afterend", this.collapsedBreadcrumbWrapper);
                }
            }
        };
        this.clickHandler = () => {
            this.handleHiddenCollapsedBreadcrumbs(this.collapsedBreadcrumbWrapper);
        };
        this.renderCollapsedBreadcrumb = () => {
            this.collapsedBreadcrumbWrapper = document.createElement("ic-breadcrumb");
            this.collapsedBreadcrumbWrapper.classList.add("collapsed-breadcrumb-wrapper");
            this.collapsedBreadcrumbEl = document.createElement("button");
            const ariaLabel = document.createElement("span");
            ariaLabel.id = "collapsed-button-label";
            ariaLabel.innerText = "Collapsed breadcrumbs";
            ariaLabel.className = "hide";
            this.collapsedBreadcrumbEl.setAttribute("aria-labelledby", "collapsed-button-label");
            const ariaDescribed = document.createElement("span");
            ariaDescribed.id = "collapsed-button-described";
            ariaDescribed.innerText = "Select to view collapsed breadcrumbs";
            ariaDescribed.className = "hide";
            this.collapsedBreadcrumbEl.setAttribute("aria-describedby", "collapsed-button-described");
            this.collapsedBreadcrumbEl.id = "collapsed-ellipsis";
            this.collapsedBreadcrumbEl.innerText = "...";
            this.collapsedBreadcrumbEl.classList.add("collapsed-breadcrumb");
            this.collapsedBreadcrumbEl.addEventListener("click", this.clickHandler);
            this.collapsedBreadcrumbWrapper.append(ariaDescribed);
            this.collapsedBreadcrumbWrapper.append(ariaLabel);
            this.collapsedBreadcrumbWrapper.append(this.collapsedBreadcrumbEl);
            return this.collapsedBreadcrumbWrapper;
        };
        this.handleHiddenCollapsedBreadcrumbs = (collapsedBreadcrumbWrapper) => {
            collapsedBreadcrumbWrapper.remove();
            this.collapsedBreadcrumbs.forEach((breadcrumb) => {
                breadcrumb.classList.add("visuallyhidden");
                breadcrumb.classList.remove("hide");
                setTimeout(() => {
                    breadcrumb.classList.add("fade");
                }, this.ADD_CLASS_DELAY);
                this.removeVisuallyHiddenClass(breadcrumb);
            });
            this.expandedBreadcrumbs = true;
            // Set focus to first unhidden breadcrumb
            this.collapsedBreadcrumbs[0].setFocus();
        };
        this.transitionendHandler = (event) => {
            if (event.propertyName === "opacity") {
                event.target.classList.remove("visuallyhidden");
            }
        };
        this.removeVisuallyHiddenClass = (breadcrumb) => {
            breadcrumb.addEventListener("transitionend", this.transitionendHandler);
        };
        this.setLastParentCollapsedBackBreadcrumb = () => {
            this.setBackBreadcrumbAttr();
            this.lastParentBreadcrumb.classList.remove("hide");
        };
        this.revertLastParentCollapsedBreadcrumb = () => {
            this.lastParentBreadcrumb.setAttribute(this.SHOW_BACK_ICON, "false");
        };
        this.resizeObserverCallback = (currSize) => {
            if (currSize !== this.deviceSize) {
                this.deviceSize = currSize;
                if (this.deviceSize <= DEVICE_SIZES.S) {
                    this.el.setAttribute("back-breadcrumb-only", "true");
                    if (this.collapsed) {
                        this.setLastParentCollapsedBackBreadcrumb();
                    }
                    else {
                        this.setBackBreadcrumb();
                    }
                }
                else {
                    this.el.setAttribute("back-breadcrumb-only", "false");
                    if (this.collapsed && this.breadcrumbs && this.breadcrumbs.length > 2) {
                        this.revertLastParentCollapsedBreadcrumb();
                        if (this.expandedBreadcrumbs) {
                            this.setDefaultBreadcrumbs();
                        }
                        else {
                            this.setCollapsed();
                        }
                    }
                    else {
                        this.setDefaultBreadcrumbs();
                    }
                }
            }
        };
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                const currSize = getCurrentDeviceSize();
                this.resizeObserverCallback(currSize);
            });
            this.resizeObserver.observe(this.el);
        };
        this.deviceSize = DEVICE_SIZES.XL;
        this.expandedBreadcrumbs = false;
        this.appearance = "default";
        this.backBreadcrumbOnly = false;
        this.collapsed = false;
    }
    watchAppearanceHandler() {
        this.setAppearance();
    }
    watchBackBreadcrumbHandler() {
        this.setBackBreadcrumb();
    }
    componentWillLoad() {
        const allBreadcrumbs = Array.from(this.el.querySelectorAll(this.IC_BREADCRUMB));
        this.setAppearance();
        if (this.backBreadcrumbOnly) {
            this.setBackBreadcrumb();
        }
        else {
            checkResizeObserver(this.runResizeObserver);
        }
        if (this.collapsed) {
            this.collapsedBreadcrumbWrapper = this.renderCollapsedBreadcrumb();
            if (allBreadcrumbs.length > 2) {
                if (getCurrentDeviceSize() === DEVICE_SIZES.S) {
                    this.setLastParentCollapsedBackBreadcrumb();
                }
                else {
                    this.setCollapsed();
                }
            }
        }
    }
    disconnectedCallback() {
        this.breadcrumb &&
            this.breadcrumb.removeEventListener("transitionend", this.transitionendHandler);
        this.collapsedBreadcrumbEl &&
            this.collapsedBreadcrumbEl.removeEventListener("click", this.clickHandler);
    }
    render() {
        return (hAsync(Host, { class: {
                back: this.backBreadcrumbOnly,
                collapsed: this.collapsed,
            } }, hAsync("nav", { "aria-label": "breadcrumbs" }, hAsync("ol", null, hAsync("slot", null)))));
    }
    get el() { return getElement(this); }
    static get watchers() { return {
        "appearance": ["watchAppearanceHandler"],
        "backBreadcrumbOnly": ["watchBackBreadcrumbHandler"]
    }; }
    static get style() { return icBreadcrumbGroupCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-breadcrumb-group",
        "$members$": {
            "appearance": [1],
            "backBreadcrumbOnly": [4, "back-breadcrumb-only"],
            "collapsed": [4],
            "deviceSize": [32],
            "expandedBreadcrumbs": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

var arrowDropdown = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M7 9.5L12 14.5L17 9.5H7Z" fill="currentColor"/>
</svg>`;

const icButtonCss = "/*!@html*/html.sc-ic-button{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-button{margin:0}/*!@main*/main.sc-ic-button{display:block}/*!@h1*/h1.sc-ic-button{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-button{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-button{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-button{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-button{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-button,strong.sc-ic-button{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-button,kbd.sc-ic-button,samp.sc-ic-button{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-button{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-button,sup.sc-ic-button{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-button{bottom:-0.25em}/*!@sup*/sup.sc-ic-button{top:-0.5em}/*!@img*/img.sc-ic-button{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-button,input.sc-ic-button,optgroup.sc-ic-button,select.sc-ic-button,textarea.sc-ic-button{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-button,input.sc-ic-button{overflow:visible}/*!@button,\nselect*/button.sc-ic-button,select.sc-ic-button{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-button,[type=\"button\"].sc-ic-button,[type=\"reset\"].sc-ic-button,[type=\"submit\"].sc-ic-button{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-button::-moz-focus-inner,[type=\"button\"].sc-ic-button::-moz-focus-inner,[type=\"reset\"].sc-ic-button::-moz-focus-inner,[type=\"submit\"].sc-ic-button::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-button:-moz-focusring,[type=\"button\"].sc-ic-button:-moz-focusring,[type=\"reset\"].sc-ic-button:-moz-focusring,[type=\"submit\"].sc-ic-button:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-button{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-button{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-button{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-button{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-button,[type=\"radio\"].sc-ic-button{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-button::-webkit-inner-spin-button,[type=\"number\"].sc-ic-button::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-button{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-button::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-button::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-button{display:block}/*!@summary*/summary.sc-ic-button{display:list-item}/*!@template*/template.sc-ic-button{display:none}/*!@[hidden]*/[hidden].sc-ic-button{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-button,body.sc-ic-button,div.sc-ic-button,span.sc-ic-button,applet.sc-ic-button,object.sc-ic-button,iframe.sc-ic-button,h1.sc-ic-button,h2.sc-ic-button,h3.sc-ic-button,h4.sc-ic-button,h5.sc-ic-button,h6.sc-ic-button,p.sc-ic-button,blockquote.sc-ic-button,pre.sc-ic-button,a.sc-ic-button,abbr.sc-ic-button,acronym.sc-ic-button,address.sc-ic-button,big.sc-ic-button,cite.sc-ic-button,code.sc-ic-button,del.sc-ic-button,dfn.sc-ic-button,em.sc-ic-button,img.sc-ic-button,ins.sc-ic-button,kbd.sc-ic-button,q.sc-ic-button,s.sc-ic-button,samp.sc-ic-button,small.sc-ic-button,strike.sc-ic-button,strong.sc-ic-button,sub.sc-ic-button,sup.sc-ic-button,tt.sc-ic-button,var.sc-ic-button,b.sc-ic-button,u.sc-ic-button,i.sc-ic-button,center.sc-ic-button,dl.sc-ic-button,dt.sc-ic-button,dd.sc-ic-button,ol.sc-ic-button,ul.sc-ic-button,li.sc-ic-button,fieldset.sc-ic-button,form.sc-ic-button,label.sc-ic-button,legend.sc-ic-button,table.sc-ic-button,caption.sc-ic-button,tbody.sc-ic-button,tfoot.sc-ic-button,thead.sc-ic-button,tr.sc-ic-button,th.sc-ic-button,td.sc-ic-button,article.sc-ic-button,aside.sc-ic-button,canvas.sc-ic-button,details.sc-ic-button,embed.sc-ic-button,figure.sc-ic-button,figcaption.sc-ic-button,footer.sc-ic-button,header.sc-ic-button,hgroup.sc-ic-button,menu.sc-ic-button,nav.sc-ic-button,output.sc-ic-button,ruby.sc-ic-button,section.sc-ic-button,summary.sc-ic-button,time.sc-ic-button,mark.sc-ic-button,audio.sc-ic-button,video.sc-ic-button{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-button-h{display:inline-block;position:relative;--button-default:var(--ic-action-default);--button-default-hover:var(--ic-action-default-hover);--button-default-active:var(--ic-action-default-active);--button-default-background-hover:var(--ic-action-default-bg-hover);--button-default-background-active:var(--ic-action-default-bg-active);--icon-width:100%;--icon-height:100%}/*!@.button,\n::slotted(a)*/.button.sc-ic-button,.sc-ic-button-s>a{font-family:var(--ic-font-body-family);text-decoration:none;font-weight:600;font-size:0.875rem;transition:var(--ic-easing-transition-fast);border-radius:var(--ic-border-radius);min-width:var(--min-width, 6.25rem);display:inline-flex;flex-direction:row;justify-content:center;align-items:center;background:none;border:none;box-sizing:border-box;white-space:nowrap;vertical-align:middle}/*!@:host(.with-badge) .button*/.with-badge.sc-ic-button-h .button.sc-ic-button{border-radius:0.2188rem}/*!@.button:hover,\n::slotted(a:hover)*/.button.sc-ic-button:hover,.sc-ic-button-s>a:hover{cursor:pointer}/*!@.button:focus,\n::slotted(a:focus)*/.button.sc-ic-button:focus,.sc-ic-button-s>a:focus{box-shadow:var(--ic-border-focus)}/*!@.button:focus-visible,\n::slotted(a:focus-visible)*/.button.sc-ic-button:focus-visible,.sc-ic-button-s>a:focus-visible{outline:var(--ic-hc-focus-outline)}/*!@:host(.dark) .button,\n:host(.dark) ::slotted(a)*/.dark.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.dark.sc-ic-button-s>a,.sc-ic-button-h.dark .sc-ic-button-s>a{--button-default:var(--ic-action-dark);--button-default-hover:var(--ic-action-dark);--button-default-active:var(--ic-action-dark);--button-default-background-hover:var(--ic-action-dark-bg-hover);--button-default-background-active:var(--ic-action-dark-bg-active)}/*!@:host(.light) .button,\n:host(.light) ::slotted(a)*/.light.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.light.sc-ic-button-s>a,.sc-ic-button-h.light .sc-ic-button-s>a{--button-default:var(--ic-action-light);--button-default-hover:var(--ic-action-light);--button-default-active:var(--ic-action-light);--button-default-background-hover:var(--ic-action-light-bg-hover);--button-default-background-active:var(--ic-action-light-bg-active)}/*!@:host(.white-background) .button,\n:host(.white-background) ::slotted(a)*/.white-background.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.white-background.sc-ic-button-s>a,.sc-ic-button-h.white-background .sc-ic-button-s>a{--button-default-background-hover:var(--ic-action-default-bg-hover-no-alpha);--button-default-background-active:var(\n    --ic-action-default-bg-active-no-alpha\n  );background-color:var(--ic-architectural-white)}/*!@:host(.white-background.dark) .button,\n:host(.white-background.dark) ::slotted(a)*/.white-background.dark.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.white-background.dark.sc-ic-button-s>a,.sc-ic-button-h.white-background.dark .sc-ic-button-s>a{--button-default-background-hover:var(--ic-action-dark-bg-hover-no-alpha);--button-default-background-active:var(--ic-action-dark-bg-active-no-alpha)}/*!@:host(.button-variant-primary.light) .button,\n:host(.button-variant-primary.light) ::slotted(a)*/.button-variant-primary.light.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-primary.light.sc-ic-button-s>a,.sc-ic-button-h.button-variant-primary.light .sc-ic-button-s>a{color:var(--ic-color-primary-text);--button-default-hover:var(--ic-action-light-hover);--button-default-active:var(--ic-action-light-active)}/*!@:host(.button-variant-primary.dark) .button,\n:host(.button-variant-primary.dark) ::slotted(a)*/.button-variant-primary.dark.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-primary.dark.sc-ic-button-s>a,.sc-ic-button-h.button-variant-primary.dark .sc-ic-button-s>a{--button-default-hover:var(--ic-action-dark-hover);--button-default-active:var(--ic-action-dark-active)}/*!@:host(.disabled),\n:host(.disabled) .button,\n:host(.disabled) ::slotted(a),\n:host(.loading),\n:host(.loading) .button*/.disabled.sc-ic-button-h,.disabled.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.disabled.sc-ic-button-s>a,.sc-ic-button-h.disabled .sc-ic-button-s>a,.loading.sc-ic-button-h,.loading.sc-ic-button-h .button.sc-ic-button{pointer-events:none}/*!@:host(.top-icon) .button*/.top-icon.sc-ic-button-h .button.sc-ic-button{flex-direction:column;--height:fit-content}/*!@:host(.top-icon) .button .icon-container*/.top-icon.sc-ic-button-h .button.sc-ic-button .icon-container.sc-ic-button{margin-right:0}/*!@:host(.button-variant-primary) .button,\n:host(.button-variant-primary) ::slotted(a)*/.button-variant-primary.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-primary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-primary .sc-ic-button-s>a{color:var(--ic-color-white-text);background-color:var(--button-default)}/*!@:host(.button-variant-primary) .button:hover*/.button-variant-primary.sc-ic-button-h .button.sc-ic-button:hover{background-color:var(--button-default-hover)}/*!@:host(.button-variant-primary.loading) .button,\n:host(.button-variant-primary) .button:active*/.button-variant-primary.loading.sc-ic-button-h .button.sc-ic-button,.button-variant-primary.sc-ic-button-h .button.sc-ic-button:active{background-color:var(--button-default-active)}/*!@:host(.button-variant-primary.disabled) .button,\n:host(.button-variant-primary.disabled) ::slotted(a)*/.button-variant-primary.disabled.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-primary.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-primary.disabled .sc-ic-button-s>a{background:var(--ic-architectural-200);color:var(--ic-architectural-300)}/*!@:host(.button-variant-primary.light.disabled) .button,\n:host(.button-variant-primary.light.disabled) ::slotted(a)*/.button-variant-primary.light.disabled.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-primary.light.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-primary.light.disabled .sc-ic-button-s>a{background:var(--ic-architectural-600);color:var(--ic-architectural-500)}/*!@:host(.button-variant-secondary) .button,\n:host(.button-variant-secondary) ::slotted(a)*/.button-variant-secondary.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary .sc-ic-button-s>a{border:var(--ic-border-width) solid var(--button-default);color:var(--button-default)}/*!@:host(.button-variant-secondary) .button:hover,\n:host(.button-variant-secondary) ::slotted(a:hover)*/.button-variant-secondary.sc-ic-button-h .button.sc-ic-button:hover,.sc-ic-button-h.button-variant-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-secondary .sc-ic-button-s>a:hover{background-color:var(--button-default-background-hover);border-color:var(--button-default-hover);color:var(--button-default-hover)}/*!@:host(.button-variant-secondary) .button:active,\n:host(.button-variant-secondary) ::slotted(a:active),\n:host(.button-variant-secondary.loading) .button*/.button-variant-secondary.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-secondary .sc-ic-button-s>a:active,.button-variant-secondary.loading.sc-ic-button-h .button.sc-ic-button{border-color:var(--button-default-active);background-color:var(--button-default-background-active);color:var(--button-default-active)}/*!@:host(.button-variant-secondary.disabled) .button,\n:host(.button-variant-secondary.disabled) ::slotted(a)*/.button-variant-secondary.disabled.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-secondary.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary.disabled .sc-ic-button-s>a{border-color:var(--ic-architectural-300);color:var(--ic-architectural-300);background:none}/*!@:host(.button-variant-secondary.light.disabled) .button,\n:host(.button-variant-secondary.light.disabled) ::slotted(a)*/.button-variant-secondary.light.disabled.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-secondary.light.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary.light.disabled .sc-ic-button-s>a{border-color:var(--ic-architectural-500);color:var(--ic-architectural-500)}/*!@:host(.button-variant-tertiary) .button,\n:host(.button-variant-tertiary) ::slotted(a)*/.button-variant-tertiary.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-tertiary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-tertiary .sc-ic-button-s>a{color:var(--button-default)}/*!@:host(.button-variant-tertiary) .button:hover,\n:host(.button-variant-tertiary) ::slotted(a:hover)*/.button-variant-tertiary.sc-ic-button-h .button.sc-ic-button:hover,.sc-ic-button-h.button-variant-tertiary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-tertiary.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-tertiary .sc-ic-button-s>a:hover{background-color:var(--button-default-background-hover);color:var(--button-default-hover)}/*!@:host(.button-variant-tertiary) .button:active,\n:host(.button-variant-tertiary) ::slotted(a:active),\n:host(.button-variant-tertiary.loading) .button*/.button-variant-tertiary.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-tertiary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-tertiary.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-tertiary .sc-ic-button-s>a:active,.button-variant-tertiary.loading.sc-ic-button-h .button.sc-ic-button{background-color:var(--button-default-background-active);color:var(--button-default-active)}/*!@:host(.button-variant-tertiary.disabled) .button,\n:host(.button-variant-tertiary.disabled) ::slotted(a)*/.button-variant-tertiary.disabled.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-tertiary.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-tertiary.disabled .sc-ic-button-s>a{color:var(--ic-architectural-300);background:none}/*!@:host(.button-variant-tertiary.light.disabled) .button,\n:host(.button-variant-tertiary.light.disabled) ::slotted(a)*/.button-variant-tertiary.light.disabled.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-tertiary.light.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-tertiary.light.disabled .sc-ic-button-s>a{color:var(--ic-architectural-500)}/*!@:host(.button-variant-destructive) .button,\n:host(.button-variant-destructive) ::slotted(a)*/.button-variant-destructive.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-destructive.sc-ic-button-s>a,.sc-ic-button-h.button-variant-destructive .sc-ic-button-s>a{color:var(--ic-color-white-text);background-color:var(--ic-action-destructive);text-transform:uppercase}/*!@:host(.button-variant-destructive) .button:hover*/.button-variant-destructive.sc-ic-button-h .button.sc-ic-button:hover{background-color:var(--ic-action-destructive-hover)}/*!@:host(.button-variant-destructive) .button:active,\n:host(.button-variant-destructive.loading) .button*/.button-variant-destructive.sc-ic-button-h .button.sc-ic-button:active,.button-variant-destructive.loading.sc-ic-button-h .button.sc-ic-button{background-color:var(--ic-action-destructive-active)}/*!@:host(.button-variant-destructive.disabled) .button,\n:host(.button-variant-destructive.disabled) ::slotted(a)*/.button-variant-destructive.disabled.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-destructive.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-destructive.disabled .sc-ic-button-s>a{background:var(--ic-architectural-200);color:var(--ic-architectural-300)}/*!@:host(.button-variant-icon) .button,\n:host(.button-variant-icon) ::slotted(a)*/.button-variant-icon.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-icon.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon .sc-ic-button-s>a{color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}/*!@:host(.button-variant-icon) .icon-container*/.button-variant-icon.sc-ic-button-h .icon-container.sc-ic-button{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}/*!@:host(.button-variant-icon) .button:hover,\n:host(.button-variant-icon) ::slotted(a:hover)*/.button-variant-icon.sc-ic-button-h .button.sc-ic-button:hover,.sc-ic-button-h.button-variant-icon.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon .sc-ic-button-s>a:hover{background-color:var(--button-default-background-hover);color:var(--button-default-hover)}/*!@:host(.button-variant-icon) .button:active:not(:focus),\n:host(.button-variant-icon) ::slotted(a:active:not(:focus)),\n:host(.button-variant-icon.loading) .button*/.button-variant-icon.sc-ic-button-h .button.sc-ic-button:active:not(:focus),.sc-ic-button-h.button-variant-icon.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon.sc-ic-button-s>a:active:not(:focus),.sc-ic-button-h.button-variant-icon .sc-ic-button-s>a:active:not(:focus),.button-variant-icon.loading.sc-ic-button-h .button.sc-ic-button{background-color:var(--button-default-background-active);color:var(--button-default-active)}/*!@:host(.button-variant-icon.disabled) .button,\n:host(.button-variant-icon.disabled) ::slotted(a)*/.button-variant-icon.disabled.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-icon.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon.disabled .sc-ic-button-s>a{color:var(--ic-architectural-300);background:none}/*!@:host(.button-variant-icon-primary) .button,\n:host(.button-variant-icon-primary) ::slotted(a)*/.button-variant-icon-primary.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-icon-primary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-primary .sc-ic-button-s>a{color:var(--ic-color-white-text);background-color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}/*!@:host(.button-variant-icon-primary) .icon-container*/.button-variant-icon-primary.sc-ic-button-h .icon-container.sc-ic-button{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}/*!@:host(.button-variant-icon-primary) .button:hover,\n:host(.button-variant-icon-primary) ::slotted(a:hover)*/.button-variant-icon-primary.sc-ic-button-h .button.sc-ic-button:hover,.sc-ic-button-h.button-variant-icon-primary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-primary.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-primary .sc-ic-button-s>a:hover{background-color:var(--button-default-hover)}/*!@:host(.button-variant-icon-primary) .button:active,\n:host(.button-variant-icon-primary) ::slotted(a:active),\n:host(.button-variant-icon-primary.loading) .button*/.button-variant-icon-primary.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-icon-primary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-primary.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon-primary .sc-ic-button-s>a:active,.button-variant-icon-primary.loading.sc-ic-button-h .button.sc-ic-button{background:var(--button-default-active)}/*!@:host(.button-variant-icon-primary.loading) .button ic-loading-indicator*/.button-variant-icon-primary.loading.sc-ic-button-h .button.sc-ic-button ic-loading-indicator.sc-ic-button{--inner-color:var(--ic-architectural-white)}/*!@:host(.button-variant-icon-primary.disabled) .button,\n:host(.button-variant-icon-primary.disabled) ::slotted(a)*/.button-variant-icon-primary.disabled.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-icon-primary.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-primary.disabled .sc-ic-button-s>a{color:var(--ic-architectural-300);background:var(--ic-architectural-200)}/*!@:host(.button-variant-icon-primary.light) .button,\n:host(.button-variant-icon-primary.light) ::slotted(a)*/.button-variant-icon-primary.light.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-icon-primary.light.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-primary.light .sc-ic-button-s>a{color:var(--ic-color-primary-text)}/*!@:host(.button-variant-icon-primary.light) .button:hover,\n:host(.button-variant-icon-primary.light) ::slotted(a:hover)*/.button-variant-icon-primary.light.sc-ic-button-h .button.sc-ic-button:hover,.sc-ic-button-h.button-variant-icon-primary.light.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-primary.light.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-primary.light .sc-ic-button-s>a:hover{background:var(--ic-action-light-hover)}/*!@:host(.button-variant-icon-primary.light) .button:active,\n:host(.button-variant-icon-primary.light) ::slotted(a:active),\n:host(.button-variant-icon-primary.light.loading) .button,\n:host(.button-variant-icon-primary.light.loading) ::slotted(a)*/.button-variant-icon-primary.light.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-icon-primary.light.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-primary.light.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon-primary.light .sc-ic-button-s>a:active,.button-variant-icon-primary.light.loading.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-icon-primary.light.loading.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-primary.light.loading .sc-ic-button-s>a{background:var(--ic-action-light-active)}/*!@:host(.button-variant-icon-primary.dark) .button:hover,\n:host(.button-variant-icon-primary.dark) ::slotted(a:hover)*/.button-variant-icon-primary.dark.sc-ic-button-h .button.sc-ic-button:hover,.sc-ic-button-h.button-variant-icon-primary.dark.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-primary.dark .sc-ic-button-s>a:hover{background:var(--ic-action-dark-hover)}/*!@:host(.button-variant-icon-primary.dark) .button:active,\n:host(.button-variant-icon-primary.dark) ::slotted(a:active),\n:host(.button-variant-icon-primary.dark.loading) .button,\n:host(.button-variant-icon-primary.dark.loading) ::slotted(a)*/.button-variant-icon-primary.dark.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-icon-primary.dark.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon-primary.dark .sc-ic-button-s>a:active,.button-variant-icon-primary.dark.loading.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-icon-primary.dark.loading.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-primary.dark.loading .sc-ic-button-s>a{background:var(--ic-action-dark-active)}/*!@:host(.button-variant-icon-secondary) .button,\n:host(.button-variant-icon-secondary) ::slotted(a)*/.button-variant-icon-secondary.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-icon-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-secondary .sc-ic-button-s>a{border:var(--ic-border-width) solid var(--button-default);color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}/*!@:host(.button-variant-icon-secondary) .icon-container*/.button-variant-icon-secondary.sc-ic-button-h .icon-container.sc-ic-button{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}/*!@:host(.button-variant-icon-secondary) .button:hover,\n:host(.button-variant-icon-secondary) ::slotted(a:hover)*/.button-variant-icon-secondary.sc-ic-button-h .button.sc-ic-button:hover,.sc-ic-button-h.button-variant-icon-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-secondary.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-secondary .sc-ic-button-s>a:hover{background-color:var(--button-default-background-hover);border-color:var(--button-default-hover);color:var(--button-default-hover)}/*!@:host(.button-variant-icon-secondary) .button:active,\n:host(.button-variant-icon-secondary) ::slotted(a:active),\n:host(.button-variant-icon-secondary.loading) .button*/.button-variant-icon-secondary.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-icon-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-secondary.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon-secondary .sc-ic-button-s>a:active,.button-variant-icon-secondary.loading.sc-ic-button-h .button.sc-ic-button{border-color:var(--button-default-active);background-color:var(--button-default-background-active);color:var(--button-default-active)}/*!@:host(.button-variant-icon-secondary.disabled) .button,\n:host(.button-variant-icon-secondary.disabled) .button:hover,\n:host(.button-variant-icon-secondary.disabled) .button:active,\n:host(.button-variant-icon-secondary.disabled) ::slotted(a),\n:host(.button-variant-icon-secondary.disabled) ::slotted(a:hover),\n:host(.button-variant-icon-secondary.disabled) ::slotted(a:active)*/.button-variant-icon-secondary.disabled.sc-ic-button-h .button.sc-ic-button,.button-variant-icon-secondary.disabled.sc-ic-button-h .button.sc-ic-button:hover,.button-variant-icon-secondary.disabled.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-icon-secondary.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-secondary.disabled .sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-secondary.disabled.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-secondary.disabled .sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-secondary.disabled.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon-secondary.disabled .sc-ic-button-s>a:active{border-color:var(--ic-architectural-300);color:var(--ic-architectural-300);background:none}/*!@:host(.button-variant-icon-secondary.light.disabled) .button,\n:host(.button-variant-icon-secondary.light.disabled) .button:hover,\n:host(.button-variant-icon-secondary.light.disabled) .button:active,\n:host(.button-variant-icon-secondary.light.disabled) ::slotted(a),\n:host(.button-variant-icon-secondary.light.disabled) ::slotted(a:hover),\n:host(.button-variant-icon-secondary.light.disabled) ::slotted(a:active)*/.button-variant-icon-secondary.light.disabled.sc-ic-button-h .button.sc-ic-button,.button-variant-icon-secondary.light.disabled.sc-ic-button-h .button.sc-ic-button:hover,.button-variant-icon-secondary.light.disabled.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-icon-secondary.light.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-secondary.light.disabled .sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-secondary.light.disabled.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-secondary.light.disabled .sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-secondary.light.disabled.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon-secondary.light.disabled .sc-ic-button-s>a:active{border-color:var(--ic-architectural-500);color:var(--ic-architectural-500)}/*!@:host(.button-variant-icon-tertiary) .button,\n:host(.button-variant-icon-tertiary) ::slotted(a)*/.button-variant-icon-tertiary.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-icon-tertiary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-tertiary .sc-ic-button-s>a{color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}/*!@:host(.button-variant-icon-tertiary) .icon-container*/.button-variant-icon-tertiary.sc-ic-button-h .icon-container.sc-ic-button{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}/*!@:host(.button-variant-icon-tertiary) .button:hover,\n:host(.button-variant-icon-tertiary) ::slotted(a:hover)*/.button-variant-icon-tertiary.sc-ic-button-h .button.sc-ic-button:hover,.sc-ic-button-h.button-variant-icon-tertiary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-tertiary.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-tertiary .sc-ic-button-s>a:hover{background-color:var(--button-default-background-hover);color:var(--button-default-hover)}/*!@:host(.button-variant-icon-tertiary) .button:active,\n:host(.button-variant-icon-tertiary) ::slotted(a:active),\n:host(.button-variant-icon-tertiary.loading) .button*/.button-variant-icon-tertiary.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-icon-tertiary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-tertiary.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon-tertiary .sc-ic-button-s>a:active,.button-variant-icon-tertiary.loading.sc-ic-button-h .button.sc-ic-button{background-color:var(--button-default-background-active);color:var(--button-default-active)}/*!@:host(.button-variant-icon-tertiary.disabled) .button,\n:host(.button-variant-icon-tertiary.disabled) .button:hover,\n:host(.button-variant-icon-tertiary.disabled) .button:active,\n:host(.button-variant-icon-tertiary.disabled) ::slotted(a),\n:host(.button-variant-icon-tertiary.disabled) ::slotted(a:hover),\n:host(.button-variant-icon-tertiary.disabled) ::slotted(a:active)*/.button-variant-icon-tertiary.disabled.sc-ic-button-h .button.sc-ic-button,.button-variant-icon-tertiary.disabled.sc-ic-button-h .button.sc-ic-button:hover,.button-variant-icon-tertiary.disabled.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-icon-tertiary.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-tertiary.disabled .sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-tertiary.disabled.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-tertiary.disabled .sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-tertiary.disabled.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon-tertiary.disabled .sc-ic-button-s>a:active{color:var(--ic-architectural-300);background:none}/*!@:host(.button-variant-icon-destructive) .button,\n:host(.button-variant-icon-destructive) ::slotted(a)*/.button-variant-icon-destructive.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-variant-icon-destructive.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-destructive .sc-ic-button-s>a{color:var(--ic-color-white-text);background-color:var(--ic-action-destructive);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}/*!@:host(.button-variant-icon-destructive) .icon-container*/.button-variant-icon-destructive.sc-ic-button-h .icon-container.sc-ic-button{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}/*!@:host(.button-variant-icon-destructive) .button:hover,\n:host(.button-variant-icon-destructive) ::slotted(a:hover)*/.button-variant-icon-destructive.sc-ic-button-h .button.sc-ic-button:hover,.sc-ic-button-h.button-variant-icon-destructive.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-destructive.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-destructive .sc-ic-button-s>a:hover{background-color:var(--ic-action-destructive-hover)}/*!@:host(.button-variant-icon-destructive) .button:active,\n:host(.button-variant-icon-destructive) ::slotted(a:active),\n:host(.button-variant-icon-destructive.loading) .button*/.button-variant-icon-destructive.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-icon-destructive.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-destructive.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon-destructive .sc-ic-button-s>a:active,.button-variant-icon-destructive.loading.sc-ic-button-h .button.sc-ic-button{background-color:var(--ic-action-destructive-active)}/*!@:host(.button-variant-icon-destructive.loading) .button ic-loading-indicator*/.button-variant-icon-destructive.loading.sc-ic-button-h .button.sc-ic-button ic-loading-indicator.sc-ic-button{--inner-color:var(--ic-architectural-white)}/*!@:host(.button-variant-icon-destructive.disabled) .button,\n:host(.button-variant-icon-destructive.disabled) .button:hover,\n:host(.button-variant-icon-destructive.disabled) .button:active,\n:host(.button-variant-icon-destructive.disabled) ::slotted(a),\n:host(.button-variant-icon-destructive.disabled) ::slotted(a:hover),\n:host(.button-variant-icon-destructive.disabled) ::slotted(a:active)*/.button-variant-icon-destructive.disabled.sc-ic-button-h .button.sc-ic-button,.button-variant-icon-destructive.disabled.sc-ic-button-h .button.sc-ic-button:hover,.button-variant-icon-destructive.disabled.sc-ic-button-h .button.sc-ic-button:active,.sc-ic-button-h.button-variant-icon-destructive.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-destructive.disabled .sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon-destructive.disabled.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-destructive.disabled .sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon-destructive.disabled.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon-destructive.disabled .sc-ic-button-s>a:active{background:var(--ic-architectural-200);color:var(--ic-architectural-300)}/*!@:host(.button-size-default) .button*/.button-size-default.sc-ic-button-h .button.sc-ic-button{height:var(--height, 2.5rem);padding:var(--ic-space-xs) var(--ic-space-md)}/*!@:host(.button-size-small) .button*/.button-size-small.sc-ic-button-h .button.sc-ic-button{height:var(--height, var(--ic-space-xl));padding:var(--ic-space-xxs) var(--ic-space-md)}/*!@:host(.button-size-large) .button*/.button-size-large.sc-ic-button-h .button.sc-ic-button{height:var(--height, var(--ic-space-xxl));padding:var(--ic-space-sm) var(--ic-space-md)}/*!@:host(.button-size-default.button-variant-icon) .button,\n:host(.button-size-default.button-variant-icon-primary) .button,\n:host(.button-size-default.button-variant-icon-secondary) .button,\n:host(.button-size-default.button-variant-icon-tertiary) .button,\n:host(.button-size-default.button-variant-icon-destructive) .button,\n:host(.button-size-default.button-variant-icon-primary) ::slotted(a),\n:host(.button-size-default.button-variant-icon-secondary) ::slotted(a),\n:host(.button-size-default.button-variant-icon-tertiary) ::slotted(a),\n:host(.button-size-default.button-variant-icon-destructive) ::slotted(a),\n:host(.button-size-default.button-variant-icon) ::slotted(a)*/.button-size-default.button-variant-icon.sc-ic-button-h .button.sc-ic-button,.button-size-default.button-variant-icon-primary.sc-ic-button-h .button.sc-ic-button,.button-size-default.button-variant-icon-secondary.sc-ic-button-h .button.sc-ic-button,.button-size-default.button-variant-icon-tertiary.sc-ic-button-h .button.sc-ic-button,.button-size-default.button-variant-icon-destructive.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-size-default.button-variant-icon-primary.sc-ic-button-s>a,.sc-ic-button-h.button-size-default.button-variant-icon-primary .sc-ic-button-s>a,.sc-ic-button-h.button-size-default.button-variant-icon-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-size-default.button-variant-icon-secondary .sc-ic-button-s>a,.sc-ic-button-h.button-size-default.button-variant-icon-tertiary.sc-ic-button-s>a,.sc-ic-button-h.button-size-default.button-variant-icon-tertiary .sc-ic-button-s>a,.sc-ic-button-h.button-size-default.button-variant-icon-destructive.sc-ic-button-s>a,.sc-ic-button-h.button-size-default.button-variant-icon-destructive .sc-ic-button-s>a,.sc-ic-button-h.button-size-default.button-variant-icon.sc-ic-button-s>a,.sc-ic-button-h.button-size-default.button-variant-icon .sc-ic-button-s>a{height:var(--height, var(--ic-space-xl));width:var(--ic-space-xl);padding:0.375rem}/*!@:host(.button-size-small.button-variant-icon) .button,\n:host(.button-size-small.button-variant-icon-primary) .button,\n:host(.button-size-small.button-variant-icon-secondary) .button,\n:host(.button-size-small.button-variant-icon-tertiary) .button,\n:host(.button-size-small.button-variant-icon-destructive) .button,\n:host(.button-size-small.button-variant-icon-primary) ::slotted(a),\n:host(.button-size-small.button-variant-icon-secondary) ::slotted(a),\n:host(.button-size-small.button-variant-icon-tertiary) ::slotted(a),\n:host(.button-size-small.button-variant-icon-destructive) ::slotted(a),\n:host(.button-size-small.button-variant-icon) ::slotted(a)*/.button-size-small.button-variant-icon.sc-ic-button-h .button.sc-ic-button,.button-size-small.button-variant-icon-primary.sc-ic-button-h .button.sc-ic-button,.button-size-small.button-variant-icon-secondary.sc-ic-button-h .button.sc-ic-button,.button-size-small.button-variant-icon-tertiary.sc-ic-button-h .button.sc-ic-button,.button-size-small.button-variant-icon-destructive.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-size-small.button-variant-icon-primary.sc-ic-button-s>a,.sc-ic-button-h.button-size-small.button-variant-icon-primary .sc-ic-button-s>a,.sc-ic-button-h.button-size-small.button-variant-icon-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-size-small.button-variant-icon-secondary .sc-ic-button-s>a,.sc-ic-button-h.button-size-small.button-variant-icon-tertiary.sc-ic-button-s>a,.sc-ic-button-h.button-size-small.button-variant-icon-tertiary .sc-ic-button-s>a,.sc-ic-button-h.button-size-small.button-variant-icon-destructive.sc-ic-button-s>a,.sc-ic-button-h.button-size-small.button-variant-icon-destructive .sc-ic-button-s>a,.sc-ic-button-h.button-size-small.button-variant-icon.sc-ic-button-s>a,.sc-ic-button-h.button-size-small.button-variant-icon .sc-ic-button-s>a{height:var(--height, var(--ic-space-lg));width:var(--ic-space-lg);padding:var(--ic-space-xxs)}/*!@:host(.button-size-large.button-variant-icon) .button,\n:host(.button-size-large.button-variant-icon-primary) .button,\n:host(.button-size-large.button-variant-icon-secondary) .button,\n:host(.button-size-large.button-variant-icon-tertiary) .button,\n:host(.button-size-large.button-variant-icon-destructive) .button,\n:host(.button-size-large.button-variant-icon-primary) ::slotted(a),\n:host(.button-size-large.button-variant-icon-secondary) ::slotted(a),\n:host(.button-size-large.button-variant-icon-tertiary) ::slotted(a),\n:host(.button-size-large.button-variant-icon-destructive) ::slotted(a),\n:host(.button-size-large.button-variant-icon) ::slotted(a)*/.button-size-large.button-variant-icon.sc-ic-button-h .button.sc-ic-button,.button-size-large.button-variant-icon-primary.sc-ic-button-h .button.sc-ic-button,.button-size-large.button-variant-icon-secondary.sc-ic-button-h .button.sc-ic-button,.button-size-large.button-variant-icon-tertiary.sc-ic-button-h .button.sc-ic-button,.button-size-large.button-variant-icon-destructive.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.button-size-large.button-variant-icon-primary.sc-ic-button-s>a,.sc-ic-button-h.button-size-large.button-variant-icon-primary .sc-ic-button-s>a,.sc-ic-button-h.button-size-large.button-variant-icon-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-size-large.button-variant-icon-secondary .sc-ic-button-s>a,.sc-ic-button-h.button-size-large.button-variant-icon-tertiary.sc-ic-button-s>a,.sc-ic-button-h.button-size-large.button-variant-icon-tertiary .sc-ic-button-s>a,.sc-ic-button-h.button-size-large.button-variant-icon-destructive.sc-ic-button-s>a,.sc-ic-button-h.button-size-large.button-variant-icon-destructive .sc-ic-button-s>a,.sc-ic-button-h.button-size-large.button-variant-icon.sc-ic-button-s>a,.sc-ic-button-h.button-size-large.button-variant-icon .sc-ic-button-s>a{height:var(--height, 2.5rem);width:2.5rem;padding:var(--ic-space-xs)}/*!@:host(.full-width),\n:host(.full-width) .button,\n:host(.full-width) ::slotted(a)*/.full-width.sc-ic-button-h,.full-width.sc-ic-button-h .button.sc-ic-button,.sc-ic-button-h.full-width.sc-ic-button-s>a,.sc-ic-button-h.full-width .sc-ic-button-s>a{width:100%}/*!@div.loading-container*/div.loading-container.sc-ic-button{position:relative;align-items:center;width:100%}/*!@ic-loading-indicator*/ic-loading-indicator.sc-ic-button{--outer-color:transparent}@keyframes loading-animation{0%{width:0%;left:0%}25%{width:0%;left:0%;opacity:0}50%{width:100%;left:0%;opacity:1}75%{width:0%;left:100%}100%{width:0%;left:100%;opacity:0}}/*!@div.icon-container*/div.icon-container.sc-ic-button{box-sizing:border-box;width:var(--ic-space-lg);height:var(--ic-space-lg);display:flex;justify-content:center;align-items:center;margin-right:var(--ic-space-xs)}/*!@div.right-icon*/div.right-icon.sc-ic-button{margin-right:auto;margin-left:var(--ic-space-xs)}/*!@:host(.full-width) .right-icon*/.full-width.sc-ic-button-h .right-icon.sc-ic-button{margin-right:var(--ic-space-xs)}/*!@::slotted(:not(ic-badge))*/.sc-ic-button-s>:not(ic-badge){width:var(--icon-width) !important;height:var(--icon-height) !important;fill:currentcolor !important;pointer-events:none}/*!@:host(.button-variant-icon) .button .icon-container*/.button-variant-icon.sc-ic-button-h .button.sc-ic-button .icon-container.sc-ic-button{margin:0;pointer-events:none}/*!@:host(.search-submit-button) ::slotted(svg)*/.sc-ic-button-h.search-submit-button .sc-ic-button-s>svg{--icon-height:1.25rem;--icon-width:1.25rem}/*!@:host(.search-submit-button-small) ::slotted(svg)*/.sc-ic-button-h.search-submit-button-small .sc-ic-button-s>svg{--icon-height:1rem;--icon-width:1rem}/*!@:host(.clear-button)*/.clear-button.sc-ic-button-h{margin:0 var(--ic-space-xxs)}/*!@:host(.clear-button) .button:focus,\n:host(.calendar-button) .button:focus*/.clear-button.sc-ic-button-h .button.sc-ic-button:focus,.calendar-button.sc-ic-button-h .button.sc-ic-button:focus{box-shadow:none}/*!@:host(.search-submit-button) .button:focus*/.search-submit-button.sc-ic-button-h .button.sc-ic-button:focus{box-shadow:none}/*!@:host(.search-submit-button) .button:not(:active):focus*/.search-submit-button.sc-ic-button-h .button.sc-ic-button:not(:active):focus{box-shadow:none;background-color:var(--ic-action-default-bg-hover)}/*!@:host(.search-submit-button)*/.search-submit-button.sc-ic-button-h{display:flex;align-items:center;margin:0 var(--ic-space-xxs)}/*!@:host(.menu-close-button) ::slotted(svg)*/.sc-ic-button-h.menu-close-button .sc-ic-button-s>svg{--icon-height:0.875rem;--icon-width:0.875rem}/*!@:host(.popout-menu-button) .button*/.popout-menu-button.sc-ic-button-h .button.sc-ic-button{height:var(--height);justify-content:left;border-radius:0;white-space:pre-line;text-align:start}/*!@:host(.popout-menu-button) div.icon-container*/.popout-menu-button.sc-ic-button-h div.icon-container.sc-ic-button{flex:none}/*!@:host(.popout-menu-button) .button:focus*/.popout-menu-button.sc-ic-button-h .button.sc-ic-button:focus{box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset)}/*!@.ic-button-describedby*/.ic-button-describedby.sc-ic-button{display:none}/*!@:host .ic-tooltip*/.sc-ic-button-h .ic-tooltip.sc-ic-button{display:block}/*!@:host .arrow-dropdown*/.sc-ic-button-h .arrow-dropdown.sc-ic-button{margin-top:auto}/*!@:host .dropdown-expanded*/.sc-ic-button-h .dropdown-expanded.sc-ic-button{transform:rotate(180deg);margin-bottom:var(--ic-space-xxxs)}/*!@:host(.dropdown-no-icon) .button*/.dropdown-no-icon.sc-ic-button-h .button.sc-ic-button{padding-right:var(--ic-space-xs)}/*!@slot[name=\"router-item\"]::slotted(a)*/slot[name=\"router-item\"].sc-ic-button-s>a{pointer-events:all}/*!@::slotted(a)*/.sc-ic-button-s>a{font-size:0.875rem !important;border:none !important;vertical-align:middle !important}/*!@:host(.white-background) ::slotted(a)*/.sc-ic-button-h.white-background.sc-ic-button-s>a,.sc-ic-button-h.white-background .sc-ic-button-s>a{background-color:var(--ic-architectural-white) !important}/*!@:host(.button-variant-primary) ::slotted(a)*/.sc-ic-button-h.button-variant-primary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-primary .sc-ic-button-s>a{background-color:var(--button-default) !important}/*!@:host(.button-variant-primary) ::slotted(a:hover)*/.sc-ic-button-h.button-variant-primary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-primary .sc-ic-button-s>a:hover{background-color:var(--button-default-hover) !important}/*!@:host(.button-variant-primary) ::slotted(a:active)*/.sc-ic-button-h.button-variant-primary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-primary .sc-ic-button-s>a:active{background-color:var(--button-default-active) !important}/*!@:host(.button-variant-primary.disabled) ::slotted(a),\n:host(.button-variant-destructive.disabled) ::slotted(a)*/.sc-ic-button-h.button-variant-primary.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-primary.disabled .sc-ic-button-s>a,.sc-ic-button-h.button-variant-destructive.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-destructive.disabled .sc-ic-button-s>a{background:var(--ic-architectural-200) !important}/*!@:host(.button-variant-primary.light.disabled) ::slotted(a)*/.sc-ic-button-h.button-variant-primary.light.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-primary.light.disabled .sc-ic-button-s>a{background:var(--ic-architectural-600) !important}/*!@:host(.button-variant-secondary) ::slotted(a)*/.sc-ic-button-h.button-variant-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary .sc-ic-button-s>a{border:var(--ic-border-width) solid var(--button-default) !important}/*!@:host(.button-variant-secondary) ::slotted(a:hover)*/.sc-ic-button-h.button-variant-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-secondary .sc-ic-button-s>a:hover{background-color:var(--button-default-background-hover) !important;border-color:var(--button-default-hover) !important}/*!@:host(.button-variant-secondary) ::slotted(a:active)*/.sc-ic-button-h.button-variant-secondary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-secondary .sc-ic-button-s>a:active{border-color:var(--button-default-active) !important;background-color:var(--button-default-background-active) !important}/*!@:host(.button-variant-secondary.disabled) ::slotted(a),\n:host(.button-variant-secondary.disabled) ::slotted(a:hover),\n:host(.button-variant-secondary.disabled) ::slotted(a:active),\n:host(.button-variant-tertiary.disabled) ::slotted(a),\n:host(.button-variant-tertiary.disabled) ::slotted(a:hover),\n:host(.button-variant-tertiary.disabled) ::slotted(a:active)*/.sc-ic-button-h.button-variant-secondary.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary.disabled .sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary.disabled.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-secondary.disabled .sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-secondary.disabled.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-secondary.disabled .sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-tertiary.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-tertiary.disabled .sc-ic-button-s>a,.sc-ic-button-h.button-variant-tertiary.disabled.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-tertiary.disabled .sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-tertiary.disabled.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-tertiary.disabled .sc-ic-button-s>a:active{border-color:var(--ic-architectural-300) !important;background:none !important}/*!@:host(.button-variant-secondary.light.disabled) ::slotted(a),\n:host(.button-variant-secondary.light.disabled) ::slotted(a:hover),\n:host(.button-variant-secondary.light.disabled) ::slotted(a:active),\n:host(.button-variant-tertiary.light.disabled) ::slotted(a),\n:host(.button-variant-tertiary.light.disabled) ::slotted(a:hover),\n:host(.button-variant-tertiary.light.disabled) ::slotted(a:active)*/.sc-ic-button-h.button-variant-secondary.light.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary.light.disabled .sc-ic-button-s>a,.sc-ic-button-h.button-variant-secondary.light.disabled.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-secondary.light.disabled .sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-secondary.light.disabled.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-secondary.light.disabled .sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-tertiary.light.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-tertiary.light.disabled .sc-ic-button-s>a,.sc-ic-button-h.button-variant-tertiary.light.disabled.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-tertiary.light.disabled .sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-tertiary.light.disabled.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-tertiary.light.disabled .sc-ic-button-s>a:active{border-color:var(--ic-architectural-500) !important}/*!@:host(.button-variant-tertiary) ::slotted(a:hover),\n:host(.button-variant-icon) ::slotted(a:hover)*/.sc-ic-button-h.button-variant-tertiary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-tertiary.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-tertiary .sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon .sc-ic-button-s>a:hover{background-color:var(--button-default-background-hover) !important}/*!@:host(.button-variant-tertiary) ::slotted(a:active:not(:focus)),\n:host(.button-variant-tertiary) ::slotted(a:active:focus),\n:host(.button-variant-tertiary) ::slotted(a:active),\n:host(.button-variant-icon) ::slotted(a:active:not(:focus))*/.sc-ic-button-h.button-variant-tertiary.sc-ic-button-s>a,.sc-ic-button-h.button-variant-tertiary.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-tertiary .sc-ic-button-s>a:active:not(:focus),.sc-ic-button-h.button-variant-tertiary.sc-ic-button-s>a:active:focus,.sc-ic-button-h.button-variant-tertiary .sc-ic-button-s>a:active:focus,.sc-ic-button-h.button-variant-tertiary .sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon.sc-ic-button-s>a:active:not(:focus),.sc-ic-button-h.button-variant-icon .sc-ic-button-s>a:active:not(:focus){background-color:var(--button-default-background-active) !important}/*!@:host(.button-variant-icon.disabled) ::slotted(a),\n:host(.button-variant-icon.disabled) ::slotted(a:hover),\n:host(.button-variant-icon.disabled) ::slotted(a:active)*/.sc-ic-button-h.button-variant-icon.disabled.sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon.disabled .sc-ic-button-s>a,.sc-ic-button-h.button-variant-icon.disabled.sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon.disabled .sc-ic-button-s>a:hover,.sc-ic-button-h.button-variant-icon.disabled.sc-ic-button-s>a:active,.sc-ic-button-h.button-variant-icon.disabled .sc-ic-button-s>a:active{background:none !important}/*!@:host(.button-variant-destructive) ::slotted(a)*/.sc-ic-button-h.button-variant-destructive.sc-ic-button-s>a,.sc-ic-button-h.button-variant-destructive .sc-ic-button-s>a{background-color:var(--ic-action-destructive) !important}/*!@:host(.button-variant-destructive) ::slotted(a:hover)*/.sc-ic-button-h.button-variant-destructive.sc-ic-button-s>a,.sc-ic-button-h.button-variant-destructive .sc-ic-button-s>a:hover{background-color:var(--ic-action-destructive-hover) !important}/*!@:host(.button-variant-destructive) ::slotted(a:active)*/.sc-ic-button-h.button-variant-destructive.sc-ic-button-s>a,.sc-ic-button-h.button-variant-destructive .sc-ic-button-s>a:active{background-color:var(--ic-action-destructive-active) !important}/*!@:host(.button-size-default) ::slotted(a)*/.sc-ic-button-h.button-size-default .sc-ic-button-s>a{height:var(--height, 2.5rem) !important;padding:var(--ic-space-xs) var(--ic-space-md) !important}/*!@:host(.button-size-small) ::slotted(a)*/.sc-ic-button-h.button-size-small .sc-ic-button-s>a{height:var(--height, var(--ic-space-xl)) !important;padding:var(--ic-space-xxs) var(--ic-space-md) !important}/*!@:host(.button-size-large) ::slotted(a)*/.sc-ic-button-h.button-size-large .sc-ic-button-s>a{height:var(--height, var(--ic-space-xxl)) !important;padding:var(--ic-space-sm) var(--ic-space-md) !important}/*!@:host(.button-size-default.button-variant-icon) ::slotted(a)*/.sc-ic-button-h.button-size-default.button-variant-icon.sc-ic-button-s>a,.sc-ic-button-h.button-size-default.button-variant-icon .sc-ic-button-s>a{height:var(--height, var(--ic-space-xl)) !important;padding:0.375rem !important}/*!@:host(.button-size-small.button-variant-icon) ::slotted(a)*/.sc-ic-button-h.button-size-small.button-variant-icon.sc-ic-button-s>a,.sc-ic-button-h.button-size-small.button-variant-icon .sc-ic-button-s>a{padding:var(--ic-space-xxs) !important}/*!@:host(.button-size-large.button-variant-icon) ::slotted(a)*/.sc-ic-button-h.button-size-large.button-variant-icon.sc-ic-button-s>a,.sc-ic-button-h.button-size-large.button-variant-icon .sc-ic-button-s>a{padding:var(--ic-space-xs) !important}@media (forced-colors: active){/*!@.button,\n  ::slotted(a)*/.button.sc-ic-button,.sc-ic-button-s>a{border:0.125rem solid transparent !important}}/*!@:host(.flip) ::slotted(svg)*/.sc-ic-button-h.flip .sc-ic-button-s>svg{transform:scaleX(-1)}";

var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s)
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
let buttonIds = 0;
/**
 * @slot icon - Deprecated. This slot should not be used anymore. Use left-icon or right-icon slot instead.
 * @slot left-icon - Content will be placed to the left of the button label.
 * @slot right-icon - Content will be placed to the right of the button label.
 * @slot top-icon - Content will be placed above the button label.
 * @slot badge - Badge component overlaying the top right of the button.
 * @slot router-item - Handle routing by nesting your routes in this slot. Setting loading to true will have no impact on this slot.
 */
class Button {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.icBlur = createEvent(this, "icBlur", 7);
        this.icFileSelection = createEvent(this, "icFileSelection", 7);
        this.icFocus = createEvent(this, "icFocus", 7);
        this.buttonIdNum = buttonIds++;
        this.hasTooltip = false;
        this.inheritedAttributes = {};
        this.describedbyEl = null;
        this.describedById = null;
        this.mutationObserver = null;
        this.hostMutationObserver = null;
        this.handleClick = () => {
            if ((this.el.type === "submit" || this.el.type === "reset") &&
                !this.hasRouterSlot() &&
                !!this.el.closest("FORM")) {
                const hiddenFormButton = document.createElement("button");
                hiddenFormButton.setAttribute("type", this.el.type);
                hiddenFormButton.style.display = "none";
                this.el.closest("FORM").appendChild(hiddenFormButton);
                hiddenFormButton.click();
                hiddenFormButton.remove();
            }
        };
        this.handleKeyDown = (ev) => {
            if (ev.key === "Escape" && this.hasTooltip) {
                this.closeButtonTooltip(ev);
            }
        };
        this.onFocus = () => {
            this.icFocus.emit();
        };
        this.onBlur = () => {
            this.icBlur.emit();
        };
        // triggered when text content of sibling element in light DOM changes
        this.mutationCallback = () => {
            this.describedByContent = this.describedbyEl.innerText;
        };
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            mutationList.forEach(({ attributeName }) => {
                const attribute = this.el.getAttribute(attributeName);
                if (attributeName === "title")
                    this.title = attribute;
                else if (attributeName === "aria-label")
                    this.ariaLabel = attribute;
                if (IC_INHERITED_ARIA.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] = attribute;
                }
            });
        };
        this.setHasTooltip = () => {
            this.hasTooltip =
                !this.disableTooltip && (!!this.title || this.isIconVariant());
        };
        this.isIconVariant = () => {
            return this.variant.startsWith("icon");
        };
        this.ariaLabel = null;
        this.describedByContent = null;
        this.title = null;
        this.accept = "*";
        this.appearance = "default";
        this.ariaControlsId = undefined;
        this.ariaOwnsId = undefined;
        this.disabled = false;
        this.disableTooltip = false;
        this.download = false;
        this.dropdown = false;
        this.dropdownExpanded = false;
        this.fileUpload = false;
        this.fileInputName = `ic-button-file-upload-input-${buttonIds++}`;
        this.form = undefined;
        this.formaction = undefined;
        this.formenctype = undefined;
        this.formmethod = undefined;
        this.formnovalidate = undefined;
        this.formtarget = undefined;
        this.fullWidth = false;
        this.href = undefined;
        this.hreflang = undefined;
        this.loading = false;
        this.multiple = false;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.selectedFiles = undefined;
        this.size = "default";
        this.target = undefined;
        this.tooltipPlacement = "bottom";
        this.transparentBackground = true;
        this.type = "button";
        this.variant = "primary";
    }
    watchDisabledHandler() {
        removeDisabledFalse(this.disabled, this.el);
    }
    disconnectedCallback() {
        if (this.mutationObserver !== null && this.mutationObserver !== undefined) {
            this.mutationObserver.disconnect();
        }
        if (this.hostMutationObserver !== null &&
            this.hostMutationObserver !== undefined) {
            this.hostMutationObserver.disconnect();
        }
    }
    componentWillUpdate() {
        if (this.loading) {
            this.el.style.setProperty("--min-width", `${this.el.getBoundingClientRect().width}px`);
        }
        this.setHasTooltip();
    }
    componentWillLoad() {
        const _a = inheritAttributes(this.el, [...IC_INHERITED_ARIA, "title"]), { title, "aria-label": ariaLabel } = _a, restInheritedAttributes = __rest(_a, ["title", "aria-label"]);
        this.title = title;
        this.ariaLabel = ariaLabel;
        this.inheritedAttributes = restInheritedAttributes;
        removeDisabledFalse(this.disabled, this.el);
        this.el.setAttribute("exportparts", "button");
        this.id = this.el.id || null;
        this.setHasTooltip();
        if (!this.hasTooltip) {
            const describedById = this.inheritedAttributes["aria-describedby"];
            if (describedById !== undefined) {
                this.describedById = describedById;
                const el = this.el.parentElement.querySelector(`#${describedById}`);
                if (el) {
                    this.describedByContent = el.innerText;
                    this.describedbyEl = el;
                }
            }
        }
    }
    componentDidLoad() {
        this.updateTheme();
        if (typeof MutationObserver !== "undefined") {
            if (this.describedById) {
                this.mutationObserver = new MutationObserver(this.mutationCallback);
                this.mutationObserver.observe(this.describedbyEl, {
                    characterData: true,
                    childList: true,
                    subtree: true,
                });
            }
            this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
            this.hostMutationObserver.observe(this.el, {
                attributes: true,
            });
        }
    }
    componentWillRender() {
        const iconEl = this.hasIconSlot("left")
            ? this.el.querySelector(`[slot="left-icon"]`)
            : this.hasIconSlot("right")
                ? this.el.querySelector(`[slot="right-icon"]`)
                : null;
        iconEl === null || iconEl === void 0 ? void 0 : iconEl.setAttribute("viewBox", "0 0 24 24");
    }
    handleHostClick(event) {
        if (!this.hasRouterSlot()) {
            if (this.fileUpload) {
                renderFileHiddenInput(this.icFileSelection, this.el, this.multiple, this.fileInputName, this.selectedFiles, this.disabled, this.accept);
            }
            if (this.disabled || this.loading) {
                event.stopImmediatePropagation();
            }
            if (this.dropdown) {
                this.dropdownExpanded = !this.dropdownExpanded;
            }
        }
    }
    themeChangeHandler({ detail }) {
        this.updateTheme(detail.mode);
    }
    /**
     * Sets focus on the native `button`.
     */
    async setFocus() {
        var _a;
        (_a = this.buttonEl) === null || _a === void 0 ? void 0 : _a.focus();
    }
    async closeButtonTooltip(ev) {
        const tooltip = this.el.shadowRoot.querySelector("ic-tooltip");
        if (await tooltip.isTooltipVisible()) {
            tooltip.displayTooltip(false);
            ev.preventDefault();
            ev.stopImmediatePropagation();
        }
    }
    hasIconSlot(position) {
        const selectorPrefix = position ? `${position}-` : "";
        return this.el.querySelector(`[slot="${selectorPrefix}icon"]`) !== null;
    }
    hasRouterSlot() {
        this.routerSlot = this.el.querySelector('[slot="router-item"]');
        if (this.routerSlot) {
            this.routerSlot.ariaLabel = this.routerSlot.textContent;
        }
        return !!this.routerSlot;
    }
    updateTheme(newTheme = null) {
        const foregroundColor = getThemeFromContext(this.el, newTheme);
        if (foregroundColor !== IcThemeForegroundEnum.Default) {
            this.appearance = foregroundColor;
        }
    }
    render() {
        const TagType = (this.href && "a") || "button";
        const { title, ariaLabel, inheritedAttributes } = this;
        const buttonAttrs = TagType === "button"
            ? {
                type: this.type,
                disabled: this.disabled,
                form: this.form,
                formaction: this.formaction,
                formenctype: this.formenctype,
                formmethod: this.formmethod,
                formnovalidate: this.formnovalidate,
                formtarget: this.formtarget,
            }
            : {
                download: this.download !== false ? this.download : null,
                href: this.href,
                rel: this.rel,
                target: this.target,
                referrerpolicy: this.referrerpolicy,
                hreflang: this.hreflang,
            };
        let describedby = null;
        let buttonId = null;
        if (this.hasTooltip) {
            buttonId =
                this.id !== null
                    ? `ic-button-with-tooltip-${this.id}`
                    : `ic-button-with-tooltip-${this.buttonIdNum}`;
            describedby =
                this.variant === "icon" && !!ariaLabel
                    ? null
                    : `ic-tooltip-${buttonId}`;
        }
        else {
            describedby = this.describedById;
        }
        const ButtonContent = () => {
            return (hAsync(TagType, Object.assign({ class: "button", "aria-disabled": this.loading || this.disabled ? "true" : null, "aria-label": this.loading ? "Loading" : ariaLabel, "aria-expanded": this.dropdown && `${this.dropdownExpanded}` }, buttonAttrs, inheritedAttributes, { onFocus: this.onFocus, onBlur: this.onBlur, ref: (el) => (this.buttonEl = el), "aria-describedby": describedby, part: "button" }), this.hasIconSlot() && !this.loading && (hAsync("div", { class: "icon-container" }, hAsync("slot", { name: "icon" }))), this.hasIconSlot("left") && !this.loading && (hAsync("div", { class: "icon-container" }, hAsync("slot", { name: "left-icon" }))), this.hasIconSlot("top") &&
                !this.hasIconSlot("left") &&
                !this.hasIconSlot("right") &&
                !this.loading && (hAsync("div", { class: "icon-container" }, hAsync("slot", { name: "top-icon" }))), this.loading ? (hAsync("div", { class: "loading-container" }, hAsync("ic-loading-indicator", { type: "linear", appearance: this.variant === "primary" ||
                    this.variant === "destructive" ||
                    this.appearance === IcThemeForegroundEnum.Dark ||
                    this.appearance === IcThemeForegroundEnum.Light
                    ? "light"
                    : "dark" }))) : (hAsync("slot", null)), this.hasIconSlot("right") && !this.loading && !this.dropdown && (hAsync("div", { class: { "icon-container": true, "right-icon": true } }, hAsync("slot", { name: "right-icon" }))), this.dropdown &&
                !this.loading &&
                this.variant !== "icon" &&
                this.variant !== "destructive" && (hAsync("span", { class: {
                    ["arrow-dropdown"]: !this.dropdownExpanded,
                    ["dropdown-expanded"]: this.dropdownExpanded,
                }, innerHTML: arrowDropdown }))));
        };
        return (hAsync(Host, { class: {
                ["disabled"]: this.disabled && !this.loading,
                [`button-variant-${this.variant}`]: true,
                [`button-size-${this.size}`]: true,
                ["loading"]: this.loading,
                ["dark"]: this.appearance === IcThemeForegroundEnum.Dark,
                ["light"]: this.appearance === IcThemeForegroundEnum.Light,
                ["full-width"]: this.fullWidth,
                ["with-badge"]: isSlotUsed(this.el, "badge"),
                ["dropdown-no-icon"]: this.dropdown &&
                    !isSlotUsed(this.el, "icon") &&
                    !isSlotUsed(this.el, "left-icon"),
                ["top-icon"]: isSlotUsed(this.el, "top-icon"),
                ["white-background"]: this.variant === "secondary" &&
                    !this.transparentBackground &&
                    this.appearance !== "light",
            }, onClick: this.handleClick, onKeyDown: this.handleKeyDown, "aria-owns": this.ariaOwnsId, "aria-controls": this.ariaControlsId, "aria-expanded": this.dropdown && `${this.dropdownExpanded}` }, this.hasTooltip && (hAsync("ic-tooltip", { id: describedby, label: title || ariaLabel, target: buttonId, placement: this.tooltipPlacement, silent: this.isIconVariant() && !!ariaLabel }, this.hasRouterSlot() ? (hAsync("slot", { name: "router-item" })) : (hAsync(ButtonContent, null)))), isSlotUsed(this.el, "badge") && hAsync("slot", { name: "badge" }), !this.hasTooltip &&
            (this.hasRouterSlot() ? (hAsync("slot", { name: "router-item" })) : (hAsync(ButtonContent, null))), this.describedByContent && (hAsync("span", { id: describedby, class: "ic-button-describedby" }, this.describedByContent))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get watchers() { return {
        "disabled": ["watchDisabledHandler"]
    }; }
    static get style() { return icButtonCss; }
    static get cmpMeta() { return {
        "$flags$": 25,
        "$tagName$": "ic-button",
        "$members$": {
            "accept": [1],
            "appearance": [1025],
            "ariaControlsId": [8, "aria-controls-id"],
            "ariaOwnsId": [8, "aria-owns-id"],
            "disabled": [4],
            "disableTooltip": [4, "disable-tooltip"],
            "download": [8],
            "dropdown": [4],
            "dropdownExpanded": [1540, "dropdown-expanded"],
            "fileUpload": [4, "file-upload"],
            "fileInputName": [1, "file-input-name"],
            "form": [1],
            "formaction": [1],
            "formenctype": [1],
            "formmethod": [1],
            "formnovalidate": [4],
            "formtarget": [1],
            "fullWidth": [4, "full-width"],
            "href": [1],
            "hreflang": [1],
            "loading": [4],
            "multiple": [4],
            "referrerpolicy": [1],
            "rel": [1],
            "selectedFiles": [16],
            "size": [1],
            "target": [1],
            "tooltipPlacement": [1, "tooltip-placement"],
            "transparentBackground": [4, "transparent-background"],
            "type": [1],
            "variant": [1],
            "ariaLabel": [32],
            "describedByContent": [32],
            "title": [32],
            "setFocus": [64]
        },
        "$listeners$": [[2, "click", "handleHostClick"], [4, "themeChange", "themeChangeHandler"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": [["dropdownExpanded", "dropdown-expanded"]]
    }; }
}

const icCardCss = "/*!@html*/html.sc-ic-card{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-card{margin:0}/*!@main*/main.sc-ic-card{display:block}/*!@h1*/h1.sc-ic-card{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-card{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-card{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-card{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-card{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-card,strong.sc-ic-card{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-card,kbd.sc-ic-card,samp.sc-ic-card{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-card{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-card,sup.sc-ic-card{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-card{bottom:-0.25em}/*!@sup*/sup.sc-ic-card{top:-0.5em}/*!@img*/img.sc-ic-card{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-card,input.sc-ic-card,optgroup.sc-ic-card,select.sc-ic-card,textarea.sc-ic-card{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-card,input.sc-ic-card{overflow:visible}/*!@button,\nselect*/button.sc-ic-card,select.sc-ic-card{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-card,[type=\"button\"].sc-ic-card,[type=\"reset\"].sc-ic-card,[type=\"submit\"].sc-ic-card{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-card::-moz-focus-inner,[type=\"button\"].sc-ic-card::-moz-focus-inner,[type=\"reset\"].sc-ic-card::-moz-focus-inner,[type=\"submit\"].sc-ic-card::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-card:-moz-focusring,[type=\"button\"].sc-ic-card:-moz-focusring,[type=\"reset\"].sc-ic-card:-moz-focusring,[type=\"submit\"].sc-ic-card:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-card{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-card{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-card{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-card{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-card,[type=\"radio\"].sc-ic-card{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-card::-webkit-inner-spin-button,[type=\"number\"].sc-ic-card::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-card{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-card::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-card::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-card{display:block}/*!@summary*/summary.sc-ic-card{display:list-item}/*!@template*/template.sc-ic-card{display:none}/*!@[hidden]*/[hidden].sc-ic-card{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-card,body.sc-ic-card,div.sc-ic-card,span.sc-ic-card,applet.sc-ic-card,object.sc-ic-card,iframe.sc-ic-card,h1.sc-ic-card,h2.sc-ic-card,h3.sc-ic-card,h4.sc-ic-card,h5.sc-ic-card,h6.sc-ic-card,p.sc-ic-card,blockquote.sc-ic-card,pre.sc-ic-card,a.sc-ic-card,abbr.sc-ic-card,acronym.sc-ic-card,address.sc-ic-card,big.sc-ic-card,cite.sc-ic-card,code.sc-ic-card,del.sc-ic-card,dfn.sc-ic-card,em.sc-ic-card,img.sc-ic-card,ins.sc-ic-card,kbd.sc-ic-card,q.sc-ic-card,s.sc-ic-card,samp.sc-ic-card,small.sc-ic-card,strike.sc-ic-card,strong.sc-ic-card,sub.sc-ic-card,sup.sc-ic-card,tt.sc-ic-card,var.sc-ic-card,b.sc-ic-card,u.sc-ic-card,i.sc-ic-card,center.sc-ic-card,dl.sc-ic-card,dt.sc-ic-card,dd.sc-ic-card,ol.sc-ic-card,ul.sc-ic-card,li.sc-ic-card,fieldset.sc-ic-card,form.sc-ic-card,label.sc-ic-card,legend.sc-ic-card,table.sc-ic-card,caption.sc-ic-card,tbody.sc-ic-card,tfoot.sc-ic-card,thead.sc-ic-card,tr.sc-ic-card,th.sc-ic-card,td.sc-ic-card,article.sc-ic-card,aside.sc-ic-card,canvas.sc-ic-card,details.sc-ic-card,embed.sc-ic-card,figure.sc-ic-card,figcaption.sc-ic-card,footer.sc-ic-card,header.sc-ic-card,hgroup.sc-ic-card,menu.sc-ic-card,nav.sc-ic-card,output.sc-ic-card,ruby.sc-ic-card,section.sc-ic-card,summary.sc-ic-card,time.sc-ic-card,mark.sc-ic-card,audio.sc-ic-card,video.sc-ic-card{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-card-h{display:flex}/*!@a*/a.sc-ic-card{text-decoration:none !important;color:var(--ic-architechtural-black) !important}/*!@button*/button.sc-ic-card{border:none;background-color:transparent;outline:var(--ic-hc-focus-outline)}/*!@.card,\n.card.clickable*/.card.sc-ic-card,.card.clickable.sc-ic-card{display:flex;flex-direction:column;border:var(--ic-border-default);border-radius:var(--ic-border-radius);box-sizing:border-box;padding:var(--ic-space-md);text-align:left;color:var(--ic-architechtural-black);transition:var(--ic-easing-transition-fast);position:relative;width:inherit;min-width:-moz-fit-content;min-width:fit-content;height:-moz-fit-content;height:fit-content;min-height:100%}/*!@.dark.card,\n.dark.card.clickable*/.dark.card.sc-ic-card,.dark.card.clickable.sc-ic-card{border:var(--ic-border-width) solid var(--ic-architectural-700)}/*!@.card.clickable:hover*/.card.clickable.sc-ic-card:hover{background-color:var(--ic-action-default-bg-hover);border:var(--ic-border-hover);cursor:pointer}/*!@.card.clickable:focus,\n.card.clickable.focussed*/.card.clickable.sc-ic-card:focus,.card.clickable.focussed.sc-ic-card{background-color:var(--ic-action-default-bg-hover);box-shadow:var(--ic-border-focus);outline:var(--ic-hc-focus-outline);border:var(--ic-border-pressed)}/*!@.card.clickable:active*/.card.clickable.sc-ic-card:active{background-color:var(--ic-action-default-bg-active);box-shadow:var(--ic-border-focus)}/*!@.card.disabled*/.card.disabled.sc-ic-card{border:var(--ic-border-disabled)}/*!@.card.fullwidth*/.card.fullwidth.sc-ic-card{width:100%}/*!@.card-header*/.card-header.sc-ic-card{display:flex;align-items:center}/*!@.icon*/.icon.sc-ic-card{display:flex;align-items:center;padding-right:var(--ic-space-xs)}/*!@.card.disabled ::slotted(svg)*/.card.disabled .sc-ic-card-s>svg{fill:var(--ic-color-tertiary-text)}/*!@.card.clickable .card-title*/.card.clickable.sc-ic-card .card-title.sc-ic-card{color:var(--ic-hyperlink);text-decoration:underline;text-decoration-thickness:var(--ic-space-1px)}/*!@.card.clickable:hover .card-title,\n.card.clickable:focus .card-title,\n.card.clickable.focussed .card-title*/.card.clickable.sc-ic-card:hover .card-title.sc-ic-card,.card.clickable.sc-ic-card:focus .card-title.sc-ic-card,.card.clickable.focussed.sc-ic-card .card-title.sc-ic-card{display:inline-block;border-bottom:0.25rem solid !important;margin-bottom:-0.25rem !important;text-decoration:none}@supports (text-underline-offset: 25%){/*!@.card.clickable:hover .card-title,\n  .card.clickable:focus .card-title,\n  .card.clickable.focussed .card-title*/.card.clickable.sc-ic-card:hover .card-title.sc-ic-card,.card.clickable.sc-ic-card:focus .card-title.sc-ic-card,.card.clickable.focussed.sc-ic-card .card-title.sc-ic-card{text-decoration-line:underline;text-decoration-thickness:25%;text-underline-offset:25%;border-bottom:0 !important;margin-bottom:0 !important}}/*!@.card.clickable:active .card-title*/.card.clickable.sc-ic-card:active .card-title.sc-ic-card{text-decoration:none}/*!@.card.disabled .card-title*/.card.disabled.sc-ic-card .card-title.sc-ic-card{text-decoration:underline;text-decoration-thickness:var(--ic-space-1px);text-decoration-color:var(--ic-color-tertiary-text);color:var(--ic-color-tertiary-text)}/*!@.subheading*/.subheading.sc-ic-card{margin-top:var(--ic-space-xxs)}/*!@.adornment*/.adornment.sc-ic-card{margin-top:var(--ic-space-xxs)}/*!@.card-message*/.card-message.sc-ic-card{margin-top:var(--ic-space-md);align-items:left}/*!@.card.disabled .card-message,\n.card.disabled .subheading*/.card.disabled.sc-ic-card .card-message.sc-ic-card,.card.disabled.sc-ic-card .subheading.sc-ic-card{color:var(--ic-color-tertiary-text)}/*!@.interaction-button*/.interaction-button.sc-ic-card{margin-left:auto}/*!@.image-top*/.image-top.sc-ic-card{margin-bottom:var(--ic-space-md);display:flex;justify-content:center}/*!@.image-mid*/.image-mid.sc-ic-card{margin-top:var(--ic-space-md);display:flex;justify-content:center}/*!@.interaction-area*/.interaction-area.sc-ic-card{display:flex;flex-grow:1;gap:var(--ic-space-md);margin-top:var(--ic-space-md);align-items:flex-end}/*!@.interaction-controls*/.interaction-controls.sc-ic-card{display:flex;align-items:center;flex-wrap:wrap;gap:var(--ic-space-sm)}/*!@.toggle-button*/.toggle-button.sc-ic-card{color:var(--ic-action-default);width:2.5rem;height:2.5rem;padding:var(--ic-space-xs);margin:var(--ic-space-1px) 0;min-width:0;cursor:pointer;transition:var(--ic-easing-transition-fast);border-radius:var(--ic-border-radius);display:inline-flex;flex-direction:row;justify-content:center;align-items:center;background:none;border:none;box-sizing:border-box;white-space:nowrap;vertical-align:middle}/*!@#ic-tooltip-expand-button*/#ic-tooltip-expand-button.sc-ic-card{margin-left:auto;position:relative}/*!@.toggle-button:hover,\n.toggle-button:hover:focus*/.toggle-button.sc-ic-card:hover,.toggle-button.sc-ic-card:hover:focus{background-color:var(--ic-action-default-bg-hover);color:var(--ic-action-default-hover)}/*!@.toggle-button:focus*/.toggle-button.sc-ic-card:focus{box-shadow:var(--ic-border-focus)}/*!@.toggle-button:active:not(:focus)*/.toggle-button.sc-ic-card:active:not(:focus){background-color:var(--ic-action-default-bg-active);color:var(--ic-action-default-active)}/*!@.toggle-button svg*/.toggle-button.sc-ic-card svg.sc-ic-card{pointer-events:none;width:100% !important;height:100% !important;fill:currentcolor !important}/*!@.toggle-button-closed svg*/.toggle-button-closed.sc-ic-card svg.sc-ic-card{transform:rotate(90deg)}/*!@.toggle-button-expanded svg*/.toggle-button-expanded.sc-ic-card svg.sc-ic-card{transform:rotate(-90deg)}/*!@.expanded-content*/.expanded-content.sc-ic-card{margin-top:var(--ic-space-md)}@media (forced-colors: active){/*!@.card ::slotted(svg)*/.card .sc-ic-card-s>svg{fill:currentcolor}/*!@.card.disabled ::slotted(svg)*/.card.disabled .sc-ic-card-s>svg{fill:GrayText !important}/*!@.card.disabled*/.card.disabled.sc-ic-card{border-color:GrayText !important}/*!@.card.disabled .card-message,\n  .card.disabled .subheading,\n  .card.disabled .card-title*/.card.disabled.sc-ic-card .card-message.sc-ic-card,.card.disabled.sc-ic-card .subheading.sc-ic-card,.card.disabled.sc-ic-card .card-title.sc-ic-card{color:GrayText}}";

/**
 * @slot heading - Content will be placed at the top of the card to the right of the icon.
 * @slot message - Content will be placed in the main body of the card.
 * @slot subheading - Content will be placed below the card heading.
 * @slot adornment - Content will be placed below the card subheading.
 * @slot image-top - Content will be placed at the top of the card above all other content.
 * @slot image-mid - Content will be placed below the card heading section.
 * @slot icon - Content will be placed to the left of the card heading.
 * @slot interaction-button - Content will be placed in the top right corner of the heading section.
 * @slot interaction-controls - Content will be placed below the card message.
 * @slot expanded-content - Content will be placed below the interaction controls but will not initially be rendered.
 * @slot badge - Badge component overlaying the top right of the card.
 */
class Card {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.hostMutationObserver = null;
        this.parentFocussed = () => {
            this.isFocussed = true;
        };
        this.parentBlurred = () => {
            this.isFocussed = false;
        };
        this.toggleExpanded = () => {
            this.areaExpanded = !this.areaExpanded;
        };
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, [
                    "message",
                    "adornment",
                    "expanded-content",
                    "image-top",
                    "image-mid",
                    "icon",
                    "interaction-button",
                    "badge",
                    "interaction-controls",
                ])
                : false)) ;
        };
        this.appearance = "default";
        this.areaExpanded = false;
        this.isFocussed = false;
        this.parentEl = null;
        this.parentIsAnchorTag = false;
        this.clickable = false;
        this.disabled = false;
        this.expandable = false;
        this.fullWidth = false;
        this.heading = undefined;
        this.href = undefined;
        this.hreflang = "";
        this.message = "";
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.subheading = undefined;
        this.target = undefined;
    }
    disconnectedCallback() {
        var _a;
        if (this.parentIsAnchorTag) {
            this.parentEl.removeEventListener("focus", this.parentFocussed);
            this.parentEl.removeEventListener("blur", this.parentBlurred);
        }
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentWillLoad() {
        this.parentEl = this.el.parentElement;
        if (this.parentEl.tagName === "A") {
            this.clickable = true;
            this.parentIsAnchorTag = true;
            this.parentEl.classList.add("ic-card-wrapper-link");
            this.parentEl.addEventListener("focus", this.parentFocussed);
            this.parentEl.addEventListener("blur", this.parentBlurred);
        }
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        !isSlotUsed(this.el, "heading") &&
            onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Card");
        this.updateTheme();
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            childList: true,
        });
    }
    handleHostClick(event) {
        if (this.disabled) {
            event.stopImmediatePropagation();
        }
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.updateTheme(theme.mode);
    }
    /**
     * Sets focus on the card.
     */
    async setFocus() {
        if (this.el.shadowRoot.querySelector("a")) {
            this.el.shadowRoot.querySelector("a").focus();
        }
        else if (this.el.shadowRoot.querySelector("button")) {
            this.el.shadowRoot.querySelector("button").focus();
        }
    }
    updateTheme(newTheme = null) {
        const foregroundColor = getThemeFromContext(this.el, newTheme || null);
        if (foregroundColor !== IcThemeForegroundEnum.Default) {
            this.appearance = foregroundColor;
        }
    }
    render() {
        const { clickable, disabled, expandable, heading, message, href, hreflang, referrerpolicy, rel, subheading, target, fullWidth, parentIsAnchorTag, isFocussed, } = this;
        const Component = parentIsAnchorTag
            ? "div"
            : clickable
                ? this.href === undefined
                    ? "button"
                    : "a"
                : "div";
        const attrs = Component == "a" && {
            href: href,
            hrefLang: hreflang,
            referrerPolicy: referrerpolicy,
            rel: rel,
            target: target,
        };
        return (hAsync(Component, Object.assign({ class: {
                ["card"]: true,
                ["clickable"]: clickable && !disabled,
                ["disabled"]: disabled,
                ["fullwidth"]: fullWidth,
                ["focussed"]: isFocussed,
                ["dark"]: this.appearance === IcThemeForegroundEnum.Dark,
            }, tabindex: clickable && !parentIsAnchorTag ? 0 : null, "aria-disabled": disabled ? "true" : null, disabled: disabled ? true : null }, attrs), isSlotUsed(this.el, "image-top") && (hAsync("div", { class: "image-top" }, hAsync("slot", { name: "image-top" }))), hAsync("div", { class: "card-header" }, isSlotUsed(this.el, "icon") && (hAsync("div", { class: "icon" }, hAsync("slot", { name: "icon" }))), hAsync("div", { class: "card-title" }, hAsync("slot", { name: "heading" }, hAsync("ic-typography", { variant: "h4" }, hAsync("p", null, heading)))), isSlotUsed(this.el, "interaction-button") && (hAsync("div", { class: "interaction-button" }, hAsync("slot", { name: "interaction-button" })))), (subheading || isSlotUsed(this.el, "subheading")) && (hAsync("div", { class: "subheading" }, hAsync("slot", { name: "subheading" }, hAsync("ic-typography", { variant: "subtitle-small" }, subheading)))), isSlotUsed(this.el, "adornment") && (hAsync("div", { class: "adornment" }, hAsync("slot", { name: "adornment" }))), isSlotUsed(this.el, "image-mid") && (hAsync("div", { class: "image-mid" }, hAsync("slot", { name: "image-mid" }))), (message || isSlotUsed(this.el, "message")) && (hAsync("div", { class: {
                ["card-message"]: true,
            } }, message && hAsync("ic-typography", { variant: "body" }, message), isSlotUsed(this.el, "message") && hAsync("slot", { name: "message" }))), (isSlotUsed(this.el, "interaction-controls") || expandable) && (hAsync("div", { class: "interaction-area" }, hAsync("div", { class: "interaction-controls" }, hAsync("slot", { name: "interaction-controls" })), expandable && (hAsync("ic-tooltip", { id: "ic-tooltip-expand-button", label: "Toggle expandable area", silent: true }, hAsync("button", { class: {
                ["toggle-button"]: true,
                [`toggle-button-${this.areaExpanded ? "expanded" : "closed"}`]: true,
            }, "aria-label": "Toggle expandable area", "aria-expanded": `${this.areaExpanded}`, "aria-controls": this.areaExpanded ? "expanded-content-area" : null, onClick: this.toggleExpanded, innerHTML: chevronIcon }))))), isSlotUsed(this.el, "expanded-content") && this.areaExpanded && (hAsync("div", { class: "expanded-content", id: "expanded-content-area" }, hAsync("slot", { name: "expanded-content" }))), isSlotUsed(this.el, "badge") && hAsync("slot", { name: "badge" })));
    }
    get el() { return getElement(this); }
    static get style() { return icCardCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-card",
        "$members$": {
            "clickable": [1028],
            "disabled": [4],
            "expandable": [4],
            "fullWidth": [4, "full-width"],
            "heading": [1],
            "href": [1],
            "hreflang": [1],
            "message": [1],
            "referrerpolicy": [1],
            "rel": [1],
            "subheading": [1],
            "target": [1],
            "appearance": [32],
            "areaExpanded": [32],
            "isFocussed": [32],
            "parentEl": [32],
            "parentIsAnchorTag": [32],
            "setFocus": [64]
        },
        "$listeners$": [[2, "click", "handleHostClick"], [4, "themeChange", "themeChangeHandler"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icCheckboxCss = "/*!@html*/html.sc-ic-checkbox{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-checkbox{margin:0}/*!@main*/main.sc-ic-checkbox{display:block}/*!@h1*/h1.sc-ic-checkbox{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-checkbox{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-checkbox{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-checkbox{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-checkbox{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-checkbox,strong.sc-ic-checkbox{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-checkbox,kbd.sc-ic-checkbox,samp.sc-ic-checkbox{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-checkbox{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-checkbox,sup.sc-ic-checkbox{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-checkbox{bottom:-0.25em}/*!@sup*/sup.sc-ic-checkbox{top:-0.5em}/*!@img*/img.sc-ic-checkbox{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-checkbox,input.sc-ic-checkbox,optgroup.sc-ic-checkbox,select.sc-ic-checkbox,textarea.sc-ic-checkbox{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-checkbox,input.sc-ic-checkbox{overflow:visible}/*!@button,\nselect*/button.sc-ic-checkbox,select.sc-ic-checkbox{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-checkbox,[type=\"button\"].sc-ic-checkbox,[type=\"reset\"].sc-ic-checkbox,[type=\"submit\"].sc-ic-checkbox{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-checkbox::-moz-focus-inner,[type=\"button\"].sc-ic-checkbox::-moz-focus-inner,[type=\"reset\"].sc-ic-checkbox::-moz-focus-inner,[type=\"submit\"].sc-ic-checkbox::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-checkbox:-moz-focusring,[type=\"button\"].sc-ic-checkbox:-moz-focusring,[type=\"reset\"].sc-ic-checkbox:-moz-focusring,[type=\"submit\"].sc-ic-checkbox:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-checkbox{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-checkbox{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-checkbox{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-checkbox{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-checkbox,[type=\"radio\"].sc-ic-checkbox{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-checkbox::-webkit-inner-spin-button,[type=\"number\"].sc-ic-checkbox::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-checkbox{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-checkbox::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-checkbox::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-checkbox{display:block}/*!@summary*/summary.sc-ic-checkbox{display:list-item}/*!@template*/template.sc-ic-checkbox{display:none}/*!@[hidden]*/[hidden].sc-ic-checkbox{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-checkbox,body.sc-ic-checkbox,div.sc-ic-checkbox,span.sc-ic-checkbox,applet.sc-ic-checkbox,object.sc-ic-checkbox,iframe.sc-ic-checkbox,h1.sc-ic-checkbox,h2.sc-ic-checkbox,h3.sc-ic-checkbox,h4.sc-ic-checkbox,h5.sc-ic-checkbox,h6.sc-ic-checkbox,p.sc-ic-checkbox,blockquote.sc-ic-checkbox,pre.sc-ic-checkbox,a.sc-ic-checkbox,abbr.sc-ic-checkbox,acronym.sc-ic-checkbox,address.sc-ic-checkbox,big.sc-ic-checkbox,cite.sc-ic-checkbox,code.sc-ic-checkbox,del.sc-ic-checkbox,dfn.sc-ic-checkbox,em.sc-ic-checkbox,img.sc-ic-checkbox,ins.sc-ic-checkbox,kbd.sc-ic-checkbox,q.sc-ic-checkbox,s.sc-ic-checkbox,samp.sc-ic-checkbox,small.sc-ic-checkbox,strike.sc-ic-checkbox,strong.sc-ic-checkbox,sub.sc-ic-checkbox,sup.sc-ic-checkbox,tt.sc-ic-checkbox,var.sc-ic-checkbox,b.sc-ic-checkbox,u.sc-ic-checkbox,i.sc-ic-checkbox,center.sc-ic-checkbox,dl.sc-ic-checkbox,dt.sc-ic-checkbox,dd.sc-ic-checkbox,ol.sc-ic-checkbox,ul.sc-ic-checkbox,li.sc-ic-checkbox,fieldset.sc-ic-checkbox,form.sc-ic-checkbox,label.sc-ic-checkbox,legend.sc-ic-checkbox,table.sc-ic-checkbox,caption.sc-ic-checkbox,tbody.sc-ic-checkbox,tfoot.sc-ic-checkbox,thead.sc-ic-checkbox,tr.sc-ic-checkbox,th.sc-ic-checkbox,td.sc-ic-checkbox,article.sc-ic-checkbox,aside.sc-ic-checkbox,canvas.sc-ic-checkbox,details.sc-ic-checkbox,embed.sc-ic-checkbox,figure.sc-ic-checkbox,figcaption.sc-ic-checkbox,footer.sc-ic-checkbox,header.sc-ic-checkbox,hgroup.sc-ic-checkbox,menu.sc-ic-checkbox,nav.sc-ic-checkbox,output.sc-ic-checkbox,ruby.sc-ic-checkbox,section.sc-ic-checkbox,summary.sc-ic-checkbox,time.sc-ic-checkbox,mark.sc-ic-checkbox,audio.sc-ic-checkbox,video.sc-ic-checkbox{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host(.disabled)*/.disabled.sc-ic-checkbox-h{color:var(--ic-architectural-200);pointer-events:none}/*!@.container*/.container.sc-ic-checkbox{display:flex;width:-moz-fit-content;width:fit-content;padding:var(--ic-space-xxs) 0 var(--ic-space-xxs) var(--ic-space-xxs);margin-bottom:var(--ic-space-xxs);align-items:center}/*!@:host(.small) .container*/.small.sc-ic-checkbox-h .container.sc-ic-checkbox{margin-bottom:var(--ic-space-xxxs)}/*!@.checkbox*/.checkbox.sc-ic-checkbox{-webkit-appearance:none;-moz-appearance:none;appearance:none;display:block;position:relative;top:0;left:0;height:var(--ic-space-lg);width:var(--ic-space-lg);background-color:var(--ic-architectural-white);border:var(--ic-border-width) solid var(--ic-architectural-400);border-radius:var(--ic-border-radius);outline:none;cursor:pointer;transition:var(--ic-easing-transition-fast);flex-shrink:0}/*!@:host(.small) .checkbox,\n:host(.small) .container svg*/.small.sc-ic-checkbox-h .checkbox.sc-ic-checkbox,.small.sc-ic-checkbox-h .container.sc-ic-checkbox svg.sc-ic-checkbox{width:var(--ic-space-md);height:var(--ic-space-md)}/*!@:host(.large) .checkbox,\n:host(.large) .container svg*/.large.sc-ic-checkbox-h .checkbox.sc-ic-checkbox,.large.sc-ic-checkbox-h .container.sc-ic-checkbox svg.sc-ic-checkbox{width:var(--ic-space-xl);height:var(--ic-space-xl)}/*!@.checkbox:checked*/.checkbox.sc-ic-checkbox:checked{background-color:var(--ic-action-default);border:var(--ic-border-width) solid var(--ic-action-default);transition:var(--ic-easing-transition-slow)}/*!@.checkbox:checked:disabled*/.checkbox.sc-ic-checkbox:checked:disabled{background-color:var(--ic-architectural-200)}/*!@.checkbox:indeterminate,\n.checkbox.indeterminate:checked*/.checkbox.sc-ic-checkbox:indeterminate,.checkbox.indeterminate.sc-ic-checkbox:checked{background-color:var(--ic-architectural-white);border:0.125rem solid var(--ic-action-default)}/*!@.checkbox:checked:hover*/.checkbox.sc-ic-checkbox:checked:hover{background-color:var(--ic-action-default-hover)}/*!@.checkbox:indeterminate:hover,\n.checkbox.indeterminate:checked:hover*/.checkbox.sc-ic-checkbox:indeterminate:hover,.checkbox.indeterminate.sc-ic-checkbox:checked:hover{background-color:var(--ic-action-default-bg-hover-no-alpha);border:0.125rem solid var(--ic-action-default-hover)}/*!@.checkbox:checked:active*/.checkbox.sc-ic-checkbox:checked:active{background-color:var(--ic-action-default-active)}/*!@.checkbox:indeterminate:active,\n.checkbox.indeterminate:checked:active*/.checkbox.sc-ic-checkbox:indeterminate:active,.checkbox.indeterminate.sc-ic-checkbox:checked:active{background-color:var(--ic-action-default-bg-active-no-alpha);border:0.125rem solid var(--ic-action-default-active)}/*!@.checkbox:hover*/.checkbox.sc-ic-checkbox:hover{background-color:var(--ic-action-default-bg-hover-no-alpha);box-shadow:0 0 0 0.25rem var(--ic-action-default-bg-hover);border:var(--ic-border-width) solid var(--ic-action-default-hover)}/*!@.checkbox:active*/.checkbox.sc-ic-checkbox:active{background-color:var(--ic-action-default-bg-active-no-alpha);box-shadow:0 0 0 0.25rem var(--ic-action-default-bg-active);border:var(--ic-border-width) solid var(--ic-action-default-active)}/*!@.checkbox:focus*/.checkbox.sc-ic-checkbox:focus{box-shadow:var(--ic-border-focus)}/*!@.checkbox:disabled*/.checkbox.sc-ic-checkbox:disabled{border:var(--ic-border-width) dashed var(--ic-architectural-200)}/*!@.checkbox-label*/.checkbox-label.sc-ic-checkbox{padding-left:var(--ic-space-sm)}/*!@.checkbox-label:hover*/.checkbox-label.sc-ic-checkbox:hover{cursor:pointer}/*!@.checkmark*/.checkmark.sc-ic-checkbox{position:relative;right:calc(-1 * var(--ic-space-lg));margin-left:calc(-1 * var(--ic-space-lg));fill:white;z-index:1;background-color:transparent;pointer-events:none;flex-shrink:0}/*!@:host(.small) .checkmark*/.small.sc-ic-checkbox-h .checkmark.sc-ic-checkbox{margin-left:calc(-1 * var(--ic-space-md));right:calc(-1 * var(--ic-space-md))}/*!@:host(.large) .checkmark*/.large.sc-ic-checkbox-h .checkmark.sc-ic-checkbox{margin-left:calc(-1 * var(--ic-space-xl));right:calc(-1 * var(--ic-space-xl))}/*!@.indeterminate-symbol*/.indeterminate-symbol.sc-ic-checkbox{position:relative;width:0.875rem;height:var(--ic-space-xxxs);right:-1.188rem;margin-left:-0.875rem;z-index:1;background-color:var(--ic-action-default);pointer-events:none;flex-shrink:0}/*!@:host(.small) .indeterminate-symbol*/.small.sc-ic-checkbox-h .indeterminate-symbol.sc-ic-checkbox{width:0.6rem;right:-0.8rem;margin-left:-0.6rem}/*!@:host(.large) .indeterminate-symbol*/.large.sc-ic-checkbox-h .indeterminate-symbol.sc-ic-checkbox{width:1.25rem;right:-1.625rem;margin-left:-1.25rem}/*!@.container:hover .indeterminate-symbol*/.container.sc-ic-checkbox:hover .indeterminate-symbol.sc-ic-checkbox{background-color:var(--ic-action-default-hover)}/*!@.container:active .indeterminate-symbol*/.container.sc-ic-checkbox:active .indeterminate-symbol.sc-ic-checkbox{background-color:var(--ic-action-default-active)}/*!@.additional-field-wrapper*/.additional-field-wrapper.sc-ic-checkbox{margin-left:calc(var(--ic-space-md) + var(--ic-space-lg));margin-top:calc(var(--ic-space-sm) / 2)}/*!@.branch-corner*/.branch-corner.sc-ic-checkbox{color:var(--ic-action-default);height:var(--ic-space-md);width:var(--ic-space-xl);border-radius:0 0 0 0.188rem;border-bottom:0.125rem solid var(--ic-action-default);border-left:0.125rem solid var(--ic-action-default)}/*!@.dynamic-container*/.dynamic-container.sc-ic-checkbox{display:flex;position:relative;margin:var(--ic-space-xxxs) 0 var(--ic-space-xxs) var(--ic-space-md);gap:var(--ic-space-xs)}/*!@.dynamic-text*/.dynamic-text.sc-ic-checkbox{color:var(--ic-action-default);margin-top:calc(var(--ic-space-sm) / 2);margin-bottom:var(--ic-space-xs);border-radius:2%}@media (max-width: 576px){/*!@::slotted(ic-text-field)*/.sc-ic-checkbox-s>ic-text-field{--input-width:100%}}@media (forced-colors: active){/*!@.checkbox*/.checkbox.sc-ic-checkbox{-webkit-appearance:revert;-moz-appearance:revert;appearance:revert;transition:none}/*!@.checkbox:checked*/.checkbox.sc-ic-checkbox:checked{transition:none}/*!@.checkbox:focus-visible*/.checkbox.sc-ic-checkbox:focus-visible{outline:0.125rem solid highlight}/*!@.checkbox:disabled:not(:checked)*/.checkbox.sc-ic-checkbox:disabled:not(:checked){-webkit-appearance:none;-moz-appearance:none;appearance:none;border-color:GrayText}/*!@.checkmark*/.checkmark.sc-ic-checkbox{fill:none}/*!@.indeterminate-symbol*/.indeterminate-symbol.sc-ic-checkbox{display:none}}";

/**
 * @slot additional-field - Content to be displayed alongside a checkbox.
 */
// eslint-disable-next-line @typescript-eslint/no-unused-vars
class Checkbox {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.checkboxChecked = createEvent(this, "checkboxChecked", 7);
        this.icCheck = createEvent(this, "icCheck", 7);
        this.handleClick = () => {
            this.checked = !this.checked;
            this.displayIndeterminate = this.nativeIndeterminateBehaviour
                ? false
                : this.indeterminate && this.checked;
            this.icCheck.emit();
            this.checkboxChecked.emit();
        };
        this.handleFormReset = () => {
            this.checked = this.initiallyChecked;
        };
        this.additionalFieldDisplay = "static";
        this.checked = false;
        this.initiallyChecked = this.checked;
        this.disabled = false;
        this.dynamicText = "This selection requires additional answers";
        this.form = undefined;
        this.formaction = undefined;
        this.formenctype = undefined;
        this.formmethod = undefined;
        this.formnovalidate = undefined;
        this.formtarget = undefined;
        this.groupLabel = undefined;
        this.indeterminate = false;
        this.displayIndeterminate = this.indeterminate;
        this.label = undefined;
        this.name = undefined;
        this.nativeIndeterminateBehaviour = false;
        this.size = undefined;
        this.small = false;
        this.value = undefined;
        this.hideLabel = false;
    }
    watchIndeterminateHandler() {
        this.displayIndeterminate = this.nativeIndeterminateBehaviour
            ? this.indeterminate
            : this.indeterminate && this.checked;
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
        addFormResetListener(this.el, this.handleFormReset);
        const checkboxGroup = this.el.parentElement;
        if (checkboxGroup) {
            if (!this.name)
                this.name = checkboxGroup.name;
            this.groupLabel = checkboxGroup.label;
        }
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([
            { prop: this.label, propName: "label" },
            { prop: this.value, propName: "value" },
        ], "Checkbox");
    }
    componentDidRender() {
        if (this.additionalFieldDisplay === "static") {
            const textfield = this.el.querySelector("ic-text-field");
            if (!this.checked) {
                textfield === null || textfield === void 0 ? void 0 : textfield.setAttribute("disabled", "");
            }
            else {
                textfield === null || textfield === void 0 ? void 0 : textfield.removeAttribute("disabled");
            }
        }
        else if (this.additionalFieldContainer) {
            this.additionalFieldContainer.style.display = !this.checked
                ? "none"
                : "flex";
        }
    }
    disconnectedCallback() {
        removeFormResetListener(this.el, this.handleFormReset);
    }
    /**
     * Sets focus on the checkbox.
     */
    async setFocus() {
        var _a;
        (_a = this.el.shadowRoot.querySelector(".checkbox")) === null || _a === void 0 ? void 0 : _a.focus();
    }
    render() {
        const { additionalFieldDisplay, checked, disabled, dynamicText, el, form, formaction, formenctype, formmethod, formnovalidate, formtarget, displayIndeterminate, groupLabel, label, name, size, small, value, } = this;
        const id = `ic-checkbox-${isPropDefined(label) || value}-${groupLabel}`.replace(/ /g, "-");
        const parentElementSize = el.parentElement
            .size;
        checked
            ? renderHiddenInput(true, el, name, checked && value, disabled)
            : removeHiddenInput(el);
        return (hAsync(Host, { class: {
                disabled,
                small,
                [`${size || parentElementSize}`]: true,
            } }, hAsync("div", { class: "container" }, displayIndeterminate && hAsync("div", { class: "indeterminate-symbol" }), !displayIndeterminate && checked && (hAsync("svg", { class: "checkmark", width: "1.5rem", height: "1.5rem", viewBox: "0 0 24 24", xmlns: "http://www.w3.org/2000/svg", "fill-rule": "evenodd", "clip-rule": "evenodd" }, hAsync("title", null, "checkmark icon"), hAsync("path", { d: "M21 6.285l-11.16 12.733-6.84-6.018 1.319-1.49 5.341 4.686 9.865-11.196 1.475 1.285z" }))), hAsync("input", { role: "checkbox", class: {
                checkbox: true,
                checked,
                indeterminate: displayIndeterminate,
            }, type: "checkbox", name: name, id: id, value: value, disabled: disabled ? true : null, checked: checked, indeterminate: displayIndeterminate, onClick: this.handleClick, form: form, formaction: formaction, formenctype: formenctype, formmethod: formmethod, formnovalidate: formnovalidate, formtarget: formtarget, "aria-label": this.hideLabel ? this.label : undefined }), !this.hideLabel && (hAsync("ic-typography", { class: "checkbox-label", variant: "body" }, hAsync("label", { htmlFor: id }, label)))), isSlotUsed(el, "additional-field") && (hAsync("div", { class: "dynamic-container", ref: (el) => (this.additionalFieldContainer = el) }, additionalFieldDisplay === "dynamic" && (hAsync("div", { class: "branch-corner" })), hAsync("div", null, additionalFieldDisplay === "dynamic" && (hAsync("ic-typography", { variant: "caption" }, hAsync("p", { class: "dynamic-text", "aria-live": "polite" }, dynamicText))), hAsync("div", { class: {
                "additional-field-wrapper": additionalFieldDisplay === "static",
            } }, hAsync("slot", { name: "additional-field" })))))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get watchers() { return {
        "indeterminate": ["watchIndeterminateHandler"]
    }; }
    static get style() { return icCheckboxCss; }
    static get cmpMeta() { return {
        "$flags$": 25,
        "$tagName$": "ic-checkbox",
        "$members$": {
            "additionalFieldDisplay": [513, "additional-field-display"],
            "checked": [1540],
            "disabled": [4],
            "dynamicText": [1, "dynamic-text"],
            "form": [1],
            "formaction": [1],
            "formenctype": [1],
            "formmethod": [1],
            "formnovalidate": [4],
            "formtarget": [1],
            "groupLabel": [1025, "group-label"],
            "indeterminate": [4],
            "label": [1],
            "name": [1025],
            "nativeIndeterminateBehaviour": [4, "native-indeterminate-behaviour"],
            "size": [1],
            "small": [4],
            "value": [1],
            "hideLabel": [4, "hide-label"],
            "initiallyChecked": [32],
            "displayIndeterminate": [32],
            "setFocus": [64]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": [["additionalFieldDisplay", "additional-field-display"], ["checked", "checked"]]
    }; }
}

const icCheckboxGroupCss = "/*!@html*/html.sc-ic-checkbox-group{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-checkbox-group{margin:0}/*!@main*/main.sc-ic-checkbox-group{display:block}/*!@h1*/h1.sc-ic-checkbox-group{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-checkbox-group{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-checkbox-group{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-checkbox-group{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-checkbox-group{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-checkbox-group,strong.sc-ic-checkbox-group{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-checkbox-group,kbd.sc-ic-checkbox-group,samp.sc-ic-checkbox-group{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-checkbox-group{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-checkbox-group,sup.sc-ic-checkbox-group{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-checkbox-group{bottom:-0.25em}/*!@sup*/sup.sc-ic-checkbox-group{top:-0.5em}/*!@img*/img.sc-ic-checkbox-group{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-checkbox-group,input.sc-ic-checkbox-group,optgroup.sc-ic-checkbox-group,select.sc-ic-checkbox-group,textarea.sc-ic-checkbox-group{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-checkbox-group,input.sc-ic-checkbox-group{overflow:visible}/*!@button,\nselect*/button.sc-ic-checkbox-group,select.sc-ic-checkbox-group{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-checkbox-group,[type=\"button\"].sc-ic-checkbox-group,[type=\"reset\"].sc-ic-checkbox-group,[type=\"submit\"].sc-ic-checkbox-group{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-checkbox-group::-moz-focus-inner,[type=\"button\"].sc-ic-checkbox-group::-moz-focus-inner,[type=\"reset\"].sc-ic-checkbox-group::-moz-focus-inner,[type=\"submit\"].sc-ic-checkbox-group::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-checkbox-group:-moz-focusring,[type=\"button\"].sc-ic-checkbox-group:-moz-focusring,[type=\"reset\"].sc-ic-checkbox-group:-moz-focusring,[type=\"submit\"].sc-ic-checkbox-group:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-checkbox-group{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-checkbox-group{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-checkbox-group{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-checkbox-group{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-checkbox-group,[type=\"radio\"].sc-ic-checkbox-group{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-checkbox-group::-webkit-inner-spin-button,[type=\"number\"].sc-ic-checkbox-group::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-checkbox-group{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-checkbox-group::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-checkbox-group::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-checkbox-group{display:block}/*!@summary*/summary.sc-ic-checkbox-group{display:list-item}/*!@template*/template.sc-ic-checkbox-group{display:none}/*!@[hidden]*/[hidden].sc-ic-checkbox-group{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-checkbox-group,body.sc-ic-checkbox-group,div.sc-ic-checkbox-group,span.sc-ic-checkbox-group,applet.sc-ic-checkbox-group,object.sc-ic-checkbox-group,iframe.sc-ic-checkbox-group,h1.sc-ic-checkbox-group,h2.sc-ic-checkbox-group,h3.sc-ic-checkbox-group,h4.sc-ic-checkbox-group,h5.sc-ic-checkbox-group,h6.sc-ic-checkbox-group,p.sc-ic-checkbox-group,blockquote.sc-ic-checkbox-group,pre.sc-ic-checkbox-group,a.sc-ic-checkbox-group,abbr.sc-ic-checkbox-group,acronym.sc-ic-checkbox-group,address.sc-ic-checkbox-group,big.sc-ic-checkbox-group,cite.sc-ic-checkbox-group,code.sc-ic-checkbox-group,del.sc-ic-checkbox-group,dfn.sc-ic-checkbox-group,em.sc-ic-checkbox-group,img.sc-ic-checkbox-group,ins.sc-ic-checkbox-group,kbd.sc-ic-checkbox-group,q.sc-ic-checkbox-group,s.sc-ic-checkbox-group,samp.sc-ic-checkbox-group,small.sc-ic-checkbox-group,strike.sc-ic-checkbox-group,strong.sc-ic-checkbox-group,sub.sc-ic-checkbox-group,sup.sc-ic-checkbox-group,tt.sc-ic-checkbox-group,var.sc-ic-checkbox-group,b.sc-ic-checkbox-group,u.sc-ic-checkbox-group,i.sc-ic-checkbox-group,center.sc-ic-checkbox-group,dl.sc-ic-checkbox-group,dt.sc-ic-checkbox-group,dd.sc-ic-checkbox-group,ol.sc-ic-checkbox-group,ul.sc-ic-checkbox-group,li.sc-ic-checkbox-group,fieldset.sc-ic-checkbox-group,form.sc-ic-checkbox-group,label.sc-ic-checkbox-group,legend.sc-ic-checkbox-group,table.sc-ic-checkbox-group,caption.sc-ic-checkbox-group,tbody.sc-ic-checkbox-group,tfoot.sc-ic-checkbox-group,thead.sc-ic-checkbox-group,tr.sc-ic-checkbox-group,th.sc-ic-checkbox-group,td.sc-ic-checkbox-group,article.sc-ic-checkbox-group,aside.sc-ic-checkbox-group,canvas.sc-ic-checkbox-group,details.sc-ic-checkbox-group,embed.sc-ic-checkbox-group,figure.sc-ic-checkbox-group,figcaption.sc-ic-checkbox-group,footer.sc-ic-checkbox-group,header.sc-ic-checkbox-group,hgroup.sc-ic-checkbox-group,menu.sc-ic-checkbox-group,nav.sc-ic-checkbox-group,output.sc-ic-checkbox-group,ruby.sc-ic-checkbox-group,section.sc-ic-checkbox-group,summary.sc-ic-checkbox-group,time.sc-ic-checkbox-group,mark.sc-ic-checkbox-group,audio.sc-ic-checkbox-group,video.sc-ic-checkbox-group{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-checkbox-group-h{display:block}/*!@ic-input-label.error*/ic-input-label.error.sc-ic-checkbox-group{color:var(--ic-status-error)}/*!@ic-input-label ic-typography*/ic-input-label.sc-ic-checkbox-group ic-typography.sc-ic-checkbox-group{margin-bottom:var(--ic-space-sm)}/*!@:host(.small) ic-input-label ic-typography*/.small.sc-ic-checkbox-group-h ic-input-label.sc-ic-checkbox-group ic-typography.sc-ic-checkbox-group{margin-bottom:calc(var(--ic-space-sm) / 2)}/*!@ic-input-validation*/ic-input-validation.sc-ic-checkbox-group{margin-top:var(--ic-space-sm)}/*!@:host(.small) ic-input-validation*/.small.sc-ic-checkbox-group-h ic-input-validation.sc-ic-checkbox-group{margin-top:calc(var(--ic-space-sm) / 2)}/*!@.checkboxes-container*/.checkboxes-container.sc-ic-checkbox-group{margin-bottom:calc(-1 * var(--ic-space-xxs))}/*!@:host(.small) .checkboxes-container*/.small.sc-ic-checkbox-group-h .checkboxes-container.sc-ic-checkbox-group{margin-bottom:calc(-1 * var(--ic-space-xxxs))}/*!@.screen-reader-only-text*/.screen-reader-only-text.sc-ic-checkbox-group{position:absolute;left:-9999px;background-color:#fff;color:#000;text-transform:none}";

// eslint-disable-next-line @typescript-eslint/no-unused-vars
class CheckboxGroup {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.icChange = createEvent(this, "icChange", 7);
        this.disabled = false;
        this.helperText = "";
        this.hideLabel = false;
        this.label = undefined;
        this.name = undefined;
        this.required = false;
        this.size = "default";
        this.small = false;
        this.validationStatus = "";
        this.validationText = "";
    }
    labelNameHandler(newValue, oldValue, propName) {
        Array.from(this.el.querySelectorAll("ic-checkbox")).forEach((checkbox) => {
            if (propName === "label")
                checkbox.groupLabel = newValue;
            else if (checkbox.name === oldValue) {
                // If the checkbox name has been set by the parent, then override it
                checkbox.name = newValue;
            }
        });
    }
    handleChange(ev) {
        //don't pass on the event if it has come from slotted text field
        //otherwise any icChange handler bound to the checkbox group will also run
        if (ev.target.tagName === "IC-TEXT-FIELD") {
            ev.stopImmediatePropagation();
        }
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([
            { prop: this.label, propName: "label" },
            { prop: this.name, propName: "name" },
        ], "Checkbox Group");
    }
    selectHandler({ target }) {
        const checkedOptions = Array.from(this.el.querySelectorAll("ic-checkbox")).filter(({ checked, disabled }) => checked && !disabled);
        this.icChange.emit({
            value: checkedOptions.map(({ value }) => value),
            checkedOptions: checkedOptions.map((opt) => {
                var _a;
                return ({
                    checkbox: opt,
                    textFieldValue: (_a = opt.querySelector("ic-text-field")) === null || _a === void 0 ? void 0 : _a.value,
                });
            }),
            selectedOption: target,
        });
    }
    render() {
        const { disabled, helperText, hideLabel, label, name, required, size, small, validationStatus, validationText, } = this;
        const describedBy = getInputDescribedByText(name, helperText !== "", validationStatus !== "");
        return (hAsync(Host, { class: { ["small"]: small, [`${size}`]: true } }, (validationStatus === "error" || required || hideLabel) && (hAsync("span", { id: "screenReaderOnlyText", class: "screen-reader-only-text", "aria-hidden": "true" }, label, " ", validationStatus === "error" ? "invalid data " : null, " ", required ? "required" : null)), hAsync("fieldset", { id: name, "aria-labelledby": `${validationStatus === "error" || required || hideLabel
                ? "screenReaderOnlyText"
                : ""} ${describedBy}`.trim(), disabled: disabled }, !hideLabel && (hAsync("legend", null, hAsync("ic-input-label", { class: { [`${validationStatus}`]: true }, label: label, helperText: helperText, required: required, disabled: disabled, for: name }))), hAsync("div", { class: "checkboxes-container" }, hAsync("slot", null))), hasValidationStatus(validationStatus, disabled) && (hAsync("ic-input-validation", { for: name, ariaLiveMode: "polite", status: validationStatus, message: validationText }))));
    }
    get el() { return getElement(this); }
    static get watchers() { return {
        "label": ["labelNameHandler"],
        "name": ["labelNameHandler"]
    }; }
    static get style() { return icCheckboxGroupCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-checkbox-group",
        "$members$": {
            "disabled": [4],
            "helperText": [1, "helper-text"],
            "hideLabel": [4, "hide-label"],
            "label": [1],
            "name": [1],
            "required": [4],
            "size": [1],
            "small": [4],
            "validationStatus": [1, "validation-status"],
            "validationText": [1, "validation-text"]
        },
        "$listeners$": [[0, "icChange", "handleChange"], [0, "icCheck", "selectHandler"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

var dismissIcon = `<svg viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 0C4.47 0 0 4.47 0 10C0 15.53 4.47 20 10 20C15.53 20 20 15.53 20 10C20 4.47 15.53 0 10 0ZM15 13.59L13.59 15L10 11.41L6.41 15L5 13.59L8.59 10L5 6.41L6.41 5L10 8.59L13.59 5L15 6.41L11.41 10L15 13.59Z" fill="currentColor"/>
</svg>
`;

const icChipCss = "/*!@html*/html.sc-ic-chip{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-chip{margin:0}/*!@main*/main.sc-ic-chip{display:block}/*!@h1*/h1.sc-ic-chip{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-chip{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-chip{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-chip{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-chip{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-chip,strong.sc-ic-chip{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-chip,kbd.sc-ic-chip,samp.sc-ic-chip{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-chip{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-chip,sup.sc-ic-chip{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-chip{bottom:-0.25em}/*!@sup*/sup.sc-ic-chip{top:-0.5em}/*!@img*/img.sc-ic-chip{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-chip,input.sc-ic-chip,optgroup.sc-ic-chip,select.sc-ic-chip,textarea.sc-ic-chip{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-chip,input.sc-ic-chip{overflow:visible}/*!@button,\nselect*/button.sc-ic-chip,select.sc-ic-chip{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-chip,[type=\"button\"].sc-ic-chip,[type=\"reset\"].sc-ic-chip,[type=\"submit\"].sc-ic-chip{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-chip::-moz-focus-inner,[type=\"button\"].sc-ic-chip::-moz-focus-inner,[type=\"reset\"].sc-ic-chip::-moz-focus-inner,[type=\"submit\"].sc-ic-chip::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-chip:-moz-focusring,[type=\"button\"].sc-ic-chip:-moz-focusring,[type=\"reset\"].sc-ic-chip:-moz-focusring,[type=\"submit\"].sc-ic-chip:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-chip{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-chip{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-chip{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-chip{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-chip,[type=\"radio\"].sc-ic-chip{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-chip::-webkit-inner-spin-button,[type=\"number\"].sc-ic-chip::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-chip{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-chip::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-chip::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-chip{display:block}/*!@summary*/summary.sc-ic-chip{display:list-item}/*!@template*/template.sc-ic-chip{display:none}/*!@[hidden]*/[hidden].sc-ic-chip{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-chip,body.sc-ic-chip,div.sc-ic-chip,span.sc-ic-chip,applet.sc-ic-chip,object.sc-ic-chip,iframe.sc-ic-chip,h1.sc-ic-chip,h2.sc-ic-chip,h3.sc-ic-chip,h4.sc-ic-chip,h5.sc-ic-chip,h6.sc-ic-chip,p.sc-ic-chip,blockquote.sc-ic-chip,pre.sc-ic-chip,a.sc-ic-chip,abbr.sc-ic-chip,acronym.sc-ic-chip,address.sc-ic-chip,big.sc-ic-chip,cite.sc-ic-chip,code.sc-ic-chip,del.sc-ic-chip,dfn.sc-ic-chip,em.sc-ic-chip,img.sc-ic-chip,ins.sc-ic-chip,kbd.sc-ic-chip,q.sc-ic-chip,s.sc-ic-chip,samp.sc-ic-chip,small.sc-ic-chip,strike.sc-ic-chip,strong.sc-ic-chip,sub.sc-ic-chip,sup.sc-ic-chip,tt.sc-ic-chip,var.sc-ic-chip,b.sc-ic-chip,u.sc-ic-chip,i.sc-ic-chip,center.sc-ic-chip,dl.sc-ic-chip,dt.sc-ic-chip,dd.sc-ic-chip,ol.sc-ic-chip,ul.sc-ic-chip,li.sc-ic-chip,fieldset.sc-ic-chip,form.sc-ic-chip,label.sc-ic-chip,legend.sc-ic-chip,table.sc-ic-chip,caption.sc-ic-chip,tbody.sc-ic-chip,tfoot.sc-ic-chip,thead.sc-ic-chip,tr.sc-ic-chip,th.sc-ic-chip,td.sc-ic-chip,article.sc-ic-chip,aside.sc-ic-chip,canvas.sc-ic-chip,details.sc-ic-chip,embed.sc-ic-chip,figure.sc-ic-chip,figcaption.sc-ic-chip,footer.sc-ic-chip,header.sc-ic-chip,hgroup.sc-ic-chip,menu.sc-ic-chip,nav.sc-ic-chip,output.sc-ic-chip,ruby.sc-ic-chip,section.sc-ic-chip,summary.sc-ic-chip,time.sc-ic-chip,mark.sc-ic-chip,audio.sc-ic-chip,video.sc-ic-chip{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-chip-h{display:inline-block;max-width:100%}/*!@.chip*/.chip.sc-ic-chip{display:flex;padding:var(--ic-space-xxs);font-size:0.875rem;border-radius:var(--ic-space-md);text-align:left;text-decoration:none;transition:var(--ic-easing-transition-fast);position:relative}/*!@.chip.small*/.chip.small.sc-ic-chip{padding:var(--ic-space-xxxs);border-radius:calc(var(--ic-space-md) - var(--ic-space-xxxs))}/*!@.chip.large*/.chip.large.sc-ic-chip{padding:var(--ic-space-xs);border-radius:calc(var(--ic-space-md) + var(--ic-space-xxs))}/*!@.label*/.label.sc-ic-chip{padding:0 var(--ic-space-xs)}/*!@.chip.hovered:not(:focus-within)*/.chip.hovered.sc-ic-chip:not(:focus-within){background-color:var(--ic-architectural-300)}/*!@.chip:focus-within*/.chip.sc-ic-chip:focus-within{box-shadow:var(--ic-border-focus);outline:var(--ic-hc-focus-outline);z-index:1}/*!@.chip.outline.hovered:not(:focus-within),\n.chip.outlined.hovered:not(:focus-within)*/.chip.outline.hovered.sc-ic-chip:not(:focus-within),.chip.outlined.hovered.sc-ic-chip:not(:focus-within){background-color:var(--ic-action-dark-bg-hover)}/*!@ic-tooltip:focus-within*/ic-tooltip.sc-ic-chip:focus-within{z-index:1}/*!@.filled*/.filled.sc-ic-chip{background-color:var(--chip-custom-color, var(--ic-architectural-200));color:var(--chip-custom-foreground-color, black);border:none}/*!@.filled.disabled*/.filled.disabled.sc-ic-chip{background-color:var(--ic-architectural-100)}/*!@.outline,\n.outlined*/.outline.sc-ic-chip,.outlined.sc-ic-chip{color:var(--ic-architectural-900);border:var(--ic-border-width) solid\n    var(--chip-custom-color, var(--ic-architectural-900));padding:calc(var(--ic-space-xxs) - var(--ic-space-1px))}/*!@.outline.small,\n.outlined.small*/.outline.small.sc-ic-chip,.outlined.small.sc-ic-chip{padding:calc(var(--ic-space-xxxs) - var(--ic-space-1px))}/*!@.outline.large,\n.outlined.large*/.outline.large.sc-ic-chip,.outlined.large.sc-ic-chip{padding:calc(var(--ic-space-xs) - var(--ic-space-1px))}/*!@.outline.disabled,\n.outlined.disabled*/.outline.disabled.sc-ic-chip,.outlined.disabled.sc-ic-chip{border:var(--ic-border-disabled);background:none}/*!@.chip.disabled ic-typography*/.chip.disabled.sc-ic-chip ic-typography.sc-ic-chip{color:var(--ic-architectural-500)}/*!@.filled.disabled ic-typography*/.filled.disabled.sc-ic-chip ic-typography.sc-ic-chip{color:var(--ic-architectural-600)}/*!@.dismiss-icon*/.dismiss-icon.sc-ic-chip{border:none;border-radius:50%;padding:0;background:none;cursor:pointer;margin:var(--ic-space-xxxs);height:calc(var(--ic-space-lg) - var(--ic-space-xxs));width:calc(var(--ic-space-lg) - var(--ic-space-xxs))}/*!@.dismiss-icon:focus*/.dismiss-icon.sc-ic-chip:focus{outline:var(--ic-hc-focus-outline)}/*!@.dismiss-icon[disabled]*/.dismiss-icon[disabled].sc-ic-chip{pointer-events:none;color:var(--ic-architectural-200)}/*!@.icon*/.icon.sc-ic-chip{padding:var(--ic-space-xxxs);box-sizing:border-box}/*!@.icon,\nic-tooltip*/.icon.sc-ic-chip,ic-tooltip.sc-ic-chip{width:var(--ic-space-lg);height:var(--ic-space-lg)}/*!@.chip.disabled path,\n.chip.disabled ::slotted(svg)*/.chip.disabled.sc-ic-chip path.sc-ic-chip,.chip.disabled.sc-ic-chip-s>svg,.chip.disabled .sc-ic-chip-s>svg{fill:var(--ic-architectural-200)}/*!@.chip.white-background*/.chip.white-background.sc-ic-chip{background-color:var(--ic-architectural-white)}/*!@.chip.white-background.hovered:not(:focus-within)*/.chip.white-background.hovered.sc-ic-chip:not(:focus-within){background-color:var(--ic-action-dark-bg-hover-no-alpha) !important}@media (forced-colors: active){/*!@.chip*/.chip.sc-ic-chip{border:var(--ic-hc-border)}/*!@.filled.small*/.filled.small.sc-ic-chip{padding:calc(var(--ic-space-xxxs) - var(--ic-space-1px))}/*!@.filled*/.filled.sc-ic-chip{padding:calc(var(--ic-space-xxxs) + var(--ic-space-1px))}/*!@.filled.large*/.filled.large.sc-ic-chip{padding:calc(var(--ic-space-xs) - var(--ic-space-1px))}/*!@.chip.disabled*/.chip.disabled.sc-ic-chip{-webkit-appearance:none;-moz-appearance:none;appearance:none;border-color:GrayText}/*!@.chip.disabled ic-typography*/.chip.disabled.sc-ic-chip ic-typography.sc-ic-chip{color:GrayText}/*!@.chip.disabled path,\n  .chip.disabled ::slotted(svg)*/.chip.disabled.sc-ic-chip path.sc-ic-chip,.chip.disabled.sc-ic-chip-s>svg,.chip.disabled .sc-ic-chip-s>svg{fill:GrayText}/*!@.chip:focus-within*/.chip.sc-ic-chip:focus-within{outline:none;border-color:Highlight}}";

/**
 * @slot icon - Content will be rendered at the start of the chip.
 * @slot badge - Badge component overlaying the top right of the chip.
 */
class Chip {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.dismiss = createEvent(this, "dismiss", 7);
        this.icDismiss = createEvent(this, "icDismiss", 7);
        this.inAGGrid = false;
        this.dismissAction = () => {
            this.dismiss.emit();
            this.icDismiss.emit();
        };
        this.mouseEnterHandler = () => {
            this.hovered = true;
        };
        this.mouseLeaveHandler = () => {
            this.hovered = false;
        };
        this.setChipColour = () => {
            const colorRGBA = convertToRGBA(this.customColor);
            if (colorRGBA) {
                const { r, g, b, a } = colorRGBA;
                const foregroundColour = (r * 299 + g * 587 + b * 114) / 1000 > 133.3505 ? "black" : "white";
                this.el.setAttribute("style", `--chip-custom-color: rgba(${r}, ${g}, ${b}, ${a}); --chip-custom-foreground-color: var(--ic-architectural-${foregroundColour})`);
            }
        };
        this.hovered = false;
        this.visible = true;
        this.appearance = undefined;
        this.customColor = null;
        this.disabled = false;
        this.dismissible = false;
        this.label = undefined;
        this.size = "default";
        this.transparentBackground = true;
        this.variant = "filled";
    }
    customColorHandler() {
        if (!this.dismissible) {
            this.setChipColour();
        }
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
        if (!this.dismissible) {
            this.setChipColour();
        }
        if (this.appearance === "outline") {
            this.variant = "outlined";
        }
    }
    componentWillRender() {
        if (isElInAGGrid(this.el)) {
            this.inAGGrid = true;
        }
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Chip");
    }
    handleClick() {
        this.visible = !this.visible;
    }
    /**
     * Sets focus on the chip.
     */
    async setFocus() {
        var _a;
        (_a = this.el.shadowRoot.querySelector("button")) === null || _a === void 0 ? void 0 : _a.focus();
    }
    render() {
        const { label, appearance, variant, size, dismissible, visible, disabled, hovered, } = this;
        return (visible && (hAsync("div", { class: {
                chip: true,
                [`${appearance}`]: appearance !== undefined,
                [`${variant}`]: true,
                [`${size}`]: true,
                disabled,
                dismissible,
                hovered,
                "white-background": this.variant === "outlined" && !this.transparentBackground,
            } }, isSlotUsed(this.el, "icon") && (hAsync("div", { class: "icon" }, hAsync("slot", { name: "icon" }))), hAsync("ic-typography", { variant: "label", "apply-vertical-margins": false, class: { label: true, "in-ag-grid": this.inAGGrid } }, hAsync("span", null, label)), dismissible && (hAsync("ic-tooltip", { label: "Dismiss", target: "dismiss-icon", class: { "tooltip-disabled": disabled } }, hAsync("button", { id: "dismiss-icon", class: "dismiss-icon", "aria-label": `Dismiss ${label} chip`, disabled: disabled, tabindex: disabled ? -1 : 0, onClick: this.dismissAction, onMouseEnter: this.mouseEnterHandler, onMouseLeave: this.mouseLeaveHandler, innerHTML: dismissIcon }))), isSlotUsed(this.el, "badge") && hAsync("slot", { name: "badge" }))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get watchers() { return {
        "customColor": ["customColorHandler"]
    }; }
    static get style() { return icChipCss; }
    static get cmpMeta() { return {
        "$flags$": 25,
        "$tagName$": "ic-chip",
        "$members$": {
            "appearance": [1],
            "customColor": [1, "custom-color"],
            "disabled": [4],
            "dismissible": [4],
            "label": [1],
            "size": [1],
            "transparentBackground": [4, "transparent-background"],
            "variant": [1],
            "hovered": [32],
            "visible": [32],
            "setFocus": [64]
        },
        "$listeners$": [[2, "icDismiss", "handleClick"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icClassificationBannerCss = "/*!@html*/html.sc-ic-classification-banner{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-classification-banner{margin:0}/*!@main*/main.sc-ic-classification-banner{display:block}/*!@h1*/h1.sc-ic-classification-banner{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-classification-banner{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-classification-banner{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-classification-banner{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-classification-banner{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-classification-banner,strong.sc-ic-classification-banner{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-classification-banner,kbd.sc-ic-classification-banner,samp.sc-ic-classification-banner{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-classification-banner{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-classification-banner,sup.sc-ic-classification-banner{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-classification-banner{bottom:-0.25em}/*!@sup*/sup.sc-ic-classification-banner{top:-0.5em}/*!@img*/img.sc-ic-classification-banner{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-classification-banner,input.sc-ic-classification-banner,optgroup.sc-ic-classification-banner,select.sc-ic-classification-banner,textarea.sc-ic-classification-banner{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-classification-banner,input.sc-ic-classification-banner{overflow:visible}/*!@button,\nselect*/button.sc-ic-classification-banner,select.sc-ic-classification-banner{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-classification-banner,[type=\"button\"].sc-ic-classification-banner,[type=\"reset\"].sc-ic-classification-banner,[type=\"submit\"].sc-ic-classification-banner{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-classification-banner::-moz-focus-inner,[type=\"button\"].sc-ic-classification-banner::-moz-focus-inner,[type=\"reset\"].sc-ic-classification-banner::-moz-focus-inner,[type=\"submit\"].sc-ic-classification-banner::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-classification-banner:-moz-focusring,[type=\"button\"].sc-ic-classification-banner:-moz-focusring,[type=\"reset\"].sc-ic-classification-banner:-moz-focusring,[type=\"submit\"].sc-ic-classification-banner:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-classification-banner{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-classification-banner{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-classification-banner{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-classification-banner{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-classification-banner,[type=\"radio\"].sc-ic-classification-banner{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-classification-banner::-webkit-inner-spin-button,[type=\"number\"].sc-ic-classification-banner::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-classification-banner{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-classification-banner::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-classification-banner::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-classification-banner{display:block}/*!@summary*/summary.sc-ic-classification-banner{display:list-item}/*!@template*/template.sc-ic-classification-banner{display:none}/*!@[hidden]*/[hidden].sc-ic-classification-banner{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-classification-banner,body.sc-ic-classification-banner,div.sc-ic-classification-banner,span.sc-ic-classification-banner,applet.sc-ic-classification-banner,object.sc-ic-classification-banner,iframe.sc-ic-classification-banner,h1.sc-ic-classification-banner,h2.sc-ic-classification-banner,h3.sc-ic-classification-banner,h4.sc-ic-classification-banner,h5.sc-ic-classification-banner,h6.sc-ic-classification-banner,p.sc-ic-classification-banner,blockquote.sc-ic-classification-banner,pre.sc-ic-classification-banner,a.sc-ic-classification-banner,abbr.sc-ic-classification-banner,acronym.sc-ic-classification-banner,address.sc-ic-classification-banner,big.sc-ic-classification-banner,cite.sc-ic-classification-banner,code.sc-ic-classification-banner,del.sc-ic-classification-banner,dfn.sc-ic-classification-banner,em.sc-ic-classification-banner,img.sc-ic-classification-banner,ins.sc-ic-classification-banner,kbd.sc-ic-classification-banner,q.sc-ic-classification-banner,s.sc-ic-classification-banner,samp.sc-ic-classification-banner,small.sc-ic-classification-banner,strike.sc-ic-classification-banner,strong.sc-ic-classification-banner,sub.sc-ic-classification-banner,sup.sc-ic-classification-banner,tt.sc-ic-classification-banner,var.sc-ic-classification-banner,b.sc-ic-classification-banner,u.sc-ic-classification-banner,i.sc-ic-classification-banner,center.sc-ic-classification-banner,dl.sc-ic-classification-banner,dt.sc-ic-classification-banner,dd.sc-ic-classification-banner,ol.sc-ic-classification-banner,ul.sc-ic-classification-banner,li.sc-ic-classification-banner,fieldset.sc-ic-classification-banner,form.sc-ic-classification-banner,label.sc-ic-classification-banner,legend.sc-ic-classification-banner,table.sc-ic-classification-banner,caption.sc-ic-classification-banner,tbody.sc-ic-classification-banner,tfoot.sc-ic-classification-banner,thead.sc-ic-classification-banner,tr.sc-ic-classification-banner,th.sc-ic-classification-banner,td.sc-ic-classification-banner,article.sc-ic-classification-banner,aside.sc-ic-classification-banner,canvas.sc-ic-classification-banner,details.sc-ic-classification-banner,embed.sc-ic-classification-banner,figure.sc-ic-classification-banner,figcaption.sc-ic-classification-banner,footer.sc-ic-classification-banner,header.sc-ic-classification-banner,hgroup.sc-ic-classification-banner,menu.sc-ic-classification-banner,nav.sc-ic-classification-banner,output.sc-ic-classification-banner,ruby.sc-ic-classification-banner,section.sc-ic-classification-banner,summary.sc-ic-classification-banner,time.sc-ic-classification-banner,mark.sc-ic-classification-banner,audio.sc-ic-classification-banner,video.sc-ic-classification-banner{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-classification-banner-h{position:fixed;left:0;bottom:0;width:100%;height:var(--ic-space-lg);z-index:var(--ic-z-index-classification-banner)}/*!@:host(.inline)*/.inline.sc-ic-classification-banner-h{position:static;left:auto;bottom:auto}/*!@.classification-banner*/.classification-banner.sc-ic-classification-banner{display:flex;flex-direction:row;justify-content:center;align-items:center;padding:var(--ic-space-xxxs) var(--ic-space-md)}/*!@.default*/.default.sc-ic-classification-banner{background-color:var(--ic-classification-not-set);color:var(--ic-classification-not-set-foreground)}/*!@.official,\n.official-sensitive*/.official.sc-ic-classification-banner,.official-sensitive.sc-ic-classification-banner{background-color:var(--ic-classification-official);color:var(--ic-classification-official-foreground)}/*!@.secret*/.secret.sc-ic-classification-banner{background-color:var(--ic-classification-secret);color:var(--ic-classification-secret-foreground)}/*!@.top-secret*/.top-secret.sc-ic-classification-banner{background-color:var(--ic-classification-top-secret);color:var(--ic-classification-top-secret-foreground)}/*!@.offscreen*/.offscreen.sc-ic-classification-banner{position:absolute;left:-9999px;background-color:#fff;color:#000;text-transform:none}@media (forced-colors: active){/*!@.classification-banner*/.classification-banner.sc-ic-classification-banner{border:var(--ic-hc-border)}}";

const classificationText = {
    default: "protective marking not set",
    official: "official",
    "official-sensitive": "official sensitive",
    secret: "secret",
    "top-secret": "top secret",
};
class ClassificationBanner {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.additionalSelectors = "";
        this.classification = "default";
        this.country = "uk";
        this.inline = false;
        this.upTo = false;
    }
    render() {
        const { inline, upTo } = this;
        // In case of unrecognized props, fallback to default
        let { country, additionalSelectors, classification } = this;
        if (!country)
            country = "";
        if (!additionalSelectors)
            additionalSelectors = "";
        if (!classification ||
            (classification && !classificationText[classification]))
            classification = "default";
        return (hAsync(Host, { class: { ["inline"]: inline } }, hAsync("banner", { "aria-label": "Protective marking", class: {
                ["classification-banner"]: true,
                [`${classification}`]: classification,
            } }, classification !== "default" ? (hAsync("span", { class: "offscreen" }, "The protective marking of this page is:", " ")) : null, hAsync("ic-typography", { variant: "caption-uppercase" }, classification === "default"
            ? classificationText[classification]
            : `${upTo ? "up to" : ""} 
               ${country} 
               ${classificationText[classification]} 
               ${additionalSelectors}`))));
    }
    static get style() { return icClassificationBannerCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-classification-banner",
        "$members$": {
            "additionalSelectors": [1, "additional-selectors"],
            "classification": [1],
            "country": [1],
            "inline": [4],
            "upTo": [4, "up-to"]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icDataEntityCss = "/*!@html*/html.sc-ic-data-entity{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-data-entity{margin:0}/*!@main*/main.sc-ic-data-entity{display:block}/*!@h1*/h1.sc-ic-data-entity{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-data-entity{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-data-entity{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-data-entity{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-data-entity{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-data-entity,strong.sc-ic-data-entity{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-data-entity,kbd.sc-ic-data-entity,samp.sc-ic-data-entity{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-data-entity{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-data-entity,sup.sc-ic-data-entity{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-data-entity{bottom:-0.25em}/*!@sup*/sup.sc-ic-data-entity{top:-0.5em}/*!@img*/img.sc-ic-data-entity{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-data-entity,input.sc-ic-data-entity,optgroup.sc-ic-data-entity,select.sc-ic-data-entity,textarea.sc-ic-data-entity{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-data-entity,input.sc-ic-data-entity{overflow:visible}/*!@button,\nselect*/button.sc-ic-data-entity,select.sc-ic-data-entity{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-data-entity,[type=\"button\"].sc-ic-data-entity,[type=\"reset\"].sc-ic-data-entity,[type=\"submit\"].sc-ic-data-entity{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-data-entity::-moz-focus-inner,[type=\"button\"].sc-ic-data-entity::-moz-focus-inner,[type=\"reset\"].sc-ic-data-entity::-moz-focus-inner,[type=\"submit\"].sc-ic-data-entity::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-data-entity:-moz-focusring,[type=\"button\"].sc-ic-data-entity:-moz-focusring,[type=\"reset\"].sc-ic-data-entity:-moz-focusring,[type=\"submit\"].sc-ic-data-entity:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-data-entity{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-data-entity{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-data-entity{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-data-entity{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-data-entity,[type=\"radio\"].sc-ic-data-entity{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-data-entity::-webkit-inner-spin-button,[type=\"number\"].sc-ic-data-entity::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-data-entity{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-data-entity::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-data-entity::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-data-entity{display:block}/*!@summary*/summary.sc-ic-data-entity{display:list-item}/*!@template*/template.sc-ic-data-entity{display:none}/*!@[hidden]*/[hidden].sc-ic-data-entity{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-data-entity,body.sc-ic-data-entity,div.sc-ic-data-entity,span.sc-ic-data-entity,applet.sc-ic-data-entity,object.sc-ic-data-entity,iframe.sc-ic-data-entity,h1.sc-ic-data-entity,h2.sc-ic-data-entity,h3.sc-ic-data-entity,h4.sc-ic-data-entity,h5.sc-ic-data-entity,h6.sc-ic-data-entity,p.sc-ic-data-entity,blockquote.sc-ic-data-entity,pre.sc-ic-data-entity,a.sc-ic-data-entity,abbr.sc-ic-data-entity,acronym.sc-ic-data-entity,address.sc-ic-data-entity,big.sc-ic-data-entity,cite.sc-ic-data-entity,code.sc-ic-data-entity,del.sc-ic-data-entity,dfn.sc-ic-data-entity,em.sc-ic-data-entity,img.sc-ic-data-entity,ins.sc-ic-data-entity,kbd.sc-ic-data-entity,q.sc-ic-data-entity,s.sc-ic-data-entity,samp.sc-ic-data-entity,small.sc-ic-data-entity,strike.sc-ic-data-entity,strong.sc-ic-data-entity,sub.sc-ic-data-entity,sup.sc-ic-data-entity,tt.sc-ic-data-entity,var.sc-ic-data-entity,b.sc-ic-data-entity,u.sc-ic-data-entity,i.sc-ic-data-entity,center.sc-ic-data-entity,dl.sc-ic-data-entity,dt.sc-ic-data-entity,dd.sc-ic-data-entity,ol.sc-ic-data-entity,ul.sc-ic-data-entity,li.sc-ic-data-entity,fieldset.sc-ic-data-entity,form.sc-ic-data-entity,label.sc-ic-data-entity,legend.sc-ic-data-entity,table.sc-ic-data-entity,caption.sc-ic-data-entity,tbody.sc-ic-data-entity,tfoot.sc-ic-data-entity,thead.sc-ic-data-entity,tr.sc-ic-data-entity,th.sc-ic-data-entity,td.sc-ic-data-entity,article.sc-ic-data-entity,aside.sc-ic-data-entity,canvas.sc-ic-data-entity,details.sc-ic-data-entity,embed.sc-ic-data-entity,figure.sc-ic-data-entity,figcaption.sc-ic-data-entity,footer.sc-ic-data-entity,header.sc-ic-data-entity,hgroup.sc-ic-data-entity,menu.sc-ic-data-entity,nav.sc-ic-data-entity,output.sc-ic-data-entity,ruby.sc-ic-data-entity,section.sc-ic-data-entity,summary.sc-ic-data-entity,time.sc-ic-data-entity,mark.sc-ic-data-entity,audio.sc-ic-data-entity,video.sc-ic-data-entity{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-data-entity-h{display:block}/*!@.rows*/.rows.sc-ic-data-entity{display:flex;flex-direction:column;gap:var(--ic-space-md)}/*!@:host(.small) .rows*/.small.sc-ic-data-entity-h .rows.sc-ic-data-entity{gap:var(--ic-space-xs)}/*!@.divider*/.divider.sc-ic-data-entity{margin-top:var(--ic-space-lg);margin-bottom:var(--ic-space-md);height:var(--ic-border-width);background-color:var(--ic-architectural-300)}/*!@:host(.small) .divider*/.small.sc-ic-data-entity-h .divider.sc-ic-data-entity{margin-top:var(--ic-space-sm);margin-bottom:var(--ic-space-xs)}@media (forced-colors: active){/*!@.divider*/.divider.sc-ic-data-entity{background-color:canvastext}}";

/**
 * @slot heading - Content will be placed at the top of the data entity.
 */
class DataEntity {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.heading = undefined;
        this.size = "default";
        this.small = false;
    }
    render() {
        const { el, heading, small, size } = this;
        if (small || size === "small") {
            Array.from(el.children).forEach((child) => child.setAttribute("size", "small"));
        }
        return (hAsync(Host, { class: { small: small || size === "small" } }, hAsync("div", { class: "heading", id: "data-entity-heading" }, hAsync("slot", { name: "heading" }, hAsync("ic-typography", { variant: "h3" }, heading))), hAsync("div", { class: "divider" }), hAsync("ul", { "aria-labelledby": "data-entity-heading", class: "rows" }, hAsync("slot", null))));
    }
    get el() { return getElement(this); }
    static get style() { return icDataEntityCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-data-entity",
        "$members$": {
            "heading": [1],
            "size": [1],
            "small": [4]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icDataRowCss = "/*!@html*/html.sc-ic-data-row{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-data-row{margin:0}/*!@main*/main.sc-ic-data-row{display:block}/*!@h1*/h1.sc-ic-data-row{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-data-row{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-data-row{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-data-row{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-data-row{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-data-row,strong.sc-ic-data-row{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-data-row,kbd.sc-ic-data-row,samp.sc-ic-data-row{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-data-row{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-data-row,sup.sc-ic-data-row{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-data-row{bottom:-0.25em}/*!@sup*/sup.sc-ic-data-row{top:-0.5em}/*!@img*/img.sc-ic-data-row{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-data-row,input.sc-ic-data-row,optgroup.sc-ic-data-row,select.sc-ic-data-row,textarea.sc-ic-data-row{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-data-row,input.sc-ic-data-row{overflow:visible}/*!@button,\nselect*/button.sc-ic-data-row,select.sc-ic-data-row{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-data-row,[type=\"button\"].sc-ic-data-row,[type=\"reset\"].sc-ic-data-row,[type=\"submit\"].sc-ic-data-row{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-data-row::-moz-focus-inner,[type=\"button\"].sc-ic-data-row::-moz-focus-inner,[type=\"reset\"].sc-ic-data-row::-moz-focus-inner,[type=\"submit\"].sc-ic-data-row::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-data-row:-moz-focusring,[type=\"button\"].sc-ic-data-row:-moz-focusring,[type=\"reset\"].sc-ic-data-row:-moz-focusring,[type=\"submit\"].sc-ic-data-row:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-data-row{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-data-row{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-data-row{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-data-row{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-data-row,[type=\"radio\"].sc-ic-data-row{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-data-row::-webkit-inner-spin-button,[type=\"number\"].sc-ic-data-row::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-data-row{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-data-row::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-data-row::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-data-row{display:block}/*!@summary*/summary.sc-ic-data-row{display:list-item}/*!@template*/template.sc-ic-data-row{display:none}/*!@[hidden]*/[hidden].sc-ic-data-row{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-data-row,body.sc-ic-data-row,div.sc-ic-data-row,span.sc-ic-data-row,applet.sc-ic-data-row,object.sc-ic-data-row,iframe.sc-ic-data-row,h1.sc-ic-data-row,h2.sc-ic-data-row,h3.sc-ic-data-row,h4.sc-ic-data-row,h5.sc-ic-data-row,h6.sc-ic-data-row,p.sc-ic-data-row,blockquote.sc-ic-data-row,pre.sc-ic-data-row,a.sc-ic-data-row,abbr.sc-ic-data-row,acronym.sc-ic-data-row,address.sc-ic-data-row,big.sc-ic-data-row,cite.sc-ic-data-row,code.sc-ic-data-row,del.sc-ic-data-row,dfn.sc-ic-data-row,em.sc-ic-data-row,img.sc-ic-data-row,ins.sc-ic-data-row,kbd.sc-ic-data-row,q.sc-ic-data-row,s.sc-ic-data-row,samp.sc-ic-data-row,small.sc-ic-data-row,strike.sc-ic-data-row,strong.sc-ic-data-row,sub.sc-ic-data-row,sup.sc-ic-data-row,tt.sc-ic-data-row,var.sc-ic-data-row,b.sc-ic-data-row,u.sc-ic-data-row,i.sc-ic-data-row,center.sc-ic-data-row,dl.sc-ic-data-row,dt.sc-ic-data-row,dd.sc-ic-data-row,ol.sc-ic-data-row,ul.sc-ic-data-row,li.sc-ic-data-row,fieldset.sc-ic-data-row,form.sc-ic-data-row,label.sc-ic-data-row,legend.sc-ic-data-row,table.sc-ic-data-row,caption.sc-ic-data-row,tbody.sc-ic-data-row,tfoot.sc-ic-data-row,thead.sc-ic-data-row,tr.sc-ic-data-row,th.sc-ic-data-row,td.sc-ic-data-row,article.sc-ic-data-row,aside.sc-ic-data-row,canvas.sc-ic-data-row,details.sc-ic-data-row,embed.sc-ic-data-row,figure.sc-ic-data-row,figcaption.sc-ic-data-row,footer.sc-ic-data-row,header.sc-ic-data-row,hgroup.sc-ic-data-row,menu.sc-ic-data-row,nav.sc-ic-data-row,output.sc-ic-data-row,ruby.sc-ic-data-row,section.sc-ic-data-row,summary.sc-ic-data-row,time.sc-ic-data-row,mark.sc-ic-data-row,audio.sc-ic-data-row,video.sc-ic-data-row{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-data-row-h{position:relative;display:block}/*!@.data*/.data.sc-ic-data-row{display:flex;align-items:center}/*!@.text-cells*/.text-cells.sc-ic-data-row{display:flex;flex-grow:1;min-width:0}/*!@.label*/.label.sc-ic-data-row{width:12.5rem;min-width:12.5rem;margin-right:var(--ic-space-md);color:var(--ic-color-tertiary-text)}/*!@.value*/.value.sc-ic-data-row{flex-grow:1}/*!@slot[name=\"value\"]::slotted(ic-text-field[readonly][hide-label])*/slot[name=\"value\"].sc-ic-data-row-s>ic-text-field[readonly][hide-label]{margin-top:calc(var(--ic-space-xs) * -1)}/*!@slot[name=\"value\"]::slotted(ic-text-field[small][readonly][hide-label])*/slot[name=\"value\"].sc-ic-data-row-s>ic-text-field[small][readonly][hide-label]{margin-top:calc(var(--ic-space-xxs) * -1)}/*!@slot[name=\"value\"]::slotted(ic-text-field[readonly][hide-label][rows])*/slot[name=\"value\"].sc-ic-data-row-s>ic-text-field[readonly][hide-label][rows]{margin-top:calc(var(--ic-space-xxs) * -1 - var(--ic-space-xxxs))}/*!@.end-component*/.end-component.sc-ic-data-row{width:-moz-fit-content;width:fit-content;margin-left:3.5rem}/*!@.divider*/.divider.sc-ic-data-row{margin-top:var(--ic-space-md);height:var(--ic-border-width);background-color:var(--ic-architectural-300)}/*!@:host(.small) .divider*/.small.sc-ic-data-row-h .divider.sc-ic-data-row{margin-top:var(--ic-space-xs)}/*!@:host(.breakpoint-medium) .label*/.breakpoint-medium.sc-ic-data-row-h .label.sc-ic-data-row{width:10rem;min-width:10rem}/*!@:host(.breakpoint-xs) .text-cells*/.breakpoint-xs.sc-ic-data-row-h .text-cells.sc-ic-data-row{flex-direction:column}/*!@:host(.breakpoint-xs) .label*/.breakpoint-xs.sc-ic-data-row-h .label.sc-ic-data-row{width:8rem;margin-bottom:var(--ic-space-xs)}/*!@:host(.breakpoint-xs) .value*/.breakpoint-xs.sc-ic-data-row-h .value.sc-ic-data-row{max-width:95%}/*!@:host(.breakpoint-xs) .end-component*/.breakpoint-xs.sc-ic-data-row-h .end-component.sc-ic-data-row{margin-left:0}@media (forced-colors: active){/*!@.divider*/.divider.sc-ic-data-row{background-color:canvastext}}";

/**
 * @slot label - Content will be rendered in the leftmost cell.
 * @slot value - Content will be rendered to the right of the label.
 * @slot end-component - Content will be displayed in the rightmost cell.
 */
class DataRow {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.hasEndComponent = false;
        this.resizeObserver = null;
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                this.checkLabelAbove();
            });
            this.resizeObserver.observe(this.el);
        };
        this.renderCellContent = (cell) => {
            const isValue = cell === "value";
            return (hAsync("div", { class: cell }, isSlotUsed(this.el, cell) ? (hAsync("slot", { name: cell })) : (hAsync("ic-typography", { variant: isValue
                    ? "body"
                    : this.entitySize === "xs"
                        ? "label"
                        : "subtitle-large" }, isValue ? this.value : this.label))));
        };
        this.deviceSize = DEVICE_SIZES.XL;
        this.entitySize = undefined;
        this.label = undefined;
        this.size = "default";
        this.small = false;
        this.value = undefined;
    }
    disconnectedCallback() {
        var _a;
        (_a = this.resizeObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentWillLoad() {
        this.deviceSize = getCurrentDeviceSize();
        this.hasEndComponent = slotHasContent(this.el, "end-component");
        this.checkLabelAbove();
    }
    componentDidLoad() {
        checkResizeObserver(this.runResizeObserver);
        if (this.hasEndComponent)
            this.labelEndComponent();
    }
    checkLabelAbove() {
        var _a;
        const rowSize = ((_a = this.el.shadowRoot.querySelector(".data")) === null || _a === void 0 ? void 0 : _a.clientWidth) + 46;
        if (rowSize) {
            this.entitySize =
                rowSize < DEVICE_SIZES.S ? "xs" : rowSize < DEVICE_SIZES.M ? "m" : "xl";
        }
    }
    labelEndComponent() {
        this.el.shadowRoot
            .querySelectorAll("slot[name=end-component]")
            .forEach((child) => child.setAttribute("aria-label", `for ${this.label} row`));
    }
    render() {
        const { el, entitySize, hasEndComponent, label, renderCellContent, size, small, value, } = this;
        return (hAsync(Host, { class: {
                ["small"]: small || size === "small",
                ["breakpoint-medium"]: entitySize === "m",
                ["breakpoint-xs"]: entitySize === "xs",
            }, role: "listitem" }, hAsync("div", { class: "data" }, hAsync("div", { class: "text-cells" }, (isSlotUsed(el, "label") || label) && renderCellContent("label"), (isSlotUsed(el, "value") || value) && renderCellContent("value")), hasEndComponent && (hAsync("div", { class: "end-component" }, hAsync("slot", { name: "end-component" })))), hAsync("div", { class: "divider" })));
    }
    get el() { return getElement(this); }
    static get style() { return icDataRowCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-data-row",
        "$members$": {
            "label": [1],
            "size": [1],
            "small": [4],
            "value": [1],
            "deviceSize": [32],
            "entitySize": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icDialogCss = "/*!@html*/html.sc-ic-dialog{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-dialog{margin:0}/*!@main*/main.sc-ic-dialog{display:block}/*!@h1*/h1.sc-ic-dialog{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-dialog{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-dialog{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-dialog{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-dialog{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-dialog,strong.sc-ic-dialog{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-dialog,kbd.sc-ic-dialog,samp.sc-ic-dialog{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-dialog{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-dialog,sup.sc-ic-dialog{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-dialog{bottom:-0.25em}/*!@sup*/sup.sc-ic-dialog{top:-0.5em}/*!@img*/img.sc-ic-dialog{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-dialog,input.sc-ic-dialog,optgroup.sc-ic-dialog,select.sc-ic-dialog,textarea.sc-ic-dialog{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-dialog,input.sc-ic-dialog{overflow:visible}/*!@button,\nselect*/button.sc-ic-dialog,select.sc-ic-dialog{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-dialog,[type=\"button\"].sc-ic-dialog,[type=\"reset\"].sc-ic-dialog,[type=\"submit\"].sc-ic-dialog{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-dialog::-moz-focus-inner,[type=\"button\"].sc-ic-dialog::-moz-focus-inner,[type=\"reset\"].sc-ic-dialog::-moz-focus-inner,[type=\"submit\"].sc-ic-dialog::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-dialog:-moz-focusring,[type=\"button\"].sc-ic-dialog:-moz-focusring,[type=\"reset\"].sc-ic-dialog:-moz-focusring,[type=\"submit\"].sc-ic-dialog:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-dialog{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-dialog{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-dialog{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-dialog{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-dialog,[type=\"radio\"].sc-ic-dialog{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-dialog::-webkit-inner-spin-button,[type=\"number\"].sc-ic-dialog::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-dialog{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-dialog::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-dialog::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-dialog{display:block}/*!@summary*/summary.sc-ic-dialog{display:list-item}/*!@template*/template.sc-ic-dialog{display:none}/*!@[hidden]*/[hidden].sc-ic-dialog{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-dialog,body.sc-ic-dialog,div.sc-ic-dialog,span.sc-ic-dialog,applet.sc-ic-dialog,object.sc-ic-dialog,iframe.sc-ic-dialog,h1.sc-ic-dialog,h2.sc-ic-dialog,h3.sc-ic-dialog,h4.sc-ic-dialog,h5.sc-ic-dialog,h6.sc-ic-dialog,p.sc-ic-dialog,blockquote.sc-ic-dialog,pre.sc-ic-dialog,a.sc-ic-dialog,abbr.sc-ic-dialog,acronym.sc-ic-dialog,address.sc-ic-dialog,big.sc-ic-dialog,cite.sc-ic-dialog,code.sc-ic-dialog,del.sc-ic-dialog,dfn.sc-ic-dialog,em.sc-ic-dialog,img.sc-ic-dialog,ins.sc-ic-dialog,kbd.sc-ic-dialog,q.sc-ic-dialog,s.sc-ic-dialog,samp.sc-ic-dialog,small.sc-ic-dialog,strike.sc-ic-dialog,strong.sc-ic-dialog,sub.sc-ic-dialog,sup.sc-ic-dialog,tt.sc-ic-dialog,var.sc-ic-dialog,b.sc-ic-dialog,u.sc-ic-dialog,i.sc-ic-dialog,center.sc-ic-dialog,dl.sc-ic-dialog,dt.sc-ic-dialog,dd.sc-ic-dialog,ol.sc-ic-dialog,ul.sc-ic-dialog,li.sc-ic-dialog,fieldset.sc-ic-dialog,form.sc-ic-dialog,label.sc-ic-dialog,legend.sc-ic-dialog,table.sc-ic-dialog,caption.sc-ic-dialog,tbody.sc-ic-dialog,tfoot.sc-ic-dialog,thead.sc-ic-dialog,tr.sc-ic-dialog,th.sc-ic-dialog,td.sc-ic-dialog,article.sc-ic-dialog,aside.sc-ic-dialog,canvas.sc-ic-dialog,details.sc-ic-dialog,embed.sc-ic-dialog,figure.sc-ic-dialog,figcaption.sc-ic-dialog,footer.sc-ic-dialog,header.sc-ic-dialog,hgroup.sc-ic-dialog,menu.sc-ic-dialog,nav.sc-ic-dialog,output.sc-ic-dialog,ruby.sc-ic-dialog,section.sc-ic-dialog,summary.sc-ic-dialog,time.sc-ic-dialog,mark.sc-ic-dialog,audio.sc-ic-dialog,video.sc-ic-dialog{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-dialog-h{position:fixed;inset:0;display:flex;align-items:center;justify-content:center;min-height:100% !important;background:rgb(0 0 0 / 60%);z-index:var(--ic-z-index-dialog);opacity:0}/*!@:host(.fade-in)*/.fade-in.sc-ic-dialog-h{opacity:1}/*!@:host(.disable-height-constraint)*/.disable-height-constraint.sc-ic-dialog-h{background:none;justify-content:unset;align-items:unset}/*!@.dialog.disable-height-constraint*/.dialog.disable-height-constraint.sc-ic-dialog{max-height:none;position:relative}/*!@.dialog.disable-height-constraint .content-area*/.dialog.disable-height-constraint.sc-ic-dialog .content-area.sc-ic-dialog{overflow-y:visible}@media (prefers-reduced-motion: no-preference){/*!@:host*/.sc-ic-dialog-h{transition:opacity var(--ic-easing-transition-slow)}/*!@.dialog*/.dialog.sc-ic-dialog{transform:translateY(-3rem);transition:transform 1000s}/*!@:host(.fade-in) .dialog*/.fade-in.sc-ic-dialog-h .dialog.sc-ic-dialog{transform:translateY(0);transition:transform var(--ic-easing-transition-slow)}}/*!@:host(.hidden)*/.hidden.sc-ic-dialog-h{display:none}/*!@.dialog*/.dialog.sc-ic-dialog{background-color:var(--ic-architectural-white);color:var(--ic-architectural-black);border:var(--ic-border-default);border-radius:var(--ic-border-radius);padding:var(--ic-space-xs) 0 var(--ic-space-md);display:flex;flex-direction:column;box-sizing:border-box;overflow-x:visible}/*!@.small*/.small.sc-ic-dialog{width:50%;max-width:25rem;min-height:11rem;max-height:70vh}/*!@.medium*/.medium.sc-ic-dialog{width:70vw;max-width:44rem;min-height:12.5rem;max-height:70vh}/*!@.large*/.large.sc-ic-dialog{width:90vw;max-width:62.5rem;min-height:12.5rem;max-height:90vh}/*!@.heading-area*/.heading-area.sc-ic-dialog{display:flex;margin-bottom:var(--ic-space-xs);padding:0 var(--ic-space-md)}/*!@.heading*/.heading.sc-ic-dialog{overflow-wrap:break-word}/*!@.close-icon*/.close-icon.sc-ic-dialog{margin-left:auto}/*!@.content-area*/.content-area.sc-ic-dialog{-ms-overflow-style:none;scrollbar-width:none;padding:0 var(--ic-space-md);margin:0;overflow-y:auto}/*!@.content-area::-webkit-scrollbar*/.content-area.sc-ic-dialog::-webkit-scrollbar{display:none}/*!@#dialog-content*/#dialog-content.sc-ic-dialog{margin-bottom:var(--ic-space-sm)}/*!@#dialog-content ::slotted(ic-typography)*/#dialog-content .sc-ic-dialog-s>ic-typography{overflow-wrap:break-word}/*!@#dialog-content ::slotted(*)*/#dialog-content .sc-ic-dialog-s>*{position:relative}/*!@.status-alert*/.status-alert.sc-ic-dialog{margin-bottom:var(--ic-space-xs)}/*!@.dialog-controls*/.dialog-controls.sc-ic-dialog{margin-top:auto;padding:var(--ic-space-xs) var(--ic-space-md) 0;display:flex;justify-content:flex-end;gap:var(--ic-space-md)}/*!@.dialog-control-button*/.dialog-control-button.sc-ic-dialog{width:-moz-fit-content;width:fit-content}/*!@.backdrop*/.backdrop.sc-ic-dialog{overflow-y:auto;position:fixed;inset:0;display:flex;align-items:center;justify-content:center;background:rgb(0 0 0 / 60%);z-index:var(--ic-z-index-dialog);padding-top:16px;padding-bottom:16px}@media (min-width: 800px){/*!@:host([size=\"large\"]) .dialog:not(.disable-width-constraint) > .content-area*/[size=\"large\"].sc-ic-dialog-h .dialog.sc-ic-dialog:not(.disable-width-constraint)>.content-area.sc-ic-dialog{width:75%}}@media (max-width: 576px){/*!@.dialog*/.dialog.sc-ic-dialog{width:100vw;height:100vh;transform:translateY(-5rem);max-width:none;max-height:none;box-sizing:border-box}/*!@.backdrop*/.backdrop.sc-ic-dialog{padding:0}/*!@.dialog.disable-height-constraint*/.dialog.disable-height-constraint.sc-ic-dialog{height:auto;min-height:100vh}}@media (max-width: 364px){/*!@.triple-button*/.triple-button.sc-ic-dialog{flex-direction:column;gap:var(--ic-space-xs)}/*!@.dialog-control-button*/.dialog-control-button.sc-ic-dialog{width:unset}}";

/**
 * @slot dialog-controls - Content will be place at the bottom of the dialog.
 * @slot heading - Content will be placed at the top of the dialog.
 * @slot label - Content will be placed above the dialog heading.
 * @slot alert - Content will be placed at the top of the content area of the dialog.
 */
class Dialog {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.icDialogCancelled = createEvent(this, "icDialogCancelled", 7);
        this.icDialogClosed = createEvent(this, "icDialogClosed", 7);
        this.icDialogConfirmed = createEvent(this, "icDialogConfirmed", 7);
        this.icDialogOpened = createEvent(this, "icDialogOpened", 7);
        this.DATA_GETS_FOCUS = "data-gets-focus";
        this.DATA_GETS_FOCUS_SELECTOR = "[data-gets-focus]";
        this.DIALOG_CONTROLS = "dialog-controls";
        this.dialogHeight = 0;
        this.focusedElementIndex = 0;
        this.IC_TEXT_FIELD = "IC-TEXT-FIELD";
        this.IC_ACCORDION = "IC-ACCORDION";
        this.IC_ACCORDION_GROUP = "IC-ACCORDION-GROUP";
        this.resizeObserver = null;
        this.dialogOpened = () => {
            var _a;
            this.dialogRendered = true;
            if (this.disableHeightConstraint) {
                this.dialogEl.show();
            }
            else {
                (_a = this.dialogEl) === null || _a === void 0 ? void 0 : _a.showModal();
            }
            setTimeout(() => {
                this.fadeIn = true;
                /**
                 * This is required to set scroll back to top if:
                 * - dialog content goes below the fold
                 * - is closed using cancel or confirm and reopened.
                 *
                 * Without this, the scroll bar will start from the dialog's last scroll-x coordinate.
                 */
                if (this.disableHeightConstraint && this.backdropEl.scrollTop !== 0) {
                    this.backdropEl.scrollTop = 0;
                }
            }, 10);
            setTimeout(() => {
                this.setInitialFocus();
                checkResizeObserver(this.runResizeObserver);
            }, 75);
            setTimeout(() => {
                this.getFocusedElementIndex();
                this.icDialogOpened.emit();
            }, 80);
        };
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                clearTimeout(this.resizeTimeout);
                this.resizeTimeout = window.setTimeout(this.resizeObserverCallback, 80);
            });
            this.resizeObserver.observe(this.dialogEl);
        };
        this.resizeObserverCallback = () => {
            if (this.dialogEl.clientHeight !== this.dialogHeight) {
                this.dialogHeight = this.dialogEl.clientHeight;
            }
        };
        this.refreshInteractiveElementsOnSlotChange = () => {
            this.contentArea = this.el.shadowRoot.querySelector("#dialog-content slot");
            this.contentArea.addEventListener("slotchange", this.getInteractiveElements);
        };
        this.removeSlotChangeListener = () => {
            if (this.contentArea) {
                this.contentArea.removeEventListener("slotchange", this.getInteractiveElements);
            }
        };
        this.setInitialFocus = () => {
            this.sourceElement = document.activeElement;
            let focusedElement;
            if (this.el.querySelector(this.DATA_GETS_FOCUS_SELECTOR) !== null) {
                focusedElement = this.el.querySelector(this.DATA_GETS_FOCUS_SELECTOR);
            }
            else {
                focusedElement = this.el.shadowRoot.querySelector(this.DATA_GETS_FOCUS_SELECTOR);
            }
            if (focusedElement.tagName === this.IC_TEXT_FIELD) {
                focusedElement.setFocus();
            }
            else if (focusedElement.tagName === this.IC_ACCORDION_GROUP) {
                focusedElement.setFocus();
            }
            else if (focusedElement.tagName === this.IC_ACCORDION) {
                focusedElement.setFocus();
            }
            else {
                focusedElement.focus({
                    preventScroll: this.disableHeightConstraint ? true : false,
                });
            }
        };
        this.getFocusedElementIndex = () => {
            for (let i = 0; i < this.interactiveElementList.length; i++) {
                if (this.interactiveElementList[i] ===
                    (this.el.shadowRoot.activeElement || document.activeElement)) {
                    this.focusedElementIndex = i;
                }
            }
        };
        this.setAlertVariant = () => {
            if (isPropDefined(this.status) && this.status !== null) {
                const alert = this.el.shadowRoot.querySelector("ic-alert");
                alert.setAttribute("variant", this.status);
            }
        };
        this.closeIconClick = () => {
            this.open = false;
        };
        this.getInteractiveElements = () => {
            this.interactiveElementList = Array.from(this.el.shadowRoot.querySelectorAll("ic-button"));
            const slottedInteractiveElements = Array.from(this.el.querySelectorAll(`a[href], button, input:not(.ic-input), textarea, select, details, [tabindex]:not([tabindex="-1"]), 
          ic-button, ic-checkbox, ic-select, ic-search-bar, ic-tab-group, ic-radio-group, 
          ic-back-to-top, ic-breadcrumb, ic-chip[dismissible="true"], ic-footer-link, ic-link, ic-navigation-button, 
          ic-navigation-item, ic-switch, ic-text-field, ic-accordion-group, ic-accordion`));
            if (slottedInteractiveElements.length > 0) {
                if (slottedInteractiveElements[0].slot !== this.DIALOG_CONTROLS) {
                    slottedInteractiveElements[0].setAttribute(this.DATA_GETS_FOCUS, "");
                }
                else if (!this.destructive) {
                    slottedInteractiveElements[slottedInteractiveElements.length - 1].setAttribute(this.DATA_GETS_FOCUS, "");
                }
            }
            for (let i = 0; i < slottedInteractiveElements.length; i++) {
                this.interactiveElementList.splice(1 + i, 0, slottedInteractiveElements[i]);
            }
        };
        this.getNextFocusEl = (focusedElementIndex) => this.interactiveElementList[focusedElementIndex];
        this.focusNextInteractiveElement = (shiftKey) => {
            this.getFocusedElementIndex();
            this.setFocusIndexBasedOnShiftKey(shiftKey);
            this.loopNextFocusIndexIfLastElement();
            let nextFocusEl = this.getNextFocusEl(this.focusedElementIndex);
            const isHidden = getComputedStyle(nextFocusEl).visibility === "hidden" ||
                (nextFocusEl.tagName === this.IC_ACCORDION_GROUP &&
                    nextFocusEl.hasAttribute("single-expansion"));
            if (nextFocusEl.tagName === this.IC_TEXT_FIELD) {
                nextFocusEl.setFocus();
            }
            else {
                if (isHidden) {
                    this.setFocusIndexBasedOnShiftKey(shiftKey);
                    this.loopNextFocusIndexIfLastElement();
                    nextFocusEl = this.getNextFocusEl(this.focusedElementIndex);
                }
                if (nextFocusEl.tagName === this.IC_ACCORDION_GROUP) {
                    nextFocusEl.setFocus();
                }
                else if (nextFocusEl.tagName === this.IC_ACCORDION) {
                    nextFocusEl.setFocus();
                }
                else {
                    nextFocusEl.focus();
                }
            }
        };
        this.setButtonOnClick = () => {
            var _a, _b, _c;
            if (this.buttons) {
                this.buttonOnclick0 = new Function((_a = this.buttonProps[0]) === null || _a === void 0 ? void 0 : _a.onclick);
                this.buttonOnclick1 = new Function((_b = this.buttonProps[1]) === null || _b === void 0 ? void 0 : _b.onclick);
                this.buttonOnclick2 = new Function((_c = this.buttonProps[2]) === null || _c === void 0 ? void 0 : _c.onclick);
            }
        };
        this.getButtonOnclick = (index) => {
            if (index === 0) {
                return this.buttonOnclick0();
            }
            else if (index === 1) {
                return this.buttonOnclick1();
            }
            else {
                return this.buttonOnclick2();
            }
        };
        this.getButtonVariant = (index) => {
            const mainVariant = this.destructive ? "destructive" : "primary";
            if (this.buttonProps.length === 1) {
                return mainVariant;
            }
            else if (this.buttonProps.length === 2) {
                if (index === 0) {
                    return "tertiary";
                }
                else {
                    return mainVariant;
                }
            }
            else {
                if (index === 2) {
                    return mainVariant;
                }
                else {
                    return "secondary";
                }
            }
        };
        this.renderDialog = () => {
            const { alertHeading, alertMessage, buttons, buttonProps, size, heading, label, status, destructive, dismissLabel, hideCloseButton, } = this;
            return (hAsync("dialog", { class: {
                    ["dialog"]: true,
                    [`${size}`]: true,
                    ["disable-height-constraint"]: this.disableHeightConstraint,
                    ["disable-width-constraint"]: this.disableWidthConstraint,
                }, "aria-labelledby": "dialog-label dialog-heading", "aria-describedby": "dialog-alert dialog-content", ref: (el) => (this.dialogEl = el) }, hAsync("div", { class: "heading-area" }, hAsync("div", { class: "heading-content" }, hAsync("div", { class: "label" }, hAsync("slot", { name: "label" }, hAsync("ic-typography", { variant: "label", id: "dialog-label" }, label))), hAsync("div", { class: "heading" }, hAsync("slot", { name: "heading" }, hAsync("ic-typography", { variant: "h4", id: "dialog-heading" }, heading)))), !hideCloseButton && (hAsync("ic-button", { class: "close-icon", variant: "icon", innerHTML: closeIcon, "aria-label": dismissLabel, onClick: this.closeIconClick, "data-gets-focus": destructive || !buttons ? "" : null }))), hAsync("div", { class: "content-area" }, isSlotUsed(this.el, "alert") ? (hAsync("slot", { name: "alert" })) : (status && (hAsync("ic-alert", { variant: status, heading: alertHeading, message: alertMessage, "title-above": true, class: "status-alert", id: "dialog-alert" }))), hAsync("div", { id: "dialog-content" }, hAsync("slot", null))), (buttons || isSlotUsed(this.el, this.DIALOG_CONTROLS)) && (hAsync("div", { class: {
                    [this.DIALOG_CONTROLS]: true,
                    ["triple-button"]: buttonProps.length === 3,
                } }, hAsync("slot", { name: this.DIALOG_CONTROLS }, !isSlotUsed(this.el, this.DIALOG_CONTROLS) &&
                buttonProps.map((props, index) => {
                    if (index > 2) {
                        return;
                    }
                    else {
                        return (hAsync("ic-button", { variant: this.getButtonVariant(index), onClick: () => this.getButtonOnclick(index), class: "dialog-control-button", "full-width": buttonProps.length === 3, "data-gets-focus": this.getButtonVariant(index) === "primary" ? "" : null }, props.label));
                    }
                }))))));
        };
        this.dialogRendered = false;
        this.fadeIn = false;
        this.alertHeading = undefined;
        this.alertMessage = undefined;
        this.buttons = true;
        this.closeOnBackdropClick = true;
        this.destructive = false;
        this.dismissLabel = "Dismiss";
        this.disableHeightConstraint = false;
        this.disableWidthConstraint = false;
        this.hideCloseButton = false;
        this.heading = undefined;
        this.label = undefined;
        this.open = undefined;
        this.size = "small";
        this.status = undefined;
        this.buttonProps = [
            {
                label: "Cancel",
                onclick: "this.cancelDialog();",
            },
            { label: "Confirm", onclick: "this.confirmDialog();" },
        ];
    }
    watchOpenHandler() {
        if (this.open) {
            this.dialogOpened();
        }
        else {
            this.fadeIn = false;
            if (this.resizeObserver !== null) {
                this.resizeObserver.disconnect();
            }
            setTimeout(() => {
                var _a;
                this.dialogRendered = false;
                this.dialogEl.close();
                (_a = this.sourceElement) === null || _a === void 0 ? void 0 : _a.focus();
                this.dialogHeight = 0;
                this.icDialogClosed.emit();
            }, 80);
        }
    }
    watchPropHandler() {
        this.setButtonOnClick();
    }
    disconnectedCallback() {
        this.removeSlotChangeListener();
    }
    componentWillLoad() {
        if (this.buttonProps.length) {
            this.setButtonOnClick();
        }
    }
    componentDidLoad() {
        this.getInteractiveElements();
        this.setAlertVariant();
        this.refreshInteractiveElementsOnSlotChange();
        if (this.open) {
            this.dialogOpened();
        }
        !isSlotUsed(this.el, "heading") &&
            onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Dialog");
    }
    componentDidRender() {
        if (getComputedStyle(this.el).display !== "none" &&
            this.disableHeightConstraint) {
            document.body.style.overflow = "hidden";
        }
        else {
            document.body.style.overflow = "auto";
        }
    }
    handleKeyboard(ev) {
        if (this.dialogRendered) {
            switch (ev.key) {
                case "Tab":
                    ev.preventDefault();
                    this.focusNextInteractiveElement(ev.shiftKey);
                    break;
                case "Escape":
                    if (!ev.repeat) {
                        this.open = false;
                    }
                    ev.stopImmediatePropagation();
                    break;
            }
        }
    }
    handleClick(ev) {
        const dialogElement = this.el.shadowRoot.querySelector("dialog");
        if (this.closeOnBackdropClick &&
            ev.composedPath().indexOf(dialogElement) <= 0) {
            const rect = this.dialogEl.getBoundingClientRect();
            const isInDialog = rect.top <= ev.clientY &&
                ev.clientY <= rect.top + rect.height &&
                rect.left <= ev.clientX &&
                ev.clientX <= rect.left + rect.width;
            if (!isInDialog) {
                this.open = false;
            }
        }
    }
    /**
     * @deprecated This method should not be used anymore. Use open prop to set dialog visibility.
     */
    async showDialog() {
        this.open = true;
    }
    /**
     * @deprecated This method should not be used anymore. Use open prop to set dialog visibility.
     */
    async hideDialog() {
        this.open = false;
    }
    /**
     * Cancels the dialog. Used by the default 'Cancel' button or can be called manually to trigger cancelling of dialog.
     */
    async cancelDialog() {
        this.icDialogCancelled.emit();
        this.open = false;
    }
    /**
     * Confirms the dialog. Used by the default 'Confirm' button or can be called manually to trigger confirming of dialog.
     */
    async confirmDialog() {
        this.icDialogConfirmed.emit();
    }
    loopNextFocusIndexIfLastElement() {
        if (this.focusedElementIndex > this.interactiveElementList.length - 1)
            this.focusedElementIndex = 0;
        else if (this.focusedElementIndex < 0) {
            this.focusedElementIndex = this.interactiveElementList.length - 1;
        }
    }
    setFocusIndexBasedOnShiftKey(shiftKey) {
        if (shiftKey) {
            this.focusedElementIndex -= 1;
        }
        else {
            this.focusedElementIndex += 1;
        }
    }
    render() {
        return (hAsync(Host, { class: {
                ["hidden"]: !this.dialogRendered,
                ["fade-in"]: this.fadeIn,
                ["disable-height-constraint"]: this.disableHeightConstraint,
            } }, this.disableHeightConstraint ? (hAsync("div", { class: "backdrop", ref: (el) => (this.backdropEl = el) }, this.renderDialog())) : (this.renderDialog())));
    }
    get el() { return getElement(this); }
    static get watchers() { return {
        "open": ["watchOpenHandler"],
        "buttonProps": ["watchPropHandler"]
    }; }
    static get style() { return icDialogCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-dialog",
        "$members$": {
            "alertHeading": [1, "alert-heading"],
            "alertMessage": [1, "alert-message"],
            "buttons": [4],
            "closeOnBackdropClick": [4, "close-on-backdrop-click"],
            "destructive": [4],
            "dismissLabel": [1, "dismiss-label"],
            "disableHeightConstraint": [4, "disable-height-constraint"],
            "disableWidthConstraint": [4, "disable-width-constraint"],
            "hideCloseButton": [4, "hide-close-button"],
            "heading": [1],
            "label": [1],
            "open": [1540],
            "size": [1],
            "status": [1],
            "buttonProps": [16],
            "dialogRendered": [32],
            "fadeIn": [32],
            "showDialog": [64],
            "hideDialog": [64],
            "cancelDialog": [64],
            "confirmDialog": [64]
        },
        "$listeners$": [[4, "keydown", "handleKeyboard"], [0, "click", "handleClick"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": [["open", "open"]]
    }; }
}

const icDividerCss = "hr.sc-ic-divider{padding:0;margin:0;border:none;height:var(--ic-space-1px);background-color:var(--ic-keyline-darken-rgb)}hr.light.sc-ic-divider{background-color:var(--ic-keyline-lighten-rgb)}";

class Divider {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.foregroundColor = getThemeForegroundColor();
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    render() {
        return (hAsync(Host, { "aria-hidden": "true" }, hAsync("hr", { class: {
                ["light"]: this.foregroundColor === IcThemeForegroundEnum.Light,
            } })));
    }
    static get style() { return icDividerCss; }
    static get cmpMeta() { return {
        "$flags$": 2,
        "$tagName$": "ic-divider",
        "$members$": {
            "foregroundColor": [32]
        },
        "$listeners$": [[4, "themeChange", "themeChangeHandler"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icEmptyStateCss = "/*!@:host*/.sc-ic-empty-state-h{gap:var(--ic-space-xs);padding:var(--ic-space-xs)}/*!@:host,\n.action-area*/.sc-ic-empty-state-h,.action-area.sc-ic-empty-state{display:flex;flex-direction:column}/*!@.action-area*/.action-area.sc-ic-empty-state{gap:var(--ic-space-md)}/*!@:host ::slotted(svg),\n:host ::slotted(img)*/.sc-ic-empty-state-h .sc-ic-empty-state-s>svg,.sc-ic-empty-state-h.sc-ic-empty-state-s>img,.sc-ic-empty-state-h .sc-ic-empty-state-s>img{border-radius:var(--ic-space-xxs)}/*!@:host(.right),\n:host(.right) .action-area*/.right.sc-ic-empty-state-h,.right.sc-ic-empty-state-h .action-area.sc-ic-empty-state{align-items:flex-end;text-align:right}/*!@:host(.center),\n:host(.center) .action-area*/.center.sc-ic-empty-state-h,.center.sc-ic-empty-state-h .action-area.sc-ic-empty-state{align-items:center;text-align:center}/*!@:host(.image-default) ::slotted(svg),\n:host(.image-default) ::slotted(img)*/.sc-ic-empty-state-h.image-default .sc-ic-empty-state-s>svg,.sc-ic-empty-state-h.image-default.sc-ic-empty-state-s>img,.sc-ic-empty-state-h.image-default .sc-ic-empty-state-s>img{height:calc(3 * var(--ic-space-lg)) !important;width:calc(3 * var(--ic-space-lg)) !important}/*!@:host(.image-small) ::slotted(svg),\n:host(.image-small) ::slotted(img)*/.sc-ic-empty-state-h.image-small .sc-ic-empty-state-s>svg,.sc-ic-empty-state-h.image-small.sc-ic-empty-state-s>img,.sc-ic-empty-state-h.image-small .sc-ic-empty-state-s>img{height:var(--ic-space-xxl) !important;width:var(--ic-space-xxl) !important}/*!@:host(.image-large) ::slotted(svg),\n:host(.image-large) ::slotted(img)*/.sc-ic-empty-state-h.image-large .sc-ic-empty-state-s>svg,.sc-ic-empty-state-h.image-large.sc-ic-empty-state-s>img,.sc-ic-empty-state-h.image-large .sc-ic-empty-state-s>img{height:calc(4 * var(--ic-space-xl)) !important;width:calc(4 * var(--ic-space-xl)) !important}";

/**
 * @slot image - Content is placed at the top above all other content.
 * @slot actions - Content is placed at the bottom below all other content.
 * @slot heading - Content will be rendered in place of the heading prop.
 * @slot subheading - Content will be rendered in place of the subheading prop.
 * @slot body - Content will be rendered in place of the body prop.
 */
class EmptyState {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.hostMutationObserver = null;
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, [
                    "image",
                    "actions",
                ])
                : false)) ;
        };
        this.aligned = "left";
        this.body = undefined;
        this.bodyMaxLines = undefined;
        this.heading = undefined;
        this.imageSize = "default";
        this.subheading = undefined;
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentDidLoad() {
        !isSlotUsed(this.el, "heading") &&
            onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Empty State");
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            childList: true,
        });
    }
    render() {
        const { aligned, body, bodyMaxLines, heading, imageSize, subheading } = this;
        return (hAsync(Host, { class: {
                [`${aligned}`]: true,
                [`image-${imageSize}`]: isSlotUsed(this.el, "image"),
            } }, isSlotUsed(this.el, "image") && hAsync("slot", { name: "image" }), hAsync("div", null, hAsync("slot", { name: "heading" }, hAsync("ic-typography", { variant: "h4" }, heading)), hAsync("slot", { name: "subheading" }, hAsync("ic-typography", { variant: "subtitle-small" }, subheading)), hAsync("slot", { name: "body" }, hAsync("ic-typography", { maxLines: bodyMaxLines }, body))), isSlotUsed(this.el, "actions") && (hAsync("div", { class: "action-area" }, hAsync("slot", { name: "actions" })))));
    }
    get el() { return getElement(this); }
    static get style() { return icEmptyStateCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-empty-state",
        "$members$": {
            "aligned": [1],
            "body": [1],
            "bodyMaxLines": [2, "body-max-lines"],
            "heading": [1],
            "imageSize": [1, "image-size"],
            "subheading": [1]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icFooterCss = "/*!@html*/html.sc-ic-footer{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-footer{margin:0}/*!@main*/main.sc-ic-footer{display:block}/*!@h1*/h1.sc-ic-footer{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-footer{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-footer{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-footer{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-footer{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-footer,strong.sc-ic-footer{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-footer,kbd.sc-ic-footer,samp.sc-ic-footer{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-footer{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-footer,sup.sc-ic-footer{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-footer{bottom:-0.25em}/*!@sup*/sup.sc-ic-footer{top:-0.5em}/*!@img*/img.sc-ic-footer{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-footer,input.sc-ic-footer,optgroup.sc-ic-footer,select.sc-ic-footer,textarea.sc-ic-footer{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-footer,input.sc-ic-footer{overflow:visible}/*!@button,\nselect*/button.sc-ic-footer,select.sc-ic-footer{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-footer,[type=\"button\"].sc-ic-footer,[type=\"reset\"].sc-ic-footer,[type=\"submit\"].sc-ic-footer{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-footer::-moz-focus-inner,[type=\"button\"].sc-ic-footer::-moz-focus-inner,[type=\"reset\"].sc-ic-footer::-moz-focus-inner,[type=\"submit\"].sc-ic-footer::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-footer:-moz-focusring,[type=\"button\"].sc-ic-footer:-moz-focusring,[type=\"reset\"].sc-ic-footer:-moz-focusring,[type=\"submit\"].sc-ic-footer:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-footer{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-footer{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-footer{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-footer{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-footer,[type=\"radio\"].sc-ic-footer{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-footer::-webkit-inner-spin-button,[type=\"number\"].sc-ic-footer::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-footer{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-footer::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-footer::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-footer{display:block}/*!@summary*/summary.sc-ic-footer{display:list-item}/*!@template*/template.sc-ic-footer{display:none}/*!@[hidden]*/[hidden].sc-ic-footer{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-footer,body.sc-ic-footer,div.sc-ic-footer,span.sc-ic-footer,applet.sc-ic-footer,object.sc-ic-footer,iframe.sc-ic-footer,h1.sc-ic-footer,h2.sc-ic-footer,h3.sc-ic-footer,h4.sc-ic-footer,h5.sc-ic-footer,h6.sc-ic-footer,p.sc-ic-footer,blockquote.sc-ic-footer,pre.sc-ic-footer,a.sc-ic-footer,abbr.sc-ic-footer,acronym.sc-ic-footer,address.sc-ic-footer,big.sc-ic-footer,cite.sc-ic-footer,code.sc-ic-footer,del.sc-ic-footer,dfn.sc-ic-footer,em.sc-ic-footer,img.sc-ic-footer,ins.sc-ic-footer,kbd.sc-ic-footer,q.sc-ic-footer,s.sc-ic-footer,samp.sc-ic-footer,small.sc-ic-footer,strike.sc-ic-footer,strong.sc-ic-footer,sub.sc-ic-footer,sup.sc-ic-footer,tt.sc-ic-footer,var.sc-ic-footer,b.sc-ic-footer,u.sc-ic-footer,i.sc-ic-footer,center.sc-ic-footer,dl.sc-ic-footer,dt.sc-ic-footer,dd.sc-ic-footer,ol.sc-ic-footer,ul.sc-ic-footer,li.sc-ic-footer,fieldset.sc-ic-footer,form.sc-ic-footer,label.sc-ic-footer,legend.sc-ic-footer,table.sc-ic-footer,caption.sc-ic-footer,tbody.sc-ic-footer,tfoot.sc-ic-footer,thead.sc-ic-footer,tr.sc-ic-footer,th.sc-ic-footer,td.sc-ic-footer,article.sc-ic-footer,aside.sc-ic-footer,canvas.sc-ic-footer,details.sc-ic-footer,embed.sc-ic-footer,figure.sc-ic-footer,figcaption.sc-ic-footer,footer.sc-ic-footer,header.sc-ic-footer,hgroup.sc-ic-footer,menu.sc-ic-footer,nav.sc-ic-footer,output.sc-ic-footer,ruby.sc-ic-footer,section.sc-ic-footer,summary.sc-ic-footer,time.sc-ic-footer,mark.sc-ic-footer,audio.sc-ic-footer,video.sc-ic-footer{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-footer-h{display:block;--footer-compliance-padding:1rem 0}/*!@:host(.footer-sparse)*/.footer-sparse.sc-ic-footer-h{--footer-links-padding:1.5rem 0;--footer-logo-margin-bottom:var(--ic-space-lg);--footer-link-inner-flex-direction:row}/*!@:host(.footer-small)*/.footer-small.sc-ic-footer-h{--footer-links-padding:0 0;--footer-logo-margin-bottom:var(--ic-space-md);--footer-link-inner-flex-direction:column}/*!@:host(.footer-light)*/.footer-light.sc-ic-footer-h{--footer-theme-secondary:var(--ic-theme-secondary);--footer-theme-tertiary:var(--ic-theme-tertiary);--footer-keyline:var(--ic-keyline-lighten)}/*!@:host(.footer-dark)*/.footer-dark.sc-ic-footer-h{--footer-theme-secondary:var(--ic-theme-secondary-light);--footer-theme-tertiary:var(--ic-theme-tertiary-light);--footer-keyline:var(--ic-keyline-darken)}/*!@:host(.footer-small.footer-ungrouped)*/.footer-small.footer-ungrouped.sc-ic-footer-h{--footer-links-padding:var(--ic-space-md) 0 0 0}/*!@footer*/footer.sc-ic-footer{display:flex;flex-direction:column;width:100%}/*!@.footer-description*/.footer-description.sc-ic-footer{background-color:var(--footer-theme-secondary);color:var(--ic-theme-text);border-bottom:var(--footer-keyline)}/*!@.footer-description-inner*/.footer-description-inner.sc-ic-footer{padding:1rem 0}/*!@.footer-links*/.footer-links.sc-ic-footer{padding:var(--footer-links-padding);background-color:var(--footer-theme-secondary);color:var(--ic-theme-text)}/*!@.footer-links-inner*/.footer-links-inner.sc-ic-footer{display:flex;flex-direction:var(--footer-link-inner-flex-direction)}/*!@.footer-compliance*/.footer-compliance.sc-ic-footer{background-color:var(--footer-theme-tertiary);color:var(--ic-theme-text)}/*!@.footer-compliance-inner*/.footer-compliance-inner.sc-ic-footer{padding:var(--footer-compliance-padding)}/*!@.footer-logo*/.footer-logo.sc-ic-footer{margin-bottom:var(--footer-logo-margin-bottom);display:flex;gap:var(--ic-space-xxl)}/*!@.footer-logo > ::slotted()*/.footer-logo>.sc-ic-footer-h{margin-right:var(--ic-space-md)}/*!@.footer-caption*/.footer-caption.sc-ic-footer{margin-bottom:var(--ic-space-md)}/*!@.classification-spacing*/.classification-spacing.sc-ic-footer{margin-bottom:var(--ic-space-lg)}@media (forced-colors: active){/*!@footer*/footer.sc-ic-footer{border-top:var(--ic-hc-border)}}";

/**
 * @slot description - Content will be rendered at the top of the footer.
 * @slot link - Content will be rendered between description and logos.
 * @slot logo - Content will be rendered underneath footer links.
 * @slot caption - Content will be rendered above Crown Copyright.
 */
class Footer {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.footerResized = createEvent(this, "footerResized", 7);
        this.resizeObserver = null;
        this.resizeObserverCallback = (currSize) => {
            if (currSize !== this.deviceSize) {
                this.deviceSize = currSize;
            }
            this.footerResized.emit();
        };
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                const currSize = getCurrentDeviceSize();
                this.resizeObserverCallback(currSize);
            });
            this.resizeObserver.observe(this.footerEl);
        };
        this.deviceSize = IC_DEVICE_SIZES.XL;
        this.foregroundColor = getThemeForegroundColor();
        this.aligned = "left";
        this.breakpoint = "medium";
        this.caption = undefined;
        this.copyright = true;
        this.description = undefined;
        this.groupLinks = false;
    }
    disconnectedCallback() {
        if (this.resizeObserver !== null) {
            this.resizeObserver.disconnect();
        }
    }
    componentWillLoad() {
        this.deviceSize = getCurrentDeviceSize();
    }
    componentDidLoad() {
        checkResizeObserver(this.runResizeObserver);
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    isSmall() {
        const bp = this.breakpoint;
        return bp === "extra small"
            ? this.deviceSize < IC_DEVICE_SIZES.XS
            : bp === "small"
                ? this.deviceSize < IC_DEVICE_SIZES.S
                : bp === "medium"
                    ? this.deviceSize < IC_DEVICE_SIZES.M
                    : bp === "large"
                        ? this.deviceSize < IC_DEVICE_SIZES.L
                        : bp === "extra large"
                            ? this.deviceSize < IC_DEVICE_SIZES.XL
                            : false;
    }
    render() {
        const { aligned, caption, copyright, description, groupLinks, foregroundColor, } = this;
        const small = this.isSmall();
        return (hAsync(Host, { class: {
                footer: true,
                [`footer-${small ? "small" : "sparse"}`]: true,
                [`footer-${groupLinks ? "grouped" : "ungrouped"}`]: true,
                [`footer-${foregroundColor}`]: true,
                // Slots will be able to infer their own color
                [IcThemeForegroundEnum.Dark]: foregroundColor === IcThemeForegroundEnum.Dark,
                [IcThemeForegroundEnum.Light]: foregroundColor === IcThemeForegroundEnum.Light,
            } }, hAsync("footer", { ref: (footerEl) => (this.footerEl = footerEl) }, (isSlotUsed(this.el, "description") || description) && (hAsync("div", { class: "footer-description" }, hAsync("ic-section-container", { aligned: aligned, fullHeight: true }, hAsync("div", { class: "footer-description-inner" }, hAsync("ic-typography", { variant: "body" }, hAsync("slot", { name: "description" }, description)))))), isSlotUsed(this.el, "link") && (hAsync("div", { class: "footer-links" }, groupLinks && small ? (hAsync("div", { class: "footer-links-inner", role: "list" }, hAsync("slot", { name: "link" }))) : (hAsync("ic-section-container", { fullHeight: true, aligned: aligned }, hAsync("div", { class: "footer-links-inner", role: "list" }, hAsync("slot", { name: "link" })))))), hAsync("div", { class: "footer-compliance" }, hAsync("ic-section-container", { aligned: aligned, fullHeight: true }, hAsync("div", { class: "footer-compliance-inner" }, isSlotUsed(this.el, "logo") && (hAsync("div", { class: "footer-logo" }, hAsync("slot", { name: "logo" }))), (isSlotUsed(this.el, "caption") || caption) && (hAsync("div", { class: "footer-caption" }, hAsync("ic-typography", { variant: this.deviceSize <= IC_DEVICE_SIZES.M
                ? "caption"
                : "body" }, hAsync("slot", { name: "caption" }, caption)))), copyright && (hAsync("div", { class: {
                ["footer-copyright"]: true,
                ["classification-spacing"]: hasClassificationBanner(),
            } }, hAsync("ic-typography", { variant: this.deviceSize <= IC_DEVICE_SIZES.M
                ? "caption-uppercase"
                : "label-uppercase" }, "\u00A9 Crown Copyright")))))))));
    }
    get el() { return getElement(this); }
    static get style() { return icFooterCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-footer",
        "$members$": {
            "aligned": [1],
            "breakpoint": [1],
            "caption": [1],
            "copyright": [4],
            "description": [1],
            "groupLinks": [4, "group-links"],
            "deviceSize": [32],
            "foregroundColor": [32]
        },
        "$listeners$": [[4, "themeChange", "themeChangeHandler"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

var OpenInNew = `<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 19H5V5h7V3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2v-7h-2v7zM14 3v2h3.59l-9.83 9.83 1.41 1.41L19 6.41V10h2V3h-7z"/></svg>`;

const icFooterLinkCss = "/*!@html*/html.sc-ic-footer-link{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-footer-link{margin:0}/*!@main*/main.sc-ic-footer-link{display:block}/*!@h1*/h1.sc-ic-footer-link{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-footer-link{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-footer-link{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-footer-link{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-footer-link{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-footer-link,strong.sc-ic-footer-link{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-footer-link,kbd.sc-ic-footer-link,samp.sc-ic-footer-link{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-footer-link{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-footer-link,sup.sc-ic-footer-link{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-footer-link{bottom:-0.25em}/*!@sup*/sup.sc-ic-footer-link{top:-0.5em}/*!@img*/img.sc-ic-footer-link{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-footer-link,input.sc-ic-footer-link,optgroup.sc-ic-footer-link,select.sc-ic-footer-link,textarea.sc-ic-footer-link{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-footer-link,input.sc-ic-footer-link{overflow:visible}/*!@button,\nselect*/button.sc-ic-footer-link,select.sc-ic-footer-link{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-footer-link,[type=\"button\"].sc-ic-footer-link,[type=\"reset\"].sc-ic-footer-link,[type=\"submit\"].sc-ic-footer-link{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-footer-link::-moz-focus-inner,[type=\"button\"].sc-ic-footer-link::-moz-focus-inner,[type=\"reset\"].sc-ic-footer-link::-moz-focus-inner,[type=\"submit\"].sc-ic-footer-link::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-footer-link:-moz-focusring,[type=\"button\"].sc-ic-footer-link:-moz-focusring,[type=\"reset\"].sc-ic-footer-link:-moz-focusring,[type=\"submit\"].sc-ic-footer-link:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-footer-link{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-footer-link{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-footer-link{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-footer-link{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-footer-link,[type=\"radio\"].sc-ic-footer-link{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-footer-link::-webkit-inner-spin-button,[type=\"number\"].sc-ic-footer-link::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-footer-link{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-footer-link::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-footer-link::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-footer-link{display:block}/*!@summary*/summary.sc-ic-footer-link{display:list-item}/*!@template*/template.sc-ic-footer-link{display:none}/*!@[hidden]*/[hidden].sc-ic-footer-link{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-footer-link,body.sc-ic-footer-link,div.sc-ic-footer-link,span.sc-ic-footer-link,applet.sc-ic-footer-link,object.sc-ic-footer-link,iframe.sc-ic-footer-link,h1.sc-ic-footer-link,h2.sc-ic-footer-link,h3.sc-ic-footer-link,h4.sc-ic-footer-link,h5.sc-ic-footer-link,h6.sc-ic-footer-link,p.sc-ic-footer-link,blockquote.sc-ic-footer-link,pre.sc-ic-footer-link,a.sc-ic-footer-link,abbr.sc-ic-footer-link,acronym.sc-ic-footer-link,address.sc-ic-footer-link,big.sc-ic-footer-link,cite.sc-ic-footer-link,code.sc-ic-footer-link,del.sc-ic-footer-link,dfn.sc-ic-footer-link,em.sc-ic-footer-link,img.sc-ic-footer-link,ins.sc-ic-footer-link,kbd.sc-ic-footer-link,q.sc-ic-footer-link,s.sc-ic-footer-link,samp.sc-ic-footer-link,small.sc-ic-footer-link,strike.sc-ic-footer-link,strong.sc-ic-footer-link,sub.sc-ic-footer-link,sup.sc-ic-footer-link,tt.sc-ic-footer-link,var.sc-ic-footer-link,b.sc-ic-footer-link,u.sc-ic-footer-link,i.sc-ic-footer-link,center.sc-ic-footer-link,dl.sc-ic-footer-link,dt.sc-ic-footer-link,dd.sc-ic-footer-link,ol.sc-ic-footer-link,ul.sc-ic-footer-link,li.sc-ic-footer-link,fieldset.sc-ic-footer-link,form.sc-ic-footer-link,label.sc-ic-footer-link,legend.sc-ic-footer-link,table.sc-ic-footer-link,caption.sc-ic-footer-link,tbody.sc-ic-footer-link,tfoot.sc-ic-footer-link,thead.sc-ic-footer-link,tr.sc-ic-footer-link,th.sc-ic-footer-link,td.sc-ic-footer-link,article.sc-ic-footer-link,aside.sc-ic-footer-link,canvas.sc-ic-footer-link,details.sc-ic-footer-link,embed.sc-ic-footer-link,figure.sc-ic-footer-link,figcaption.sc-ic-footer-link,footer.sc-ic-footer-link,header.sc-ic-footer-link,hgroup.sc-ic-footer-link,menu.sc-ic-footer-link,nav.sc-ic-footer-link,output.sc-ic-footer-link,ruby.sc-ic-footer-link,section.sc-ic-footer-link,summary.sc-ic-footer-link,time.sc-ic-footer-link,mark.sc-ic-footer-link,audio.sc-ic-footer-link,video.sc-ic-footer-link{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host(.footer-link-ungrouped-sparse)*/.footer-link-ungrouped-sparse.sc-ic-footer-link-h{--footer-link-margin-left:0;--footer-link-margin-right:2.5rem;--footer-link-margin-bottom:0}/*!@:host(.footer-link-ungrouped-small)*/.footer-link-ungrouped-small.sc-ic-footer-link-h{--footer-link-margin-left:0;--footer-link-margin-right:0;--footer-link-margin-bottom:var(--ic-space-md)}/*!@:host(.footer-link-grouped-sparse)*/.footer-link-grouped-sparse.sc-ic-footer-link-h{--footer-link-margin-left:0;--footer-link-margin-right:0;--footer-link-margin-bottom:var(--ic-space-md)}/*!@:host(.footer-link-grouped-small)*/.footer-link-grouped-small.sc-ic-footer-link-h{--footer-link-margin-left:var(--ic-space-md);--footer-link-margin-right:0;--footer-link-margin-bottom:var(--ic-space-md)}/*!@:host(.footer-link)*/.footer-link.sc-ic-footer-link-h{margin-left:var(--footer-link-margin-left);margin-right:var(--footer-link-margin-right);margin-bottom:var(--footer-link-margin-bottom)}/*!@:host(.footer-link) a,\n:host(.footer-link) a ::slotted(a)*/.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a{display:flex;align-items:flex-end;font-weight:var(--ic-font-weight-bold);color:inherit;width:-moz-fit-content;width:fit-content;font-size:var(--ic-font-size-regular)}/*!@:host(.footer-link) a:link,\n:host(.footer-link) a ::slotted(a:link)*/.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:link,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link{color:inherit;text-decoration:underline;font-weight:var(--ic-font-weight-bold)}/*!@:host(.footer-link) a:link > ::slotted(svg),\n:host(.footer-link) a:link > ::slotted(img),\n:host(.footer-link) a ::slotted(a:link > ::slotted(svg)),\n:host(.footer-link) a ::slotted(a:link > ::slotted(img))*/.sc-ic-footer-link-h.footer-link a:link>.sc-ic-footer-link-s>svg,.sc-ic-footer-link-h.footer-link a:link>.sc-ic-footer-link-s>img,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link>-shadowcssslotted(svg),.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link>-shadowcssslotted(svg),.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link>-shadowcssslotted(img),.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link>-shadowcssslotted(img){padding:var(--ic-space-xxxs);pointer-events:none;transition:var(--ic-easing-transition-fast)}/*!@:host(.footer-link-light) ::slotted(svg)*/.sc-ic-footer-link-h.footer-link-light .sc-ic-footer-link-s>svg{fill:var(--ic-architectural-white)}/*!@:host(.footer-link-dark) ::slotted(svg)*/.sc-ic-footer-link-h.footer-link-dark.sc-ic-footer-link-s>svg,.sc-ic-footer-link-h.footer-link-dark .sc-ic-footer-link-s>svg{fill:var(--ic-architectural-black)}/*!@:host(.footer-link) a:link:hover,\n:host(.footer-link) a:link:focus,\n:host(.footer-link) a ::slotted(a:link:hover),\n:host(.footer-link) a ::slotted(a:link:focus)*/.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:link:hover,.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:link:focus,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:hover,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link:hover,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:focus,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link:focus{border-bottom:0.25rem solid !important;margin-bottom:-0.25rem !important;text-decoration:none}@supports (text-underline-offset: 25%){/*!@:host(.footer-link) a:link:hover,\n  :host(.footer-link) a:link:focus,\n  :host(.footer-link) a ::slotted(a:link:hover),\n  :host(.footer-link) a ::slotted(a:link:focus)*/.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:link:hover,.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:link:focus,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:hover,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link:hover,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:focus,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link:focus{text-decoration-line:underline;text-decoration-thickness:25%;text-underline-offset:25%;border-bottom:0 !important;margin-bottom:0 !important}}/*!@:host(.footer-link) a:link:hover,\n:host(.footer-link) a ::slotted(a:link:hover)*/.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:link:hover,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:hover,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link:hover{outline:none}/*!@:host(.footer-link) a:link:focus,\n:host(.footer-link) a ::slotted(a:link:focus)*/.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:link:focus,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:focus,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link:focus{outline:none}/*!@:host(.footer-link) a:link:focus > ::slotted(svg),\n:host(.footer-link) a:link:focus > ::slotted(img),\n:host(.footer-link) a ::slotted(a:link:focus > ::slotted(svg)),\n:host(.footer-link) a ::slotted(a:link:focus > ::slotted(img))*/.sc-ic-footer-link-h.footer-link a:link:focus>.sc-ic-footer-link-s>svg,.sc-ic-footer-link-h.footer-link a:link:focus>.sc-ic-footer-link-s>img,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:focus,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:focus>-shadowcssslotted(svg),.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link:focus>-shadowcssslotted(svg),.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:focus>-shadowcssslotted(img),.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link:focus>-shadowcssslotted(img){box-shadow:var(--ic-border-focus);border-radius:var(--ic-border-radius)}/*!@:host(.footer-link) a:focus,\n:host(.footer-link) a ::slotted(a:focus)*/.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:focus,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:focus,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:focus{outline:none;transition:var(--ic-transition-duration-fast)}/*!@:host(.footer-link) a:link:active,\n:host(.footer-link) a:link:focus:active,\n:host(.footer-link) a:link:visited:active,\n:host(.footer-link) a ::slotted(a:link:active),\n:host(.footer-link) a ::slotted(a:link:focus:active),\n:host(.footer-link) a ::slotted(a:link:visited:active)*/.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:link:active,.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:link:focus:active,.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:link:visited:active,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:active,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link:active,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:focus,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:focus:active,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link:focus:active,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:link:visited:active,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:link:visited:active{color:inherit;text-decoration:none}/*!@:host(.footer-link) a:hover,\n:host(.footer-link) a ::slotted(a:hover)*/.footer-link.sc-ic-footer-link-h a.sc-ic-footer-link:hover,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a,.sc-ic-footer-link-h.footer-link a.sc-ic-footer-link-s>a:hover,.sc-ic-footer-link-h.footer-link a .sc-ic-footer-link-s>a:hover{text-decoration:none}/*!@.open-in-new-icon*/.open-in-new-icon.sc-ic-footer-link{padding-left:var(--ic-space-xxs)}/*!@.open-in-new-icon,\n.open-in-new-icon svg*/.open-in-new-icon.sc-ic-footer-link,.open-in-new-icon.sc-ic-footer-link svg.sc-ic-footer-link{height:var(--ic-space-md);width:var(--ic-space-md)}/*!@:host(.footer-link-light) .open-in-new-icon svg*/.footer-link-light.sc-ic-footer-link-h .open-in-new-icon.sc-ic-footer-link svg.sc-ic-footer-link{fill:var(--ic-architectural-white)}/*!@:host(.footer-link-dark) .open-in-new-icon svg*/.footer-link-dark.sc-ic-footer-link-h .open-in-new-icon.sc-ic-footer-link svg.sc-ic-footer-link{fill:var(--ic-architectural-black)}@media screen and (min-width: 769px){/*!@:host(.footer-link.footer-link-ungrouped-sparse:last-of-type)*/.footer-link.footer-link-ungrouped-sparse.sc-ic-footer-link-h:last-of-type{margin-right:0}}@media (forced-colors: active){/*!@:host(.footer-link-light) ::slotted(svg),\n  :host(.footer-link-dark) ::slotted(svg)*/.sc-ic-footer-link-h.footer-link-light .sc-ic-footer-link-s>svg,.sc-ic-footer-link-h.footer-link-dark.sc-ic-footer-link-s>svg,.sc-ic-footer-link-h.footer-link-dark .sc-ic-footer-link-s>svg{fill:currentcolor}}";

class FooterLink {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.deviceSize = DEVICE_SIZES.XL;
        this.footerConfig = { small: false, grouped: false };
        this.foregroundColor = getThemeForegroundColor();
        this.download = false;
        this.href = null;
        this.hreflang = undefined;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.target = undefined;
    }
    componentWillLoad() {
        this.footerConfig = this.inferConfig(this.el);
    }
    footerResizeHandler() {
        this.footerConfig = this.inferConfig(this.el);
    }
    footerThemeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    inferConfig(e) {
        if (e.parentElement !== null) {
            if (e.parentElement.classList.contains("footer")) {
                return {
                    small: e.parentElement.classList.contains("footer-small"),
                    grouped: e.parentElement.classList.contains("footer-grouped"),
                };
            }
            else {
                return this.inferConfig(e.parentElement);
            }
        }
        else {
            return { small: false, grouped: false };
        }
    }
    render() {
        const { footerConfig, href, hreflang, referrerpolicy, rel, target, download, } = this;
        const { small, grouped } = footerConfig;
        return (hAsync(Host, { class: {
                "footer-link": true,
                [`footer-link-${grouped ? "grouped" : "ungrouped"}-${small ? "small" : "sparse"}`]: true,
                [`footer-link-${this.foregroundColor}`]: true,
            }, role: "listitem" }, hAsync("a", { href: href, hreflang: hreflang, referrerPolicy: referrerpolicy, rel: rel, download: download !== false ? download : null, target: target }, hAsync("slot", null), target === "_blank" && (hAsync("span", { class: "open-in-new-icon", innerHTML: OpenInNew })))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get style() { return icFooterLinkCss; }
    static get cmpMeta() { return {
        "$flags$": 25,
        "$tagName$": "ic-footer-link",
        "$members$": {
            "download": [8],
            "href": [1],
            "hreflang": [1],
            "referrerpolicy": [1],
            "rel": [1],
            "target": [1],
            "deviceSize": [32],
            "footerConfig": [32],
            "foregroundColor": [32]
        },
        "$listeners$": [[4, "footerResized", "footerResizeHandler"], [4, "themeChange", "footerThemeChangeHandler"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icFooterLinkGroupCss = "/*!@html*/html.sc-ic-footer-link-group{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-footer-link-group{margin:0}/*!@main*/main.sc-ic-footer-link-group{display:block}/*!@h1*/h1.sc-ic-footer-link-group{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-footer-link-group{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-footer-link-group{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-footer-link-group{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-footer-link-group{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-footer-link-group,strong.sc-ic-footer-link-group{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-footer-link-group,kbd.sc-ic-footer-link-group,samp.sc-ic-footer-link-group{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-footer-link-group{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-footer-link-group,sup.sc-ic-footer-link-group{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-footer-link-group{bottom:-0.25em}/*!@sup*/sup.sc-ic-footer-link-group{top:-0.5em}/*!@img*/img.sc-ic-footer-link-group{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-footer-link-group,input.sc-ic-footer-link-group,optgroup.sc-ic-footer-link-group,select.sc-ic-footer-link-group,textarea.sc-ic-footer-link-group{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-footer-link-group,input.sc-ic-footer-link-group{overflow:visible}/*!@button,\nselect*/button.sc-ic-footer-link-group,select.sc-ic-footer-link-group{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-footer-link-group,[type=\"button\"].sc-ic-footer-link-group,[type=\"reset\"].sc-ic-footer-link-group,[type=\"submit\"].sc-ic-footer-link-group{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-footer-link-group::-moz-focus-inner,[type=\"button\"].sc-ic-footer-link-group::-moz-focus-inner,[type=\"reset\"].sc-ic-footer-link-group::-moz-focus-inner,[type=\"submit\"].sc-ic-footer-link-group::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-footer-link-group:-moz-focusring,[type=\"button\"].sc-ic-footer-link-group:-moz-focusring,[type=\"reset\"].sc-ic-footer-link-group:-moz-focusring,[type=\"submit\"].sc-ic-footer-link-group:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-footer-link-group{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-footer-link-group{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-footer-link-group{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-footer-link-group{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-footer-link-group,[type=\"radio\"].sc-ic-footer-link-group{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-footer-link-group::-webkit-inner-spin-button,[type=\"number\"].sc-ic-footer-link-group::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-footer-link-group{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-footer-link-group::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-footer-link-group::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-footer-link-group{display:block}/*!@summary*/summary.sc-ic-footer-link-group{display:list-item}/*!@template*/template.sc-ic-footer-link-group{display:none}/*!@[hidden]*/[hidden].sc-ic-footer-link-group{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-footer-link-group,body.sc-ic-footer-link-group,div.sc-ic-footer-link-group,span.sc-ic-footer-link-group,applet.sc-ic-footer-link-group,object.sc-ic-footer-link-group,iframe.sc-ic-footer-link-group,h1.sc-ic-footer-link-group,h2.sc-ic-footer-link-group,h3.sc-ic-footer-link-group,h4.sc-ic-footer-link-group,h5.sc-ic-footer-link-group,h6.sc-ic-footer-link-group,p.sc-ic-footer-link-group,blockquote.sc-ic-footer-link-group,pre.sc-ic-footer-link-group,a.sc-ic-footer-link-group,abbr.sc-ic-footer-link-group,acronym.sc-ic-footer-link-group,address.sc-ic-footer-link-group,big.sc-ic-footer-link-group,cite.sc-ic-footer-link-group,code.sc-ic-footer-link-group,del.sc-ic-footer-link-group,dfn.sc-ic-footer-link-group,em.sc-ic-footer-link-group,img.sc-ic-footer-link-group,ins.sc-ic-footer-link-group,kbd.sc-ic-footer-link-group,q.sc-ic-footer-link-group,s.sc-ic-footer-link-group,samp.sc-ic-footer-link-group,small.sc-ic-footer-link-group,strike.sc-ic-footer-link-group,strong.sc-ic-footer-link-group,sub.sc-ic-footer-link-group,sup.sc-ic-footer-link-group,tt.sc-ic-footer-link-group,var.sc-ic-footer-link-group,b.sc-ic-footer-link-group,u.sc-ic-footer-link-group,i.sc-ic-footer-link-group,center.sc-ic-footer-link-group,dl.sc-ic-footer-link-group,dt.sc-ic-footer-link-group,dd.sc-ic-footer-link-group,ol.sc-ic-footer-link-group,ul.sc-ic-footer-link-group,li.sc-ic-footer-link-group,fieldset.sc-ic-footer-link-group,form.sc-ic-footer-link-group,label.sc-ic-footer-link-group,legend.sc-ic-footer-link-group,table.sc-ic-footer-link-group,caption.sc-ic-footer-link-group,tbody.sc-ic-footer-link-group,tfoot.sc-ic-footer-link-group,thead.sc-ic-footer-link-group,tr.sc-ic-footer-link-group,th.sc-ic-footer-link-group,td.sc-ic-footer-link-group,article.sc-ic-footer-link-group,aside.sc-ic-footer-link-group,canvas.sc-ic-footer-link-group,details.sc-ic-footer-link-group,embed.sc-ic-footer-link-group,figure.sc-ic-footer-link-group,figcaption.sc-ic-footer-link-group,footer.sc-ic-footer-link-group,header.sc-ic-footer-link-group,hgroup.sc-ic-footer-link-group,menu.sc-ic-footer-link-group,nav.sc-ic-footer-link-group,output.sc-ic-footer-link-group,ruby.sc-ic-footer-link-group,section.sc-ic-footer-link-group,summary.sc-ic-footer-link-group,time.sc-ic-footer-link-group,mark.sc-ic-footer-link-group,audio.sc-ic-footer-link-group,video.sc-ic-footer-link-group{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host(.footer-link-group-sparse)*/.footer-link-group-sparse.sc-ic-footer-link-group-h{--footer-link-group-margin-right:5.938rem;--footer-link-group-border-bottom:0 solid transparent;--footer-link-group-title-margin-top:0;--footer-link-group-title-margin-bottom:var(--ic-space-md)}/*!@:host(.footer-link-group-small)*/.footer-link-group-small.sc-ic-footer-link-group-h{--footer-link-group-margin-right:0;--footer-link-group-title-margin-top:var(--ic-space-md);--footer-link-group-title-margin-bottom:var(--ic-space-md);--footer-link-group-links-padding-left:var(--ic-space-md);--footer-link-group-links-padding-bottom:var(--ic-space-md)}/*!@:host(.footer-link-group-light.footer-link-group-small)*/.footer-link-group-light.footer-link-group-small.sc-ic-footer-link-group-h{--footer-link-group-border-bottom:var(--ic-keyline-lighten)}/*!@:host(.footer-link-group-dark.footer-link-group-small)*/.footer-link-group-dark.footer-link-group-small.sc-ic-footer-link-group-h{--footer-link-group-border-bottom:var(--ic-keyline-darken)}/*!@:host(.footer-link-group)*/.footer-link-group.sc-ic-footer-link-group-h{margin-right:var(--footer-link-group-margin-right);border-bottom:var(--footer-link-group-border-bottom)}/*!@:host(.footer-link-group-small.footer-link-group-light:hover)*/.footer-link-group-small.footer-link-group-light.sc-ic-footer-link-group-h:hover{background-color:var(--ic-action-light-bg-hover);cursor:pointer}/*!@:host(.footer-link-group-small.footer-link-group-dark:hover)*/.footer-link-group-small.footer-link-group-dark.sc-ic-footer-link-group-h:hover{background-color:var(--ic-action-dark-bg-hover);cursor:pointer}/*!@:host(.footer-link-group-sparse:focus)*/.footer-link-group-sparse.sc-ic-footer-link-group-h:focus{box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset);outline:var(--ic-hc-focus-outline);z-index:1}/*!@:host(.footer-link-group-small:focus)*/.footer-link-group-small.sc-ic-footer-link-group-h:focus{box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset);outline:var(--ic-hc-focus-outline);z-index:1}/*!@:host(.footer-link-group-small.footer-link-group-light:active)*/.footer-link-group-small.footer-link-group-light.sc-ic-footer-link-group-h:active{background-color:var(--ic-action-light-bg-active)}/*!@:host(.footer-link-group-small.footer-link-group-dark:active)*/.footer-link-group-small.footer-link-group-dark.sc-ic-footer-link-group-h:active{background-color:var(--ic-action-dark-bg-active)}/*!@.footer-link-group-title*/.footer-link-group-title.sc-ic-footer-link-group{margin-top:var(--footer-link-group-title-margin-top);margin-bottom:var(--footer-link-group-title-margin-bottom);flex-grow:1}/*!@.footer-link-group-toggle*/.footer-link-group-toggle.sc-ic-footer-link-group{fill:white !important}/*!@.footer-link-group-links*/.footer-link-group-links.sc-ic-footer-link-group{display:flex;flex-direction:column}/*!@.footer-link-group-header*/.footer-link-group-header.sc-ic-footer-link-group{display:flex;align-items:center}";

class FooterLinkGroup {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.handleKeydown = (event) => {
            if (event.key === " " || event.key === "Enter") {
                this.toggleExpanded();
            }
        };
        this.toggleExpanded = () => {
            this.expanded = !this.expanded;
        };
        this.expanded = false;
        this.deviceSize = DEVICE_SIZES.XL;
        this.dropdownIconStyle = getThemeForegroundColor();
        this.small = false;
        this.groupTitle = undefined;
    }
    componentWillLoad() {
        this.small = this.isSmall(this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.groupTitle, propName: "group-title" }], "Footer Link Group");
    }
    footerResizeHandler() {
        this.small = this.isSmall(this.el);
    }
    footerThemeChangeHandler(ev) {
        const theme = ev.detail;
        this.dropdownIconStyle = theme.mode;
    }
    isSmall(e) {
        if (e.parentElement !== null) {
            if (e.parentElement.classList.contains("footer")) {
                return e.parentElement.classList.contains("footer-small");
            }
            else {
                return this.isSmall(e.parentElement);
            }
        }
        else {
            return false;
        }
    }
    render() {
        const { small, groupTitle } = this;
        return !small ? (hAsync(Host, { class: {
                ["footer-link-group footer-link-group-sparse"]: true,
                [`footer-link-group-${this.dropdownIconStyle}`]: true,
            }, role: "listitem" }, hAsync("div", { class: "footer-link-group-title" }, hAsync("ic-typography", { variant: "subtitle-small" }, groupTitle)), hAsync("div", { class: "footer-link-group-links", role: "list" }, hAsync("slot", null)))) : (hAsync(Host, { class: {
                ["footer-link-group footer-link-group-small"]: true,
                [`footer-link-group-${this.dropdownIconStyle}`]: true,
            }, tabIndex: "1", onClick: this.toggleExpanded, onKeydown: this.handleKeydown, "aria-expanded": this.expanded }, hAsync("ic-section-container", { fullHeight: true }, hAsync("div", { class: "footer-link-group-header" }, hAsync("div", { class: "footer-link-group-title" }, hAsync("ic-typography", { variant: "label" }, groupTitle)), this.expanded ? (hAsync("svg", { class: "footer-link-group-toggle", xmlns: "http://www.w3.org/2000/svg", "aria-hidden": "true", role: "img", width: "1em", height: "1em", preserveAspectRatio: "xMidYMid meet", viewBox: "0 0 1200 1200" }, hAsync("path", { fill: "currentColor", d: "M600.002 210.605L421.285 389.336L0 810.559l178.721 178.836l421.281-421.341l421.281 421.341L1200 810.559L778.733 389.336L600.002 210.605z" }))) : (hAsync("svg", { class: "footer-link-group-toggle", xmlns: "http://www.w3.org/2000/svg", "aria-hidden": "true", role: "img", width: "1em", height: "1em", preserveAspectRatio: "xMidYMid meet", viewBox: "0 0 1200 1200" }, hAsync("g", { transform: "translate(0 1200) scale(1 -1)" }, hAsync("path", { fill: "currentColor", d: "M600.002 210.605L421.285 389.336L0 810.559l178.721 178.836l421.281-421.341l421.281 421.341L1200 810.559L778.733 389.336L600.002 210.605z" }))))), this.expanded && (hAsync("div", { class: "footer-link-group-links", role: "list" }, hAsync("slot", null))))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get style() { return icFooterLinkGroupCss; }
    static get cmpMeta() { return {
        "$flags$": 25,
        "$tagName$": "ic-footer-link-group",
        "$members$": {
            "groupTitle": [1, "group-title"],
            "expanded": [32],
            "deviceSize": [32],
            "dropdownIconStyle": [32],
            "small": [32]
        },
        "$listeners$": [[4, "footerResized", "footerResizeHandler"], [4, "themeChange", "footerThemeChangeHandler"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icHeroCss = "/*!@html*/html.sc-ic-hero{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-hero{margin:0}/*!@main*/main.sc-ic-hero{display:block}/*!@h1*/h1.sc-ic-hero{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-hero{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-hero{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-hero{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-hero{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-hero,strong.sc-ic-hero{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-hero,kbd.sc-ic-hero,samp.sc-ic-hero{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-hero{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-hero,sup.sc-ic-hero{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-hero{bottom:-0.25em}/*!@sup*/sup.sc-ic-hero{top:-0.5em}/*!@img*/img.sc-ic-hero{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-hero,input.sc-ic-hero,optgroup.sc-ic-hero,select.sc-ic-hero,textarea.sc-ic-hero{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-hero,input.sc-ic-hero{overflow:visible}/*!@button,\nselect*/button.sc-ic-hero,select.sc-ic-hero{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-hero,[type=\"button\"].sc-ic-hero,[type=\"reset\"].sc-ic-hero,[type=\"submit\"].sc-ic-hero{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-hero::-moz-focus-inner,[type=\"button\"].sc-ic-hero::-moz-focus-inner,[type=\"reset\"].sc-ic-hero::-moz-focus-inner,[type=\"submit\"].sc-ic-hero::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-hero:-moz-focusring,[type=\"button\"].sc-ic-hero:-moz-focusring,[type=\"reset\"].sc-ic-hero:-moz-focusring,[type=\"submit\"].sc-ic-hero:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-hero{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-hero{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-hero{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-hero{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-hero,[type=\"radio\"].sc-ic-hero{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-hero::-webkit-inner-spin-button,[type=\"number\"].sc-ic-hero::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-hero{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-hero::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-hero::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-hero{display:block}/*!@summary*/summary.sc-ic-hero{display:list-item}/*!@template*/template.sc-ic-hero{display:none}/*!@[hidden]*/[hidden].sc-ic-hero{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-hero,body.sc-ic-hero,div.sc-ic-hero,span.sc-ic-hero,applet.sc-ic-hero,object.sc-ic-hero,iframe.sc-ic-hero,h1.sc-ic-hero,h2.sc-ic-hero,h3.sc-ic-hero,h4.sc-ic-hero,h5.sc-ic-hero,h6.sc-ic-hero,p.sc-ic-hero,blockquote.sc-ic-hero,pre.sc-ic-hero,a.sc-ic-hero,abbr.sc-ic-hero,acronym.sc-ic-hero,address.sc-ic-hero,big.sc-ic-hero,cite.sc-ic-hero,code.sc-ic-hero,del.sc-ic-hero,dfn.sc-ic-hero,em.sc-ic-hero,img.sc-ic-hero,ins.sc-ic-hero,kbd.sc-ic-hero,q.sc-ic-hero,s.sc-ic-hero,samp.sc-ic-hero,small.sc-ic-hero,strike.sc-ic-hero,strong.sc-ic-hero,sub.sc-ic-hero,sup.sc-ic-hero,tt.sc-ic-hero,var.sc-ic-hero,b.sc-ic-hero,u.sc-ic-hero,i.sc-ic-hero,center.sc-ic-hero,dl.sc-ic-hero,dt.sc-ic-hero,dd.sc-ic-hero,ol.sc-ic-hero,ul.sc-ic-hero,li.sc-ic-hero,fieldset.sc-ic-hero,form.sc-ic-hero,label.sc-ic-hero,legend.sc-ic-hero,table.sc-ic-hero,caption.sc-ic-hero,tbody.sc-ic-hero,tfoot.sc-ic-hero,thead.sc-ic-hero,tr.sc-ic-hero,th.sc-ic-hero,td.sc-ic-hero,article.sc-ic-hero,aside.sc-ic-hero,canvas.sc-ic-hero,details.sc-ic-hero,embed.sc-ic-hero,figure.sc-ic-hero,figcaption.sc-ic-hero,footer.sc-ic-hero,header.sc-ic-hero,hgroup.sc-ic-hero,menu.sc-ic-hero,nav.sc-ic-hero,output.sc-ic-hero,ruby.sc-ic-hero,section.sc-ic-hero,summary.sc-ic-hero,time.sc-ic-hero,mark.sc-ic-hero,audio.sc-ic-hero,video.sc-ic-hero{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-hero-h{display:block;background-color:var(--ic-theme-tertiary);color:var(--ic-theme-text);--hero-heading-bottom-margin:var(--ic-space-md)}/*!@:host(.dark)*/.dark.sc-ic-hero-h{background-color:var(--ic-theme-secondary)}/*!@:host(.has-background-image)*/.has-background-image.sc-ic-hero-h{background-repeat:no-repeat;background-position:right -6.25rem;background-size:auto calc(100% + 6.25rem);box-shadow:var(--ic-elevation-inset)}@media (prefers-reduced-motion){/*!@:host(.has-background-image)*/.has-background-image.sc-ic-hero-h{background-position:right -6.25rem !important}}/*!@ic-typography.heading-bottom-spacing*/ic-typography.heading-bottom-spacing.sc-ic-hero{margin-bottom:var(--hero-heading-bottom-margin)}/*!@.section-container*/.section-container.sc-ic-hero{display:flex;align-items:center;height:100%}/*!@.left-container*/.left-container.sc-ic-hero{padding:var(--ic-space-xl) 0}/*!@.left-container:not(.left-container-full-width)*/.left-container.sc-ic-hero:not(.left-container-full-width){flex-basis:50%}/*!@.left-container-full-width*/.left-container-full-width.sc-ic-hero{width:100%}/*!@.right-container*/.right-container.sc-ic-hero{flex-basis:50%}/*!@.interaction-container*/.interaction-container.sc-ic-hero{display:flex;gap:var(--ic-space-md);margin-top:var(--ic-space-lg);flex-wrap:wrap}/*!@.secondary-container*/.secondary-container.sc-ic-hero{display:flex;flex-direction:column;justify-content:center;border-left:var(--ic-space-xxxs) solid var(--ic-theme-text)}/*!@.secondary-subheading*/.secondary-subheading.sc-ic-hero{margin-top:var(--ic-space-xxs)}/*!@:host([content-aligned=\"left\"]) .left-container,\n:host([content-aligned=\"left\"]) .interaction-container*/[content-aligned=\"left\"].sc-ic-hero-h .left-container.sc-ic-hero,[content-aligned=\"left\"].sc-ic-hero-h .interaction-container.sc-ic-hero{justify-content:flex-start;text-align:left}/*!@:host([content-aligned=\"center\"]) .left-container,\n:host([content-aligned=\"center\"]) .interaction-container*/[content-aligned=\"center\"].sc-ic-hero-h .left-container.sc-ic-hero,[content-aligned=\"center\"].sc-ic-hero-h .interaction-container.sc-ic-hero{justify-content:center;text-align:center}@media (min-width: 992px){/*!@.left-container-full-width*/.left-container-full-width.sc-ic-hero{width:66.6%}}@media (min-width: 1044px){/*!@:host,\n  .section-container*/.sc-ic-hero-h,.section-container.sc-ic-hero{min-height:13rem}/*!@:host(.small),\n  :host(.small) .section-container*/.small.sc-ic-hero-h,.small.sc-ic-hero-h .section-container.sc-ic-hero{min-height:10.813rem}/*!@.left-container:not(.left-container-full-width)*/.left-container.sc-ic-hero:not(.left-container-full-width){flex-basis:66.6%}/*!@.left-container*/.left-container.sc-ic-hero{min-height:9rem}/*!@.right-container*/.right-container.sc-ic-hero{flex-basis:33.3%;margin-left:3.125rem}/*!@.secondary-container*/.secondary-container.sc-ic-hero{min-height:9rem}/*!@.secondary-heading,\n  .secondary-subheading*/.secondary-heading.sc-ic-hero,.secondary-subheading.sc-ic-hero{margin-left:3.938rem}}@media (min-width: 801px) and (max-width: 1043px){/*!@:host(.has-background-image)*/.has-background-image.sc-ic-hero-h{background-image:none !important}/*!@:host,\n  .section-container*/.sc-ic-hero-h,.section-container.sc-ic-hero{min-height:16rem}/*!@:host(.small),\n  :host(.small) .section-container*/.small.sc-ic-hero-h,.small.sc-ic-hero-h .section-container.sc-ic-hero{min-height:15rem}/*!@:host(.secondary-heading),\n  :host(.secondary-heading) .section-container*/.secondary-heading.sc-ic-hero-h,.secondary-heading.sc-ic-hero-h .section-container.sc-ic-hero{min-height:14rem}/*!@.left-container*/.left-container.sc-ic-hero{min-height:10rem}/*!@.secondary-container*/.secondary-container.sc-ic-hero{min-height:10rem}/*!@.secondary-heading,\n  .secondary-subheading*/.secondary-heading.sc-ic-hero,.secondary-subheading.sc-ic-hero{margin-left:5.922rem}/*!@.right-container*/.right-container.sc-ic-hero{margin-left:3.125rem}}@media (min-width: 641px) and (max-width: 800px){/*!@:host(.has-background-image)*/.has-background-image.sc-ic-hero-h{background-image:none !important}/*!@:host,\n  .section-container*/.sc-ic-hero-h,.section-container.sc-ic-hero{min-height:16rem}/*!@:host(.small),\n  :host(.small) .section-container*/.small.sc-ic-hero-h,.small.sc-ic-hero-h .section-container.sc-ic-hero{min-height:15rem}/*!@:host(.secondary-heading),\n  :host(.secondary-heading) .section-container*/.secondary-heading.sc-ic-hero-h,.secondary-heading.sc-ic-hero-h .section-container.sc-ic-hero{min-height:14rem}/*!@.left-container*/.left-container.sc-ic-hero{min-height:10rem}/*!@.secondary-container*/.secondary-container.sc-ic-hero{min-height:10rem}/*!@.secondary-heading,\n  .secondary-subheading*/.secondary-heading.sc-ic-hero,.secondary-subheading.sc-ic-hero{margin-left:2.125rem}/*!@.right-container*/.right-container.sc-ic-hero{margin-left:3.125rem}}@media (min-width: 481px) and (max-width: 640px){/*!@:host(.has-background-image)*/.has-background-image.sc-ic-hero-h{background-image:none !important}/*!@:host,\n  .section-container*/.sc-ic-hero-h,.section-container.sc-ic-hero{min-height:13rem}/*!@:host(.small),\n  :host(.small) .section-container*/.small.sc-ic-hero-h,.small.sc-ic-hero-h .section-container.sc-ic-hero{min-height:10.813rem}/*!@:host(.secondary-heading),\n  :host(.secondary-heading) .section-container*/.secondary-heading.sc-ic-hero-h,.secondary-heading.sc-ic-hero-h .section-container.sc-ic-hero{min-height:17.5rem}/*!@:host(.secondary-heading) .section-container,\n  :host(.small) .section-container,\n  .section-container*/.secondary-heading.sc-ic-hero-h .section-container.sc-ic-hero,.small.sc-ic-hero-h .section-container.sc-ic-hero,.section-container.sc-ic-hero{flex-direction:column;align-items:flex-start}/*!@.left-container*/.left-container.sc-ic-hero{height:-moz-fit-content;height:fit-content}/*!@.secondary-container*/.secondary-container.sc-ic-hero{height:-moz-fit-content;height:fit-content;border:none}/*!@.right-container*/.right-container.sc-ic-hero{margin-bottom:2.5rem}}@media (max-width: 480px){/*!@:host(.has-background-image)*/.has-background-image.sc-ic-hero-h{background-image:none !important}/*!@:host,\n  .section-container*/.sc-ic-hero-h,.section-container.sc-ic-hero{min-height:12rem}/*!@:host,\n  .right-container*/.sc-ic-hero-h,.right-container.sc-ic-hero{margin-bottom:var(--ic-space-md)}/*!@:host(.small),\n  :host(.small) .section-container*/.small.sc-ic-hero-h,.small.sc-ic-hero-h .section-container.sc-ic-hero{min-height:10.813rem}/*!@:host(.secondary-heading),\n  :host(.secondary-heading) .section-container*/.secondary-heading.sc-ic-hero-h,.secondary-heading.sc-ic-hero-h .section-container.sc-ic-hero{min-height:16.5rem}/*!@:host(.secondary-heading) .section-container,\n  :host(.small) .section-container,\n  .section-container*/.secondary-heading.sc-ic-hero-h .section-container.sc-ic-hero,.small.sc-ic-hero-h .section-container.sc-ic-hero,.section-container.sc-ic-hero{flex-direction:column;align-items:flex-start}/*!@.left-container*/.left-container.sc-ic-hero{height:-moz-fit-content;height:fit-content}/*!@.secondary-container*/.secondary-container.sc-ic-hero{height:-moz-fit-content;height:fit-content;border:none}}";

/**
 * @slot heading - Content will be rendered in the title area, in place of the heading.
 * @slot subheading - Content will be rendered in the title area, in place of the subheading.
 * @slot interaction - Content will be rendered in the interaction area, adjacent to the title area.
 * @slot secondary - Content will be rendered in the secondary content area.
 */
class Hero {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.hostMutationObserver = null;
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, "secondary")
                : false)) ;
        };
        this.foregroundColor = getThemeForegroundColor();
        this.rightContent = false;
        this.leftContentFullWidth = !this.rightContent && this.secondaryHeading === undefined;
        this.scrollFactor = "right -100px";
        this.aligned = "left";
        this.backgroundImage = undefined;
        this.contentAligned = "left";
        this.disableBackgroundParallax = false;
        this.heading = undefined;
        this.secondaryHeading = undefined;
        this.secondarySubheading = undefined;
        this.size = "default";
        this.small = false;
        this.subheading = undefined;
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentWillLoad() {
        this.rightContent = slotHasContent(this.el, "secondary");
    }
    componentDidLoad() {
        !isSlotUsed(this.el, "heading") &&
            onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Hero");
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            childList: true,
        });
    }
    componentWillRender() {
        this.rightContent = slotHasContent(this.el, "secondary");
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    doScroll() {
        if (this.disableBackgroundParallax) {
            return;
        }
        const scrolltotop = document.scrollingElement.scrollTop;
        const factor = 0.4;
        const y = -100 + scrolltotop * factor;
        this.scrollFactor = "right " + y + "px";
    }
    render() {
        const { aligned, small, size, heading, subheading, secondaryHeading, secondarySubheading, foregroundColor, backgroundImage, scrollFactor, } = this;
        let style = {};
        if (isPropDefined(backgroundImage)) {
            style = {
                "background-image": "url(" + backgroundImage + ")",
                "background-position": scrollFactor,
            };
        }
        return (hAsync(Host, { class: {
                [IcThemeForegroundEnum.Dark]: foregroundColor === IcThemeForegroundEnum.Dark,
                ["has-background-image"]: backgroundImage !== undefined,
                ["small"]: small || size === "small",
                ["secondary-heading"]: !!secondaryHeading,
            }, style: style }, hAsync("ic-section-container", { aligned: aligned, fullHeight: true, class: "section-container" }, hAsync("div", { class: {
                ["left-container"]: true,
                ["left-container-full-width"]: this.leftContentFullWidth,
            } }, hAsync("div", { class: "heading" }, hAsync("slot", { name: "heading" }, hAsync("ic-typography", { variant: small || size === "small" ? "h2" : "h1", class: {
                ["heading-bottom-spacing"]: !small && size !== "small",
            } }, heading))), hAsync("div", { class: "subheading" }, hAsync("slot", { name: "subheading" }, hAsync("ic-typography", { variant: "body" }, subheading))), hAsync("div", { class: "interaction-container" }, hAsync("slot", { name: "interaction" }))), (isPropDefined(secondaryHeading) || this.rightContent) && (hAsync("div", { class: "right-container" }, hAsync("slot", { name: "secondary" }, secondaryHeading && (hAsync("div", { class: "secondary-container" }, hAsync("div", { class: "secondary-heading" }, hAsync("ic-typography", { variant: "h4" }, secondaryHeading)), hAsync("div", { class: "secondary-subheading" }, hAsync("ic-typography", { variant: "subtitle-small" }, secondarySubheading))))))))));
    }
    get el() { return getElement(this); }
    static get style() { return icHeroCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-hero",
        "$members$": {
            "aligned": [1],
            "backgroundImage": [1, "background-image"],
            "contentAligned": [1, "content-aligned"],
            "disableBackgroundParallax": [4, "disable-background-parallax"],
            "heading": [1],
            "secondaryHeading": [1, "secondary-heading"],
            "secondarySubheading": [1, "secondary-subheading"],
            "size": [1],
            "small": [4],
            "subheading": [1],
            "foregroundColor": [32],
            "rightContent": [32],
            "leftContentFullWidth": [32],
            "scrollFactor": [32]
        },
        "$listeners$": [[4, "themeChange", "themeChangeHandler"], [5, "scroll", "doScroll"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

var LeftArrow = `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
  <path d="M13.0875 6.175L11.9125 5L6.91251 10L11.9125 15L13.0875 13.825L9.27084 10L13.0875 6.175Z"/>
</svg>`;

var RightArrow = `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
  <path d="M8.08748 5L6.91248 6.175L10.7291 10L6.91248 13.825L8.08748 15L13.0875 10L8.08748 5Z"/>
</svg>`;

const icHorizontalScrollCss = "/*!@html*/html.sc-ic-horizontal-scroll{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-horizontal-scroll{margin:0}/*!@main*/main.sc-ic-horizontal-scroll{display:block}/*!@h1*/h1.sc-ic-horizontal-scroll{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-horizontal-scroll{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-horizontal-scroll{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-horizontal-scroll{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-horizontal-scroll{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-horizontal-scroll,strong.sc-ic-horizontal-scroll{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-horizontal-scroll,kbd.sc-ic-horizontal-scroll,samp.sc-ic-horizontal-scroll{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-horizontal-scroll{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-horizontal-scroll,sup.sc-ic-horizontal-scroll{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-horizontal-scroll{bottom:-0.25em}/*!@sup*/sup.sc-ic-horizontal-scroll{top:-0.5em}/*!@img*/img.sc-ic-horizontal-scroll{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-horizontal-scroll,input.sc-ic-horizontal-scroll,optgroup.sc-ic-horizontal-scroll,select.sc-ic-horizontal-scroll,textarea.sc-ic-horizontal-scroll{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-horizontal-scroll,input.sc-ic-horizontal-scroll{overflow:visible}/*!@button,\nselect*/button.sc-ic-horizontal-scroll,select.sc-ic-horizontal-scroll{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-horizontal-scroll,[type=\"button\"].sc-ic-horizontal-scroll,[type=\"reset\"].sc-ic-horizontal-scroll,[type=\"submit\"].sc-ic-horizontal-scroll{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-horizontal-scroll::-moz-focus-inner,[type=\"button\"].sc-ic-horizontal-scroll::-moz-focus-inner,[type=\"reset\"].sc-ic-horizontal-scroll::-moz-focus-inner,[type=\"submit\"].sc-ic-horizontal-scroll::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-horizontal-scroll:-moz-focusring,[type=\"button\"].sc-ic-horizontal-scroll:-moz-focusring,[type=\"reset\"].sc-ic-horizontal-scroll:-moz-focusring,[type=\"submit\"].sc-ic-horizontal-scroll:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-horizontal-scroll{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-horizontal-scroll{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-horizontal-scroll{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-horizontal-scroll{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-horizontal-scroll,[type=\"radio\"].sc-ic-horizontal-scroll{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-horizontal-scroll::-webkit-inner-spin-button,[type=\"number\"].sc-ic-horizontal-scroll::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-horizontal-scroll{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-horizontal-scroll::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-horizontal-scroll::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-horizontal-scroll{display:block}/*!@summary*/summary.sc-ic-horizontal-scroll{display:list-item}/*!@template*/template.sc-ic-horizontal-scroll{display:none}/*!@[hidden]*/[hidden].sc-ic-horizontal-scroll{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-horizontal-scroll,body.sc-ic-horizontal-scroll,div.sc-ic-horizontal-scroll,span.sc-ic-horizontal-scroll,applet.sc-ic-horizontal-scroll,object.sc-ic-horizontal-scroll,iframe.sc-ic-horizontal-scroll,h1.sc-ic-horizontal-scroll,h2.sc-ic-horizontal-scroll,h3.sc-ic-horizontal-scroll,h4.sc-ic-horizontal-scroll,h5.sc-ic-horizontal-scroll,h6.sc-ic-horizontal-scroll,p.sc-ic-horizontal-scroll,blockquote.sc-ic-horizontal-scroll,pre.sc-ic-horizontal-scroll,a.sc-ic-horizontal-scroll,abbr.sc-ic-horizontal-scroll,acronym.sc-ic-horizontal-scroll,address.sc-ic-horizontal-scroll,big.sc-ic-horizontal-scroll,cite.sc-ic-horizontal-scroll,code.sc-ic-horizontal-scroll,del.sc-ic-horizontal-scroll,dfn.sc-ic-horizontal-scroll,em.sc-ic-horizontal-scroll,img.sc-ic-horizontal-scroll,ins.sc-ic-horizontal-scroll,kbd.sc-ic-horizontal-scroll,q.sc-ic-horizontal-scroll,s.sc-ic-horizontal-scroll,samp.sc-ic-horizontal-scroll,small.sc-ic-horizontal-scroll,strike.sc-ic-horizontal-scroll,strong.sc-ic-horizontal-scroll,sub.sc-ic-horizontal-scroll,sup.sc-ic-horizontal-scroll,tt.sc-ic-horizontal-scroll,var.sc-ic-horizontal-scroll,b.sc-ic-horizontal-scroll,u.sc-ic-horizontal-scroll,i.sc-ic-horizontal-scroll,center.sc-ic-horizontal-scroll,dl.sc-ic-horizontal-scroll,dt.sc-ic-horizontal-scroll,dd.sc-ic-horizontal-scroll,ol.sc-ic-horizontal-scroll,ul.sc-ic-horizontal-scroll,li.sc-ic-horizontal-scroll,fieldset.sc-ic-horizontal-scroll,form.sc-ic-horizontal-scroll,label.sc-ic-horizontal-scroll,legend.sc-ic-horizontal-scroll,table.sc-ic-horizontal-scroll,caption.sc-ic-horizontal-scroll,tbody.sc-ic-horizontal-scroll,tfoot.sc-ic-horizontal-scroll,thead.sc-ic-horizontal-scroll,tr.sc-ic-horizontal-scroll,th.sc-ic-horizontal-scroll,td.sc-ic-horizontal-scroll,article.sc-ic-horizontal-scroll,aside.sc-ic-horizontal-scroll,canvas.sc-ic-horizontal-scroll,details.sc-ic-horizontal-scroll,embed.sc-ic-horizontal-scroll,figure.sc-ic-horizontal-scroll,figcaption.sc-ic-horizontal-scroll,footer.sc-ic-horizontal-scroll,header.sc-ic-horizontal-scroll,hgroup.sc-ic-horizontal-scroll,menu.sc-ic-horizontal-scroll,nav.sc-ic-horizontal-scroll,output.sc-ic-horizontal-scroll,ruby.sc-ic-horizontal-scroll,section.sc-ic-horizontal-scroll,summary.sc-ic-horizontal-scroll,time.sc-ic-horizontal-scroll,mark.sc-ic-horizontal-scroll,audio.sc-ic-horizontal-scroll,video.sc-ic-horizontal-scroll{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-horizontal-scroll-h{--border-bottom-color:var(--ic-architectural-300);--splitter-color:var(--ic-architectural-100);display:flex;max-width:100%}/*!@:host(.light)*/.light.sc-ic-horizontal-scroll-h{--splitter-color:var(--ic-keyline-lighten-rgb)}/*!@:host(.dark)*/.dark.sc-ic-horizontal-scroll-h{--splitter-color:var(--ic-keyline-darken-rgb)}/*!@::slotted(*)*/.sc-ic-horizontal-scroll-s>*{overflow-x:scroll;overflow-y:hidden;scroll-behavior:smooth;scrollbar-width:none;-ms-overflow-style:none;margin:calc(var(--ic-space-xs) * -1) !important;padding:var(--ic-space-xs) !important}/*!@:host(.visible) ::slotted(*)*/.sc-ic-horizontal-scroll-h.visible .sc-ic-horizontal-scroll-s>*{margin:calc(var(--ic-space-xs) * -1) 0 !important;padding:var(--ic-space-xs) !important}/*!@.tabs-container::-webkit-scrollbar*/.tabs-container.sc-ic-horizontal-scroll::-webkit-scrollbar{display:none}/*!@.scroll-container-left,\n.scroll-container-right*/.scroll-container-left.sc-ic-horizontal-scroll,.scroll-container-right.sc-ic-horizontal-scroll{display:flex}/*!@.scroll-container-left*/.scroll-container-left.sc-ic-horizontal-scroll{margin-left:var(--ic-space-xxs)}/*!@.scroll-container-right*/.scroll-container-right.sc-ic-horizontal-scroll{margin-right:var(--ic-space-xxs)}/*!@.hidden*/.hidden.sc-ic-horizontal-scroll{display:none}/*!@.scroll-arrow*/.scroll-arrow.sc-ic-horizontal-scroll{margin:var(--ic-space-xxs) 0}/*!@.disabled .ic-tooltip-container*/.disabled.sc-ic-horizontal-scroll .ic-tooltip-container.sc-ic-horizontal-scroll{display:none !important}/*!@.scroll-splitter-left,\n.scroll-splitter-right*/.scroll-splitter-left.sc-ic-horizontal-scroll,.scroll-splitter-right.sc-ic-horizontal-scroll{display:flex;height:var(--ic-space-lg);width:var(--ic-space-1px);margin-top:var(--ic-space-xs);border-radius:var(--ic-space-1px);background-color:var(--splitter-color)}/*!@.scroll-splitter-left*/.scroll-splitter-left.sc-ic-horizontal-scroll{margin-left:calc(var(--ic-space-xxs) - var(--ic-space-1px))}/*!@.scroll-splitter-right*/.scroll-splitter-right.sc-ic-horizontal-scroll{margin-right:calc(var(--ic-space-xxs) - var(--ic-space-1px))}/*!@.disabled .scroll-splitter-left,\n.disabled .scroll-splitter-right*/.disabled.sc-ic-horizontal-scroll .scroll-splitter-left.sc-ic-horizontal-scroll,.disabled.sc-ic-horizontal-scroll .scroll-splitter-right.sc-ic-horizontal-scroll{background-color:transparent}/*!@.disabled ic-button > svg*/.disabled.sc-ic-horizontal-scroll ic-button.sc-ic-horizontal-scroll>svg.sc-ic-horizontal-scroll{color:var(--ic-keyline-darken-rgb)}/*!@:host(.dark) .disabled ic-button > svg,\n:host(.light) .disabled ic-button > svg*/.dark.sc-ic-horizontal-scroll-h .disabled.sc-ic-horizontal-scroll ic-button.sc-ic-horizontal-scroll>svg.sc-ic-horizontal-scroll,.light.sc-ic-horizontal-scroll-h .disabled.sc-ic-horizontal-scroll ic-button.sc-ic-horizontal-scroll>svg.sc-ic-horizontal-scroll{color:var(--splitter-color) !important}";

const SCROLL_DELAY_MS = 200;
class HorizontalScroll {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.buttonStateSet = false;
        this.focusHandler = (event) => {
            this.itemFocusHandler(Array.from(this.items).indexOf(event.target));
        };
        this.resizeObserverCallback = () => {
            if (this.el.clientWidth >= this.itemsContainerEl.scrollWidth) {
                this.itemOverflow = false;
            }
            else {
                this.itemOverflow = elementOverflowsX(this.itemsContainerEl);
            }
            if (this.itemOverflow) {
                this.lastItemVisible =
                    this.itemsContainerEl.offsetWidth + this.itemsContainerEl.scrollLeft >=
                        this.itemsContainerEl.scrollWidth;
            }
        };
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                this.resizeObserverCallback();
            });
            this.resizeObserver.observe(this.itemsContainerEl);
        };
        this.scrollLeft = () => {
            this.scrollItemIntoView(this.getCurrentLeftItem() - 1);
        };
        this.scrollRight = () => {
            this.scrollItemIntoView(this.getCurrentLeftItem() + 1);
        };
        this.longScrollRight = () => {
            this.scrollRight();
            this.scrollDelay = window.setTimeout(this.longScrollRight, SCROLL_DELAY_MS);
        };
        this.longScrollLeft = () => {
            this.scrollLeft();
            this.scrollDelay = window.setTimeout(this.longScrollLeft, SCROLL_DELAY_MS);
        };
        this.leftArrowMouseDownHandler = (e) => {
            e.preventDefault();
            this.scrollDelay = window.setTimeout(this.longScrollLeft, SCROLL_DELAY_MS);
        };
        this.rightArrowMouseDownHandler = (e) => {
            e.preventDefault();
            this.scrollDelay = window.setTimeout(this.longScrollRight, SCROLL_DELAY_MS);
        };
        this.arrowMouseUpHandler = () => {
            window.clearTimeout(this.scrollDelay);
        };
        this.getCurrentLeftItem = () => {
            const index = this.itemOffsets.findIndex((el) => el > Math.round(this.itemsContainerEl.scrollLeft));
            return index < 0 ? 0 : index;
        };
        this.scrollHandler = () => {
            window.clearTimeout(this.isScrolling);
            // Set a timeout to run after scrolling ends
            this.isScrolling = window.setTimeout(this.scrollStopped, 50);
        };
        this.scrollStopped = () => {
            // If scrollItemIntoView has been called, the button states will already be set
            // Can't just handle it here as it causes strange jumping behaviour in positioning
            const scrollLeft = Math.round(this.itemsContainerEl.scrollLeft);
            if (this.buttonStateSet === false) {
                this.firstItemVisible = scrollLeft === 0;
                this.lastItemVisible =
                    this.itemsContainerEl.offsetWidth + scrollLeft >=
                        this.itemsContainerEl.scrollWidth;
            }
            this.buttonStateSet = false;
        };
        this.firstItemVisible = true;
        this.itemOverflow = false;
        this.lastItemVisible = false;
        this.appearance = "default";
        this.focusTrigger = "focus";
    }
    componentWillLoad() {
        this.itemsContainerEl = this.el.children[0];
        this.itemsContainerEl.addEventListener("scroll", this.scrollHandler);
        this.items = getSlotElements(this.itemsContainerEl);
        this.items.forEach((item) => {
            if (item.addEventListener) {
                item.addEventListener(this.focusTrigger, this.focusHandler);
            }
        });
    }
    componentDidLoad() {
        let runningTotal = 0;
        this.itemOffsets = this.items.map((item) => {
            runningTotal += item.offsetWidth;
            return runningTotal;
        });
        checkResizeObserver(this.runResizeObserver);
        // Add event listener to scroll containers as mouse events are not fired on disabled elements (ic-button's <button>)
        // 'mouseleave' needed in case the user moves their mouse while holding the arrow buttons
        // - 'mouseup' otherwise not detected and scrolling not stopped
        const scrollArrows = Array.from(this.el.shadowRoot.querySelectorAll("div"));
        ["mouseup", "mouseleave"].forEach((event) => {
            scrollArrows.forEach((arrow) => arrow.addEventListener(event, this.arrowMouseUpHandler));
        });
    }
    disconnectedCallback() {
        if (this.resizeObserver !== undefined) {
            this.resizeObserver.disconnect();
        }
        const scrollArrows = Array.from(this.el.shadowRoot.querySelectorAll("div"));
        ["mouseup", "mouseleave"].forEach((event) => {
            scrollArrows.forEach((arrow) => arrow.removeEventListener(event, this.arrowMouseUpHandler));
        });
        this.items.forEach((item) => {
            if (item.removeEventListener) {
                item.removeEventListener(this.focusTrigger, this.focusHandler);
            }
        });
        this.itemsContainerEl.removeEventListener("scroll", this.scrollHandler);
    }
    /**
     * @internal if side scrolling enabled, scrolls the specified item into view.
     */
    async scrollItemIntoView(itemPosition) {
        this.firstItemVisible = itemPosition <= 0;
        const newScrollPos = itemPosition <= 0 ? 0 : this.itemOffsets[itemPosition - 1];
        this.lastItemVisible =
            this.itemsContainerEl.offsetWidth + newScrollPos >=
                this.itemsContainerEl.scrollWidth;
        this.buttonStateSet = true;
        this.itemsContainerEl.scrollLeft = newScrollPos;
    }
    itemFocusHandler(itemPosition) {
        if (this.itemOverflow) {
            this.scrollItemIntoView(itemPosition);
        }
    }
    render() {
        const { appearance, firstItemVisible, lastItemVisible, itemOverflow } = this;
        return (hAsync(Host, { class: {
                ["visible"]: itemOverflow,
                ["dark"]: this.appearance === IcThemeForegroundEnum.Dark,
                ["light"]: this.appearance === IcThemeForegroundEnum.Light,
            } }, hAsync("div", { "aria-hidden": "true", class: {
                ["scroll-container-left"]: true,
                ["hidden"]: !itemOverflow,
                ["disabled"]: firstItemVisible,
            }, role: "tab" }, hAsync("ic-button", { class: "scroll-arrow", variant: "icon", "aria-label": "Scroll left", appearance: appearance, innerHTML: LeftArrow, disabled: firstItemVisible, tabindex: "-1", onClick: this.scrollLeft, onMouseDown: this.leftArrowMouseDownHandler }), hAsync("span", { class: "scroll-splitter-left" })), hAsync("slot", null), hAsync("div", { "aria-hidden": "true", class: {
                ["scroll-container-right"]: true,
                ["hidden"]: !itemOverflow,
                ["disabled"]: lastItemVisible,
            }, role: "tab" }, hAsync("span", { class: "scroll-splitter-right" }), hAsync("ic-button", { class: "scroll-arrow", variant: "icon", "aria-label": "Scroll right", appearance: appearance, innerHTML: RightArrow, disabled: lastItemVisible, tabindex: "-1", onClick: this.scrollRight, onMouseDown: this.rightArrowMouseDownHandler }))));
    }
    get el() { return getElement(this); }
    static get style() { return icHorizontalScrollCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-horizontal-scroll",
        "$members$": {
            "appearance": [1],
            "focusTrigger": [1, "focus-trigger"],
            "firstItemVisible": [32],
            "itemOverflow": [32],
            "lastItemVisible": [32],
            "scrollItemIntoView": [64]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icInputComponentContainerCss = "ic-input-component-container{display:flex;border:var(--ic-border-width) solid\n    var(--border-color, var(--ic-architectural-400));border-radius:var(--ic-border-radius);transition:var(--ic-easing-transition-slow);height:2.5rem;width:var(--input-width, 20rem);padding:var(--ic-space-1px);background-color:var(--ic-architectural-white);box-sizing:border-box;fill:var(--ic-architectural-400);outline:none}ic-input-component-container.fullwidth{width:100%}ic-input-component-container.disabled,ic-input-component-container.disabled:hover{border:var(--ic-border-width) dashed var(--ic-architectural-200)}ic-input-component-container.readonly,ic-input-component-container.readonly:hover{border:none;padding:0}ic-input-component-container.error{border:var(--ic-error-border-default);padding:0}ic-input-component-container.error:hover{border:var(--ic-error-border-hover)}ic-input-component-container.error:focus-within{border:var(--ic-error-border-pressed)}ic-input-component-container.warning{border:var(--ic-warning-border-default);padding:0}ic-input-component-container.warning:hover{border:var(--ic-warning-border-hover)}ic-input-component-container.warning:focus-within{border:var(--ic-warning-border-pressed)}ic-input-component-container.success{border:var(--ic-success-border-default);padding:0}ic-input-component-container.success:hover{border:var(--ic-success-border-hover)}ic-input-component-container.success:focus-within{border:var(--ic-success-border-pressed)}ic-input-component-container.small{height:var(--ic-space-xl)}ic-input-component-container.large{height:var(--ic-space-xxl)}ic-input-component-container.multiline{height:auto}ic-input-component-container .icon-container{margin-top:var(--ic-space-xxs);margin-left:0.438rem;display:flex;align-items:center}ic-input-component-container.multiline .icon-container,ic-input-component-container.multiline.small .icon-container{margin-top:0.375rem;display:block}ic-input-component-container.readonly .icon-container{margin-left:-0.313rem}ic-input-component-container.disabled ::-moz-placeholder{display:none}ic-input-component-container.disabled ::placeholder{display:none}ic-input-component-container .inline-success{margin:var(--ic-space-xs) 0.375rem;display:flex;align-items:center}ic-input-component-container.dark:hover{--border-color:var(--ic-architectural-400)}ic-input-component-container .inline-success>svg{fill:var(--ic-status-success);height:1.25rem;width:1.25rem}ic-input-component-container:hover{border:var(--ic-border-hover);color:var(--ic-action-dark-hover)}ic-input-component-container:focus{border:var(--ic-border-pressed)}.focus-indicator{display:flex;width:100%;margin:-0.125rem;padding:0.125rem;border-radius:var(--ic-border-radius);transition:var(--ic-easing-transition-fast)}.focus-indicator:focus-within,.focus-indicator-enabled{box-shadow:var(--ic-border-focus)}.focus-indicator.dark:focus-within{box-shadow:var(--ic-border-focus)}@media (forced-colors: active){ic-input-component-container,.focus-indicator{transition:none}ic-input-component-container:focus-within{border:var(--ic-border-width) solid Highlight;outline:0.125rem solid Highlight}ic-input-component-container.disabled,ic-input-component-container.disabled:hover{border:var(--ic-border-width) dashed GrayText}}";

/**
 * @slot left-icon - Content will be placed to the left of the input.
 */
class InputComponentContainer {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, "left-icon")
                : false)) ;
        };
        this.appearance = "default";
        this.dark = false;
        this.disabled = false;
        this.fullWidth = false;
        this.multiLine = false;
        this.readonly = false;
        this.size = "default";
        this.small = false;
        this.validationInline = false;
        this.validationStatus = "";
    }
    componentDidLoad() {
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, { childList: true });
    }
    render() {
        const { size, small, validationStatus, disabled, readonly, multiLine, fullWidth, dark, appearance, validationInline, } = this;
        const hasValidationStatus = this.validationStatus !== "" && !this.disabled && !this.readonly
            ? true
            : false;
        return (hAsync(Host, { class: {
                small: small,
                [`${size}`]: true,
                [validationStatus]: hasValidationStatus,
                disabled: disabled,
                readonly: readonly,
                ["multiline"]: multiLine,
                ["fullwidth"]: fullWidth,
                ["dark"]: dark || appearance === "dark",
            }, "aria-disabled": disabled && `${disabled}` }, hAsync("div", { class: {
                "focus-indicator": true,
                dark: dark || appearance === "dark",
            } }, slotHasContent(this.el, "left-icon") && (hAsync("div", { class: {
                ["icon-container"]: true,
            } }, hAsync("slot", { name: "left-icon" }))), hAsync("slot", null), validationInline &&
            validationStatus === IcInformationStatus.Success && (hAsync("span", { class: {
                ["inline-success"]: true,
            }, innerHTML: successIcon })))));
    }
    get el() { return getElement(this); }
    static get style() { return icInputComponentContainerCss; }
    static get cmpMeta() { return {
        "$flags$": 4,
        "$tagName$": "ic-input-component-container",
        "$members$": {
            "appearance": [1],
            "dark": [4],
            "disabled": [4],
            "fullWidth": [4, "full-width"],
            "multiLine": [4, "multi-line"],
            "readonly": [4],
            "size": [1],
            "small": [4],
            "validationInline": [4, "validation-inline"],
            "validationStatus": [1, "validation-status"]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icInputContainerCss = "ic-input-container .component-container{display:flex;flex-direction:column}";

class InputContainer {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.disabled = false;
        this.readonly = false;
    }
    render() {
        return (hAsync(Host, null, hAsync("div", { class: {
                ["component-container"]: true,
                ["disabled"]: this.disabled,
                ["readonly"]: this.readonly,
            } }, hAsync("slot", null))));
    }
    static get style() { return icInputContainerCss; }
    static get cmpMeta() { return {
        "$flags$": 4,
        "$tagName$": "ic-input-container",
        "$members$": {
            "disabled": [4],
            "readonly": [4]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icInputLabelCss = "ic-input-label{margin-bottom:var(--ic-space-xs)}ic-input-label.with-helper{margin-bottom:var(--ic-space-xxxs)}ic-input-label.readonly{color:var(--ic-color-tertiary-text)}ic-input-label .helpertext{margin-top:var(--ic-space-xxxs)}ic-input-label .helpertext-normal{color:var(--ic-color-secondary-text)}ic-input-label .helpertext-readonly{color:var(--ic-color-tertiary-text)}ic-input-label .readonly-label{color:var(--ic-color-secondary-text)}ic-input-label .error-label{color:var(--ic-status-error)}ic-input-label .dark{color:var(--ic-architectural-white)}";

class InputLabel {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.appearance = "default";
        this.dark = false;
        this.disabled = false;
        this.error = false;
        this.for = undefined;
        this.helperText = "";
        this.label = undefined;
        this.readonly = false;
        this.required = false;
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Input Label");
    }
    render() {
        const { disabled, readonly, label, required, helperText, error, dark, appearance, } = this;
        const labelText = required ? label + " *" : label;
        const labelContent = readonly ? (`${labelText}`) : (hAsync("label", { htmlFor: this.for }, labelText));
        const id = getInputHelperTextID(this.for);
        return (hAsync(Host, { class: {
                ["disabled"]: disabled,
                ["readonly"]: readonly,
                ["with-helper"]: helperText !== "",
            } }, hAsync("ic-typography", { variant: "label", class: {
                ["readonly-label"]: readonly,
                ["error-label"]: error && !(readonly || disabled),
                ["dark"]: dark || appearance === "dark",
            } }, labelContent), helperText !== "" && (hAsync("ic-typography", { variant: "caption", class: {
                ["helpertext"]: true,
                ["helpertext-normal"]: !disabled && !readonly,
                ["helpertext-readonly"]: readonly,
            } }, hAsync("span", { id: id }, helperText)))));
    }
    static get style() { return icInputLabelCss; }
    static get cmpMeta() { return {
        "$flags$": 0,
        "$tagName$": "ic-input-label",
        "$members$": {
            "appearance": [1],
            "dark": [4],
            "disabled": [4],
            "error": [4],
            "for": [1],
            "helperText": [1, "helper-text"],
            "label": [1],
            "readonly": [4],
            "required": [4]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icInputValidationCss = "ic-input-validation{width:var(--input-width, 20rem);margin-top:var(--ic-space-xs);display:flex}ic-input-validation.fullwidth{width:100%}ic-input-validation span.status-icon{padding-right:var(--ic-space-xxs)}ic-input-validation span.status-icon>svg{height:1.25rem;width:1.25rem}ic-input-validation span.icon-success>svg{fill:var(--ic-status-success)}ic-input-validation span.icon-error>svg{fill:var(--ic-status-error)}ic-input-validation span.icon-warning>svg{fill:var(--ic-status-warning)}ic-input-validation .statustext{flex-grow:1}";

const icon = {
    [IcInformationStatus.Warning]: warningIcon$1,
    [IcInformationStatus.Error]: errorIcon,
    [IcInformationStatus.Success]: successIcon,
};
/**
 * @slot validation-message-adornment - Content will be placed to the right of the validation message.
 */
class InputValidation {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.ariaLiveMode = "polite";
        this.for = undefined;
        this.fullWidth = false;
        this.message = undefined;
        this.status = "";
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.message, propName: "message" }], "Input Validation");
    }
    render() {
        const displayIcon = this.status !== "" ? icon[this.status] : "";
        const id = getInputValidationTextID(this.for);
        return (hAsync(Host, { class: {
                [this.status]: this.status !== "",
                ["fullwidth"]: this.fullWidth,
            } }, displayIcon !== "" && (hAsync("span", { class: {
                ["status-icon"]: true,
                [`icon-${this.status}`]: true,
            }, innerHTML: displayIcon })), hAsync("ic-typography", { variant: "caption", class: "statustext" }, hAsync("span", { "aria-live": this.ariaLiveMode, id: id }, this.message)), hAsync("slot", { name: "validation-message-adornment" })));
    }
    get el() { return getElement(this); }
    static get style() { return icInputValidationCss; }
    static get cmpMeta() { return {
        "$flags$": 4,
        "$tagName$": "ic-input-validation",
        "$members$": {
            "ariaLiveMode": [1, "aria-live-mode"],
            "for": [1],
            "fullWidth": [4, "full-width"],
            "message": [1],
            "status": [1]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icLinkCss = "/*!@html*/html.sc-ic-link{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-link{margin:0}/*!@main*/main.sc-ic-link{display:block}/*!@h1*/h1.sc-ic-link{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-link{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-link{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-link{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-link{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-link,strong.sc-ic-link{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-link,kbd.sc-ic-link,samp.sc-ic-link{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-link{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-link,sup.sc-ic-link{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-link{bottom:-0.25em}/*!@sup*/sup.sc-ic-link{top:-0.5em}/*!@img*/img.sc-ic-link{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-link,input.sc-ic-link,optgroup.sc-ic-link,select.sc-ic-link,textarea.sc-ic-link{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-link,input.sc-ic-link{overflow:visible}/*!@button,\nselect*/button.sc-ic-link,select.sc-ic-link{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-link,[type=\"button\"].sc-ic-link,[type=\"reset\"].sc-ic-link,[type=\"submit\"].sc-ic-link{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-link::-moz-focus-inner,[type=\"button\"].sc-ic-link::-moz-focus-inner,[type=\"reset\"].sc-ic-link::-moz-focus-inner,[type=\"submit\"].sc-ic-link::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-link:-moz-focusring,[type=\"button\"].sc-ic-link:-moz-focusring,[type=\"reset\"].sc-ic-link:-moz-focusring,[type=\"submit\"].sc-ic-link:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-link{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-link{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-link{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-link{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-link,[type=\"radio\"].sc-ic-link{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-link::-webkit-inner-spin-button,[type=\"number\"].sc-ic-link::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-link{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-link::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-link::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-link{display:block}/*!@summary*/summary.sc-ic-link{display:list-item}/*!@template*/template.sc-ic-link{display:none}/*!@[hidden]*/[hidden].sc-ic-link{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-link,body.sc-ic-link,div.sc-ic-link,span.sc-ic-link,applet.sc-ic-link,object.sc-ic-link,iframe.sc-ic-link,h1.sc-ic-link,h2.sc-ic-link,h3.sc-ic-link,h4.sc-ic-link,h5.sc-ic-link,h6.sc-ic-link,p.sc-ic-link,blockquote.sc-ic-link,pre.sc-ic-link,a.sc-ic-link,abbr.sc-ic-link,acronym.sc-ic-link,address.sc-ic-link,big.sc-ic-link,cite.sc-ic-link,code.sc-ic-link,del.sc-ic-link,dfn.sc-ic-link,em.sc-ic-link,img.sc-ic-link,ins.sc-ic-link,kbd.sc-ic-link,q.sc-ic-link,s.sc-ic-link,samp.sc-ic-link,small.sc-ic-link,strike.sc-ic-link,strong.sc-ic-link,sub.sc-ic-link,sup.sc-ic-link,tt.sc-ic-link,var.sc-ic-link,b.sc-ic-link,u.sc-ic-link,i.sc-ic-link,center.sc-ic-link,dl.sc-ic-link,dt.sc-ic-link,dd.sc-ic-link,ol.sc-ic-link,ul.sc-ic-link,li.sc-ic-link,fieldset.sc-ic-link,form.sc-ic-link,label.sc-ic-link,legend.sc-ic-link,table.sc-ic-link,caption.sc-ic-link,tbody.sc-ic-link,tfoot.sc-ic-link,thead.sc-ic-link,tr.sc-ic-link,th.sc-ic-link,td.sc-ic-link,article.sc-ic-link,aside.sc-ic-link,canvas.sc-ic-link,details.sc-ic-link,embed.sc-ic-link,figure.sc-ic-link,figcaption.sc-ic-link,footer.sc-ic-link,header.sc-ic-link,hgroup.sc-ic-link,menu.sc-ic-link,nav.sc-ic-link,output.sc-ic-link,ruby.sc-ic-link,section.sc-ic-link,summary.sc-ic-link,time.sc-ic-link,mark.sc-ic-link,audio.sc-ic-link,video.sc-ic-link{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host(.link) .ic-link,\n:host(.link) ::slotted(a)*/.link.sc-ic-link-h .ic-link.sc-ic-link,.sc-ic-link-h.link.sc-ic-link-s>a,.sc-ic-link-h.link .sc-ic-link-s>a{color:var(--ic-hyperlink);text-decoration:underline;font-weight:var(--ic-font-weight-bold);transition:var(--ic-easing-transition-fast)}/*!@:host(.link.dark) .ic-link.dark,\n:host(.link.dark) ::slotted(a)*/.link.dark.sc-ic-link-h .ic-link.dark.sc-ic-link,.sc-ic-link-h.link.dark.sc-ic-link-s>a,.sc-ic-link-h.link.dark .sc-ic-link-s>a{color:var(--ic-color-primary-text)}/*!@:host(.link.light) .ic-link.light,\n:host(.link.light) ::slotted(a)*/.link.light.sc-ic-link-h .ic-link.light.sc-ic-link,.sc-ic-link-h.link.light.sc-ic-link-s>a,.sc-ic-link-h.link.light .sc-ic-link-s>a{color:var(--ic-color-white-text)}/*!@:host(.link) .ic-link:visited,\n:host(.link) ::slotted(a:visited)*/.link.sc-ic-link-h .ic-link.sc-ic-link:visited,.sc-ic-link-h.link.sc-ic-link-s>a,.sc-ic-link-h.link.sc-ic-link-s>a:visited,.sc-ic-link-h.link .sc-ic-link-s>a:visited{color:var(--ic-hyperlink-visited)}/*!@:host(.link) .ic-link:hover,\n:host(.link) .ic-link:focus,\n:host(.link) ::slotted(a:hover),\n:host(.link) ::slotted(a:focus)*/.link.sc-ic-link-h .ic-link.sc-ic-link:hover,.link.sc-ic-link-h .ic-link.sc-ic-link:focus,.sc-ic-link-h.link.sc-ic-link-s>a,.sc-ic-link-h.link.sc-ic-link-s>a:hover,.sc-ic-link-h.link .sc-ic-link-s>a:hover,.sc-ic-link-h.link.sc-ic-link-s>a:focus,.sc-ic-link-h.link .sc-ic-link-s>a:focus{outline:none;border-bottom:0.25rem solid !important;margin-bottom:-0.25rem !important;text-decoration:none}@supports (text-underline-offset: 10%){/*!@:host(.link) .ic-link:hover,\n  :host(.link) .ic-link:focus,\n  :host(.link) ::slotted(a:hover),\n  :host(.link) ::slotted(a:focus)*/.link.sc-ic-link-h .ic-link.sc-ic-link:hover,.link.sc-ic-link-h .ic-link.sc-ic-link:focus,.sc-ic-link-h.link.sc-ic-link-s>a,.sc-ic-link-h.link.sc-ic-link-s>a:hover,.sc-ic-link-h.link .sc-ic-link-s>a:hover,.sc-ic-link-h.link.sc-ic-link-s>a:focus,.sc-ic-link-h.link .sc-ic-link-s>a:focus{text-decoration-line:underline;text-decoration-thickness:25%;text-underline-offset:10%;border-bottom:0 !important;margin-bottom:0 !important}}/*!@:host(.link) .ic-link:active,\n:host(.link) .ic-link:focus:active,\n:host(.link) .ic-link:visited:active,\n:host(.link) ::slotted(a:active),\n:host(.link) ::slotted(a:focus:active),\n:host(.link) ::slotted(a:visited:active)*/.link.sc-ic-link-h .ic-link.sc-ic-link:active,.link.sc-ic-link-h .ic-link.sc-ic-link:focus:active,.link.sc-ic-link-h .ic-link.sc-ic-link:visited:active,.sc-ic-link-h.link.sc-ic-link-s>a,.sc-ic-link-h.link.sc-ic-link-s>a:active,.sc-ic-link-h.link .sc-ic-link-s>a:active,.sc-ic-link-h.link.sc-ic-link-s>a:focus,.sc-ic-link-h.link.sc-ic-link-s>a:focus:active,.sc-ic-link-h.link .sc-ic-link-s>a:focus:active,.sc-ic-link-h.link.sc-ic-link-s>a:visited,.sc-ic-link-h.link.sc-ic-link-s>a:visited:active,.sc-ic-link-h.link .sc-ic-link-s>a:visited:active{text-decoration:none}/*!@.ic-link-open-in-new-icon*/.ic-link-open-in-new-icon.sc-ic-link{vertical-align:middle;margin-left:var(--ic-space-xxs)}/*!@.ic-link > .ic-link-open-in-new-icon*/.ic-link.sc-ic-link>.ic-link-open-in-new-icon.sc-ic-link{fill:var(--ic-hyperlink)}/*!@.ic-link.dark > .ic-link-open-in-new-icon*/.ic-link.dark.sc-ic-link>.ic-link-open-in-new-icon.sc-ic-link{fill:var(--ic-color-primary-text)}/*!@.ic-link.light > .ic-link-open-in-new-icon*/.ic-link.light.sc-ic-link>.ic-link-open-in-new-icon.sc-ic-link{fill:var(--ic-color-white-text)}/*!@.ic-link-open-in-new-icon > svg*/.ic-link-open-in-new-icon.sc-ic-link>svg.sc-ic-link{width:var(--ic-space-md);height:var(--ic-space-md);fill:currentcolor}/*!@.ic-link:visited > .ic-link-open-in-new-icon*/.ic-link.sc-ic-link:visited>.ic-link-open-in-new-icon.sc-ic-link{fill:var(--ic-hyperlink-visited)}/*!@.ic-link.light:visited > .ic-link-open-in-new-icon*/.ic-link.light.sc-ic-link:visited>.ic-link-open-in-new-icon.sc-ic-link{fill:var(--ic-hyperlink-contrast-visited)}/*!@:host(.breadcrumb-link) .ic-link*/.breadcrumb-link.sc-ic-link-h .ic-link.sc-ic-link{display:var(--breadcrumb-link-display);align-items:var(--breadcrumb-link-align-items);gap:var(--breadcrumb-link-gap)}/*!@:host(.breadcrumb-link) .ic-link ::slotted(.back-icon)*/.sc-ic-link-h.breadcrumb-link .ic-link .sc-ic-link-s>.back-icon{height:var(--ic-space-lg);width:var(--ic-space-lg)}/*!@:host(.breadcrumb-link.current-page) a,\n:host(.breadcrumb-link.current-page) ::slotted(a)*/.breadcrumb-link.current-page.sc-ic-link-h a.sc-ic-link,.sc-ic-link-h.breadcrumb-link.current-page.sc-ic-link-s>a,.sc-ic-link-h.breadcrumb-link.current-page .sc-ic-link-s>a{font-weight:normal;color:inherit;text-decoration:none;display:flex;align-items:center}/*!@:host(.breadcrumb-link.current-page) .ic-link,\n:host(.breadcrumb-link.current-page) ::slotted(a:focus)*/.breadcrumb-link.current-page.sc-ic-link-h .ic-link.sc-ic-link,.sc-ic-link-h.breadcrumb-link.current-page.sc-ic-link-s>a,.sc-ic-link-h.breadcrumb-link.current-page.sc-ic-link-s>a:focus,.sc-ic-link-h.breadcrumb-link.current-page .sc-ic-link-s>a:focus{outline:var(--ic-hc-focus-outline);text-decoration:none}/*!@:host(.breadcrumb-link.current-page) .ic-link:visited*/.breadcrumb-link.current-page.sc-ic-link-h .ic-link.sc-ic-link:visited{color:var(--ic-color-primary-text)}";

/**
 * @slot router-item - Handle routing by nesting your routes in this slot.
 */
class Link {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.inheritedAttributes = {};
        this.hostMutationObserver = null;
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            mutationList.forEach(({ attributeName }) => {
                if (IC_INHERITED_ARIA.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] =
                        this.el.getAttribute(attributeName);
                }
            });
        };
        this.appearance = "default";
        this.download = false;
        this.href = null;
        this.hreflang = undefined;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.showIcon = undefined;
        this.target = undefined;
    }
    componentWillLoad() {
        this.inheritedAttributes = inheritAttributes(this.el, IC_INHERITED_ARIA);
        this.updateTheme();
    }
    componentDidLoad() {
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            attributes: true,
        });
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    themeChangeHandler({ detail }) {
        this.updateTheme(detail.mode);
    }
    /**
     * Sets focus on the link.
     */
    async setFocus() {
        var _a;
        (_a = this.el.shadowRoot.querySelector("a")) === null || _a === void 0 ? void 0 : _a.focus();
    }
    updateTheme(newTheme = null) {
        const theme = getThemeFromContext(this.el, newTheme);
        if (theme !== IcThemeForegroundEnum.Default) {
            this.appearance = theme;
        }
    }
    hasRouterSlot() {
        this.routerSlot = this.el.querySelector('[slot="router-item"]');
        if (this.routerSlot) {
            this.routerSlot.ariaLabel = this.routerSlot.textContent;
        }
        return !!this.routerSlot;
    }
    render() {
        const { download, href, hreflang, referrerpolicy, rel, target, showIcon, appearance, } = this;
        return (hAsync(Host, { class: { ["link"]: true, [`${appearance}`]: true } }, this.hasRouterSlot() ? (hAsync("slot", { name: "router-item" })) : (hAsync("a", Object.assign({ class: {
                ["ic-link"]: href !== null,
                [`${appearance}`]: href !== null,
            }, download: download !== false ? download : null, href: href, hrefLang: hreflang, referrerPolicy: referrerpolicy, rel: rel, target: target, tabindex: href !== null ? "0" : "-1" }, this.inheritedAttributes), hAsync("slot", null), (showIcon || target === "_blank") && (hAsync("span", { class: "ic-link-open-in-new-icon", innerHTML: OpenInNew }))))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get style() { return icLinkCss; }
    static get cmpMeta() { return {
        "$flags$": 25,
        "$tagName$": "ic-link",
        "$members$": {
            "appearance": [1025],
            "download": [8],
            "href": [1],
            "hreflang": [1],
            "referrerpolicy": [1],
            "rel": [1],
            "showIcon": [4, "show-icon"],
            "target": [1],
            "setFocus": [64]
        },
        "$listeners$": [[4, "themeChange", "themeChangeHandler"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icLoadingIndicatorCss = "/*!@html*/html.sc-ic-loading-indicator{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-loading-indicator{margin:0}/*!@main*/main.sc-ic-loading-indicator{display:block}/*!@h1*/h1.sc-ic-loading-indicator{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-loading-indicator{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-loading-indicator{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-loading-indicator{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-loading-indicator{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-loading-indicator,strong.sc-ic-loading-indicator{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-loading-indicator,kbd.sc-ic-loading-indicator,samp.sc-ic-loading-indicator{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-loading-indicator{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-loading-indicator,sup.sc-ic-loading-indicator{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-loading-indicator{bottom:-0.25em}/*!@sup*/sup.sc-ic-loading-indicator{top:-0.5em}/*!@img*/img.sc-ic-loading-indicator{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-loading-indicator,input.sc-ic-loading-indicator,optgroup.sc-ic-loading-indicator,select.sc-ic-loading-indicator,textarea.sc-ic-loading-indicator{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-loading-indicator,input.sc-ic-loading-indicator{overflow:visible}/*!@button,\nselect*/button.sc-ic-loading-indicator,select.sc-ic-loading-indicator{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-loading-indicator,[type=\"button\"].sc-ic-loading-indicator,[type=\"reset\"].sc-ic-loading-indicator,[type=\"submit\"].sc-ic-loading-indicator{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-loading-indicator::-moz-focus-inner,[type=\"button\"].sc-ic-loading-indicator::-moz-focus-inner,[type=\"reset\"].sc-ic-loading-indicator::-moz-focus-inner,[type=\"submit\"].sc-ic-loading-indicator::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-loading-indicator:-moz-focusring,[type=\"button\"].sc-ic-loading-indicator:-moz-focusring,[type=\"reset\"].sc-ic-loading-indicator:-moz-focusring,[type=\"submit\"].sc-ic-loading-indicator:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-loading-indicator{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-loading-indicator{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-loading-indicator{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-loading-indicator{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-loading-indicator,[type=\"radio\"].sc-ic-loading-indicator{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-loading-indicator::-webkit-inner-spin-button,[type=\"number\"].sc-ic-loading-indicator::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-loading-indicator{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-loading-indicator::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-loading-indicator::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-loading-indicator{display:block}/*!@summary*/summary.sc-ic-loading-indicator{display:list-item}/*!@template*/template.sc-ic-loading-indicator{display:none}/*!@[hidden]*/[hidden].sc-ic-loading-indicator{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-loading-indicator,body.sc-ic-loading-indicator,div.sc-ic-loading-indicator,span.sc-ic-loading-indicator,applet.sc-ic-loading-indicator,object.sc-ic-loading-indicator,iframe.sc-ic-loading-indicator,h1.sc-ic-loading-indicator,h2.sc-ic-loading-indicator,h3.sc-ic-loading-indicator,h4.sc-ic-loading-indicator,h5.sc-ic-loading-indicator,h6.sc-ic-loading-indicator,p.sc-ic-loading-indicator,blockquote.sc-ic-loading-indicator,pre.sc-ic-loading-indicator,a.sc-ic-loading-indicator,abbr.sc-ic-loading-indicator,acronym.sc-ic-loading-indicator,address.sc-ic-loading-indicator,big.sc-ic-loading-indicator,cite.sc-ic-loading-indicator,code.sc-ic-loading-indicator,del.sc-ic-loading-indicator,dfn.sc-ic-loading-indicator,em.sc-ic-loading-indicator,img.sc-ic-loading-indicator,ins.sc-ic-loading-indicator,kbd.sc-ic-loading-indicator,q.sc-ic-loading-indicator,s.sc-ic-loading-indicator,samp.sc-ic-loading-indicator,small.sc-ic-loading-indicator,strike.sc-ic-loading-indicator,strong.sc-ic-loading-indicator,sub.sc-ic-loading-indicator,sup.sc-ic-loading-indicator,tt.sc-ic-loading-indicator,var.sc-ic-loading-indicator,b.sc-ic-loading-indicator,u.sc-ic-loading-indicator,i.sc-ic-loading-indicator,center.sc-ic-loading-indicator,dl.sc-ic-loading-indicator,dt.sc-ic-loading-indicator,dd.sc-ic-loading-indicator,ol.sc-ic-loading-indicator,ul.sc-ic-loading-indicator,li.sc-ic-loading-indicator,fieldset.sc-ic-loading-indicator,form.sc-ic-loading-indicator,label.sc-ic-loading-indicator,legend.sc-ic-loading-indicator,table.sc-ic-loading-indicator,caption.sc-ic-loading-indicator,tbody.sc-ic-loading-indicator,tfoot.sc-ic-loading-indicator,thead.sc-ic-loading-indicator,tr.sc-ic-loading-indicator,th.sc-ic-loading-indicator,td.sc-ic-loading-indicator,article.sc-ic-loading-indicator,aside.sc-ic-loading-indicator,canvas.sc-ic-loading-indicator,details.sc-ic-loading-indicator,embed.sc-ic-loading-indicator,figure.sc-ic-loading-indicator,figcaption.sc-ic-loading-indicator,footer.sc-ic-loading-indicator,header.sc-ic-loading-indicator,hgroup.sc-ic-loading-indicator,menu.sc-ic-loading-indicator,nav.sc-ic-loading-indicator,output.sc-ic-loading-indicator,ruby.sc-ic-loading-indicator,section.sc-ic-loading-indicator,summary.sc-ic-loading-indicator,time.sc-ic-loading-indicator,mark.sc-ic-loading-indicator,audio.sc-ic-loading-indicator,video.sc-ic-loading-indicator{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-loading-indicator-h{display:block;--linear-border-radius:0.25rem;--inner-color:var(--ic-action-default);--outer-color:var(--ic-architectural-100);--label-color:var(--ic-color-primary-text);--margin:none;--linear-line-height:var(--ic-space-xs)}/*!@:host(.light)*/.light.sc-ic-loading-indicator-h{--inner-color:var(--ic-architectural-white);--outer-color:var(--ic-architectural-800);--label-color:var(--ic-architectural-white)}/*!@.ic-loading-container*/.ic-loading-container.sc-ic-loading-indicator{display:flex;flex-direction:column;justify-content:center;align-items:center}/*!@:host([size=\"small\"])*/[size=\"small\"].sc-ic-loading-indicator-h{--circular-diameter:2.5rem;--linear-line-height:var(--ic-space-xxs)}/*!@:host([size=\"default\"])*/[size=\"default\"].sc-ic-loading-indicator-h{--circular-diameter:5rem}/*!@:host([size=\"large\"])*/[size=\"large\"].sc-ic-loading-indicator-h{--circular-diameter:7.5rem}/*!@:host([size=\"icon\"])*/[size=\"icon\"].sc-ic-loading-indicator-h{display:inline-block;--margin:var(--ic-space-xxxs);--circular-diameter:1.25rem}/*!@:host(.label)*/.label.sc-ic-loading-indicator-h{--margin:0 0 var(--ic-space-xs) 0}/*!@.ic-loading-label*/.ic-loading-label.sc-ic-loading-indicator{color:var(--label-color);margin-left:var(--label-margin-left)}/*!@.ic-loading-circular-outer*/.ic-loading-circular-outer.sc-ic-loading-indicator{height:var(--circular-diameter);width:var(--circular-diameter)}/*!@.ic-loading-circular-outer.indeterminate*/.ic-loading-circular-outer.indeterminate.sc-ic-loading-indicator{animation:circular-animation 1s linear;animation-iteration-count:infinite}@keyframes circular-animation{100%{transform:rotate(360deg)}}/*!@.ic-loading-circular-outer,\n.ic-loading-linear-outer*/.ic-loading-circular-outer.sc-ic-loading-indicator,.ic-loading-linear-outer.sc-ic-loading-indicator{margin:var(--margin)}/*!@.ic-loading-linear-outer*/.ic-loading-linear-outer.sc-ic-loading-indicator{background-color:var(--outer-color);height:var(--linear-line-height);width:100%;border-radius:var(--linear-border-radius);overflow:hidden}/*!@.ic-loading-linear-inner*/.ic-loading-linear-inner.sc-ic-loading-indicator{position:relative;height:100%;background-color:var(--inner-color);border-radius:var(--linear-border-radius)}/*!@.indeterminate > .ic-loading-linear-inner*/.indeterminate.sc-ic-loading-indicator>.ic-loading-linear-inner.sc-ic-loading-indicator{animation:linear-animation 2s infinite}/*!@.determinate > .ic-loading-linear-inner*/.determinate.sc-ic-loading-indicator>.ic-loading-linear-inner.sc-ic-loading-indicator{transition:width 0.5s;width:var(--linear-width)}/*!@:host(.full-width)*/.full-width.sc-ic-loading-indicator-h{--linear-border-radius:none}@keyframes linear-animation{0%{width:0%;left:-1%}25%{width:0%;left:-1%}50%{width:101%;left:-1%}75%{width:0%;left:101%}100%{width:0%;left:101%}}/*!@.ic-loading-circular-svg*/.ic-loading-circular-svg.sc-ic-loading-indicator{position:relative;width:100%;height:100%;transform:rotate(-90deg)}/*!@.ic-loading-circular-svg circle*/.ic-loading-circular-svg.sc-ic-loading-indicator circle.sc-ic-loading-indicator{width:100%;height:100%;fill:none;stroke:var(--compact-step-outer-color, var(--outer-color));stroke-width:var(--circular-line-width);stroke-linecap:round}/*!@.ic-loading-circular-svg circle:nth-child(2)*/.ic-loading-circular-svg.sc-ic-loading-indicator circle.sc-ic-loading-indicator:nth-child(2){--circular-indeterminate:calc(\n    (0.25 * var(--stroke-dasharray)) - var(--stroke-dasharray)\n  );stroke-dasharray:var(--stroke-dasharray), var(--stroke-dasharray);stroke-dashoffset:var(--stroke-dashoffset, var(--circular-indeterminate));stroke:var(--compact-step-inner-color, var(--inner-color))}/*!@:host(.inner-label) .ic-loading-circular-inner*/.inner-label.sc-ic-loading-indicator-h .ic-loading-circular-inner.sc-ic-loading-indicator{display:grid}/*!@:host(.inner-label) .ic-loading-circular-svg,\n.inner-text*/.inner-label.sc-ic-loading-indicator-h .ic-loading-circular-svg.sc-ic-loading-indicator,.inner-text.sc-ic-loading-indicator{grid-column:1;grid-row:1}/*!@:host(.not-required.compact-step-progress-indicator)\n  .ic-loading-circular-svg\n  circle:nth-child(2)*/.not-required.compact-step-progress-indicator.sc-ic-loading-indicator-h .ic-loading-circular-svg.sc-ic-loading-indicator circle.sc-ic-loading-indicator:nth-child(2){stroke:var(--ic-architectural-300)}/*!@.inner-text*/.inner-text.sc-ic-loading-indicator{display:flex;align-items:center;justify-content:center;width:var(--ic-space-lg);height:inherit;overflow:hidden;margin:auto;color:var(--compact-step-inner-color, var(--ic-status-info))}/*!@:host(.not-required.compact-step-progress-indicator) .inner-text*/.not-required.compact-step-progress-indicator.sc-ic-loading-indicator-h .inner-text.sc-ic-loading-indicator{color:var(--ic-color-tertiary-text)}/*!@:host(.light.not-required.compact-step-progress-indicator) .inner-text*/.light.not-required.compact-step-progress-indicator.sc-ic-loading-indicator-h .inner-text.sc-ic-loading-indicator{color:var(--ic-architectural-400)}@media (forced-colors: active){/*!@.indeterminate > .ic-loading-circular-inner*/.indeterminate.sc-ic-loading-indicator>.ic-loading-circular-inner.sc-ic-loading-indicator{forced-color-adjust:none}/*!@.ic-loading-linear-outer*/.ic-loading-linear-outer.sc-ic-loading-indicator{border:var(--ic-hc-border)}/*!@.ic-loading-linear-inner*/.ic-loading-linear-inner.sc-ic-loading-indicator{background-color:canvastext}/*!@.ic-loading-circular-svg circle*/.ic-loading-circular-svg.sc-ic-loading-indicator circle.sc-ic-loading-indicator{stroke:Background}/*!@.ic-loading-circular-svg circle:nth-child(2)*/.ic-loading-circular-svg.sc-ic-loading-indicator circle.sc-ic-loading-indicator:nth-child(2){stroke:canvastext}/*!@:host(.not-required.compact-step-progress-indicator)\n    .ic-loading-circular-svg\n    circle:nth-child(2)*/.not-required.compact-step-progress-indicator.sc-ic-loading-indicator-h .ic-loading-circular-svg.sc-ic-loading-indicator circle.sc-ic-loading-indicator:nth-child(2){stroke:GrayText}}";

class LoadingIndicator {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.updateCircularProgressMeter = () => {
            if (!this.indeterminate) {
                this.circularMeter.style.setProperty("--progress-value", String(this.progress));
            }
        };
        this.getLabel = (labelIndex, setLabel) => {
            return new Promise(() => {
                this.interval = setInterval(() => {
                    if (labelIndex < this.labelList.length - 1) {
                        labelIndex++;
                    }
                    else {
                        labelIndex = 0;
                    }
                    setLabel(this.labelList[labelIndex]);
                }, this.labelDuration);
            });
        };
        this.getLabelVariant = () => {
            var _a;
            let variant = "h4";
            const width = (_a = this.outerElement) === null || _a === void 0 ? void 0 : _a.offsetWidth;
            if (this.size === "small" || (this.type === "circular" && width < 60)) {
                variant = "label";
            }
            else if (this.size === "large" ||
                (this.type === "circular" && width >= 120)) {
                variant = "h2";
            }
            return variant;
        };
        // Sets the circular indicator line width - accounting for the circle size being altered using the CSS custom property
        this.setCircleLineWidth = () => {
            const { offsetWidth: width } = this.outerElement;
            const compactStepCircularLineWidth = this.el.classList.contains("compact-step-progress-indicator")
                ? 40
                : 0;
            const toastDismissTimerCircularLineWidth = this.el.classList.contains("toast-dismiss-timer")
                ? 20
                : 0;
            if (width ||
                compactStepCircularLineWidth ||
                toastDismissTimerCircularLineWidth) {
                this.circularLineWidth =
                    (compactStepCircularLineWidth ||
                        toastDismissTimerCircularLineWidth ||
                        width) * 0.1;
                this.circularDiameter =
                    compactStepCircularLineWidth ||
                        toastDismissTimerCircularLineWidth ||
                        width;
                this.outerElement.style.setProperty("--circular-line-width", `${this.circularLineWidth}px`);
            }
        };
        this.setLinearDeterminateWidth = () => {
            if (!this.innerElement)
                return;
            // Ensure progress cannot be out of bounds
            const progress = Math.min(this.max, Math.max(this.min, this.progress));
            const proportion = (progress - this.min) / (this.max - this.min);
            this.showSecond = proportion > 0.5;
            if (this.showSecond) {
                this.innerElement.classList.remove("clip");
            }
            else {
                this.innerElement.classList.add("clip");
            }
            this.innerElement.style.setProperty("--linear-width", `${proportion * 100}%`);
        };
        this.calcOuterClass = () => {
            let cls = `ic-loading-${this.type}-outer`;
            cls += this.indeterminate ? " indeterminate" : " determinate";
            return cls;
        };
        this.updateLabel = () => {
            if (isPropDefined(this.label)) {
                this.labelList = this.label.split("/");
                const labelIndex = 0;
                this.indicatorLabel = this.labelList[labelIndex];
                if (this.labelList.length > 1) {
                    this.getLabel(labelIndex, (label) => {
                        this.indicatorLabel = label;
                    });
                }
            }
        };
        this.setCircleXY = () => {
            if (this.circularDiameter > 0) {
                const r = this.circularDiameter / 2;
                const x = r;
                const y = r;
                const nextRadius = r - this.circularLineWidth / 2;
                this.setDashSteps(nextRadius);
                return { x, y, r: nextRadius };
            }
            return { x: 0, y: 0, r: 0 };
        };
        this.setDashSteps = (radius) => {
            const dashArray = 2 * Math.PI * radius;
            const progress = Math.min(Math.max(this.progress, this.min), this.max);
            const proportion = -1 - (progress - this.min) / (this.max - this.min);
            this.circularMeter.style.setProperty("--stroke-dasharray", `${dashArray}px`);
            if (!this.indeterminate) {
                this.circularMeter.style.setProperty("--circular-steps-max", String(this.max));
                this.circularMeter.style.setProperty("--stroke-dashoffset", `${proportion * dashArray}px`);
            }
        };
        this.circularDiameter = undefined;
        this.circularLineWidth = undefined;
        this.indeterminate = undefined;
        this.indicatorLabel = undefined;
        this.showSecond = false;
        this.appearance = "dark";
        this.description = "Loading";
        this.fullWidth = false;
        this.innerLabel = undefined;
        this.labelDuration = 8000;
        this.max = 100;
        this.min = 0;
        this.size = "default";
        this.type = "circular";
        this.label = undefined;
        this.progress = undefined;
    }
    watchPropHandler() {
        this.updateLabel();
    }
    watchProgressHandler() {
        if (this.type === "circular") {
            this.updateCircularProgressMeter();
        }
    }
    disconnectedCallback() {
        clearInterval(this.interval);
    }
    componentWillLoad() {
        this.indeterminate = this.progress === undefined;
        this.updateLabel();
        this.el.setAttribute("exportparts", "ic-loading-container");
    }
    componentDidLoad() {
        if (this.type === "circular") {
            this.setCircleLineWidth();
            this.circularMeter = this.el.shadowRoot.querySelector(".ic-loading-circular-svg circle:nth-child(2)");
            this.updateCircularProgressMeter();
        }
        if (Number(this.progress) >= 0 && this.type === "linear") {
            this.setLinearDeterminateWidth();
        }
    }
    componentWillUpdate() {
        this.indeterminate = this.progress === undefined;
    }
    componentDidUpdate() {
        if (Number(this.progress) >= 0 && this.type === "linear") {
            this.setLinearDeterminateWidth();
        }
    }
    render() {
        const { appearance, label, description, size, fullWidth, innerLabel } = this;
        const { x, y, r } = this.setCircleXY();
        return (hAsync(Host, { class: {
                ["light"]: appearance === IcThemeForegroundEnum.Light,
                ["label"]: !!label,
                ["full-width"]: fullWidth,
                ["inner-label"]: !!innerLabel,
            } }, hAsync("div", { class: "ic-loading-container", part: "ic-loading-container" }, hAsync("div", { ref: (el) => (this.outerElement = el), class: this.calcOuterClass(), role: "progressbar", "aria-labelledby": this.label && this.size !== "icon" && "ic-loading-label", "aria-label": description, "aria-valuenow": this.progress, "aria-valuemin": this.min, "aria-valuemax": this.max }, hAsync("div", { ref: (el) => (this.innerElement = el), class: `ic-loading-${this.type}-inner` }, this.innerLabel &&
            this.innerLabel !== undefined &&
            this.size === "small" && (hAsync("ic-typography", { variant: "subtitle-small", class: "inner-text" }, this.innerLabel)), this.type === "circular" && (hAsync("svg", { class: "ic-loading-circular-svg", viewBox: `0 0 ${this.circularDiameter || 0} ${this.circularDiameter || 0}` }, hAsync("circle", { cx: `${x}`, cy: `${y}`, r: `${r}` }), hAsync("circle", { cx: `${x}`, cy: `${y}`, r: `${r}` }))))), label && size !== "icon" && (hAsync("ic-typography", { id: "ic-loading-label", class: "ic-loading-label", role: "status", variant: this.getLabelVariant() }, hAsync("p", null, this.indicatorLabel))))));
    }
    get el() { return getElement(this); }
    static get watchers() { return {
        "label": ["watchPropHandler"],
        "progress": ["watchProgressHandler"]
    }; }
    static get style() { return icLoadingIndicatorCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-loading-indicator",
        "$members$": {
            "appearance": [1],
            "description": [1],
            "fullWidth": [516, "full-width"],
            "innerLabel": [2, "inner-label"],
            "labelDuration": [2, "label-duration"],
            "max": [2],
            "min": [2],
            "size": [513],
            "type": [513],
            "label": [1],
            "progress": [2],
            "circularDiameter": [32],
            "circularLineWidth": [32],
            "indeterminate": [32],
            "indicatorLabel": [32],
            "showSecond": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": [["fullWidth", "full-width"], ["size", "size"], ["type", "type"]]
    }; }
}

var top = 'top';
var bottom = 'bottom';
var right = 'right';
var left = 'left';
var auto = 'auto';
var basePlacements = [top, bottom, right, left];
var start = 'start';
var end = 'end';
var clippingParents = 'clippingParents';
var viewport = 'viewport';
var popper = 'popper';
var reference = 'reference';
var variationPlacements = /*#__PURE__*/basePlacements.reduce(function (acc, placement) {
  return acc.concat([placement + "-" + start, placement + "-" + end]);
}, []);
var placements = /*#__PURE__*/[].concat(basePlacements, [auto]).reduce(function (acc, placement) {
  return acc.concat([placement, placement + "-" + start, placement + "-" + end]);
}, []); // modifiers that need to read the DOM

var beforeRead = 'beforeRead';
var read = 'read';
var afterRead = 'afterRead'; // pure-logic modifiers

var beforeMain = 'beforeMain';
var main = 'main';
var afterMain = 'afterMain'; // modifier with the purpose to write to the DOM (or write into a framework state)

var beforeWrite = 'beforeWrite';
var write = 'write';
var afterWrite = 'afterWrite';
var modifierPhases = [beforeRead, read, afterRead, beforeMain, main, afterMain, beforeWrite, write, afterWrite];

function getNodeName(element) {
  return element ? (element.nodeName || '').toLowerCase() : null;
}

function getWindow(node) {
  if (node == null) {
    return window;
  }

  if (node.toString() !== '[object Window]') {
    var ownerDocument = node.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView || window : window;
  }

  return node;
}

function isElement(node) {
  var OwnElement = getWindow(node).Element;
  return node instanceof OwnElement || node instanceof Element;
}

function isHTMLElement(node) {
  var OwnElement = getWindow(node).HTMLElement;
  return node instanceof OwnElement || node instanceof HTMLElement;
}

function isShadowRoot(node) {
  // IE 11 has no ShadowRoot
  if (typeof ShadowRoot === 'undefined') {
    return false;
  }

  var OwnElement = getWindow(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}

// and applies them to the HTMLElements such as popper and arrow

function applyStyles(_ref) {
  var state = _ref.state;
  Object.keys(state.elements).forEach(function (name) {
    var style = state.styles[name] || {};
    var attributes = state.attributes[name] || {};
    var element = state.elements[name]; // arrow is optional + virtual elements

    if (!isHTMLElement(element) || !getNodeName(element)) {
      return;
    } // Flow doesn't support to extend this property, but it's the most
    // effective way to apply styles to an HTMLElement
    // $FlowFixMe[cannot-write]


    Object.assign(element.style, style);
    Object.keys(attributes).forEach(function (name) {
      var value = attributes[name];

      if (value === false) {
        element.removeAttribute(name);
      } else {
        element.setAttribute(name, value === true ? '' : value);
      }
    });
  });
}

function effect$2(_ref2) {
  var state = _ref2.state;
  var initialStyles = {
    popper: {
      position: state.options.strategy,
      left: '0',
      top: '0',
      margin: '0'
    },
    arrow: {
      position: 'absolute'
    },
    reference: {}
  };
  Object.assign(state.elements.popper.style, initialStyles.popper);
  state.styles = initialStyles;

  if (state.elements.arrow) {
    Object.assign(state.elements.arrow.style, initialStyles.arrow);
  }

  return function () {
    Object.keys(state.elements).forEach(function (name) {
      var element = state.elements[name];
      var attributes = state.attributes[name] || {};
      var styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]); // Set all values to an empty string to unset them

      var style = styleProperties.reduce(function (style, property) {
        style[property] = '';
        return style;
      }, {}); // arrow is optional + virtual elements

      if (!isHTMLElement(element) || !getNodeName(element)) {
        return;
      }

      Object.assign(element.style, style);
      Object.keys(attributes).forEach(function (attribute) {
        element.removeAttribute(attribute);
      });
    });
  };
} // eslint-disable-next-line import/no-unused-modules


var applyStyles$1 = {
  name: 'applyStyles',
  enabled: true,
  phase: 'write',
  fn: applyStyles,
  effect: effect$2,
  requires: ['computeStyles']
};

function getBasePlacement(placement) {
  return placement.split('-')[0];
}

var max = Math.max;
var min = Math.min;
var round = Math.round;

function getUAString() {
  var uaData = navigator.userAgentData;

  if (uaData != null && uaData.brands && Array.isArray(uaData.brands)) {
    return uaData.brands.map(function (item) {
      return item.brand + "/" + item.version;
    }).join(' ');
  }

  return navigator.userAgent;
}

function isLayoutViewport() {
  return !/^((?!chrome|android).)*safari/i.test(getUAString());
}

function getBoundingClientRect(element, includeScale, isFixedStrategy) {
  if (includeScale === void 0) {
    includeScale = false;
  }

  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }

  var clientRect = element.getBoundingClientRect();
  var scaleX = 1;
  var scaleY = 1;

  if (includeScale && isHTMLElement(element)) {
    scaleX = element.offsetWidth > 0 ? round(clientRect.width) / element.offsetWidth || 1 : 1;
    scaleY = element.offsetHeight > 0 ? round(clientRect.height) / element.offsetHeight || 1 : 1;
  }

  var _ref = isElement(element) ? getWindow(element) : window,
      visualViewport = _ref.visualViewport;

  var addVisualOffsets = !isLayoutViewport() && isFixedStrategy;
  var x = (clientRect.left + (addVisualOffsets && visualViewport ? visualViewport.offsetLeft : 0)) / scaleX;
  var y = (clientRect.top + (addVisualOffsets && visualViewport ? visualViewport.offsetTop : 0)) / scaleY;
  var width = clientRect.width / scaleX;
  var height = clientRect.height / scaleY;
  return {
    width: width,
    height: height,
    top: y,
    right: x + width,
    bottom: y + height,
    left: x,
    x: x,
    y: y
  };
}

// means it doesn't take into account transforms.

function getLayoutRect(element) {
  var clientRect = getBoundingClientRect(element); // Use the clientRect sizes if it's not been transformed.
  // Fixes https://github.com/popperjs/popper-core/issues/1223

  var width = element.offsetWidth;
  var height = element.offsetHeight;

  if (Math.abs(clientRect.width - width) <= 1) {
    width = clientRect.width;
  }

  if (Math.abs(clientRect.height - height) <= 1) {
    height = clientRect.height;
  }

  return {
    x: element.offsetLeft,
    y: element.offsetTop,
    width: width,
    height: height
  };
}

function contains(parent, child) {
  var rootNode = child.getRootNode && child.getRootNode(); // First, attempt with faster native method

  if (parent.contains(child)) {
    return true;
  } // then fallback to custom implementation with Shadow DOM support
  else if (rootNode && isShadowRoot(rootNode)) {
      var next = child;

      do {
        if (next && parent.isSameNode(next)) {
          return true;
        } // $FlowFixMe[prop-missing]: need a better way to handle this...


        next = next.parentNode || next.host;
      } while (next);
    } // Give up, the result is false


  return false;
}

function getComputedStyle$1(element) {
  return getWindow(element).getComputedStyle(element);
}

function isTableElement(element) {
  return ['table', 'td', 'th'].indexOf(getNodeName(element)) >= 0;
}

function getDocumentElement(element) {
  // $FlowFixMe[incompatible-return]: assume body is always available
  return ((isElement(element) ? element.ownerDocument : // $FlowFixMe[prop-missing]
  element.document) || window.document).documentElement;
}

function getParentNode(element) {
  if (getNodeName(element) === 'html') {
    return element;
  }

  return (// this is a quicker (but less type safe) way to save quite some bytes from the bundle
    // $FlowFixMe[incompatible-return]
    // $FlowFixMe[prop-missing]
    element.assignedSlot || // step into the shadow DOM of the parent of a slotted node
    element.parentNode || ( // DOM Element detected
    isShadowRoot(element) ? element.host : null) || // ShadowRoot detected
    // $FlowFixMe[incompatible-call]: HTMLElement is a Node
    getDocumentElement(element) // fallback

  );
}

function getTrueOffsetParent(element) {
  if (!isHTMLElement(element) || // https://github.com/popperjs/popper-core/issues/837
  getComputedStyle$1(element).position === 'fixed') {
    return null;
  }

  return element.offsetParent;
} // `.offsetParent` reports `null` for fixed elements, while absolute elements
// return the containing block


function getContainingBlock(element) {
  var isFirefox = /firefox/i.test(getUAString());
  var isIE = /Trident/i.test(getUAString());

  if (isIE && isHTMLElement(element)) {
    // In IE 9, 10 and 11 fixed elements containing block is always established by the viewport
    var elementCss = getComputedStyle$1(element);

    if (elementCss.position === 'fixed') {
      return null;
    }
  }

  var currentNode = getParentNode(element);

  if (isShadowRoot(currentNode)) {
    currentNode = currentNode.host;
  }

  while (isHTMLElement(currentNode) && ['html', 'body'].indexOf(getNodeName(currentNode)) < 0) {
    var css = getComputedStyle$1(currentNode); // This is non-exhaustive but covers the most common CSS properties that
    // create a containing block.
    // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block

    if (css.transform !== 'none' || css.perspective !== 'none' || css.contain === 'paint' || ['transform', 'perspective'].indexOf(css.willChange) !== -1 || isFirefox && css.willChange === 'filter' || isFirefox && css.filter && css.filter !== 'none') {
      return currentNode;
    } else {
      currentNode = currentNode.parentNode;
    }
  }

  return null;
} // Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.


function getOffsetParent(element) {
  var window = getWindow(element);
  var offsetParent = getTrueOffsetParent(element);

  while (offsetParent && isTableElement(offsetParent) && getComputedStyle$1(offsetParent).position === 'static') {
    offsetParent = getTrueOffsetParent(offsetParent);
  }

  if (offsetParent && (getNodeName(offsetParent) === 'html' || getNodeName(offsetParent) === 'body' && getComputedStyle$1(offsetParent).position === 'static')) {
    return window;
  }

  return offsetParent || getContainingBlock(element) || window;
}

function getMainAxisFromPlacement(placement) {
  return ['top', 'bottom'].indexOf(placement) >= 0 ? 'x' : 'y';
}

function within(min$1, value, max$1) {
  return max(min$1, min(value, max$1));
}
function withinMaxClamp(min, value, max) {
  var v = within(min, value, max);
  return v > max ? max : v;
}

function getFreshSideObject() {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  };
}

function mergePaddingObject(paddingObject) {
  return Object.assign({}, getFreshSideObject(), paddingObject);
}

function expandToHashMap(value, keys) {
  return keys.reduce(function (hashMap, key) {
    hashMap[key] = value;
    return hashMap;
  }, {});
}

var toPaddingObject = function toPaddingObject(padding, state) {
  padding = typeof padding === 'function' ? padding(Object.assign({}, state.rects, {
    placement: state.placement
  })) : padding;
  return mergePaddingObject(typeof padding !== 'number' ? padding : expandToHashMap(padding, basePlacements));
};

function arrow(_ref) {
  var _state$modifiersData$;

  var state = _ref.state,
      name = _ref.name,
      options = _ref.options;
  var arrowElement = state.elements.arrow;
  var popperOffsets = state.modifiersData.popperOffsets;
  var basePlacement = getBasePlacement(state.placement);
  var axis = getMainAxisFromPlacement(basePlacement);
  var isVertical = [left, right].indexOf(basePlacement) >= 0;
  var len = isVertical ? 'height' : 'width';

  if (!arrowElement || !popperOffsets) {
    return;
  }

  var paddingObject = toPaddingObject(options.padding, state);
  var arrowRect = getLayoutRect(arrowElement);
  var minProp = axis === 'y' ? top : left;
  var maxProp = axis === 'y' ? bottom : right;
  var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets[axis] - state.rects.popper[len];
  var startDiff = popperOffsets[axis] - state.rects.reference[axis];
  var arrowOffsetParent = getOffsetParent(arrowElement);
  var clientSize = arrowOffsetParent ? axis === 'y' ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
  var centerToReference = endDiff / 2 - startDiff / 2; // Make sure the arrow doesn't overflow the popper if the center point is
  // outside of the popper bounds

  var min = paddingObject[minProp];
  var max = clientSize - arrowRect[len] - paddingObject[maxProp];
  var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
  var offset = within(min, center, max); // Prevents breaking syntax highlighting...

  var axisProp = axis;
  state.modifiersData[name] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset, _state$modifiersData$.centerOffset = offset - center, _state$modifiersData$);
}

function effect$1(_ref2) {
  var state = _ref2.state,
      options = _ref2.options;
  var _options$element = options.element,
      arrowElement = _options$element === void 0 ? '[data-popper-arrow]' : _options$element;

  if (arrowElement == null) {
    return;
  } // CSS selector


  if (typeof arrowElement === 'string') {
    arrowElement = state.elements.popper.querySelector(arrowElement);

    if (!arrowElement) {
      return;
    }
  }

  if (!contains(state.elements.popper, arrowElement)) {
    return;
  }

  state.elements.arrow = arrowElement;
} // eslint-disable-next-line import/no-unused-modules


var arrow$1 = {
  name: 'arrow',
  enabled: true,
  phase: 'main',
  fn: arrow,
  effect: effect$1,
  requires: ['popperOffsets'],
  requiresIfExists: ['preventOverflow']
};

function getVariation(placement) {
  return placement.split('-')[1];
}

var unsetSides = {
  top: 'auto',
  right: 'auto',
  bottom: 'auto',
  left: 'auto'
}; // Round the offsets to the nearest suitable subpixel based on the DPR.
// Zooming can change the DPR, but it seems to report a value that will
// cleanly divide the values into the appropriate subpixels.

function roundOffsetsByDPR(_ref, win) {
  var x = _ref.x,
      y = _ref.y;
  var dpr = win.devicePixelRatio || 1;
  return {
    x: round(x * dpr) / dpr || 0,
    y: round(y * dpr) / dpr || 0
  };
}

function mapToStyles(_ref2) {
  var _Object$assign2;

  var popper = _ref2.popper,
      popperRect = _ref2.popperRect,
      placement = _ref2.placement,
      variation = _ref2.variation,
      offsets = _ref2.offsets,
      position = _ref2.position,
      gpuAcceleration = _ref2.gpuAcceleration,
      adaptive = _ref2.adaptive,
      roundOffsets = _ref2.roundOffsets,
      isFixed = _ref2.isFixed;
  var _offsets$x = offsets.x,
      x = _offsets$x === void 0 ? 0 : _offsets$x,
      _offsets$y = offsets.y,
      y = _offsets$y === void 0 ? 0 : _offsets$y;

  var _ref3 = typeof roundOffsets === 'function' ? roundOffsets({
    x: x,
    y: y
  }) : {
    x: x,
    y: y
  };

  x = _ref3.x;
  y = _ref3.y;
  var hasX = offsets.hasOwnProperty('x');
  var hasY = offsets.hasOwnProperty('y');
  var sideX = left;
  var sideY = top;
  var win = window;

  if (adaptive) {
    var offsetParent = getOffsetParent(popper);
    var heightProp = 'clientHeight';
    var widthProp = 'clientWidth';

    if (offsetParent === getWindow(popper)) {
      offsetParent = getDocumentElement(popper);

      if (getComputedStyle$1(offsetParent).position !== 'static' && position === 'absolute') {
        heightProp = 'scrollHeight';
        widthProp = 'scrollWidth';
      }
    } // $FlowFixMe[incompatible-cast]: force type refinement, we compare offsetParent with window above, but Flow doesn't detect it


    offsetParent = offsetParent;

    if (placement === top || (placement === left || placement === right) && variation === end) {
      sideY = bottom;
      var offsetY = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.height : // $FlowFixMe[prop-missing]
      offsetParent[heightProp];
      y -= offsetY - popperRect.height;
      y *= gpuAcceleration ? 1 : -1;
    }

    if (placement === left || (placement === top || placement === bottom) && variation === end) {
      sideX = right;
      var offsetX = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.width : // $FlowFixMe[prop-missing]
      offsetParent[widthProp];
      x -= offsetX - popperRect.width;
      x *= gpuAcceleration ? 1 : -1;
    }
  }

  var commonStyles = Object.assign({
    position: position
  }, adaptive && unsetSides);

  var _ref4 = roundOffsets === true ? roundOffsetsByDPR({
    x: x,
    y: y
  }, getWindow(popper)) : {
    x: x,
    y: y
  };

  x = _ref4.x;
  y = _ref4.y;

  if (gpuAcceleration) {
    var _Object$assign;

    return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? '0' : '', _Object$assign[sideX] = hasX ? '0' : '', _Object$assign.transform = (win.devicePixelRatio || 1) <= 1 ? "translate(" + x + "px, " + y + "px)" : "translate3d(" + x + "px, " + y + "px, 0)", _Object$assign));
  }

  return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y + "px" : '', _Object$assign2[sideX] = hasX ? x + "px" : '', _Object$assign2.transform = '', _Object$assign2));
}

function computeStyles(_ref5) {
  var state = _ref5.state,
      options = _ref5.options;
  var _options$gpuAccelerat = options.gpuAcceleration,
      gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat,
      _options$adaptive = options.adaptive,
      adaptive = _options$adaptive === void 0 ? true : _options$adaptive,
      _options$roundOffsets = options.roundOffsets,
      roundOffsets = _options$roundOffsets === void 0 ? true : _options$roundOffsets;
  var commonStyles = {
    placement: getBasePlacement(state.placement),
    variation: getVariation(state.placement),
    popper: state.elements.popper,
    popperRect: state.rects.popper,
    gpuAcceleration: gpuAcceleration,
    isFixed: state.options.strategy === 'fixed'
  };

  if (state.modifiersData.popperOffsets != null) {
    state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.popperOffsets,
      position: state.options.strategy,
      adaptive: adaptive,
      roundOffsets: roundOffsets
    })));
  }

  if (state.modifiersData.arrow != null) {
    state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.arrow,
      position: 'absolute',
      adaptive: false,
      roundOffsets: roundOffsets
    })));
  }

  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    'data-popper-placement': state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


var computeStyles$1 = {
  name: 'computeStyles',
  enabled: true,
  phase: 'beforeWrite',
  fn: computeStyles,
  data: {}
};

var passive = {
  passive: true
};

function effect(_ref) {
  var state = _ref.state,
      instance = _ref.instance,
      options = _ref.options;
  var _options$scroll = options.scroll,
      scroll = _options$scroll === void 0 ? true : _options$scroll,
      _options$resize = options.resize,
      resize = _options$resize === void 0 ? true : _options$resize;
  var window = getWindow(state.elements.popper);
  var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);

  if (scroll) {
    scrollParents.forEach(function (scrollParent) {
      scrollParent.addEventListener('scroll', instance.update, passive);
    });
  }

  if (resize) {
    window.addEventListener('resize', instance.update, passive);
  }

  return function () {
    if (scroll) {
      scrollParents.forEach(function (scrollParent) {
        scrollParent.removeEventListener('scroll', instance.update, passive);
      });
    }

    if (resize) {
      window.removeEventListener('resize', instance.update, passive);
    }
  };
} // eslint-disable-next-line import/no-unused-modules


var eventListeners = {
  name: 'eventListeners',
  enabled: true,
  phase: 'write',
  fn: function fn() {},
  effect: effect,
  data: {}
};

var hash$1 = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, function (matched) {
    return hash$1[matched];
  });
}

var hash = {
  start: 'end',
  end: 'start'
};
function getOppositeVariationPlacement(placement) {
  return placement.replace(/start|end/g, function (matched) {
    return hash[matched];
  });
}

function getWindowScroll(node) {
  var win = getWindow(node);
  var scrollLeft = win.pageXOffset;
  var scrollTop = win.pageYOffset;
  return {
    scrollLeft: scrollLeft,
    scrollTop: scrollTop
  };
}

function getWindowScrollBarX(element) {
  // If <html> has a CSS width greater than the viewport, then this will be
  // incorrect for RTL.
  // Popper 1 is broken in this case and never had a bug report so let's assume
  // it's not an issue. I don't think anyone ever specifies width on <html>
  // anyway.
  // Browsers where the left scrollbar doesn't cause an issue report `0` for
  // this (e.g. Edge 2019, IE11, Safari)
  return getBoundingClientRect(getDocumentElement(element)).left + getWindowScroll(element).scrollLeft;
}

function getViewportRect(element, strategy) {
  var win = getWindow(element);
  var html = getDocumentElement(element);
  var visualViewport = win.visualViewport;
  var width = html.clientWidth;
  var height = html.clientHeight;
  var x = 0;
  var y = 0;

  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    var layoutViewport = isLayoutViewport();

    if (layoutViewport || !layoutViewport && strategy === 'fixed') {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }

  return {
    width: width,
    height: height,
    x: x + getWindowScrollBarX(element),
    y: y
  };
}

// of the `<html>` and `<body>` rect bounds if horizontally scrollable

function getDocumentRect(element) {
  var _element$ownerDocumen;

  var html = getDocumentElement(element);
  var winScroll = getWindowScroll(element);
  var body = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
  var width = max(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
  var height = max(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
  var x = -winScroll.scrollLeft + getWindowScrollBarX(element);
  var y = -winScroll.scrollTop;

  if (getComputedStyle$1(body || html).direction === 'rtl') {
    x += max(html.clientWidth, body ? body.clientWidth : 0) - width;
  }

  return {
    width: width,
    height: height,
    x: x,
    y: y
  };
}

function isScrollParent(element) {
  // Firefox wants us to check `-x` and `-y` variations as well
  var _getComputedStyle = getComputedStyle$1(element),
      overflow = _getComputedStyle.overflow,
      overflowX = _getComputedStyle.overflowX,
      overflowY = _getComputedStyle.overflowY;

  return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
}

function getScrollParent(node) {
  if (['html', 'body', '#document'].indexOf(getNodeName(node)) >= 0) {
    // $FlowFixMe[incompatible-return]: assume body is always available
    return node.ownerDocument.body;
  }

  if (isHTMLElement(node) && isScrollParent(node)) {
    return node;
  }

  return getScrollParent(getParentNode(node));
}

/*
given a DOM element, return the list of all scroll parents, up the list of ancesors
until we get to the top window object. This list is what we attach scroll listeners
to, because if any of these parent elements scroll, we'll need to re-calculate the
reference element's position.
*/

function listScrollParents(element, list) {
  var _element$ownerDocumen;

  if (list === void 0) {
    list = [];
  }

  var scrollParent = getScrollParent(element);
  var isBody = scrollParent === ((_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
  var win = getWindow(scrollParent);
  var target = isBody ? [win].concat(win.visualViewport || [], isScrollParent(scrollParent) ? scrollParent : []) : scrollParent;
  var updatedList = list.concat(target);
  return isBody ? updatedList : // $FlowFixMe[incompatible-call]: isBody tells us target will be an HTMLElement here
  updatedList.concat(listScrollParents(getParentNode(target)));
}

function rectToClientRect(rect) {
  return Object.assign({}, rect, {
    left: rect.x,
    top: rect.y,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height
  });
}

function getInnerBoundingClientRect(element, strategy) {
  var rect = getBoundingClientRect(element, false, strategy === 'fixed');
  rect.top = rect.top + element.clientTop;
  rect.left = rect.left + element.clientLeft;
  rect.bottom = rect.top + element.clientHeight;
  rect.right = rect.left + element.clientWidth;
  rect.width = element.clientWidth;
  rect.height = element.clientHeight;
  rect.x = rect.left;
  rect.y = rect.top;
  return rect;
}

function getClientRectFromMixedType(element, clippingParent, strategy) {
  return clippingParent === viewport ? rectToClientRect(getViewportRect(element, strategy)) : isElement(clippingParent) ? getInnerBoundingClientRect(clippingParent, strategy) : rectToClientRect(getDocumentRect(getDocumentElement(element)));
} // A "clipping parent" is an overflowable container with the characteristic of
// clipping (or hiding) overflowing elements with a position different from
// `initial`


function getClippingParents(element) {
  var clippingParents = listScrollParents(getParentNode(element));
  var canEscapeClipping = ['absolute', 'fixed'].indexOf(getComputedStyle$1(element).position) >= 0;
  var clipperElement = canEscapeClipping && isHTMLElement(element) ? getOffsetParent(element) : element;

  if (!isElement(clipperElement)) {
    return [];
  } // $FlowFixMe[incompatible-return]: https://github.com/facebook/flow/issues/1414


  return clippingParents.filter(function (clippingParent) {
    return isElement(clippingParent) && contains(clippingParent, clipperElement) && getNodeName(clippingParent) !== 'body';
  });
} // Gets the maximum area that the element is visible in due to any number of
// clipping parents


function getClippingRect(element, boundary, rootBoundary, strategy) {
  var mainClippingParents = boundary === 'clippingParents' ? getClippingParents(element) : [].concat(boundary);
  var clippingParents = [].concat(mainClippingParents, [rootBoundary]);
  var firstClippingParent = clippingParents[0];
  var clippingRect = clippingParents.reduce(function (accRect, clippingParent) {
    var rect = getClientRectFromMixedType(element, clippingParent, strategy);
    accRect.top = max(rect.top, accRect.top);
    accRect.right = min(rect.right, accRect.right);
    accRect.bottom = min(rect.bottom, accRect.bottom);
    accRect.left = max(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromMixedType(element, firstClippingParent, strategy));
  clippingRect.width = clippingRect.right - clippingRect.left;
  clippingRect.height = clippingRect.bottom - clippingRect.top;
  clippingRect.x = clippingRect.left;
  clippingRect.y = clippingRect.top;
  return clippingRect;
}

function computeOffsets(_ref) {
  var reference = _ref.reference,
      element = _ref.element,
      placement = _ref.placement;
  var basePlacement = placement ? getBasePlacement(placement) : null;
  var variation = placement ? getVariation(placement) : null;
  var commonX = reference.x + reference.width / 2 - element.width / 2;
  var commonY = reference.y + reference.height / 2 - element.height / 2;
  var offsets;

  switch (basePlacement) {
    case top:
      offsets = {
        x: commonX,
        y: reference.y - element.height
      };
      break;

    case bottom:
      offsets = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;

    case right:
      offsets = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;

    case left:
      offsets = {
        x: reference.x - element.width,
        y: commonY
      };
      break;

    default:
      offsets = {
        x: reference.x,
        y: reference.y
      };
  }

  var mainAxis = basePlacement ? getMainAxisFromPlacement(basePlacement) : null;

  if (mainAxis != null) {
    var len = mainAxis === 'y' ? 'height' : 'width';

    switch (variation) {
      case start:
        offsets[mainAxis] = offsets[mainAxis] - (reference[len] / 2 - element[len] / 2);
        break;

      case end:
        offsets[mainAxis] = offsets[mainAxis] + (reference[len] / 2 - element[len] / 2);
        break;
    }
  }

  return offsets;
}

function detectOverflow(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      _options$placement = _options.placement,
      placement = _options$placement === void 0 ? state.placement : _options$placement,
      _options$strategy = _options.strategy,
      strategy = _options$strategy === void 0 ? state.strategy : _options$strategy,
      _options$boundary = _options.boundary,
      boundary = _options$boundary === void 0 ? clippingParents : _options$boundary,
      _options$rootBoundary = _options.rootBoundary,
      rootBoundary = _options$rootBoundary === void 0 ? viewport : _options$rootBoundary,
      _options$elementConte = _options.elementContext,
      elementContext = _options$elementConte === void 0 ? popper : _options$elementConte,
      _options$altBoundary = _options.altBoundary,
      altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary,
      _options$padding = _options.padding,
      padding = _options$padding === void 0 ? 0 : _options$padding;
  var paddingObject = mergePaddingObject(typeof padding !== 'number' ? padding : expandToHashMap(padding, basePlacements));
  var altContext = elementContext === popper ? reference : popper;
  var popperRect = state.rects.popper;
  var element = state.elements[altBoundary ? altContext : elementContext];
  var clippingClientRect = getClippingRect(isElement(element) ? element : element.contextElement || getDocumentElement(state.elements.popper), boundary, rootBoundary, strategy);
  var referenceClientRect = getBoundingClientRect(state.elements.reference);
  var popperOffsets = computeOffsets({
    reference: referenceClientRect,
    element: popperRect,
    strategy: 'absolute',
    placement: placement
  });
  var popperClientRect = rectToClientRect(Object.assign({}, popperRect, popperOffsets));
  var elementClientRect = elementContext === popper ? popperClientRect : referenceClientRect; // positive = overflowing the clipping rect
  // 0 or negative = within the clipping rect

  var overflowOffsets = {
    top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
    bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
    left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
    right: elementClientRect.right - clippingClientRect.right + paddingObject.right
  };
  var offsetData = state.modifiersData.offset; // Offsets can be applied only to the popper element

  if (elementContext === popper && offsetData) {
    var offset = offsetData[placement];
    Object.keys(overflowOffsets).forEach(function (key) {
      var multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
      var axis = [top, bottom].indexOf(key) >= 0 ? 'y' : 'x';
      overflowOffsets[key] += offset[axis] * multiply;
    });
  }

  return overflowOffsets;
}

function computeAutoPlacement(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      placement = _options.placement,
      boundary = _options.boundary,
      rootBoundary = _options.rootBoundary,
      padding = _options.padding,
      flipVariations = _options.flipVariations,
      _options$allowedAutoP = _options.allowedAutoPlacements,
      allowedAutoPlacements = _options$allowedAutoP === void 0 ? placements : _options$allowedAutoP;
  var variation = getVariation(placement);
  var placements$1 = variation ? flipVariations ? variationPlacements : variationPlacements.filter(function (placement) {
    return getVariation(placement) === variation;
  }) : basePlacements;
  var allowedPlacements = placements$1.filter(function (placement) {
    return allowedAutoPlacements.indexOf(placement) >= 0;
  });

  if (allowedPlacements.length === 0) {
    allowedPlacements = placements$1;
  } // $FlowFixMe[incompatible-type]: Flow seems to have problems with two array unions...


  var overflows = allowedPlacements.reduce(function (acc, placement) {
    acc[placement] = detectOverflow(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding
    })[getBasePlacement(placement)];
    return acc;
  }, {});
  return Object.keys(overflows).sort(function (a, b) {
    return overflows[a] - overflows[b];
  });
}

function getExpandedFallbackPlacements(placement) {
  if (getBasePlacement(placement) === auto) {
    return [];
  }

  var oppositePlacement = getOppositePlacement(placement);
  return [getOppositeVariationPlacement(placement), oppositePlacement, getOppositeVariationPlacement(oppositePlacement)];
}

function flip(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;

  if (state.modifiersData[name]._skip) {
    return;
  }

  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis,
      specifiedFallbackPlacements = options.fallbackPlacements,
      padding = options.padding,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      _options$flipVariatio = options.flipVariations,
      flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio,
      allowedAutoPlacements = options.allowedAutoPlacements;
  var preferredPlacement = state.options.placement;
  var basePlacement = getBasePlacement(preferredPlacement);
  var isBasePlacement = basePlacement === preferredPlacement;
  var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [getOppositePlacement(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
  var placements = [preferredPlacement].concat(fallbackPlacements).reduce(function (acc, placement) {
    return acc.concat(getBasePlacement(placement) === auto ? computeAutoPlacement(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding,
      flipVariations: flipVariations,
      allowedAutoPlacements: allowedAutoPlacements
    }) : placement);
  }, []);
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var checksMap = new Map();
  var makeFallbackChecks = true;
  var firstFittingPlacement = placements[0];

  for (var i = 0; i < placements.length; i++) {
    var placement = placements[i];

    var _basePlacement = getBasePlacement(placement);

    var isStartVariation = getVariation(placement) === start;
    var isVertical = [top, bottom].indexOf(_basePlacement) >= 0;
    var len = isVertical ? 'width' : 'height';
    var overflow = detectOverflow(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      altBoundary: altBoundary,
      padding: padding
    });
    var mainVariationSide = isVertical ? isStartVariation ? right : left : isStartVariation ? bottom : top;

    if (referenceRect[len] > popperRect[len]) {
      mainVariationSide = getOppositePlacement(mainVariationSide);
    }

    var altVariationSide = getOppositePlacement(mainVariationSide);
    var checks = [];

    if (checkMainAxis) {
      checks.push(overflow[_basePlacement] <= 0);
    }

    if (checkAltAxis) {
      checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
    }

    if (checks.every(function (check) {
      return check;
    })) {
      firstFittingPlacement = placement;
      makeFallbackChecks = false;
      break;
    }

    checksMap.set(placement, checks);
  }

  if (makeFallbackChecks) {
    // `2` may be desired in some cases – research later
    var numberOfChecks = flipVariations ? 3 : 1;

    var _loop = function _loop(_i) {
      var fittingPlacement = placements.find(function (placement) {
        var checks = checksMap.get(placement);

        if (checks) {
          return checks.slice(0, _i).every(function (check) {
            return check;
          });
        }
      });

      if (fittingPlacement) {
        firstFittingPlacement = fittingPlacement;
        return "break";
      }
    };

    for (var _i = numberOfChecks; _i > 0; _i--) {
      var _ret = _loop(_i);

      if (_ret === "break") break;
    }
  }

  if (state.placement !== firstFittingPlacement) {
    state.modifiersData[name]._skip = true;
    state.placement = firstFittingPlacement;
    state.reset = true;
  }
} // eslint-disable-next-line import/no-unused-modules


var flip$1 = {
  name: 'flip',
  enabled: true,
  phase: 'main',
  fn: flip,
  requiresIfExists: ['offset'],
  data: {
    _skip: false
  }
};

function getSideOffsets(overflow, rect, preventedOffsets) {
  if (preventedOffsets === void 0) {
    preventedOffsets = {
      x: 0,
      y: 0
    };
  }

  return {
    top: overflow.top - rect.height - preventedOffsets.y,
    right: overflow.right - rect.width + preventedOffsets.x,
    bottom: overflow.bottom - rect.height + preventedOffsets.y,
    left: overflow.left - rect.width - preventedOffsets.x
  };
}

function isAnySideFullyClipped(overflow) {
  return [top, right, bottom, left].some(function (side) {
    return overflow[side] >= 0;
  });
}

function hide(_ref) {
  var state = _ref.state,
      name = _ref.name;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var preventedOffsets = state.modifiersData.preventOverflow;
  var referenceOverflow = detectOverflow(state, {
    elementContext: 'reference'
  });
  var popperAltOverflow = detectOverflow(state, {
    altBoundary: true
  });
  var referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
  var popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
  var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
  var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
  state.modifiersData[name] = {
    referenceClippingOffsets: referenceClippingOffsets,
    popperEscapeOffsets: popperEscapeOffsets,
    isReferenceHidden: isReferenceHidden,
    hasPopperEscaped: hasPopperEscaped
  };
  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    'data-popper-reference-hidden': isReferenceHidden,
    'data-popper-escaped': hasPopperEscaped
  });
} // eslint-disable-next-line import/no-unused-modules


var hide$1 = {
  name: 'hide',
  enabled: true,
  phase: 'main',
  requiresIfExists: ['preventOverflow'],
  fn: hide
};

function distanceAndSkiddingToXY(placement, rects, offset) {
  var basePlacement = getBasePlacement(placement);
  var invertDistance = [left, top].indexOf(basePlacement) >= 0 ? -1 : 1;

  var _ref = typeof offset === 'function' ? offset(Object.assign({}, rects, {
    placement: placement
  })) : offset,
      skidding = _ref[0],
      distance = _ref[1];

  skidding = skidding || 0;
  distance = (distance || 0) * invertDistance;
  return [left, right].indexOf(basePlacement) >= 0 ? {
    x: distance,
    y: skidding
  } : {
    x: skidding,
    y: distance
  };
}

function offset(_ref2) {
  var state = _ref2.state,
      options = _ref2.options,
      name = _ref2.name;
  var _options$offset = options.offset,
      offset = _options$offset === void 0 ? [0, 0] : _options$offset;
  var data = placements.reduce(function (acc, placement) {
    acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset);
    return acc;
  }, {});
  var _data$state$placement = data[state.placement],
      x = _data$state$placement.x,
      y = _data$state$placement.y;

  if (state.modifiersData.popperOffsets != null) {
    state.modifiersData.popperOffsets.x += x;
    state.modifiersData.popperOffsets.y += y;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


var offset$1 = {
  name: 'offset',
  enabled: true,
  phase: 'main',
  requires: ['popperOffsets'],
  fn: offset
};

function popperOffsets(_ref) {
  var state = _ref.state,
      name = _ref.name;
  // Offsets are the actual position the popper needs to have to be
  // properly positioned near its reference element
  // This is the most basic placement, and will be adjusted by
  // the modifiers in the next step
  state.modifiersData[name] = computeOffsets({
    reference: state.rects.reference,
    element: state.rects.popper,
    strategy: 'absolute',
    placement: state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


var popperOffsets$1 = {
  name: 'popperOffsets',
  enabled: true,
  phase: 'read',
  fn: popperOffsets,
  data: {}
};

function getAltAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}

function preventOverflow(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;
  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      padding = options.padding,
      _options$tether = options.tether,
      tether = _options$tether === void 0 ? true : _options$tether,
      _options$tetherOffset = options.tetherOffset,
      tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
  var overflow = detectOverflow(state, {
    boundary: boundary,
    rootBoundary: rootBoundary,
    padding: padding,
    altBoundary: altBoundary
  });
  var basePlacement = getBasePlacement(state.placement);
  var variation = getVariation(state.placement);
  var isBasePlacement = !variation;
  var mainAxis = getMainAxisFromPlacement(basePlacement);
  var altAxis = getAltAxis(mainAxis);
  var popperOffsets = state.modifiersData.popperOffsets;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var tetherOffsetValue = typeof tetherOffset === 'function' ? tetherOffset(Object.assign({}, state.rects, {
    placement: state.placement
  })) : tetherOffset;
  var normalizedTetherOffsetValue = typeof tetherOffsetValue === 'number' ? {
    mainAxis: tetherOffsetValue,
    altAxis: tetherOffsetValue
  } : Object.assign({
    mainAxis: 0,
    altAxis: 0
  }, tetherOffsetValue);
  var offsetModifierState = state.modifiersData.offset ? state.modifiersData.offset[state.placement] : null;
  var data = {
    x: 0,
    y: 0
  };

  if (!popperOffsets) {
    return;
  }

  if (checkMainAxis) {
    var _offsetModifierState$;

    var mainSide = mainAxis === 'y' ? top : left;
    var altSide = mainAxis === 'y' ? bottom : right;
    var len = mainAxis === 'y' ? 'height' : 'width';
    var offset = popperOffsets[mainAxis];
    var min$1 = offset + overflow[mainSide];
    var max$1 = offset - overflow[altSide];
    var additive = tether ? -popperRect[len] / 2 : 0;
    var minLen = variation === start ? referenceRect[len] : popperRect[len];
    var maxLen = variation === start ? -popperRect[len] : -referenceRect[len]; // We need to include the arrow in the calculation so the arrow doesn't go
    // outside the reference bounds

    var arrowElement = state.elements.arrow;
    var arrowRect = tether && arrowElement ? getLayoutRect(arrowElement) : {
      width: 0,
      height: 0
    };
    var arrowPaddingObject = state.modifiersData['arrow#persistent'] ? state.modifiersData['arrow#persistent'].padding : getFreshSideObject();
    var arrowPaddingMin = arrowPaddingObject[mainSide];
    var arrowPaddingMax = arrowPaddingObject[altSide]; // If the reference length is smaller than the arrow length, we don't want
    // to include its full size in the calculation. If the reference is small
    // and near the edge of a boundary, the popper can overflow even if the
    // reference is not overflowing as well (e.g. virtual elements with no
    // width or height)

    var arrowLen = within(0, referenceRect[len], arrowRect[len]);
    var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis : minLen - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis;
    var maxOffset = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis : maxLen + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis;
    var arrowOffsetParent = state.elements.arrow && getOffsetParent(state.elements.arrow);
    var clientOffset = arrowOffsetParent ? mainAxis === 'y' ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
    var offsetModifierValue = (_offsetModifierState$ = offsetModifierState == null ? void 0 : offsetModifierState[mainAxis]) != null ? _offsetModifierState$ : 0;
    var tetherMin = offset + minOffset - offsetModifierValue - clientOffset;
    var tetherMax = offset + maxOffset - offsetModifierValue;
    var preventedOffset = within(tether ? min(min$1, tetherMin) : min$1, offset, tether ? max(max$1, tetherMax) : max$1);
    popperOffsets[mainAxis] = preventedOffset;
    data[mainAxis] = preventedOffset - offset;
  }

  if (checkAltAxis) {
    var _offsetModifierState$2;

    var _mainSide = mainAxis === 'x' ? top : left;

    var _altSide = mainAxis === 'x' ? bottom : right;

    var _offset = popperOffsets[altAxis];

    var _len = altAxis === 'y' ? 'height' : 'width';

    var _min = _offset + overflow[_mainSide];

    var _max = _offset - overflow[_altSide];

    var isOriginSide = [top, left].indexOf(basePlacement) !== -1;

    var _offsetModifierValue = (_offsetModifierState$2 = offsetModifierState == null ? void 0 : offsetModifierState[altAxis]) != null ? _offsetModifierState$2 : 0;

    var _tetherMin = isOriginSide ? _min : _offset - referenceRect[_len] - popperRect[_len] - _offsetModifierValue + normalizedTetherOffsetValue.altAxis;

    var _tetherMax = isOriginSide ? _offset + referenceRect[_len] + popperRect[_len] - _offsetModifierValue - normalizedTetherOffsetValue.altAxis : _max;

    var _preventedOffset = tether && isOriginSide ? withinMaxClamp(_tetherMin, _offset, _tetherMax) : within(tether ? _tetherMin : _min, _offset, tether ? _tetherMax : _max);

    popperOffsets[altAxis] = _preventedOffset;
    data[altAxis] = _preventedOffset - _offset;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


var preventOverflow$1 = {
  name: 'preventOverflow',
  enabled: true,
  phase: 'main',
  fn: preventOverflow,
  requiresIfExists: ['offset']
};

function getHTMLElementScroll(element) {
  return {
    scrollLeft: element.scrollLeft,
    scrollTop: element.scrollTop
  };
}

function getNodeScroll(node) {
  if (node === getWindow(node) || !isHTMLElement(node)) {
    return getWindowScroll(node);
  } else {
    return getHTMLElementScroll(node);
  }
}

function isElementScaled(element) {
  var rect = element.getBoundingClientRect();
  var scaleX = round(rect.width) / element.offsetWidth || 1;
  var scaleY = round(rect.height) / element.offsetHeight || 1;
  return scaleX !== 1 || scaleY !== 1;
} // Returns the composite rect of an element relative to its offsetParent.
// Composite means it takes into account transforms as well as layout.


function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
  if (isFixed === void 0) {
    isFixed = false;
  }

  var isOffsetParentAnElement = isHTMLElement(offsetParent);
  var offsetParentIsScaled = isHTMLElement(offsetParent) && isElementScaled(offsetParent);
  var documentElement = getDocumentElement(offsetParent);
  var rect = getBoundingClientRect(elementOrVirtualElement, offsetParentIsScaled, isFixed);
  var scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  var offsets = {
    x: 0,
    y: 0
  };

  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== 'body' || // https://github.com/popperjs/popper-core/issues/1078
    isScrollParent(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }

    if (isHTMLElement(offsetParent)) {
      offsets = getBoundingClientRect(offsetParent, true);
      offsets.x += offsetParent.clientLeft;
      offsets.y += offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX(documentElement);
    }
  }

  return {
    x: rect.left + scroll.scrollLeft - offsets.x,
    y: rect.top + scroll.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height
  };
}

function order(modifiers) {
  var map = new Map();
  var visited = new Set();
  var result = [];
  modifiers.forEach(function (modifier) {
    map.set(modifier.name, modifier);
  }); // On visiting object, check for its dependencies and visit them recursively

  function sort(modifier) {
    visited.add(modifier.name);
    var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
    requires.forEach(function (dep) {
      if (!visited.has(dep)) {
        var depModifier = map.get(dep);

        if (depModifier) {
          sort(depModifier);
        }
      }
    });
    result.push(modifier);
  }

  modifiers.forEach(function (modifier) {
    if (!visited.has(modifier.name)) {
      // check for visited object
      sort(modifier);
    }
  });
  return result;
}

function orderModifiers(modifiers) {
  // order based on dependencies
  var orderedModifiers = order(modifiers); // order based on phase

  return modifierPhases.reduce(function (acc, phase) {
    return acc.concat(orderedModifiers.filter(function (modifier) {
      return modifier.phase === phase;
    }));
  }, []);
}

function debounce(fn) {
  var pending;
  return function () {
    if (!pending) {
      pending = new Promise(function (resolve) {
        Promise.resolve().then(function () {
          pending = undefined;
          resolve(fn());
        });
      });
    }

    return pending;
  };
}

function mergeByName(modifiers) {
  var merged = modifiers.reduce(function (merged, current) {
    var existing = merged[current.name];
    merged[current.name] = existing ? Object.assign({}, existing, current, {
      options: Object.assign({}, existing.options, current.options),
      data: Object.assign({}, existing.data, current.data)
    }) : current;
    return merged;
  }, {}); // IE11 does not support Object.values

  return Object.keys(merged).map(function (key) {
    return merged[key];
  });
}

var DEFAULT_OPTIONS = {
  placement: 'bottom',
  modifiers: [],
  strategy: 'absolute'
};

function areValidElements() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return !args.some(function (element) {
    return !(element && typeof element.getBoundingClientRect === 'function');
  });
}

function popperGenerator(generatorOptions) {
  if (generatorOptions === void 0) {
    generatorOptions = {};
  }

  var _generatorOptions = generatorOptions,
      _generatorOptions$def = _generatorOptions.defaultModifiers,
      defaultModifiers = _generatorOptions$def === void 0 ? [] : _generatorOptions$def,
      _generatorOptions$def2 = _generatorOptions.defaultOptions,
      defaultOptions = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS : _generatorOptions$def2;
  return function createPopper(reference, popper, options) {
    if (options === void 0) {
      options = defaultOptions;
    }

    var state = {
      placement: 'bottom',
      orderedModifiers: [],
      options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
      modifiersData: {},
      elements: {
        reference: reference,
        popper: popper
      },
      attributes: {},
      styles: {}
    };
    var effectCleanupFns = [];
    var isDestroyed = false;
    var instance = {
      state: state,
      setOptions: function setOptions(setOptionsAction) {
        var options = typeof setOptionsAction === 'function' ? setOptionsAction(state.options) : setOptionsAction;
        cleanupModifierEffects();
        state.options = Object.assign({}, defaultOptions, state.options, options);
        state.scrollParents = {
          reference: isElement(reference) ? listScrollParents(reference) : reference.contextElement ? listScrollParents(reference.contextElement) : [],
          popper: listScrollParents(popper)
        }; // Orders the modifiers based on their dependencies and `phase`
        // properties

        var orderedModifiers = orderModifiers(mergeByName([].concat(defaultModifiers, state.options.modifiers))); // Strip out disabled modifiers

        state.orderedModifiers = orderedModifiers.filter(function (m) {
          return m.enabled;
        });
        runModifierEffects();
        return instance.update();
      },
      // Sync update – it will always be executed, even if not necessary. This
      // is useful for low frequency updates where sync behavior simplifies the
      // logic.
      // For high frequency updates (e.g. `resize` and `scroll` events), always
      // prefer the async Popper#update method
      forceUpdate: function forceUpdate() {
        if (isDestroyed) {
          return;
        }

        var _state$elements = state.elements,
            reference = _state$elements.reference,
            popper = _state$elements.popper; // Don't proceed if `reference` or `popper` are not valid elements
        // anymore

        if (!areValidElements(reference, popper)) {
          return;
        } // Store the reference and popper rects to be read by modifiers


        state.rects = {
          reference: getCompositeRect(reference, getOffsetParent(popper), state.options.strategy === 'fixed'),
          popper: getLayoutRect(popper)
        }; // Modifiers have the ability to reset the current update cycle. The
        // most common use case for this is the `flip` modifier changing the
        // placement, which then needs to re-run all the modifiers, because the
        // logic was previously ran for the previous placement and is therefore
        // stale/incorrect

        state.reset = false;
        state.placement = state.options.placement; // On each update cycle, the `modifiersData` property for each modifier
        // is filled with the initial data specified by the modifier. This means
        // it doesn't persist and is fresh on each update.
        // To ensure persistent data, use `${name}#persistent`

        state.orderedModifiers.forEach(function (modifier) {
          return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
        });

        for (var index = 0; index < state.orderedModifiers.length; index++) {
          if (state.reset === true) {
            state.reset = false;
            index = -1;
            continue;
          }

          var _state$orderedModifie = state.orderedModifiers[index],
              fn = _state$orderedModifie.fn,
              _state$orderedModifie2 = _state$orderedModifie.options,
              _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2,
              name = _state$orderedModifie.name;

          if (typeof fn === 'function') {
            state = fn({
              state: state,
              options: _options,
              name: name,
              instance: instance
            }) || state;
          }
        }
      },
      // Async and optimistically optimized update – it will not be executed if
      // not necessary (debounced to run at most once-per-tick)
      update: debounce(function () {
        return new Promise(function (resolve) {
          instance.forceUpdate();
          resolve(state);
        });
      }),
      destroy: function destroy() {
        cleanupModifierEffects();
        isDestroyed = true;
      }
    };

    if (!areValidElements(reference, popper)) {
      return instance;
    }

    instance.setOptions(options).then(function (state) {
      if (!isDestroyed && options.onFirstUpdate) {
        options.onFirstUpdate(state);
      }
    }); // Modifiers have the ability to execute arbitrary code before the first
    // update cycle runs. They will be executed in the same order as the update
    // cycle. This is useful when a modifier adds some persistent data that
    // other modifiers need to use, but the modifier is run after the dependent
    // one.

    function runModifierEffects() {
      state.orderedModifiers.forEach(function (_ref) {
        var name = _ref.name,
            _ref$options = _ref.options,
            options = _ref$options === void 0 ? {} : _ref$options,
            effect = _ref.effect;

        if (typeof effect === 'function') {
          var cleanupFn = effect({
            state: state,
            name: name,
            instance: instance,
            options: options
          });

          var noopFn = function noopFn() {};

          effectCleanupFns.push(cleanupFn || noopFn);
        }
      });
    }

    function cleanupModifierEffects() {
      effectCleanupFns.forEach(function (fn) {
        return fn();
      });
      effectCleanupFns = [];
    }

    return instance;
  };
}

var defaultModifiers = [eventListeners, popperOffsets$1, computeStyles$1, applyStyles$1, offset$1, flip$1, preventOverflow$1, arrow$1, hide$1];
var createPopper = /*#__PURE__*/popperGenerator({
  defaultModifiers: defaultModifiers
}); // eslint-disable-next-line import/no-unused-modules

var checkIcon = `<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.79502 15.875L4.62502 11.705L3.20502 13.115L8.79502 18.705L20.795 6.70501L19.385 5.29501L8.79502 15.875Z" fill="currentColor"/>
</svg>
`;

const icMenuCss = "html.sc-ic-menu{line-height:1.15;-webkit-text-size-adjust:100%}body.sc-ic-menu{margin:0}main.sc-ic-menu{display:block}h1.sc-ic-menu{font-size:2em;margin:0.67em 0}hr.sc-ic-menu{box-sizing:content-box;height:0;overflow:visible}pre.sc-ic-menu{font-family:monospace, monospace;font-size:1em}a.sc-ic-menu{background-color:transparent}abbr[title].sc-ic-menu{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}b.sc-ic-menu,strong.sc-ic-menu{font-weight:bolder}code.sc-ic-menu,kbd.sc-ic-menu,samp.sc-ic-menu{font-family:monospace, monospace;font-size:1em}small.sc-ic-menu{font-size:80%}sub.sc-ic-menu,sup.sc-ic-menu{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub.sc-ic-menu{bottom:-0.25em}sup.sc-ic-menu{top:-0.5em}img.sc-ic-menu{border-style:none}button.sc-ic-menu,input.sc-ic-menu,optgroup.sc-ic-menu,select.sc-ic-menu,textarea.sc-ic-menu{font-family:inherit;font-size:100%;line-height:1.15;margin:0}button.sc-ic-menu,input.sc-ic-menu{overflow:visible}button.sc-ic-menu,select.sc-ic-menu{text-transform:none}button.sc-ic-menu,[type=\"button\"].sc-ic-menu,[type=\"reset\"].sc-ic-menu,[type=\"submit\"].sc-ic-menu{-webkit-appearance:button}button.sc-ic-menu::-moz-focus-inner,[type=\"button\"].sc-ic-menu::-moz-focus-inner,[type=\"reset\"].sc-ic-menu::-moz-focus-inner,[type=\"submit\"].sc-ic-menu::-moz-focus-inner{border-style:none;padding:0}button.sc-ic-menu:-moz-focusring,[type=\"button\"].sc-ic-menu:-moz-focusring,[type=\"reset\"].sc-ic-menu:-moz-focusring,[type=\"submit\"].sc-ic-menu:-moz-focusring{outline:1px dotted ButtonText}fieldset.sc-ic-menu{padding:0.35em 0.75em 0.625em}legend.sc-ic-menu{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}progress.sc-ic-menu{vertical-align:baseline}textarea.sc-ic-menu{overflow:auto}[type=\"checkbox\"].sc-ic-menu,[type=\"radio\"].sc-ic-menu{box-sizing:border-box;padding:0}[type=\"number\"].sc-ic-menu::-webkit-inner-spin-button,[type=\"number\"].sc-ic-menu::-webkit-outer-spin-button{height:auto}[type=\"search\"].sc-ic-menu{-webkit-appearance:textfield;outline-offset:-2px}[type=\"search\"].sc-ic-menu::-webkit-search-decoration{-webkit-appearance:none}.sc-ic-menu::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}details.sc-ic-menu{display:block}summary.sc-ic-menu{display:list-item}template.sc-ic-menu{display:none}[hidden].sc-ic-menu{display:none}html.sc-ic-menu,body.sc-ic-menu,div.sc-ic-menu,span.sc-ic-menu,applet.sc-ic-menu,object.sc-ic-menu,iframe.sc-ic-menu,h1.sc-ic-menu,h2.sc-ic-menu,h3.sc-ic-menu,h4.sc-ic-menu,h5.sc-ic-menu,h6.sc-ic-menu,p.sc-ic-menu,blockquote.sc-ic-menu,pre.sc-ic-menu,a.sc-ic-menu,abbr.sc-ic-menu,acronym.sc-ic-menu,address.sc-ic-menu,big.sc-ic-menu,cite.sc-ic-menu,code.sc-ic-menu,del.sc-ic-menu,dfn.sc-ic-menu,em.sc-ic-menu,img.sc-ic-menu,ins.sc-ic-menu,kbd.sc-ic-menu,q.sc-ic-menu,s.sc-ic-menu,samp.sc-ic-menu,small.sc-ic-menu,strike.sc-ic-menu,strong.sc-ic-menu,sub.sc-ic-menu,sup.sc-ic-menu,tt.sc-ic-menu,var.sc-ic-menu,b.sc-ic-menu,u.sc-ic-menu,i.sc-ic-menu,center.sc-ic-menu,dl.sc-ic-menu,dt.sc-ic-menu,dd.sc-ic-menu,ol.sc-ic-menu,ul.sc-ic-menu,li.sc-ic-menu,fieldset.sc-ic-menu,form.sc-ic-menu,label.sc-ic-menu,legend.sc-ic-menu,table.sc-ic-menu,caption.sc-ic-menu,tbody.sc-ic-menu,tfoot.sc-ic-menu,thead.sc-ic-menu,tr.sc-ic-menu,th.sc-ic-menu,td.sc-ic-menu,article.sc-ic-menu,aside.sc-ic-menu,canvas.sc-ic-menu,details.sc-ic-menu,embed.sc-ic-menu,figure.sc-ic-menu,figcaption.sc-ic-menu,footer.sc-ic-menu,header.sc-ic-menu,hgroup.sc-ic-menu,menu.sc-ic-menu,nav.sc-ic-menu,output.sc-ic-menu,ruby.sc-ic-menu,section.sc-ic-menu,summary.sc-ic-menu,time.sc-ic-menu,mark.sc-ic-menu,audio.sc-ic-menu,video.sc-ic-menu{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}@media (prefers-reduced-motion: no-preference){.open.sc-ic-menu-h .menu.sc-ic-menu{transition:max-height var(--ic-transition-duration-slow)}}.sc-ic-menu-h{border-radius:var(--ic-border-radius);max-height:0;width:var(--input-width, 20rem);color:var(--ic-color-primary-text);background-color:var(--ic-architectural-white);position:relative;z-index:var(--ic-z-index-menu);box-sizing:border-box;box-shadow:var(--ic-elevation-overlay)}.sc-ic-menu-h:not(.no-focus):focus-within{box-shadow:var(--ic-border-focus)}#retry-button.sc-ic-menu::part(button){height:var(--ic-space-lg)}.small.sc-ic-menu #retry-button.sc-ic-menu::part(button){height:var(--ic-space-md)}.on-dialog.sc-ic-menu-h{inset:auto !important}.menu.sc-ic-menu{text-decoration:none;list-style-type:none;border:var(--ic-border-width) solid var(--ic-architectural-400);border-radius:var(--ic-border-radius);background-color:var(--ic-architectural-white);visibility:hidden;max-height:0;overflow-y:hidden}.menu-scroll.sc-ic-menu{overflow-y:auto}.menu.sc-ic-menu:focus-visible{outline:none}.open.sc-ic-menu-h{max-height:none;display:block}.open.sc-ic-menu-h .menu.sc-ic-menu{visibility:visible;max-height:calc(var(--ic-space-xl) * 10 + var(--ic-space-xxxs))}.full-width.sc-ic-menu-h{width:100%}.option.sc-ic-menu{padding:var(--ic-space-xs) calc(var(--ic-space-xs) - var(--ic-space-1px));cursor:pointer;display:flex;align-items:center;overflow-wrap:anywhere}.option.sc-ic-menu:not(.loading-option){justify-content:space-between}.small.sc-ic-menu-h .option.sc-ic-menu{padding:var(--ic-space-xxs) calc(var(--ic-space-xs) - var(--ic-space-1px))}.large.sc-ic-menu-h .option.sc-ic-menu{padding:var(--ic-space-sm) calc(var(--ic-space-xs) - var(--ic-space-1px))}.option.sc-ic-menu:last-child{border-radius:0 0 var(--ic-space-1px) var(--ic-space-1px)}.option.sc-ic-menu:first-child{border-radius:var(--ic-space-1px) var(--ic-space-1px) 0 0}.option.sc-ic-menu:not(.disabled-option):hover{background-color:var(--ic-action-dark-bg-hover)}.option.sc-ic-menu:not(.disabled-option):active{background-color:var(--ic-action-dark-bg-active)}.option.sc-ic-menu:focus-visible{outline:var(--ic-hc-focus-outline)}.option.sc-ic-menu:not(.disabled-option) .option-description.sc-ic-menu{color:var(--ic-color-secondary-text)}.option.sc-ic-menu .option-label.sc-ic-menu{display:flex;flex-direction:row;align-items:top}.option.sc-ic-menu .option-element.sc-ic-menu{margin-top:var(--ic-space-xxs)}.option.sc-ic-menu .option-icon.sc-ic-menu{height:var(--ic-space-md);width:var(--ic-space-md);margin-top:var(--ic-space-xxs);margin-right:var(--ic-space-xxxs)}.option-text-container.sc-ic-menu{pointer-events:none}.option.loading-option.sc-ic-menu .option-text-container.sc-ic-menu{margin-left:calc(var(--ic-space-xs) + var(--ic-space-xxxs));color:var(--ic-color-secondary-text)}.error-icon-svg.sc-ic-menu{height:var(--ic-space-md);width:var(--ic-space-md);fill:var(--ic-status-error);align-self:center;display:flex;margin-right:calc(var(--ic-space-xxs) * 1.2)}.loading-error-info.sc-ic-menu{display:flex}.check-icon.sc-ic-menu{height:var(--ic-space-lg);width:var(--ic-space-lg);margin-left:var(--ic-space-xs);pointer-events:none}.focused-option.sc-ic-menu .check-icon.sc-ic-menu *.sc-ic-menu{fill:currentcolor}.option-group-title.sc-ic-menu{padding:var(--ic-space-lg) calc(var(--ic-space-xs) - var(--ic-space-1px))\n    var(--ic-space-xs);color:var(--ic-color-tertiary-text)}.small.sc-ic-menu-h .option-group-title.sc-ic-menu{padding:var(--ic-space-sm) calc(var(--ic-space-xs) - var(--ic-space-1px))\n    var(--ic-space-xxs)}.last-recommended-option.sc-ic-menu{border-bottom:var(--ic-border-default)}.disabled-option.sc-ic-menu{color:var(--ic-architectural-200);cursor:default;pointer-events:none}.focused-option.sc-ic-menu,.focused-option.sc-ic-menu .option-description.sc-ic-menu{background-color:var(--ic-focus-blue) !important;color:var(--ic-color-white-text) !important}.no-results.sc-ic-menu-h li.sc-ic-menu{cursor:no-drop}.no-results.sc-ic-menu-h li.sc-ic-menu:hover{background-color:transparent}@media (forced-colors: active){.focused-option.sc-ic-menu:focus{outline:none;border:0.125rem solid transparent}}";

// eslint-disable-next-line @typescript-eslint/no-unused-vars
class Menu {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.menuKeyPress = createEvent(this, "menuKeyPress", 7);
        this.menuOptionId = createEvent(this, "menuOptionId", 7);
        this.menuOptionSelect = createEvent(this, "menuOptionSelect", 7);
        this.menuStateChange = createEvent(this, "menuStateChange", 7);
        this.menuValueChange = createEvent(this, "menuValueChange", 7);
        this.retryButtonClicked = createEvent(this, "retryButtonClicked", 7);
        this.timeoutBlur = createEvent(this, "timeoutBlur", 7);
        this.ungroupedOptionsSet = createEvent(this, "ungroupedOptionsSet", 7);
        this.disabledOptionSelected = false;
        this.hasPreviouslyBlurred = false;
        this.hasTimedOut = false;
        this.isLoading = false;
        this.isSearchBar = false;
        this.isSearchableSelect = false;
        // Prevents menu re-opening immediately after it is closed on blur when clicking input.
        this.preventClickOpen = false;
        this.ungroupedOptions = [];
        this.handleClearListener = () => {
            this.optionHighlighted = "";
        };
        this.handleSubmitSearch = () => {
            const highlightedOptionIndex = this.options.findIndex((option) => option[this.valueField] === this.optionHighlighted);
            this.setInputValue(highlightedOptionIndex);
        };
        this.handleMenuChange = (open, focusInput) => {
            this.menuStateChange.emit({ open, focusInput });
            if (!open && focusInput !== false) {
                this.inputEl.focus();
                this.preventClickOpen = false;
            }
        };
        this.setNextOptionValue = (selectedOptionIndex) => {
            if (this.ungroupedOptions[selectedOptionIndex + 1]) {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[selectedOptionIndex + 1][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[selectedOptionIndex + 1][this.valueField]),
                });
            }
            else {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[0][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[0][this.valueField]),
                });
            }
        };
        this.setPreviousOptionValue = (selectedOptionIndex) => {
            if (this.ungroupedOptions[selectedOptionIndex - 1]) {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[selectedOptionIndex - 1][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[selectedOptionIndex - 1][this.valueField]),
                });
            }
            else {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[this.ungroupedOptions.length - 1][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[this.ungroupedOptions.length - 1][this.valueField]),
                });
            }
        };
        this.getParentEl = (parent) => {
            if (parent.tagName === "IC-SEARCH-BAR") {
                this.isSearchBar = true;
            }
            else if (parent.tagName === "IC-SELECT" &&
                parent.getAttribute("searchable") !== null &&
                parent.getAttribute("searchable") !== undefined) {
                this.isSearchableSelect = true;
            }
        };
        this.arrowBehaviour = (event) => {
            event.preventDefault();
            this.handleMenuChange(true);
        };
        this.setMenuOptions = () => this.isSearchBar ? this.options : this.ungroupedOptions;
        this.setHighlightedOption = (highlightedIndex) => {
            const menuOptions = this.setMenuOptions();
            menuOptions[highlightedIndex] &&
                !menuOptions[highlightedIndex].timedOut &&
                (this.optionHighlighted =
                    menuOptions[highlightedIndex][this.valueField] || undefined);
        };
        this.autoSetInputValueKeyboardOpen = (event) => {
            const selectedOptionIndex = this.ungroupedOptions.findIndex((option) => option[this.valueField] === this.value);
            this.keyboardNav = false;
            switch (event.key) {
                case "ArrowDown":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    this.setNextOptionValue(selectedOptionIndex);
                    break;
                case "ArrowUp":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    this.setPreviousOptionValue(selectedOptionIndex);
                    break;
                case " ":
                case "Enter":
                    if (event.target.id !== "clear-button") {
                        this.handleMenuChange(true);
                    }
                    break;
            }
        };
        this.manSetInputValueKeyboardOpen = (event) => {
            const menuOptions = this.setMenuOptions();
            const highlightedOptionIndex = menuOptions.findIndex((option) => option[this.valueField] === this.optionHighlighted);
            const getOptionId = (index) => { var _a; return (_a = Array.from(this.host.querySelectorAll("li"))[index]) === null || _a === void 0 ? void 0 : _a.id; };
            const isOpen = this.isSearchBar || this.isSearchableSelect || this.open;
            switch (event.key) {
                case "ArrowDown":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    if (highlightedOptionIndex < menuOptions.length - 1) {
                        this.setHighlightedOption(highlightedOptionIndex + 1);
                        this.menuOptionId.emit({
                            optionId: getOptionId(highlightedOptionIndex + 1),
                        });
                    }
                    else {
                        this.setHighlightedOption(0);
                        this.menuOptionId.emit({
                            optionId: getOptionId(0),
                        });
                    }
                    this.preventIncorrectTabOrder = false;
                    this.focusFromSearchKeypress = false;
                    break;
                case "ArrowUp":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    if (highlightedOptionIndex <= 0 ||
                        highlightedOptionIndex > menuOptions.length + 1) {
                        this.setHighlightedOption(menuOptions.length - 1);
                        this.menuOptionId.emit({
                            optionId: getOptionId(menuOptions.length - 1),
                        });
                    }
                    else {
                        this.setHighlightedOption(highlightedOptionIndex - 1);
                        this.menuOptionId.emit({
                            optionId: getOptionId(highlightedOptionIndex - 1),
                        });
                    }
                    this.preventIncorrectTabOrder = false;
                    this.focusFromSearchKeypress = false;
                    break;
                case "Home":
                    this.keyboardNav = true;
                    event.preventDefault();
                    this.arrowBehaviour(event);
                    this.setHighlightedOption(0);
                    this.menuOptionId.emit({
                        optionId: getOptionId(0),
                    });
                    break;
                case "End":
                    this.keyboardNav = true;
                    event.preventDefault();
                    this.arrowBehaviour(event);
                    this.setHighlightedOption(menuOptions.length - 1);
                    this.menuOptionId.emit({
                        optionId: getOptionId(menuOptions.length - 1),
                    });
                    break;
                case " ":
                    this.keyboardNav = false;
                    if (this.isSearchBar || this.isSearchableSelect) {
                        break;
                    }
                    else {
                        if (event.target.id !== "clear-button") {
                            this.handleMenuChange(true);
                        }
                    }
                    break;
                case "Enter":
                    event.preventDefault();
                    this.keyboardNav = false;
                    if (isOpen) {
                        if (highlightedOptionIndex >= 0) {
                            if (menuOptions[highlightedOptionIndex] !== undefined) {
                                if (this.isSearchBar &&
                                    menuOptions[highlightedOptionIndex].disabled === true) {
                                    this.disabledOptionSelected = true;
                                }
                                else {
                                    this.setInputValue(highlightedOptionIndex);
                                    this.value =
                                        menuOptions[highlightedOptionIndex][this.valueField];
                                }
                            }
                        }
                        else {
                            this.setInputValue(highlightedOptionIndex);
                        }
                    }
                    else {
                        this.handleMenuChange(true);
                    }
                    break;
                case "Escape":
                    if (this.open) {
                        event.stopImmediatePropagation();
                    }
                    this.handleMenuChange(false);
                    this.menuOptionId.emit({ optionId: undefined });
                    break;
                case "Shift":
                case "Tab":
                    if (this.isSearchBar) {
                        this.keyboardNav = true;
                    }
                    this.preventIncorrectTabOrder = true;
                    break;
                default:
                    this.keyboardNav = false;
                    this.focusOnSearchOrSelectInput(menuOptions, highlightedOptionIndex);
                    break;
            }
        };
        this.setInputValue = (highlightedOptionIndex) => {
            const menuOptions = this.setMenuOptions();
            if (menuOptions[highlightedOptionIndex] !== undefined) {
                this.menuOptionSelect.emit({
                    value: menuOptions[highlightedOptionIndex][this.valueField],
                });
                this.optionHighlighted = undefined;
                this.menuOptionId.emit({ optionId: undefined });
            }
            if (!this.hasTimedOut)
                this.handleMenuChange(false);
            else
                this.parentEl.setFocus();
        };
        this.handleOptionClick = (event) => {
            const { value, label } = event.target.dataset;
            this.menuOptionSelect.emit({ value, label });
            this.handleMenuChange(false);
        };
        this.handleRetry = () => {
            this.retryButtonClicked.emit({ value: this.value });
        };
        this.handleRetryKeyDown = (ev) => {
            if (ev.key === "Enter" || ev.key === " ") {
                ev.preventDefault();
                this.retryButtonClicked.emit({ value: this.value, keyPressed: ev.key });
            }
        };
        this.handleBlur = (event) => {
            if (event.relatedTarget !== this.inputEl) {
                if (!this.menu.contains(event.relatedTarget)) {
                    this.handleMenuChange(false, this.hasPreviouslyBlurred);
                }
            }
            else {
                this.handleMenuChange(false);
                this.preventClickOpen = true;
            }
            if (!this.isSearchBar)
                this.hasPreviouslyBlurred = !!event.relatedTarget;
        };
        this.handleMouseDown = (event) => {
            event.preventDefault();
        };
        this.handleMenuKeyDown = (event) => {
            if (this.activationType === "automatic") {
                this.autoSetValueOnMenuKeyDown(event);
            }
            else if (this.activationType === "manual" && !this.isSearchBar) {
                this.manSetInputValueKeyboardOpen(event);
            }
        };
        this.emitMenuKeyPress = (isNavKey, key) => {
            this.menuKeyPress.emit({ isNavKey: isNavKey, key: key });
        };
        this.autoSetValueOnMenuKeyDown = (event) => {
            event.cancelBubble = true;
            const selectedOptionIndex = this.ungroupedOptions.findIndex((option) => option[this.valueField] === this.value);
            const isSearchableSelect = this.inputEl.tagName === "INPUT";
            this.keyboardNav = false;
            switch (event.key) {
                case " ":
                    event.preventDefault();
                    break;
                case "ArrowUp":
                    if (!this.hasTimedOut) {
                        event.preventDefault();
                        this.setPreviousOptionValue(selectedOptionIndex);
                        this.keyboardNav = true;
                    }
                    break;
                case "ArrowDown":
                    if (!this.hasTimedOut) {
                        event.preventDefault();
                        this.setNextOptionValue(selectedOptionIndex);
                        this.keyboardNav = true;
                    }
                    break;
                case "Home":
                    this.menuOptionSelect.emit({
                        value: this.ungroupedOptions[0][this.valueField],
                    });
                    this.keyboardNav = true;
                    break;
                case "End":
                    this.menuOptionSelect.emit({
                        value: this.ungroupedOptions[this.ungroupedOptions.length - 1][this.valueField],
                    });
                    this.keyboardNav = true;
                    break;
                case "Enter":
                    !this.hasTimedOut && this.handleMenuChange(false);
                    break;
                case "Escape":
                    this.handleMenuChange(false);
                    break;
                case "Backspace":
                    if (isSearchableSelect) {
                        this.inputEl.focus();
                    }
                    break;
                case "Shift":
                    break;
                default:
                    if (isSearchableSelect && event.key !== "Tab" && !this.hasTimedOut) {
                        this.inputEl.focus();
                    }
                    if (event.key.length === 1) {
                        this.keyboardNav = true;
                    }
                    break;
            }
            this.emitMenuKeyPress(this.keyboardNav, event.key);
        };
        this.handleMenuKeyUp = (event) => {
            if (event.key === "Tab" && event.shiftKey) {
                this.preventClickOpen = false;
            }
            if (event.key === "Enter" && this.disabledOptionSelected) {
                this.disabledOptionSelected = false;
                event.stopImmediatePropagation();
            }
        };
        this.getOptionId = (value) => {
            return `${this.menuId}-${value}`;
        };
        this.getOptionAriaLabel = (option, parentOption) => {
            let ariaLabel = option[this.labelField];
            if (option.description) {
                ariaLabel = `${ariaLabel}, ${option.description}`;
            }
            if (option.element) {
                ariaLabel = `${ariaLabel}, ${option.element.ariaLabel}`;
            }
            if (parentOption) {
                return `${ariaLabel}, ${parentOption[this.labelField]} group`;
            }
            else {
                return ariaLabel;
            }
        };
        this.getSortedOptions = (options) => {
            let sorted = [];
            if (options.sort) {
                sorted = options.sort((optionA, optionB) => optionA.recommended && !optionB.recommended ? -1 : 0);
            }
            return sorted;
        };
        this.isManualMode = this.activationType === "manual";
        this.scrollToSelected = (menu) => {
            const selectedOption = this.selectOnEnter
                ? this.host.querySelector(`li[data-value="${this.optionHighlighted}"]`)
                : menu.querySelector(".option[aria-selected='true']");
            if (selectedOption) {
                const elTop = selectedOption.offsetTop + selectedOption.offsetHeight;
                if (elTop > menu.scrollTop + menu.offsetHeight ||
                    elTop < menu.scrollTop + menu.offsetHeight) {
                    menu.scrollTop = selectedOption.offsetTop;
                }
                selectedOption.focus();
            }
        };
        this.loadUngroupedOptions = () => {
            if (this.options.length > 0 && this.options.map) {
                this.options.map((option) => {
                    if (option.children) {
                        option.children.map((option) => !option.disabled && this.ungroupedOptions.push(option));
                    }
                    else if (!option.disabled) {
                        this.ungroupedOptions.push(option);
                    }
                });
            }
            this.ungroupedOptions = this.getSortedOptions(this.ungroupedOptions);
            this.ungroupedOptionsSet.emit({ options: this.ungroupedOptions });
        };
        this.setMenuScrollbar = () => {
            let optionsHeight = 0;
            this.host
                .querySelectorAll(".option")
                .forEach((option) => (optionsHeight += option.clientHeight));
            if (optionsHeight >= 320) {
                this.menu.classList.add("menu-scroll");
            }
        };
        this.handleTimeoutBlur = (ev) => {
            this.timeoutBlur.emit({ ev });
        };
        this.optionContent = (option) => {
            var _a;
            return (hAsync(Fragment, null, option.loading && hAsync("ic-loading-indicator", { size: "icon" }), hAsync("div", { class: "option-text-container" }, hAsync("div", { class: "option-label" }, option.icon && (hAsync("div", { class: "option-icon", innerHTML: option.icon, "aria-hidden": "true" })), hAsync("ic-typography", { variant: "body", "aria-hidden": "true" }, option[this.labelField])), option.description && (hAsync("ic-typography", { id: `${this.getOptionId(option[this.valueField])}-description`, class: "option-description", variant: "caption", "aria-hidden": "true" }, hAsync("p", null, option.description))), option.element && (hAsync("div", { class: "option-element", innerHTML: option.element.component, "aria-hidden": "true" }))), !!option[this.valueField] &&
                !!this.value &&
                option[this.valueField].toLowerCase() === ((_a = this.value) === null || _a === void 0 ? void 0 : _a.toLowerCase()) &&
                this.parentEl.tagName !== "IC-SEARCH-BAR" && (hAsync("span", { class: "check-icon", innerHTML: checkIcon }))));
        };
        this.displayOption = (option, index, parentOption) => {
            const { open, value, keyboardNav, isManualMode, initialOptionsListRender, optionHighlighted, options, } = this;
            return (hAsync("li", { id: this.getOptionId(option[this.valueField]), class: {
                    option: true,
                    "focused-option": isManualMode
                        ? (keyboardNav || initialOptionsListRender) &&
                            option[this.valueField] === optionHighlighted
                        : keyboardNav && option[this.valueField] === value,
                    "last-recommended-option": option.recommended &&
                        options[index + 1] &&
                        !options[index + 1].recommended,
                    "disabled-option": option.disabled,
                    "loading-option": option.loading,
                    timeout: option.timedOut,
                }, role: "option", tabindex: open &&
                    (option[this.valueField] === value ||
                        option[this.valueField] === optionHighlighted) &&
                    keyboardNav
                    ? "0"
                    : "-1", "aria-label": this.getOptionAriaLabel(option, parentOption), "aria-selected": `${option[this.valueField] === value}`, "aria-disabled": option.disabled ? "true" : "false", onClick: !option.timedOut && !option.loading && this.handleOptionClick, onBlur: this.handleBlur, onMouseDown: this.handleMouseDown, "data-value": option[this.valueField], "data-label": option[this.labelField] }, option.timedOut ? (hAsync(Fragment, null, hAsync("div", { class: "loading-error-info" }, hAsync("svg", { class: "error-icon-svg", "aria-labelledby": "error-title", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", fill: "#000000" }, hAsync("title", { id: "error-title" }, "Error"), hAsync("g", { id: "close-octagon" }, hAsync("path", { id: "Vector", d: "M8.77 3L3.5 8.27V15.73L8.77 21H16.23L21.5 15.73V8.27L16.23 3M8.91 7L12.5 10.59L16.09 7L17.5 8.41L13.91 12L17.5 15.59L16.09 17L12.5 13.41L8.91 17L7.5 15.59L11.09 12L7.5 8.41" }))), hAsync("ic-typography", { variant: "label" }, option[this.labelField])), hAsync("ic-button", { size: "small", variant: "tertiary", onClick: this.handleRetry, onKeyDown: this.handleRetryKeyDown, onBlur: this.handleTimeoutBlur, id: "retry-button" }, "Retry"))) : (this.optionContent(option))));
        };
        this.focusFromSearchKeypress = false;
        this.initialOptionsListRender = false;
        this.keyboardNav = false;
        this.optionHighlighted = undefined;
        this.preventIncorrectTabOrder = false;
        this.activationType = "automatic";
        this.anchorEl = undefined;
        this.autoFocusOnSelected = true;
        this.fullWidth = false;
        this.inputEl = undefined;
        this.inputLabel = undefined;
        this.labelField = "label";
        this.menuId = undefined;
        this.open = undefined;
        this.parentEl = undefined;
        this.searchMode = "navigation";
        this.selectOnEnter = false;
        this.size = "default";
        this.small = false;
        this.options = undefined;
        this.value = undefined;
        this.valueField = "value";
    }
    watchOpenHandler() {
        if (!this.open && this.popperInstance) {
            this.popperInstance.destroy();
            this.popperInstance = null;
        }
    }
    watchOptionsHandler(newOptions) {
        this.hasTimedOut = newOptions.some((opt) => opt.timedOut);
        this.isLoading = newOptions.some((opt) => opt.loading);
        this.ungroupedOptions = [];
        this.loadUngroupedOptions();
    }
    watchValueHandler() {
        this.menuValueChange.emit({ value: this.value });
    }
    connectedCallback() {
        this.getParentEl(this.parentEl);
        if (this.isSearchBar) {
            if (this.searchMode === "navigation")
                this.setHighlightedOption(0);
            this.initialOptionsListRender = true;
        }
    }
    disconnectedCallback() {
        if (this.popperInstance) {
            this.popperInstance.destroy();
        }
        this.parentEl.removeEventListener("icClear", this.handleClearListener);
        this.parentEl.removeEventListener("icSubmitSearch", this.handleSubmitSearch);
    }
    componentWillLoad() {
        var _a, _b;
        this.loadUngroupedOptions();
        this.parentEl.addEventListener("icClear", this.handleClearListener);
        this.parentEl.addEventListener("icSubmitSearch", this.handleSubmitSearch);
        this.hasTimedOut = (_a = this.options) === null || _a === void 0 ? void 0 : _a.some((opt) => opt.timedOut);
        this.isLoading = (_b = this.options) === null || _b === void 0 ? void 0 : _b.some((opt) => opt.loading);
    }
    componentDidLoad() {
        if (this.isSearchBar &&
            this.parentEl.disableFilter) {
            this.focusFromSearchKeypress = true;
        }
        onComponentRequiredPropUndefined([
            { prop: this.open, propName: "open" },
            { prop: this.options, propName: "options" },
            { prop: this.menuId, propName: "menu-id" },
            { prop: this.inputLabel, propName: "input-label" },
            //NOTE: no check for value, input-el or anchor-el as otherwise get console errors on first load of select component
        ], "Menu");
    }
    componentDidUpdate() {
        const inputValueInOptions = this.options.some((option) => option[this.valueField] === this.value);
        if (this.open && this.options.length !== 0) {
            if (this.value &&
                this.keyboardNav &&
                inputValueInOptions &&
                this.autoFocusOnSelected &&
                !this.isSearchableSelect) {
                this.scrollToSelected(this.menu);
            }
            else if (this.inputEl.tagName !== "IC-TEXT-FIELD" &&
                this.inputEl.tagName !== "INPUT") {
                this.menu.focus();
            }
            else if (!!this.optionHighlighted &&
                !this.focusFromSearchKeypress &&
                !this.preventIncorrectTabOrder) {
                const highlightedEl = this.host.querySelector(`li[data-value="${this.optionHighlighted}"]`);
                if (highlightedEl) {
                    highlightedEl.focus();
                }
            }
        }
        if (this.open && !this.value && this.selectOnEnter) {
            this.scrollToSelected(this.menu);
        }
    }
    componentDidRender() {
        if (this.open && !this.popperInstance && this.anchorEl) {
            this.initPopperJs(this.anchorEl);
        }
        if (this.open && !!this.options.length) {
            this.setMenuScrollbar();
        }
    }
    /**
     * @internal If menu is opened with the mouse, emit menuStateChange custom event.
     */
    async handleClickOpen() {
        if (!this.preventClickOpen) {
            this.menuStateChange.emit({ open: !this.open });
            this.keyboardNav = false;
        }
        this.preventClickOpen = false;
    }
    /**
     * Used alongside activationType
     * If menu is opened via keyboard navigation (i.e. Enter, ArrowUp or ArrowDown), emit optionSelect custom event.
     * @param {KeyboardEvent} event The keyboard event which is available when handleKeyboardOpen is invoked.
     */
    async handleKeyboardOpen(event) {
        if (this.activationType === "automatic") {
            this.autoSetInputValueKeyboardOpen(event);
        }
        else {
            this.manSetInputValueKeyboardOpen(event);
        }
    }
    /**
     * @internal Used to highlight the first option in the menu.
     */
    async handleSetFirstOption() {
        this.setHighlightedOption(0);
    }
    /**
     * @internal Used to initialize popperJS with an anchor element.
     * 5/12/2023: Tested with Floating UI, however, discovered inconsistent
     * boundary behaviour so sticking with PopperJS.
     */
    async initPopperJs(anchor) {
        this.popperInstance = createPopper(anchor, this.host, {
            placement: "bottom",
            modifiers: [
                {
                    name: "offset",
                    options: {
                        offset: [0, 7],
                    },
                },
                {
                    name: "flip",
                    options: {
                        fallbackPlacements: ["top"],
                        rootBoundary: "viewport",
                    },
                },
            ],
        });
    }
    focusOnSearchOrSelectInput(menuOptions, highlightedOptionIndex) {
        if (!menuOptions[highlightedOptionIndex])
            return;
        if (this.isSearchBar) {
            this.parentEl.setFocus();
            if (this.searchMode === "navigation")
                this.setHighlightedOption(0);
        }
        if (this.isSearchableSelect) {
            this.parentEl.setFocus();
        }
        this.focusFromSearchKeypress = true;
    }
    render() {
        const { inputLabel, options, menuId, value, fullWidth, hasTimedOut, isLoading, size, small, open, inputEl, keyboardNav, } = this;
        return (hAsync(Host, { class: {
                "full-width": fullWidth,
                "no-focus": (inputEl === null || inputEl === void 0 ? void 0 : inputEl.tagName) === "INPUT" || hasTimedOut || isLoading,
                small: small,
                [size]: true,
                open: open,
            } }, options.length !== 0 && (hAsync("ul", { id: menuId, class: "menu", role: "listbox", "aria-label": inputLabel, "aria-activedescendant": value != null && value !== "" ? this.getOptionId(value) : "", tabindex: open && !keyboardNav && (inputEl === null || inputEl === void 0 ? void 0 : inputEl.tagName) !== "INPUT" ? "0" : "-1", ref: (el) => (this.menu = el), onKeyDown: this.handleMenuKeyDown, onKeyUp: this.handleMenuKeyUp, onBlur: this.handleBlur }, this.getSortedOptions(options).map((option, index) => {
            if (option.children) {
                if (option.children.length > 0) {
                    return (hAsync("div", null, hAsync("ic-typography", { class: "option-group-title", role: "presentation", variant: "subtitle-small" }, hAsync("p", null, option[this.labelField])), option.children.map((childOption) => this.displayOption(childOption, index, option))));
                }
                else {
                    return null;
                }
            }
            else {
                return this.displayOption(option, index);
            }
        })))));
    }
    get host() { return getElement(this); }
    static get watchers() { return {
        "open": ["watchOpenHandler"],
        "options": ["watchOptionsHandler"],
        "value": ["watchValueHandler"]
    }; }
    static get style() { return icMenuCss; }
    static get cmpMeta() { return {
        "$flags$": 2,
        "$tagName$": "ic-menu",
        "$members$": {
            "activationType": [1, "activation-type"],
            "anchorEl": [16],
            "autoFocusOnSelected": [4, "auto-focus-on-selected"],
            "fullWidth": [4, "full-width"],
            "inputEl": [16],
            "inputLabel": [1, "input-label"],
            "labelField": [1, "label-field"],
            "menuId": [1, "menu-id"],
            "open": [516],
            "parentEl": [16],
            "searchMode": [1, "search-mode"],
            "selectOnEnter": [4, "select-on-enter"],
            "size": [1],
            "small": [4],
            "options": [16],
            "value": [1025],
            "valueField": [1, "value-field"],
            "focusFromSearchKeypress": [32],
            "initialOptionsListRender": [32],
            "keyboardNav": [32],
            "optionHighlighted": [32],
            "preventIncorrectTabOrder": [32],
            "handleClickOpen": [64],
            "handleKeyboardOpen": [64],
            "handleSetFirstOption": [64],
            "initPopperJs": [64]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": [["open", "open"]]
    }; }
}

const icMenuGroupCss = "/*!@html*/html.sc-ic-menu-group{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-menu-group{margin:0}/*!@main*/main.sc-ic-menu-group{display:block}/*!@h1*/h1.sc-ic-menu-group{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-menu-group{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-menu-group{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-menu-group{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-menu-group{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-menu-group,strong.sc-ic-menu-group{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-menu-group,kbd.sc-ic-menu-group,samp.sc-ic-menu-group{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-menu-group{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-menu-group,sup.sc-ic-menu-group{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-menu-group{bottom:-0.25em}/*!@sup*/sup.sc-ic-menu-group{top:-0.5em}/*!@img*/img.sc-ic-menu-group{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-menu-group,input.sc-ic-menu-group,optgroup.sc-ic-menu-group,select.sc-ic-menu-group,textarea.sc-ic-menu-group{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-menu-group,input.sc-ic-menu-group{overflow:visible}/*!@button,\nselect*/button.sc-ic-menu-group,select.sc-ic-menu-group{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-menu-group,[type=\"button\"].sc-ic-menu-group,[type=\"reset\"].sc-ic-menu-group,[type=\"submit\"].sc-ic-menu-group{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-menu-group::-moz-focus-inner,[type=\"button\"].sc-ic-menu-group::-moz-focus-inner,[type=\"reset\"].sc-ic-menu-group::-moz-focus-inner,[type=\"submit\"].sc-ic-menu-group::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-menu-group:-moz-focusring,[type=\"button\"].sc-ic-menu-group:-moz-focusring,[type=\"reset\"].sc-ic-menu-group:-moz-focusring,[type=\"submit\"].sc-ic-menu-group:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-menu-group{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-menu-group{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-menu-group{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-menu-group{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-menu-group,[type=\"radio\"].sc-ic-menu-group{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-menu-group::-webkit-inner-spin-button,[type=\"number\"].sc-ic-menu-group::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-menu-group{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-menu-group::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-menu-group::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-menu-group{display:block}/*!@summary*/summary.sc-ic-menu-group{display:list-item}/*!@template*/template.sc-ic-menu-group{display:none}/*!@[hidden]*/[hidden].sc-ic-menu-group{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-menu-group,body.sc-ic-menu-group,div.sc-ic-menu-group,span.sc-ic-menu-group,applet.sc-ic-menu-group,object.sc-ic-menu-group,iframe.sc-ic-menu-group,h1.sc-ic-menu-group,h2.sc-ic-menu-group,h3.sc-ic-menu-group,h4.sc-ic-menu-group,h5.sc-ic-menu-group,h6.sc-ic-menu-group,p.sc-ic-menu-group,blockquote.sc-ic-menu-group,pre.sc-ic-menu-group,a.sc-ic-menu-group,abbr.sc-ic-menu-group,acronym.sc-ic-menu-group,address.sc-ic-menu-group,big.sc-ic-menu-group,cite.sc-ic-menu-group,code.sc-ic-menu-group,del.sc-ic-menu-group,dfn.sc-ic-menu-group,em.sc-ic-menu-group,img.sc-ic-menu-group,ins.sc-ic-menu-group,kbd.sc-ic-menu-group,q.sc-ic-menu-group,s.sc-ic-menu-group,samp.sc-ic-menu-group,small.sc-ic-menu-group,strike.sc-ic-menu-group,strong.sc-ic-menu-group,sub.sc-ic-menu-group,sup.sc-ic-menu-group,tt.sc-ic-menu-group,var.sc-ic-menu-group,b.sc-ic-menu-group,u.sc-ic-menu-group,i.sc-ic-menu-group,center.sc-ic-menu-group,dl.sc-ic-menu-group,dt.sc-ic-menu-group,dd.sc-ic-menu-group,ol.sc-ic-menu-group,ul.sc-ic-menu-group,li.sc-ic-menu-group,fieldset.sc-ic-menu-group,form.sc-ic-menu-group,label.sc-ic-menu-group,legend.sc-ic-menu-group,table.sc-ic-menu-group,caption.sc-ic-menu-group,tbody.sc-ic-menu-group,tfoot.sc-ic-menu-group,thead.sc-ic-menu-group,tr.sc-ic-menu-group,th.sc-ic-menu-group,td.sc-ic-menu-group,article.sc-ic-menu-group,aside.sc-ic-menu-group,canvas.sc-ic-menu-group,details.sc-ic-menu-group,embed.sc-ic-menu-group,figure.sc-ic-menu-group,figcaption.sc-ic-menu-group,footer.sc-ic-menu-group,header.sc-ic-menu-group,hgroup.sc-ic-menu-group,menu.sc-ic-menu-group,nav.sc-ic-menu-group,output.sc-ic-menu-group,ruby.sc-ic-menu-group,section.sc-ic-menu-group,summary.sc-ic-menu-group,time.sc-ic-menu-group,mark.sc-ic-menu-group,audio.sc-ic-menu-group,video.sc-ic-menu-group{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-menu-group-h{display:flex;flex-direction:column}/*!@ic-typography*/ic-typography.sc-ic-menu-group{color:var(--ic-color-tertiary-text);margin:var(--ic-space-xs) var(--ic-space-xs) 0}/*!@ul*/ul.sc-ic-menu-group{list-style-type:none;margin:0;padding:0}/*!@hr*/hr.sc-ic-menu-group{display:flex;align-self:stretch;border:calc(var(--ic-space-xxxs) / 2) solid var(--ic-architectural-300);margin:var(--ic-space-xxs) 0 calc(var(--ic-space-sm) / 4)}";

class MenuGroup {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.label = undefined;
    }
    render() {
        const parentMenu = this.el.closest("ic-popover-menu");
        return (hAsync(Host, { "aria-label": this.label !== null ? this.label : "" }, isPropDefined(this.label) && (hAsync("ic-typography", { variant: "subtitle-small" }, this.label)), hAsync("ul", { role: "group" }, hAsync("slot", null)), this.el !== (parentMenu === null || parentMenu === void 0 ? void 0 : parentMenu.querySelector("ic-menu-group:last-child")) && (hAsync("hr", null))));
    }
    get el() { return getElement(this); }
    static get style() { return icMenuGroupCss; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ic-menu-group",
        "$members$": {
            "label": [1]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icMenuItemCss = "/*!@html*/html.sc-ic-menu-item{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-menu-item{margin:0}/*!@main*/main.sc-ic-menu-item{display:block}/*!@h1*/h1.sc-ic-menu-item{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-menu-item{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-menu-item{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-menu-item{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-menu-item{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-menu-item,strong.sc-ic-menu-item{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-menu-item,kbd.sc-ic-menu-item,samp.sc-ic-menu-item{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-menu-item{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-menu-item,sup.sc-ic-menu-item{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-menu-item{bottom:-0.25em}/*!@sup*/sup.sc-ic-menu-item{top:-0.5em}/*!@img*/img.sc-ic-menu-item{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-menu-item,input.sc-ic-menu-item,optgroup.sc-ic-menu-item,select.sc-ic-menu-item,textarea.sc-ic-menu-item{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-menu-item,input.sc-ic-menu-item{overflow:visible}/*!@button,\nselect*/button.sc-ic-menu-item,select.sc-ic-menu-item{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-menu-item,[type=\"button\"].sc-ic-menu-item,[type=\"reset\"].sc-ic-menu-item,[type=\"submit\"].sc-ic-menu-item{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-menu-item::-moz-focus-inner,[type=\"button\"].sc-ic-menu-item::-moz-focus-inner,[type=\"reset\"].sc-ic-menu-item::-moz-focus-inner,[type=\"submit\"].sc-ic-menu-item::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-menu-item:-moz-focusring,[type=\"button\"].sc-ic-menu-item:-moz-focusring,[type=\"reset\"].sc-ic-menu-item:-moz-focusring,[type=\"submit\"].sc-ic-menu-item:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-menu-item{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-menu-item{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-menu-item{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-menu-item{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-menu-item,[type=\"radio\"].sc-ic-menu-item{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-menu-item::-webkit-inner-spin-button,[type=\"number\"].sc-ic-menu-item::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-menu-item{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-menu-item::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-menu-item::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-menu-item{display:block}/*!@summary*/summary.sc-ic-menu-item{display:list-item}/*!@template*/template.sc-ic-menu-item{display:none}/*!@[hidden]*/[hidden].sc-ic-menu-item{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-menu-item,body.sc-ic-menu-item,div.sc-ic-menu-item,span.sc-ic-menu-item,applet.sc-ic-menu-item,object.sc-ic-menu-item,iframe.sc-ic-menu-item,h1.sc-ic-menu-item,h2.sc-ic-menu-item,h3.sc-ic-menu-item,h4.sc-ic-menu-item,h5.sc-ic-menu-item,h6.sc-ic-menu-item,p.sc-ic-menu-item,blockquote.sc-ic-menu-item,pre.sc-ic-menu-item,a.sc-ic-menu-item,abbr.sc-ic-menu-item,acronym.sc-ic-menu-item,address.sc-ic-menu-item,big.sc-ic-menu-item,cite.sc-ic-menu-item,code.sc-ic-menu-item,del.sc-ic-menu-item,dfn.sc-ic-menu-item,em.sc-ic-menu-item,img.sc-ic-menu-item,ins.sc-ic-menu-item,kbd.sc-ic-menu-item,q.sc-ic-menu-item,s.sc-ic-menu-item,samp.sc-ic-menu-item,small.sc-ic-menu-item,strike.sc-ic-menu-item,strong.sc-ic-menu-item,sub.sc-ic-menu-item,sup.sc-ic-menu-item,tt.sc-ic-menu-item,var.sc-ic-menu-item,b.sc-ic-menu-item,u.sc-ic-menu-item,i.sc-ic-menu-item,center.sc-ic-menu-item,dl.sc-ic-menu-item,dt.sc-ic-menu-item,dd.sc-ic-menu-item,ol.sc-ic-menu-item,ul.sc-ic-menu-item,li.sc-ic-menu-item,fieldset.sc-ic-menu-item,form.sc-ic-menu-item,label.sc-ic-menu-item,legend.sc-ic-menu-item,table.sc-ic-menu-item,caption.sc-ic-menu-item,tbody.sc-ic-menu-item,tfoot.sc-ic-menu-item,thead.sc-ic-menu-item,tr.sc-ic-menu-item,th.sc-ic-menu-item,td.sc-ic-menu-item,article.sc-ic-menu-item,aside.sc-ic-menu-item,canvas.sc-ic-menu-item,details.sc-ic-menu-item,embed.sc-ic-menu-item,figure.sc-ic-menu-item,figcaption.sc-ic-menu-item,footer.sc-ic-menu-item,header.sc-ic-menu-item,hgroup.sc-ic-menu-item,menu.sc-ic-menu-item,nav.sc-ic-menu-item,output.sc-ic-menu-item,ruby.sc-ic-menu-item,section.sc-ic-menu-item,summary.sc-ic-menu-item,time.sc-ic-menu-item,mark.sc-ic-menu-item,audio.sc-ic-menu-item,video.sc-ic-menu-item{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@li*/li.sc-ic-menu-item{list-style:none;padding:0}/*!@:host ::part(button)*/.sc-ic-menu-item-h .sc-ic-menu-item::part(button){color:var(--ic-color-primary-text);padding:calc(var(--ic-space-xxxs) / 2);display:flex;align-items:flex-start;gap:var(--ic-space-xs);border-radius:0;min-height:2.5rem;height:auto}/*!@.focus-border*/.focus-border.sc-ic-menu-item{display:flex;align-items:flex-start;gap:var(--ic-space-xs);border-radius:var(--ic-border-radius);margin:calc(var(--ic-space-xxxs) / 2);padding:var(--ic-space-xxs);border:var(--ic-space-xxxs) dashed transparent;--icon-height:auto}/*!@:host(.disabled) ::part(button)*/.disabled.sc-ic-menu-item-h .sc-ic-menu-item::part(button){color:var(--ic-architectural-200) !important;pointer-events:none}/*!@:host(.disabled) .menu-item-label,\n:host(.disabled) .shortcut,\n:host(.disabled) .menu-item-description*/.disabled.sc-ic-menu-item-h .menu-item-label.sc-ic-menu-item,.disabled.sc-ic-menu-item-h .shortcut.sc-ic-menu-item,.disabled.sc-ic-menu-item-h .menu-item-description.sc-ic-menu-item{color:var(--ic-architectural-200) !important}/*!@:host([variant=\"destructive\"]) ::part(button)*/[variant=\"destructive\"].sc-ic-menu-item-h .sc-ic-menu-item::part(button){color:var(--ic-action-destructive)}/*!@:host ::part(button):hover*/.sc-ic-menu-item-h .sc-ic-menu-item::part(button):hover{background-color:var(--ic-action-dark-bg-hover)}/*!@:host ::part(button):focus-visible,\n:host ::part(button):focus*/.sc-ic-menu-item-h .sc-ic-menu-item::part(button):focus-visible,.sc-ic-menu-item-h .sc-ic-menu-item::part(button):focus{color:var(--ic-color-white-text);background-color:var(--ic-focus-blue);box-shadow:none}/*!@:host(.disabled) ::part(button):focus-visible,\n:host(.disabled) ::part(button):focus*/.disabled.sc-ic-menu-item-h .sc-ic-menu-item::part(button):focus-visible,.disabled.sc-ic-menu-item-h .sc-ic-menu-item::part(button):focus{color:var(--ic-theme-lighten-40) !important}/*!@:host([variant=\"destructive\"]) ::part(button):focus-visible,\n:host([variant=\"destructive\"]) ::part(button):focus*/[variant=\"destructive\"].sc-ic-menu-item-h .sc-ic-menu-item::part(button):focus-visible,[variant=\"destructive\"].sc-ic-menu-item-h .sc-ic-menu-item::part(button):focus{background-color:var(--ic-action-destructive)}/*!@ic-button:focus-within .menu-item-label,\nic-button:focus-within .shortcut,\nic-button:focus-within .menu-item-description*/ic-button.sc-ic-menu-item:focus-within .menu-item-label.sc-ic-menu-item,ic-button.sc-ic-menu-item:focus-within .shortcut.sc-ic-menu-item,ic-button.sc-ic-menu-item:focus-within .menu-item-description.sc-ic-menu-item{color:var(--ic-color-white-text)}/*!@:host(.disabled) ic-button:focus-within .focus-border*/.disabled.sc-ic-menu-item-h ic-button.sc-ic-menu-item:focus-within .focus-border.sc-ic-menu-item{border-color:var(--ic-architectural-white)}/*!@:host(.disabled) ic-button:focus-within .menu-item-label,\n:host(.disabled) ic-button:focus-within .shortcut,\n:host(.disabled) ic-button:focus-within .menu-item-description*/.disabled.sc-ic-menu-item-h ic-button.sc-ic-menu-item:focus-within .menu-item-label.sc-ic-menu-item,.disabled.sc-ic-menu-item-h ic-button.sc-ic-menu-item:focus-within .shortcut.sc-ic-menu-item,.disabled.sc-ic-menu-item-h ic-button.sc-ic-menu-item:focus-within .menu-item-description.sc-ic-menu-item{color:var(--ic-theme-lighten-40) !important}/*!@:host ::part(button):active*/.sc-ic-menu-item-h .sc-ic-menu-item::part(button):active{background-color:var(--ic-action-dark-bg-active);color:var(--ic-color-primary-text) !important}/*!@:host([variant=\"destructive\"]) ::part(button):active*/[variant=\"destructive\"].sc-ic-menu-item-h .sc-ic-menu-item::part(button):active{background-color:var(--ic-action-dark-bg-active);color:var(--ic-action-destructive) !important}/*!@.menu-item-info*/.menu-item-info.sc-ic-menu-item{display:flex;flex-direction:column;flex:1;align-items:baseline;white-space:pre-line;text-align:left}/*!@.menu-labels*/.menu-labels.sc-ic-menu-item{display:flex;align-items:baseline;gap:var(--ic-space-xs)}/*!@.menu-item-description*/.menu-item-description.sc-ic-menu-item{color:var(--ic-color-secondary-text)}/*!@.shortcut*/.shortcut.sc-ic-menu-item{color:var(--ic-color-tertiary-text);display:flex;flex:min-content}/*!@:host([variant=\"destructive\"]) .menu-item-label*/[variant=\"destructive\"].sc-ic-menu-item-h .menu-item-label.sc-ic-menu-item{text-transform:uppercase;font-weight:600;letter-spacing:0.025em}/*!@ic-button:active .menu-item-label*/ic-button.sc-ic-menu-item:active .menu-item-label.sc-ic-menu-item{color:var(--ic-color-primary-text)}/*!@ic-button:active .menu-item-description*/ic-button.sc-ic-menu-item:active .menu-item-description.sc-ic-menu-item{color:var(--ic-color-secondary-text)}/*!@ic-button:active .shortcut*/ic-button.sc-ic-menu-item:active .shortcut.sc-ic-menu-item{color:var(--ic-color-tertiary-text)}/*!@:host([variant=\"destructive\"]) ic-button:active .menu-item-label*/[variant=\"destructive\"].sc-ic-menu-item-h ic-button.sc-ic-menu-item:active .menu-item-label.sc-ic-menu-item{color:var(--ic-action-destructive) !important}/*!@.icon,\n.check-icon,\n.submenu-icon,\n.icon ::slotted(svg),\n.check-icon svg,\n.submenu-icon svg*/.icon.sc-ic-menu-item,.check-icon.sc-ic-menu-item,.submenu-icon.sc-ic-menu-item,.icon.sc-ic-menu-item-s>svg,.icon .sc-ic-menu-item-s>svg,.check-icon.sc-ic-menu-item svg.sc-ic-menu-item,.submenu-icon.sc-ic-menu-item svg.sc-ic-menu-item{width:var(--ic-space-lg);height:var(--ic-space-lg)}/*!@.check-icon.hide*/.check-icon.hide.sc-ic-menu-item{visibility:hidden}@media (forced-colors: active){/*!@:host ::part(button)*/.sc-ic-menu-item-h .sc-ic-menu-item::part(button){border:canvas}/*!@:host ::part(button):focus-visible*/.sc-ic-menu-item-h .sc-ic-menu-item::part(button):focus-visible{outline:var(--ic-space-xxxs) solid transparent}/*!@.focus-border*/.focus-border.sc-ic-menu-item{border-color:canvas}/*!@:host(.disabled) ic-button:focus-within .focus-border*/.disabled.sc-ic-menu-item-h ic-button.sc-ic-menu-item:focus-within .focus-border.sc-ic-menu-item{border-color:GrayText}/*!@:host(.disabled) .menu-item-info,\n  :host(.disabled) .menu-item-label,\n  :host(.disabled) .shortcut,\n  :host(.disabled) .menu-item-description,\n  :host(.disabled) ic-button:focus-within .menu-item-info,\n  :host(.disabled) ic-button:focus-within .menu-item-label,\n  :host(.disabled) ic-button:focus-within .shortcut,\n  :host(.disabled) ic-button:focus-within .menu-item-description*/.disabled.sc-ic-menu-item-h .menu-item-info.sc-ic-menu-item,.disabled.sc-ic-menu-item-h .menu-item-label.sc-ic-menu-item,.disabled.sc-ic-menu-item-h .shortcut.sc-ic-menu-item,.disabled.sc-ic-menu-item-h .menu-item-description.sc-ic-menu-item,.disabled.sc-ic-menu-item-h ic-button.sc-ic-menu-item:focus-within .menu-item-info.sc-ic-menu-item,.disabled.sc-ic-menu-item-h ic-button.sc-ic-menu-item:focus-within .menu-item-label.sc-ic-menu-item,.disabled.sc-ic-menu-item-h ic-button.sc-ic-menu-item:focus-within .shortcut.sc-ic-menu-item,.disabled.sc-ic-menu-item-h ic-button.sc-ic-menu-item:focus-within .menu-item-description.sc-ic-menu-item{color:GrayText !important}/*!@:host(.disabled) ::part(button):focus-visible,\n  :host(.disabled) ::part(button):focus*/.disabled.sc-ic-menu-item-h .sc-ic-menu-item::part(button):focus-visible,.disabled.sc-ic-menu-item-h .sc-ic-menu-item::part(button):focus{outline-color:GrayText !important}}";

/**
 * @slot icon - Content will be placed to the left of the menu item label.
 */
class MenuItem {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.childBlur = createEvent(this, "childBlur", 7);
        this.handleMenuItemClick = createEvent(this, "handleMenuItemClick", 7);
        this.triggerPopoverMenuInstance = createEvent(this, "triggerPopoverMenuInstance", 7);
        this.handleClick = (e) => {
            if (isPropDefined(this.submenuTriggerFor)) {
                this.triggerPopoverMenuInstance.emit();
            }
            else if (this.variant === "toggle") {
                e.preventDefault();
                this.toggleChecked = !this.toggleChecked;
            }
            this.handleMenuItemClick.emit({
                label: this.label,
                hasSubMenu: !!this.el.submenuTriggerFor,
            });
        };
        this.getMenuItemAriaLabel = () => {
            let ariaLabel = this.label;
            if (isPropDefined(this.description)) {
                ariaLabel = `${ariaLabel}, ${this.description}`;
            }
            if (isPropDefined(this.keyboardShortcut)) {
                ariaLabel = `${ariaLabel}, ${this.keyboardShortcut}`;
            }
            if (this.variant === "destructive") {
                ariaLabel = `${ariaLabel}, destructive`;
            }
            if (isPropDefined(this.submenuTriggerFor)) {
                ariaLabel = `${ariaLabel}, triggers submenu`;
            }
            if (this.el.classList.contains("ic-popover-submenu-back-button")) {
                ariaLabel = "Go back to parent menu";
            }
            const parentEl = this.el.parentElement;
            if (parentEl.tagName === "IC-MENU-GROUP" &&
                parentEl.label) {
                return `${ariaLabel}, ${parentEl.label} menu group`;
            }
            else {
                return ariaLabel;
            }
        };
        this.toggleChecked = false;
        this.description = undefined;
        this.disabled = false;
        this.href = undefined;
        this.hreflang = undefined;
        this.keyboardShortcut = undefined;
        this.label = undefined;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.submenuTriggerFor = undefined;
        this.target = undefined;
        this.variant = "default";
    }
    componentWillLoad() {
        // This ensures that trigger menu items are always set to the default variant
        if (isPropDefined(this.submenuTriggerFor) && this.variant !== "default") {
            this.variant = "default";
        }
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Menu Item");
    }
    handleHostClick(e) {
        if (this.disabled) {
            e.stopImmediatePropagation();
        }
    }
    render() {
        // A sub-component to layout the menu information correctly in ic-button
        const MenuItemInformation = () => {
            return (hAsync("div", { class: "menu-item-info" }, hAsync("div", { class: "menu-labels" }, hAsync("ic-typography", { class: "menu-item-label" }, this.label), this.keyboardShortcut && (hAsync("ic-typography", { variant: "caption", class: "shortcut" }, this.keyboardShortcut))), this.description && (hAsync("ic-typography", { class: "menu-item-description", variant: "caption" }, this.description))));
        };
        return (hAsync(Host, { class: {
                ["disabled"]: this.disabled,
            } }, hAsync("li", { role: this.variant === "toggle" ? "menuitemcheckbox" : "menuitem", "aria-disabled": `${this.disabled}`, "aria-checked": this.variant === "toggle" ? this.toggleChecked : undefined }, hAsync("ic-button", { fullWidth: true, variant: "tertiary", onClick: this.handleClick, href: isPropDefined(this.href), hreflang: isPropDefined(this.hreflang), target: isPropDefined(this.target), rel: isPropDefined(this.rel), referrerpolicy: this.referrerpolicy !== undefined ? this.referrerpolicy : null, "aria-disabled": `${this.disabled}`, "aria-label": this.getMenuItemAriaLabel(), ariaControlsId: isPropDefined(this.submenuTriggerFor)
                ? `ic-popover-submenu-${this.submenuTriggerFor}`
                : false, "aria-haspopup": isPropDefined(this.submenuTriggerFor) ||
                this.el.classList.contains("ic-popover-submenu-back-button")
                ? "menu"
                : false, ariaOwnsId: isPropDefined(this.submenuTriggerFor)
                ? `ic-popover-submenu-${this.submenuTriggerFor}`
                : false }, hAsync("div", { class: "focus-border" }, isSlotUsed(this.el, "icon") && (hAsync("span", { class: "icon" }, hAsync("slot", { name: "icon" }))), hAsync(MenuItemInformation, null), this.variant === "toggle" && (hAsync("span", { class: {
                ["check-icon"]: true,
                ["hide"]: !this.toggleChecked,
            }, "aria-hidden": "true", innerHTML: checkIcon })), isPropDefined(this.submenuTriggerFor) && (hAsync("span", { class: { ["submenu-icon"]: true }, "aria-hidden": "true", innerHTML: chevronIcon })))))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get style() { return icMenuItemCss; }
    static get cmpMeta() { return {
        "$flags$": 25,
        "$tagName$": "ic-menu-item",
        "$members$": {
            "description": [1],
            "disabled": [4],
            "href": [1],
            "hreflang": [1],
            "keyboardShortcut": [1, "keyboard-shortcut"],
            "label": [1],
            "referrerpolicy": [1],
            "rel": [1],
            "submenuTriggerFor": [1, "submenu-trigger-for"],
            "target": [1],
            "variant": [1537],
            "toggleChecked": [32]
        },
        "$listeners$": [[2, "click", "handleHostClick"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": [["variant", "variant"]]
    }; }
}

const icNavigationButtonCss = "/*!@html*/html.sc-ic-navigation-button{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-navigation-button{margin:0}/*!@main*/main.sc-ic-navigation-button{display:block}/*!@h1*/h1.sc-ic-navigation-button{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-navigation-button{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-navigation-button{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-navigation-button{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-navigation-button{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-navigation-button,strong.sc-ic-navigation-button{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-navigation-button,kbd.sc-ic-navigation-button,samp.sc-ic-navigation-button{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-navigation-button{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-navigation-button,sup.sc-ic-navigation-button{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-navigation-button{bottom:-0.25em}/*!@sup*/sup.sc-ic-navigation-button{top:-0.5em}/*!@img*/img.sc-ic-navigation-button{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-navigation-button,input.sc-ic-navigation-button,optgroup.sc-ic-navigation-button,select.sc-ic-navigation-button,textarea.sc-ic-navigation-button{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-navigation-button,input.sc-ic-navigation-button{overflow:visible}/*!@button,\nselect*/button.sc-ic-navigation-button,select.sc-ic-navigation-button{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-navigation-button,[type=\"button\"].sc-ic-navigation-button,[type=\"reset\"].sc-ic-navigation-button,[type=\"submit\"].sc-ic-navigation-button{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-navigation-button::-moz-focus-inner,[type=\"button\"].sc-ic-navigation-button::-moz-focus-inner,[type=\"reset\"].sc-ic-navigation-button::-moz-focus-inner,[type=\"submit\"].sc-ic-navigation-button::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-navigation-button:-moz-focusring,[type=\"button\"].sc-ic-navigation-button:-moz-focusring,[type=\"reset\"].sc-ic-navigation-button:-moz-focusring,[type=\"submit\"].sc-ic-navigation-button:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-navigation-button{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-navigation-button{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-navigation-button{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-navigation-button{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-navigation-button,[type=\"radio\"].sc-ic-navigation-button{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-navigation-button::-webkit-inner-spin-button,[type=\"number\"].sc-ic-navigation-button::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-navigation-button{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-navigation-button::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-navigation-button::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-navigation-button{display:block}/*!@summary*/summary.sc-ic-navigation-button{display:list-item}/*!@template*/template.sc-ic-navigation-button{display:none}/*!@[hidden]*/[hidden].sc-ic-navigation-button{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-navigation-button,body.sc-ic-navigation-button,div.sc-ic-navigation-button,span.sc-ic-navigation-button,applet.sc-ic-navigation-button,object.sc-ic-navigation-button,iframe.sc-ic-navigation-button,h1.sc-ic-navigation-button,h2.sc-ic-navigation-button,h3.sc-ic-navigation-button,h4.sc-ic-navigation-button,h5.sc-ic-navigation-button,h6.sc-ic-navigation-button,p.sc-ic-navigation-button,blockquote.sc-ic-navigation-button,pre.sc-ic-navigation-button,a.sc-ic-navigation-button,abbr.sc-ic-navigation-button,acronym.sc-ic-navigation-button,address.sc-ic-navigation-button,big.sc-ic-navigation-button,cite.sc-ic-navigation-button,code.sc-ic-navigation-button,del.sc-ic-navigation-button,dfn.sc-ic-navigation-button,em.sc-ic-navigation-button,img.sc-ic-navigation-button,ins.sc-ic-navigation-button,kbd.sc-ic-navigation-button,q.sc-ic-navigation-button,s.sc-ic-navigation-button,samp.sc-ic-navigation-button,small.sc-ic-navigation-button,strike.sc-ic-navigation-button,strong.sc-ic-navigation-button,sub.sc-ic-navigation-button,sup.sc-ic-navigation-button,tt.sc-ic-navigation-button,var.sc-ic-navigation-button,b.sc-ic-navigation-button,u.sc-ic-navigation-button,i.sc-ic-navigation-button,center.sc-ic-navigation-button,dl.sc-ic-navigation-button,dt.sc-ic-navigation-button,dd.sc-ic-navigation-button,ol.sc-ic-navigation-button,ul.sc-ic-navigation-button,li.sc-ic-navigation-button,fieldset.sc-ic-navigation-button,form.sc-ic-navigation-button,label.sc-ic-navigation-button,legend.sc-ic-navigation-button,table.sc-ic-navigation-button,caption.sc-ic-navigation-button,tbody.sc-ic-navigation-button,tfoot.sc-ic-navigation-button,thead.sc-ic-navigation-button,tr.sc-ic-navigation-button,th.sc-ic-navigation-button,td.sc-ic-navigation-button,article.sc-ic-navigation-button,aside.sc-ic-navigation-button,canvas.sc-ic-navigation-button,details.sc-ic-navigation-button,embed.sc-ic-navigation-button,figure.sc-ic-navigation-button,figcaption.sc-ic-navigation-button,footer.sc-ic-navigation-button,header.sc-ic-navigation-button,hgroup.sc-ic-navigation-button,menu.sc-ic-navigation-button,nav.sc-ic-navigation-button,output.sc-ic-navigation-button,ruby.sc-ic-navigation-button,section.sc-ic-navigation-button,summary.sc-ic-navigation-button,time.sc-ic-navigation-button,mark.sc-ic-navigation-button,audio.sc-ic-navigation-button,video.sc-ic-navigation-button{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}/*!@:host*/.sc-ic-navigation-button-h{display:block;margin-right:var(--ic-space-xs);list-style:none}/*!@:host(.in-side-menu)*/.in-side-menu.sc-ic-navigation-button-h{margin-right:0}/*!@:host::part(button)*/.sc-ic-navigation-button-h::part(button){height:100%;min-height:2.5rem}";

const MUTABLE_ATTRIBUTES$2 = [...IC_INHERITED_ARIA, "title"];
/**
 * @slot icon - Content will be placed to the left of the button label.
 * @slot badge - Badge component overlaying the top right of the button.
 */
class NavigationButton {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.inheritedAttributes = {};
        this.hostMutationObserver = null;
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            mutationList.forEach(({ attributeName }) => {
                if (MUTABLE_ATTRIBUTES$2.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] =
                        this.el.getAttribute(attributeName);
                }
            });
        };
        this.initialAppearance = getThemeForegroundColor();
        this.mode = "navbar";
        this.download = false;
        this.href = undefined;
        this.hreflang = undefined;
        this.label = undefined;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.target = undefined;
    }
    componentWillLoad() {
        this.inheritedAttributes = inheritAttributes(this.el, MUTABLE_ATTRIBUTES$2);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Navigation Button");
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            attributes: true,
        });
    }
    componentWillRender() {
        const iconEl = this.el.querySelector(`[slot="icon"]`);
        iconEl !== null && iconEl.setAttribute("viewBox", "0 0 24 24");
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    navBarMenuOpenHandler() {
        this.mode = "menu";
    }
    navBarMenuCloseHandler() {
        this.mode = "navbar";
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.initialAppearance = theme.mode;
    }
    /**
     * Sets focus on the native `button`.
     */
    async setFocus() {
        if (this.buttonEl) {
            this.buttonEl.focus();
        }
    }
    render() {
        const { href, target, rel, download, referrerpolicy } = this;
        let label = "";
        let className = "";
        let variant = "icon";
        let appearance = this.initialAppearance;
        let size = "large";
        let fullWidth = false;
        let disableTooltip = false;
        if (this.mode === "menu") {
            label = this.label;
            variant = "tertiary";
            appearance = IcThemeForegroundEnum.Default;
            size = "default";
            fullWidth = true;
            className = "popout-menu-button";
            disableTooltip = true;
        }
        const buttonProps = {
            variant,
            appearance,
            size,
            href,
            target,
            rel,
            download,
            referrerpolicy,
            fullWidth,
            disableTooltip,
        };
        return (hAsync(Host, { class: { ["in-side-menu"]: this.mode === "menu" } }, hAsync("ic-button", Object.assign({ class: className, "aria-label": variant == "icon" ? this.label : null, ref: (el) => (this.buttonEl = el) }, buttonProps, this.inheritedAttributes), label, hAsync("slot", { slot: "left-icon", name: "icon" }), isSlotUsed(this.el, "badge") && variant === "icon" && (hAsync("slot", { name: "badge" })))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get style() { return icNavigationButtonCss; }
    static get cmpMeta() { return {
        "$flags$": 25,
        "$tagName$": "ic-navigation-button",
        "$members$": {
            "download": [8],
            "href": [1],
            "hreflang": [1],
            "label": [1],
            "referrerpolicy": [1],
            "rel": [1],
            "target": [1],
            "initialAppearance": [32],
            "mode": [32],
            "setFocus": [64]
        },
        "$listeners$": [[4, "icNavigationMenuOpened", "navBarMenuOpenHandler"], [4, "icNavigationMenuClosed", "navBarMenuCloseHandler"], [4, "themeChange", "themeChangeHandler"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const icNavigationGroupCss = "/*!@html*/html.sc-ic-navigation-group{line-height:1.15;-webkit-text-size-adjust:100%}/*!@body*/body.sc-ic-navigation-group{margin:0}/*!@main*/main.sc-ic-navigation-group{display:block}/*!@h1*/h1.sc-ic-navigation-group{font-size:2em;margin:0.67em 0}/*!@hr*/hr.sc-ic-navigation-group{box-sizing:content-box;height:0;overflow:visible}/*!@pre*/pre.sc-ic-navigation-group{font-family:monospace, monospace;font-size:1em}/*!@a*/a.sc-ic-navigation-group{background-color:transparent}/*!@abbr[title]*/abbr[title].sc-ic-navigation-group{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}/*!@b,\nstrong*/b.sc-ic-navigation-group,strong.sc-ic-navigation-group{font-weight:bolder}/*!@code,\nkbd,\nsamp*/code.sc-ic-navigation-group,kbd.sc-ic-navigation-group,samp.sc-ic-navigation-group{font-family:monospace, monospace;font-size:1em}/*!@small*/small.sc-ic-navigation-group{font-size:80%}/*!@sub,\nsup*/sub.sc-ic-navigation-group,sup.sc-ic-navigation-group{font-size:75%;line-height:0;position:relative;vertical-align:baseline}/*!@sub*/sub.sc-ic-navigation-group{bottom:-0.25em}/*!@sup*/sup.sc-ic-navigation-group{top:-0.5em}/*!@img*/img.sc-ic-navigation-group{border-style:none}/*!@button,\ninput,\noptgroup,\nselect,\ntextarea*/button.sc-ic-navigation-group,input.sc-ic-navigation-group,optgroup.sc-ic-navigation-group,select.sc-ic-navigation-group,textarea.sc-ic-navigation-group{font-family:inherit;font-size:100%;line-height:1.15;margin:0}/*!@button,\ninput*/button.sc-ic-navigation-group,input.sc-ic-navigation-group{overflow:visible}/*!@button,\nselect*/button.sc-ic-navigation-group,select.sc-ic-navigation-group{text-transform:none}/*!@button,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"]*/button.sc-ic-navigation-group,[type=\"button\"].sc-ic-navigation-group,[type=\"reset\"].sc-ic-navigation-group,[type=\"submit\"].sc-ic-navigation-group{-webkit-appearance:button}/*!@button::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner*/button.sc-ic-navigation-group::-moz-focus-inner,[type=\"button\"].sc-ic-navigation-group::-moz-focus-inner,[type=\"reset\"].sc-ic-navigation-group::-moz-focus-inner,[type=\"submit\"].sc-ic-navigation-group::-moz-focus-inner{border-style:none;padding:0}/*!@button:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring*/button.sc-ic-navigation-group:-moz-focusring,[type=\"button\"].sc-ic-navigation-group:-moz-focusring,[type=\"reset\"].sc-ic-navigation-group:-moz-focusring,[type=\"submit\"].sc-ic-navigation-group:-moz-focusring{outline:1px dotted ButtonText}/*!@fieldset*/fieldset.sc-ic-navigation-group{padding:0.35em 0.75em 0.625em}/*!@legend*/legend.sc-ic-navigation-group{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}/*!@progress*/progress.sc-ic-navigation-group{vertical-align:baseline}/*!@textarea*/textarea.sc-ic-navigation-group{overflow:auto}/*!@[type=\"checkbox\"],\n[type=\"radio\"]*/[type=\"checkbox\"].sc-ic-navigation-group,[type=\"radio\"].sc-ic-navigation-group{box-sizing:border-box;padding:0}/*!@[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button*/[type=\"number\"].sc-ic-navigation-group::-webkit-inner-spin-button,[type=\"number\"].sc-ic-navigation-group::-webkit-outer-spin-button{height:auto}/*!@[type=\"search\"]*/[type=\"search\"].sc-ic-navigation-group{-webkit-appearance:textfield;outline-offset:-2px}/*!@[type=\"search\"]::-webkit-search-decoration*/[type=\"search\"].sc-ic-navigation-group::-webkit-search-decoration{-webkit-appearance:none}/*!@::-webkit-file-upload-button*/.sc-ic-navigation-group::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}/*!@details*/details.sc-ic-navigation-group{display:block}/*!@summary*/summary.sc-ic-navigation-group{display:list-item}/*!@template*/template.sc-ic-navigation-group{display:none}/*!@[hidden]*/[hidden].sc-ic-navigation-group{display:none}/*!@html,\nbody,\ndiv,\nspan,\napplet,\nobject,\niframe,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\np,\nblockquote,\npre,\na,\nabbr,\nacronym,\naddress,\nbig,\ncite,\ncode,\ndel,\ndfn,\nem,\nimg,\nins,\nkbd,\nq,\ns,\nsamp,\nsmall,\nstrike,\nstrong,\nsub,\nsup,\ntt,\nvar,\nb,\nu,\ni,\ncenter,\ndl,\ndt,\ndd,\nol,\nul,\nli,\nfieldset,\nform,\nlabel,\nlegend,\ntable,\ncaption,\ntbody,\ntfoot,\nthead,\ntr,\nth,\ntd,\narticle,\naside,\ncanvas,\ndetails,\nembed,\nfigure,\nfigcaption,\nfooter,\nheader,\nhgroup,\nmenu,\nnav,\noutput,\nruby,\nsection,\nsummary,\ntime,\nmark,\naudio,\nvideo*/html.sc-ic-navigation-group,body.sc-ic-navigation-group,div.sc-ic-navigation-group,span.sc-ic-navigation-group,applet.sc-ic-navigation-group,object.sc-ic-navigation-group,iframe.sc-ic-navigation-group,h1.sc-ic-navigation-group,h2.sc-ic-navigation-group,h3.sc-ic-navigation-group,h4.sc-ic-navigation-group,h5.sc-ic-navigation-group,h6.sc-ic-navigation-group,p.sc-ic-navigation-group,blockquote.sc-ic-navigation-group,pre.sc-ic-navigation-group,a.sc-ic-navigation-group,abbr.sc-ic-navigation-group,acronym.sc-ic-navigation-group,address.sc-ic-navigation-group,big.sc-ic-navigation-group,cite.sc-ic-navigation-group,code.sc-ic-navigation-group,del.sc-ic-navigation-group,dfn.sc-ic-navigation-group,em.sc-ic-navigation-group,img.sc-ic-navigation-group,ins.sc-ic-navigation-group,kbd.sc-ic-navigation-group,q.sc-ic-navigation-group,s.sc-ic-navigation-group,samp.sc-ic-navigation-group,small.sc-ic-navigation-group,strike.sc-ic-navigation-group,strong.sc-ic-navigation-group,sub.sc-ic-navigation-group,sup.sc-ic-navigation-group,tt.sc-ic-navigation-group,var.sc-ic-navigation-group,b.sc-ic-navigation-group,u.sc-ic-navigation-group,i.sc-ic-navigation-group,center.sc-ic-navigation-group,dl.sc-ic-navigation-group,dt.sc-ic-navigation-group,dd.sc-ic-navigation-group,ol.sc-ic-navigation-group,ul.sc-ic-navigation-group,li.sc-ic-navigation-group,fieldset.sc-ic-navigation-group,form.sc-ic-navigation-group,label.sc-ic-navigation-group,legend.sc-ic-navigation-group,table.sc-ic-navigation-group,caption.sc-ic-navigation-group,tbody.sc-ic-navigation-group,tfoot.sc-ic-navigation-group,thead.sc-ic-navigation-group,tr.sc-ic-navigation-group,th.sc-ic-navigation-group,td.sc-ic-navigation-group,article.sc-ic-navigation-group,aside.sc-ic-na