/**
 * Add an event listener to `element` that only fires when the target of the
 * event matches `selector`.
 *
 * @param {Element} element
 * @param {string} eventName
 * @param {string} selector
 * @param {EventListener} handler
 */
export function addEventDelegate(element: Element, eventName: string, selector: string, handler: EventListener): void;
/**
 * Removes all of an element's child nodes.
 *
 * @param {Element} element
 */
export function clearChildren(element: Element): void;
/**
 * Deserialize an HTML string into a document fragment.
 *
 * @param {string} htmlString
 * @return {Document}
 */
export function deserialize(htmlString: string): Document;
/**
 * Parse the text content of the element picked out by the given selector as
 * JSON data, returning it as an object.
 *
 * @param {string} selector
 *   A CSS selector for picking out the HTML element that contains the JSON data
 *   to load.
 * @param {Document} [scope]
 *   The DOM tree to run the selector over.
 * @return {object}
 *   The JSON data converted to an object, or `null` if no data could be read.
 */
export function parseJsonFromElement(selector: string, scope?: Document): object;
/**
 * Serialize a document or document fragment into an HTML string.
 *
 * @param {Document|DocumentFragment} documentOrFragment
 * @return {string}
 */
export function serialize(documentOrFragment: Document | DocumentFragment): string;
