/* 
 * Copyright 2017, Emanuel Rabina (http://www.ultraq.net.nz/)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Escapes special HTML characters in a string with their entity code
 * equivalents.
 * 
 * @param {String} string
 * @return {String}
 *   HTML escaped string, safe for use in HTML.
 */
export function escapeHtml(string) {

  return typeof string !== 'string' ? string : string.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#039;');
}

/**
 * Returns the replacement of each placeholder in a template string with a
 * corresponding replacement value.
 * 
 * @param {String} template
 * @param {...String} values
 *   Argument list of values or a single array of values.
 * @return {String}
 *   Replaced template string.
 */
export function format(template) {
  for (var _len = arguments.length, values = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    values[_key - 1] = arguments[_key];
  }

  return template.replace(/\{(\d+)\}/g, function (match, index) {
    return values[+index] + '';
  });
}

//# sourceMappingURL=string-utils.es.js.map