export const __esModule: boolean;
/**
 * Escapes special HTML characters in a string with their entity code
 * equivalents.
 *
 * @param {string} string
 * @return {string}
 *   HTML escaped string, safe for use in HTML.
 */
export function escapeHtml(string: string): string;
/**
 * Returns the replacement of each placeholder in a template string with a
 * corresponding replacement value.
 *
 * @param {string} template
 *   String containing indexed (`{0}`, `{1}`, ...) or named (`{value}`,
 *   `{greeting}`, ...) placeholders, but not both.
 * @param {...string|Record<string,string>} values
 *   Either an argument list / array of values to replace values in an indexed
 *   template string, or an object where the keys are the names in a named
 *   template string to replace with their values.
 * @return {string}
 *   Replaced template string.
 */
export function format(template: string, ...values: (string | Record<string, string>)[]): string;
