'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports['default'] = createUncontrollable;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj['default'] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _utils = require('./utils');

var utils = _interopRequireWildcard(_utils);

function createUncontrollable(mixins, set) {

  return uncontrollable;

  function uncontrollable(Component, controlledValues) {
    var methods = arguments.length <= 2 || arguments[2] === undefined ? [] : arguments[2];

    var displayName = Component.displayName || Component.name || 'Component',
        basePropTypes = utils.getType(Component).propTypes,
        propTypes;

    propTypes = utils.uncontrolledPropTypes(controlledValues, basePropTypes, displayName);

    methods = utils.transform(methods, function (obj, method) {
      obj[method] = function () {
        var _refs$inner;

        return (_refs$inner = this.refs.inner)[method].apply(_refs$inner, arguments);
      };
    }, {});

    var component = _react2['default'].createClass(_extends({

      displayName: 'Uncontrolled(' + displayName + ')',

      mixins: mixins,

      propTypes: propTypes

    }, methods, {

      componentWillMount: function componentWillMount() {
        var props = this.props,
            keys = Object.keys(controlledValues);

        this._values = utils.transform(keys, function (values, key) {
          values[key] = props[utils.defaultKey(key)];
        }, {});
      },

      /**
       * If a prop switches from controlled to Uncontrolled
       * reset its value to the defaultValue
       */
      componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
        var _this = this;

        var props = this.props,
            keys = Object.keys(controlledValues);

        keys.forEach(function (key) {
          if (utils.getValue(nextProps, key) === undefined && utils.getValue(props, key) !== undefined) {
            _this._values[key] = nextProps[utils.defaultKey(key)];
          }
        });
      },

      render: function render() {
        var _this2 = this;

        var newProps = {};
        var _props = this.props;
        var valueLink = _props.valueLink;
        var checkedLink = _props.checkedLink;

        var props = _objectWithoutProperties(_props, ['valueLink', 'checkedLink']);

        utils.each(controlledValues, function (handle, propName) {
          var linkPropName = utils.getLinkName(propName),
              prop = _this2.props[propName];

          if (linkPropName && !isProp(_this2.props, propName) && isProp(_this2.props, linkPropName)) {
            prop = _this2.props[linkPropName].value;
          }

          newProps[propName] = prop !== undefined ? prop : _this2._values[propName];

          newProps[handle] = setAndNotify.bind(_this2, propName);
        });

        newProps = _extends({}, props, newProps, { ref: 'inner' });

        return _react2['default'].createElement(Component, newProps);
      }

    }));

    component.ControlledComponent = Component;

    /**
     * useful when wrapping a Component and you want to control
     * everything
     */
    component.deferControlTo = function (newComponent, additions, nextMethods) {
      if (additions === undefined) additions = {};

      return uncontrollable(newComponent, _extends({}, controlledValues, additions), nextMethods);
    };

    return component;

    function setAndNotify(propName, value) {
      var linkName = utils.getLinkName(propName),
          handler = this.props[controlledValues[propName]];

      if (linkName && isProp(this.props, linkName) && !handler) {
        handler = this.props[linkName].requestChange;
      }

      for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        args[_key - 2] = arguments[_key];
      }

      set(this, propName, handler, value, args);
    }

    function isProp(props, prop) {
      return props[prop] !== undefined;
    }
  }
}

module.exports = exports['default'];