import * as _unhead_schema from '@unhead/schema';
import { Head, HeadEntryOptions, ActiveHeadEntry, Title, Base, Meta, MetaFlatInput, Link, Script, Style, Noscript, HtmlAttributes, BodyAttributes, TitleTemplate, Unhead, HeadPlugin, CreateHeadOptions, HeadEntry, HeadTag } from '@unhead/schema';
import { RenderDomHeadOptions } from '@unhead/dom';

interface DedupesTagsPluginOptions {
    dedupeKeys?: string[];
}
declare const DedupesTagsPlugin: (options?: DedupesTagsPluginOptions) => _unhead_schema.HeadPlugin;

declare const SortTagsPlugin: () => _unhead_schema.HeadPlugin;

declare const TitleTemplatePlugin: () => _unhead_schema.HeadPlugin;

declare const DeprecatedTagAttrPlugin: () => _unhead_schema.HeadPlugin;

declare const ProvideTagHashPlugin: () => _unhead_schema.HeadPlugin;

interface TriggerDomPatchingOnUpdatesPluginOptions extends RenderDomHeadOptions {
    delayFn?: (fn: () => void) => void;
}
declare const PatchDomOnEntryUpdatesPlugin: (options?: TriggerDomPatchingOnUpdatesPluginOptions) => _unhead_schema.HeadPlugin;

/**
 * Supports DOM event handlers (i.e `onload`) as functions.
 *
 * When SSR we need to strip out these values. On CSR we
 */
declare const EventHandlersPlugin: () => _unhead_schema.HeadPlugin;

type Arrayable<T> = T | Array<T>;
declare function asArray<T>(value: Arrayable<T>): T[];
declare const HasElementTags: string[];

declare function useHead<T extends Head>(input: T, options?: HeadEntryOptions): ActiveHeadEntry<T> | void;
declare const useTagTitle: (title: Title) => ActiveHeadEntry<any> | void;
declare const useTagBase: (base: Base) => ActiveHeadEntry<any> | void;
declare const useTagMeta: (meta: Arrayable<Meta>) => ActiveHeadEntry<any> | void;
declare const useTagMetaFlat: (meta: MetaFlatInput) => ActiveHeadEntry<any> | void;
declare const useSeoMeta: (meta: MetaFlatInput) => ActiveHeadEntry<any> | void;
declare const useTagLink: (link: Arrayable<Link>) => ActiveHeadEntry<any> | void;
declare const useTagScript: (script: Arrayable<Script>) => ActiveHeadEntry<any> | void;
declare const useTagStyle: (style: Arrayable<Style>) => ActiveHeadEntry<any> | void;
declare const useTagNoscript: (noscript: Arrayable<Noscript>) => ActiveHeadEntry<any> | void;
declare const useHtmlAttrs: (attrs: HtmlAttributes) => ActiveHeadEntry<any> | void;
declare const useBodyAttrs: (attrs: BodyAttributes) => ActiveHeadEntry<any> | void;
declare const useTitleTemplate: (titleTemplate: TitleTemplate) => ActiveHeadEntry<any> | void;

declare function useServerHead<T extends Head>(input: T, options?: HeadEntryOptions): ActiveHeadEntry<T> | void;
declare const useServerTagTitle: (title: Title) => ActiveHeadEntry<any> | void;
declare const useServerTagBase: (base: Base) => ActiveHeadEntry<any> | void;
declare const useServerTagMeta: (meta: Arrayable<Meta>) => ActiveHeadEntry<any> | void;
declare const useServerTagMetaFlat: (meta: MetaFlatInput) => ActiveHeadEntry<any> | void;
declare const useServerTagLink: (link: Arrayable<Link>) => ActiveHeadEntry<any> | void;
declare const useServerTagScript: (script: Arrayable<Script>) => ActiveHeadEntry<any> | void;
declare const useServerTagStyle: (style: Arrayable<Style>) => ActiveHeadEntry<any> | void;
declare const useServerTagNoscript: (noscript: Arrayable<Noscript>) => ActiveHeadEntry<any> | void;
declare const useServerHtmlAttrs: (attrs: HtmlAttributes) => ActiveHeadEntry<any> | void;
declare const useServerBodyAttrs: (attrs: BodyAttributes) => ActiveHeadEntry<any> | void;
declare const useServerTitleTemplate: (titleTemplate: TitleTemplate) => ActiveHeadEntry<any> | void;

declare let activeHead: Unhead<any> | undefined;
declare const setActiveHead: (head: Unhead<any> | undefined) => Unhead<any> | undefined;
declare const getActiveHead: () => Unhead<any> | undefined;

declare const CorePlugins: () => HeadPlugin[];
declare const DOMPlugins: (options?: CreateHeadOptions) => HeadPlugin[];
declare function createHead<T extends {} = Head>(options?: CreateHeadOptions): Unhead<T>;
/**
 * Creates a core instance of unhead. Does not provide a global ctx for composables to work
 * and does not register DOM plugins.
 *
 * @param options
 */
declare function createHeadCore<T extends {} = Head>(options?: CreateHeadOptions): Unhead<T>;

declare function defineHeadPlugin(plugin: HeadPlugin): HeadPlugin;

declare function normaliseEntryTags<T extends {} = Head>(e: HeadEntry<T>): Promise<HeadTag[]>;

declare const composableNames: string[];
declare const unheadComposablesImports: {
    from: string;
    imports: string[];
}[];

export { Arrayable, CorePlugins, DOMPlugins, DedupesTagsPlugin, DedupesTagsPluginOptions, DeprecatedTagAttrPlugin, EventHandlersPlugin, HasElementTags, PatchDomOnEntryUpdatesPlugin, ProvideTagHashPlugin, SortTagsPlugin, TitleTemplatePlugin, activeHead, asArray, composableNames, createHead, createHeadCore, defineHeadPlugin, getActiveHead, normaliseEntryTags, setActiveHead, unheadComposablesImports, useBodyAttrs, useHead, useHtmlAttrs, useSeoMeta, useServerBodyAttrs, useServerHead, useServerHtmlAttrs, useServerTagBase, useServerTagLink, useServerTagMeta, useServerTagMetaFlat, useServerTagNoscript, useServerTagScript, useServerTagStyle, useServerTagTitle, useServerTitleTemplate, useTagBase, useTagLink, useTagMeta, useTagMetaFlat, useTagNoscript, useTagScript, useTagStyle, useTagTitle, useTitleTemplate };
