import * as _unhead_schema from '@unhead/schema';
import { Head, CreateHeadOptions, Unhead, Title as Title$1, TitleTemplate as TitleTemplate$1, EntryAugmentation, Base as Base$1, Link as Link$1, Meta as Meta$1, Style as Style$1, Script as Script$1, Noscript as Noscript$1, DataKeys, SchemaAugmentations, DefinedValueOrEmptyObject, MergeHead, BaseHtmlAttr, MaybeArray, BaseBodyAttr, HeadEntryOptions, MetaFlatInput, ActiveHeadEntry } from '@unhead/schema';
export { ActiveHeadEntry, Head, HeadEntryOptions, HeadTag, MergeHead, Unhead } from '@unhead/schema';
import { ComputedRef, Ref, Plugin } from 'vue';

/**
 * Creates a core instance of unhead. Does not provide a global ctx for composables to work
 * and does not register DOM plugins.
 *
 * @param options
 */
declare function createHeadCore<T extends {} = Head>(options?: CreateHeadOptions): Unhead<T>;

type MaybeReadonlyRef<T> = (() => T) | ComputedRef<T>;
type MaybeComputedRef<T> = T | MaybeReadonlyRef<T> | Ref<T>;
type MaybeComputedRefOrPromise<T> = T | MaybeReadonlyRef<T> | Ref<T> | Promise<T>;
type MaybeComputedRefEntries<T> = MaybeComputedRef<T> | {
    [key in keyof T]?: MaybeComputedRefOrPromise<T[key]>;
};
type Arrayable<T> = T | Array<T>;

interface HtmlAttr extends Omit<BaseHtmlAttr, 'class'> {
    /**
     * The class global attribute is a space-separated list of the case-sensitive classes of the element.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/class
     */
    class?: MaybeArray<MaybeComputedRef<string>> | Record<string, MaybeComputedRef<boolean>>;
}
interface BodyAttr extends Omit<BaseBodyAttr, 'class'> {
    /**
     * The class global attribute is a space-separated list of the case-sensitive classes of the element.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/class
     */
    class?: MaybeArray<MaybeComputedRef<string>> | Record<string, MaybeComputedRef<boolean>>;
}
type Title = MaybeComputedRef<Title$1>;
type TitleTemplate = TitleTemplate$1 | Ref<TitleTemplate$1> | ((title?: string) => TitleTemplate$1);
type Base<E extends EntryAugmentation = {}> = MaybeComputedRef<MaybeComputedRefEntries<Base$1<E>>>;
type Link<E extends EntryAugmentation = {}> = MaybeComputedRefEntries<Link$1<E>>;
type Meta<E extends EntryAugmentation = {}> = MaybeComputedRefEntries<Meta$1<E>>;
type Style<E extends EntryAugmentation = {}> = MaybeComputedRefEntries<Style$1<E>>;
type Script<E extends EntryAugmentation = {}> = MaybeComputedRefEntries<Script$1<E>>;
type Noscript<E extends EntryAugmentation = {}> = MaybeComputedRefEntries<Noscript$1<E>>;
type HtmlAttributes<E extends EntryAugmentation = {}> = MaybeComputedRef<MaybeComputedRefEntries<HtmlAttr & DataKeys & SchemaAugmentations['htmlAttrs'] & DefinedValueOrEmptyObject<E>>>;
type BodyAttributes<E extends EntryAugmentation = {}> = MaybeComputedRef<MaybeComputedRefEntries<BodyAttr & DataKeys & SchemaAugmentations['bodyAttrs'] & DefinedValueOrEmptyObject<E>>>;
interface ReactiveHead<E extends MergeHead = MergeHead> {
    /**
     * The <title> HTML element defines the document's title that is shown in a browser's title bar or a page's tab.
     * It only contains text; tags within the element are ignored.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/title
     */
    title?: Title | Promise<Title>;
    /**
     * Generate the title from a template.
     */
    titleTemplate?: TitleTemplate;
    /**
     * The <base> HTML element specifies the base URL to use for all relative URLs in a document.
     * There can be only one <base> element in a document.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/base
     */
    base?: Base<E['base']>;
    /**
     * The <link> HTML element specifies relationships between the current document and an external resource.
     * This element is most commonly used to link to stylesheets, but is also used to establish site icons
     * (both "favicon" style icons and icons for the home screen and apps on mobile devices) among other things.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/link#attr-as
     */
    link?: MaybeComputedRef<Link<E['link']>[]>;
    /**
     * The <meta> element represents metadata that cannot be expressed in other HTML elements, like <link> or <script>.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta
     */
    meta?: MaybeComputedRef<Meta<E['meta']>[]>;
    /**
     * The <style> HTML element contains style information for a document, or part of a document.
     * It contains CSS, which is applied to the contents of the document containing the <style> element.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/style
     */
    style?: MaybeComputedRef<Style<E['style']>[]>;
    /**
     * The <script> HTML element is used to embed executable code or data; this is typically used to embed or refer to JavaScript code.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/script
     */
    script?: MaybeComputedRef<Script<E['script']>[]>;
    /**
     * The <noscript> HTML element defines a section of HTML to be inserted if a script type on the page is unsupported
     * or if scripting is currently turned off in the browser.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/noscript
     */
    noscript?: MaybeComputedRef<Noscript<E['noscript']>[]>;
    /**
     * Attributes for the <html> HTML element.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/html
     */
    htmlAttrs?: HtmlAttributes<E['htmlAttrs']>;
    /**
     * Attributes for the <body> HTML element.
     *
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/body
     */
    bodyAttrs?: BodyAttributes<E['bodyAttrs']>;
}
type UseHeadInput<T extends MergeHead = {}> = MaybeComputedRef<ReactiveHead<T>>;

declare function resolveUnrefHeadInput(ref: any, lastKey?: string | number): any;
declare function asArray<T>(value: Arrayable<T>): T[];

type VueHeadClient<T extends MergeHead> = Unhead<MaybeComputedRef<ReactiveHead<T>>> & Plugin;
declare const headSymbol = "usehead";
declare function injectHead<T extends MergeHead>(): VueHeadClient<T>;
declare function createHead<T extends MergeHead>(options?: Omit<CreateHeadOptions, 'domDelayFn'>): VueHeadClient<T>;

declare const VueHeadMixin: {
    created(): void;
};

declare const VueReactiveUseHeadPlugin: () => _unhead_schema.HeadPlugin;

declare const Vue2ProvideUnheadPlugin: Plugin;

declare function useServerHead<T extends MergeHead>(input: UseHeadInput<T>, options?: HeadEntryOptions): void | _unhead_schema.ActiveHeadEntry<UseHeadInput<T>>;
declare const useServerTagTitle: (title: ReactiveHead['title']) => void | _unhead_schema.ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useServerTitleTemplate: (titleTemplate: ReactiveHead['titleTemplate']) => void | _unhead_schema.ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useServerTagMeta: (meta: Arrayable<Meta>) => void | _unhead_schema.ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useServerTagMetaFlat: (meta: MaybeComputedRefEntries<MetaFlatInput>) => void | _unhead_schema.ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useServerTagLink: (link: Arrayable<Link>) => void | _unhead_schema.ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useServerTagScript: (script: Arrayable<Script>) => void | _unhead_schema.ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useServerTagStyle: (style: Arrayable<Style>) => void | _unhead_schema.ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useServerTagNoscript: (noscript: Arrayable<Noscript>) => void | _unhead_schema.ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useServerTagBase: (base: ReactiveHead['base']) => void | _unhead_schema.ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useServerHtmlAttrs: (attrs: ReactiveHead['htmlAttrs']) => void | _unhead_schema.ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useServerBodyAttrs: (attrs: ReactiveHead['bodyAttrs']) => void | _unhead_schema.ActiveHeadEntry<UseHeadInput<MergeHead>>;

declare function useHead<T extends MergeHead>(input: UseHeadInput<T>, options?: HeadEntryOptions): ActiveHeadEntry<UseHeadInput<T>> | void;
declare const useTagTitle: (title: ReactiveHead['title']) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useTitleTemplate: (titleTemplate: ReactiveHead['titleTemplate']) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useTagMeta: (meta: Arrayable<Meta>) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useTagMetaFlat: (meta: MaybeComputedRefEntries<MetaFlatInput>) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useSeoMeta: (meta: MaybeComputedRefEntries<MetaFlatInput>) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useTagLink: (link: Arrayable<Link>) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useTagScript: (script: Arrayable<Script>) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useTagStyle: (style: Arrayable<Style>) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useTagNoscript: (noscript: Arrayable<Noscript>) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useTagBase: (base: ReactiveHead['base']) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useHtmlAttrs: (attrs: ReactiveHead['htmlAttrs']) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;
declare const useBodyAttrs: (attrs: ReactiveHead['bodyAttrs']) => void | ActiveHeadEntry<UseHeadInput<MergeHead>>;

declare const unheadVueComposablesImports: {
    from: string;
    imports: string[];
}[];

export { Arrayable, Base, BodyAttributes, HtmlAttributes, Link, MaybeComputedRef, MaybeComputedRefEntries, MaybeComputedRefOrPromise, MaybeReadonlyRef, Meta, Noscript, ReactiveHead, Script, Style, Title, TitleTemplate, UseHeadInput, Vue2ProvideUnheadPlugin, VueHeadClient, VueHeadMixin, VueReactiveUseHeadPlugin, asArray, createHead, createHeadCore, headSymbol, injectHead, resolveUnrefHeadInput, unheadVueComposablesImports, useBodyAttrs, useHead, useHtmlAttrs, useSeoMeta, useServerBodyAttrs, useServerHead, useServerHtmlAttrs, useServerTagBase, useServerTagLink, useServerTagMeta, useServerTagMetaFlat, useServerTagNoscript, useServerTagScript, useServerTagStyle, useServerTagTitle, useServerTitleTemplate, useTagBase, useTagLink, useTagMeta, useTagMetaFlat, useTagNoscript, useTagScript, useTagStyle, useTagTitle, useTitleTemplate };
