import { P as Preset, I as Import, B as BuiltinPresetName, a as InlinePreset, T as TypeDeclarationOptions, M as MagicStringResult, S as ScanDirExportsOptions, U as UnimportOptions, b as Thenable, c as InjectImportsOptions, d as ImportInjectionResult, e as UnimportMeta, f as InstallGlobalOptions } from './types-31beb514.js';
export { p as Addon, A as AddonsOptions, j as ImportCommon, i as ImportName, n as InjectionUsageRecord, h as ModuleId, l as PackagePreset, o as PathFromResolver, k as PresetImport, m as UnimportContext, g as builtinPresets } from './types-31beb514.js';
import MagicString from 'magic-string';
import * as mlly from 'mlly';

declare function resolvePreset(preset: Preset): Promise<Import[]>;
declare function resolveBuiltinPresets(presets: (BuiltinPresetName | Preset)[]): Promise<Import[]>;

declare const excludeRE: RegExp[];
declare const importAsRE: RegExp;
declare const separatorRE: RegExp;
/**                                                           |       |
 *                    destructing   case&ternary    non-call  |  id   |
 *                         ↓             ↓             ↓      |       |*/
declare const matchRE: RegExp;
declare function stripCommentsAndStrings(code: string): string;
declare function defineUnimportPreset(preset: InlinePreset): InlinePreset;
declare function toImports(imports: Import[], isCJS?: boolean): string;
declare function dedupeImports(imports: Import[], warn: (msg: string) => void): Import[];
declare function toExports(imports: Import[], fileDir?: string): string;
declare function toTypeDeclarationItems(imports: Import[], options?: TypeDeclarationOptions): string[];
declare function toTypeDeclarationFile(imports: Import[], options?: TypeDeclarationOptions): string;
declare function getString(code: string | MagicString): string;
declare function getMagicString(code: string | MagicString): MagicString;
declare function addImportToCode(code: string | MagicString, imports: Import[], isCJS?: boolean, mergeExisting?: boolean): MagicStringResult;
declare function normalizeImports(imports: Import[]): Import[];
declare function resolveIdAbsolute(id: string, parentId?: string): Promise<any>;

declare function scanDirExports(dir: string | string[], options?: ScanDirExportsOptions): Promise<Import[]>;
declare function scanExports(filepath: string): Promise<Import[]>;

type Unimport = ReturnType<typeof createUnimport>;
declare function createUnimport(opts: Partial<UnimportOptions>): {
    clearDynamicImports: () => void;
    modifyDynamicImports: (fn: (imports: Import[]) => Thenable<void | Import[]>) => Promise<void>;
    getImports: () => Promise<Import[]>;
    detectImports: (code: string | MagicString) => Promise<{
        s: MagicString;
        strippedCode: string;
        isCJSContext: boolean;
        matchedImports: Import[];
    }>;
    injectImports: (code: string | MagicString, id?: string, options?: InjectImportsOptions) => Promise<ImportInjectionResult>;
    toExports: (filepath?: string) => Promise<string>;
    parseVirtualImports: (code: string) => mlly.ParsedStaticImport[];
    generateTypeDeclarations: (options?: TypeDeclarationOptions) => Promise<string>;
    getMetadata: () => UnimportMeta | undefined;
};

declare function installGlobalAutoImports(imports: Import[] | Unimport, options?: InstallGlobalOptions): Promise<any>;

export { BuiltinPresetName, Import, ImportInjectionResult, InjectImportsOptions, InlinePreset, InstallGlobalOptions, MagicStringResult, Preset, ScanDirExportsOptions, Thenable, TypeDeclarationOptions, Unimport, UnimportMeta, UnimportOptions, addImportToCode, createUnimport, dedupeImports, defineUnimportPreset, excludeRE, getMagicString, getString, importAsRE, installGlobalAutoImports, matchRE, normalizeImports, resolveBuiltinPresets, resolveIdAbsolute, resolvePreset, scanDirExports, scanExports, separatorRE, stripCommentsAndStrings, toExports, toImports, toTypeDeclarationFile, toTypeDeclarationItems };
