import type * as estree from 'estree';
import type * as hast from 'hast';
import type * as mdast from 'mdast';
import { type VFile } from 'vfile';
export declare namespace define {
    /**
     * A mapping of variables to define. They keys are the names. The values are the ESTree expression
     * to represent them.
     */
    type Variables = Record<string, estree.Expression>;
    /**
     * Options for {@link define}
     */
    interface Options {
        /**
         * If and how to export the variable.
         *
         * - `'module'`: Export the value using an ESM const export declaration.
         * - `'namespace'`: Attach the value as a property on `MDXContent`.
         * - `false`: Define the variable locally, but don’t export it.
         *
         * @default 'module'
         */
        export?: 'module' | 'namespace' | false | undefined;
        /**
         * What to do if there’s a name conflict.
         *
         * - `'skip'`: Don’t insert the variable if there’s a name conflict.
         * - `'throw'`: Throw if there’s a name conflict.
         * - `'warn'`: Emit a vfile warning, but don’t throw.
         *
         * @default 'throw'
         */
        conflict?: 'skip' | 'throw' | 'warn' | undefined;
    }
}
/**
 * Define variables in an MDX related AST.
 *
 * @param ast
 *   The AST in which to define an export
 * @param file
 *   The {@link VFile} to emit warnings to.
 * @param variables
 *   A mapping of variables to define. They keys are the names. The values are the ESTree expression
 *   to represent them.
 * @param options
 *   Additional options to configure behaviour.
 */
export declare function define(ast: estree.Program | hast.Root | mdast.Root, file: VFile, variables: define.Variables, options?: define.Options | undefined): undefined;
//# sourceMappingURL=unist-util-mdx-define.d.ts.map