import { cac } from 'cac';
import { loadConfig } from '@unocss/config';
import { toArray } from '@unocss/core';
import { b as build, v as version, h as handleError } from './shared/cli.bf8f797d.mjs';
import 'node:fs';
import 'pathe';
import 'fast-glob';
import 'consola';
import 'colorette';
import 'perfect-debounce';
import '@rollup/pluginutils';
import 'magic-string';
import '@ampproject/remapping';
import '@unocss/preset-uno';

async function startCli(cwd = process.cwd(), argv = process.argv, options = {}) {
  const cli = cac("unocss");
  cli.command("[...patterns]", "Glob patterns", {
    ignoreOptionDefaultValue: true
  }).option("-o, --out-file <file>", "Output file", {
    default: cwd
  }).option("-c, --config [file]", "Config file").option("-w, --watch", "Watch for file changes").option("--preflights", "Enable preflights", { default: true }).option("-m, --minify", "Minify generated CSS", { default: false }).action(async (patterns, flags) => {
    Object.assign(options, {
      cwd,
      ...flags
    });
    if (patterns)
      options.patterns = patterns;
    const { config } = await loadConfig(cwd, options.config);
    const entries = toArray(config.cli?.entry || options);
    await Promise.all(entries.map(
      (entry) => build({
        ...options,
        ...entry
      })
    ));
  });
  cli.help();
  cli.version(version);
  cli.parse(argv, { run: false });
  await cli.runMatchedCommand();
}

startCli().catch(handleError);
