import { extractorArbitraryVariants } from '@unocss/extractor-arbitrary-variants';
import { entriesToCss, toArray } from '@unocss/core';
import './shared/preset-mini.f5158c55.mjs';
import { r as rules } from './shared/preset-mini.3535c317.mjs';
export { p as parseColor } from './shared/preset-mini.9dd74f3a.mjs';
export { c as colors } from './shared/preset-mini.1c66bf79.mjs';
import { t as theme } from './shared/preset-mini.c8479548.mjs';
export { t as theme } from './shared/preset-mini.c8479548.mjs';
import { v as variants } from './shared/preset-mini.27c86dd4.mjs';
import './shared/preset-mini.dfe8388f.mjs';

const preflights = [
  {
    layer: "preflights",
    getCSS(ctx) {
      if (ctx.theme.preflightBase) {
        const css = entriesToCss(Object.entries(ctx.theme.preflightBase));
        const roots = toArray(ctx.theme.preflightRoot ?? ["*,::before,::after", "::backdrop"]);
        return roots.map((root) => `${root}{${css}}`).join("");
      }
    }
  }
];

function presetMini(options = {}) {
  options.dark = options.dark ?? "class";
  options.attributifyPseudo = options.attributifyPseudo ?? false;
  options.preflight = options.preflight ?? true;
  options.variablePrefix = options.variablePrefix ?? "un-";
  return {
    name: "@unocss/preset-mini",
    theme,
    rules,
    variants: variants(options),
    options,
    prefix: options.prefix,
    postprocess: VarPrefixPostprocessor(options.variablePrefix),
    preflights: options.preflight ? normalizePreflights(preflights, options.variablePrefix) : [],
    extractorDefault: options.arbitraryVariants === false ? void 0 : extractorArbitraryVariants
  };
}
function VarPrefixPostprocessor(prefix) {
  if (prefix !== "un-") {
    return (obj) => {
      obj.entries.forEach((i) => {
        i[0] = i[0].replace(/^--un-/, `--${prefix}`);
        if (typeof i[1] === "string")
          i[1] = i[1].replace(/var\(--un-/g, `var(--${prefix}`);
      });
    };
  }
}
function normalizePreflights(preflights3, variablePrefix) {
  if (variablePrefix !== "un-") {
    return preflights3.map((p) => ({
      ...p,
      getCSS: (() => async (ctx) => {
        const css = await p.getCSS(ctx);
        if (css)
          return css.replace(/--un-/g, `--${variablePrefix}`);
      })()
    }));
  }
  return preflights3;
}

export { VarPrefixPostprocessor, presetMini as default, normalizePreflights, preflights, presetMini };
