import { UserConfig, GenerateResult, UserConfigDefaults, UnoGenerator } from '@unocss/core';

interface RuntimeGenerateResult extends GenerateResult {
    getStyleElement(name: string): HTMLStyleElement | undefined;
    getStyleElements(): Map<string, HTMLStyleElement>;
}
interface RuntimeOptions {
    /**
     * Default config of UnoCSS
     */
    defaults?: UserConfigDefaults;
    /**
     * Enable css property auto prefixer
     * @default false
     */
    autoPrefix?: boolean;
    /**
     * Attribute to use as cloaking
     * @default 'un-cloak'
     */
    cloakAttribute?: string;
    /**
     * Callback to modify config
     */
    configResolved?: (config: UserConfig, defaults: UserConfigDefaults) => void;
    /**
     * Callback when the runtime is ready. Returning false will prevent default extraction
     */
    ready?: (runtime: RuntimeContext) => false | any;
    /**
     * When enabled, UnoCSS will look for the existing selectors defined in the stylesheet and bypass them.
     * This is useful when using the runtime alongwith the build-time UnoCSS.
     */
    bypassDefined?: boolean;
}
type RuntimeInspectorCallback = (element: Element) => boolean;
interface RuntimeContext {
    /**
     * The UnoCSS instance.
     *
     * @type {UnoGenerator}
     */
    uno: UnoGenerator;
    /**
     * Run extractor on specified tokens
     *
     * @returns {Promise<void>}
     */
    extract: (tokens: string | string[]) => Promise<void>;
    /**
     * Rerun extractor on the whole <body>, regardless of paused status or inspection limitation.
     *
     * @returns {Promise<void>}
     */
    extractAll: () => Promise<void>;
    /**
     * Set/unset inspection callback to allow/ignore element to be extracted.
     *
     * @param {RuntimeInspectorCallback} [callback] - Callback to determine whether the element will be extracted.
     *
     * @returns {void}
     */
    inspect: (callback?: RuntimeInspectorCallback) => void;
    /**
     * Pause/resume/toggle the runtime.
     *
     * @param {boolean} [state] - False or True respectively pause or resume the runtime. Undefined parameter toggles the pause/resume state.
     *
     * @returns {void}
     */
    toggleObserver: (state?: boolean) => void;
    /**
     * Manually run the update cycle.
     *
     * @returns {RuntimeGenerateResult}
     */
    update: () => Promise<RuntimeGenerateResult>;
    /**
     * The UnoCSS version.
     *
     * @type {string}
     */
    version: string;
}
declare global {
    interface Window {
        __unocss?: UserConfig & {
            runtime?: RuntimeOptions;
        };
        __unocss_runtime?: RuntimeContext;
    }
}
declare function init(inlineConfig?: RuntimeOptions): void;

export { RuntimeContext, RuntimeGenerateResult, RuntimeInspectorCallback, RuntimeOptions, init as default };
