/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/***/ (() => {

const u = up.util;
up.migrate = (function () {
    const config = new up.Config(() => ({
        logLevel: 'warn'
    }));
    function renamedProperty(object, oldKey, newKey) {
        const warning = () => warn('Property { %s } has been renamed to { %s } (found in %o)', oldKey, newKey, object);
        Object.defineProperty(object, oldKey, {
            get() {
                warning();
                return this[newKey];
            },
            set(newValue) {
                warning();
                this[newKey] = newValue;
            }
        });
    }
    function removedProperty(object, key) {
        const warning = () => warn('Property { %s } has been removed without replacement (found in %o)', key, object);
        Object.defineProperty(object, key, {
            get() {
                warning();
                return this[key];
            },
            set(newValue) {
                warning();
                this[key] = newValue;
            }
        });
    }
    function renamedAttribute(oldAttr, newAttr, { scope, mapValue } = {}) {
        let selector = scope || `[${oldAttr}]`;
        up.macro(selector, { priority: -1000 }, function (element) {
            if (element.hasAttribute(oldAttr)) {
                warn('Attribute [%s] has been renamed to [%s] (found in %o)', oldAttr, newAttr, element);
                let value = element.getAttribute(oldAttr);
                if (mapValue) {
                    value = mapValue(value);
                }
                element.setAttribute(newAttr, value);
                element.removeAttribute(oldAttr);
            }
        });
    }
    function fixKey(object, oldKey, newKey) {
        if (u.isDefined(object[oldKey])) {
            warn('Property { %s } has been renamed to { %s } (found in %o)', oldKey, newKey, object);
            u.renameKey(object, oldKey, newKey);
        }
    }
    const renamedEvents = {};
    function renamedEvent(oldType, newType) {
        renamedEvents[oldType] = newType;
    }
    const removedEvents = {};
    function removedEvent(type, replacementExpression = null) {
        removedEvents[type] = replacementExpression;
    }
    function fixEventType(eventType) {
        let newEventType = renamedEvents[eventType];
        if (newEventType) {
            warn(`Event ${eventType} has been renamed to ${newEventType}`);
            return newEventType;
        }
        else if (eventType in removedEvents) {
            let message = `Event ${eventType} has been removed`;
            let replacementExpression = removedEvents[eventType];
            if (replacementExpression) {
                message += `. Use ${replacementExpression} instead.`;
            }
            warn(message);
            return eventType;
        }
        else {
            return eventType;
        }
    }
    function fixEventTypes(eventTypes) {
        return u.uniq(u.map(eventTypes, fixEventType));
    }
    function renamedPackage(oldName, newName) {
        Object.defineProperty(up, oldName, {
            get() {
                warn(`up.${oldName} has been renamed to up.${newName}`);
                return up[newName];
            }
        });
    }
    const warnedMessages = {};
    function warn(message, ...args) {
        const formattedMessage = u.sprintf(message, ...args);
        if (!warnedMessages[formattedMessage]) {
            warnedMessages[formattedMessage] = true;
            up.log[config.logLevel]('unpoly-migrate', message, ...args);
        }
    }
    function deprecated(deprecatedExpression, replacementExpression) {
        warn(`${deprecatedExpression} has been deprecated. Use ${replacementExpression} instead.`);
    }
    function formerlyAsync(label) {
        const promise = Promise.resolve();
        const oldThen = promise.then;
        promise.then = function () {
            warn(`${label} no longer returns a promise`);
            return oldThen.apply(this, arguments);
        };
        return promise;
    }
    function reset() {
        config.reset();
    }
    up.on('up:framework:reset', reset);
    return {
        deprecated,
        renamedPackage,
        renamedProperty,
        removedProperty,
        renamedAttribute,
        formerlyAsync,
        renamedEvent,
        removedEvent,
        fixEventTypes,
        fixKey,
        warn,
        loaded: true,
        config
    };
})();


/***/ }),
/* 2 */
/***/ (() => {

up.util.only = function (object, ...keys) {
    up.migrate.deprecated('up.util.only(object, ...keys)', 'up.util.pick(object, keys)');
    return up.util.pick(object, keys);
};
up.util.except = function (object, ...keys) {
    up.migrate.deprecated('up.util.except(object, ...keys)', 'up.util.omit(object, keys)');
    return up.util.omit(object, keys);
};
up.util.parseUrl = function (...args) {
    up.migrate.deprecated('up.util.parseUrl()', 'up.util.parseURL()');
    return up.util.parseURL(...args);
};
up.util.any = function (...args) {
    up.migrate.deprecated('up.util.any()', 'up.util.some()');
    return up.util.some(...args);
};
up.util.all = function (...args) {
    up.migrate.deprecated('up.util.all()', 'up.util.every()');
    return up.util.every(...args);
};
up.util.detect = function (...args) {
    up.migrate.deprecated('up.util.detect()', 'up.util.find()');
    return up.util.find(...args);
};
up.util.select = function (...args) {
    up.migrate.deprecated('up.util.select()', 'up.util.filter()');
    return up.util.filter(...args);
};
up.util.setTimer = function (...args) {
    up.migrate.deprecated('up.util.setTimer()', 'up.util.timer()');
    return up.util.timer(...args);
};
up.util.escapeHtml = function (...args) {
    up.migrate.deprecated('up.util.escapeHtml()', 'up.util.escapeHTML()');
    return up.util.escapeHTML(...args);
};
up.util.selectorForElement = function (...args) {
    up.migrate.deprecated('up.util.selectorForElement()', 'up.fragment.toTarget()');
    return up.fragment.toTarget(...args);
};
up.util.nextFrame = function (...args) {
    up.migrate.deprecated('up.util.nextFrame()', 'up.util.task()');
    return up.util.task(...args);
};
up.util.times = function (count, block) {
    up.migrate.deprecated('up.util.times()', 'a `for` loop');
    for (let i = 0; i < count; i++) {
        block();
    }
};
up.util.assign = function (...args) {
    up.migrate.deprecated('up.util.assign()', 'Object.assign()');
    return Object.assign(...args);
};
up.util.values = function (...args) {
    up.migrate.deprecated('up.util.values()', 'Object.values()');
    return Object.values(...args);
};


/***/ }),
/* 3 */
/***/ (() => {

up.browser.loadPage = function (...args) {
    up.migrate.deprecated('up.browser.loadPage()', 'up.network.loadPage()');
    return up.network.loadPage(...args);
};
up.browser.isSupported = function (...args) {
    up.migrate.deprecated('up.browser.isSupported()', 'up.framework.isSupported()');
    return up.framework.isSupported(...args);
};


/***/ }),
/* 4 */
/***/ (() => {

up.element.first = function (...args) {
    up.migrate.deprecated('up.element.first()', 'up.element.get()');
    return up.element.get(...args);
};
up.element.createFromHtml = function (...args) {
    up.migrate.deprecated('up.element.createFromHtml()', 'up.element.createFromHTML()');
    return up.element.createFromHTML(...args);
};
up.element.remove = function (element) {
    up.migrate.deprecated('up.element.remove()', 'Element#remove()');
    return element.remove();
};
up.element.matches = function (element, selector) {
    up.migrate.deprecated('up.element.matches()', 'Element#matches()');
    return element.matches(selector);
};
up.element.closest = function (element, selector) {
    up.migrate.deprecated('up.element.closest()', 'Element#closest()');
    return element.closest(selector);
};
up.element.replace = function (oldElement, newElement) {
    up.migrate.deprecated('up.element.replace()', 'Element#replaceWith()');
    return oldElement.replaceWith(newElement);
};
up.element.all = function (...args) {
    up.migrate.deprecated('up.element.all()', 'Document#querySelectorAll() or Element#querySelectorAll()');
    const selector = args.pop();
    const root = args[0] || document;
    return root.querySelectorAll(selector);
};
up.element.toggleClass = function (element, klass, newPresent) {
    const list = element.classList;
    if (newPresent == null) {
        newPresent = !list.contains(klass);
    }
    if (newPresent) {
        return list.add(klass);
    }
    else {
        return list.remove(klass);
    }
};
up.element.toSelector = function (...args) {
    up.migrate.deprecated('up.element.toSelector()', 'up.fragment.toTarget()');
    return up.fragment.toTarget(...args);
};
up.element.isAttached = function (element) {
    up.migrate.deprecated('up.element.isAttached()', 'element.isConnected');
    return element.isConnected;
};
up.element.isDetached = function (element) {
    up.migrate.deprecated('up.element.isDetached()', '!element.isConnected');
    return !element.isConnected;
};


/***/ }),
/* 5 */
/***/ (() => {

up.migrate.renamedPackage('bus', 'event');
up.event.nobodyPrevents = function (...args) {
    up.migrate.deprecated('up.event.nobodyPrevents(type)', '!up.emit(type).defaultPrevented');
    const event = up.emit(...args);
    return !event.defaultPrevented;
};


/***/ }),
/* 6 */
/***/ (() => {

const u = up.util;
const e = up.element;
up.migrate.postCompile = function (elements, compiler) {
    let keepValue;
    if (keepValue = compiler.keep) {
        up.migrate.warn('The { keep: true } option for up.compiler() has been removed. Have the compiler set [up-keep] attribute instead.');
        const value = u.isString(keepValue) ? keepValue : '';
        for (let element of elements) {
            element.setAttribute('up-keep', value);
        }
    }
};
up.migrate.targetMacro = function (queryAttr, fixedResultAttrs, callback) {
    up.macro(`[${queryAttr}]`, function (link) {
        let optionalTarget;
        const resultAttrs = u.copy(fixedResultAttrs);
        if ((optionalTarget = link.getAttribute(queryAttr))) {
            resultAttrs['up-target'] = optionalTarget;
        }
        else {
            resultAttrs['up-follow'] = '';
        }
        e.setMissingAttrs(link, resultAttrs);
        link.removeAttribute(queryAttr);
        callback === null || callback === void 0 ? void 0 : callback();
    });
};


/***/ }),
/* 7 */
/***/ (() => {

up.migrate.renamedProperty(up.form.config, 'fields', 'fieldSelectors');
up.migrate.renamedProperty(up.form.config, 'submitButtons', 'submitButtonSelectors');
up.migrate.renamedProperty(up.form.config, 'validateTargets', 'groupSelectors');
up.migrate.renamedProperty(up.form.config, 'observeDelay', 'watchInputDelay');
up.migrate.migratedFormGroupSelectors = function () {
    return up.form.config.groupSelectors.map((originalSelector) => {
        let migratedSelector = originalSelector.replace(/:has\(:origin\)$/, '');
        if (originalSelector !== migratedSelector) {
            up.migrate.warn('Selectors in up.form.config.groupSelectors must not contain ":has(:origin)". The suffix is added automatically where required. Found in "%s".', originalSelector);
        }
        return migratedSelector;
    });
};
up.migrate.renamedAttribute('up-observe', 'up-watch');
up.migrate.renamedAttribute('up-fieldset', 'up-form-group');
up.migrate.renamedAttribute('up-delay', 'up-watch-delay', { scope: '[up-autosubmit]' });
up.migrate.renamedAttribute('up-delay', 'up-watch-delay', { scope: '[up-watch]' });
up.migrate.renamedAttribute('up-restore-scroll', 'up-scroll', { mapValue: (value) => (value === 'true' ? 'restore' : 'reset') });
up.observe = function (...args) {
    up.migrate.deprecated('up.observe()', 'up.watch()');
    if (up.util.isList(args[0]) && args[0].length > 1) {
        let list = args.shift();
        up.migrate.warn('Calling up.observe() with a list of multiple elements is no longer supported by up.watch()');
        let unwatchFns = up.util.map(list, (firstArg) => up.watch(firstArg, ...args));
        return up.util.sequence(unwatchFns);
    }
    return up.watch(...args);
};


/***/ }),
/* 8 */
/***/ (() => {

const u = up.util;
up.migrate.renamedPackage('flow', 'fragment');
up.migrate.renamedPackage('dom', 'fragment');
up.migrate.renamedProperty(up.fragment.config, 'fallbacks', 'mainTargets');
up.migrate.handleResponseDocOptions = docOptions => up.migrate.fixKey(docOptions, 'html', 'document');
up.replace = function (target, url, options) {
    up.migrate.deprecated('up.replace(target, url)', 'up.navigate(target, { url })');
    return up.navigate(Object.assign(Object.assign({}, options), { target, url }));
};
up.extract = function (target, document, options) {
    up.migrate.deprecated('up.extract(target, document)', 'up.navigate(target, { document })');
    return up.navigate(Object.assign(Object.assign({}, options), { target, document }));
};
up.fragment.first = function (...args) {
    up.migrate.deprecated('up.fragment.first()', 'up.fragment.get()');
    return up.fragment.get(...args);
};
up.first = up.fragment.first;
up.migrate.preprocessRenderOptions = function (options) {
    if (u.isString(options.history) && (options.history !== 'auto')) {
        up.migrate.warn("Passing a URL as { history } option is deprecated. Pass it as { location } instead.");
        options.location = options.history;
        options.history = 'auto';
    }
    for (let prop of ['target', 'origin']) {
        if (u.isJQuery(options[prop])) {
            up.migrate.warn('Passing a jQuery collection as { %s } is deprecated. Pass it as a native element instead.', prop);
            options[prop] = up.element.get(options[prop]);
        }
    }
    if (options.fail === 'auto') {
        up.migrate.warn("The option { fail: 'auto' } is deprecated. Omit the option instead.");
        delete options.fail;
    }
    let solo = u.pluckKey(options, 'solo');
    if (u.isString(solo)) {
        up.migrate.warn("The up.render() option { solo } has been replaced by { abort } and { abort } no longer accepts a URL pattern. Check if you can use { abort: 'target'} or use up.network.abort(pattern) instead.");
        options.abort = (options) => up.network.abort(solo, options);
    }
    else if (u.isFunction(solo)) {
        up.migrate.warn("The up.render() option { solo } has been replaced by { abort } and { abort } no longer accepts a Function(up.Request): boolean. Check if you can use { abort: 'target'} or use up.network.abort(fn) instead.");
        options.abort = (options) => { up.network.abort(solo, options); };
    }
    else if (solo === true) {
        up.migrate.warn('Option { solo: true }', "{ abort: 'all' }");
        options.abort = 'all';
    }
    else if (solo === false) {
        up.migrate.warn('Option { solo: false }', "{ abort: false }");
        options.abort = false;
    }
    up.migrate.fixKey(options, 'keep', 'useKeep');
    up.migrate.fixKey(options, 'hungry', 'useHungry');
    up.migrate.fixKey(options, 'failOnFinished', 'onFailFinished');
    if (u.isString(options.reveal)) {
        up.migrate.deprecated(`Option { reveal: '${options.reveal}' }`, `{ scroll: '${options.reveal}' }`);
        options.scroll = options.reveal;
    }
    else if (options.reveal === true) {
        up.migrate.deprecated('Option { reveal: true }', "{ scroll: 'target' }");
        options.scroll = 'target';
    }
    else if (options.reveal === false) {
        up.migrate.deprecated('Option { reveal: false }', "{ scroll: false }");
        options.scroll = false;
    }
    if (u.isDefined(options.resetScroll)) {
        up.migrate.deprecated('Option { resetScroll: true }', "{ scroll: 'reset' }");
        options.scroll = 'teset';
    }
    if (u.isDefined(options.restoreScroll)) {
        up.migrate.deprecated('Option { restoreScroll: true }', "{ scroll: 'restore' }");
        options.scroll = 'restore';
    }
};
up.migrate.postprocessReloadOptions = function (options) {
    var _a;
    let lastModified = (_a = options.headers) === null || _a === void 0 ? void 0 : _a['If-Modified-Since'];
    let legacyHeader;
    if (lastModified) {
        legacyHeader = Math.floor(new Date(lastModified) * 0.001).toString();
    }
    else {
        legacyHeader = '0';
    }
    options.headers[up.protocol.headerize('reloadFromTime')] = legacyHeader;
};
const ATTR_SELECTOR_PATTERN = /\[([\w-]+)(?:([~|^$*]?=)(["'])?([^\3\]]*?)\3)?]/g;
up.migrate.resolveOrigin = function (target, { origin } = {}) {
    let pattern = new RegExp(ATTR_SELECTOR_PATTERN.source + '|&|:origin\\b', 'g');
    return target.replace(pattern, function (variant) {
        if (variant === ':origin' || variant === '&') {
            if (variant === '&') {
                up.migrate.deprecated("Origin shorthand '&'", ':origin');
            }
            if (origin) {
                return up.fragment.toTarget(origin);
            }
            else {
                up.fail('Missing { origin } element to resolve "%s" reference (found in %s)', variant, target);
            }
        }
        else {
            return variant;
        }
    });
};
up.migrate.removedEvent('up:fragment:kept', 'up:fragment:keep');
let runScripts = up.fragment.config.runScripts;
let runScriptsSet = false;
Object.defineProperty(up.fragment.config, 'runScripts', {
    get() {
        return runScripts;
    },
    set(value) {
        runScripts = value;
        runScriptsSet = true;
    }
});
up.on('up:framework:boot', function () {
    if (!runScriptsSet) {
        up.migrate.warn('Scripts within fragments are now executed. Configure up.fragment.config.runScripts to remove this warning.');
    }
});
up.compiler('[up-keep]', function (element) {
    let selector = up.element.booleanOrStringAttr(element, 'up-keep');
    if (u.isString(selector)) {
        up.migrate.warn('The [up-keep] attribute no longer supports a selector value. Elements will be matched by their derived target. You may prevent keeping with [up-on-keep="if(condition) event.preventDefault()"]. ');
        up.element.setMissingAttr(element, 'up-on-keep', `if (!newFragment.matches(${JSON.stringify(selector)})) event.preventDefault()`);
        element.setAttribute('up-keep', '');
    }
});


/***/ }),
/* 9 */
/***/ (() => {

up.migrate.renamedProperty(up.history.config, 'popTargets', 'restoreTargets');
up.history.url = function () {
    up.migrate.deprecated('up.history.url()', 'up.history.location');
    return up.history.location;
};
up.migrate.renamedEvent('up:history:push', 'up:location:changed');
up.migrate.renamedEvent('up:history:pushed', 'up:location:changed');
up.migrate.renamedEvent('up:history:restore', 'up:location:changed');
up.migrate.renamedEvent('up:history:restored', 'up:location:changed');
up.migrate.renamedEvent('up:history:replaced', 'up:location:changed');


/***/ }),
/* 10 */
/***/ (() => {

up.migrate.renamedPackage('navigation', 'feedback');
up.migrate.renamedProperty(up.feedback.config, 'navs', 'navSelectors');


/***/ }),
/* 11 */
/***/ (() => {

up.migrate.parseFollowOptions = function (parser) {
    parser.string('flavor');
    parser.string('width');
    parser.string('height');
    parser.boolean('closable');
    parser.booleanOrString('solo');
    parser.booleanOrString('reveal');
    parser.boolean('resetScroll');
    parser.boolean('restoreScroll');
    parser.booleanOrString('historyVisible');
    parser.booleanOrString('clearCache');
};
up.migrate.targetMacro('up-dash', { 'up-preload': '', 'up-instant': '' }, () => up.migrate.deprecated('a[up-dash]', 'up.link.config.instantSelectors and up.link.config.preloadSelectors'));
up.migrate.renamedAttribute('up-delay', 'up-preload-delay', { scope: up.link.preloadSelector });


/***/ }),
/* 12 */
/***/ (() => {

up.migrate.handleLayerOptions = function (options) {
    up.migrate.fixKey(options, 'flavor', 'mode');
    up.migrate.fixKey(options, 'closable', 'dismissable');
    up.migrate.fixKey(options, 'closeLabel', 'dismissLabel');
    for (let dimensionKey of ['width', 'maxWidth', 'height']) {
        if (options[dimensionKey]) {
            up.migrate.warn(`Layer option { ${dimensionKey} } has been removed. Use { size } or { class } instead.`);
        }
    }
    if (options.sticky) {
        up.migrate.warn('Layer option { sticky } has been removed. Give links an [up-peel=false] attribute to prevent layer dismissal on click.');
    }
    if (options.template) {
        up.migrate.warn('Layer option { template } has been removed. Use { class } or modify the layer HTML on up:layer:open.');
    }
    if (options.layer === 'page') {
        up.migrate.warn("Option { layer: 'page' } has been renamed to { layer: 'root' }.");
        options.layer = 'root';
    }
    if ((options.layer === 'modal') || (options.layer === 'popup')) {
        up.migrate.warn(`Option { layer: '${options.layer}' } has been removed. Did you mean { layer: 'overlay' }?`);
        options.layer = 'overlay';
    }
};
up.migrate.handleTetherOptions = function (options) {
    const [position, align] = options.position.split('-');
    if (align) {
        up.migrate.warn('The position value %o is deprecated. Use %o instead.', options.position, { position, align });
        options.position = position;
        options.align = align;
    }
};
up.migrate.registerLayerCloser = layer => layer.registerClickCloser('up-close', (value, closeOptions) => {
    up.migrate.deprecated('[up-close]', '[up-dismiss]');
    layer.dismiss(value, closeOptions);
});
up.migrate.handleLayerConfig = config => up.migrate.fixKey(config, 'historyVisible', 'history');
up.util.getter(up.Layer.prototype, 'historyVisible', function () {
    up.migrate.deprecated('up.Layer#historyVisible', 'up.Layer#history');
    return this.history;
});


/***/ }),
/* 13 */
/***/ (() => {

const FLAVORS_ERROR = new Error('up.modal.flavors has been removed without direct replacement. You may give new layers a { class } or modify layer elements on up:layer:open.');
up.modal = {
    visit(url, options = {}) {
        up.migrate.deprecated('up.modal.visit(url)', 'up.layer.open({ url, mode: "modal" })');
        return up.layer.open(Object.assign(Object.assign({}, options), { url, mode: 'modal' }));
    },
    follow(link, options = {}) {
        up.migrate.deprecated('up.modal.follow(link)', 'up.follow(link, { layer: "modal" })');
        return up.follow(link, Object.assign(Object.assign({}, options), { layer: 'modal' }));
    },
    extract(target, html, options = {}) {
        up.migrate.deprecated('up.modal.extract(target, document)', 'up.layer.open({ document, mode: "modal" })');
        return up.layer.open(Object.assign(Object.assign({}, options), { target, html, layer: 'modal' }));
    },
    close(options = {}) {
        up.migrate.deprecated('up.modal.close()', 'up.layer.dismiss()');
        up.layer.dismiss(null, options);
        return up.migrate.formerlyAsync('up.layer.dismiss()');
    },
    url() {
        up.migrate.deprecated('up.modal.url()', 'up.layer.location');
        return up.layer.location;
    },
    coveredUrl() {
        var _a;
        up.migrate.deprecated('up.modal.coveredUrl()', 'up.layer.parent.location');
        return (_a = up.layer.parent) === null || _a === void 0 ? void 0 : _a.location;
    },
    get config() {
        up.migrate.deprecated('up.modal.config', 'up.layer.config.modal');
        return up.layer.config.modal;
    },
    contains(element) {
        up.migrate.deprecated('up.modal.contains()', 'up.layer.contains()');
        return up.layer.contains(element);
    },
    isOpen() {
        up.migrate.deprecated('up.modal.isOpen()', 'up.layer.isOverlay()');
        return up.layer.isOverlay();
    },
    get flavors() {
        throw FLAVORS_ERROR;
    },
    flavor() {
        throw FLAVORS_ERROR;
    }
};
up.migrate.renamedEvent('up:modal:open', 'up:layer:open');
up.migrate.renamedEvent('up:modal:opened', 'up:layer:opened');
up.migrate.renamedEvent('up:modal:close', 'up:layer:dismiss');
up.migrate.renamedEvent('up:modal:closed', 'up:layer:dismissed');
up.migrate.targetMacro('up-modal', { 'up-layer': 'new modal' }, () => up.migrate.deprecated('a[up-modal]', 'a[up-layer="new modal"]'));
up.migrate.targetMacro('up-drawer', { 'up-layer': 'new drawer' }, () => up.migrate.deprecated('a[up-drawer]', 'a[up-layer="new drawer"]'));


/***/ }),
/* 14 */
/***/ (() => {

up.popup = {
    attach(origin, options = {}) {
        origin = up.fragment.get(origin);
        up.migrate.deprecated('up.popup.attach(origin)', "up.layer.open({ origin, layer: 'popup' })");
        return up.layer.open(Object.assign(Object.assign({}, options), { origin, layer: 'popup' }));
    },
    close(options = {}) {
        up.migrate.deprecated('up.popup.close()', 'up.layer.dismiss()');
        up.layer.dismiss(null, options);
        return up.migrate.formerlyAsync('up.layer.dismiss()');
    },
    url() {
        up.migrate.deprecated('up.popup.url()', 'up.layer.location');
        return up.layer.location;
    },
    coveredUrl() {
        var _a;
        up.migrate.deprecated('up.popup.coveredUrl()', 'up.layer.parent.location');
        return (_a = up.layer.parent) === null || _a === void 0 ? void 0 : _a.location;
    },
    get config() {
        up.migrate.deprecated('up.popup.config', 'up.layer.config.popup');
        return up.layer.config.popup;
    },
    contains(element) {
        up.migrate.deprecated('up.popup.contains()', 'up.layer.contains()');
        return up.layer.contains(element);
    },
    isOpen() {
        up.migrate.deprecated('up.popup.isOpen()', 'up.layer.isOverlay()');
        return up.layer.isOverlay();
    },
    sync() {
        up.migrate.deprecated('up.popup.sync()', 'up.layer.sync()');
        return up.layer.sync();
    }
};
up.migrate.renamedEvent('up:popup:open', 'up:layer:open');
up.migrate.renamedEvent('up:popup:opened', 'up:layer:opened');
up.migrate.renamedEvent('up:popup:close', 'up:layer:dismiss');
up.migrate.renamedEvent('up:popup:closed', 'up:layer:dismissed');
up.migrate.targetMacro('up-popup', { 'up-layer': 'new popup' }, () => up.migrate.deprecated('[up-popup]', '[up-layer="new popup"]'));


/***/ }),
/* 15 */
/***/ (() => {

up.macro('[up-tooltip]', function (opener) {
    up.migrate.warn('[up-tooltip] has been deprecated. A [title] was set instead.');
    up.element.setMissingAttr(opener, 'title', opener.getAttribute('up-tooltip'));
});


/***/ }),
/* 16 */
/***/ (() => {

up.migrate.clearCacheFromXHR = function (xhr) {
    let value = xhr.getResponseHeader('X-Up-Clear-Cache');
    if (value) {
        up.migrate.deprecated('X-Up-Clear-Cache', 'X-Up-Expire-Cache');
        if (value === 'false') {
            return false;
        }
        else {
            return value;
        }
    }
};


/***/ }),
/* 17 */
/***/ (() => {

const u = up.util;
up.migrate.renamedPackage('proxy', 'network');
up.migrate.renamedEvent('up:proxy:load', 'up:request:load');
up.migrate.renamedEvent('up:proxy:received', 'up:request:loaded');
up.migrate.renamedEvent('up:proxy:loaded', 'up:request:loaded');
up.migrate.renamedEvent('up:proxy:fatal', 'up:request:offline');
up.migrate.renamedEvent('up:request:fatal', 'up:request:offline');
up.migrate.renamedEvent('up:proxy:aborted', 'up:request:aborted');
up.migrate.renamedEvent('up:proxy:slow', 'up:network:late');
up.migrate.renamedEvent('up:proxy:recover', 'up:network:recover');
up.migrate.renamedEvent('up:request:late', 'up:network:late');
up.migrate.renamedEvent('up:request:recover', 'up:network:recover');
const preloadDelayMoved = () => up.migrate.deprecated('up.proxy.config.preloadDelay', 'up.link.config.preloadDelay');
Object.defineProperty(up.network.config, 'preloadDelay', {
    get() {
        preloadDelayMoved();
        return up.link.config.preloadDelay;
    },
    set(value) {
        preloadDelayMoved();
        up.link.config.preloadDelay = value;
    }
});
up.migrate.renamedProperty(up.network.config, 'maxRequests', 'concurrency');
up.migrate.renamedProperty(up.network.config, 'slowDelay', 'badResponseTime');
up.migrate.renamedProperty(up.network.config, 'cacheExpiry', 'cacheExpireAge');
up.migrate.renamedProperty(up.network.config, 'clearCache', 'expireCache');
up.migrate.handleRequestOptions = function (options) {
    up.migrate.fixKey(options, 'clearCache', 'expireCache');
    if (options.solo) {
        up.migrate.warn('The option up.request({ solo }) has been removed. Use up.network.abort() or up.fragment.abort() instead.');
    }
};
up.ajax = function (...args) {
    up.migrate.deprecated('up.ajax()', 'up.request()');
    const pickResponseText = response => response.text;
    return up.request(...args).then(pickResponseText);
};
up.network.clear = function () {
    up.migrate.deprecated('up.proxy.clear()', 'up.cache.expire()');
    up.cache.expire();
};
up.Request.Cache.prototype.clear = function (...args) {
    up.migrate.deprecated('up.cache.clear()', 'up.cache.expire()');
    this.expire(...args);
};
up.network.preload = function (...args) {
    up.migrate.deprecated('up.proxy.preload(link)', 'up.link.preload(link)');
    return up.link.preload(...args);
};
up.migrate.preprocessAbortArgs = function (args) {
    if (args.length === 2 && u.isString(args[1])) {
        up.migrate.warn('up.network.abort() no longer takes a reason as a second argument. Pass it as { reason } option instead.');
        args[1] = { reason: args[1] };
    }
};
up.network.isIdle = function () {
    up.migrate.deprecated('up.network.isIdle()', '!up.network.isBusy()');
    return !up.network.isBusy();
};
up.Request.prototype.navigate = function () {
    up.migrate.deprecated('up.Request#navigate()', 'up.Request#loadPage()');
    this.loadPage();
};
up.Response.prototype.isSuccess = function () {
    up.migrate.deprecated('up.Response#isSuccess()', 'up.Response#ok');
    return this.ok;
};
up.Response.prototype.isError = function () {
    up.migrate.deprecated('up.Response#isError()', '!up.Response#ok');
    return !this.ok;
};
function mayHaveCustomIndicator() {
    const listeners = up.EventListener.allNonDefault(document);
    return u.find(listeners, listener => listener.eventType === 'up:network:late');
}
const progressBarDefault = up.network.config.progressBar;
function disableProgressBarIfCustomIndicator() {
    up.network.config.progressBar = function () {
        if (mayHaveCustomIndicator()) {
            up.migrate.warn('Disabled the default progress bar as may have built a custom loading indicator with your up:network:late listener. Please set up.network.config.progressBar to true or false.');
            return false;
        }
        else {
            return progressBarDefault;
        }
    };
}
disableProgressBarIfCustomIndicator();
up.on('up:framework:reset', disableProgressBarIfCustomIndicator);


/***/ }),
/* 18 */
/***/ (() => {

up.migrate.renamedProperty(up.radio.config, 'hungry', 'hungrySelectors');


/***/ }),
/* 19 */
/***/ (() => {

up.migrate.renamedPackage('layout', 'viewport');
up.migrate.renamedProperty(up.viewport.config, 'viewports', 'viewportSelectors');
up.migrate.renamedProperty(up.viewport.config, 'snap', 'revealSnap');
up.migrate.removedProperty(up.viewport.config, 'scrollSpeed');
up.viewport.closest = function (...args) {
    up.migrate.deprecated('up.viewport.closest()', 'up.viewport.get()');
    return up.viewport.get(...args);
};
up.viewport.scroll = function (viewport, top, options = {}) {
    viewport = up.fragment.get(viewport, options);
    viewport.scrollTo(Object.assign(Object.assign({}, options), { top }));
    return up.migrate.formerlyAsync('up.scroll()');
};
up.scroll = up.viewport.scroll;


/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
up.framework.startExtension();
__webpack_require__(1);
__webpack_require__(2);
__webpack_require__(3);
__webpack_require__(4);
__webpack_require__(5);
__webpack_require__(6);
__webpack_require__(7);
__webpack_require__(8);
__webpack_require__(9);
__webpack_require__(10);
__webpack_require__(11);
__webpack_require__(12);
__webpack_require__(13);
__webpack_require__(14);
__webpack_require__(15);
__webpack_require__(16);
__webpack_require__(17);
__webpack_require__(18);
__webpack_require__(19);
up.framework.stopExtension();

})();

/******/ })()
;