import { D as Driver, S as Storage, a as StorageValue } from './types-227df1cc.js';
export { D as Driver, S as Storage, c as StorageMeta, a as StorageValue, U as Unwatch, b as WatchCallback, W as WatchEvent } from './types-227df1cc.js';

interface CreateStorageOptions {
    driver?: Driver;
}
declare function createStorage(options?: CreateStorageOptions): Storage;
declare type Snapshot<T = string> = Record<string, T>;
declare function snapshot(storage: Storage, base: string): Promise<Snapshot<string>>;
declare function restoreSnapshot(driver: Storage, snapshot: Snapshot<StorageValue>, base?: string): Promise<void>;

declare function prefixStorage(storage: Storage, base: string): Storage;
declare function normalizeKey(key?: string): string;
declare function joinKeys(...keys: string[]): string;
declare function normalizeBaseKey(base?: string): string;

declare type DriverFactory<T> = (opts?: T) => Driver;
declare function defineDriver<T = any>(factory: DriverFactory<T>): DriverFactory<T>;

declare const builtinDrivers: {
    cloudflareKVHTTP: string;
    cloudflareKVBinding: string;
    "cloudflare-kv-http": string;
    "cloudflare-kv-binding": string;
    fs: string;
    github: string;
    http: string;
    localStorage: string;
    localstorage: string;
    memory: string;
    overlay: string;
    redis: string;
};
declare type BuiltinDriverName = keyof typeof builtinDrivers;

export { BuiltinDriverName, CreateStorageOptions, Snapshot, builtinDrivers, createStorage, defineDriver, joinKeys, normalizeBaseKey, normalizeKey, prefixStorage, restoreSnapshot, snapshot };
