'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.curry1 = curry1;
exports.curry2 = curry2;
exports.curry3 = curry3;
exports.curry4 = curry4;
exports.default = curry;
/* eslint no-shadow:0, no-param-reassign:0 */
var _ = exports._ = '@@updeep/placeholder';

function countArguments(args, max) {
  var n = args.length;
  if (n > max) n = max;

  while (args[n - 1] === _) {
    n--;
  }

  return n;
}

function curry1(fn) {
  return function curried(a) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    var b = args[0];
    var c = args[1];

    var n = countArguments(arguments);

    if (n >= 1) return fn(a, b, c);
    return curried;
  };
}

function curry2(fn) {
  return function curried(a, b) {
    for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
      args[_key2 - 2] = arguments[_key2];
    }

    var c = args[0];
    var d = args[1];

    var n = countArguments(arguments, 2);

    if (b === _ || c === _ || d === _) {
      throw new Error('Can only use placeholder on first argument of this function.');
    }

    if (n >= 2) {
      if (a === _) return curry1(function (a, c, d) {
        return fn(a, b, c, d);
      });
      return fn(a, b, c, d);
    }

    if (n === 1) return curry1(function (b, c, d) {
      return fn(a, b, c, d);
    });
    return curried;
  };
}

function curry3(fn) {
  return function curried(a, b, c) {
    for (var _len3 = arguments.length, args = Array(_len3 > 3 ? _len3 - 3 : 0), _key3 = 3; _key3 < _len3; _key3++) {
      args[_key3 - 3] = arguments[_key3];
    }

    var d = args[0];
    var e = args[1];

    var n = countArguments(arguments, 3);

    if (c === _ || d === _ || e === _) {
      throw new Error('Can only use placeholder on first or second argument of this function.');
    }

    if (n >= 3) {
      if (a === _) {
        if (b === _) return curry2(function (a, b, d, e) {
          return fn(a, b, c, d, e);
        });
        return curry1(function (a, d, e) {
          return fn(a, b, c, d, e);
        });
      }
      if (b === _) return curry1(function (b, d, e) {
        return fn(a, b, c, d, e);
      });
      return fn(a, b, c, d, e);
    }

    if (n === 2) {
      if (a === _) return curry2(function (a, c, d, e) {
        return fn(a, b, c, d, e);
      });
      return curry1(function (c, d, e) {
        return fn(a, b, c, d, e);
      });
    }

    if (n === 1) return curry2(function (b, c, d, e) {
      return fn(a, b, c, d, e);
    });

    return curried;
  };
}

function curry4(fn) {
  return function curried(a, b, c, d) {
    for (var _len4 = arguments.length, args = Array(_len4 > 4 ? _len4 - 4 : 0), _key4 = 4; _key4 < _len4; _key4++) {
      args[_key4 - 4] = arguments[_key4];
    }

    var e = args[0];
    var f = args[1];

    var n = countArguments(arguments, 4);

    if (d === _ || e === _ || f === _) {
      throw new Error('Can only use placeholder on first, second or third argument of this function.');
    }

    if (n >= 4) {
      if (a === _) {
        if (b === _) {
          if (c === _) return curry3(function (a, b, c, e, f) {
            return fn(a, b, c, d, e, f);
          });
          return curry2(function (a, b, e, f) {
            return fn(a, b, c, d, e, f);
          });
        }
        if (c === _) return curry2(function (a, c, e, f) {
          return fn(a, b, c, d, e, f);
        });
        return curry1(function (a, e, f) {
          return fn(a, b, c, d, e, f);
        });
      }
      if (b === _) {
        if (c === _) return curry2(function (b, c, e, f) {
          return fn(a, b, c, d, e, f);
        });
        return curry1(function (b, e, f) {
          return fn(a, b, c, d, e, f);
        });
      }
      if (c === _) return curry1(function (c, e, f) {
        return fn(a, b, c, d, e, f);
      });
      return fn(a, b, c, d, e, f);
    }

    if (n === 3) {
      if (a === _) {
        if (b === _) return curry3(function (a, b, d, e, f) {
          return fn(a, b, c, d, e, f);
        });
        return curry2(function (a, d, e, f) {
          return fn(a, b, c, d, e, f);
        });
      }
      if (b === _) return curry2(function (b, d, e, f) {
        return fn(a, b, c, d, e, f);
      });
      return curry1(function (d, e, f) {
        return fn(a, b, c, d, e, f);
      });
    }

    if (n === 2) {
      if (a === _) return curry3(function (a, c, d, e, f) {
        return fn(a, b, c, d, e, f);
      });
      return curry2(function (c, d, e, f) {
        return fn(a, b, c, d, e, f);
      });
    }

    if (n === 1) return curry3(function (b, c, d, e, f) {
      return fn(a, b, c, d, e, f);
    });
    return curried;
  };
}

function curry(fn) {
  var length = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : fn.length;

  return [fn, curry1, curry2, curry3, curry4][length](fn);
}