"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = openIdConnect;
exports.tokenize = tokenize;

require("core-js/modules/es7.object.entries");

require("core-js/modules/es6.promise");

var _axios = require("axios");

var _jwtDecode = _interopRequireDefault(require("jwt-decode"));

require("babel-polyfill");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } } function _next(value) { step("next", value); } function _throw(err) { step("throw", err); } _next(); }); }; }

// needed to apply async/await polyfills
let token = null;
/**
 * Options for getting tokens
 * @typedef {Object} Options
 * @property {string} [userInfoApiUrl] - url to Open ID Connect endpoint
 * @property {number} [timeout] - time in milliseconds until token will be
 *                                invalid
 * @property {Object} [propertyTransforms] - apply additional transforms to
 *                                           specific properties
 */

/**
 * Callback to resolve Open ID Connect token
 * @callback tokenCallback
 * @param {?Error} err -
 * @param {?Object} token - with encoded and decoded values
 */

/**
 * Get token from uPortal Open ID Connect service
 * @param {Options} [options] - allow setting a custom user info API url and a
 *                              custom clock smear
 * @param {tokenCallback} [callback] - optional callback, alternative to Promise
 *                                     API
 * @return {Promise<Object>} Promise that resolves with the encoded and decoded
 *                           token in an Object
 */

function openIdConnect() {
  return _openIdConnect.apply(this, arguments);
}
/**
 * Extract JWT contents
 * @param {string} jwt - JSON Web Token to decode
 * @return {Object} with encoded and decoded values
 */


function _openIdConnect() {
  _openIdConnect = _asyncToGenerator(function* ({
    userInfoApiUrl = '/uPortal/api/v5-1/userinfo',
    timeout = 50000,
    propertyTransforms = {}
  } = {}, callback) {
    // If there already is a valid token, resolve it
    if (token !== null) {
      return token;
    }

    try {
      // get a new token
      const _ref = yield (0, _axios.get)(userInfoApiUrl, {
        responseType: 'text'
      }),
            data = _ref.data; // store the encoded and decoded versions


      token = tokenize(data); // Allow for additional transforms to be applied to decoded properties

      Object.entries(propertyTransforms).forEach(([property, transform]) => {
        token.decoded[property] = transform(token.decoded[property]);
      }); // automatically clear token after expiration

      setTimeout(() => {
        token = null;
      }, timeout); // pass value to optional call back

      if (callback) {
        return callback(null, token);
      } // resolve the promise


      return token;
    } catch (err) {
      // pass back error for callback
      if (callback) {
        return callback(err);
      } // re-throw error for promises


      throw err;
    }
  });
  return _openIdConnect.apply(this, arguments);
}

function tokenize(jwt) {
  return {
    encoded: jwt,
    decoded: (0, _jwtDecode.default)(jwt)
  };
}