'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var decode = _interopDefault(require('jwt-decode'));

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }

  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}

function _asyncToGenerator(fn) {
  return function () {
    var self = this,
        args = arguments;
    return new Promise(function (resolve, reject) {
      var gen = fn.apply(self, args);

      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
      }

      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
      }

      _next(undefined);
    });
  };
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArrayLimit(arr, i) {
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance");
}

/**
 * Options for getting tokens
 * @typedef {Object} Options
 * @property {string} [userInfoApiUrl] - url to Open ID Connect endpoint
 * @property {number} [timeout] - time in milliseconds until token will be
 *                                invalid
 * @property {Object} [propertyTransforms] - apply additional transforms to
 *                                           specific properties
 */

/**
 * Callback to resolve Open ID Connect token
 * @callback tokenCallback
 * @param {?Error} err -
 * @param {?Object} token - with encoded and decoded values
 */

/**
 * Get token from uPortal Open ID Connect service
 * @param {Options} [options] - allow setting a custom user info API url and a
 *                              custom clock smear
 * @param {tokenCallback} [callback] - optional callback, alternative to Promise
 *                                     API
 * @return {Promise<Object>} Promise that resolves with the encoded and decoded
 *                           token in an Object
 */

function openIdConnect() {
  return _openIdConnect.apply(this, arguments);
}
/**
 * Extract JWT contents
 * @param {string} jwt - JSON Web Token to decode
 * @return {Object} with encoded and decoded values
 */

function _openIdConnect() {
  _openIdConnect = _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee() {
    var _ref,
        _ref$userInfoApiUrl,
        userInfoApiUrl,
        _ref$timeout,
        _ref$propertyTransfor,
        propertyTransforms,
        callback,
        response,
        data,
        token,
        _args = arguments;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _ref = _args.length > 0 && _args[0] !== undefined ? _args[0] : {}, _ref$userInfoApiUrl = _ref.userInfoApiUrl, userInfoApiUrl = _ref$userInfoApiUrl === void 0 ? '/uPortal/api/v5-1/userinfo' : _ref$userInfoApiUrl, _ref$timeout = _ref.timeout, _ref$propertyTransfor = _ref.propertyTransforms, propertyTransforms = _ref$propertyTransfor === void 0 ? {} : _ref$propertyTransfor;
            callback = _args.length > 1 ? _args[1] : undefined;
            _context.prev = 2;
            _context.next = 5;
            return fetch(userInfoApiUrl, {
              method: 'GET',
              credentials: 'include'
            });

          case 5:
            response = _context.sent;

            if (response.ok) {
              _context.next = 8;
              break;
            }

            throw new Error(response.statusText);

          case 8:
            _context.next = 10;
            return response.text();

          case 10:
            data = _context.sent;
            // store the encoded and decoded versions
            token = tokenize(data); // Allow for additional transforms to be applied to decoded properties

            Object.entries(propertyTransforms).forEach(function (_ref2) {
              var _ref3 = _slicedToArray(_ref2, 2),
                  property = _ref3[0],
                  transform = _ref3[1];

              token.decoded[property] = transform(token.decoded[property]);
            }); // pass value to optional call back

            if (!callback) {
              _context.next = 15;
              break;
            }

            return _context.abrupt("return", callback(null, token));

          case 15:
            return _context.abrupt("return", token);

          case 18:
            _context.prev = 18;
            _context.t0 = _context["catch"](2);

            if (!callback) {
              _context.next = 22;
              break;
            }

            return _context.abrupt("return", callback(_context.t0));

          case 22:
            throw _context.t0;

          case 23:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, this, [[2, 18]]);
  }));
  return _openIdConnect.apply(this, arguments);
}

function tokenize(jwt) {
  return {
    encoded: jwt,
    decoded: decode(jwt)
  };
}

exports.default = openIdConnect;
exports.tokenize = tokenize;
