const HASH = "(?:(?:/)?#(?:/)?)";
const SLASH = "(?:/)";
/**
 *
 * @param {string} path
 * @return {[RegExp,string[]]}
 */
export function pathToRegExp(path) {
    const params = [];
    const folders = path
        .replace(/#(\/)?/, "/#")
        .split(/\//g)
        .filter((value) => value);

    const regFolders = folders
        .map((folder, index) => {
            if (folder === "*")
                return `${SLASH}${
                    index === folders.length - 1 ? "?" : ""
                }[^\/]${index === folders.length - 1 ? "*" : "+"}`;
            if (folder === "...") return `${SLASH}?.*`;
            const [, hash = "", type, spread, param] = folder.match(
                /(#)?([\{\[])?(\.\.\.)?(\w*)([\}\]])?/
            );
            if (type == "{" || type == "[") {
                params.push(param);
                const wildcard = type == "[" ? "*" : "+";
                const slash =
                    (hash ? HASH : SLASH) + (type == "[" ? "?" : "{1}");
                return spread
                    ? `${slash}(.${wildcard})`
                    : `${slash}([^\/#]${wildcard})`;
            } else {
                return (
                    (hash ? HASH : "/") +
                    ignore(hash ? folder.slice(1) : folder)
                );
            }
        })
        .join("");
    // Hash paths escape the path start requirement
    const isHash = !regFolders.indexOf(HASH);
    return [
        RegExp(
            (isHash ? "" : "^") +
                (regFolders || SLASH + "?") +
                // closed paths are only enabled out of hash
                (!isHash && path != "/" && path.endsWith("/") ? "/" : "") +
                "$"
        ),
        params,
    ];
}

/**
 *
 * @param {string} str
 */
export const ignore = (str) => str.replace(/([.+^()\-:])/g, "\\$1");
