// src/module.ts
var ID = Math.random();
var ID_REG = RegExp(`{${ID}-(\\d+)}`);
var CACHE = {};
var getIndexParam = (value) => value.match(ID_REG)?.[1];
function media(parts, ...params) {
  const template = parts.raw.reduce((str, part, i) => str + part + (i in params ? `{${ID}-${i}}` : ""), "");
  if (!CACHE[template]) {
    CACHE[template] = parse(template);
  }
  const result = CACHE[template];
  return {
    result,
    match(callback) {
      let defaultResult;
      let value;
      for (let prop in result) {
        const currentResult = result[prop];
        if (currentResult.default) {
          defaultResult = currentResult;
        } else if (callback(currentResult)) {
          value = currentResult;
          break;
        }
      }
      value = value || defaultResult;
      return value.param ? params[value.param] : value.value;
    }
  };
}
function parse(template) {
  const groups = template.split(/,\s+/).map((value) => {
    value = value.trim();
    const test = value.match(/(.+)\s+(\d+(?:\.\d+){0,1})(\w+)$/);
    if (test) {
      const [, value2, size, unit] = test;
      return {
        value: value2,
        size: Number(size),
        unit,
        param: getIndexParam(value2)
      };
    } else {
      return {
        value,
        size: -1 >>> 0,
        unit: "",
        param: getIndexParam(value),
        default: true
      };
    }
  });
  return groups.sort((a, b) => a.size > b.size ? -1 : 1);
}
export {
  media as default,
  parse
};
