var _class, _temp;

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

// If global `URL` constructor is available, use it
var URL_ = typeof URL === 'function' ? URL : require('url-parse');

var _require = require('@uppy/core'),
    Plugin = _require.Plugin;

var Translator = require('@uppy/utils/lib/Translator');

var RateLimitedQueue = require('@uppy/utils/lib/RateLimitedQueue');

var _require2 = require('@uppy/companion-client'),
    RequestClient = _require2.RequestClient;

var XHRUpload = require('@uppy/xhr-upload');

function resolveUrl(origin, link) {
  return new URL_(link, origin).toString();
}

function isXml(xhr) {
  var contentType = xhr.headers ? xhr.headers['content-type'] : xhr.getResponseHeader('Content-Type');
  return typeof contentType === 'string' && contentType.toLowerCase() === 'application/xml';
}

function getXmlValue(source, key) {
  var start = source.indexOf("<" + key + ">");
  var end = source.indexOf("</" + key + ">", start);
  return start !== -1 && end !== -1 ? source.slice(start + key.length + 2, end) : '';
}

function assertServerError(res) {
  if (res && res.error) {
    var error = new Error(res.message);

    _extends(error, res.error);

    throw error;
  }

  return res;
}

module.exports = (_temp = _class =
/*#__PURE__*/
function (_Plugin) {
  _inheritsLoose(AwsS3, _Plugin);

  function AwsS3(uppy, opts) {
    var _this;

    _this = _Plugin.call(this, uppy, opts) || this;
    _this.type = 'uploader';
    _this.id = _this.opts.id || 'AwsS3';
    _this.title = 'AWS S3';
    _this.defaultLocale = {
      strings: {
        preparingUpload: 'Preparing upload...'
      }
    };
    var defaultOptions = {
      timeout: 30 * 1000,
      limit: 0,
      getUploadParameters: _this.getUploadParameters.bind(_assertThisInitialized(_this))
    };
    _this.opts = _extends({}, defaultOptions, {}, opts);

    _this.i18nInit();

    _this.client = new RequestClient(uppy, opts);
    _this.prepareUpload = _this.prepareUpload.bind(_assertThisInitialized(_this));
    _this.requests = new RateLimitedQueue(_this.opts.limit);
    return _this;
  }

  var _proto = AwsS3.prototype;

  _proto.setOptions = function setOptions(newOpts) {
    _Plugin.prototype.setOptions.call(this, newOpts);

    this.i18nInit();
  };

  _proto.i18nInit = function i18nInit() {
    this.translator = new Translator([this.defaultLocale, this.uppy.locale, this.opts.locale]);
    this.i18n = this.translator.translate.bind(this.translator);
    this.setPluginState(); // so that UI re-renders and we see the updated locale
  };

  _proto.getUploadParameters = function getUploadParameters(file) {
    if (!this.opts.companionUrl) {
      throw new Error('Expected a `companionUrl` option containing a Companion address.');
    }

    var filename = encodeURIComponent(file.meta.name);
    var type = encodeURIComponent(file.meta.type);
    return this.client.get("s3/params?filename=" + filename + "&type=" + type).then(assertServerError);
  };

  _proto.validateParameters = function validateParameters(file, params) {
    var valid = typeof params === 'object' && params && typeof params.url === 'string' && (typeof params.fields === 'object' || params.fields == null) && (params.method == null || /^(put|post)$/i.test(params.method));

    if (!valid) {
      var err = new TypeError("AwsS3: got incorrect result from 'getUploadParameters()' for file '" + file.name + "', expected an object '{ url, method, fields, headers }'.\nSee https://uppy.io/docs/aws-s3/#getUploadParameters-file for more on the expected format.");
      console.error(err);
      throw err;
    }

    return params;
  };

  _proto.prepareUpload = function prepareUpload(fileIDs) {
    var _this2 = this;

    fileIDs.forEach(function (id) {
      var file = _this2.uppy.getFile(id);

      _this2.uppy.emit('preprocess-progress', file, {
        mode: 'determinate',
        message: _this2.i18n('preparingUpload'),
        value: 0
      });
    }); // Wrapping rate-limited opts.getUploadParameters in a Promise takes some boilerplate!

    var getUploadParameters = this.requests.wrapPromiseFunction(function (file) {
      return _this2.opts.getUploadParameters(file);
    });
    return Promise.all(fileIDs.map(function (id) {
      var file = _this2.uppy.getFile(id);

      return getUploadParameters(file).then(function (params) {
        return _this2.validateParameters(file, params);
      }).then(function (params) {
        _this2.uppy.emit('preprocess-progress', file, {
          mode: 'determinate',
          message: _this2.i18n('preparingUpload'),
          value: 1
        });

        return params;
      }).catch(function (error) {
        _this2.uppy.emit('upload-error', file, error);
      });
    })).then(function (responses) {
      var updatedFiles = {};
      fileIDs.forEach(function (id, index) {
        var file = _this2.uppy.getFile(id);

        if (!file || file.error) {
          return;
        }

        var _responses$index = responses[index],
            _responses$index$meth = _responses$index.method,
            method = _responses$index$meth === void 0 ? 'post' : _responses$index$meth,
            url = _responses$index.url,
            fields = _responses$index.fields,
            headers = _responses$index.headers;
        var xhrOpts = {
          method: method,
          formData: method.toLowerCase() === 'post',
          endpoint: url,
          metaFields: fields ? Object.keys(fields) : []
        };

        if (headers) {
          xhrOpts.headers = headers;
        }

        var updatedFile = _extends({}, file, {
          meta: _extends({}, file.meta, {}, fields),
          xhrUpload: xhrOpts
        });

        updatedFiles[id] = updatedFile;
      });

      var _this2$uppy$getState = _this2.uppy.getState(),
          files = _this2$uppy$getState.files;

      _this2.uppy.setState({
        files: _extends({}, files, {}, updatedFiles)
      });

      fileIDs.forEach(function (id) {
        var file = _this2.uppy.getFile(id);

        _this2.uppy.emit('preprocess-complete', file);
      });
    });
  };

  _proto.install = function install() {
    var log = this.uppy.log;
    this.uppy.addPreProcessor(this.prepareUpload);
    var warnedSuccessActionStatus = false;
    var xhrUploadOpts = {
      fieldName: 'file',
      responseUrlFieldName: 'location',
      timeout: this.opts.timeout,
      __queue: this.requests,
      responseType: 'text',
      // Get the response data from a successful XMLHttpRequest instance.
      // `content` is the S3 response as a string.
      // `xhr` is the XMLHttpRequest instance.
      getResponseData: function getResponseData(content, xhr) {
        var opts = this; // If no response, we've hopefully done a PUT request to the file
        // in the bucket on its full URL.

        if (!isXml(xhr)) {
          if (opts.method.toUpperCase() === 'POST') {
            if (!warnedSuccessActionStatus) {
              log('[AwsS3] No response data found, make sure to set the success_action_status AWS SDK option to 201. See https://uppy.io/docs/aws-s3/#POST-Uploads', 'warning');
              warnedSuccessActionStatus = true;
            } // The responseURL won't contain the object key. Give up.


            return {
              location: null
            };
          } // responseURL is not available in older browsers.


          if (!xhr.responseURL) {
            return {
              location: null
            };
          } // Trim the query string because it's going to be a bunch of presign
          // parameters for a PUT request—doing a GET request with those will
          // always result in an error


          return {
            location: xhr.responseURL.replace(/\?.*$/, '')
          };
        }

        return {
          // Some S3 alternatives do not reply with an absolute URL.
          // Eg DigitalOcean Spaces uses /$bucketName/xyz
          location: resolveUrl(xhr.responseURL, getXmlValue(content, 'Location')),
          bucket: getXmlValue(content, 'Bucket'),
          key: getXmlValue(content, 'Key'),
          etag: getXmlValue(content, 'ETag')
        };
      },
      // Get the error data from a failed XMLHttpRequest instance.
      // `content` is the S3 response as a string.
      // `xhr` is the XMLHttpRequest instance.
      getResponseError: function getResponseError(content, xhr) {
        // If no response, we don't have a specific error message, use the default.
        if (!isXml(xhr)) {
          return;
        }

        var error = getXmlValue(content, 'Message');
        return new Error(error);
      }
    }; // Replace getResponseData() with overwritten version.

    if (this.opts.getResponseData) {
      xhrUploadOpts.getResponseData = this.opts.getResponseData;
    }

    this.uppy.use(XHRUpload, xhrUploadOpts);
  };

  _proto.uninstall = function uninstall() {
    var uploader = this.uppy.getPlugin('XHRUpload');
    this.uppy.removePlugin(uploader);
    this.uppy.removePreProcessor(this.prepareUpload);
  };

  return AwsS3;
}(Plugin), _class.VERSION = "1.3.3", _temp);