import { RequestClient } from '@uppy/companion-client';
import { BasePlugin, type DefinePluginOpts, EventManager, type PluginOpts, type Uppy } from '@uppy/core';
import type { Body, Meta, RequestOptions, UppyFile } from '@uppy/utils';
import MultipartUploader from './MultipartUploader.js';
import type { MultipartUploadResultWithSignal, UploadPartBytesResult, UploadResult, UploadResultWithSignal } from './utils.js';
type PartUploadedCallback<M extends Meta, B extends Body> = (file: UppyFile<M, B>, part: {
    PartNumber: number;
    ETag: string;
}) => void;
declare module '@uppy/core' {
    interface UppyEventMap<M extends Meta, B extends Body> {
        's3-multipart:part-uploaded': PartUploadedCallback<M, B>;
    }
}
export interface AwsS3STSResponse {
    credentials: {
        AccessKeyId: string;
        SecretAccessKey: string;
        SessionToken: string;
        Expiration?: string;
    };
    bucket: string;
    region: string;
}
type MaybePromise<T> = T | Promise<T>;
type SignPartOptions = {
    uploadId: string;
    key: string;
    partNumber: number;
    body: Blob;
    signal?: AbortSignal;
};
export type AwsS3UploadParameters = {
    method: 'POST';
    url: string;
    fields: Record<string, string>;
    expires?: number;
    headers?: Record<string, string>;
} | {
    method?: 'PUT';
    url: string;
    fields?: Record<string, never>;
    expires?: number;
    headers?: Record<string, string>;
};
export interface AwsS3Part {
    PartNumber?: number;
    Size?: number;
    ETag?: string;
}
type AWSS3WithCompanion = {
    endpoint: ConstructorParameters<typeof RequestClient<any, any>>[1]['companionUrl'];
    headers?: ConstructorParameters<typeof RequestClient<any, any>>[1]['companionHeaders'];
    cookiesRule?: ConstructorParameters<typeof RequestClient<any, any>>[1]['companionCookiesRule'];
    getTemporarySecurityCredentials?: true;
};
type AWSS3WithoutCompanion = {
    getTemporarySecurityCredentials?: (options?: {
        signal?: AbortSignal;
    }) => MaybePromise<AwsS3STSResponse>;
    uploadPartBytes?: (options: {
        signature: AwsS3UploadParameters;
        body: FormData | Blob;
        size?: number;
        onProgress: any;
        onComplete: any;
        signal?: AbortSignal;
    }) => Promise<UploadPartBytesResult>;
};
type AWSS3NonMultipartWithCompanionMandatory = {};
type AWSS3NonMultipartWithoutCompanionMandatory<M extends Meta, B extends Body> = {
    getUploadParameters: (file: UppyFile<M, B>, options: RequestOptions) => MaybePromise<AwsS3UploadParameters>;
};
type AWSS3NonMultipartWithCompanion = AWSS3WithCompanion & AWSS3NonMultipartWithCompanionMandatory & {
    shouldUseMultipart: false;
};
type AWSS3NonMultipartWithoutCompanion<M extends Meta, B extends Body> = AWSS3WithoutCompanion & AWSS3NonMultipartWithoutCompanionMandatory<M, B> & {
    shouldUseMultipart: false;
};
type AWSS3MultipartWithoutCompanionMandatorySignPart<M extends Meta, B extends Body> = {
    signPart: (file: UppyFile<M, B>, opts: SignPartOptions) => MaybePromise<AwsS3UploadParameters>;
};
type AWSS3MultipartWithoutCompanionMandatory<M extends Meta, B extends Body> = {
    getChunkSize?: (file: {
        size: number;
    }) => number;
    createMultipartUpload: (file: UppyFile<M, B>) => MaybePromise<UploadResult>;
    listParts: (file: UppyFile<M, B>, opts: UploadResultWithSignal) => MaybePromise<AwsS3Part[]>;
    abortMultipartUpload: (file: UppyFile<M, B>, opts: UploadResultWithSignal) => MaybePromise<void>;
    completeMultipartUpload: (file: UppyFile<M, B>, opts: {
        uploadId: string;
        key: string;
        parts: AwsS3Part[];
        signal: AbortSignal;
    }) => MaybePromise<{
        location?: string;
    }>;
} & AWSS3MultipartWithoutCompanionMandatorySignPart<M, B>;
type AWSS3MultipartWithoutCompanion<M extends Meta, B extends Body> = AWSS3WithoutCompanion & AWSS3MultipartWithoutCompanionMandatory<M, B> & {
    shouldUseMultipart?: true;
};
type AWSS3MultipartWithCompanion<M extends Meta, B extends Body> = AWSS3WithCompanion & Partial<AWSS3MultipartWithoutCompanionMandatory<M, B>> & {
    shouldUseMultipart?: true;
};
type AWSS3MaybeMultipartWithCompanion<M extends Meta, B extends Body> = AWSS3WithCompanion & Partial<AWSS3MultipartWithoutCompanionMandatory<M, B>> & AWSS3NonMultipartWithCompanionMandatory & {
    shouldUseMultipart: (file: UppyFile<M, B>) => boolean;
};
type AWSS3MaybeMultipartWithoutCompanion<M extends Meta, B extends Body> = AWSS3WithoutCompanion & AWSS3MultipartWithoutCompanionMandatory<M, B> & AWSS3NonMultipartWithoutCompanionMandatory<M, B> & {
    shouldUseMultipart: (file: UppyFile<M, B>) => boolean;
};
interface _AwsS3MultipartOptions extends PluginOpts {
    allowedMetaFields?: string[] | boolean;
    limit?: number;
    retryDelays?: number[] | null;
}
export type AwsS3MultipartOptions<M extends Meta, B extends Body> = _AwsS3MultipartOptions & (AWSS3NonMultipartWithCompanion | AWSS3NonMultipartWithoutCompanion<M, B> | AWSS3MultipartWithCompanion<M, B> | AWSS3MultipartWithoutCompanion<M, B> | AWSS3MaybeMultipartWithCompanion<M, B> | AWSS3MaybeMultipartWithoutCompanion<M, B>);
export type { AwsS3MultipartOptions as AwsS3Options };
declare const defaultOptions: {
    allowedMetaFields: true;
    limit: number;
    getTemporarySecurityCredentials: any;
    shouldUseMultipart: true;
    retryDelays: number[];
};
export type { AwsBody } from './utils.js';
export default class AwsS3Multipart<M extends Meta, B extends Body> extends BasePlugin<DefinePluginOpts<AwsS3MultipartOptions<M, B>, keyof typeof defaultOptions> & Pick<AWSS3MultipartWithoutCompanionMandatory<M, B>, 'getChunkSize' | 'createMultipartUpload' | 'listParts' | 'abortMultipartUpload' | 'completeMultipartUpload'> & Required<Pick<AWSS3WithoutCompanion, 'uploadPartBytes'>> & Partial<AWSS3WithCompanion> & AWSS3MultipartWithoutCompanionMandatorySignPart<M, B> & AWSS3NonMultipartWithoutCompanionMandatory<M, B>, M, B> {
    #private;
    static VERSION: string;
    protected requests: any;
    protected uploaderEvents: Record<string, EventManager<M, B> | null>;
    protected uploaders: Record<string, MultipartUploader<M, B> | null>;
    constructor(uppy: Uppy<M, B>, opts?: AwsS3MultipartOptions<M, B>);
    setOptions(newOptions: Partial<AwsS3MultipartOptions<M, B>>): void;
    /**
     * Clean up all references for a file's upload: the MultipartUploader instance,
     * any events related to the file, and the Companion WebSocket connection.
     *
     * Set `opts.abort` to tell S3 that the multipart upload is cancelled and must be removed.
     * This should be done when the user cancels the upload, not when the upload is completed or errored.
     */
    resetUploaderReferences(fileID: string, opts?: {
        abort: boolean;
    }): void;
    createMultipartUpload(file: UppyFile<M, B>, signal?: AbortSignal): Promise<UploadResult>;
    listParts(file: UppyFile<M, B>, { key, uploadId, signal }: UploadResultWithSignal, oldSignal?: AbortSignal): Promise<AwsS3Part[]>;
    completeMultipartUpload(file: UppyFile<M, B>, { key, uploadId, parts, signal }: MultipartUploadResultWithSignal, oldSignal?: AbortSignal): Promise<B>;
    createSignedURL(file: UppyFile<M, B>, options: SignPartOptions): Promise<AwsS3UploadParameters>;
    signPart(file: UppyFile<M, B>, { uploadId, key, partNumber, signal }: SignPartOptions): Promise<AwsS3UploadParameters>;
    abortMultipartUpload(file: UppyFile<M, B>, { key, uploadId, signal }: UploadResultWithSignal): Promise<void>;
    getUploadParameters(file: UppyFile<M, B>, options: RequestOptions): Promise<AwsS3UploadParameters>;
    static uploadPartBytes({ signature: { url, expires, headers, method }, body, size, onProgress, onComplete, signal, }: {
        signature: AwsS3UploadParameters;
        body: FormData | Blob;
        size?: number;
        onProgress: any;
        onComplete: any;
        signal?: AbortSignal;
    }): Promise<UploadPartBytesResult>;
    install(): void;
    uninstall(): void;
}
export type uploadPartBytes = (typeof AwsS3Multipart<any, any>)['uploadPartBytes'];
//# sourceMappingURL=index.d.ts.map