import { Provider, tokenStorage, type CompanionPluginOptions } from '@uppy/companion-client';
import { UIPlugin, Uppy } from '@uppy/core';
import { ProviderViews } from '@uppy/provider-views';
import { h, type ComponentChild } from 'preact';
import type { UppyFile, Body, Meta } from '@uppy/utils/lib/UppyFile';
import type { UnknownProviderPluginState } from '@uppy/core/lib/Uppy.js';
export type BoxOptions = CompanionPluginOptions;
export default class Box<M extends Meta, B extends Body> extends UIPlugin<BoxOptions, M, B, UnknownProviderPluginState> {
    static VERSION: any;
    icon: () => h.JSX.Element;
    provider: Provider<M, B>;
    view: ProviderViews<M, B>;
    storage: typeof tokenStorage;
    files: UppyFile<M, B>[];
    rootFolderId: string | null;
    constructor(uppy: Uppy<M, B>, opts: BoxOptions);
    install(): void;
    uninstall(): void;
    render(state: unknown): ComponentChild;
}
//# sourceMappingURL=Box.d.ts.map