'use strict';

var _class, _temp;

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var AuthError = require('./AuthError');

var fetchWithNetworkError = require('@uppy/utils/lib/fetchWithNetworkError'); // Remove the trailing slash so we can always safely append /xyz.


function stripSlash(url) {
  return url.replace(/\/$/, '');
}

module.exports = (_temp = _class = /*#__PURE__*/function () {
  function RequestClient(uppy, opts) {
    this.uppy = uppy;
    this.opts = opts;
    this.onReceiveResponse = this.onReceiveResponse.bind(this);
    this.allowedHeaders = ['accept', 'content-type', 'uppy-auth-token'];
    this.preflightDone = false;
  }

  var _proto = RequestClient.prototype;

  _proto.headers = function headers() {
    var userHeaders = this.opts.companionHeaders || this.opts.serverHeaders || {};
    return Promise.resolve(_extends({}, this.defaultHeaders, userHeaders));
  };

  _proto._getPostResponseFunc = function _getPostResponseFunc(skip) {
    var _this = this;

    return function (response) {
      if (!skip) {
        return _this.onReceiveResponse(response);
      }

      return response;
    };
  };

  _proto.onReceiveResponse = function onReceiveResponse(response) {
    var state = this.uppy.getState();
    var companion = state.companion || {};
    var host = this.opts.companionUrl;
    var headers = response.headers; // Store the self-identified domain name for the Companion instance we just hit.

    if (headers.has('i-am') && headers.get('i-am') !== companion[host]) {
      var _extends2;

      this.uppy.setState({
        companion: _extends({}, companion, (_extends2 = {}, _extends2[host] = headers.get('i-am'), _extends2))
      });
    }

    return response;
  };

  _proto._getUrl = function _getUrl(url) {
    if (/^(https?:|)\/\//.test(url)) {
      return url;
    }

    return this.hostname + "/" + url;
  };

  _proto._json = function _json(res) {
    if (res.status === 401) {
      throw new AuthError();
    }

    if (res.status < 200 || res.status > 300) {
      var errMsg = "Failed request with status: " + res.status + ". " + res.statusText;
      return res.json().then(function (errData) {
        errMsg = errData.message ? errMsg + " message: " + errData.message : errMsg;
        errMsg = errData.requestId ? errMsg + " request-Id: " + errData.requestId : errMsg;
        throw new Error(errMsg);
      }).catch(function () {
        throw new Error(errMsg);
      });
    }

    return res.json();
  };

  _proto.preflight = function preflight(path) {
    var _this2 = this;

    if (this.preflightDone) {
      return Promise.resolve(this.allowedHeaders.slice());
    }

    return fetch(this._getUrl(path), {
      method: 'OPTIONS'
    }).then(function (response) {
      if (response.headers.has('access-control-allow-headers')) {
        _this2.allowedHeaders = response.headers.get('access-control-allow-headers').split(',').map(function (headerName) {
          return headerName.trim().toLowerCase();
        });
      }

      _this2.preflightDone = true;
      return _this2.allowedHeaders.slice();
    }).catch(function (err) {
      _this2.uppy.log("[CompanionClient] unable to make preflight request " + err, 'warning');

      _this2.preflightDone = true;
      return _this2.allowedHeaders.slice();
    });
  };

  _proto.preflightAndHeaders = function preflightAndHeaders(path) {
    var _this3 = this;

    return Promise.all([this.preflight(path), this.headers()]).then(function (_ref) {
      var allowedHeaders = _ref[0],
          headers = _ref[1];
      // filter to keep only allowed Headers
      Object.keys(headers).forEach(function (header) {
        if (allowedHeaders.indexOf(header.toLowerCase()) === -1) {
          _this3.uppy.log("[CompanionClient] excluding unallowed header " + header);

          delete headers[header];
        }
      });
      return headers;
    });
  };

  _proto.get = function get(path, skipPostResponse) {
    var _this4 = this;

    return this.preflightAndHeaders(path).then(function (headers) {
      return fetchWithNetworkError(_this4._getUrl(path), {
        method: 'get',
        headers: headers,
        credentials: 'same-origin'
      });
    }).then(this._getPostResponseFunc(skipPostResponse)).then(function (res) {
      return _this4._json(res);
    }).catch(function (err) {
      err = err.isAuthError ? err : new Error("Could not get " + _this4._getUrl(path) + ". " + err);
      return Promise.reject(err);
    });
  };

  _proto.post = function post(path, data, skipPostResponse) {
    var _this5 = this;

    return this.preflightAndHeaders(path).then(function (headers) {
      return fetchWithNetworkError(_this5._getUrl(path), {
        method: 'post',
        headers: headers,
        credentials: 'same-origin',
        body: JSON.stringify(data)
      });
    }).then(this._getPostResponseFunc(skipPostResponse)).then(function (res) {
      return _this5._json(res);
    }).catch(function (err) {
      err = err.isAuthError ? err : new Error("Could not post " + _this5._getUrl(path) + ". " + err);
      return Promise.reject(err);
    });
  };

  _proto.delete = function _delete(path, data, skipPostResponse) {
    var _this6 = this;

    return this.preflightAndHeaders(path).then(function (headers) {
      return fetchWithNetworkError(_this6.hostname + "/" + path, {
        method: 'delete',
        headers: headers,
        credentials: 'same-origin',
        body: data ? JSON.stringify(data) : null
      });
    }).then(this._getPostResponseFunc(skipPostResponse)).then(function (res) {
      return _this6._json(res);
    }).catch(function (err) {
      err = err.isAuthError ? err : new Error("Could not delete " + _this6._getUrl(path) + ". " + err);
      return Promise.reject(err);
    });
  };

  _createClass(RequestClient, [{
    key: "hostname",
    get: function get() {
      var _this$uppy$getState = this.uppy.getState(),
          companion = _this$uppy$getState.companion;

      var host = this.opts.companionUrl;
      return stripSlash(companion && companion[host] ? companion[host] : host);
    }
  }, {
    key: "defaultHeaders",
    get: function get() {
      return {
        Accept: 'application/json',
        'Content-Type': 'application/json',
        'Uppy-Versions': "@uppy/companion-client=" + RequestClient.VERSION
      };
    }
  }]);

  return RequestClient;
}(), _class.VERSION = "1.6.0", _temp);