import { BasePlugin, Uppy } from '@uppy/core';
import CompressorJS from 'compressorjs';
import type { Body, Meta, UppyFile } from '@uppy/utils/lib/UppyFile';
import type { DefinePluginOpts, PluginOpts } from '@uppy/core';
declare module '@uppy/core' {
    interface UppyEventMap<M extends Meta, B extends Body> {
        'compressor:complete': (file: UppyFile<M, B>[]) => void;
    }
}
export interface CompressorOpts extends PluginOpts, CompressorJS.Options {
    limit?: number;
}
export type { CompressorOpts as CompressorOptions };
declare const defaultOptions: {
    quality: number;
    limit: number;
};
export default class Compressor<M extends Meta, B extends Body> extends BasePlugin<DefinePluginOpts<CompressorOpts, keyof typeof defaultOptions>, M, B> {
    #private;
    constructor(uppy: Uppy<M, B>, opts?: CompressorOpts);
    compress(blob: Blob): Promise<Blob | File>;
    prepareUpload(fileIDs: string[]): Promise<void>;
    install(): void;
    uninstall(): void;
}
//# sourceMappingURL=index.d.ts.map