var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var getFileNameAndExtension = require('@uppy/utils/lib/getFileNameAndExtension');
var truncateString = require('../utils/truncateString');
var copyToClipboard = require('../utils/copyToClipboard');
var prettyBytes = require('prettier-bytes');
var FileItemProgress = require('./FileItemProgress');
var getFileTypeIcon = require('../utils/getFileTypeIcon');
var FilePreview = require('./FilePreview');

var _require = require('./icons'),
    iconRetry = _require.iconRetry;

var classNames = require('classnames');

var _require2 = require('preact'),
    h = _require2.h;

function FileItemProgressWrapper(props) {
  if (props.hideRetryButton && props.error) {
    return;
  }

  if (props.isUploaded || props.hidePauseResumeCancelButtons && !props.error) {
    return h(
      'div',
      { 'class': 'uppy-DashboardItem-progressIndicator' },
      h(FileItemProgress, {
        progress: props.file.progress.percentage,
        fileID: props.file.id,
        hidePauseResumeCancelButtons: props.hidePauseResumeCancelButtons,
        individualCancellation: props.individualCancellation
      })
    );
  }

  return h(
    'button',
    {
      'class': 'uppy-DashboardItem-progressIndicator',
      type: 'button',
      'aria-label': props.progressIndicatorTitle,
      title: props.progressIndicatorTitle,
      onclick: props.onPauseResumeCancelRetry },
    props.error ? props.hideRetryButton ? null : iconRetry() : h(FileItemProgress, {
      progress: props.file.progress.percentage,
      fileID: props.file.id,
      individualCancellation: props.individualCancellation,
      hidePauseResumeCancelButtons: props.hidePauseResumeCancelButtons
    })
  );
}

module.exports = function FileItem(props) {
  var file = props.file;
  var acquirers = props.acquirers;

  var isProcessing = file.progress.preprocess || file.progress.postprocess;
  var isUploaded = file.progress.uploadComplete && !isProcessing && !file.error;
  var uploadInProgressOrComplete = file.progress.uploadStarted || isProcessing;
  var uploadInProgress = file.progress.uploadStarted && !file.progress.uploadComplete || isProcessing;
  var isPaused = file.isPaused || false;
  var error = file.error || false;

  var fileName = getFileNameAndExtension(file.meta.name).name;
  var truncatedFileName = props.isWide ? truncateString(fileName, 30) : fileName;

  function onPauseResumeCancelRetry(ev) {
    if (isUploaded) return;

    if (error && !props.hideRetryButton) {
      props.retryUpload(file.id);
      return;
    }

    if (props.hidePauseResumeCancelButtons) {
      return;
    }

    if (props.resumableUploads) {
      props.pauseUpload(file.id);
    } else if (props.individualCancellation) {
      props.cancelUpload(file.id);
    }
  }

  function progressIndicatorTitle(props) {
    if (isUploaded) {
      return props.i18n('uploadComplete');
    }

    if (error) {
      return props.i18n('retryUpload');
    }

    if (props.resumableUploads) {
      if (file.isPaused) {
        return props.i18n('resumeUpload');
      }
      return props.i18n('pauseUpload');
    } else if (props.individualCancellation) {
      return props.i18n('cancelUpload');
    }

    return '';
  }

  var dashboardItemClass = classNames('uppy-DashboardItem', { 'is-inprogress': uploadInProgress }, { 'is-processing': isProcessing }, { 'is-complete': isUploaded }, { 'is-paused': isPaused }, { 'is-error': error }, { 'is-resumable': props.resumableUploads }, { 'is-noIndividualCancellation': !props.individualCancellation });

  var showRemoveButton = props.individualCancellation ? !isUploaded : !uploadInProgress && !isUploaded;

  return h(
    'li',
    { 'class': dashboardItemClass, id: 'uppy_' + file.id, title: file.meta.name },
    h(
      'div',
      { 'class': 'uppy-DashboardItem-preview' },
      h(
        'div',
        { 'class': 'uppy-DashboardItem-previewInnerWrap', style: { backgroundColor: getFileTypeIcon(file.type).color } },
        props.showLinkToFileUploadResult && file.uploadURL ? h('a', { 'class': 'uppy-DashboardItem-previewLink', href: file.uploadURL, rel: 'noreferrer noopener', target: '_blank' }) : null,
        h(FilePreview, { file: file })
      ),
      h(
        'div',
        { 'class': 'uppy-DashboardItem-progress' },
        h(FileItemProgressWrapper, _extends({
          progressIndicatorTitle: progressIndicatorTitle(props),
          onPauseResumeCancelRetry: onPauseResumeCancelRetry,
          file: file,
          error: error
        }, props))
      )
    ),
    h(
      'div',
      { 'class': 'uppy-DashboardItem-info' },
      h(
        'div',
        { 'class': 'uppy-DashboardItem-name', title: fileName },
        props.showLinkToFileUploadResult && file.uploadURL ? h(
          'a',
          { href: file.uploadURL, rel: 'noreferrer noopener', target: '_blank' },
          file.extension ? truncatedFileName + '.' + file.extension : truncatedFileName
        ) : file.extension ? truncatedFileName + '.' + file.extension : truncatedFileName
      ),
      h(
        'div',
        { 'class': 'uppy-DashboardItem-status' },
        file.data.size ? h(
          'div',
          { 'class': 'uppy-DashboardItem-statusSize' },
          prettyBytes(file.data.size)
        ) : null,
        file.source && file.source !== props.id && h(
          'div',
          { 'class': 'uppy-DashboardItem-sourceIcon' },
          acquirers.map(function (acquirer) {
            if (acquirer.id === file.source) {
              return h(
                'span',
                { title: props.i18n('fileSource', { name: acquirer.name }) },
                acquirer.icon()
              );
            }
          })
        ),
        !uploadInProgressOrComplete && props.metaFields && props.metaFields.length ? h(
          'button',
          { 'class': 'uppy-u-reset uppy-DashboardItem-edit',
            type: 'button',
            'aria-label': props.i18n('editFile'),
            title: props.i18n('editFile'),
            onclick: function onclick(e) {
              return props.toggleFileCard(file.id);
            } },
          props.i18n('edit')
        ) : null,
        props.showLinkToFileUploadResult && file.uploadURL ? h(
          'button',
          { 'class': 'uppy-u-reset uppy-DashboardItem-copyLink',
            type: 'button',
            'aria-label': props.i18n('copyLink'),
            title: props.i18n('copyLink'),
            onclick: function onclick() {
              copyToClipboard(file.uploadURL, props.i18n('copyLinkToClipboardFallback')).then(function () {
                props.log('Link copied to clipboard.');
                props.info(props.i18n('copyLinkToClipboardSuccess'), 'info', 3000);
              }).catch(props.log);
            } },
          props.i18n('link')
        ) : ''
      )
    ),
    h(
      'div',
      { 'class': 'uppy-DashboardItem-action' },
      showRemoveButton && h(
        'button',
        { 'class': 'uppy-DashboardItem-remove',
          type: 'button',
          'aria-label': props.i18n('removeFile'),
          title: props.i18n('removeFile'),
          onclick: function onclick() {
            return props.removeFile(file.id);
          } },
        h(
          'svg',
          { 'aria-hidden': 'true', 'class': 'UppyIcon', width: '18', height: '18', viewBox: '0 0 18 18' },
          h('path', { d: 'M9 0C4.034 0 0 4.034 0 9s4.034 9 9 9 9-4.034 9-9-4.034-9-9-9z' }),
          h('path', { fill: '#FFF', d: 'M13 12.222l-.778.778L9 9.778 5.778 13 5 12.222 8.222 9 5 5.778 5.778 5 9 8.222 12.222 5l.778.778L9.778 9z' })
        )
      )
    )
  );
};