var _require = require('preact'),
    h = _require.h;

var classNames = require('classnames');

var AddFiles = require('./AddFiles');

var AddFilesPanel = function AddFilesPanel(props) {
  return h("div", {
    className: classNames('uppy-Dashboard-AddFilesPanel', props.className),
    "data-uppy-panelType": "AddFiles",
    "aria-hidden": props.showAddFilesPanel
  }, h("div", {
    className: "uppy-DashboardContent-bar"
  }, h("div", {
    className: "uppy-DashboardContent-title",
    role: "heading",
    "aria-level": "1"
  }, props.i18n('addingMoreFiles')), h("button", {
    className: "uppy-DashboardContent-back",
    type: "button",
    onClick: function onClick(ev) {
      return props.toggleAddFilesPanel(false);
    }
  }, props.i18n('back'))), h(AddFiles, props));
};

module.exports = AddFilesPanel;