var _require = require('preact'),
    h = _require.h;

var classNames = require('classnames');

function EditorPanel(props) {
  var file = this.props.files[this.props.fileCardFor];
  return h("div", {
    className: classNames('uppy-DashboardContent-panel', props.className),
    role: "tabpanel",
    "data-uppy-panelType": "FileEditor",
    id: "uppy-DashboardContent-panel--editor"
  }, h("div", {
    className: "uppy-DashboardContent-bar"
  }, h("div", {
    className: "uppy-DashboardContent-title",
    role: "heading",
    "aria-level": "1"
  }, props.i18nArray('editing', {
    file: h("span", {
      className: "uppy-DashboardContent-titleFile"
    }, file.meta ? file.meta.name : file.name)
  })), h("button", {
    className: "uppy-DashboardContent-back",
    type: "button",
    onClick: props.hideAllPanels
  }, props.i18n('done'))), h("div", {
    className: "uppy-DashboardContent-panelBody"
  }, props.editors.map(function (target) {
    return props.getPlugin(target.id).render(props.state);
  })));
}

module.exports = EditorPanel;