function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _require = require('preact'),
    h = _require.h,
    Component = _require.Component;

var classNames = require('classnames');

var getFileTypeIcon = require('../../utils/getFileTypeIcon');

var ignoreEvent = require('../../utils/ignoreEvent.js');

var FilePreview = require('../FilePreview');

var FileCard = /*#__PURE__*/function (_Component) {
  _inheritsLoose(FileCard, _Component);

  function FileCard(props) {
    var _this;

    _this = _Component.call(this, props) || this;

    _this.saveOnEnter = function (ev) {
      if (ev.keyCode === 13) {
        ev.stopPropagation();
        ev.preventDefault();
        var file = _this.props.files[_this.props.fileCardFor];

        _this.props.saveFileCard(_this.state.formState, file.id);
      }
    };

    _this.updateMeta = function (newVal, name) {
      var _extends2;

      _this.setState({
        formState: _extends({}, _this.state.formState, (_extends2 = {}, _extends2[name] = newVal, _extends2))
      });
    };

    _this.handleSave = function () {
      var fileID = _this.props.fileCardFor;

      _this.props.saveFileCard(_this.state.formState, fileID);
    };

    _this.handleCancel = function () {
      _this.props.toggleFileCard(false);
    };

    _this.renderMetaFields = function () {
      var metaFields = _this.getMetaFields() || [];
      var fieldCSSClasses = {
        text: 'uppy-u-reset uppy-c-textInput uppy-Dashboard-FileCard-input'
      };
      return metaFields.map(function (field) {
        var id = "uppy-Dashboard-FileCard-input-" + field.id;
        return h("fieldset", {
          key: field.id,
          className: "uppy-Dashboard-FileCard-fieldset"
        }, h("label", {
          className: "uppy-Dashboard-FileCard-label",
          htmlFor: id
        }, field.name), field.render !== undefined ? field.render({
          value: _this.state.formState[field.id],
          onChange: function onChange(newVal) {
            return _this.updateMeta(newVal, field.id);
          },
          fieldCSSClasses: fieldCSSClasses
        }, h) : h("input", {
          className: fieldCSSClasses.text,
          id: id,
          type: field.type || 'text',
          value: _this.state.formState[field.id],
          placeholder: field.placeholder,
          onKeyUp: _this.saveOnEnter,
          onKeyDown: _this.saveOnEnter,
          onKeyPress: _this.saveOnEnter,
          onInput: function onInput(ev) {
            return _this.updateMeta(ev.target.value, field.id);
          },
          "data-uppy-super-focusable": true
        }));
      });
    };

    var _file = _this.props.files[_this.props.fileCardFor];

    var _metaFields = _this.getMetaFields() || [];

    var storedMetaData = {};

    _metaFields.forEach(function (field) {
      storedMetaData[field.id] = _file.meta[field.id] || '';
    });

    _this.state = {
      formState: storedMetaData
    };
    return _this;
  }

  var _proto = FileCard.prototype;

  _proto.getMetaFields = function getMetaFields() {
    return typeof this.props.metaFields === 'function' ? this.props.metaFields(this.props.files[this.props.fileCardFor]) : this.props.metaFields;
  };

  _proto.render = function render() {
    var _this2 = this;

    var file = this.props.files[this.props.fileCardFor];
    var showEditButton = this.props.canEditFile(file);
    return h("div", {
      className: classNames('uppy-Dashboard-FileCard', this.props.className),
      "data-uppy-panelType": "FileCard",
      onDragOver: ignoreEvent,
      onDragLeave: ignoreEvent,
      onDrop: ignoreEvent,
      onPaste: ignoreEvent
    }, h("div", {
      className: "uppy-DashboardContent-bar"
    }, h("div", {
      className: "uppy-DashboardContent-title",
      role: "heading",
      "aria-level": "1"
    }, this.props.i18nArray('editing', {
      file: h("span", {
        className: "uppy-DashboardContent-titleFile"
      }, file.meta ? file.meta.name : file.name)
    })), h("button", {
      className: "uppy-DashboardContent-back",
      type: "button",
      title: this.props.i18n('finishEditingFile'),
      onClick: this.handleSave
    }, this.props.i18n('done'))), h("div", {
      className: "uppy-Dashboard-FileCard-inner"
    }, h("div", {
      className: "uppy-Dashboard-FileCard-preview",
      style: {
        backgroundColor: getFileTypeIcon(file.type).color
      }
    }, h(FilePreview, {
      file: file
    }), showEditButton && h("button", {
      type: "button",
      className: "uppy-u-reset uppy-c-btn uppy-Dashboard-FileCard-edit",
      onClick: function onClick() {
        return _this2.props.openFileEditor(file);
      }
    }, this.props.i18n('editFile'))), h("div", {
      className: "uppy-Dashboard-FileCard-info"
    }, this.renderMetaFields()), h("div", {
      className: "uppy-Dashboard-FileCard-actions"
    }, h("button", {
      className: "uppy-u-reset uppy-c-btn uppy-c-btn-primary uppy-Dashboard-FileCard-actionsBtn",
      type: "button",
      onClick: this.handleSave
    }, this.props.i18n('saveChanges')), h("button", {
      className: "uppy-u-reset uppy-c-btn uppy-c-btn-link uppy-Dashboard-FileCard-actionsBtn",
      type: "button",
      onClick: this.handleCancel
    }, this.props.i18n('cancel')))));
  };

  return FileCard;
}(Component);

module.exports = FileCard;