function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _require = require('preact'),
    cloneElement = _require.cloneElement,
    Component = _require.Component;

var classNames = require('classnames');

var transitionName = 'uppy-transition-slideDownUp';
var duration = 250;
/**
 * Vertical slide transition.
 *
 * This can take a _single_ child component, which _must_ accept a `className` prop.
 *
 * Currently this is specific to the `uppy-transition-slideDownUp` transition,
 * but it should be simple to extend this for any type of single-element
 * transition by setting the CSS name and duration as props.
 */

var Slide = /*#__PURE__*/function (_Component) {
  _inheritsLoose(Slide, _Component);

  function Slide(props) {
    var _this;

    _this = _Component.call(this, props) || this;
    _this.state = {
      cachedChildren: null,
      className: ''
    };
    return _this;
  }

  var _proto = Slide.prototype;

  _proto.componentWillUpdate = function componentWillUpdate(nextProps) {
    var _this2 = this;

    var cachedChildren = this.state.cachedChildren;
    var child = nextProps.children[0];
    if (cachedChildren === child) return;
    var patch = {
      cachedChildren: child
    }; // Enter transition

    if (child && !cachedChildren) {
      patch.className = transitionName + "-enter";
      cancelAnimationFrame(this.animationFrame);
      clearTimeout(this.leaveTimeout);
      this.leaveTimeout = undefined;
      this.animationFrame = requestAnimationFrame(function () {
        // Force it to render before we add the active class
        _this2.base.getBoundingClientRect();

        _this2.setState({
          className: transitionName + "-enter " + transitionName + "-enter-active"
        });

        _this2.enterTimeout = setTimeout(function () {
          _this2.setState({
            className: ''
          });
        }, duration);
      });
    } // Leave transition


    if (cachedChildren && !child && this.leaveTimeout === undefined) {
      patch.cachedChildren = cachedChildren;
      patch.className = transitionName + "-leave";
      cancelAnimationFrame(this.animationFrame);
      clearTimeout(this.enterTimeout);
      this.enterTimeout = undefined;
      this.animationFrame = requestAnimationFrame(function () {
        _this2.setState({
          className: transitionName + "-leave " + transitionName + "-leave-active"
        });

        _this2.leaveTimeout = setTimeout(function () {
          _this2.setState({
            cachedChildren: null,
            className: ''
          });
        }, duration);
      });
    }

    this.setState(patch);
  };

  _proto.render = function render() {
    var _this$state = this.state,
        cachedChildren = _this$state.cachedChildren,
        className = _this$state.className;

    if (!cachedChildren) {
      return null;
    }

    return cloneElement(cachedChildren, {
      className: classNames(className, cachedChildren.attributes.className)
    });
  };

  return Slide;
}(Component);

module.exports = Slide;