var _class, _temp;

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var _require = require('preact'),
    h = _require.h;

var _require2 = require('@uppy/core'),
    Plugin = _require2.Plugin;

var Translator = require('@uppy/utils/lib/Translator');

var DashboardUI = require('./components/Dashboard');

var StatusBar = require('@uppy/status-bar');

var Informer = require('@uppy/informer');

var ThumbnailGenerator = require('@uppy/thumbnail-generator');

var findAllDOMElements = require('@uppy/utils/lib/findAllDOMElements');

var toArray = require('@uppy/utils/lib/toArray');

var getDroppedFiles = require('@uppy/utils/lib/getDroppedFiles');

var getTextDirection = require('@uppy/utils/lib/getTextDirection');

var trapFocus = require('./utils/trapFocus');

var cuid = require('cuid');

var ResizeObserver = require('resize-observer-polyfill').default || require('resize-observer-polyfill');

var createSuperFocus = require('./utils/createSuperFocus');

var memoize = require('memoize-one').default || require('memoize-one');

var FOCUSABLE_ELEMENTS = require('@uppy/utils/lib/FOCUSABLE_ELEMENTS');

var TAB_KEY = 9;
var ESC_KEY = 27;

function createPromise() {
  var o = {};
  o.promise = new Promise(function (resolve, reject) {
    o.resolve = resolve;
    o.reject = reject;
  });
  return o;
}

function defaultPickerIcon() {
  return h("svg", {
    "aria-hidden": "true",
    focusable: "false",
    width: "30",
    height: "30",
    viewBox: "0 0 30 30"
  }, h("path", {
    d: "M15 30c8.284 0 15-6.716 15-15 0-8.284-6.716-15-15-15C6.716 0 0 6.716 0 15c0 8.284 6.716 15 15 15zm4.258-12.676v6.846h-8.426v-6.846H5.204l9.82-12.364 9.82 12.364H19.26z"
  }));
}
/**
 * Dashboard UI with previews, metadata editing, tabs for various services and more
 */


module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin) {
  _inheritsLoose(Dashboard, _Plugin);

  function Dashboard(uppy, _opts) {
    var _this;

    _this = _Plugin.call(this, uppy, _opts) || this;

    _this.setOptions = function (newOpts) {
      _Plugin.prototype.setOptions.call(_assertThisInitialized(_this), newOpts);

      _this.i18nInit();
    };

    _this.i18nInit = function () {
      _this.translator = new Translator([_this.defaultLocale, _this.uppy.locale, _this.opts.locale]);
      _this.i18n = _this.translator.translate.bind(_this.translator);
      _this.i18nArray = _this.translator.translateArray.bind(_this.translator);

      _this.setPluginState(); // so that UI re-renders and we see the updated locale

    };

    _this.removeTarget = function (plugin) {
      var pluginState = _this.getPluginState(); // filter out the one we want to remove


      var newTargets = pluginState.targets.filter(function (target) {
        return target.id !== plugin.id;
      });

      _this.setPluginState({
        targets: newTargets
      });
    };

    _this.addTarget = function (plugin) {
      var callerPluginId = plugin.id || plugin.constructor.name;
      var callerPluginName = plugin.title || callerPluginId;
      var callerPluginType = plugin.type;

      if (callerPluginType !== 'acquirer' && callerPluginType !== 'progressindicator' && callerPluginType !== 'editor') {
        var msg = 'Dashboard: can only be targeted by plugins of types: acquirer, progressindicator, editor';

        _this.uppy.log(msg, 'error');

        return;
      }

      var target = {
        id: callerPluginId,
        name: callerPluginName,
        type: callerPluginType
      };

      var state = _this.getPluginState();

      var newTargets = state.targets.slice();
      newTargets.push(target);

      _this.setPluginState({
        targets: newTargets
      });

      return _this.el;
    };

    _this.hideAllPanels = function () {
      var update = {
        activePickerPanel: false,
        showAddFilesPanel: false,
        activeOverlayType: null,
        fileCardFor: null,
        showFileEditor: false
      };

      var current = _this.getPluginState();

      if (current.activePickerPanel === update.activePickerPanel && current.showAddFilesPanel === update.showAddFilesPanel && current.showFileEditor === update.showFileEditor && current.activeOverlayType === update.activeOverlayType) {
        // avoid doing a state update if nothing changed
        return;
      }

      _this.setPluginState(update);
    };

    _this.showPanel = function (id) {
      var _this$getPluginState = _this.getPluginState(),
          targets = _this$getPluginState.targets;

      var activePickerPanel = targets.filter(function (target) {
        return target.type === 'acquirer' && target.id === id;
      })[0];

      _this.setPluginState({
        activePickerPanel: activePickerPanel,
        activeOverlayType: 'PickerPanel'
      });
    };

    _this.canEditFile = function (file) {
      var _this$getPluginState2 = _this.getPluginState(),
          targets = _this$getPluginState2.targets;

      var editors = _this._getEditors(targets);

      return editors.some(function (target) {
        return _this.uppy.getPlugin(target.id).canEditFile(file);
      });
    };

    _this.openFileEditor = function (file) {
      var _this$getPluginState3 = _this.getPluginState(),
          targets = _this$getPluginState3.targets;

      var editors = _this._getEditors(targets);

      _this.setPluginState({
        showFileEditor: true,
        fileCardFor: file.id || null,
        activeOverlayType: 'FileEditor'
      });

      editors.forEach(function (editor) {
        _this.uppy.getPlugin(editor.id).selectFile(file);
      });
    };

    _this.openModal = function () {
      var _createPromise = createPromise(),
          promise = _createPromise.promise,
          resolve = _createPromise.resolve; // save scroll position


      _this.savedScrollPosition = window.pageYOffset; // save active element, so we can restore focus when modal is closed

      _this.savedActiveElement = document.activeElement;

      if (_this.opts.disablePageScrollWhenModalOpen) {
        document.body.classList.add('uppy-Dashboard-isFixed');
      }

      if (_this.opts.animateOpenClose && _this.getPluginState().isClosing) {
        var handler = function handler() {
          _this.setPluginState({
            isHidden: false
          });

          _this.el.removeEventListener('animationend', handler, false);

          resolve();
        };

        _this.el.addEventListener('animationend', handler, false);
      } else {
        _this.setPluginState({
          isHidden: false
        });

        resolve();
      }

      if (_this.opts.browserBackButtonClose) {
        _this.updateBrowserHistory();
      } // handle ESC and TAB keys in modal dialog


      document.addEventListener('keydown', _this.handleKeyDownInModal);

      _this.uppy.emit('dashboard:modal-open');

      return promise;
    };

    _this.closeModal = function (opts) {
      if (opts === void 0) {
        opts = {};
      }

      var _opts2 = opts,
          _opts2$manualClose = _opts2.manualClose,
          manualClose = _opts2$manualClose === void 0 ? true : _opts2$manualClose;

      var _this$getPluginState4 = _this.getPluginState(),
          isHidden = _this$getPluginState4.isHidden,
          isClosing = _this$getPluginState4.isClosing;

      if (isHidden || isClosing) {
        // short-circuit if animation is ongoing
        return;
      }

      var _createPromise2 = createPromise(),
          promise = _createPromise2.promise,
          resolve = _createPromise2.resolve;

      if (_this.opts.disablePageScrollWhenModalOpen) {
        document.body.classList.remove('uppy-Dashboard-isFixed');
      }

      if (_this.opts.animateOpenClose) {
        _this.setPluginState({
          isClosing: true
        });

        var handler = function handler() {
          _this.setPluginState({
            isHidden: true,
            isClosing: false
          });

          _this.superFocus.cancel();

          _this.savedActiveElement.focus();

          _this.el.removeEventListener('animationend', handler, false);

          resolve();
        };

        _this.el.addEventListener('animationend', handler, false);
      } else {
        _this.setPluginState({
          isHidden: true
        });

        _this.superFocus.cancel();

        _this.savedActiveElement.focus();

        resolve();
      } // handle ESC and TAB keys in modal dialog


      document.removeEventListener('keydown', _this.handleKeyDownInModal);

      if (manualClose) {
        if (_this.opts.browserBackButtonClose) {
          // Make sure that the latest entry in the history state is our modal name
          if (history.state && history.state[_this.modalName]) {
            // Go back in history to clear out the entry we created (ultimately closing the modal)
            history.go(-1);
          }
        }
      }

      _this.uppy.emit('dashboard:modal-closed');

      return promise;
    };

    _this.isModalOpen = function () {
      return !_this.getPluginState().isHidden || false;
    };

    _this.requestCloseModal = function () {
      if (_this.opts.onRequestCloseModal) {
        return _this.opts.onRequestCloseModal();
      }

      return _this.closeModal();
    };

    _this.setDarkModeCapability = function (isDarkModeOn) {
      var _this$uppy$getState = _this.uppy.getState(),
          capabilities = _this$uppy$getState.capabilities;

      _this.uppy.setState({
        capabilities: _extends({}, capabilities, {
          darkMode: isDarkModeOn
        })
      });
    };

    _this.handleSystemDarkModeChange = function (event) {
      var isDarkModeOnNow = event.matches;

      _this.uppy.log("[Dashboard] Dark mode is " + (isDarkModeOnNow ? 'on' : 'off'));

      _this.setDarkModeCapability(isDarkModeOnNow);
    };

    _this.toggleFileCard = function (show, fileID) {
      var file = _this.uppy.getFile(fileID);

      if (show) {
        _this.uppy.emit('dashboard:file-edit-start', file);
      } else {
        _this.uppy.emit('dashboard:file-edit-complete', file);
      }

      _this.setPluginState({
        fileCardFor: show ? fileID : null,
        activeOverlayType: show ? 'FileCard' : null
      });
    };

    _this.toggleAddFilesPanel = function (show) {
      _this.setPluginState({
        showAddFilesPanel: show,
        activeOverlayType: show ? 'AddFiles' : null
      });
    };

    _this.addFiles = function (files) {
      var descriptors = files.map(function (file) {
        return {
          source: _this.id,
          name: file.name,
          type: file.type,
          data: file,
          meta: {
            // path of the file relative to the ancestor directory the user selected.
            // e.g. 'docs/Old Prague/airbnb.pdf'
            relativePath: file.relativePath || null
          }
        };
      });

      try {
        _this.uppy.addFiles(descriptors);
      } catch (err) {
        _this.uppy.log(err);
      }
    };

    _this.startListeningToResize = function () {
      // Watch for Dashboard container (`.uppy-Dashboard-inner`) resize
      // and update containerWidth/containerHeight in plugin state accordingly.
      // Emits first event on initialization.
      _this.resizeObserver = new ResizeObserver(function (entries, observer) {
        var uppyDashboardInnerEl = entries[0];
        var _uppyDashboardInnerEl = uppyDashboardInnerEl.contentRect,
            width = _uppyDashboardInnerEl.width,
            height = _uppyDashboardInnerEl.height;

        _this.uppy.log("[Dashboard] resized: " + width + " / " + height, 'debug');

        _this.setPluginState({
          containerWidth: width,
          containerHeight: height,
          areInsidesReadyToBeVisible: true
        });
      });

      _this.resizeObserver.observe(_this.el.querySelector('.uppy-Dashboard-inner')); // If ResizeObserver fails to emit an event telling us what size to use - default to the mobile view


      _this.makeDashboardInsidesVisibleAnywayTimeout = setTimeout(function () {
        var pluginState = _this.getPluginState();

        var isModalAndClosed = !_this.opts.inline && pluginState.isHidden;

        if ( // if ResizeObserver hasn't yet fired,
        !pluginState.areInsidesReadyToBeVisible // and it's not due to the modal being closed
        && !isModalAndClosed) {
          _this.uppy.log("[Dashboard] resize event didn't fire on time: defaulted to mobile layout", 'debug');

          _this.setPluginState({
            areInsidesReadyToBeVisible: true
          });
        }
      }, 1000);
    };

    _this.stopListeningToResize = function () {
      _this.resizeObserver.disconnect();

      clearTimeout(_this.makeDashboardInsidesVisibleAnywayTimeout);
    };

    _this.recordIfFocusedOnUppyRecently = function (event) {
      if (_this.el.contains(event.target)) {
        _this.ifFocusedOnUppyRecently = true;
      } else {
        _this.ifFocusedOnUppyRecently = false; // ___Why run this.superFocus.cancel here when it already runs in superFocusOnEachUpdate?
        //    Because superFocus is debounced, when we move from Uppy to some other element on the page,
        //    previously run superFocus sometimes hits and moves focus back to Uppy.

        _this.superFocus.cancel();
      }
    };

    _this.disableAllFocusableElements = function (disable) {
      var focusableNodes = toArray(_this.el.querySelectorAll(FOCUSABLE_ELEMENTS));

      if (disable) {
        focusableNodes.forEach(function (node) {
          // save previous tabindex in a data-attribute, to restore when enabling
          var currentTabIndex = node.getAttribute('tabindex');

          if (currentTabIndex) {
            node.dataset.inertTabindex = currentTabIndex;
          }

          node.setAttribute('tabindex', '-1');
        });
      } else {
        focusableNodes.forEach(function (node) {
          if ('inertTabindex' in node.dataset) {
            node.setAttribute('tabindex', node.dataset.inertTabindex);
          } else {
            node.removeAttribute('tabindex');
          }
        });
      }

      _this.dashboardIsDisabled = disable;
    };

    _this.updateBrowserHistory = function () {
      // Ensure history state does not already contain our modal name to avoid double-pushing
      if (!history.state || !history.state[_this.modalName]) {
        var _extends2;

        // Push to history so that the page is not lost on browser back button press
        history.pushState(_extends({}, history.state, (_extends2 = {}, _extends2[_this.modalName] = true, _extends2)), '');
      } // Listen for back button presses


      window.addEventListener('popstate', _this.handlePopState, false);
    };

    _this.handlePopState = function (event) {
      // Close the modal if the history state no longer contains our modal name
      if (_this.isModalOpen() && (!event.state || !event.state[_this.modalName])) {
        _this.closeModal({
          manualClose: false
        });
      } // When the browser back button is pressed and uppy is now the latest entry in the history but the modal is closed, fix the history by removing the uppy history entry
      // This occurs when another entry is added into the history state while the modal is open, and then the modal gets manually closed
      // Solves PR #575 (https://github.com/transloadit/uppy/pull/575)


      if (!_this.isModalOpen() && event.state && event.state[_this.modalName]) {
        history.go(-1);
      }
    };

    _this.handleKeyDownInModal = function (event) {
      // close modal on esc key press
      if (event.keyCode === ESC_KEY) _this.requestCloseModal(event); // trap focus on tab key press

      if (event.keyCode === TAB_KEY) trapFocus.forModal(event, _this.getPluginState().activeOverlayType, _this.el);
    };

    _this.handleClickOutside = function () {
      if (_this.opts.closeModalOnClickOutside) _this.requestCloseModal();
    };

    _this.handlePaste = function (event) {
      // 1. Let any acquirer plugin (Url/Webcam/etc.) handle pastes to the root
      _this.uppy.iteratePlugins(function (plugin) {
        if (plugin.type === 'acquirer') {
          // Every Plugin with .type acquirer can define handleRootPaste(event)
          plugin.handleRootPaste && plugin.handleRootPaste(event);
        }
      }); // 2. Add all dropped files


      var files = toArray(event.clipboardData.files);

      _this.addFiles(files);
    };

    _this.handleInputChange = function (event) {
      event.preventDefault();
      var files = toArray(event.target.files);

      _this.addFiles(files);
    };

    _this.handleDragOver = function (event) {
      event.preventDefault();
      event.stopPropagation();

      if (_this.opts.disabled || _this.opts.disableLocalFiles) {
        return;
      } // 1. Add a small (+) icon on drop
      // (and prevent browsers from interpreting this as files being _moved_ into the browser, https://github.com/transloadit/uppy/issues/1978)


      event.dataTransfer.dropEffect = 'copy';
      clearTimeout(_this.removeDragOverClassTimeout);

      _this.setPluginState({
        isDraggingOver: true
      });
    };

    _this.handleDragLeave = function (event) {
      event.preventDefault();
      event.stopPropagation();

      if (_this.opts.disabled || _this.opts.disableLocalFiles) {
        return;
      }

      clearTimeout(_this.removeDragOverClassTimeout); // Timeout against flickering, this solution is taken from drag-drop library. Solution with 'pointer-events: none' didn't work across browsers.

      _this.removeDragOverClassTimeout = setTimeout(function () {
        _this.setPluginState({
          isDraggingOver: false
        });
      }, 50);
    };

    _this.handleDrop = function (event, dropCategory) {
      event.preventDefault();
      event.stopPropagation();

      if (_this.opts.disabled || _this.opts.disableLocalFiles) {
        return;
      }

      clearTimeout(_this.removeDragOverClassTimeout); // 2. Remove dragover class

      _this.setPluginState({
        isDraggingOver: false
      }); // 3. Let any acquirer plugin (Url/Webcam/etc.) handle drops to the root


      _this.uppy.iteratePlugins(function (plugin) {
        if (plugin.type === 'acquirer') {
          // Every Plugin with .type acquirer can define handleRootDrop(event)
          plugin.handleRootDrop && plugin.handleRootDrop(event);
        }
      }); // 4. Add all dropped files


      var executedDropErrorOnce = false;

      var logDropError = function logDropError(error) {
        _this.uppy.log(error, 'error'); // In practice all drop errors are most likely the same, so let's just show one to avoid overwhelming the user


        if (!executedDropErrorOnce) {
          _this.uppy.info(error.message, 'error');

          executedDropErrorOnce = true;
        }
      };

      getDroppedFiles(event.dataTransfer, {
        logDropError: logDropError
      }).then(function (files) {
        if (files.length > 0) {
          _this.uppy.log('[Dashboard] Files were dropped');

          _this.addFiles(files);
        }
      });
    };

    _this.handleRequestThumbnail = function (file) {
      if (!_this.opts.waitForThumbnailsBeforeUpload) {
        _this.uppy.emit('thumbnail:request', file);
      }
    };

    _this.handleCancelThumbnail = function (file) {
      if (!_this.opts.waitForThumbnailsBeforeUpload) {
        _this.uppy.emit('thumbnail:cancel', file);
      }
    };

    _this.handleKeyDownInInline = function (event) {
      // Trap focus on tab key press.
      if (event.keyCode === TAB_KEY) trapFocus.forInline(event, _this.getPluginState().activeOverlayType, _this.el);
    };

    _this.handlePasteOnBody = function (event) {
      var isFocusInOverlay = _this.el.contains(document.activeElement);

      if (isFocusInOverlay) {
        _this.handlePaste(event);
      }
    };

    _this.handleComplete = function (_ref) {
      var failed = _ref.failed;

      if (_this.opts.closeAfterFinish && failed.length === 0) {
        // All uploads are done
        _this.requestCloseModal();
      }
    };

    _this.handleCancelRestore = function () {
      _this.uppy.emit('restore-canceled');
    };

    _this._openFileEditorWhenFilesAdded = function (files) {
      var firstFile = files[0];

      if (_this.canEditFile(firstFile)) {
        _this.openFileEditor(firstFile);
      }
    };

    _this.initEvents = function () {
      // Modal open button
      if (_this.opts.trigger && !_this.opts.inline) {
        var showModalTrigger = findAllDOMElements(_this.opts.trigger);

        if (showModalTrigger) {
          showModalTrigger.forEach(function (trigger) {
            return trigger.addEventListener('click', _this.openModal);
          });
        } else {
          _this.uppy.log('Dashboard modal trigger not found. Make sure `trigger` is set in Dashboard options, unless you are planning to call `dashboard.openModal()` method yourself', 'warning');
        }
      }

      _this.startListeningToResize();

      document.addEventListener('paste', _this.handlePasteOnBody);

      _this.uppy.on('plugin-remove', _this.removeTarget);

      _this.uppy.on('file-added', _this.hideAllPanels);

      _this.uppy.on('dashboard:modal-closed', _this.hideAllPanels);

      _this.uppy.on('file-editor:complete', _this.hideAllPanels);

      _this.uppy.on('complete', _this.handleComplete); // ___Why fire on capture?
      //    Because this.ifFocusedOnUppyRecently needs to change before onUpdate() fires.


      document.addEventListener('focus', _this.recordIfFocusedOnUppyRecently, true);
      document.addEventListener('click', _this.recordIfFocusedOnUppyRecently, true);

      if (_this.opts.inline) {
        _this.el.addEventListener('keydown', _this.handleKeyDownInInline);
      }

      if (_this.opts.autoOpenFileEditor) {
        _this.uppy.on('files-added', _this._openFileEditorWhenFilesAdded);
      }
    };

    _this.removeEvents = function () {
      var showModalTrigger = findAllDOMElements(_this.opts.trigger);

      if (!_this.opts.inline && showModalTrigger) {
        showModalTrigger.forEach(function (trigger) {
          return trigger.removeEventListener('click', _this.openModal);
        });
      }

      _this.stopListeningToResize();

      document.removeEventListener('paste', _this.handlePasteOnBody);
      window.removeEventListener('popstate', _this.handlePopState, false);

      _this.uppy.off('plugin-remove', _this.removeTarget);

      _this.uppy.off('file-added', _this.hideAllPanels);

      _this.uppy.off('dashboard:modal-closed', _this.hideAllPanels);

      _this.uppy.off('file-editor:complete', _this.hideAllPanels);

      _this.uppy.off('complete', _this.handleComplete);

      document.removeEventListener('focus', _this.recordIfFocusedOnUppyRecently);
      document.removeEventListener('click', _this.recordIfFocusedOnUppyRecently);

      if (_this.opts.inline) {
        _this.el.removeEventListener('keydown', _this.handleKeyDownInInline);
      }

      if (_this.opts.autoOpenFileEditor) {
        _this.uppy.off('files-added', _this._openFileEditorWhenFilesAdded);
      }
    };

    _this.superFocusOnEachUpdate = function () {
      var isFocusInUppy = _this.el.contains(document.activeElement); // When focus is lost on the page (== focus is on body for most browsers, or focus is null for IE11)


      var isFocusNowhere = document.activeElement === document.body || document.activeElement === null;

      var isInformerHidden = _this.uppy.getState().info.isHidden;

      var isModal = !_this.opts.inline;

      if ( // If update is connected to showing the Informer - let the screen reader calmly read it.
      isInformerHidden && ( // If we are in a modal - always superfocus without concern for other elements on the page (user is unlikely to want to interact with the rest of the page)
      isModal // If we are already inside of Uppy, or
      || isFocusInUppy // If we are not focused on anything BUT we have already, at least once, focused on uppy
      //   1. We focus when isFocusNowhere, because when the element we were focused on disappears (e.g. an overlay), - focus gets lost. If user is typing something somewhere else on the page, - focus won't be 'nowhere'.
      //   2. We only focus when focus is nowhere AND this.ifFocusedOnUppyRecently, to avoid focus jumps if we do something else on the page.
      //   [Practical check] Without '&& this.ifFocusedOnUppyRecently', in Safari, in inline mode, when file is uploading, - navigate via tab to the checkbox, try to press space multiple times. Focus will jump to Uppy.
      || isFocusNowhere && _this.ifFocusedOnUppyRecently)) {
        _this.superFocus(_this.el, _this.getPluginState().activeOverlayType);
      } else {
        _this.superFocus.cancel();
      }
    };

    _this.afterUpdate = function () {
      if (_this.opts.disabled && !_this.dashboardIsDisabled) {
        _this.disableAllFocusableElements(true);

        return;
      }

      if (!_this.opts.disabled && _this.dashboardIsDisabled) {
        _this.disableAllFocusableElements(false);
      }

      _this.superFocusOnEachUpdate();
    };

    _this.cancelUpload = function (fileID) {
      _this.uppy.removeFile(fileID);
    };

    _this.saveFileCard = function (meta, fileID) {
      _this.uppy.setFileMeta(fileID, meta);

      _this.toggleFileCard(false, fileID);
    };

    _this._attachRenderFunctionToTarget = function (target) {
      var plugin = _this.uppy.getPlugin(target.id);

      return _extends({}, target, {
        icon: plugin.icon || _this.opts.defaultPickerIcon,
        render: plugin.render
      });
    };

    _this._isTargetSupported = function (target) {
      var plugin = _this.uppy.getPlugin(target.id); // If the plugin does not provide a `supported` check, assume the plugin works everywhere.


      if (typeof plugin.isSupported !== 'function') {
        return true;
      }

      return plugin.isSupported();
    };

    _this._getAcquirers = memoize(function (targets) {
      return targets.filter(function (target) {
        return target.type === 'acquirer' && _this._isTargetSupported(target);
      }).map(_this._attachRenderFunctionToTarget);
    });
    _this._getProgressIndicators = memoize(function (targets) {
      return targets.filter(function (target) {
        return target.type === 'progressindicator';
      }).map(_this._attachRenderFunctionToTarget);
    });
    _this._getEditors = memoize(function (targets) {
      return targets.filter(function (target) {
        return target.type === 'editor';
      }).map(_this._attachRenderFunctionToTarget);
    });

    _this.render = function (state) {
      var pluginState = _this.getPluginState();

      var files = state.files,
          capabilities = state.capabilities,
          allowNewUpload = state.allowNewUpload; // TODO: move this to Core, to share between Status Bar and Dashboard
      // (and any other plugin that might need it, too)

      var newFiles = Object.keys(files).filter(function (file) {
        return !files[file].progress.uploadStarted;
      });
      var uploadStartedFiles = Object.keys(files).filter(function (file) {
        return files[file].progress.uploadStarted;
      });
      var pausedFiles = Object.keys(files).filter(function (file) {
        return files[file].isPaused;
      });
      var completeFiles = Object.keys(files).filter(function (file) {
        return files[file].progress.uploadComplete;
      });
      var erroredFiles = Object.keys(files).filter(function (file) {
        return files[file].error;
      });
      var inProgressFiles = Object.keys(files).filter(function (file) {
        return !files[file].progress.uploadComplete && files[file].progress.uploadStarted;
      });
      var inProgressNotPausedFiles = inProgressFiles.filter(function (file) {
        return !files[file].isPaused;
      });
      var processingFiles = Object.keys(files).filter(function (file) {
        return files[file].progress.preprocess || files[file].progress.postprocess;
      });
      var isUploadStarted = uploadStartedFiles.length > 0;
      var isAllComplete = state.totalProgress === 100 && completeFiles.length === Object.keys(files).length && processingFiles.length === 0;
      var isAllErrored = isUploadStarted && erroredFiles.length === uploadStartedFiles.length;
      var isAllPaused = inProgressFiles.length !== 0 && pausedFiles.length === inProgressFiles.length;

      var acquirers = _this._getAcquirers(pluginState.targets);

      var progressindicators = _this._getProgressIndicators(pluginState.targets);

      var editors = _this._getEditors(pluginState.targets);

      var theme;

      if (_this.opts.theme === 'auto') {
        theme = capabilities.darkMode ? 'dark' : 'light';
      } else {
        theme = _this.opts.theme;
      }

      if (['files', 'folders', 'both'].indexOf(_this.opts.fileManagerSelectionType) < 0) {
        _this.opts.fileManagerSelectionType = 'files';
        console.error("Unsupported option for \"fileManagerSelectionType\". Using default of \"" + _this.opts.fileManagerSelectionType + "\".");
      }

      return DashboardUI({
        state: state,
        isHidden: pluginState.isHidden,
        files: files,
        newFiles: newFiles,
        uploadStartedFiles: uploadStartedFiles,
        completeFiles: completeFiles,
        erroredFiles: erroredFiles,
        inProgressFiles: inProgressFiles,
        inProgressNotPausedFiles: inProgressNotPausedFiles,
        processingFiles: processingFiles,
        isUploadStarted: isUploadStarted,
        isAllComplete: isAllComplete,
        isAllErrored: isAllErrored,
        isAllPaused: isAllPaused,
        totalFileCount: Object.keys(files).length,
        totalProgress: state.totalProgress,
        allowNewUpload: allowNewUpload,
        acquirers: acquirers,
        theme: theme,
        disabled: _this.opts.disabled,
        disableLocalFiles: _this.opts.disableLocalFiles,
        direction: _this.opts.direction,
        activePickerPanel: pluginState.activePickerPanel,
        showFileEditor: pluginState.showFileEditor,
        disableAllFocusableElements: _this.disableAllFocusableElements,
        animateOpenClose: _this.opts.animateOpenClose,
        isClosing: pluginState.isClosing,
        getPlugin: _this.uppy.getPlugin,
        progressindicators: progressindicators,
        editors: editors,
        autoProceed: _this.uppy.opts.autoProceed,
        id: _this.id,
        closeModal: _this.requestCloseModal,
        handleClickOutside: _this.handleClickOutside,
        handleInputChange: _this.handleInputChange,
        handlePaste: _this.handlePaste,
        inline: _this.opts.inline,
        showPanel: _this.showPanel,
        hideAllPanels: _this.hideAllPanels,
        log: _this.uppy.log,
        i18n: _this.i18n,
        i18nArray: _this.i18nArray,
        removeFile: _this.uppy.removeFile,
        uppy: _this.uppy,
        info: _this.uppy.info,
        note: _this.opts.note,
        recoveredState: state.recoveredState,
        metaFields: pluginState.metaFields,
        resumableUploads: capabilities.resumableUploads || false,
        individualCancellation: capabilities.individualCancellation,
        isMobileDevice: capabilities.isMobileDevice,
        pauseUpload: _this.uppy.pauseResume,
        retryUpload: _this.uppy.retryUpload,
        cancelUpload: _this.cancelUpload,
        cancelAll: _this.uppy.cancelAll,
        fileCardFor: pluginState.fileCardFor,
        toggleFileCard: _this.toggleFileCard,
        toggleAddFilesPanel: _this.toggleAddFilesPanel,
        showAddFilesPanel: pluginState.showAddFilesPanel,
        saveFileCard: _this.saveFileCard,
        openFileEditor: _this.openFileEditor,
        canEditFile: _this.canEditFile,
        width: _this.opts.width,
        height: _this.opts.height,
        showLinkToFileUploadResult: _this.opts.showLinkToFileUploadResult,
        fileManagerSelectionType: _this.opts.fileManagerSelectionType,
        proudlyDisplayPoweredByUppy: _this.opts.proudlyDisplayPoweredByUppy,
        hideCancelButton: _this.opts.hideCancelButton,
        hideRetryButton: _this.opts.hideRetryButton,
        hidePauseResumeButton: _this.opts.hidePauseResumeButton,
        showRemoveButtonAfterComplete: _this.opts.showRemoveButtonAfterComplete,
        containerWidth: pluginState.containerWidth,
        containerHeight: pluginState.containerHeight,
        areInsidesReadyToBeVisible: pluginState.areInsidesReadyToBeVisible,
        isTargetDOMEl: _this.isTargetDOMEl,
        parentElement: _this.el,
        allowedFileTypes: _this.uppy.opts.restrictions.allowedFileTypes,
        maxNumberOfFiles: _this.uppy.opts.restrictions.maxNumberOfFiles,
        showSelectedFiles: _this.opts.showSelectedFiles,
        handleCancelRestore: _this.handleCancelRestore,
        handleRequestThumbnail: _this.handleRequestThumbnail,
        handleCancelThumbnail: _this.handleCancelThumbnail,
        // drag props
        isDraggingOver: pluginState.isDraggingOver,
        handleDragOver: _this.handleDragOver,
        handleDragLeave: _this.handleDragLeave,
        handleDrop: _this.handleDrop
      });
    };

    _this.discoverProviderPlugins = function () {
      _this.uppy.iteratePlugins(function (plugin) {
        if (plugin && !plugin.target && plugin.opts && plugin.opts.target === _this.constructor) {
          _this.addTarget(plugin);
        }
      });
    };

    _this.install = function () {
      // Set default state for Dashboard
      _this.setPluginState({
        isHidden: true,
        fileCardFor: null,
        activeOverlayType: null,
        showAddFilesPanel: false,
        activePickerPanel: false,
        showFileEditor: false,
        metaFields: _this.opts.metaFields,
        targets: [],
        // We'll make them visible once .containerWidth is determined
        areInsidesReadyToBeVisible: false,
        isDraggingOver: false
      });

      var _this$opts = _this.opts,
          inline = _this$opts.inline,
          closeAfterFinish = _this$opts.closeAfterFinish;

      if (inline && closeAfterFinish) {
        throw new Error('[Dashboard] `closeAfterFinish: true` cannot be used on an inline Dashboard, because an inline Dashboard cannot be closed at all. Either set `inline: false`, or disable the `closeAfterFinish` option.');
      }

      var allowMultipleUploads = _this.uppy.opts.allowMultipleUploads;

      if (allowMultipleUploads && closeAfterFinish) {
        _this.uppy.log('[Dashboard] When using `closeAfterFinish`, we recommended setting the `allowMultipleUploads` option to `false` in the Uppy constructor. See https://uppy.io/docs/uppy/#allowMultipleUploads-true', 'warning');
      }

      var target = _this.opts.target;

      if (target) {
        _this.mount(target, _assertThisInitialized(_this));
      }

      var plugins = _this.opts.plugins || [];
      plugins.forEach(function (pluginID) {
        var plugin = _this.uppy.getPlugin(pluginID);

        if (plugin) {
          plugin.mount(_assertThisInitialized(_this), plugin);
        }
      });

      if (!_this.opts.disableStatusBar) {
        _this.uppy.use(StatusBar, {
          id: _this.id + ":StatusBar",
          target: _assertThisInitialized(_this),
          hideUploadButton: _this.opts.hideUploadButton,
          hideRetryButton: _this.opts.hideRetryButton,
          hidePauseResumeButton: _this.opts.hidePauseResumeButton,
          hideCancelButton: _this.opts.hideCancelButton,
          showProgressDetails: _this.opts.showProgressDetails,
          hideAfterFinish: _this.opts.hideProgressAfterFinish,
          locale: _this.opts.locale,
          doneButtonHandler: _this.opts.doneButtonHandler
        });
      }

      if (!_this.opts.disableInformer) {
        _this.uppy.use(Informer, {
          id: _this.id + ":Informer",
          target: _assertThisInitialized(_this)
        });
      }

      if (!_this.opts.disableThumbnailGenerator) {
        _this.uppy.use(ThumbnailGenerator, {
          id: _this.id + ":ThumbnailGenerator",
          thumbnailWidth: _this.opts.thumbnailWidth,
          thumbnailType: _this.opts.thumbnailType,
          waitForThumbnailsBeforeUpload: _this.opts.waitForThumbnailsBeforeUpload,
          // If we don't block on thumbnails, we can lazily generate them
          lazy: !_this.opts.waitForThumbnailsBeforeUpload
        });
      } // Dark Mode / theme


      _this.darkModeMediaQuery = typeof window !== 'undefined' && window.matchMedia ? window.matchMedia('(prefers-color-scheme: dark)') : null;
      var isDarkModeOnFromTheStart = _this.darkModeMediaQuery ? _this.darkModeMediaQuery.matches : false;

      _this.uppy.log("[Dashboard] Dark mode is " + (isDarkModeOnFromTheStart ? 'on' : 'off'));

      _this.setDarkModeCapability(isDarkModeOnFromTheStart);

      if (_this.opts.theme === 'auto') {
        _this.darkModeMediaQuery.addListener(_this.handleSystemDarkModeChange);
      }

      _this.discoverProviderPlugins();

      _this.initEvents();
    };

    _this.uninstall = function () {
      if (!_this.opts.disableInformer) {
        var informer = _this.uppy.getPlugin(_this.id + ":Informer"); // Checking if this plugin exists, in case it was removed by uppy-core
        // before the Dashboard was.


        if (informer) _this.uppy.removePlugin(informer);
      }

      if (!_this.opts.disableStatusBar) {
        var statusBar = _this.uppy.getPlugin(_this.id + ":StatusBar");

        if (statusBar) _this.uppy.removePlugin(statusBar);
      }

      if (!_this.opts.disableThumbnailGenerator) {
        var thumbnail = _this.uppy.getPlugin(_this.id + ":ThumbnailGenerator");

        if (thumbnail) _this.uppy.removePlugin(thumbnail);
      }

      var plugins = _this.opts.plugins || [];
      plugins.forEach(function (pluginID) {
        var plugin = _this.uppy.getPlugin(pluginID);

        if (plugin) plugin.unmount();
      });

      if (_this.opts.theme === 'auto') {
        _this.darkModeMediaQuery.removeListener(_this.handleSystemDarkModeChange);
      }

      _this.unmount();

      _this.removeEvents();
    };

    _this.id = _this.opts.id || 'Dashboard';
    _this.title = 'Dashboard';
    _this.type = 'orchestrator';
    _this.modalName = "uppy-Dashboard-" + cuid();
    _this.defaultLocale = {
      strings: {
        closeModal: 'Close Modal',
        importFrom: 'Import from %{name}',
        addingMoreFiles: 'Adding more files',
        addMoreFiles: 'Add more files',
        dashboardWindowTitle: 'File Uploader Window (Press escape to close)',
        dashboardTitle: 'File Uploader',
        copyLinkToClipboardSuccess: 'Link copied to clipboard',
        copyLinkToClipboardFallback: 'Copy the URL below',
        copyLink: 'Copy link',
        fileSource: 'File source: %{name}',
        done: 'Done',
        back: 'Back',
        addMore: 'Add more',
        removeFile: 'Remove file',
        editFile: 'Edit file',
        editing: 'Editing %{file}',
        finishEditingFile: 'Finish editing file',
        saveChanges: 'Save changes',
        cancel: 'Cancel',
        myDevice: 'My Device',
        dropPasteFiles: 'Drop files here or %{browseFiles}',
        dropPasteFolders: 'Drop files here or %{browseFolders}',
        dropPasteBoth: 'Drop files here, %{browseFiles} or %{browseFolders}',
        dropPasteImportFiles: 'Drop files here, %{browseFiles} or import from:',
        dropPasteImportFolders: 'Drop files here, %{browseFolders} or import from:',
        dropPasteImportBoth: 'Drop files here, %{browseFiles}, %{browseFolders} or import from:',
        importFiles: 'Import files from:',
        dropHint: 'Drop your files here',
        browseFiles: 'browse files',
        browseFolders: 'browse folders',
        uploadComplete: 'Upload complete',
        uploadPaused: 'Upload paused',
        resumeUpload: 'Resume upload',
        pauseUpload: 'Pause upload',
        retryUpload: 'Retry upload',
        cancelUpload: 'Cancel upload',
        xFilesSelected: {
          0: '%{smart_count} file selected',
          1: '%{smart_count} files selected'
        },
        uploadingXFiles: {
          0: 'Uploading %{smart_count} file',
          1: 'Uploading %{smart_count} files'
        },
        processingXFiles: {
          0: 'Processing %{smart_count} file',
          1: 'Processing %{smart_count} files'
        },
        recoveredXFiles: {
          0: 'We could not fully recover 1 file. Please re-select it and resume the upload.',
          1: 'We could not fully recover %{smart_count} files. Please re-select them and resume the upload.'
        },
        recoveredAllFiles: 'We restored all files. You can now resume the upload.',
        sessionRestored: 'Session restored',
        reSelect: 'Re-select',
        // The default `poweredBy2` string only combines the `poweredBy` string (%{backwardsCompat}) with the size.
        // Locales can override `poweredBy2` to specify a different word order. This is for backwards compat with
        // Uppy 1.9.x and below which did a naive concatenation of `poweredBy2 + size` instead of using a locale-specific
        // substitution.
        // TODO: In 2.0 `poweredBy2` should be removed in and `poweredBy` updated to use substitution.
        poweredBy2: '%{backwardsCompat} %{uppy}',
        poweredBy: 'Powered by'
      }
    }; // set default options

    var defaultOptions = {
      target: 'body',
      metaFields: [],
      trigger: '#uppy-select-files',
      inline: false,
      width: 750,
      height: 550,
      thumbnailWidth: 280,
      thumbnailType: 'image/jpeg',
      waitForThumbnailsBeforeUpload: false,
      defaultPickerIcon: defaultPickerIcon,
      showLinkToFileUploadResult: true,
      showProgressDetails: false,
      hideUploadButton: false,
      hideCancelButton: false,
      hideRetryButton: false,
      hidePauseResumeButton: false,
      hideProgressAfterFinish: false,
      doneButtonHandler: function doneButtonHandler() {
        _this.uppy.reset();

        _this.requestCloseModal();
      },
      note: null,
      closeModalOnClickOutside: false,
      closeAfterFinish: false,
      disableStatusBar: false,
      disableInformer: false,
      disableThumbnailGenerator: false,
      disablePageScrollWhenModalOpen: true,
      animateOpenClose: true,
      fileManagerSelectionType: 'files',
      proudlyDisplayPoweredByUppy: true,
      onRequestCloseModal: function onRequestCloseModal() {
        return _this.closeModal();
      },
      showSelectedFiles: true,
      showRemoveButtonAfterComplete: false,
      browserBackButtonClose: false,
      theme: 'light',
      autoOpenFileEditor: false,
      disabled: false,
      disableLocalFiles: false
    }; // merge default options with the ones set by user

    _this.opts = _extends({}, defaultOptions, _opts);

    _this.i18nInit();

    _this.superFocus = createSuperFocus();
    _this.ifFocusedOnUppyRecently = false; // Timeouts

    _this.makeDashboardInsidesVisibleAnywayTimeout = null;
    _this.removeDragOverClassTimeout = null;
    return _this;
  }

  var _proto = Dashboard.prototype;

  _proto.onMount = function onMount() {
    // Set the text direction if the page has not defined one.
    var element = this.el;
    var direction = getTextDirection(element);

    if (!direction) {
      element.dir = 'ltr';
    }
  };

  return Dashboard;
}(Plugin), _class.VERSION = "1.20.2", _temp);