function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var _require = require('./icons'),
    localIcon = _require.localIcon;

var _require2 = require('preact'),
    h = _require2.h,
    Component = _require2.Component;

var AddFiles =
/*#__PURE__*/
function (_Component) {
  _inheritsLoose(AddFiles, _Component);

  function AddFiles(props) {
    var _this;

    _this = _Component.call(this, props) || this;
    _this.triggerFileInputClick = _this.triggerFileInputClick.bind(_assertThisInitialized(_this));
    _this.handleFileInputChange = _this.handleFileInputChange.bind(_assertThisInitialized(_this));
    _this.renderPoweredByUppy = _this.renderPoweredByUppy.bind(_assertThisInitialized(_this));
    _this.renderHiddenFileInput = _this.renderHiddenFileInput.bind(_assertThisInitialized(_this));
    _this.renderDropPasteBrowseTagline = _this.renderDropPasteBrowseTagline.bind(_assertThisInitialized(_this));
    _this.renderMyDeviceAcquirer = _this.renderMyDeviceAcquirer.bind(_assertThisInitialized(_this));
    _this.renderAcquirer = _this.renderAcquirer.bind(_assertThisInitialized(_this));
    return _this;
  }

  var _proto = AddFiles.prototype;

  _proto.triggerFileInputClick = function triggerFileInputClick() {
    this.fileInput.click();
  };

  _proto.handleFileInputChange = function handleFileInputChange(event) {
    this.props.handleInputChange(event); // We clear the input after a file is selected, because otherwise
    // change event is not fired in Chrome and Safari when a file
    // with the same name is selected.
    // ___Why not use value="" on <input/> instead?
    //    Because if we use that method of clearing the input,
    //    Chrome will not trigger change if we drop the same file twice (Issue #768).

    event.target.value = null;
  };

  _proto.renderPoweredByUppy = function renderPoweredByUppy() {
    return h("a", {
      tabindex: "-1",
      href: "https://uppy.io",
      rel: "noreferrer noopener",
      target: "_blank",
      class: "uppy-Dashboard-poweredBy"
    }, this.props.i18n('poweredBy') + ' ', h("svg", {
      "aria-hidden": "true",
      focusable: "false",
      class: "UppyIcon uppy-Dashboard-poweredByIcon",
      width: "11",
      height: "11",
      viewBox: "0 0 11 11"
    }, h("path", {
      d: "M7.365 10.5l-.01-4.045h2.612L5.5.806l-4.467 5.65h2.604l.01 4.044h3.718z",
      "fill-rule": "evenodd"
    })), h("span", {
      class: "uppy-Dashboard-poweredByUppy"
    }, "Uppy"));
  };

  _proto.renderHiddenFileInput = function renderHiddenFileInput() {
    var _this2 = this;

    return h("input", {
      class: "uppy-Dashboard-input",
      hidden: true,
      "aria-hidden": "true",
      tabindex: -1,
      type: "file",
      name: "files[]",
      multiple: this.props.maxNumberOfFiles !== 1,
      onchange: this.handleFileInputChange,
      accept: this.props.allowedFileTypes,
      ref: function ref(_ref) {
        _this2.fileInput = _ref;
      }
    });
  };

  _proto.renderDropPasteBrowseTagline = function renderDropPasteBrowseTagline() {
    var browse = h("button", {
      type: "button",
      class: "uppy-u-reset uppy-Dashboard-browse",
      onclick: this.triggerFileInputClick
    }, this.props.i18n('browse'));
    return h("div", {
      class: "uppy-Dashboard-dropFilesTitle"
    }, this.props.acquirers.length === 0 ? this.props.i18nArray('dropPaste', {
      browse: browse
    }) : this.props.i18nArray('dropPasteImport', {
      browse: browse
    }));
  };

  _proto.renderMyDeviceAcquirer = function renderMyDeviceAcquirer() {
    return h("div", {
      class: "uppy-DashboardTab",
      role: "presentation"
    }, h("button", {
      type: "button",
      class: "uppy-DashboardTab-btn",
      role: "tab",
      tabindex: 0,
      "data-uppy-super-focusable": true,
      onclick: this.triggerFileInputClick
    }, localIcon(), h("div", {
      class: "uppy-DashboardTab-name"
    }, this.props.i18n('myDevice'))));
  };

  _proto.renderAcquirer = function renderAcquirer(acquirer) {
    var _this3 = this;

    return h("div", {
      class: "uppy-DashboardTab",
      role: "presentation"
    }, h("button", {
      type: "button",
      class: "uppy-DashboardTab-btn",
      role: "tab",
      tabindex: 0,
      "aria-controls": "uppy-DashboardContent-panel--" + acquirer.id,
      "aria-selected": this.props.activePickerPanel.id === acquirer.id,
      "data-uppy-super-focusable": true,
      onclick: function onclick() {
        return _this3.props.showPanel(acquirer.id);
      }
    }, acquirer.icon(), h("div", {
      class: "uppy-DashboardTab-name"
    }, acquirer.name)));
  };

  _proto.render = function render() {
    var _this4 = this;

    return h("div", {
      class: "uppy-DashboardAddFiles"
    }, this.renderHiddenFileInput(), h("div", {
      class: "uppy-DashboardTabs"
    }, this.renderDropPasteBrowseTagline(), this.props.acquirers.length > 0 && h("div", {
      class: "uppy-DashboardTabs-list",
      role: "tablist"
    }, this.renderMyDeviceAcquirer(), this.props.acquirers.map(function (acquirer) {
      return _this4.renderAcquirer(acquirer);
    }))), h("div", {
      class: "uppy-DashboardAddFiles-info"
    }, this.props.note && h("div", {
      class: "uppy-Dashboard-note"
    }, this.props.note), this.props.proudlyDisplayPoweredByUppy && this.renderPoweredByUppy(this.props)));
  };

  return AddFiles;
}(Component);

module.exports = AddFiles;