function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var _require = require('preact'),
    h = _require.h,
    Component = _require.Component;

var getFileTypeIcon = require('../../utils/getFileTypeIcon');

var ignoreEvent = require('../../utils/ignoreEvent.js');

var FilePreview = require('../FilePreview');

var FileCard =
/*#__PURE__*/
function (_Component) {
  _inheritsLoose(FileCard, _Component);

  function FileCard(props) {
    var _this;

    _this = _Component.call(this, props) || this;

    _this.saveOnEnter = function (ev) {
      if (ev.keyCode === 13) {
        ev.stopPropagation();
        ev.preventDefault();
        var file = _this.props.files[_this.props.fileCardFor];

        _this.props.saveFileCard(_this.state.formState, file.id);
      }
    };

    _this.tempStoreMeta = function (ev, name) {
      var _extends2;

      _this.setState({
        formState: _extends({}, _this.state.formState, (_extends2 = {}, _extends2[name] = ev.target.value, _extends2))
      });
    };

    _this.handleSave = function () {
      var fileID = _this.props.fileCardFor;

      _this.props.saveFileCard(_this.state.formState, fileID);
    };

    _this.handleCancel = function () {
      _this.props.toggleFileCard();
    };

    _this.renderMetaFields = function () {
      var metaFields = _this.props.metaFields || [];
      return metaFields.map(function (field) {
        var id = "uppy-Dashboard-FileCard-input-" + field.id;
        return h("fieldset", {
          key: field.id,
          class: "uppy-Dashboard-FileCard-fieldset"
        }, h("label", {
          class: "uppy-Dashboard-FileCard-label",
          for: id
        }, field.name), h("input", {
          class: "uppy-u-reset uppy-c-textInput uppy-Dashboard-FileCard-input",
          id: id,
          type: "text",
          value: _this.state.formState[field.id],
          placeholder: field.placeholder,
          onkeyup: _this.saveOnEnter,
          onkeydown: _this.saveOnEnter,
          onkeypress: _this.saveOnEnter,
          oninput: function oninput(ev) {
            return _this.tempStoreMeta(ev, field.id);
          },
          "data-uppy-super-focusable": true
        }));
      });
    };

    var _file = _this.props.files[_this.props.fileCardFor];

    var _metaFields = _this.props.metaFields || [];

    var storedMetaData = {};

    _metaFields.forEach(function (field) {
      storedMetaData[field.id] = _file.meta[field.id] || '';
    });

    _this.state = {
      formState: storedMetaData
    };
    return _this;
  }

  var _proto = FileCard.prototype;

  _proto.render = function render() {
    var file = this.props.files[this.props.fileCardFor];
    return h("div", {
      class: "uppy-Dashboard-FileCard",
      "data-uppy-panelType": "FileCard",
      onDragOver: ignoreEvent,
      onDragLeave: ignoreEvent,
      onDrop: ignoreEvent,
      onPaste: ignoreEvent
    }, h("div", {
      class: "uppy-DashboardContent-bar"
    }, h("div", {
      class: "uppy-DashboardContent-title",
      role: "heading",
      "aria-level": "h1"
    }, this.props.i18nArray('editing', {
      file: h("span", {
        class: "uppy-DashboardContent-titleFile"
      }, file.meta ? file.meta.name : file.name)
    })), h("button", {
      class: "uppy-DashboardContent-back",
      type: "button",
      title: this.props.i18n('finishEditingFile'),
      onclick: this.handleSave
    }, this.props.i18n('done'))), h("div", {
      class: "uppy-Dashboard-FileCard-inner"
    }, h("div", {
      class: "uppy-Dashboard-FileCard-preview",
      style: {
        backgroundColor: getFileTypeIcon(file.type).color
      }
    }, h(FilePreview, {
      file: file
    })), h("div", {
      class: "uppy-Dashboard-FileCard-info"
    }, this.renderMetaFields()), h("div", {
      class: "uppy-Dashboard-FileCard-actions"
    }, h("button", {
      class: "uppy-u-reset uppy-c-btn uppy-c-btn-primary uppy-Dashboard-FileCard-actionsBtn",
      type: "button",
      onclick: this.handleSave
    }, this.props.i18n('saveChanges')), h("button", {
      class: "uppy-u-reset uppy-c-btn uppy-c-btn-link uppy-Dashboard-FileCard-actionsBtn",
      type: "button",
      onclick: this.handleCancel
    }, this.props.i18n('cancel')))));
  };

  return FileCard;
}(Component);

module.exports = FileCard;