var _class, _temp;

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var _require = require('@uppy/core'),
    Plugin = _require.Plugin;

var Translator = require('@uppy/utils/lib/Translator');

var DashboardUI = require('./components/Dashboard');

var StatusBar = require('@uppy/status-bar');

var Informer = require('@uppy/informer');

var ThumbnailGenerator = require('@uppy/thumbnail-generator');

var findAllDOMElements = require('@uppy/utils/lib/findAllDOMElements');

var toArray = require('@uppy/utils/lib/toArray');

var getDroppedFiles = require('@uppy/utils/lib/getDroppedFiles');

var trapFocus = require('./utils/trapFocus');

var cuid = require('cuid');

var ResizeObserver = require('resize-observer-polyfill').default || require('resize-observer-polyfill');

var _require2 = require('./components/icons'),
    defaultPickerIcon = _require2.defaultPickerIcon;

var createSuperFocus = require('./utils/createSuperFocus');

var memoize = require('memoize-one').default || require('memoize-one');

var TAB_KEY = 9;
var ESC_KEY = 27;

function createPromise() {
  var o = {};
  o.promise = new Promise(function (resolve, reject) {
    o.resolve = resolve;
    o.reject = reject;
  });
  return o;
}
/**
 * Dashboard UI with previews, metadata editing, tabs for various services and more
 */


module.exports = (_temp = _class =
/*#__PURE__*/
function (_Plugin) {
  _inheritsLoose(Dashboard, _Plugin);

  function Dashboard(uppy, opts) {
    var _this;

    _this = _Plugin.call(this, uppy, opts) || this;

    _this.cancelUpload = function (fileID) {
      _this.uppy.removeFile(fileID);
    };

    _this.saveFileCard = function (meta, fileID) {
      _this.uppy.setFileMeta(fileID, meta);

      _this.toggleFileCard();
    };

    _this._attachRenderFunctionToTarget = function (target) {
      var plugin = _this.uppy.getPlugin(target.id);

      return _extends({}, target, {
        icon: plugin.icon || _this.opts.defaultPickerIcon,
        render: plugin.render
      });
    };

    _this._isTargetSupported = function (target) {
      var plugin = _this.uppy.getPlugin(target.id); // If the plugin does not provide a `supported` check, assume the plugin works everywhere.


      if (typeof plugin.isSupported !== 'function') {
        return true;
      }

      return plugin.isSupported();
    };

    _this._getAcquirers = memoize(function (targets) {
      return targets.filter(function (target) {
        return target.type === 'acquirer' && _this._isTargetSupported(target);
      }).map(_this._attachRenderFunctionToTarget);
    });
    _this._getProgressIndicators = memoize(function (targets) {
      return targets.filter(function (target) {
        return target.type === 'progressindicator';
      }).map(_this._attachRenderFunctionToTarget);
    });
    _this.id = _this.opts.id || 'Dashboard';
    _this.title = 'Dashboard';
    _this.type = 'orchestrator';
    _this.modalName = "uppy-Dashboard-" + cuid();
    _this.defaultLocale = {
      strings: {
        closeModal: 'Close Modal',
        importFrom: 'Import from %{name}',
        addingMoreFiles: 'Adding more files',
        addMoreFiles: 'Add more files',
        dashboardWindowTitle: 'File Uploader Window (Press escape to close)',
        dashboardTitle: 'File Uploader',
        copyLinkToClipboardSuccess: 'Link copied to clipboard',
        copyLinkToClipboardFallback: 'Copy the URL below',
        copyLink: 'Copy link',
        link: 'Link',
        fileSource: 'File source: %{name}',
        done: 'Done',
        back: 'Back',
        addMore: 'Add more',
        removeFile: 'Remove file',
        editFile: 'Edit file',
        editing: 'Editing %{file}',
        edit: 'Edit',
        finishEditingFile: 'Finish editing file',
        saveChanges: 'Save changes',
        cancel: 'Cancel',
        myDevice: 'My Device',
        dropPasteImport: 'Drop files here, paste, %{browse} or import from',
        dropPaste: 'Drop files here, paste or %{browse}',
        dropHint: 'Drop your files here',
        browse: 'browse',
        uploadComplete: 'Upload complete',
        uploadPaused: 'Upload paused',
        resumeUpload: 'Resume upload',
        pauseUpload: 'Pause upload',
        retryUpload: 'Retry upload',
        cancelUpload: 'Cancel upload',
        xFilesSelected: {
          0: '%{smart_count} file selected',
          1: '%{smart_count} files selected',
          2: '%{smart_count} files selected'
        },
        uploadingXFiles: {
          0: 'Uploading %{smart_count} file',
          1: 'Uploading %{smart_count} files',
          2: 'Uploading %{smart_count} files'
        },
        processingXFiles: {
          0: 'Processing %{smart_count} file',
          1: 'Processing %{smart_count} files',
          2: 'Processing %{smart_count} files'
        },
        poweredBy: 'Powered by'
      } // set default options

    };
    var defaultOptions = {
      target: 'body',
      metaFields: [],
      trigger: '#uppy-select-files',
      inline: false,
      width: 750,
      height: 550,
      thumbnailWidth: 280,
      waitForThumbnailsBeforeUpload: false,
      defaultPickerIcon: defaultPickerIcon,
      showLinkToFileUploadResult: true,
      showProgressDetails: false,
      hideUploadButton: false,
      hideRetryButton: false,
      hidePauseResumeCancelButtons: false,
      hideProgressAfterFinish: false,
      note: null,
      closeModalOnClickOutside: false,
      closeAfterFinish: false,
      disableStatusBar: false,
      disableInformer: false,
      disableThumbnailGenerator: false,
      disablePageScrollWhenModalOpen: true,
      animateOpenClose: true,
      proudlyDisplayPoweredByUppy: true,
      onRequestCloseModal: function onRequestCloseModal() {
        return _this.closeModal();
      },
      showSelectedFiles: true,
      browserBackButtonClose: false // merge default options with the ones set by user

    };
    _this.opts = _extends({}, defaultOptions, {}, opts);

    _this.i18nInit();

    _this.openModal = _this.openModal.bind(_assertThisInitialized(_this));
    _this.closeModal = _this.closeModal.bind(_assertThisInitialized(_this));
    _this.requestCloseModal = _this.requestCloseModal.bind(_assertThisInitialized(_this));
    _this.isModalOpen = _this.isModalOpen.bind(_assertThisInitialized(_this));
    _this.addTarget = _this.addTarget.bind(_assertThisInitialized(_this));
    _this.removeTarget = _this.removeTarget.bind(_assertThisInitialized(_this));
    _this.hideAllPanels = _this.hideAllPanels.bind(_assertThisInitialized(_this));
    _this.showPanel = _this.showPanel.bind(_assertThisInitialized(_this));
    _this.toggleFileCard = _this.toggleFileCard.bind(_assertThisInitialized(_this));
    _this.toggleAddFilesPanel = _this.toggleAddFilesPanel.bind(_assertThisInitialized(_this));
    _this.initEvents = _this.initEvents.bind(_assertThisInitialized(_this));
    _this.handlePopState = _this.handlePopState.bind(_assertThisInitialized(_this));
    _this.handleKeyDownInModal = _this.handleKeyDownInModal.bind(_assertThisInitialized(_this));
    _this.handleKeyDownInInline = _this.handleKeyDownInInline.bind(_assertThisInitialized(_this));
    _this.handleComplete = _this.handleComplete.bind(_assertThisInitialized(_this));
    _this.handleClickOutside = _this.handleClickOutside.bind(_assertThisInitialized(_this));
    _this.handlePaste = _this.handlePaste.bind(_assertThisInitialized(_this));
    _this.handlePasteOnBody = _this.handlePasteOnBody.bind(_assertThisInitialized(_this));
    _this.handleInputChange = _this.handleInputChange.bind(_assertThisInitialized(_this));
    _this.handleDragOver = _this.handleDragOver.bind(_assertThisInitialized(_this));
    _this.handleDragLeave = _this.handleDragLeave.bind(_assertThisInitialized(_this));
    _this.handleDrop = _this.handleDrop.bind(_assertThisInitialized(_this));
    _this.superFocusOnEachUpdate = _this.superFocusOnEachUpdate.bind(_assertThisInitialized(_this));
    _this.recordIfFocusedOnUppyRecently = _this.recordIfFocusedOnUppyRecently.bind(_assertThisInitialized(_this));
    _this.render = _this.render.bind(_assertThisInitialized(_this));
    _this.install = _this.install.bind(_assertThisInitialized(_this));
    _this.superFocus = createSuperFocus();
    _this.ifFocusedOnUppyRecently = false; // Timeouts

    _this.makeDashboardInsidesVisibleAnywayTimeout = null;
    _this.removeDragOverClassTimeout = null;
    return _this;
  }

  var _proto = Dashboard.prototype;

  _proto.setOptions = function setOptions(newOpts) {
    _Plugin.prototype.setOptions.call(this, newOpts);

    this.i18nInit();
  };

  _proto.i18nInit = function i18nInit() {
    this.translator = new Translator([this.defaultLocale, this.uppy.locale, this.opts.locale]);
    this.i18n = this.translator.translate.bind(this.translator);
    this.i18nArray = this.translator.translateArray.bind(this.translator);
    this.setPluginState(); // so that UI re-renders and we see the updated locale
  };

  _proto.removeTarget = function removeTarget(plugin) {
    var pluginState = this.getPluginState(); // filter out the one we want to remove

    var newTargets = pluginState.targets.filter(function (target) {
      return target.id !== plugin.id;
    });
    this.setPluginState({
      targets: newTargets
    });
  };

  _proto.addTarget = function addTarget(plugin) {
    var callerPluginId = plugin.id || plugin.constructor.name;
    var callerPluginName = plugin.title || callerPluginId;
    var callerPluginType = plugin.type;

    if (callerPluginType !== 'acquirer' && callerPluginType !== 'progressindicator' && callerPluginType !== 'presenter') {
      var msg = 'Dashboard: Modal can only be used by plugins of types: acquirer, progressindicator, presenter';
      this.uppy.log(msg, 'error');
      return;
    }

    var target = {
      id: callerPluginId,
      name: callerPluginName,
      type: callerPluginType
    };
    var state = this.getPluginState();
    var newTargets = state.targets.slice();
    newTargets.push(target);
    this.setPluginState({
      targets: newTargets
    });
    return this.el;
  };

  _proto.hideAllPanels = function hideAllPanels() {
    this.setPluginState({
      activePickerPanel: false,
      showAddFilesPanel: false,
      activeOverlayType: null
    });
  };

  _proto.showPanel = function showPanel(id) {
    var _this$getPluginState = this.getPluginState(),
        targets = _this$getPluginState.targets;

    var activePickerPanel = targets.filter(function (target) {
      return target.type === 'acquirer' && target.id === id;
    })[0];
    this.setPluginState({
      activePickerPanel: activePickerPanel,
      activeOverlayType: 'PickerPanel'
    });
  };

  _proto.openModal = function openModal() {
    var _this2 = this;

    var _createPromise = createPromise(),
        promise = _createPromise.promise,
        resolve = _createPromise.resolve; // save scroll position


    this.savedScrollPosition = window.pageYOffset; // save active element, so we can restore focus when modal is closed

    this.savedActiveElement = document.activeElement;

    if (this.opts.disablePageScrollWhenModalOpen) {
      document.body.classList.add('uppy-Dashboard-isFixed');
    }

    if (this.opts.animateOpenClose && this.getPluginState().isClosing) {
      var handler = function handler() {
        _this2.setPluginState({
          isHidden: false
        });

        _this2.el.removeEventListener('animationend', handler, false);

        resolve();
      };

      this.el.addEventListener('animationend', handler, false);
    } else {
      this.setPluginState({
        isHidden: false
      });
      resolve();
    }

    if (this.opts.browserBackButtonClose) {
      this.updateBrowserHistory();
    } // handle ESC and TAB keys in modal dialog


    document.addEventListener('keydown', this.handleKeyDownInModal);
    this.uppy.emit('dashboard:modal-open');
    return promise;
  };

  _proto.closeModal = function closeModal(opts) {
    var _this3 = this;

    if (opts === void 0) {
      opts = {};
    }

    var _opts = opts,
        _opts$manualClose = _opts.manualClose,
        manualClose = _opts$manualClose === void 0 ? true : _opts$manualClose;

    var _this$getPluginState2 = this.getPluginState(),
        isHidden = _this$getPluginState2.isHidden,
        isClosing = _this$getPluginState2.isClosing;

    if (isHidden || isClosing) {
      // short-circuit if animation is ongoing
      return;
    }

    var _createPromise2 = createPromise(),
        promise = _createPromise2.promise,
        resolve = _createPromise2.resolve;

    if (this.opts.disablePageScrollWhenModalOpen) {
      document.body.classList.remove('uppy-Dashboard-isFixed');
    }

    if (this.opts.animateOpenClose) {
      this.setPluginState({
        isClosing: true
      });

      var handler = function handler() {
        _this3.setPluginState({
          isHidden: true,
          isClosing: false
        });

        _this3.superFocus.cancel();

        _this3.savedActiveElement.focus();

        _this3.el.removeEventListener('animationend', handler, false);

        resolve();
      };

      this.el.addEventListener('animationend', handler, false);
    } else {
      this.setPluginState({
        isHidden: true
      });
      this.superFocus.cancel();
      this.savedActiveElement.focus();
      resolve();
    } // handle ESC and TAB keys in modal dialog


    document.removeEventListener('keydown', this.handleKeyDownInModal);

    if (manualClose) {
      if (this.opts.browserBackButtonClose) {
        // Make sure that the latest entry in the history state is our modal name
        if (history.state && history.state[this.modalName]) {
          // Go back in history to clear out the entry we created (ultimately closing the modal)
          history.go(-1);
        }
      }
    }

    this.uppy.emit('dashboard:modal-closed');
    return promise;
  };

  _proto.isModalOpen = function isModalOpen() {
    return !this.getPluginState().isHidden || false;
  };

  _proto.requestCloseModal = function requestCloseModal() {
    if (this.opts.onRequestCloseModal) {
      return this.opts.onRequestCloseModal();
    }

    return this.closeModal();
  };

  _proto.toggleFileCard = function toggleFileCard(fileId) {
    if (fileId) {
      this.uppy.emit('dashboard:file-edit-start');
    } else {
      this.uppy.emit('dashboard:file-edit-complete');
    }

    this.setPluginState({
      fileCardFor: fileId || null,
      activeOverlayType: fileId ? 'FileCard' : null
    });
  };

  _proto.toggleAddFilesPanel = function toggleAddFilesPanel(show) {
    this.setPluginState({
      showAddFilesPanel: show,
      activeOverlayType: show ? 'AddFiles' : null
    });
  };

  _proto.addFile = function addFile(file) {
    try {
      this.uppy.addFile({
        source: this.id,
        name: file.name,
        type: file.type,
        data: file,
        meta: {
          // path of the file relative to the ancestor directory the user selected.
          // e.g. 'docs/Old Prague/airbnb.pdf'
          relativePath: file.relativePath || null
        }
      });
    } catch (err) {
      if (!err.isRestriction) {
        this.uppy.log(err);
      }
    }
  } // ___Why make insides of Dashboard invisible until first ResizeObserver event is emitted?
  //    ResizeOberserver doesn't emit the first resize event fast enough, users can see the jump from one .uppy-size-- to another (e.g. in Safari)
  // ___Why not apply visibility property to .uppy-Dashboard-inner?
  //    Because ideally, acc to specs, ResizeObserver should see invisible elements as of width 0. So even though applying invisibility to .uppy-Dashboard-inner works now, it may not work in the future.
  ;

  _proto.startListeningToResize = function startListeningToResize() {
    var _this4 = this;

    // Watch for Dashboard container (`.uppy-Dashboard-inner`) resize
    // and update containerWidth/containerHeight in plugin state accordingly.
    // Emits first event on initialization.
    this.resizeObserver = new ResizeObserver(function (entries, observer) {
      var uppyDashboardInnerEl = entries[0];
      var _uppyDashboardInnerEl = uppyDashboardInnerEl.contentRect,
          width = _uppyDashboardInnerEl.width,
          height = _uppyDashboardInnerEl.height;

      _this4.uppy.log("[Dashboard] resized: " + width + " / " + height, 'debug');

      _this4.setPluginState({
        containerWidth: width,
        containerHeight: height,
        areInsidesReadyToBeVisible: true
      });
    });
    this.resizeObserver.observe(this.el.querySelector('.uppy-Dashboard-inner')); // If ResizeObserver fails to emit an event telling us what size to use - default to the mobile view

    this.makeDashboardInsidesVisibleAnywayTimeout = setTimeout(function () {
      var pluginState = _this4.getPluginState();

      var isModalAndClosed = !_this4.opts.inline && pluginState.isHidden;

      if ( // if ResizeObserver hasn't yet fired,
      !pluginState.areInsidesReadyToBeVisible && // and it's not due to the modal being closed
      !isModalAndClosed) {
        _this4.uppy.log("[Dashboard] resize event didn't fire on time: defaulted to mobile layout", 'debug');

        _this4.setPluginState({
          areInsidesReadyToBeVisible: true
        });
      }
    }, 1000);
  };

  _proto.stopListeningToResize = function stopListeningToResize() {
    this.resizeObserver.disconnect();
    clearTimeout(this.makeDashboardInsidesVisibleAnywayTimeout);
  } // Records whether we have been interacting with uppy right now, which is then used to determine whether state updates should trigger a refocusing.
  ;

  _proto.recordIfFocusedOnUppyRecently = function recordIfFocusedOnUppyRecently(event) {
    if (this.el.contains(event.target)) {
      this.ifFocusedOnUppyRecently = true;
    } else {
      this.ifFocusedOnUppyRecently = false; // ___Why run this.superFocus.cancel here when it already runs in superFocusOnEachUpdate?
      //    Because superFocus is debounced, when we move from Uppy to some other element on the page,
      //    previously run superFocus sometimes hits and moves focus back to Uppy.

      this.superFocus.cancel();
    }
  };

  _proto.updateBrowserHistory = function updateBrowserHistory() {
    // Ensure history state does not already contain our modal name to avoid double-pushing
    if (!history.state || !history.state[this.modalName]) {
      var _extends2;

      // Push to history so that the page is not lost on browser back button press
      history.pushState(_extends({}, history.state, (_extends2 = {}, _extends2[this.modalName] = true, _extends2)), '');
    } // Listen for back button presses


    window.addEventListener('popstate', this.handlePopState, false);
  };

  _proto.handlePopState = function handlePopState(event) {
    // Close the modal if the history state no longer contains our modal name
    if (this.isModalOpen() && (!event.state || !event.state[this.modalName])) {
      this.closeModal({
        manualClose: false
      });
    } // When the browser back button is pressed and uppy is now the latest entry in the history but the modal is closed, fix the history by removing the uppy history entry
    // This occurs when another entry is added into the history state while the modal is open, and then the modal gets manually closed
    // Solves PR #575 (https://github.com/transloadit/uppy/pull/575)


    if (!this.isModalOpen() && event.state && event.state[this.modalName]) {
      history.go(-1);
    }
  };

  _proto.handleKeyDownInModal = function handleKeyDownInModal(event) {
    // close modal on esc key press
    if (event.keyCode === ESC_KEY) this.requestCloseModal(event); // trap focus on tab key press

    if (event.keyCode === TAB_KEY) trapFocus.forModal(event, this.getPluginState().activeOverlayType, this.el);
  };

  _proto.handleClickOutside = function handleClickOutside() {
    if (this.opts.closeModalOnClickOutside) this.requestCloseModal();
  };

  _proto.handlePaste = function handlePaste(event) {
    var _this5 = this;

    // 1. Let any acquirer plugin (Url/Webcam/etc.) handle pastes to the root
    this.uppy.iteratePlugins(function (plugin) {
      if (plugin.type === 'acquirer') {
        // Every Plugin with .type acquirer can define handleRootPaste(event)
        plugin.handleRootPaste && plugin.handleRootPaste(event);
      }
    }); // 2. Add all dropped files

    var files = toArray(event.clipboardData.files);
    files.forEach(function (file) {
      _this5.uppy.log('[Dashboard] File pasted');

      _this5.addFile(file);
    });
  };

  _proto.handleInputChange = function handleInputChange(event) {
    var _this6 = this;

    event.preventDefault();
    var files = toArray(event.target.files);
    files.forEach(function (file) {
      return _this6.addFile(file);
    });
  };

  _proto.handleDragOver = function handleDragOver(event) {
    event.preventDefault();
    event.stopPropagation();
    clearTimeout(this.removeDragOverClassTimeout);
    this.setPluginState({
      isDraggingOver: true
    });
  };

  _proto.handleDragLeave = function handleDragLeave(event) {
    var _this7 = this;

    event.preventDefault();
    event.stopPropagation();
    clearTimeout(this.removeDragOverClassTimeout); // Timeout against flickering, this solution is taken from drag-drop library. Solution with 'pointer-events: none' didn't work across browsers.

    this.removeDragOverClassTimeout = setTimeout(function () {
      _this7.setPluginState({
        isDraggingOver: false
      });
    }, 50);
  };

  _proto.handleDrop = function handleDrop(event, dropCategory) {
    var _this8 = this;

    event.preventDefault();
    event.stopPropagation();
    clearTimeout(this.removeDragOverClassTimeout); // 1. Add a small (+) icon on drop

    event.dataTransfer.dropEffect = 'copy'; // 2. Remove dragover class

    this.setPluginState({
      isDraggingOver: false
    }); // 3. Let any acquirer plugin (Url/Webcam/etc.) handle drops to the root

    this.uppy.iteratePlugins(function (plugin) {
      if (plugin.type === 'acquirer') {
        // Every Plugin with .type acquirer can define handleRootDrop(event)
        plugin.handleRootDrop && plugin.handleRootDrop(event);
      }
    }); // 4. Add all dropped files

    var executedDropErrorOnce = false;

    var logDropError = function logDropError(error) {
      _this8.uppy.log(error, 'error'); // In practice all drop errors are most likely the same, so let's just show one to avoid overwhelming the user


      if (!executedDropErrorOnce) {
        _this8.uppy.info(error.message, 'error');

        executedDropErrorOnce = true;
      }
    };

    getDroppedFiles(event.dataTransfer, {
      logDropError: logDropError
    }).then(function (files) {
      if (files.length > 0) {
        _this8.uppy.log('[Dashboard] Files were dropped');

        files.forEach(function (file) {
          return _this8.addFile(file);
        });
      }
    });
  };

  _proto.handleKeyDownInInline = function handleKeyDownInInline(event) {
    // Trap focus on tab key press.
    if (event.keyCode === TAB_KEY) trapFocus.forInline(event, this.getPluginState().activeOverlayType, this.el);
  } // ___Why do we listen to the 'paste' event on a document instead of onPaste={props.handlePaste} prop, or this.el.addEventListener('paste')?
  //    Because (at least) Chrome doesn't handle paste if focus is on some button, e.g. 'My Device'.
  //    => Therefore, the best option is to listen to all 'paste' events, and only react to them when we are focused on our particular Uppy instance.
  // ___Why do we still need onPaste={props.handlePaste} for the DashboardUi?
  //    Because if we click on the 'Drop files here' caption e.g., `document.activeElement` will be 'body'. Which means our standard determination of whether we're pasting into our Uppy instance won't work.
  //    => Therefore, we need a traditional onPaste={props.handlePaste} handler too.
  ;

  _proto.handlePasteOnBody = function handlePasteOnBody(event) {
    var isFocusInOverlay = this.el.contains(document.activeElement);

    if (isFocusInOverlay) {
      this.handlePaste(event);
    }
  };

  _proto.handleComplete = function handleComplete(_ref) {
    var failed = _ref.failed,
        uploadID = _ref.uploadID;

    if (this.opts.closeAfterFinish && failed.length === 0) {
      // All uploads are done
      this.requestCloseModal();
    }
  };

  _proto.initEvents = function initEvents() {
    var _this9 = this;

    // Modal open button
    var showModalTrigger = findAllDOMElements(this.opts.trigger);

    if (!this.opts.inline && showModalTrigger) {
      showModalTrigger.forEach(function (trigger) {
        return trigger.addEventListener('click', _this9.openModal);
      });
    }

    if (!this.opts.inline && !showModalTrigger) {
      this.uppy.log('Dashboard modal trigger not found. Make sure `trigger` is set in Dashboard options unless you are planning to call openModal() method yourself', 'error');
    }

    this.startListeningToResize();
    document.addEventListener('paste', this.handlePasteOnBody);
    this.uppy.on('plugin-remove', this.removeTarget);
    this.uppy.on('file-added', this.hideAllPanels);
    this.uppy.on('dashboard:modal-closed', this.hideAllPanels);
    this.uppy.on('complete', this.handleComplete); // ___Why fire on capture?
    //    Because this.ifFocusedOnUppyRecently needs to change before onUpdate() fires.

    document.addEventListener('focus', this.recordIfFocusedOnUppyRecently, true);
    document.addEventListener('click', this.recordIfFocusedOnUppyRecently, true);

    if (this.opts.inline) {
      this.el.addEventListener('keydown', this.handleKeyDownInInline);
    }
  };

  _proto.removeEvents = function removeEvents() {
    var _this10 = this;

    var showModalTrigger = findAllDOMElements(this.opts.trigger);

    if (!this.opts.inline && showModalTrigger) {
      showModalTrigger.forEach(function (trigger) {
        return trigger.removeEventListener('click', _this10.openModal);
      });
    }

    this.stopListeningToResize();
    document.removeEventListener('paste', this.handlePasteOnBody);
    window.removeEventListener('popstate', this.handlePopState, false);
    this.uppy.off('plugin-remove', this.removeTarget);
    this.uppy.off('file-added', this.hideAllPanels);
    this.uppy.off('dashboard:modal-closed', this.hideAllPanels);
    this.uppy.off('complete', this.handleComplete);
    document.removeEventListener('focus', this.recordIfFocusedOnUppyRecently);
    document.removeEventListener('click', this.recordIfFocusedOnUppyRecently);

    if (this.opts.inline) {
      this.el.removeEventListener('keydown', this.handleKeyDownInInline);
    }
  };

  _proto.superFocusOnEachUpdate = function superFocusOnEachUpdate() {
    var isFocusInUppy = this.el.contains(document.activeElement); // When focus is lost on the page (== focus is on body for most browsers, or focus is null for IE11)

    var isFocusNowhere = document.activeElement === document.querySelector('body') || document.activeElement === null;
    var isInformerHidden = this.uppy.getState().info.isHidden;
    var isModal = !this.opts.inline;

    if ( // If update is connected to showing the Informer - let the screen reader calmly read it.
    isInformerHidden && ( // If we are in a modal - always superfocus without concern for other elements on the page (user is unlikely to want to interact with the rest of the page)
    isModal || // If we are already inside of Uppy, or
    isFocusInUppy || // If we are not focused on anything BUT we have already, at least once, focused on uppy
    //   1. We focus when isFocusNowhere, because when the element we were focused on disappears (e.g. an overlay), - focus gets lost. If user is typing something somewhere else on the page, - focus won't be 'nowhere'.
    //   2. We only focus when focus is nowhere AND this.ifFocusedOnUppyRecently, to avoid focus jumps if we do something else on the page.
    //   [Practical check] Without '&& this.ifFocusedOnUppyRecently', in Safari, in inline mode, when file is uploading, - navigate via tab to the checkbox, try to press space multiple times. Focus will jump to Uppy.
    isFocusNowhere && this.ifFocusedOnUppyRecently)) {
      this.superFocus(this.el, this.getPluginState().activeOverlayType);
    } else {
      this.superFocus.cancel();
    }
  };

  _proto.afterUpdate = function afterUpdate() {
    this.superFocusOnEachUpdate();
  };

  _proto.render = function render(state) {
    var pluginState = this.getPluginState();
    var files = state.files,
        capabilities = state.capabilities,
        allowNewUpload = state.allowNewUpload; // TODO: move this to Core, to share between Status Bar and Dashboard
    // (and any other plugin that might need it, too)

    var newFiles = Object.keys(files).filter(function (file) {
      return !files[file].progress.uploadStarted;
    });
    var uploadStartedFiles = Object.keys(files).filter(function (file) {
      return files[file].progress.uploadStarted;
    });
    var pausedFiles = Object.keys(files).filter(function (file) {
      return files[file].isPaused;
    });
    var completeFiles = Object.keys(files).filter(function (file) {
      return files[file].progress.uploadComplete;
    });
    var erroredFiles = Object.keys(files).filter(function (file) {
      return files[file].error;
    });
    var inProgressFiles = Object.keys(files).filter(function (file) {
      return !files[file].progress.uploadComplete && files[file].progress.uploadStarted;
    });
    var inProgressNotPausedFiles = inProgressFiles.filter(function (file) {
      return !files[file].isPaused;
    });
    var processingFiles = Object.keys(files).filter(function (file) {
      return files[file].progress.preprocess || files[file].progress.postprocess;
    });
    var isUploadStarted = uploadStartedFiles.length > 0;
    var isAllComplete = state.totalProgress === 100 && completeFiles.length === Object.keys(files).length && processingFiles.length === 0;
    var isAllErrored = isUploadStarted && erroredFiles.length === uploadStartedFiles.length;
    var isAllPaused = inProgressFiles.length !== 0 && pausedFiles.length === inProgressFiles.length;

    var acquirers = this._getAcquirers(pluginState.targets);

    var progressindicators = this._getProgressIndicators(pluginState.targets);

    return DashboardUI({
      state: state,
      isHidden: pluginState.isHidden,
      files: files,
      newFiles: newFiles,
      uploadStartedFiles: uploadStartedFiles,
      completeFiles: completeFiles,
      erroredFiles: erroredFiles,
      inProgressFiles: inProgressFiles,
      inProgressNotPausedFiles: inProgressNotPausedFiles,
      processingFiles: processingFiles,
      isUploadStarted: isUploadStarted,
      isAllComplete: isAllComplete,
      isAllErrored: isAllErrored,
      isAllPaused: isAllPaused,
      totalFileCount: Object.keys(files).length,
      totalProgress: state.totalProgress,
      allowNewUpload: allowNewUpload,
      acquirers: acquirers,
      activePickerPanel: pluginState.activePickerPanel,
      animateOpenClose: this.opts.animateOpenClose,
      isClosing: pluginState.isClosing,
      getPlugin: this.uppy.getPlugin,
      progressindicators: progressindicators,
      autoProceed: this.uppy.opts.autoProceed,
      id: this.id,
      closeModal: this.requestCloseModal,
      handleClickOutside: this.handleClickOutside,
      handleInputChange: this.handleInputChange,
      handlePaste: this.handlePaste,
      inline: this.opts.inline,
      showPanel: this.showPanel,
      hideAllPanels: this.hideAllPanels,
      log: this.uppy.log,
      i18n: this.i18n,
      i18nArray: this.i18nArray,
      addFile: this.uppy.addFile,
      removeFile: this.uppy.removeFile,
      info: this.uppy.info,
      note: this.opts.note,
      metaFields: pluginState.metaFields,
      resumableUploads: capabilities.resumableUploads || false,
      individualCancellation: capabilities.individualCancellation,
      pauseUpload: this.uppy.pauseResume,
      retryUpload: this.uppy.retryUpload,
      cancelUpload: this.cancelUpload,
      cancelAll: this.uppy.cancelAll,
      fileCardFor: pluginState.fileCardFor,
      toggleFileCard: this.toggleFileCard,
      toggleAddFilesPanel: this.toggleAddFilesPanel,
      showAddFilesPanel: pluginState.showAddFilesPanel,
      saveFileCard: this.saveFileCard,
      width: this.opts.width,
      height: this.opts.height,
      showLinkToFileUploadResult: this.opts.showLinkToFileUploadResult,
      proudlyDisplayPoweredByUppy: this.opts.proudlyDisplayPoweredByUppy,
      containerWidth: pluginState.containerWidth,
      areInsidesReadyToBeVisible: pluginState.areInsidesReadyToBeVisible,
      isTargetDOMEl: this.isTargetDOMEl,
      parentElement: this.el,
      allowedFileTypes: this.uppy.opts.restrictions.allowedFileTypes,
      maxNumberOfFiles: this.uppy.opts.restrictions.maxNumberOfFiles,
      showSelectedFiles: this.opts.showSelectedFiles,
      // drag props
      isDraggingOver: pluginState.isDraggingOver,
      handleDragOver: this.handleDragOver,
      handleDragLeave: this.handleDragLeave,
      handleDrop: this.handleDrop
    });
  };

  _proto.discoverProviderPlugins = function discoverProviderPlugins() {
    var _this11 = this;

    this.uppy.iteratePlugins(function (plugin) {
      if (plugin && !plugin.target && plugin.opts && plugin.opts.target === _this11.constructor) {
        _this11.addTarget(plugin);
      }
    });
  };

  _proto.install = function install() {
    var _this12 = this;

    // Set default state for Dashboard
    this.setPluginState({
      isHidden: true,
      fileCardFor: null,
      activeOverlayType: null,
      showAddFilesPanel: false,
      activePickerPanel: false,
      metaFields: this.opts.metaFields,
      targets: [],
      // We'll make them visible once .containerWidth is determined
      areInsidesReadyToBeVisible: false,
      isDraggingOver: false
    });
    var _this$opts = this.opts,
        inline = _this$opts.inline,
        closeAfterFinish = _this$opts.closeAfterFinish;

    if (inline && closeAfterFinish) {
      throw new Error('[Dashboard] `closeAfterFinish: true` cannot be used on an inline Dashboard, because an inline Dashboard cannot be closed at all. Either set `inline: false`, or disable the `closeAfterFinish` option.');
    }

    var allowMultipleUploads = this.uppy.opts.allowMultipleUploads;

    if (allowMultipleUploads && closeAfterFinish) {
      this.uppy.log('[Dashboard] When using `closeAfterFinish`, we recommended setting the `allowMultipleUploads` option to `false` in the Uppy constructor. See https://uppy.io/docs/uppy/#allowMultipleUploads-true', 'warning');
    }

    var target = this.opts.target;

    if (target) {
      this.mount(target, this);
    }

    var plugins = this.opts.plugins || [];
    plugins.forEach(function (pluginID) {
      var plugin = _this12.uppy.getPlugin(pluginID);

      if (plugin) {
        plugin.mount(_this12, plugin);
      }
    });

    if (!this.opts.disableStatusBar) {
      this.uppy.use(StatusBar, {
        id: this.id + ":StatusBar",
        target: this,
        hideUploadButton: this.opts.hideUploadButton,
        hideRetryButton: this.opts.hideRetryButton,
        hidePauseResumeButton: this.opts.hidePauseResumeButton,
        hideCancelButton: this.opts.hideCancelButton,
        showProgressDetails: this.opts.showProgressDetails,
        hideAfterFinish: this.opts.hideProgressAfterFinish,
        locale: this.opts.locale
      });
    }

    if (!this.opts.disableInformer) {
      this.uppy.use(Informer, {
        id: this.id + ":Informer",
        target: this
      });
    }

    if (!this.opts.disableThumbnailGenerator) {
      this.uppy.use(ThumbnailGenerator, {
        id: this.id + ":ThumbnailGenerator",
        thumbnailWidth: this.opts.thumbnailWidth,
        waitForThumbnailsBeforeUpload: this.opts.waitForThumbnailsBeforeUpload
      });
    }

    this.discoverProviderPlugins();
    this.initEvents();
  };

  _proto.uninstall = function uninstall() {
    var _this13 = this;

    if (!this.opts.disableInformer) {
      var informer = this.uppy.getPlugin(this.id + ":Informer"); // Checking if this plugin exists, in case it was removed by uppy-core
      // before the Dashboard was.

      if (informer) this.uppy.removePlugin(informer);
    }

    if (!this.opts.disableStatusBar) {
      var statusBar = this.uppy.getPlugin(this.id + ":StatusBar");
      if (statusBar) this.uppy.removePlugin(statusBar);
    }

    if (!this.opts.disableThumbnailGenerator) {
      var thumbnail = this.uppy.getPlugin(this.id + ":ThumbnailGenerator");
      if (thumbnail) this.uppy.removePlugin(thumbnail);
    }

    var plugins = this.opts.plugins || [];
    plugins.forEach(function (pluginID) {
      var plugin = _this13.uppy.getPlugin(pluginID);

      if (plugin) plugin.unmount();
    });
    this.unmount();
    this.removeEvents();
  };

  return Dashboard;
}(Plugin), _class.VERSION = "1.5.0", _temp);