function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var shallowEqual = require('is-shallow-equal');

var _require = require('preact'),
    h = _require.h,
    Component = _require.Component;
/**
 * Higher order component that doesn't rerender an element if its props didn't change.
 */


module.exports = function pure(Inner) {
  return (
    /*#__PURE__*/
    function (_Component) {
      _inheritsLoose(Pure, _Component);

      function Pure() {
        return _Component.apply(this, arguments) || this;
      }

      var _proto = Pure.prototype;

      _proto.shouldComponentUpdate = function shouldComponentUpdate(nextProps) {
        return !shallowEqual(this.props, nextProps);
      };

      _proto.render = function render() {
        // we have to clone this or Preact mutates it:
        // https://github.com/preactjs/preact/issues/836
        // TODO can be removed if we upgrade to Preact X
        var props = _extends({}, this.props);

        return h(Inner, props);
      };

      return Pure;
    }(Component)
  );
};