import { UIPlugin, type UIPluginOptions, type UnknownPlugin, type Uppy, type State } from '@uppy/core';
import type { ComponentChild, VNode } from 'preact';
import type { DefinePluginOpts } from '@uppy/core/lib/BasePlugin.js';
import type { Body, Meta, UppyFile } from '@uppy/utils/lib/UppyFile';
import { defaultPickerIcon } from '@uppy/provider-views';
type GenericEventCallback = () => void;
export type DashboardFileEditStartCallback<M extends Meta, B extends Body> = (file?: UppyFile<M, B>) => void;
export type DashboardFileEditCompleteCallback<M extends Meta, B extends Body> = (file?: UppyFile<M, B>) => void;
export type DashboardShowPlanelCallback = (id: string) => void;
declare module '@uppy/core' {
    interface UppyEventMap<M extends Meta, B extends Body> {
        'dashboard:modal-open': GenericEventCallback;
        'dashboard:modal-closed': GenericEventCallback;
        'dashboard:show-panel': DashboardShowPlanelCallback;
        'dashboard:file-edit-start': DashboardFileEditStartCallback<M, B>;
        'dashboard:file-edit-complete': DashboardFileEditCompleteCallback<M, B>;
        'dashboard:close-panel': (id: string | undefined) => void;
        'restore-canceled': GenericEventCallback;
    }
}
type FieldRenderOptions = {
    value: string;
    onChange: (newVal: string) => void;
    fieldCSSClasses: {
        text: string;
    };
    required: boolean;
    form: string;
};
type PreactRender = (node: any, params: Record<string, unknown> | null, ...children: any[]) => VNode<any>;
interface MetaField {
    id: string;
    name: string;
    placeholder?: string;
    render?: (field: FieldRenderOptions, h: PreactRender) => VNode<any>;
}
interface Target {
    id: string;
    name: string;
    type: string;
}
export interface TargetWithRender extends Target {
    icon: () => ComponentChild;
    render: () => ComponentChild;
}
export interface DashboardState<M extends Meta, B extends Body> {
    targets: Target[];
    activePickerPanel: Target | undefined;
    showAddFilesPanel: boolean;
    activeOverlayType: string | null;
    fileCardFor: string | null;
    showFileEditor: boolean;
    metaFields?: MetaField[] | ((file: UppyFile<M, B>) => MetaField[]);
    isHidden: boolean;
    isClosing: boolean;
    containerWidth: number;
    containerHeight: number;
    areInsidesReadyToBeVisible: boolean;
    isDraggingOver: boolean;
    [key: string]: unknown;
}
export interface DashboardModalOptions {
    inline?: false;
    animateOpenClose?: boolean;
    browserBackButtonClose?: boolean;
    closeAfterFinish?: boolean;
    closeModalOnClickOutside?: boolean;
    disablePageScrollWhenModalOpen?: boolean;
}
export interface DashboardInlineOptions {
    inline: true;
    height?: string | number;
    width?: string | number;
}
interface DashboardMiscOptions<M extends Meta, B extends Body> extends UIPluginOptions {
    autoOpen?: 'metaEditor' | 'imageEditor' | null;
    defaultPickerIcon?: typeof defaultPickerIcon;
    disabled?: boolean;
    disableInformer?: boolean;
    disableLocalFiles?: boolean;
    disableStatusBar?: boolean;
    disableThumbnailGenerator?: boolean;
    doneButtonHandler?: null | (() => void);
    fileManagerSelectionType?: 'files' | 'folders' | 'both';
    hideCancelButton?: boolean;
    hidePauseResumeButton?: boolean;
    hideProgressAfterFinish?: boolean;
    hideRetryButton?: boolean;
    hideUploadButton?: boolean;
    metaFields?: MetaField[] | ((file: UppyFile<M, B>) => MetaField[]);
    nativeCameraFacingMode?: 'user' | 'environment' | '';
    note?: string | null;
    onDragLeave?: (event: DragEvent) => void;
    onDragOver?: (event: DragEvent) => void;
    onDrop?: (event: DragEvent) => void;
    onRequestCloseModal?: () => void;
    plugins?: string[];
    proudlyDisplayPoweredByUppy?: boolean;
    showLinkToFileUploadResult?: boolean;
    showNativePhotoCameraButton?: boolean;
    showNativeVideoCameraButton?: boolean;
    showProgressDetails?: boolean;
    showRemoveButtonAfterComplete?: boolean;
    showSelectedFiles?: boolean;
    singleFileFullScreen?: boolean;
    theme?: 'auto' | 'dark' | 'light';
    thumbnailHeight?: number;
    thumbnailType?: string;
    thumbnailWidth?: number;
    trigger?: string | Element | null;
    waitForThumbnailsBeforeUpload?: boolean;
}
export type DashboardOptions<M extends Meta, B extends Body> = DashboardMiscOptions<M, B> & (DashboardModalOptions | DashboardInlineOptions);
declare const defaultOptions: {
    target: string;
    metaFields: never[];
    thumbnailWidth: number;
    thumbnailType: string;
    waitForThumbnailsBeforeUpload: false;
    defaultPickerIcon: typeof defaultPickerIcon;
    showLinkToFileUploadResult: false;
    showProgressDetails: false;
    hideUploadButton: false;
    hideCancelButton: false;
    hideRetryButton: false;
    hidePauseResumeButton: false;
    hideProgressAfterFinish: false;
    note: null;
    singleFileFullScreen: true;
    disableStatusBar: false;
    disableInformer: false;
    disableThumbnailGenerator: false;
    fileManagerSelectionType: "files";
    proudlyDisplayPoweredByUppy: true;
    showSelectedFiles: true;
    showRemoveButtonAfterComplete: false;
    showNativePhotoCameraButton: false;
    showNativeVideoCameraButton: false;
    theme: "light";
    autoOpen: null;
    disabled: false;
    disableLocalFiles: false;
    nativeCameraFacingMode: "";
    onDragLeave: () => void;
    onDragOver: () => void;
    onDrop: () => void;
    plugins: never[];
    doneButtonHandler: any;
    onRequestCloseModal: any;
    inline: boolean;
    animateOpenClose: true;
    browserBackButtonClose: false;
    closeAfterFinish: false;
    closeModalOnClickOutside: false;
    disablePageScrollWhenModalOpen: true;
    trigger: null;
    width: number;
    height: number;
};
/**
 * Dashboard UI with previews, metadata editing, tabs for various services and more
 */
export default class Dashboard<M extends Meta, B extends Body> extends UIPlugin<DefinePluginOpts<DashboardMiscOptions<M, B> & Omit<DashboardInlineOptions, 'inline'> & Omit<DashboardModalOptions, 'inline'> & {
    inline?: boolean;
}, keyof typeof defaultOptions>, M, B, DashboardState<M, B>> {
    #private;
    static VERSION: any;
    private modalName;
    private superFocus;
    private ifFocusedOnUppyRecently;
    private dashboardIsDisabled;
    private savedScrollPosition;
    private savedActiveElement;
    private resizeObserver;
    private darkModeMediaQuery;
    private makeDashboardInsidesVisibleAnywayTimeout;
    constructor(uppy: Uppy<M, B>, opts?: DashboardOptions<M, B>);
    removeTarget: (plugin: UnknownPlugin<M, B>) => void;
    addTarget: (plugin: UnknownPlugin<M, B>) => HTMLElement | null;
    hideAllPanels: () => void;
    showPanel: (id: string) => void;
    private canEditFile;
    openFileEditor: (file: UppyFile<M, B>) => void;
    closeFileEditor: () => void;
    saveFileEditor: () => void;
    openModal: () => Promise<void>;
    closeModal: (opts?: {
        manualClose: boolean;
    }) => void | Promise<void>;
    isModalOpen: () => boolean;
    private requestCloseModal;
    setDarkModeCapability: (isDarkModeOn: boolean) => void;
    private handleSystemDarkModeChange;
    private toggleFileCard;
    private toggleAddFilesPanel;
    addFiles: (files: File[]) => void;
    private startListeningToResize;
    private stopListeningToResize;
    private recordIfFocusedOnUppyRecently;
    private disableInteractiveElements;
    private updateBrowserHistory;
    private handlePopState;
    private handleKeyDownInModal;
    private handleClickOutside;
    private handlePaste;
    private handleInputChange;
    private handleDragOver;
    private handleDragLeave;
    private handleDrop;
    private handleRequestThumbnail;
    /**
     * We cancel thumbnail requests when a file item component unmounts to avoid
     * clogging up the queue when the user scrolls past many elements.
     */
    private handleCancelThumbnail;
    private handleKeyDownInInline;
    private handlePasteOnBody;
    private handleComplete;
    private handleCancelRestore;
    initEvents: () => void;
    removeEvents: () => void;
    private superFocusOnEachUpdate;
    readonly afterUpdate: () => void;
    saveFileCard: (meta: M, fileID: string) => void;
    render: (state: State<M, B>) => import("preact").JSX.Element;
    setOptions(opts: Partial<DashboardOptions<M, B>>): void;
    install: () => void;
    uninstall: () => void;
}
export {};
//# sourceMappingURL=Dashboard.d.ts.map