import { h } from 'preact';
import type { Body, Meta, UppyFile } from '@uppy/utils/lib/UppyFile';
import type { State, UIPluginOptions, Uppy } from '@uppy/core';
import type { I18n } from '@uppy/utils/lib/Translator';
import type Translator from '@uppy/utils/lib/Translator';
import type { TargetedEvent } from 'preact/compat';
import type { DashboardState, TargetWithRender } from '../Dashboard';
type DashboardUIProps<M extends Meta, B extends Body> = {
    state: State<M, B>;
    isHidden: boolean;
    files: State<M, B>['files'];
    newFiles: UppyFile<M, B>[];
    uploadStartedFiles: UppyFile<M, B>[];
    completeFiles: UppyFile<M, B>[];
    erroredFiles: UppyFile<M, B>[];
    inProgressFiles: UppyFile<M, B>[];
    inProgressNotPausedFiles: UppyFile<M, B>[];
    processingFiles: UppyFile<M, B>[];
    isUploadStarted: boolean;
    isAllComplete: boolean;
    isAllPaused: boolean;
    totalFileCount: number;
    totalProgress: number;
    allowNewUpload: boolean;
    acquirers: TargetWithRender[];
    theme: string;
    disabled: boolean;
    disableLocalFiles: boolean;
    direction: UIPluginOptions['direction'];
    activePickerPanel: DashboardState<M, B>['activePickerPanel'];
    showFileEditor: boolean;
    saveFileEditor: () => void;
    closeFileEditor: () => void;
    disableInteractiveElements: (disable: boolean) => void;
    animateOpenClose: boolean;
    isClosing: boolean;
    progressindicators: TargetWithRender[];
    editors: TargetWithRender[];
    autoProceed: boolean;
    id: string;
    closeModal: () => void;
    handleClickOutside: () => void;
    handleInputChange: (event: TargetedEvent<HTMLInputElement, Event>) => void;
    handlePaste: (event: ClipboardEvent) => void;
    inline: boolean;
    showPanel: (id: string) => void;
    hideAllPanels: () => void;
    i18n: I18n;
    i18nArray: Translator['translateArray'];
    uppy: Uppy<M, B>;
    note: string | null;
    recoveredState: State<M, B>['recoveredState'];
    metaFields: DashboardState<M, B>['metaFields'];
    resumableUploads: boolean;
    individualCancellation: boolean;
    isMobileDevice?: boolean;
    fileCardFor: string | null;
    toggleFileCard: (show: boolean, fileID: string) => void;
    toggleAddFilesPanel: (show: boolean) => void;
    showAddFilesPanel: boolean;
    saveFileCard: (meta: M, fileID: string) => void;
    openFileEditor: (file: UppyFile<M, B>) => void;
    canEditFile: (file: UppyFile<M, B>) => boolean;
    width: string | number;
    height: string | number;
    showLinkToFileUploadResult: boolean;
    fileManagerSelectionType: string;
    proudlyDisplayPoweredByUppy: boolean;
    hideCancelButton: boolean;
    hideRetryButton: boolean;
    hidePauseResumeButton: boolean;
    showRemoveButtonAfterComplete: boolean;
    containerWidth: number;
    containerHeight: number;
    areInsidesReadyToBeVisible: boolean;
    parentElement: HTMLElement | null;
    allowedFileTypes: string[] | null;
    maxNumberOfFiles: number | null;
    requiredMetaFields: any;
    showSelectedFiles: boolean;
    showNativePhotoCameraButton: boolean;
    showNativeVideoCameraButton: boolean;
    nativeCameraFacingMode: 'user' | 'environment' | '';
    singleFileFullScreen: boolean;
    handleCancelRestore: () => void;
    handleRequestThumbnail: (file: UppyFile<M, B>) => void;
    handleCancelThumbnail: (file: UppyFile<M, B>) => void;
    isDraggingOver: boolean;
    handleDragOver: (event: DragEvent) => void;
    handleDragLeave: (event: DragEvent) => void;
    handleDrop: (event: DragEvent) => void;
};
export default function Dashboard<M extends Meta, B extends Body>(props: DashboardUIProps<M, B>): h.JSX.Element;
export {};
//# sourceMappingURL=Dashboard.d.ts.map