import { type VNode, type ComponentChildren } from 'preact';
/**
 * Vertical slide transition.
 *
 * This can take a _single_ child component, which _must_ accept a `className` prop.
 *
 * Currently this is specific to the `uppy-transition-slideDownUp` transition,
 * but it should be simple to extend this for any type of single-element
 * transition by setting the CSS name and duration as props.
 */
declare function Slide({ children }: {
    children: ComponentChildren;
}): VNode<{
    className?: string | undefined;
}> | null;
export default Slide;
//# sourceMappingURL=Slide.d.ts.map