import type { Body, DefinePluginOpts, Meta, PluginOpts, Uppy } from '@uppy/core';
import { BasePlugin } from '@uppy/core';
export interface DropTargetOptions extends PluginOpts {
    target?: HTMLElement | string | null;
    onDrop?: (event: DragEvent) => void;
    onDragOver?: (event: DragEvent) => void;
    onDragLeave?: (event: DragEvent) => void;
}
declare const defaultOpts: {
    target: null;
};
/**
 * Drop Target plugin
 *
 */
export default class DropTarget<M extends Meta, B extends Body> extends BasePlugin<DefinePluginOpts<DropTargetOptions, keyof typeof defaultOpts>, M, B> {
    static VERSION: string;
    private nodes?;
    constructor(uppy: Uppy<M, B>, opts?: DropTargetOptions);
    addFiles: (files: Array<File>) => void;
    handleDrop: (event: DragEvent) => Promise<void>;
    handleDragOver: (event: DragEvent) => void;
    handleDragLeave: (event: DragEvent) => void;
    addListeners: () => void;
    removeListeners: () => void;
    install(): void;
    uninstall(): void;
}
export {};
//# sourceMappingURL=index.d.ts.map