function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('@uppy/core'),
    Plugin = _require.Plugin;

var _require2 = require('@uppy/companion-client'),
    Provider = _require2.Provider;

var ProviderViews = require('@uppy/provider-views');

var _require3 = require('preact'),
    h = _require3.h;

module.exports = function (_Plugin) {
  _inherits(Dropbox, _Plugin);

  function Dropbox(uppy, opts) {
    _classCallCheck(this, Dropbox);

    var _this = _possibleConstructorReturn(this, _Plugin.call(this, uppy, opts));

    _this.id = _this.opts.id || 'Dropbox';
    Provider.initPlugin(_this, opts);
    _this.title = _this.opts.title || 'Dropbox';
    _this.icon = function () {
      return h(
        'svg',
        { 'aria-hidden': 'true', fill: '#0060ff', width: '128', height: '118', viewBox: '0 0 128 118' },
        h('path', { d: 'M38.145.777L1.108 24.96l25.608 20.507 37.344-23.06z' }),
        h('path', { d: 'M1.108 65.975l37.037 24.183L64.06 68.525l-37.343-23.06zM64.06 68.525l25.917 21.633 37.036-24.183-25.61-20.51z' }),
        h('path', { d: 'M127.014 24.96L89.977.776 64.06 22.407l37.345 23.06zM64.136 73.18l-25.99 21.567-11.122-7.262v8.142l37.112 22.256 37.114-22.256v-8.142l-11.12 7.262z' })
      );
    };

    _this[_this.id] = new Provider(uppy, {
      serverUrl: _this.opts.serverUrl,
      serverHeaders: _this.opts.serverHeaders,
      provider: 'dropbox'
    });

    _this.onAuth = _this.onAuth.bind(_this);
    _this.render = _this.render.bind(_this);
    return _this;
  }

  Dropbox.prototype.install = function install() {
    this.view = new ProviderViews(this);
    // Set default state for Dropbox
    this.setPluginState({
      authenticated: false,
      files: [],
      folders: [],
      directories: [],
      activeRow: -1,
      filterInput: '',
      isSearchVisible: false
    });

    var target = this.opts.target;
    if (target) {
      this.mount(target, this);
    }
  };

  Dropbox.prototype.uninstall = function uninstall() {
    this.view.tearDown();
    this.unmount();
  };

  Dropbox.prototype.onAuth = function onAuth(authenticated) {
    this.setPluginState({ authenticated: authenticated });
    if (authenticated) {
      this.view.getFolder();
    }
  };

  Dropbox.prototype.render = function render(state) {
    return this.view.render(state);
  };

  return Dropbox;
}(Plugin);