import { Provider, tokenStorage, type CompanionPluginOptions } from '@uppy/companion-client';
import { UIPlugin, Uppy } from '@uppy/core';
import { ProviderViews } from '@uppy/provider-views';
import { h, type ComponentChild } from 'preact';
import type { UppyFile, Body, Meta } from '@uppy/utils/lib/UppyFile';
import type { UnknownProviderPluginState } from '@uppy/core/lib/Uppy.js';
export type DropboxOptions = CompanionPluginOptions;
export default class Dropbox<M extends Meta, B extends Body> extends UIPlugin<DropboxOptions, M, B, UnknownProviderPluginState> {
    static VERSION: any;
    icon: () => h.JSX.Element;
    provider: Provider<M, B>;
    view: ProviderViews<M, B>;
    storage: typeof tokenStorage;
    files: UppyFile<M, B>[];
    rootFolderId: string | null;
    constructor(uppy: Uppy<M, B>, opts: DropboxOptions);
    install(): void;
    uninstall(): void;
    render(state: unknown): ComponentChild;
}
//# sourceMappingURL=Dropbox.d.ts.map