import { Provider, type CompanionPluginOptions } from '@uppy/companion-client';
import { UIPlugin, Uppy } from '@uppy/core';
import { ProviderViews } from '@uppy/provider-views';
import { h, type ComponentChild } from 'preact';
import type { LocaleStrings } from '@uppy/utils/lib/Translator';
import type { UppyFile, Body, Meta, AsyncStore, UnknownProviderPlugin, UnknownProviderPluginState } from '@uppy/core';
import locale from './locale.js';
export type DropboxOptions = CompanionPluginOptions & {
    locale?: LocaleStrings<typeof locale>;
};
export default class Dropbox<M extends Meta, B extends Body> extends UIPlugin<DropboxOptions, M, B, UnknownProviderPluginState> implements UnknownProviderPlugin<M, B> {
    static VERSION: any;
    icon: () => h.JSX.Element;
    provider: Provider<M, B>;
    view: ProviderViews<M, B>;
    storage: AsyncStore;
    files: UppyFile<M, B>[];
    rootFolderId: string | null;
    constructor(uppy: Uppy<M, B>, opts: DropboxOptions);
    install(): void;
    uninstall(): void;
    render(state: unknown): ComponentChild;
}
//# sourceMappingURL=Dropbox.d.ts.map