import { Provider, tokenStorage, type CompanionPluginOptions } from '@uppy/companion-client';
import { UIPlugin, Uppy } from '@uppy/core';
import { ProviderViews } from '@uppy/provider-views';
import { h, type ComponentChild } from 'preact';
import type { UppyFile, Body, Meta } from '@uppy/utils/lib/UppyFile';
import type { UnknownProviderPluginState } from '@uppy/core/lib/Uppy.js';
export type FacebookOptions = CompanionPluginOptions;
export default class Facebook<M extends Meta, B extends Body> extends UIPlugin<FacebookOptions, M, B, UnknownProviderPluginState> {
    static VERSION: any;
    icon: () => h.JSX.Element;
    provider: Provider<M, B>;
    view: ProviderViews<M, B>;
    storage: typeof tokenStorage;
    files: UppyFile<M, B>[];
    rootFolderId: string | null;
    constructor(uppy: Uppy<M, B>, opts: FacebookOptions);
    install(): void;
    uninstall(): void;
    render(state: unknown): ComponentChild;
}
//# sourceMappingURL=Facebook.d.ts.map