import type { Body, DefinePluginOpts, Meta, UIPluginOptions, Uppy, UppyEventMap } from '@uppy/core';
import { BasePlugin } from '@uppy/core';
type Result<M extends Meta, B extends Body> = Parameters<UppyEventMap<M, B>['complete']>[0];
export interface FormOptions extends UIPluginOptions {
    resultName?: string;
    getMetaFromForm?: boolean;
    addResultToForm?: boolean;
    submitOnSuccess?: boolean;
    triggerUploadOnSubmit?: boolean;
}
declare const defaultOptions: {
    resultName: string;
    getMetaFromForm: boolean;
    addResultToForm: boolean;
    submitOnSuccess: boolean;
    triggerUploadOnSubmit: boolean;
};
type Opts = DefinePluginOpts<FormOptions, keyof typeof defaultOptions>;
export default class Form<M extends Meta, B extends Body> extends BasePlugin<Opts, M, B> {
    #private;
    static VERSION: string;
    constructor(uppy: Uppy<M, B>, opts?: FormOptions);
    handleUploadStart(): void;
    handleSuccess(result: Result<M, B>): void;
    handleFormSubmit(ev: Event): void;
    addResultToForm(result: Result<M, B>): void;
    getMetaFromForm(): void;
    install(): void;
    uninstall(): void;
}
export {};
//# sourceMappingURL=index.d.ts.map